/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryDecision$ShouldRetry$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RetryableTransactionBatch;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionBatch;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionBatch$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionResult;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryLogic;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryPolicy;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionStatus;
import org.neo4j.kernel.impl.util.collection.EagerBuffer;
import org.neo4j.memory.MemoryTracker;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055b!B\u0006\r\u0003\u0003Y\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0005B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\t\u0001B\u0001B\u0003%a\tC\u0003J\u0001\u0011\u0005!\nC\u0003R\u0001\u0019E!\u000bC\u0003b\u0001\u0019E!\rC\u0003~\u0001\u0019Ea\u0010C\u0004\u0002$\u0001!)&!\n\u0003=\u0005\u00137\u000f\u001e:bGR\u001cVM]5bYR\u0013\u0018M\\:bGRLwN\\:QSB,'BA\u0007\u000f\u0003\u0015\u0001\u0018\u000e]3t\u0015\ty\u0001#A\u0006j]R,'\u000f\u001d:fi\u0016$'BA\t\u0013\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0005\u000b\u0002\u0011%tG/\u001a:oC2T!!\u0006\f\u0002\r\rL\b\u000f[3s\u0015\t9\u0002$A\u0003oK>$$NC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001e=5\tA\"\u0003\u0002 \u0019\tq\u0001+\u001b9f/&$\bnU8ve\u000e,\u0017AB:pkJ\u001cW\r\u0005\u0002\u001eE%\u00111\u0005\u0004\u0002\u0005!&\u0004X-A\u0003j]:,'/A\u0005cCR\u001c\u0007nU5{KB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,\u001d\u0005A1m\\7nC:$7/\u0003\u0002.Q\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002!=tWI\u001d:pe\n+\u0007.\u0019<j_V\u0014\bC\u0001\u0019C\u001d\t\ttH\u0004\u00023{9\u00111\u0007\u0010\b\u0003imr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005aR\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003}I\t1!Y:u\u0013\t\u0001\u0015)\u0001\u0007Tk\n\fX/\u001a:z\u0007\u0006dGN\u0003\u0002?%%\u00111\t\u0012\u0002\u001f\u0013:$&/\u00198tC\u000e$\u0018n\u001c8t\u001f:,%O]8s\u0005\u0016D\u0017M^5pkJT!\u0001Q!\u0002\u0017I,GO]=Q_2L7-\u001f\t\u0003;\u001dK!\u0001\u0013\u0007\u0003-Q\u0013\u0018M\\:bGRLwN\u001c*fiJL\bk\u001c7jGf\fa\u0001P5oSRtDCB&M\u001b:{\u0005\u000b\u0005\u0002\u001e\u0001!)\u0001E\u0002a\u0001C!)AE\u0002a\u0001C!)QE\u0002a\u0001M!)aF\u0002a\u0001_!)QI\u0002a\u0001\r\u0006Qq/\u001b;i'R\fG/^:\u0015\u0007MSF\fE\u0002U+^k\u0011\u0001E\u0005\u0003-B\u0011qb\u00117pg&tw-\u0013;fe\u0006$xN\u001d\t\u0003)bK!!\u0017\t\u0003\u0013\rK\b\u000f[3s%><\b\"B.\b\u0001\u0004\u0019\u0016AB8viB,H\u000fC\u0003^\u000f\u0001\u0007a,\u0001\u0004ti\u0006$Xo\u001d\t\u0003;}K!\u0001\u0019\u0007\u0003#Q\u0013\u0018M\\:bGRLwN\\*uCR,8/A\u0005hKR\u0014Vm];miR)1MZ6qkB\u0011Q\u0004Z\u0005\u0003K2\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0011\u00159\u0007\u00021\u0001i\u00035IgN\\3s!&\u0004X-\u00138UqB\u0011Q$[\u0005\u0003U2\u0011a\u0003\u0016:b]N\f7\r^5p]BK\u0007/Z,sCB\u0004XM\u001d\u0005\u0006Y\"\u0001\r!\\\u0001\u0006gR\fG/\u001a\t\u0003;9L!a\u001c\u0007\u0003\u0015E+XM]=Ti\u0006$X\rC\u0003r\u0011\u0001\u0007!/A\u0003cCR\u001c\u0007\u000e\u0005\u0002\u001eg&\u0011A\u000f\u0004\u0002\u0011)J\fgn]1di&|gNQ1uG\"DQA\u001e\u0005A\u0002]\fQ\"\\3n_JLHK]1dW\u0016\u0014\bC\u0001=|\u001b\u0005I(B\u0001>\u0017\u0003\u0019iW-\\8ss&\u0011A0\u001f\u0002\u000e\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0002\u001bA\u0014x\u000eZ;dK>+H\u000f];u)!\u0019v0a\u0007\u0002 \u0005\u0005\u0002bBA\u0001\u0013\u0001\u0007\u00111A\u0001\fK\u0006<WM\u001d\"vM\u001a,'\u000fE\u0003\u0002\u0006\u0005]q+\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0005\u0003\u001b\ty!\u0001\u0003vi&d'\u0002BA\t\u0003'\tA![7qY*\u0019\u0011Q\u0003\f\u0002\r-,'O\\3m\u0013\u0011\tI\"a\u0002\u0003\u0017\u0015\u000bw-\u001a:Ck\u001a4WM\u001d\u0005\u0007\u0003;I\u0001\u0019A2\u0002\rI,7/\u001e7u\u0011\u0015\t\u0018\u00021\u0001s\u0011\u0015a\u0017\u00021\u0001n\u0003UIg\u000e^3s]\u0006d7I]3bi\u0016\u0014Vm];miN$RaUA\u0014\u0003WAa!!\u000b\u000b\u0001\u0004\u0019\u0016!B5oaV$\b\"\u00027\u000b\u0001\u0004i\u0007")
public abstract class AbstractSerialTransactionsPipe
extends PipeWithSource {
    private final Pipe inner;
    private final Expression batchSize;
    private final SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour;
    private final TransactionRetryPolicy retryPolicy;

    public abstract ClosingIterator<CypherRow> withStatus(ClosingIterator<CypherRow> var1, TransactionStatus var2);

    public abstract TransactionResult getResult(TransactionPipeWrapper var1, QueryState var2, TransactionBatch var3, MemoryTracker var4);

    public abstract ClosingIterator<CypherRow> produceOutput(EagerBuffer<CypherRow> var1, TransactionResult var2, TransactionBatch var3, QueryState var4);

    @Override
    public final ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        Option<TransactionRetryLogic> retryLogic = TransactionPipeWrapper$.MODULE$.createRetryLogic(this.onErrorBehaviour, this.retryPolicy, state);
        TransactionPipeWrapper innerPipeInTx = TransactionPipeWrapper$.MODULE$.apply(this.onErrorBehaviour, this.id(), this.inner, false, retryLogic);
        long batchSizeLong = TransactionPipeWrapper$.MODULE$.evaluateBatchSize(this.batchSize, state);
        MemoryTracker memoryTracker = state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.id());
        return ClosingIterator$.MODULE$.MemoryTrackingClosingIterator(input).eagerGrouped(batchSizeLong, memoryTracker).flatMap((Function1 & Serializable)eagerBuffer -> {
            TransactionResult transactionResult;
            TransactionBatch batch = TransactionBatch$.MODULE$.apply((EagerBuffer<CypherRow>)eagerBuffer);
            Option option = retryLogic;
            if (option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic value = (TransactionRetryLogic)some.value();
                transactionResult = this.executeWithRetry$1(batch, value, innerPipeInTx, state, memoryTracker);
            } else if (None$.MODULE$.equals(option)) {
                transactionResult = this.runBatch$1(batch, innerPipeInTx, state, memoryTracker);
            } else {
                throw new MatchError((Object)option);
            }
            TransactionResult innerResult = transactionResult;
            return this.produceOutput((EagerBuffer<CypherRow>)eagerBuffer, innerResult, batch, state);
        });
    }

    private final TransactionResult runBatch$1(TransactionBatch batch, TransactionPipeWrapper innerPipeInTx$1, QueryState state$1, MemoryTracker memoryTracker$1) {
        TransactionResult result;
        block0: {
            result = this.getResult(innerPipeInTx$1, state$1, batch, memoryTracker$1);
            QueryStatistics statistics = result.status().queryStatistics();
            if (statistics == null) break block0;
            state$1.query().addStatistics(statistics);
        }
        return result;
    }

    private final TransactionResult executeWithRetry$1(TransactionBatch batch, TransactionRetryLogic retryLogic, TransactionPipeWrapper innerPipeInTx$1, QueryState state$1, MemoryTracker memoryTracker$1) {
        TransactionStatus status;
        TransactionResult result;
        while (true) {
            Tuple2<TransactionStatus, Throwable> tuple2;
            if ((tuple2 = TransactionPipeWrapper$.MODULE$.handleRetry((result = this.runBatch$1(batch, innerPipeInTx$1, state$1, memoryTracker$1)).retryDecision(), result.status(), this.onErrorBehaviour, batch)) == null) {
                throw new MatchError(tuple2);
            }
            TransactionStatus status2 = (TransactionStatus)tuple2._1();
            Throwable throwable = (Throwable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)status2, (Object)throwable);
            status = (TransactionStatus)tuple22._1();
            Throwable throwable2 = (Throwable)tuple22._2();
            if (throwable2 != null) {
                throw throwable2;
            }
            RetryDecision retryDecision = result.retryDecision();
            if (!RetryDecision$ShouldRetry$.MODULE$.equals(retryDecision)) break;
            RetryableTransactionBatch nextBatch = batch.computeNextRetryState(retryLogic);
            LockSupport.parkNanos(nextBatch.nanosUntilRetry());
            batch = nextBatch;
        }
        return result.copy(status, result.copy$default$2(), result.copy$default$3());
    }

    public AbstractSerialTransactionsPipe(Pipe source, Pipe inner, Expression batchSize, SubqueryCall.InTransactionsOnErrorBehaviour onErrorBehaviour, TransactionRetryPolicy retryPolicy) {
        this.inner = inner;
        this.batchSize = batchSize;
        this.onErrorBehaviour = onErrorBehaviour;
        this.retryPolicy = retryPolicy;
        super(source);
    }
}

