/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.TokenContext;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.IsMap$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Property$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.values.KeyToken;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u000f\u001e\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t}\u0001\u0011\t\u0012)A\u0005_!Aq\b\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005H\u0001\tE\t\u0015!\u0003B\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015q\b\u0001\"\u0011\u0000\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003sA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005M\u0003!!A\u0005\u0002\u0005U\u0003\"CA1\u0001\u0005\u0005I\u0011IA2\u0011%\tY\u0007AA\u0001\n\u0003\ti\u0007C\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013QP\u0004\n\u0003\u0003k\u0012\u0011!E\u0001\u0003\u00073\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011Q\u0011\u0005\u0007\u0011Z!\t!!%\t\u0011y4\u0012\u0011!C#\u0003'C\u0001\"\u0014\f\u0002\u0002\u0013\u0005\u0015Q\u0013\u0005\n\u000373\u0012\u0011!CA\u0003;C\u0011\"a,\u0017\u0003\u0003%I!!-\u0003\u0011A\u0013x\u000e]3sifT!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY8n[\u0006tGm\u001d\u0006\u0003E\r\n1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011A%J\u0001\beVtG/[7f\u0015\t1s%\u0001\u0005j]R,'O\\1m\u0015\tA\u0013&\u0001\u0004dsBDWM\u001d\u0006\u0003U-\nQA\\3pi)T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0005\u0001=\u001a\u0014\b\u0005\u00021c5\tQ$\u0003\u00023;\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011AGO\u0005\u0003wU\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fq!\\1q\u000bb\u0004(/F\u00010\u0003!i\u0017\r]#yaJ\u0004\u0013a\u00039s_B,'\u000f^=LKf,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t~\taA^1mk\u0016\u001c\u0018B\u0001$D\u0005!YU-\u001f+pW\u0016t\u0017\u0001\u00049s_B,'\u000f^=LKf\u0004\u0013A\u0002\u001fj]&$h\bF\u0002K\u00172\u0003\"\u0001\r\u0001\t\u000bq*\u0001\u0019A\u0018\t\u000b}*\u0001\u0019A!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007=#&\f\u0005\u0002Q%6\t\u0011K\u0003\u0002ES%\u00111+\u0015\u0002\t\u0003:Lh+\u00197vK\")QK\u0002a\u0001-\u0006\u0019!o\\<\u0011\u0005]CV\"A\u0012\n\u0005e\u001b#a\u0003*fC\u0012\f'\r\\3S_^DQa\u0017\u0004A\u0002q\u000bQa\u001d;bi\u0016\u0004\"!\u00181\u000e\u0003yS!aX\u0011\u0002\u000bAL\u0007/Z:\n\u0005\u0005t&AC)vKJL8\u000b^1uK\u00069!/Z<sSR,GCA\u0018e\u0011\u0015)w\u00011\u0001g\u0003\u00051\u0007\u0003\u0002\u001bh_=J!\u0001[\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001C2iS2$'/\u001a8\u0016\u0003-\u00042\u0001\\80\u001b\u0005i'B\u000186\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a6\u00141aU3r\u0003%\t'oZ;nK:$8/F\u0001t!\r!Hp\f\b\u0003kjt!A^=\u000e\u0003]T!\u0001_\u0017\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014BA>6\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]?\u000b\u0005m,\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0017qA!!\u0002\u0002\bA\u0011a/N\u0005\u0004\u0003\u0013)\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\nU\nAaY8qsR)!*!\u0006\u0002\u0018!9Ah\u0003I\u0001\u0002\u0004y\u0003bB \f!\u0003\u0005\r!Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u00020\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W)\u0014AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)DK\u0002B\u0003?\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005}\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA'!\r!\u0014qJ\u0005\u0004\u0003#*$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA,\u0003;\u00022\u0001NA-\u0013\r\tY&\u000e\u0002\u0004\u0003:L\b\"CA0!\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\r\t\u0006Y\u0006\u001d\u0014qK\u0005\u0004\u0003Sj'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001c\u0002vA\u0019A'!\u001d\n\u0007\u0005MTGA\u0004C_>dW-\u00198\t\u0013\u0005}##!AA\u0002\u0005]\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002p\u0005}\u0004\"CA0)\u0005\u0005\t\u0019AA,\u0003!\u0001&o\u001c9feRL\bC\u0001\u0019\u0017'\u00111\u0012qQ\u001d\u0011\u000f\u0005%\u0015QR\u0018B\u00156\u0011\u00111\u0012\u0006\u0003IUJA!a$\u0002\f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005\rECAA\u001e)\u0015Q\u0015qSAM\u0011\u0015a\u0014\u00041\u00010\u0011\u0015y\u0014\u00041\u0001B\u0003\u001d)h.\u00199qYf$B!a(\u0002,B)A'!)\u0002&&\u0019\u00111U\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014qU\u0018B\u0013\r\tI+\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u00055&$!AA\u0002)\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005M\u0006\u0003BA\u001f\u0003kKA!a.\u0002@\t1qJ\u00196fGR\u0004")
public class Property
extends Expression
implements Product,
scala.Serializable {
    private final Expression mapExpr;
    private final KeyToken propertyKey;

    public static Option<Tuple2<Expression, KeyToken>> unapply(Property property) {
        return Property$.MODULE$.unapply(property);
    }

    public static Function1<Tuple2<Expression, KeyToken>, Property> tupled() {
        return Property$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<KeyToken, Property>> curried() {
        return Property$.MODULE$.curried();
    }

    public Expression mapExpr() {
        return this.mapExpr;
    }

    public KeyToken propertyKey() {
        return this.propertyKey;
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        Value value;
        AnyValue anyValue = this.mapExpr().apply(row, state);
        if (IsNoValue$.MODULE$.unapply(anyValue)) {
            value = Values.NO_VALUE;
        } else if (anyValue instanceof VirtualNodeValue) {
            Value value2;
            VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
            Option<Object> option = this.propertyKey().getOptId((TokenContext)state.query());
            if (None$.MODULE$.equals(option)) {
                value2 = Values.NO_VALUE;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                int propId = BoxesRunTime.unboxToInt((Object)some.value());
                value2 = state.query().nodeOps().getProperty(virtualNodeValue.id(), propId, (Object)state.cursors().nodeCursor(), state.cursors().propertyCursor(), true);
            } else {
                throw new MatchError(option);
            }
            value = value2;
        } else if (anyValue instanceof VirtualRelationshipValue) {
            Value value3;
            VirtualRelationshipValue virtualRelationshipValue = (VirtualRelationshipValue)anyValue;
            Option<Object> option = this.propertyKey().getOptId((TokenContext)state.query());
            if (None$.MODULE$.equals(option)) {
                value3 = Values.NO_VALUE;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                int propId = BoxesRunTime.unboxToInt((Object)some.value());
                value3 = state.query().relationshipOps().getProperty(virtualRelationshipValue.id(), propId, (Object)state.cursors().relationshipScanCursor(), state.cursors().propertyCursor(), true);
            } else {
                throw new MatchError(option);
            }
            value = value3;
        } else {
            Option<Function1<QueryState, MapValue>> option = IsMap$.MODULE$.unapply(anyValue);
            if (!option.isEmpty()) {
                Function1 mapFunc = (Function1)option.get();
                value = ((MapValue)mapFunc.apply((Object)state)).get(this.propertyKey().name());
            } else if (anyValue instanceof TemporalValue) {
                TemporalValue temporalValue = (TemporalValue)anyValue;
                value = temporalValue.get(this.propertyKey().name());
            } else if (anyValue instanceof DurationValue) {
                DurationValue durationValue = (DurationValue)anyValue;
                value = durationValue.get(this.propertyKey().name());
            } else if (anyValue instanceof PointValue) {
                Value v;
                PointValue pointValue = (PointValue)anyValue;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> pointValue.get(this.propertyKey().name()));
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        throw new InvalidArgumentException(e.getMessage(), e);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                Value value4 = v = (Value)success.value();
                value = value4;
            } else {
                throw new CypherTypeException(new StringBuilder(38).append("Type mismatch: expected a map but was ").append(anyValue).toString());
            }
        }
        return value;
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        return (Expression)f.apply((Object)new Property(this.mapExpr().rewrite(f), (KeyToken)this.propertyKey().rewrite((Function1)f)));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.mapExpr(), this.propertyKey()}));
    }

    @Override
    public Seq<Expression> arguments() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.mapExpr()}));
    }

    @Override
    public String toString() {
        return new StringBuilder(1).append(this.mapExpr()).append(".").append(this.propertyKey().name()).toString();
    }

    public Property copy(Expression mapExpr, KeyToken propertyKey) {
        return new Property(mapExpr, propertyKey);
    }

    public Expression copy$default$1() {
        return this.mapExpr();
    }

    public KeyToken copy$default$2() {
        return this.propertyKey();
    }

    public String productPrefix() {
        return "Property";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.mapExpr();
                break;
            }
            case 1: {
                expression = this.propertyKey();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Property;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Property)) return false;
        boolean bl = true;
        if (!bl) return false;
        Property property = (Property)x$1;
        Expression expression = this.mapExpr();
        Expression expression2 = property.mapExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        KeyToken keyToken = this.propertyKey();
        KeyToken keyToken2 = property.propertyKey();
        if (keyToken == null) {
            if (keyToken2 != null) {
                return false;
            }
        } else if (!keyToken.equals(keyToken2)) return false;
        if (!property.canEqual(this)) return false;
        return true;
    }

    public Property(Expression mapExpr, KeyToken propertyKey) {
        this.mapExpr = mapExpr;
        this.propertyKey = propertyKey;
        Product.$init$((Product)this);
    }
}

