/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class ShowSchemaCommandHelper$ {
    public static ShowSchemaCommandHelper$ MODULE$;

    static {
        new ShowSchemaCommandHelper$();
    }

    public String escapeBackticks(String str) {
        return new StringOps(Predef$.MODULE$.augmentString(str)).replaceAllLiterally("`", "``");
    }

    public MapValue extractOptionsMap(String providerName, IndexConfig indexConfig) {
        Tuple2 tuple2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(indexConfig.asMap()).asScala()).toSeq().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq configKeys = (Seq)tuple2._1();
        Seq configValues = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)configKeys, (Object)configValues);
        Tuple2 tuple23 = tuple22;
        Seq configKeys2 = (Seq)tuple23._1();
        Seq configValues2 = (Seq)tuple23._2();
        String[] optionKeys = (String[])((Object[])new String[]{"indexConfig", "indexProvider"});
        AnyValue[] optionValues = (AnyValue[])((Object[])new AnyValue[]{VirtualValues.map((String[])((String[])configKeys2.toArray(ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])configValues2.toArray(ClassTag$.MODULE$.apply(AnyValue.class)))), Values.stringValue((String)providerName)});
        return VirtualValues.map((String[])optionKeys, (AnyValue[])optionValues);
    }

    public String optionsAsString(String providerString, String configString) {
        return new StringBuilder(34).append("{indexConfig: ").append(configString).append(", indexProvider: '").append(providerString).append("'}").toString();
    }

    public String asEscapedString(List<String> list, StringJoiner stringJoiner) {
        list.foreach((Function1 & Serializable & scala.Serializable)elem -> stringJoiner.add(new StringBuilder(2).append("`").append(MODULE$.escapeBackticks((String)elem)).append("`").toString()));
        return stringJoiner.toString();
    }

    public String configAsString(IndexConfig indexConfig, Function1<Value, String> configValueAsString) {
        StringJoiner configString = this.configStringJoiner();
        ListMap sortedIndexConfig = (ListMap)ListMap$.MODULE$.apply((Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(indexConfig.asMap()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$));
        sortedIndexConfig.foldLeft((Object)configString, (Function2 & Serializable & scala.Serializable)(acc, entry) -> {
            String singleConfig = new StringBuilder(4).append("`").append(entry._1()).append("`: ").append(configValueAsString.apply(entry._2())).toString();
            return acc.add(singleConfig);
        });
        return configString.toString();
    }

    public String btreeConfigValueAsString(Value configValue) {
        Value value = configValue;
        if (!(value instanceof DoubleArray)) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Could not convert config value '").append(configValue).append("' to config string.").toString());
        }
        DoubleArray doubleArray = (DoubleArray)value;
        String string = Arrays.toString(doubleArray.asObjectCopy());
        return string;
    }

    public StringJoiner colonStringJoiner() {
        return new StringJoiner(":", ":", "");
    }

    public StringJoiner barStringJoiner() {
        return new StringJoiner("|", ":", "");
    }

    public StringJoiner propStringJoiner() {
        return new StringJoiner(", n.", "n.", "");
    }

    public StringJoiner relPropStringJoiner() {
        return new StringJoiner(", r.", "r.", "");
    }

    private StringJoiner configStringJoiner() {
        return new StringJoiner(",", "{", "}");
    }

    private ShowSchemaCommandHelper$() {
        MODULE$ = this;
    }
}

