/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.neo4j.csv.reader.BufferOverflowException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResources$;
import org.neo4j.cypher.internal.runtime.interpreted.TheCookieManager$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sun.net.www.protocol.http.HttpURLConnection;

@ScalaSignature(bytes="\u0006\u0001\u0005es!B\u000b\u0017\u0011\u0003\u0019c!B\u0013\u0017\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%\t\u0001\r\u0005\u0007s\u0005\u0001\u000b\u0011B\u0019\t\u000fi\n!\u0019!C\u0001w!1q(\u0001Q\u0001\nqBq\u0001Q\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004F\u0003\u0001\u0006IA\u0011\u0005\b\r\u0006\u0011\r\u0011\"\u0001<\u0011\u00199\u0015\u0001)A\u0005y!)\u0001*\u0001C\u0005\u0013\u001a!QE\u0006\u0001Z\u0011!\u0001GB!A!\u0002\u0013\t\u0007\"B\u0017\r\t\u0003)\u0007\"\u00025\r\t\u0003I\u0007\"CA\n\u0019E\u0005I\u0011AA\u000b\u0011\u001d\tY\u0003\u0004C\u0005\u0003[Aq!a\u000e\r\t\u0013\tI\u0004C\u0005\u0002R1\t\n\u0011\"\u0003\u0002T!I\u0011q\u000b\u0007\u0012\u0002\u0013%\u00111K\u0001\r\u0007N3&+Z:pkJ\u001cWm\u001d\u0006\u0003/a\t1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011\u0011DG\u0001\beVtG/[7f\u0015\tYB$\u0001\u0005j]R,'O\\1m\u0015\tib$\u0001\u0004dsBDWM\u001d\u0006\u0003?\u0001\nQA\\3pi)T\u0011!I\u0001\u0004_J<7\u0001\u0001\t\u0003I\u0005i\u0011A\u0006\u0002\r\u0007N3&+Z:pkJ\u001cWm]\n\u0003\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$\u0003UqUiT0V'\u0016\u0013v,Q$F\u001dR{\u0006KU#G\u0013b+\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nA\u0001\\1oO*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005\u0019\u0019FO]5oO\u00061b*R(`+N+%kX!H\u000b:#v\f\u0015*F\r&C\u0006%\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`\r&+E\nR0U\u000bJk\u0015JT!U\u001fJ+\u0012\u0001\u0010\t\u0003QuJ!AP\u0015\u0003\t\rC\u0017M]\u0001\u001a\t\u00163\u0015)\u0016'U?\u001aKU\t\u0014#`)\u0016\u0013V*\u0013(B)>\u0013\u0006%A\nE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV)F\u0001C!\tA3)\u0003\u0002ES\t\u0019\u0011J\u001c;\u0002)\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#!\u0003I!UIR!V\u0019R{\u0016+V(U\u000b~\u001b\u0005*\u0011*\u0002'\u0011+e)Q+M)~\u000bVk\u0014+F?\u000eC\u0015I\u0015\u0011\u0002\r\r|gNZ5h)\rQ%k\u0016\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000baA]3bI\u0016\u0014(BA(\u001f\u0003\r\u00197O^\u0005\u0003#2\u0013QbQ8oM&<WO]1uS>t\u0007\"B*\f\u0001\u0004!\u0016A\u00067fO\u0006\u001c\u0017pQ:w#V|G/Z#tG\u0006\u0004\u0018N\\4\u0011\u0005!*\u0016B\u0001,*\u0005\u001d\u0011un\u001c7fC:DQ\u0001W\u0006A\u0002\t\u000bQbY:w\u0005V4g-\u001a:TSj,7c\u0001\u0007(5B\u00111LX\u0007\u00029*\u0011QLF\u0001\u0006a&\u0004Xm]\u0005\u0003?r\u00131#\u0012=uKJt\u0017\r\\\"T-J+7o\\;sG\u0016\fqB]3t_V\u00148-Z'b]\u0006<WM\u001d\t\u0003E\u000el\u0011\u0001G\u0005\u0003Ib\u0011qBU3t_V\u00148-Z'b]\u0006<WM\u001d\u000b\u0003M\u001e\u0004\"\u0001\n\u0007\t\u000b\u0001t\u0001\u0019A1\u0002\u001d\u001d,GoQ:w\u0013R,'/\u0019;peRI!.\\;\u0002\n\u0005-\u0011q\u0002\t\u00037.L!\u0001\u001c/\u0003\u001f1{\u0017\rZ\"tm&#XM]1u_JDQA\\\bA\u0002=\f1!\u001e:m!\t\u00018/D\u0001r\u0015\t\u0011X'A\u0002oKRL!\u0001^9\u0003\u0007U\u0013F\nC\u0003w\u001f\u0001\u0007q/A\bgS\u0016dG\rV3s[&t\u0017\r^8s!\rA\u0003P_\u0005\u0003s&\u0012aa\u00149uS>t\u0007cA>\u0002\u00069\u0019A0!\u0001\u0011\u0005uLS\"\u0001@\u000b\u0005}\u0014\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0004%\na\u0001\u0015:fI\u00164\u0017b\u0001\u001d\u0002\b)\u0019\u00111A\u0015\t\u000bM{\u0001\u0019\u0001+\t\r\u00055q\u00021\u0001C\u0003)\u0011WO\u001a4feNK'0\u001a\u0005\t\u0003#y\u0001\u0013!a\u0001)\u00069\u0001.Z1eKJ\u001c\u0018\u0001G4fi\u000e\u001bh/\u0013;fe\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0003\u0016\u0004)\u0006e1FAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0012&\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0013\u001d,GOU3bI\u0016\u0014H\u0003BA\u0018\u0003k\u00012aSA\u0019\u0013\r\t\u0019\u0004\u0014\u0002\r\u0007\"\f'OU3bI\u0006\u0014G.\u001a\u0005\u0006]F\u0001\ra\\\u0001\u000b_B,gn\u0015;sK\u0006lG\u0003CA\u001e\u0003\u000f\nI%!\u0014\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u00116\u0003\tIw.\u0003\u0003\u0002F\u0005}\"aC%oaV$8\u000b\u001e:fC6DQA\u001c\nA\u0002=D\u0001\"a\u0013\u0013!\u0003\u0005\rAQ\u0001\u0012G>tg.Z2uS>tG+[7f_V$\b\u0002CA(%A\u0005\t\u0019\u0001\"\u0002\u0017I,\u0017\r\u001a+j[\u0016|W\u000f^\u0001\u0015_B,gn\u0015;sK\u0006lG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U#f\u0001\"\u0002\u001a\u0005!r\u000e]3o'R\u0014X-Y7%I\u00164\u0017-\u001e7uIM\u0002")
public class CSVResources
implements ExternalCSVResource {
    private final ResourceManager resourceManager;

    public static char DEFAULT_QUOTE_CHAR() {
        return CSVResources$.MODULE$.DEFAULT_QUOTE_CHAR();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return CSVResources$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static char DEFAULT_FIELD_TERMINATOR() {
        return CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR();
    }

    public static String NEO_USER_AGENT_PREFIX() {
        return CSVResources$.MODULE$.NEO_USER_AGENT_PREFIX();
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        CharReadable reader = this.getReader(url);
        char delimiter = BoxesRunTime.unboxToChar((Object)fieldTerminator.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)x$1.charAt(0))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR()));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)reader, (Configuration)CSVResources$.MODULE$.org$neo4j$cypher$internal$runtime$interpreted$CSVResources$$config(legacyCsvQuoteEscaping, bufferSize), (boolean)false);
        Extractors.TextValueExtractor extractor = new Extractors(delimiter).textValue();
        char intDelimiter = delimiter;
        Mark mark = new Mark();
        CSVResource resource = new CSVResource(url, (AutoCloseable)seeker);
        this.resourceManager.trace((AutoCloseablePlus)resource);
        return new LoadCsvIterator(null, resource, seeker, mark, intDelimiter, extractor){
            private long lastProcessed;
            private boolean readAll;
            private Value[] nextRow;
            private final CSVResource resource$1;
            private final CharSeeker seeker$1;
            private final Mark mark$1;
            private final int intDelimiter$1;
            private final Extractors.TextValueExtractor extractor$1;

            public long lastProcessed() {
                return this.lastProcessed;
            }

            private void lastProcessed_$eq(long x$1) {
                this.lastProcessed = x$1;
            }

            public boolean readAll() {
                return this.readAll;
            }

            private void readAll_$eq(boolean x$1) {
                this.readAll = x$1;
            }

            public void closeMore() {
                this.resource$1.close();
            }

            private Value[] readNextRow() {
                ArrayBuffer buffer = new ArrayBuffer();
                try {
                    while (this.seeker$1.seek(this.mark$1, this.intDelimiter$1)) {
                        boolean success = this.seeker$1.tryExtract(this.mark$1, (Extractor)this.extractor$1);
                        buffer.$plus$eq((Object)(success ? this.extractor$1.value() : Values.NO_VALUE));
                        if (!this.mark$1.isEndOfLine()) continue;
                        return buffer.isEmpty() ? null : (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
                    }
                }
                catch (BufferOverflowException e) {
                    throw new CypherExecutionException(e.getMessage(), (Throwable)e);
                }
                return buffer.isEmpty() ? null : (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
            }

            private Value[] nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(Value[] x$1) {
                this.nextRow = x$1;
            }

            public boolean innerHasNext() {
                return this.nextRow() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Value[] next() {
                void var1_1;
                Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
                Value[] row = this.nextRow();
                this.nextRow_$eq(this.readNextRow());
                this.lastProcessed_$eq(this.lastProcessed() + 1L);
                this.readAll_$eq(!this.hasNext());
                return var1_1;
            }
            {
                this.resource$1 = resource$1;
                this.seeker$1 = seeker$1;
                this.mark$1 = mark$1;
                this.intDelimiter$1 = intDelimiter$1;
                this.extractor$1 = extractor$1;
                this.lastProcessed = 0L;
                this.readAll = false;
                this.nextRow = this.readNextRow();
            }
        };
    }

    @Override
    public boolean getCsvIterator$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private CharReadable getReader(URL url) {
        void v2;
        try {
            void var2_4;
            CharReadable charReadable;
            String string = url.getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                charReadable = Readables.files((Charset)StandardCharsets.UTF_8, (Path[])new Path[]{Paths.get(url.toURI())});
            } else {
                InputStream inputStream = this.openStream(url, this.openStream$default$2(), this.openStream$default$3());
                charReadable = Readables.wrap((InputStream)inputStream, (String)url.toString(), (Charset)StandardCharsets.UTF_8, (long)0L);
            }
            CharReadable reader = charReadable;
            v2 = var2_4;
        }
        catch (IOException e) {
            throw new LoadExternalResourceException(new StringBuilder(40).append("Couldn't load the external resource at: ").append(url).toString(), (Throwable)e);
        }
        return v2;
    }

    private InputStream openStream(URL url, int connectionTimeout, int readTimeout) {
        if (url.getProtocol().startsWith("http")) {
            TheCookieManager$.MODULE$.ensureEnabled();
        }
        URLConnection con = url.openConnection();
        con.setRequestProperty("User-Agent", new StringBuilder(0).append(CSVResources$.MODULE$.NEO_USER_AGENT_PREFIX()).append(HttpURLConnection.userAgent).toString());
        con.setConnectTimeout(connectionTimeout);
        con.setReadTimeout(readTimeout);
        InputStream stream = con.getInputStream();
        String string = con.getContentEncoding();
        InputStream inputStream = "gzip".equals(string) ? new GZIPInputStream(stream) : ("deflate".equals(string) ? new InflaterInputStream(stream) : stream);
        return inputStream;
    }

    private int openStream$default$2() {
        return 2000;
    }

    private int openStream$default$3() {
        return 600000;
    }

    public CSVResources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

