/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.neo4j.csv.reader.BufferOverflowException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResources$;
import org.neo4j.cypher.internal.runtime.interpreted.TheCookieManager$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}s!\u0002\f\u0018\u0011\u0003!c!\u0002\u0014\u0018\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001y!1\u0001)\u0001Q\u0001\nuBq!Q\u0001C\u0002\u0013\u0005!\t\u0003\u0004G\u0003\u0001\u0006Ia\u0011\u0005\b\u000f\u0006\u0011\r\u0011\"\u0001=\u0011\u0019A\u0015\u0001)A\u0005{!)\u0011*\u0001C\u0005\u0015\u001a!ae\u0006\u0001[\u0011!\tGB!A!\u0002\u0013\u0011\u0007\"\u0002\u0018\r\t\u00031\u0007\"B5\r\t\u0003Q\u0007\"CA\u000b\u0019E\u0005I\u0011AA\f\u0011\u001d\ti\u0003\u0004C\u0005\u0003_Aq!!\u000f\r\t\u0013\tY\u0004C\u0005\u0002T1\t\n\u0011\"\u0003\u0002V!I\u0011\u0011\f\u0007\u0012\u0002\u0013%\u0011Q\u000b\u0005\b\u00037bA\u0011BA/\u00031\u00195K\u0016*fg>,(oY3t\u0015\tA\u0012$A\u0006j]R,'\u000f\u001d:fi\u0016$'B\u0001\u000e\u001c\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001H\u000f\u0002\u0011%tG/\u001a:oC2T!AH\u0010\u0002\r\rL\b\u000f[3s\u0015\t\u0001\u0013%A\u0003oK>$$NC\u0001#\u0003\ry'oZ\u0002\u0001!\t)\u0013!D\u0001\u0018\u00051\u00195K\u0016*fg>,(oY3t'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\nQCT#P?V\u001bVIU0B\u000f\u0016sEk\u0018)S\u000b\u001aK\u0005,F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0017A\u0006(F\u001f~+6+\u0012*`\u0003\u001e+e\nV0Q%\u00163\u0015\n\u0017\u0011\u00021\u0011+e)Q+M)~3\u0015*\u0012'E?R+%+T%O\u0003R{%+F\u0001>!\tIc(\u0003\u0002@U\t!1\t[1s\u0003e!UIR!V\u0019R{f)S#M\t~#VIU'J\u001d\u0006#vJ\u0015\u0011\u0002'\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#\u0016\u0003\r\u0003\"!\u000b#\n\u0005\u0015S#aA%oi\u0006!B)\u0012$B+2#vLQ+G\r\u0016\u0013vlU%[\u000b\u0002\n!\u0003R#G\u0003VcEkX)V\u001fR+ul\u0011%B%\u0006\u0019B)\u0012$B+2#v,U+P)\u0016{6\tS!SA\u000511m\u001c8gS\u001e$2aS*Y!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0004sK\u0006$WM\u001d\u0006\u0003!~\t1aY:w\u0013\t\u0011VJA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006).\u0001\r!V\u0001\u0017Y\u0016<\u0017mY=DgZ\fVo\u001c;f\u000bN\u001c\u0017\r]5oOB\u0011\u0011FV\u0005\u0003/*\u0012qAQ8pY\u0016\fg\u000eC\u0003Z\u0017\u0001\u00071)A\u0007dgZ\u0014UO\u001a4feNK'0Z\n\u0004\u0019!Z\u0006C\u0001/`\u001b\u0005i&B\u00010\u0018\u0003\u0015\u0001\u0018\u000e]3t\u0013\t\u0001WLA\nFqR,'O\\1m\u0007N3&+Z:pkJ\u001cW-A\bsKN|WO]2f\u001b\u0006t\u0017mZ3s!\t\u0019G-D\u0001\u001a\u0013\t)\u0017DA\bSKN|WO]2f\u001b\u0006t\u0017mZ3s)\t9\u0007\u000e\u0005\u0002&\u0019!)\u0011M\u0004a\u0001E\u0006qq-\u001a;DgZLE/\u001a:bi>\u0014H#C6om\u0006-\u0011QBA\t!\taF.\u0003\u0002n;\nyAj\\1e\u0007N4\u0018\n^3sCR|'\u000fC\u0003p\u001f\u0001\u0007\u0001/A\u0002ve2\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u001c\u0002\u00079,G/\u0003\u0002ve\n\u0019QK\u0015'\t\u000b]|\u0001\u0019\u0001=\u0002\u001f\u0019LW\r\u001c3UKJl\u0017N\\1u_J\u00042!K=|\u0013\tQ(F\u0001\u0004PaRLwN\u001c\t\u0004y\u0006\u001dabA?\u0002\u0004A\u0011aPK\u0007\u0002\u007f*\u0019\u0011\u0011A\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t)AK\u0001\u0007!J,G-\u001a4\n\u0007e\nIAC\u0002\u0002\u0006)BQ\u0001V\bA\u0002UCa!a\u0004\u0010\u0001\u0004\u0019\u0015A\u00032vM\u001a,'oU5{K\"A\u00111C\b\u0011\u0002\u0003\u0007Q+A\u0004iK\u0006$WM]:\u00021\u001d,GoQ:w\u0013R,'/\u0019;pe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u001a)\u001aQ+a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011bZ3u%\u0016\fG-\u001a:\u0015\t\u0005E\u0012q\u0007\t\u0004\u0019\u0006M\u0012bAA\u001b\u001b\na1\t[1s%\u0016\fG-\u00192mK\")q.\u0005a\u0001a\u0006Qq\u000e]3o'R\u0014X-Y7\u0015\u0011\u0005u\u0012\u0011JA&\u0003\u001f\u0002B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u00072\u0014AA5p\u0013\u0011\t9%!\u0011\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006_J\u0001\r\u0001\u001d\u0005\t\u0003\u001b\u0012\u0002\u0013!a\u0001\u0007\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\t\u0011\u0005E#\u0003%AA\u0002\r\u000b1B]3bIRKW.Z8vi\u0006!r\u000e]3o'R\u0014X-Y7%I\u00164\u0017-\u001e7uII*\"!a\u0016+\u0007\r\u000bY\"\u0001\u000bpa\u0016t7\u000b\u001e:fC6$C-\u001a4bk2$HeM\u0001\nkN,'/Q4f]R,\u0012a\u001f")
public class CSVResources
implements ExternalCSVResource {
    private final ResourceManager resourceManager;

    public static char DEFAULT_QUOTE_CHAR() {
        return CSVResources$.MODULE$.DEFAULT_QUOTE_CHAR();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return CSVResources$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static char DEFAULT_FIELD_TERMINATOR() {
        return CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR();
    }

    public static String NEO_USER_AGENT_PREFIX() {
        return CSVResources$.MODULE$.NEO_USER_AGENT_PREFIX();
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        CharReadable reader = this.getReader(url);
        char delimiter = BoxesRunTime.unboxToChar((Object)fieldTerminator.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)x$1.charAt(0))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable)() -> CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR()));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)reader, (Configuration)CSVResources$.MODULE$.org$neo4j$cypher$internal$runtime$interpreted$CSVResources$$config(legacyCsvQuoteEscaping, bufferSize), (boolean)false);
        Extractors.TextValueExtractor extractor = new Extractors(delimiter).textValue();
        char intDelimiter = delimiter;
        Mark mark = new Mark();
        CSVResource resource = new CSVResource(url, (AutoCloseable)seeker);
        this.resourceManager.trace((AutoCloseablePlus)resource);
        return new LoadCsvIterator(null, resource, seeker, mark, intDelimiter, extractor){
            private long lastProcessed;
            private boolean readAll;
            private Value[] nextRow;
            private final CSVResource resource$1;
            private final CharSeeker seeker$1;
            private final Mark mark$1;
            private final int intDelimiter$1;
            private final Extractors.TextValueExtractor extractor$1;

            public long lastProcessed() {
                return this.lastProcessed;
            }

            private void lastProcessed_$eq(long x$1) {
                this.lastProcessed = x$1;
            }

            public boolean readAll() {
                return this.readAll;
            }

            private void readAll_$eq(boolean x$1) {
                this.readAll = x$1;
            }

            public void closeMore() {
                this.resource$1.close();
            }

            private Value[] readNextRow() {
                ArrayBuffer buffer = new ArrayBuffer();
                try {
                    while (this.seeker$1.seek(this.mark$1, this.intDelimiter$1)) {
                        Value value = (Value)this.seeker$1.tryExtract(this.mark$1, (Extractor)this.extractor$1);
                        buffer.$plus$eq((Object)(!this.extractor$1.isEmpty((Object)value) ? value : Values.NO_VALUE));
                        if (!this.mark$1.isEndOfLine()) continue;
                        return buffer.isEmpty() ? null : (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
                    }
                }
                catch (BufferOverflowException e) {
                    throw new CypherExecutionException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Tried to read a field larger than the current buffer size.\n                | Make sure that the field doesn't have an unterminated quote,\n                | if it doesn't you can try increasing the buffer size via `dbms.import.csv.buffer_size`.")), (Throwable)e);
                }
                return buffer.isEmpty() ? null : (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
            }

            private Value[] nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(Value[] x$1) {
                this.nextRow = x$1;
            }

            public boolean innerHasNext() {
                return this.nextRow() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Value[] next() {
                void var1_1;
                Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
                Value[] row = this.nextRow();
                this.nextRow_$eq(this.readNextRow());
                this.lastProcessed_$eq(this.lastProcessed() + 1L);
                this.readAll_$eq(!this.hasNext());
                return var1_1;
            }
            {
                this.resource$1 = resource$1;
                this.seeker$1 = seeker$1;
                this.mark$1 = mark$1;
                this.intDelimiter$1 = intDelimiter$1;
                this.extractor$1 = extractor$1;
                this.lastProcessed = 0L;
                this.readAll = false;
                this.nextRow = this.readNextRow();
            }
        };
    }

    @Override
    public boolean getCsvIterator$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private CharReadable getReader(URL url) {
        void v2;
        try {
            void var2_4;
            CharReadable charReadable;
            String string = url.getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                charReadable = Readables.files((Charset)StandardCharsets.UTF_8, (Path[])new Path[]{Paths.get(url.toURI())});
            } else {
                InputStream inputStream = this.openStream(url, this.openStream$default$2(), this.openStream$default$3());
                charReadable = Readables.wrap((InputStream)inputStream, (String)url.toString(), (Charset)StandardCharsets.UTF_8, (long)0L);
            }
            CharReadable reader = charReadable;
            v2 = var2_4;
        }
        catch (IOException e) {
            throw new LoadExternalResourceException("Couldn't load the external resource at: " + url, (Throwable)e);
        }
        return v2;
    }

    private InputStream openStream(URL url, int connectionTimeout, int readTimeout) {
        InputStream inputStream;
        block5: {
            if (url.getProtocol().startsWith("http")) {
                TheCookieManager$.MODULE$.ensureEnabled();
            }
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", CSVResources$.MODULE$.NEO_USER_AGENT_PREFIX() + this.userAgent());
            con.setConnectTimeout(connectionTimeout);
            con.setReadTimeout(readTimeout);
            InputStream stream = con.getInputStream();
            String string = con.getContentEncoding();
            switch (string == null ? 0 : string.hashCode()) {
                case 3189082: {
                    if (!"gzip".equals(string)) break;
                    inputStream = new GZIPInputStream(stream);
                    break block5;
                }
                case 1545112619: {
                    if (!"deflate".equals(string)) break;
                    inputStream = new InflaterInputStream(stream);
                    break block5;
                }
            }
            inputStream = stream;
        }
        return inputStream;
    }

    private int openStream$default$2() {
        return 2000;
    }

    private int openStream$default$3() {
        return 600000;
    }

    private String userAgent() {
        Runtime.Version version = Runtime.version();
        String agent = System.getProperty("http.agent");
        return agent == null ? "Java/" + version : agent + " Java/" + version;
    }

    public CSVResources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

