/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import org.neo4j.cypher.internal.runtime.CypherRow$;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Values;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class NumericHelper$ {
    public static final NumericHelper$ MODULE$ = new NumericHelper$();

    public Option<Object> asLongEntityId(AnyValue a) {
        Object object;
        AnyValue anyValue = a;
        if (anyValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)anyValue;
            object = new Some((Object)BoxesRunTime.boxToLong((long)integralValue.longValue()));
        } else {
            FloatingPointValue floatingPointValue;
            object = anyValue instanceof FloatingPointValue ? (NumberValues.numbersEqual((double)(floatingPointValue = (FloatingPointValue)anyValue).doubleValue(), (long)floatingPointValue.longValue()) ? new Some((Object)BoxesRunTime.boxToLong((long)floatingPointValue.longValue())) : None$.MODULE$) : None$.MODULE$;
        }
        return object;
    }

    public long asLongEntityIdPrimitive(AnyValue a) {
        long l;
        AnyValue anyValue = a;
        if (anyValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)anyValue;
            l = integralValue.longValue();
        } else {
            FloatingPointValue floatingPointValue;
            l = anyValue instanceof FloatingPointValue && NumberValues.numbersEqual((double)(floatingPointValue = (FloatingPointValue)anyValue).doubleValue(), (long)floatingPointValue.longValue()) ? floatingPointValue.longValue() : -1L;
        }
        return l;
    }

    public DoubleValue asDouble(AnyValue a) {
        return Values.doubleValue((double)this.asNumber(a).doubleValue());
    }

    public int asPrimitiveInt(AnyValue a) {
        return (int)this.asNumber(a).longValue();
    }

    public LongValue asLong(AnyValue a) {
        return Values.longValue((long)this.asPrimitiveLong(a));
    }

    public long asPrimitiveLong(AnyValue a) {
        return this.asNumber(a).longValue();
    }

    public NumberValue asNumber(AnyValue a) {
        NumberValue numberValue;
        AnyValue anyValue = a;
        if (anyValue == null) {
            throw new CypherTypeException("Expected a numeric value for " + this.toString() + ", but got null");
        }
        if (anyValue == Values.NO_VALUE) {
            throw new CypherTypeException("Expected a numeric value for " + this.toString() + ", but got null");
        }
        if (!(anyValue instanceof NumberValue)) {
            throw new CypherTypeException("Expected a numeric value for " + this.toString() + ", but got: " + a.toString());
        }
        NumberValue numberValue2 = numberValue = (NumberValue)anyValue;
        return numberValue2;
    }

    public NumberValue evaluateStaticallyKnownNumber(Expression exp, QueryState state) {
        return this.asNumber(exp.apply((ReadableRow)CypherRow$.MODULE$.empty(), state));
    }

    private NumericHelper$() {
    }
}

