/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TerminateTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.InternalLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u000f\u001f\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t9\u0002\u0011\t\u0012)A\u0005\u0011\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005g\u0001\tE\t\u0015!\u0003`\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011B5\t\u000b9\u0004A\u0011A8\t\u000bQ\u0004A\u0011I;\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0002\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011%\t\u0019\u0005AI\u0001\n\u0003\t)\u0005C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u0002L!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005e\u0004!!A\u0005B\u0005m\u0004\"CAE\u0001\u0005\u0005I\u0011AAF\u0011%\t)\nAA\u0001\n\u0003\n9\nC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0011\u0002\u001e\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0015\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003K;\u0011\"!+\u001f\u0003\u0003E\t!a+\u0007\u0011uq\u0012\u0011!E\u0001\u0003[CaA\\\f\u0005\u0002\u0005\r\u0007\"CAP/\u0005\u0005IQIAQ\u0011%\t)mFA\u0001\n\u0003\u000b9\rC\u0005\u0002P^\t\t\u0011\"!\u0002R\"I\u00111]\f\u0002\u0002\u0013%\u0011Q\u001d\u0002\u001d)\u0016\u0014X.\u001b8bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>lW.\u00198e\u0015\ty\u0002%\u0001\u0007tQ><8m\\7nC:$7O\u0003\u0002\"E\u0005A1m\\7nC:$7O\u0003\u0002$I\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t)c%A\u0004sk:$\u0018.\\3\u000b\u0005\u001dB\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%R\u0013AB2za\",'O\u0003\u0002,Y\u0005)a.Z85U*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001aQR\u0004CA\u00193\u001b\u0005q\u0012BA\u001a\u001f\u0005I!&/\u00198tC\u000e$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000fA\u0013x\u000eZ;diB\u00111h\u0011\b\u0003y\u0005s!!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u0001\"7\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\t3\u0014\u0001C4jm\u0016t\u0017\nZ:\u0016\u0003!\u0003BaO%L-&\u0011!*\u0012\u0002\u0007\u000b&$\b.\u001a:\u0011\u0007mbe*\u0003\u0002N\u000b\n!A*[:u!\ty5K\u0004\u0002Q#B\u0011QHN\u0005\u0003%Z\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!K\u000e\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0002\n1\"\u001a=qe\u0016\u001c8/[8og&\u00111\f\u0017\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!C4jm\u0016t\u0017\nZ:!\u0003\u001d\u0019w\u000e\\;n]N,\u0012a\u0018\t\u0004w1\u0003\u0007CA1e\u001b\u0005\u0011'BA2'\u0003\r\t7\u000f^\u0005\u0003K\n\u0014!b\u00155po\u000e{G.^7o\u0003!\u0019w\u000e\\;n]N\u0004\u0013\u0001D=jK2$7i\u001c7v[:\u001cX#A5\u0011\u0007mb%\u000e\u0005\u0002bW&\u0011AN\u0019\u0002\u0012\u0007>lW.\u00198e%\u0016\u001cX\u000f\u001c;Ji\u0016l\u0017!D=jK2$7i\u001c7v[:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005aF\u00148\u000f\u0005\u00022\u0001!)ai\u0002a\u0001\u0011\")Ql\u0002a\u0001?\")qm\u0002a\u0001S\u0006\u0001rN]5hS:\fGNT1nKJ{wo\u001d\u000b\u0006m\u0006\u001d\u0011q\u0003\t\u0004obTX\"\u0001\u0013\n\u0005e$#aD\"m_NLgnZ%uKJ\fGo\u001c:\u0011\t=[h*`\u0005\u0003yV\u00131!T1q!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u0016\u0002\rY\fG.^3t\u0013\r\t)a \u0002\t\u0003:Lh+\u00197vK\"9\u0011\u0011\u0002\u0005A\u0002\u0005-\u0011!B:uCR,\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E!%A\u0003qSB,7/\u0003\u0003\u0002\u0016\u0005=!AC)vKJL8\u000b^1uK\"9\u0011\u0011\u0004\u0005A\u0002\u0005m\u0011a\u00022bg\u0016\u0014vn\u001e\t\u0004o\u0006u\u0011bAA\u0010I\tI1)\u001f9iKJ\u0014vn^\u0001\u0005G>\u0004\u0018\u0010F\u0004q\u0003K\t9#!\u000b\t\u000f\u0019K\u0001\u0013!a\u0001\u0011\"9Q,\u0003I\u0001\u0002\u0004y\u0006bB4\n!\u0003\u0005\r![\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyCK\u0002I\u0003cY#!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{1\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011IA\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9EK\u0002`\u0003c\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002N)\u001a\u0011.!\r\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&\u0019A+a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004cA\u001b\u0002h%\u0019\u0011\u0011\u000e\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0014Q\u000f\t\u0004k\u0005E\u0014bAA:m\t\u0019\u0011I\\=\t\u0013\u0005]t\"!AA\u0002\u0005\u0015\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002~A1\u0011qPAC\u0003_j!!!!\u000b\u0007\u0005\re'\u0001\u0006d_2dWm\u0019;j_:LA!a\"\u0002\u0002\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti)a%\u0011\u0007U\ny)C\u0002\u0002\u0012Z\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002xE\t\t\u00111\u0001\u0002p\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019&!'\t\u0013\u0005]$#!AA\u0002\u0005\u0015\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\u000e\u0006\u001d\u0006\"CA<+\u0005\u0005\t\u0019AA8\u0003q!VM]7j]\u0006$X\r\u0016:b]N\f7\r^5p]N\u001cu.\\7b]\u0012\u0004\"!M\f\u0014\u000b]\ty+!/\u0011\u0011\u0005E\u0016Q\u0017%`SBl!!a-\u000b\u0005\u00152\u0014\u0002BA\\\u0003g\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\tY,!1\u000e\u0005\u0005u&\u0002BA`\u00037\n!![8\n\u0007\u0011\u000bi\f\u0006\u0002\u0002,\u0006)\u0011\r\u001d9msR9\u0001/!3\u0002L\u00065\u0007\"\u0002$\u001b\u0001\u0004A\u0005\"B/\u001b\u0001\u0004y\u0006\"B4\u001b\u0001\u0004I\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003'\fy\u000eE\u00036\u0003+\fI.C\u0002\u0002XZ\u0012aa\u00149uS>t\u0007CB\u001b\u0002\\\"{\u0016.C\u0002\u0002^Z\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAq7\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002hB!\u0011QKAu\u0013\u0011\tY/a\u0016\u0003\r=\u0013'.Z2u\u0001")
public class TerminateTransactionsCommand
extends TransactionCommand
implements Product,
Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final List<ShowColumn> columns;
    private final List<CommandResultItem> yieldColumns;

    public static Option<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>> unapply(TerminateTransactionsCommand x$0) {
        return TerminateTransactionsCommand$.MODULE$.unapply(x$0);
    }

    public static TerminateTransactionsCommand apply(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return TerminateTransactionsCommand$.MODULE$.apply(givenIds, columns, yieldColumns);
    }

    public static Function1<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>, TerminateTransactionsCommand> tupled() {
        return TerminateTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<List<ShowColumn>, Function1<List<CommandResultItem>, TerminateTransactionsCommand>>> curried() {
        return TerminateTransactionsCommand$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public List<ShowColumn> columns() {
        return this.columns;
    }

    public List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    @Override
    public ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState state, CypherRow baseRow) {
        List<String> ids = TransactionCommandHelper$.MODULE$.extractIds(this.givenIds(), state, baseRow);
        if (ids.isEmpty()) {
            throw new InvalidSemanticsException("Missing transaction id to terminate, the transaction id can be found using `SHOW TRANSACTIONS`.");
        }
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        String executingUser = securityContext.subject().executingUser();
        String authenticatedUser = securityContext.subject().authenticatedUser();
        String loggingUser = securityContext.impersonating() ? authenticatedUser + ":" + executingUser : executingUser;
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("User %s trying to terminate transactions: %s.", new Object[]{loggingUser, ids.mkString("[", ", ", "]")});
        DatabaseContextProvider databaseManager = ctx.getDatabaseContextProvider();
        DatabaseIdRepository databaseIdRepository = databaseManager.databaseIdRepository();
        Tuple2 tuple2 = (Tuple2)ids.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String idText = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            Map accMap = (Map)tuple23._1();
            Set accSet = (Set)tuple23._2();
            TransactionId id = TransactionId$.MODULE$.parse(idText);
            Optional namedDatabaseId = databaseIdRepository.getByName(id.database());
            if (namedDatabaseId.isPresent()) {
                NamedDatabaseId databaseId = (NamedDatabaseId)namedDatabaseId.get();
                Set transactions = (Set)accMap.getOrElse((Object)databaseId, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                tuple2 = new Tuple2((Object)accMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)databaseId), (Object)transactions.$plus((Object)id))}))), (Object)accSet);
                return tuple2;
            } else {
                tuple2 = new Tuple2((Object)accMap, (Object)accSet.$plus((Object)id));
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map transactionsByDatabase = (Map)tuple2._1();
        Set otherTxIds = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transactionsByDatabase, (Object)otherTxIds);
        Tuple2 tuple23 = tuple22;
        Map transactionsByDatabase2 = (Map)tuple23._1();
        Set otherTxIds2 = (Set)tuple23._2();
        Iterable rows = (Iterable)transactionsByDatabase2.flatMap((Function1 & Serializable)x0$2 -> {
            Map map;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            NamedDatabaseId databaseId = (NamedDatabaseId)tuple2._1();
            Set txIds = (Set)tuple2._2();
            if (databaseId == null) throw new MatchError((Object)tuple2);
            NamedDatabaseId namedDatabaseId = databaseId;
            if (txIds == null) throw new MatchError((Object)tuple2);
            Set set = txIds;
            Optional maybeDatabaseContext = databaseManager.getDatabaseContext(namedDatabaseId);
            String dbName = namedDatabaseId.name();
            if (maybeDatabaseContext.isPresent()) {
                DatabaseContext databaseContext = (DatabaseContext)maybeDatabaseContext.get();
                AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(dbName);
                map = ((IterableOnceOps)((IterableOps)TransactionCommandHelper$.MODULE$.getExecutingTransactions(databaseContext).map((Function1 & Serializable)tx -> {
                    TransactionId txIdRepresentation = TransactionId$.MODULE$.apply(dbName, tx.getTransactionSequenceNumber());
                    return new Tuple2((Object)txIdRepresentation, tx);
                })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TerminateTransactionsCommand.$anonfun$originalNameRows$5(dbScope, securityContext, set, x0$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else {
                map = Predef$.MODULE$.Map().empty();
            }
            Map allowedTransactions = map;
            return (Set)set.map((Function1 & Serializable)txId -> {
                Option txHandle = allowedTransactions.get(txId);
                Tuple2 tuple2 = (Tuple2)txHandle.map((Function1 & Serializable)x0$4 -> {
                    Tuple2 tuple2;
                    KernelTransactionHandle kernelTransactionHandle = x0$4;
                    if (kernelTransactionHandle.isClosing()) {
                        tuple2 = new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Unable to terminate closing transactions.");
                    } else {
                        kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
                        log.info("User %s terminated transaction %s.", new Object[]{loggingUser, txId.toString()});
                        tuple2 = new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Transaction terminated.");
                    }
                    return tuple2;
                }).getOrElse((Function0 & Serializable)() -> new Tuple2(null, (Object)"Transaction not found."));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String username = (String)tuple2._1();
                String message = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)username, (Object)message);
                Tuple2 tuple23 = tuple22;
                String username2 = (String)tuple23._1();
                String message2 = (String)tuple23._2();
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.stringOrNoValue((String)username2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)message2))}));
            });
        });
        Iterable updatedWithExtraRows = (Iterable)rows.$plus$plus((IterableOnce)otherTxIds2.map((Function1 & Serializable)txId -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.NO_VALUE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)"Transaction not found."))}))));
        List<Map<String, AnyValue>> updatedColumnNameRows = this.updateRowsWithPotentiallyRenamedColumns((List<Map<String, AnyValue>>)updatedWithExtraRows.toList());
        return ClosingIterator$.MODULE$.apply(updatedColumnNameRows.iterator());
    }

    public TerminateTransactionsCommand copy(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return new TerminateTransactionsCommand(givenIds, columns, yieldColumns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public List<ShowColumn> copy$default$2() {
        return this.columns();
    }

    public List<CommandResultItem> copy$default$3() {
        return this.yieldColumns();
    }

    public String productPrefix() {
        return "TerminateTransactionsCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return switch (n) {
            case 0 -> this.givenIds();
            case 1 -> this.columns();
            case 2 -> this.yieldColumns();
            default -> Statics.ioobe((int)x$1);
        };
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TerminateTransactionsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return switch (n) {
            case 0 -> "givenIds";
            case 1 -> "columns";
            case 2 -> "yieldColumns";
            default -> (String)Statics.ioobe((int)x$1);
        };
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TerminateTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TerminateTransactionsCommand terminateTransactionsCommand = (TerminateTransactionsCommand)x$1;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = terminateTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.columns();
        List<ShowColumn> list2 = terminateTransactionsCommand.columns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<CommandResultItem> list3 = this.yieldColumns();
        List<CommandResultItem> list4 = terminateTransactionsCommand.yieldColumns();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        if (!terminateTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$5(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, Set x3$1, Tuple2 x0$3) {
        AdminActionOnResource action;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionId txIdRepresentation = (TransactionId)tuple2._1();
        KernelTransactionHandle tx = (KernelTransactionHandle)tuple2._2();
        String username = tx.subject().executingUser();
        boolean bl = TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, dbScope$1, (Segment)new UserSegment(username)), securityContext$1) && x3$1.contains((Object)txIdRepresentation);
        return bl;
    }

    public TerminateTransactionsCommand(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        this.givenIds = givenIds;
        this.columns = columns;
        this.yieldColumns = yieldColumns;
        super(columns, yieldColumns);
        Product.$init$((Product)this);
    }
}

