/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.LenientCreateRelationship$;
import org.neo4j.cypher.internal.runtime.WriteOperations;
import org.neo4j.cypher.internal.runtime.WriteQueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.BaseCreatePipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.CreateNodeCommand;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.CreateRelationshipCommand;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005!4QAB\u0004\u0002\u0002YA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006G\u0001!\t\u0002\n\u0005\u0006\u001d\u0002!\tb\u0014\u0005\u00067\u0002!I\u0001\u0018\u0002\u0011\u000b:$\u0018\u000e^=De\u0016\fG/\u001a)ja\u0016T!\u0001C\u0005\u0002\u000bAL\u0007/Z:\u000b\u0005)Y\u0011aC5oi\u0016\u0014\bO]3uK\u0012T!\u0001D\u0007\u0002\u000fI,h\u000e^5nK*\u0011abD\u0001\tS:$XM\u001d8bY*\u0011\u0001#E\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005I\u0019\u0012!\u00028f_RR'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u00059\u0011B\u0001\u000e\b\u00059\u0011\u0015m]3De\u0016\fG/\u001a)ja\u0016\f1a\u001d:d!\tAR$\u0003\u0002\u001f\u000f\t!\u0001+\u001b9f\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u00031\u0001AQa\u0007\u0002A\u0002q\t!b\u0019:fCR,gj\u001c3f)\u0011)c\bR%\u0011\t\u0019J3FN\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1A+\u001e9mKJ\u0002\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018(\u001b\u0005y#B\u0001\u0019\u0016\u0003\u0019a$o\\8u}%\u0011!gJ\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023OA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\bm&\u0014H/^1m\u0015\tY\u0014#\u0001\u0004wC2,Xm]\u0005\u0003{a\u0012\u0001CV5siV\fGNT8eKZ\u000bG.^3\t\u000b}\u001a\u0001\u0019\u0001!\u0002\u000f\r|g\u000e^3yiB\u0011\u0011IQ\u0007\u0002\u0017%\u00111i\u0003\u0002\n\u0007f\u0004\b.\u001a:S_^DQ!R\u0002A\u0002\u0019\u000bQa\u001d;bi\u0016\u0004\"\u0001G$\n\u0005!;!AC)vKJL8\u000b^1uK\")!j\u0001a\u0001\u0017\u0006!A-\u0019;b!\tAB*\u0003\u0002N\u000f\t\t2I]3bi\u0016tu\u000eZ3D_6l\u0017M\u001c3\u0002%\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u000b\u0005!V3v\u000b\u0005\u0003'S-\n\u0006C\u0001*T\u001b\u0005Q\u0014B\u0001+;\u0005!\te.\u001f,bYV,\u0007\"B \u0005\u0001\u0004\u0001\u0005\"B#\u0005\u0001\u00041\u0005\"\u0002&\u0005\u0001\u0004A\u0006C\u0001\rZ\u0013\tQvAA\rDe\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8tQ&\u00048i\\7nC:$\u0017aB4fi:{G-\u001a\u000b\u0006mu{\u0016m\u0019\u0005\u0006=\u0016\u0001\r\u0001Q\u0001\u0004e><\b\"\u00021\u0006\u0001\u0004Y\u0013a\u0002:fY:\u000bW.\u001a\u0005\u0006E\u0016\u0001\raK\u0001\u0005]\u0006lW\rC\u0003e\u000b\u0001\u0007Q-A\u0004mK:LWM\u001c;\u0011\u0005\u00192\u0017BA4(\u0005\u001d\u0011un\u001c7fC:\u0004")
public abstract class EntityCreatePipe
extends BaseCreatePipe {
    public Tuple2<String, VirtualNodeValue> createNode(CypherRow context, QueryState state, CreateNodeCommand data) {
        int[] labelIds = (int[])((IterableOnceOps)data.labels().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getOrCreateId((WriteQueryContext)state.query())))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        long node = state.query().createNodeId(labelIds);
        data.properties().foreach((Function1 & Serializable)x$2 -> {
            this.setProperties(context, state, node, x$2, (WriteOperations<?, ?>)state.query().nodeWriteOps());
            return BoxedUnit.UNIT;
        });
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.idName()), (Object)VirtualValues.node((long)node));
    }

    public Tuple2<String, AnyValue> createRelationship(CypherRow context, QueryState state, CreateRelationshipCommand data) {
        Value value;
        VirtualNodeValue start = this.getNode(context, data.idName(), data.startNode(), state.lenientCreateRelationship());
        VirtualNodeValue end = this.getNode(context, data.idName(), data.endNode(), state.lenientCreateRelationship());
        if (start == null || end == null) {
            value = Values.NO_VALUE;
        } else {
            int typeId = data.relType().getOrCreateType((WriteQueryContext)state.query());
            long relationship = state.query().createRelationshipId(start.id(), end.id(), typeId);
            data.properties().foreach((Function1 & Serializable)x$3 -> {
                this.setProperties(context, state, relationship, x$3, (WriteOperations<?, ?>)state.query().relationshipWriteOps());
                return BoxedUnit.UNIT;
            });
            value = VirtualValues.relationship((long)relationship, (long)start.id(), (long)end.id(), (int)typeId);
        }
        Value relationship = value;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.idName()), (Object)relationship);
    }

    private VirtualNodeValue getNode(CypherRow row, String relName, String name, boolean lenient) {
        VirtualNodeValue virtualNodeValue;
        AnyValue anyValue = row.getByName(name);
        if (anyValue instanceof VirtualNodeValue) {
            VirtualNodeValue virtualNodeValue2;
            virtualNodeValue = virtualNodeValue2 = (VirtualNodeValue)anyValue;
        } else if (anyValue != null && IsNoValue$.MODULE$.unapply(anyValue)) {
            if (!lenient) {
                throw new InternalException(LenientCreateRelationship$.MODULE$.errorMsg(relName, name));
            }
            virtualNodeValue = null;
        } else {
            throw new InternalException("Expected to find a node at '" + name + "' but found instead: " + anyValue);
        }
        return virtualNodeValue;
    }

    public EntityCreatePipe(Pipe src) {
        super(src);
    }
}

