/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AvgFunction$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u000f\u001f\u0001=B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!)!\t\u0001C\u0001\u0007\")a\t\u0001C\u0001\u000f\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0006b\u0002-\u0001\u0001\u0004%I!\u0017\u0005\u0007?\u0002\u0001\u000b\u0015\u0002*\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\"9Q\r\u0001a\u0001\n\u00131\u0007B\u00025\u0001A\u0003&!\rC\u0004j\u0001\u0001\u0007I\u0011B1\t\u000f)\u0004\u0001\u0019!C\u0005W\"1Q\u000e\u0001Q!\n\tDqA\u001c\u0001A\u0002\u0013%\u0011\rC\u0004p\u0001\u0001\u0007I\u0011\u00029\t\rI\u0004\u0001\u0015)\u0003c\u0011\u001d\u0019\b\u00011A\u0005\n\u0005Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004x\u0001\u0001\u0006KA\u0019\u0005\u0006q\u0002!\t%\u001f\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAa!a\r\u0001\t\u0003\tvaBA\u001b=!\u0005\u0011q\u0007\u0004\u0007;yA\t!!\u000f\t\r\tKB\u0011AA!\u0011!\t\u0019%\u0007b\u0001\n\u0003\t\u0006bBA#3\u0001\u0006IA\u0015\u0002\f\u0003Z<g)\u001e8di&|gN\u0003\u0002 A\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\t\t#%A\u0003qSB,7O\u0003\u0002$I\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t)c%A\u0004sk:$\u0018.\\3\u000b\u0005\u001dB\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%R\u0013AB2za\",'O\u0003\u0002,Y\u0005)a.Z85U*\tQ&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001aQ\u0002\"!\r\u001a\u000e\u0003yI!a\r\u0010\u0003'\u0005;wM]3hCRLwN\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c\u001f\u0005\u0019rU/\\3sS\u000e|%\u000fR;sCRLwN\\!hOJ,w-\u0019;j_:,\u0005\u0010\u001d:fgNLwN\\\u0001\u0006m\u0006dW/Z\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002?E\u0005A1m\\7nC:$7/\u0003\u0002Aw\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\rY\fG.^3!\u0003\u0019a\u0014N\\5u}Q\u0011A)\u0012\t\u0003c\u0001AQaN\u0002A\u0002e\nAA\\1nKV\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\rM#(/\u001b8h\u0003\u0015\u0019w.\u001e8u+\u0005\u0011\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&\u0001\u0002'p]\u001e\f\u0011bY8v]R|F%Z9\u0015\u0005ik\u0006CA*\\\u0013\taFK\u0001\u0003V]&$\bb\u00020\u0007\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014AB2pk:$\b%\u0001\tn_:$\bn\u001d*v]:LgnZ!wOV\t!\r\u0005\u0002TG&\u0011A\r\u0016\u0002\u0007\t>,(\r\\3\u0002)5|g\u000e\u001e5t%Vtg.\u001b8h\u0003Z<w\fJ3r)\tQv\rC\u0004_\u0013\u0005\u0005\t\u0019\u00012\u0002#5|g\u000e\u001e5t%Vtg.\u001b8h\u0003Z<\u0007%\u0001\beCf\u001c(+\u001e8oS:<\u0017I^4\u0002%\u0011\f\u0017p\u001d*v]:LgnZ!wO~#S-\u001d\u000b\u000352DqA\u0018\u0007\u0002\u0002\u0003\u0007!-A\beCf\u001c(+\u001e8oS:<\u0017I^4!\u0003E\u0019XmY8oIN\u0014VO\u001c8j]\u001e\feoZ\u0001\u0016g\u0016\u001cwN\u001c3t%Vtg.\u001b8h\u0003Z<w\fJ3r)\tQ\u0016\u000fC\u0004_\u001f\u0005\u0005\t\u0019\u00012\u0002%M,7m\u001c8egJ+hN\\5oO\u00063x\rI\u0001\u0010]\u0006twn\u001d*v]:LgnZ!wO\u0006\u0019b.\u00198pgJ+hN\\5oO\u00063xm\u0018\u0013fcR\u0011!L\u001e\u0005\b=J\t\t\u00111\u0001c\u0003Aq\u0017M\\8t%Vtg.\u001b8h\u0003Z<\u0007%\u0001\u0004sKN,H\u000e\u001e\u000b\u0004u\u0006\u0015\u0001cA>\u0002\u00025\tAP\u0003\u0002~}\u0006A1\u000f^8sC\ndWM\u0003\u0002\u0000U\u00051a/\u00197vKNL1!a\u0001}\u0005\u00151\u0016\r\\;f\u0011\u001d\t9\u0001\u0006a\u0001\u0003\u0013\tQa\u001d;bi\u0016\u0004B!a\u0003\u0002\u000e5\t\u0001%C\u0002\u0002\u0010\u0001\u0012!\"U;fef\u001cF/\u0019;f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Q\u0016QCA\u0011\u0011\u001d\t9\"\u0006a\u0001\u00033\tA\u0001Z1uCB!\u00111DA\u000f\u001b\u0005!\u0013bAA\u0010I\tY!+Z1eC\ndWMU8x\u0011\u001d\t9!\u0006a\u0001\u0003\u0013\t!#\u00199qYf4\u0016\r\\;f\t&\u0014Xm\u0019;msR\u0019!,a\n\t\u000f\u0005%b\u00031\u0001\u0002,\u0005\u0011a\u000f\u001c\t\u0005\u0003[\ty#D\u0001\u007f\u0013\r\t\tD \u0002\t\u0003:Lh+\u00197vK\u0006\u0011\u0012mZ4sK\u001e\fG/\u001a3S_^\u001cu.\u001e8u\u0003-\teo\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005EJ2cA\r\u0002<A\u00191+!\u0010\n\u0007\u0005}BK\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003o\tAb\u0015%B\u00192{ukX*J5\u0016\u000bQb\u0015%B\u00192{ukX*J5\u0016\u0003\u0003")
public class AvgFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private long count;
    private double monthsRunningAvg;
    private double daysRunningAvg;
    private double secondsRunningAvg;
    private double nanosRunningAvg;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    public static long SHALLOW_SIZE() {
        return AvgFunction$.MODULE$.SHALLOW_SIZE();
    }

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "AVG";
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    private double monthsRunningAvg() {
        return this.monthsRunningAvg;
    }

    private void monthsRunningAvg_$eq(double x$1) {
        this.monthsRunningAvg = x$1;
    }

    private double daysRunningAvg() {
        return this.daysRunningAvg;
    }

    private void daysRunningAvg_$eq(double x$1) {
        this.daysRunningAvg = x$1;
    }

    private double secondsRunningAvg() {
        return this.secondsRunningAvg;
    }

    private void secondsRunningAvg_$eq(double x$1) {
        this.secondsRunningAvg = x$1;
    }

    private double nanosRunningAvg() {
        return this.nanosRunningAvg;
    }

    private void nanosRunningAvg_$eq(double x$1) {
        this.nanosRunningAvg = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return Values.NO_VALUE;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException("invalid aggregation type " + this.aggregatingType());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException("invalid aggregation type " + this.aggregatingType());
        return DurationValue.approximate((double)this.monthsRunningAvg(), (double)this.daysRunningAvg(), (double)this.secondsRunningAvg(), (double)this.nanosRunningAvg()).normalize();
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.applyValueDirectly(vl);
    }

    public void applyValueDirectly(AnyValue vl) {
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable)number -> {
            AvgFunction.$anonfun$applyValueDirectly$1(this, number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable)duration -> {
            AvgFunction.$anonfun$applyValueDirectly$2(this, duration);
            return BoxedUnit.UNIT;
        });
    }

    public long aggregatedRowCount() {
        return this.count();
    }

    private final void AggregatingNumbers$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$1(AvgFunction $this, NumberValue number) {
        $this.count_$eq($this.count() + 1L);
        NumberValue diff = number.minus($this.sumNumber());
        NumberValue next = diff.dividedBy((double)$this.count());
        $this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)$this.sumNumber(), (NumberValue)next));
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$2(AvgFunction $this, DurationValue duration) {
        $this.count_$eq($this.count() + 1L);
        $this.monthsRunningAvg_$eq($this.monthsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - $this.monthsRunningAvg()) / (double)$this.count());
        $this.daysRunningAvg_$eq($this.daysRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - $this.daysRunningAvg()) / (double)$this.count());
        $this.secondsRunningAvg_$eq($this.secondsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - $this.secondsRunningAvg()) / (double)$this.count());
        $this.nanosRunningAvg_$eq($this.nanosRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - $this.nanosRunningAvg()) / (double)$this.count());
    }

    public AvgFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.count = 0L;
        this.monthsRunningAvg = 0.0;
        this.daysRunningAvg = 0.0;
        this.secondsRunningAvg = 0.0;
        this.nanosRunningAvg = 0.0;
    }
}

