/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-h!B\u0015+\u0003\u0003I\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003j\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015)\bA\"\u0005w\u0011\u001d\ti\u0002\u0001C\t\u0003?1a!!\u000e\u0001\t\u0005]\u0002BCA \u0015\t\u0005\t\u0015!\u0003\u0002B!I\u00111\u0002\u0006\u0003\u0002\u0003\u0006Ia\u001e\u0005\ty*\u0011\t\u0011)A\u00053\"Q\u0011q\f\u0006\u0003\u0002\u0003\u0006I!!\u0019\t\r1TA\u0011AA4\u0011%\t)H\u0003b\u0001\n\u0013\t9\b\u0003\u0005\u0002\u0000)\u0001\u000b\u0011BA=\u0011%\t\tI\u0003b\u0001\n\u0013\t\u0019\tC\u0004\u0002\u0006*\u0001\u000b\u0011B@\t\u0017\u0005\u001d%\u00021AA\u0002\u0013%\u0011\u0011\u0012\u0005\f\u0003\u0017S\u0001\u0019!a\u0001\n\u0013\ti\t\u0003\u0006\u0002\u001a*\u0001\r\u0011!Q!\n]D\u0011\"a'\u000b\u0001\u0004%I!!(\t\u0013\u0005}%\u00021A\u0005\n\u0005\u0005\u0006bBAS\u0015\u0001\u0006K!\u001a\u0005\t\u0003OS\u0001\u0015\"\u0015\u0002*\"9\u00111\u0016\u0006\u0005B\u0005u\u0005bBAW\u0015\u0011\u0005\u0013q\u0016\u0005\b\u0003cSA\u0011BAX\r\u0019\t\u0019\f\u0001\u0003\u00026\"I\u00111\u0002\u0010\u0003\u0002\u0003\u0006Ia\u001e\u0005\tyz\u0011\t\u0011)A\u00053\"Q\u0011q\f\u0010\u0003\u0002\u0003\u0006I!!\u0019\t\r1tB\u0011AA\\\u0011!\t9K\bQ\u0005R\u0005%\u0006bBAV=\u0011\u0005\u0013Q\u0014\u0005\b\u0003[sB\u0011IAX\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!!6\u0001\t#\n9\u000eC\u0004\u0002`\u0002!I!!9\u0003'\u0005\u00137\u000f\u001e:bGRdu.\u00193D'Z\u0003\u0016\u000e]3\u000b\u0005-b\u0013!\u00029ja\u0016\u001c(BA\u0017/\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005=\u0002\u0014a\u0002:v]RLW.\u001a\u0006\u0003cI\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003gQ\naaY=qQ\u0016\u0014(BA\u001b7\u0003\u0015qWm\u001c\u001bk\u0015\u00059\u0014aA8sO\u000e\u00011C\u0001\u0001;!\tYD(D\u0001+\u0013\ti$F\u0001\bQSB,w+\u001b;i'>,(oY3\u0002\rM|WO]2f!\tY\u0004)\u0003\u0002BU\t!\u0001+\u001b9f\u0003\u00191wN]7biB\u0011AiR\u0007\u0002\u000b*\u0011a\tM\u0001\u0003SJL!\u0001S#\u0003\u0013\r\u001bfKR8s[\u0006$\u0018!D;sY\u0016C\bO]3tg&|g\u000e\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tyE&\u0001\u0005d_6l\u0017M\u001c3t\u0013\t\tFJ\u0001\u0006FqB\u0014Xm]:j_:\fqBZ5fY\u0012$VM]7j]\u0006$xN\u001d\t\u0004)^KV\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r=\u0003H/[8o!\tQ\u0016M\u0004\u0002\\?B\u0011A,V\u0007\u0002;*\u0011a\fO\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001,\u0016A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001Y+\u0002-1,w-Y2z\u0007N4\u0018+^8uK\u0016\u001b8-\u00199j]\u001e\u0004\"\u0001\u00164\n\u0005\u001d,&a\u0002\"p_2,\u0017M\\\u0001\u000bEV4g-\u001a:TSj,\u0007C\u0001+k\u0013\tYWKA\u0002J]R\fa\u0001P5oSRtDc\u00028paF\u00148\u000f\u001e\t\u0003w\u0001AQAP\u0004A\u0002}BQAQ\u0004A\u0002\rCQ!S\u0004A\u0002)CQAU\u0004A\u0002MCQ\u0001Z\u0004A\u0002\u0015DQ\u0001[\u0004A\u0002%\f\u0001b\u001e:ji\u0016\u0014vn\u001e\u000b\nonl\u0018QAA\u0005\u0003\u001b\u0001\"\u0001_=\u000e\u00039J!A\u001f\u0018\u0003\u0013\rK\b\u000f[3s%><\b\"\u0002?\t\u0001\u0004I\u0016\u0001\u00034jY\u0016t\u0017-\\3\t\u000byD\u0001\u0019A@\u0002\u00151Lg.\u001a8v[\n,'\u000fE\u0002U\u0003\u0003I1!a\u0001V\u0005\u0011auN\\4\t\r\u0005\u001d\u0001\u00021\u0001f\u0003\u0011a\u0017m\u001d;\t\r\u0005-\u0001\u00021\u0001x\u0003-\t'oZ;nK:$(k\\<\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012\u0005)a/\u00197vKB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018Q\naA^1mk\u0016\u001c\u0018\u0002BA\u000e\u0003+\u0011\u0001\"\u00118z-\u0006dW/Z\u0001\rO\u0016$\u0018*\u001c9peR,&\u000b\u0014\u000b\u0005\u0003C\t\t\u0004\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u00079,GO\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\u0011\ty#!\n\u0003\u0007U\u0013F\n\u0003\u0004\u00024%\u0001\r!W\u0001\nkJd7\u000b\u001e:j]\u001e\u00141#\u0013;fe\u0006$xN],ji\"DU-\u00193feN\u001c2ACA\u001d!\u0011A\u00181H<\n\u0007\u0005ubFA\bDY>\u001c\u0018N\\4Ji\u0016\u0014\u0018\r^8s\u0003\u001dAW-\u00193feN\u0004b!a\u0011\u0002N\u0005Mc\u0002BA#\u0003\u0013r1\u0001XA$\u0013\u00051\u0016bAA&+\u00069\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u00121aU3r\u0015\r\tY%\u0016\t\u0005\u0003+\nY&\u0004\u0002\u0002X)!\u0011\u0011LA\u000b\u0003!\u0019Ho\u001c:bE2,\u0017\u0002BA/\u0003/\u0012QAV1mk\u0016\fQ!\u001b8oKJ\u00042aOA2\u0013\r\t)G\u000b\u0002\u0010\u0019>\fGmQ:w\u0013R,'/\u0019;peRQ\u0011\u0011NA7\u0003_\n\t(a\u001d\u0011\u0007\u0005-$\"D\u0001\u0001\u0011\u001d\tyd\u0004a\u0001\u0003\u0003Ba!a\u0003\u0010\u0001\u00049\b\"\u0002?\u0010\u0001\u0004I\u0006bBA0\u001f\u0001\u0007\u0011\u0011M\u0001\fS:$XM\u001d8bY6\u000b\u0007/\u0006\u0002\u0002zA1\u00010a\u001fZ\u0003#I1!! /\u00059\t%O]1z\u0005\u0006\u001c7.\u001a3NCB\fA\"\u001b8uKJt\u0017\r\\'ba\u0002\nq\"\u001b8uKJt\u0017\r\\'baNK'0Z\u000b\u0002\u007f\u0006\u0001\u0012N\u001c;fe:\fG.T1q'&TX\rI\u0001\u0007]\u0016<(k\\<\u0016\u0003]\f!B\\3x%><x\fJ3r)\u0011\ty)!&\u0011\u0007Q\u000b\t*C\u0002\u0002\u0014V\u0013A!\u00168ji\"A\u0011qS\u000b\u0002\u0002\u0003\u0007q/A\u0002yIE\nqA\\3x%><\b%A\u0006oK\u0016$7/\u00169eCR,W#A3\u0002\u001f9,W\rZ:Va\u0012\fG/Z0%KF$B!a$\u0002$\"A\u0011q\u0013\r\u0002\u0002\u0003\u0007Q-\u0001\u0007oK\u0016$7/\u00169eCR,\u0007%A\u0005dY>\u001cX-T8sKR\u0011\u0011qR\u0001\rS:tWM\u001d%bg:+\u0007\u0010^\u0001\u0005]\u0016DH\u000fF\u0001x\u00039\u0019w.\u001c9vi\u0016tU\r\u001f;S_^\u0014a#\u0013;fe\u0006$xN],ji\"|W\u000f\u001e%fC\u0012,'o]\n\u0004=\u0005eB\u0003CA]\u0003w\u000bi,a0\u0011\u0007\u0005-d\u0004\u0003\u0004\u0002\f\t\u0002\ra\u001e\u0005\u0006y\n\u0002\r!\u0017\u0005\b\u0003?\u0012\u0003\u0019AA1\u0003I9W\r\u001e'pC\u0012\u001c5KV%uKJ\fGo\u001c:\u0015\u0011\u0005\u0005\u0014QYAh\u0003#Dq!a2'\u0001\u0004\tI-A\u0003ti\u0006$X\rE\u0002<\u0003\u0017L1!!4+\u0005)\tV/\u001a:z'R\fG/\u001a\u0005\u0007\u0003g1\u0003\u0019A-\t\r\u0005Mg\u00051\u0001f\u0003))8/\u001a%fC\u0012,'o]\u0001\u0016S:$XM\u001d8bY\u000e\u0013X-\u0019;f%\u0016\u001cX\u000f\u001c;t)\u0019\tI$!7\u0002^\"9\u00111\\\u0014A\u0002\u0005e\u0012!B5oaV$\bbBAdO\u0001\u0007\u0011\u0011Z\u0001\u0010e\u0016\u0004H.Y2f\u001d>4\u0016\r\\;fgR!\u00111]Au!\u0019\t\u0019%!:\u0002T%!\u0011q]A)\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0005\b\u0003\u007fA\u0003\u0019AAr\u0001")
public abstract class AbstractLoadCSVPipe
extends PipeWithSource {
    private final CSVFormat format;
    private final Expression urlExpression;
    private final Option<String> fieldTerminator;
    private final boolean legacyCsvQuoteEscaping;
    private final int bufferSize;

    public abstract CypherRow writeRow(String var1, long var2, boolean var4, CypherRow var5, AnyValue var6);

    public URL getImportURL(String urlString) {
        URL uRL;
        try {
            uRL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new LoadExternalResourceException("Invalid URL '" + urlString + "': " + e.getMessage(), (Throwable)e);
        }
        return uRL;
    }

    private LoadCsvIterator getLoadCSVIterator(QueryState state, String urlString, boolean useHeaders) {
        return state.resources().getCsvIterator(urlString, state.query(), this.fieldTerminator, this.legacyCsvQuoteEscaping, this.bufferSize, useHeaders);
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        return input.flatMap((Function1 & Serializable)row -> {
            String urlString = ((TextValue)$this.urlExpression.apply((ReadableRow)row, state)).stringValue();
            CSVFormat cSVFormat = $this.format;
            if (HasHeaders$.MODULE$.equals(cSVFormat)) {
                LoadCsvIterator iterator = this.getLoadCSVIterator(state, urlString, true);
                IndexedSeq headers = ((ClosingIterator)iterator).nonEmpty() ? ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((ClosingIterator)iterator).next())) : (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
                return new IteratorWithHeaders(this, (Seq<Value>)this.replaceNoValues((IndexedSeq<Value>)headers), (CypherRow)row, this.getImportURL(urlString).getFile(), iterator);
            }
            if (NoHeaders$.MODULE$.equals(cSVFormat)) {
                return new IteratorWithoutHeaders(this, (CypherRow)row, this.getImportURL(urlString).getFile(), this.getLoadCSVIterator(state, urlString, false));
            }
            throw new MatchError((Object)cSVFormat);
        });
    }

    private IndexedSeq<Value> replaceNoValues(IndexedSeq<Value> headers) {
        return (IndexedSeq)headers.map((Function1 & Serializable)x0$1 -> {
            Value value = x0$1;
            if (value == Values.NO_VALUE) {
                return Values.stringValue((String)"");
            }
            return value;
        });
    }

    public AbstractLoadCSVPipe(Pipe source, CSVFormat format, Expression urlExpression, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize) {
        this.format = format;
        this.urlExpression = urlExpression;
        this.fieldTerminator = fieldTerminator;
        this.legacyCsvQuoteEscaping = legacyCsvQuoteEscaping;
        this.bufferSize = bufferSize;
        super(source);
    }

    private class IteratorWithHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        private final ArrayBackedMap<String, AnyValue> internalMap;
        private final long internalMapSize;
        private CypherRow newRow;
        private boolean needsUpdate;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        private ArrayBackedMap<String, AnyValue> internalMap() {
            return this.internalMap;
        }

        private long internalMapSize() {
            return this.internalMapSize;
        }

        private CypherRow newRow() {
            return this.newRow;
        }

        private void newRow_$eq(CypherRow x$1) {
            this.newRow = x$1;
        }

        private boolean needsUpdate() {
            return this.needsUpdate;
        }

        private void needsUpdate_$eq(boolean x$1) {
            this.needsUpdate = x$1;
        }

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            if (this.needsUpdate()) {
                this.newRow_$eq(this.computeNextRow());
                this.needsUpdate_$eq(false);
            }
            return this.newRow() != null;
        }

        public CypherRow next() {
            Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
            this.needsUpdate_$eq(true);
            return this.newRow();
        }

        private CypherRow computeNextRow() {
            if (((ClosingIterator)this.inner).hasNext()) {
                Value[] row = (Value[])((ClosingIterator)this.inner).next();
                this.internalMap().putValues((Object)((AnyValue[])row));
                java.util.Map internalMapCopy = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.internalMap().copy()).asJava();
                long payloadSize = 0L;
                for (int i = 0; i < row.length; ++i) {
                    payloadSize += row[i].estimatedHeapUsage();
                }
                MapValue mapValue = VirtualValues.fromMap((java.util.Map)internalMapCopy, (long)this.internalMapSize(), (long)payloadSize);
                return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)mapValue);
            }
            return null;
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithHeaders(AbstractLoadCSVPipe $outer, Seq<Value> headers, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.internalMap = new ArrayBackedMap(((IterableOnceOps)((IterableOps)headers.map((Function1 & Serializable)a -> {
                if (a == Values.NO_VALUE) {
                    return null;
                }
                return ((TextValue)a).stringValue();
            })).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Values.NO_VALUE, ClassTag$.MODULE$.apply(AnyValue.class));
            this.internalMapSize = ArrayBackedMap$.MODULE$.SHALLOW_SIZE() + HeapEstimator.shallowSizeOfObjectArray((int)headers.size());
            this.needsUpdate = true;
        }
    }

    private class IteratorWithoutHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            return ((ClosingIterator)this.inner).hasNext();
        }

        public CypherRow next() {
            ListValue value = VirtualValues.list((AnyValue[])((AnyValue[])((ClosingIterator)this.inner).next()));
            return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)value);
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithoutHeaders(AbstractLoadCSVPipe $outer, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

