/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.csv.reader.BufferOverflowException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResources$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%q!B\b\u0011\u0011\u0003ib!B\u0010\u0011\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u0007]\u0005\u0001\u000b\u0011B\u0016\t\u000f=\n!\u0019!C\u0001a!1A'\u0001Q\u0001\nEBq!N\u0001C\u0002\u0013\u0005!\u0006\u0003\u00047\u0003\u0001\u0006Ia\u000b\u0005\u0006o\u0005!I\u0001\u000f\u0004\u0005?A\u0001\u0001\n\u0003\u0005P\u0015\t\u0005\t\u0015!\u0003Q\u0011\u00159#\u0002\"\u0001U\u0011\u00159&\u0002\"\u0011Y\u0011\u001dA(\"%A\u0005\u0002e\fAbQ*W%\u0016\u001cx.\u001e:dKNT!!\u0005\n\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003'Q\tqA];oi&lWM\u0003\u0002\u0016-\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00181\u000511-\u001f9iKJT!!\u0007\u000e\u0002\u000b9,w\u000e\u000e6\u000b\u0003m\t1a\u001c:h\u0007\u0001\u0001\"AH\u0001\u000e\u0003A\u0011AbQ*W%\u0016\u001cx.\u001e:dKN\u001c\"!A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ$\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`\r&+E\nR0U\u000bJk\u0015JT!U\u001fJ+\u0012a\u000b\t\u0003E1J!!L\u0012\u0003\t\rC\u0017M]\u0001\u001a\t\u00163\u0015)\u0016'U?\u001aKU\t\u0014#`)\u0016\u0013V*\u0013(B)>\u0013\u0006%A\nE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV)F\u00012!\t\u0011#'\u0003\u00024G\t\u0019\u0011J\u001c;\u0002)\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#!\u0003I!UIR!V\u0019R{\u0016+V(U\u000b~\u001b\u0005*\u0011*\u0002'\u0011+e)Q+M)~\u000bVk\u0014+F?\u000eC\u0015I\u0015\u0011\u0002\r\r|gNZ5h)\rI\u0014I\u0012\t\u0003u}j\u0011a\u000f\u0006\u0003yu\naA]3bI\u0016\u0014(B\u0001 \u0019\u0003\r\u00197O^\u0005\u0003\u0001n\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002\"\n\u0001\u0004\u0019\u0015A\u00067fO\u0006\u001c\u0017pQ:w#V|G/Z#tG\u0006\u0004\u0018N\\4\u0011\u0005\t\"\u0015BA#$\u0005\u001d\u0011un\u001c7fC:DQaR\u0005A\u0002E\nQbY:w\u0005V4g-\u001a:TSj,7c\u0001\u0006\"\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A\nE\u0001\u0006a&\u0004Xm]\u0005\u0003\u001d.\u00131#\u0012=uKJt\u0017\r\\\"T-J+7o\\;sG\u0016\fqB]3t_V\u00148-Z'b]\u0006<WM\u001d\t\u0003#Jk\u0011AE\u0005\u0003'J\u0011qBU3t_V\u00148-Z'b]\u0006<WM\u001d\u000b\u0003+Z\u0003\"A\b\u0006\t\u000b=c\u0001\u0019\u0001)\u0002\u001d\u001d,GoQ:w\u0013R,'/\u0019;peR9\u0011\fX5ogR4\bC\u0001&[\u0013\tY6JA\bM_\u0006$7i\u001d<Ji\u0016\u0014\u0018\r^8s\u0011\u0015iV\u00021\u0001_\u0003%)(\u000f\\*ue&tw\r\u0005\u0002`M:\u0011\u0001\r\u001a\t\u0003C\u000ej\u0011A\u0019\u0006\u0003Gr\ta\u0001\u0010:p_Rt\u0014BA3$\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u001c\u0003\"\u00026\u000e\u0001\u0004Y\u0017!B9vKJL\bCA)m\u0013\ti'C\u0001\u0007Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000fC\u0003p\u001b\u0001\u0007\u0001/A\bgS\u0016dG\rV3s[&t\u0017\r^8s!\r\u0011\u0013OX\u0005\u0003e\u000e\u0012aa\u00149uS>t\u0007\"\u0002\"\u000e\u0001\u0004\u0019\u0005\"B;\u000e\u0001\u0004\t\u0014A\u00032vM\u001a,'oU5{K\"9q/\u0004I\u0001\u0002\u0004\u0019\u0015a\u00025fC\u0012,'o]\u0001\u0019O\u0016$8i\u001d<Ji\u0016\u0014\u0018\r^8sI\u0011,g-Y;mi\u00122T#\u0001>+\u0005\r[8&\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0001$\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000fq(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class CSVResources
implements ExternalCSVResource {
    private final ResourceManager resourceManager;

    public static char DEFAULT_QUOTE_CHAR() {
        return CSVResources$.MODULE$.DEFAULT_QUOTE_CHAR();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return CSVResources$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static char DEFAULT_FIELD_TERMINATOR() {
        return CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR();
    }

    @Override
    public LoadCsvIterator getCsvIterator(String urlString, QueryContext query, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URI uri = new URI(urlString);
            return new Tuple2((Object)uri, (Object)query.getImportDataConnection(uri));
        });
        if (!(try_ instanceof Success)) {
            Throwable error;
            Throwable error2;
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable error3 = failure.exception();
                if (error3 instanceof AuthorizationViolationException) {
                    AuthorizationViolationException authorizationViolationException = (AuthorizationViolationException)error3;
                    throw authorizationViolationException;
                }
            }
            if (bl && (error2 = failure.exception()) instanceof URISyntaxException) {
                URISyntaxException uRISyntaxException = (URISyntaxException)error2;
                throw LoadExternalResourceException.invalidUrl((String)urlString, (Throwable)uRISyntaxException);
            }
            if (bl && (error = failure.exception()) instanceof URLAccessValidationError) {
                URLAccessValidationError uRLAccessValidationError = (URLAccessValidationError)error;
                if (uRLAccessValidationError.getMessage().contains("unknown protocol:")) {
                    throw LoadExternalResourceException.withInnerErrorMessage((String)urlString, (Throwable)uRLAccessValidationError);
                }
                throw LoadExternalResourceException.cannotLoadFromUrl((String)urlString, (Throwable)uRLAccessValidationError);
            }
            if (bl) {
                Throwable error4 = failure.exception();
                throw LoadExternalResourceException.cannotLoadFromUrl((String)urlString, (Throwable)error4);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tuple2 readable = (Tuple2)success.value();
        Tuple2 tuple2 = readable;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        URI uri = (URI)tuple2._1();
        CharReadable reader = (CharReadable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)uri, (Object)reader);
        URI uri2 = (URI)tuple22._1();
        CharReadable reader2 = (CharReadable)tuple22._2();
        char delimiter = BoxesRunTime.unboxToChar((Object)fieldTerminator.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)x$2.charAt(0))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable)() -> CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR()));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)reader2, (Configuration)CSVResources$.MODULE$.org$neo4j$cypher$internal$runtime$interpreted$CSVResources$$config(legacyCsvQuoteEscaping, bufferSize), (boolean)false);
        Extractor extractor = new Extractors(delimiter).textValue();
        char intDelimiter = delimiter;
        Mark mark = new Mark();
        CSVResource resource = new CSVResource(uri2, (AutoCloseable)seeker);
        this.resourceManager.trace((AutoCloseablePlus)resource);
        return new LoadCsvIterator(null, resource, seeker, mark, intDelimiter, extractor){
            private long lastProcessed;
            private boolean readAll;
            private Value[] nextRow;
            private final CSVResource resource$1;
            private final CharSeeker seeker$1;
            private final Mark mark$1;
            private final int intDelimiter$1;
            private final Extractor extractor$1;

            public long lastProcessed() {
                return this.lastProcessed;
            }

            private void lastProcessed_$eq(long x$1) {
                this.lastProcessed = x$1;
            }

            public boolean readAll() {
                return this.readAll;
            }

            private void readAll_$eq(boolean x$1) {
                this.readAll = x$1;
            }

            public void closeMore() {
                this.resource$1.close();
            }

            private Value[] readNextRow() {
                ArrayBuffer buffer = new ArrayBuffer();
                try {
                    while (this.seeker$1.seek(this.mark$1, this.intDelimiter$1)) {
                        Value value = (Value)this.seeker$1.tryExtract(this.mark$1, this.extractor$1);
                        buffer.$plus$eq((Object)(!this.extractor$1.isEmpty((Object)value) ? value : Values.NO_VALUE));
                        if (!this.mark$1.isEndOfLine()) continue;
                        if (buffer.isEmpty()) {
                            return null;
                        }
                        return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
                    }
                }
                catch (BufferOverflowException e) {
                    throw CypherExecutionException.csvBufferSizeOverflow((Throwable)e);
                }
                if (buffer.isEmpty()) {
                    return null;
                }
                return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
            }

            private Value[] nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(Value[] x$1) {
                this.nextRow = x$1;
            }

            public boolean innerHasNext() {
                return this.nextRow() != null;
            }

            public Value[] next() {
                Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
                Value[] row = this.nextRow();
                this.nextRow_$eq(this.readNextRow());
                this.lastProcessed_$eq(this.lastProcessed() + 1L);
                this.readAll_$eq(!this.hasNext());
                return row;
            }
            {
                this.resource$1 = resource$1;
                this.seeker$1 = seeker$1;
                this.mark$1 = mark$1;
                this.intDelimiter$1 = intDelimiter$1;
                this.extractor$1 = extractor$1;
                this.lastProcessed = 0L;
                this.readAll = false;
                this.nextRow = this.readNextRow();
            }
        };
    }

    @Override
    public boolean getCsvIterator$default$6() {
        return false;
    }

    public CSVResources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

