/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowIndexType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowIndexesCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexSettingsValidator;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;

public final class ShowIndexesCommand$
implements Serializable {
    public static final ShowIndexesCommand$ MODULE$ = new ShowIndexesCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowIndexesCommand$$createIndexStatement(String name, IndexType indexType, EntityType entityType, List<String> labelsOrTypes, List<String> properties, IndexProviderDescriptor provider, IndexConfig indexConfig, Option<ConstraintDescriptor> maybeConstraint, boolean returnCypher5Values) {
        String providerName = provider.name();
        IndexType indexType2 = indexType;
        if (IndexType.RANGE.equals(indexType2)) {
            ConstraintDescriptor constraint;
            ConstraintDescriptor constraint2;
            ConstraintDescriptor constraint3;
            boolean bl = false;
            Some some = null;
            Option<ConstraintDescriptor> option = maybeConstraint;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ConstraintDescriptor constraint4 = (ConstraintDescriptor)some.value();
                if (constraint4.isNodeUniquenessConstraint()) {
                    return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
                }
            }
            if (bl && (constraint3 = (ConstraintDescriptor)some.value()).isRelationshipUniquenessConstraint()) {
                return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
            }
            if (bl && (constraint2 = (ConstraintDescriptor)some.value()).isNodeKeyConstraint()) {
                String predicate = returnCypher5Values ? "IS NODE KEY" : "IS KEY";
                return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, predicate);
            }
            if (bl && (constraint = (ConstraintDescriptor)some.value()).isRelationshipKeyConstraint()) {
                String predicate = returnCypher5Values ? "IS RELATIONSHIP KEY" : "IS KEY";
                return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, predicate);
            }
            if (bl) {
                throw new IllegalArgumentException("Expected an index or index backed constraint, found another constraint.");
            }
            if (None$.MODULE$.equals(option)) {
                EntityType entityType2 = entityType;
                if (EntityType.NODE.equals(entityType2)) {
                    return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("RANGE", name, labelsOrTypes, properties, ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand$default$5());
                }
                if (EntityType.RELATIONSHIP.equals(entityType2)) {
                    return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("RANGE", name, labelsOrTypes, properties, ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand$default$5());
                }
                throw new IllegalArgumentException("Did not recognize entity type " + entityType);
            }
            throw new MatchError(option);
        }
        if (IndexType.FULLTEXT.equals(indexType2)) {
            String labelsOrTypesWithBars = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.barStringJoiner());
            String fulltextConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig);
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, fulltextConfig);
            EntityType entityType3 = entityType;
            if (EntityType.NODE.equals(entityType3)) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("FULLTEXT", name, "(n" + labelsOrTypesWithBars + ")", "EACH [" + escapedNodeProperties + "]", (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType3)) {
                String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("FULLTEXT", name, "()-[r" + labelsOrTypesWithBars + "]-()", "EACH [" + escapedRelProperties + "]", (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.TEXT.equals(indexType2)) {
            String optionsString = "{indexConfig: {}, indexProvider: '" + providerName + "'}";
            EntityType entityType4 = entityType;
            if (EntityType.NODE.equals(entityType4)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("TEXT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType4)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("TEXT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.POINT.equals(indexType2)) {
            String pointConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig);
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, pointConfig);
            EntityType entityType5 = entityType;
            if (EntityType.NODE.equals(entityType5)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("POINT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType5)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("POINT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.VECTOR.equals(indexType2)) {
            VectorIndexSettingsValidator settingsValidator = VectorIndexVersion.fromDescriptor((IndexProviderDescriptor)provider).indexSettingValidator();
            VectorIndexConfig vectorIndexConfig = settingsValidator.trustIsValidToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(indexConfig));
            String vectorConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(vectorIndexConfig.config());
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, vectorConfig);
            EntityType entityType6 = entityType;
            if (EntityType.NODE.equals(entityType6)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("VECTOR", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType6)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("VECTOR", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.LOOKUP.equals(indexType2)) {
            EntityType entityType7 = entityType;
            if (EntityType.NODE.equals(entityType7)) {
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("LOOKUP", name, "(n)", "EACH labels(n)", ShowSchemaCommandHelper$.MODULE$.createIndexCommand$default$5());
            }
            if (EntityType.RELATIONSHIP.equals(entityType7)) {
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("LOOKUP", name, "()-[r]-()", "EACH type(r)", ShowSchemaCommandHelper$.MODULE$.createIndexCommand$default$5());
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        throw new IllegalArgumentException("Did not recognize index type " + indexType);
    }

    public ShowIndexesCommand apply(ShowIndexType indexType, List<ShowColumn> columns, List<CommandResultItem> yieldColumns, CypherVersion cypherVersion) {
        return new ShowIndexesCommand(indexType, columns, yieldColumns, cypherVersion);
    }

    public Option<Tuple4<ShowIndexType, List<ShowColumn>, List<CommandResultItem>, CypherVersion>> unapply(ShowIndexesCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.indexType(), x$0.columns(), x$0.yieldColumns(), (Object)x$0.cypherVersion()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowIndexesCommand$.class);
    }

    private ShowIndexesCommand$() {
    }
}

