/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.PercentileContFunction$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.PercentileDiscFunction$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.PercentileFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.PercentilesFunction$;
import org.neo4j.cypher.operations.CypherCoercions;
import org.neo4j.cypher.operations.CypherFunctions;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000e\u001c\u00011B\u0011\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u001e\t\u0011m\u0002!\u0011!Q\u0001\nIB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005e!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"Ia\u000f\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\no\u0002\u0001\r\u00111A\u0005\naD1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Q\u00111\u0002\u0001A\u0002\u0003\u0005\u000b\u0015B=\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002 \u0001\u0001\r\u0011!Q!\n\u0005E\u0001\"CA\u0011\u0001\t\u0007I\u0011IA\u0012\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\u0015\u0002bBA\u001b\u0001\u0011E\u0013q\u0007\u0005\b\u0003#\u0002A\u0011IA*\u000f\u001d\t\u0019g\u0007E\u0001\u0003K2aAG\u000e\t\u0002\u0005\u001d\u0004BB.\u0017\t\u0003\ty\u0007C\u0005\u0002rY\u0011\r\u0011\"\u0001\u0002t!A\u00111\u0010\f!\u0002\u0013\t)HA\nQKJ\u001cWM\u001c;jY\u0016\u001ch)\u001e8di&|gN\u0003\u0002\u001d;\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\tqr$A\u0003qSB,7O\u0003\u0002!C\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t\u00113%A\u0004sk:$\u0018.\\3\u000b\u0005\u0011*\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0019:\u0013AB2za\",'O\u0003\u0002)S\u0005)a.Z85U*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001[A\u0011afL\u0007\u00027%\u0011\u0001g\u0007\u0002\u0013!\u0016\u00148-\u001a8uS2,g)\u001e8di&|g.A\u0003wC2,X\r\u0005\u00024q5\tAG\u0003\u00026m\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9t$\u0001\u0005d_6l\u0017M\u001c3t\u0013\tIDG\u0001\u0006FqB\u0014Xm]:j_:L!!M\u0018\u0002\u0017A,'oY3oi&dWm]\u0001\u0005W\u0016L8/A\bjg\u0012K7o\u0019:fi\u0016\u0014\u0016M\\4f\u00035iW-\\8ssR\u0013\u0018mY6feB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iJ\u0001\u0007[\u0016lwN]=\n\u0005\u0011\u000b%!D'f[>\u0014\u0018\u0010\u0016:bG.,'/A\u0003pe\u0012,'\u000f\u0005\u0002H1:\u0011\u0001*\u0016\b\u0003\u0013Rs!AS*\u000f\u0005-\u0013fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty5&\u0001\u0004=e>|GOP\u0005\u0002U%\u0011\u0001&K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0005U\u001a\u0013B\u0001,X\u0003I1UO\\2uS>t\u0017J\u001c<pG\u0006$\u0018n\u001c8\u000b\u0005U\u001a\u0013BA-[\u00055\t%oZ;nK:$xJ\u001d3fe*\u0011akV\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fusv\fY1cGB\u0011a\u0006\u0001\u0005\u0006c\u001d\u0001\rA\r\u0005\u0006w\u001d\u0001\rA\r\u0005\u0006y\u001d\u0001\rA\r\u0005\u0006{\u001d\u0001\rA\r\u0005\u0006}\u001d\u0001\ra\u0010\u0005\u0006\u000b\u001e\u0001\rAR\u0001\u0006a\u0016\u00148m]\u000b\u0002MB\u0019qM\u001b7\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014Q!\u0011:sCf\u0004\"aZ7\n\u00059D'A\u0002#pk\ndW-A\u0005qKJ\u001c7o\u0018\u0013fcR\u0011\u0011\u000f\u001e\t\u0003OJL!a\u001d5\u0003\tUs\u0017\u000e\u001e\u0005\bk&\t\t\u00111\u0001g\u0003\rAH%M\u0001\u0007a\u0016\u00148m\u001d\u0011\u0002\u000f5\f\u0007oS3zgV\t\u0011\u0010E\u0002hUj\u0004\"a_@\u000f\u0005ql\bCA'i\u0013\tq\b.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0004TiJLgn\u001a\u0006\u0003}\"\f1\"\\1q\u0017\u0016L8o\u0018\u0013fcR\u0019\u0011/!\u0003\t\u000fUd\u0011\u0011!a\u0001s\u0006AQ.\u00199LKf\u001c\b%A\u0006jg\u0012K7o\u0019:fi\u0016\u001cXCAA\t!\u00119'.a\u0005\u0011\u0007\u001d\f)\"C\u0002\u0002\u0018!\u0014qAQ8pY\u0016\fg.A\bjg\u0012K7o\u0019:fi\u0016\u001cx\fJ3r)\r\t\u0018Q\u0004\u0005\tk>\t\t\u00111\u0001\u0002\u0012\u0005a\u0011n\u001d#jg\u000e\u0014X\r^3tA\u0005!a.Y7f+\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\t1\fgn\u001a\u0006\u0003\u0003_\tAA[1wC&!\u0011\u0011AA\u0015\u0003\u0015q\u0017-\\3!\u0003)ygNR5sgR\u0014vn\u001e\u000b\u0006c\u0006e\u0012Q\t\u0005\b\u0003w\u0019\u0002\u0019AA\u001f\u0003\u0011!\u0017\r^1\u0011\t\u0005}\u0012\u0011I\u0007\u0002C%\u0019\u00111I\u0011\u0003\u0017I+\u0017\rZ1cY\u0016\u0014vn\u001e\u0005\b\u0003\u000f\u001a\u0002\u0019AA%\u0003\u0015\u0019H/\u0019;f!\u0011\tY%!\u0014\u000e\u0003uI1!a\u0014\u001e\u0005)\tV/\u001a:z'R\fG/Z\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0015\t\u0005U\u0013\u0011\r\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L\u0014\u0002\rY\fG.^3t\u0013\u0011\ty&!\u0017\u0003\u0011\u0005s\u0017PV1mk\u0016Dq!a\u0012\u0015\u0001\u0004\tI%A\nQKJ\u001cWM\u001c;jY\u0016\u001ch)\u001e8di&|g\u000e\u0005\u0002/-M\u0019a#!\u001b\u0011\u0007\u001d\fY'C\u0002\u0002n!\u0014a!\u00118z%\u00164GCAA3\u00031\u0019\u0006*\u0011'M\u001f^{6+\u0013.F+\t\t)\bE\u0002h\u0003oJ1!!\u001fi\u0005\u0011auN\\4\u0002\u001bMC\u0015\t\u0014'P/~\u001b\u0016JW#!\u0001")
public class PercentilesFunction
extends PercentileFunction {
    private final Expression percentiles;
    private final Expression keys;
    private final Expression isDiscreteRange;
    private final MemoryTracker memoryTracker;
    private final FunctionInvocation.ArgumentOrder order;
    private double[] percs;
    private String[] mapKeys;
    private boolean[] isDiscretes;
    private final String name;

    public static long SHALLOW_SIZE() {
        return PercentilesFunction$.MODULE$.SHALLOW_SIZE();
    }

    private double[] percs() {
        return this.percs;
    }

    private void percs_$eq(double[] x$1) {
        this.percs = x$1;
    }

    private String[] mapKeys() {
        return this.mapKeys;
    }

    private void mapKeys_$eq(String[] x$1) {
        this.mapKeys = x$1;
    }

    private boolean[] isDiscretes() {
        return this.isDiscretes;
    }

    private void isDiscretes_$eq(boolean[] x$1) {
        this.isDiscretes = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void onFirstRow(ReadableRow data, QueryState state) {
        int i;
        SequenceValue percsValue = CypherCoercions.asSequenceValue((AnyValue)this.percentiles.apply(data, state));
        this.percs_$eq(new double[percsValue.intSize()]);
        for (i = 0; i < percsValue.intSize(); ++i) {
            double perc;
            this.percs()[i] = perc = CypherCoercions.asNumberValue((AnyValue)percsValue.value((long)i)).doubleValue();
            if (!(perc < 0.0) && !(perc > 1.0)) continue;
            throw InvalidArgumentException.invalidPercentage((double)perc);
        }
        SequenceValue keysValue = CypherCoercions.asSequenceValue((AnyValue)this.keys.apply(data, state));
        this.mapKeys_$eq(new String[keysValue.intSize()]);
        for (i = 0; i < this.mapKeys().length; ++i) {
            this.mapKeys()[i] = CypherFunctions.asTextValue((AnyValue)keysValue.value((long)i)).stringValue();
        }
        if (keysValue.intSize() != this.percs().length) {
            throw new InternalException("Expected 'percentiles' " + Predef$.MODULE$.wrapDoubleArray(this.percs()).mkString(",") + " and 'keys' " + Predef$.MODULE$.wrapRefArray((Object[])this.mapKeys()).mkString(",") + " to have the same length");
        }
        SequenceValue isDiscreteValues = CypherCoercions.asSequenceValue((AnyValue)this.isDiscreteRange.apply(data, state));
        this.isDiscretes_$eq(new boolean[isDiscreteValues.intSize()]);
        for (i = 0; i < this.isDiscretes().length; ++i) {
            this.isDiscretes()[i] = ((BooleanValue)isDiscreteValues.value((long)i)).booleanValue();
        }
        if (isDiscreteValues.intSize() != this.percs().length) {
            throw new InternalException("Expected 'percentiles' " + Predef$.MODULE$.wrapDoubleArray(this.percs()).mkString(",") + " and 'isDiscreteRange' " + Predef$.MODULE$.wrapBooleanArray(this.isDiscretes()).mkString(",") + " to have the same length");
        }
    }

    @Override
    public AnyValue result(QueryState state) {
        Value value;
        FunctionInvocation.ArgumentOrder argumentOrder = this.order;
        FunctionInvocation.ArgumentUnordered$ argumentUnordered$ = FunctionInvocation.ArgumentUnordered$.MODULE$;
        if (!(argumentOrder != null ? !argumentOrder.equals(argumentUnordered$) : argumentUnordered$ != null)) {
            this.temp().sort((o1, o2) -> Double.compare(o1.doubleValue(), o2.doubleValue()));
        }
        if (this.count() == 0) {
            value = Values.NO_VALUE;
        } else {
            MapValueBuilder mapBuilder = new MapValueBuilder(this.percs().length);
            for (int i = 0; i < this.percs().length; ++i) {
                double perc = this.percs()[i];
                String mapKey = this.mapKeys()[i];
                NumberValue percValue = this.isDiscretes()[i] ? PercentileDiscFunction$.MODULE$.computePercentileDisc(this.temp(), this.count(), perc, this.order) : PercentileContFunction$.MODULE$.computePercentileCont(this.temp(), this.count(), perc, this.order);
                mapBuilder.add(mapKey, (AnyValue)percValue);
            }
            value = mapBuilder.build();
        }
        Value result = value;
        this.temp().close();
        this.temp_$eq(null);
        this.memoryTracker.releaseHeap((long)this.count() * this.estimatedNumberValue());
        return result;
    }

    public PercentilesFunction(Expression value, Expression percentiles, Expression keys, Expression isDiscreteRange, MemoryTracker memoryTracker, FunctionInvocation.ArgumentOrder order) {
        this.percentiles = percentiles;
        this.keys = keys;
        this.isDiscreteRange = isDiscreteRange;
        this.memoryTracker = memoryTracker;
        this.order = order;
        super(value, memoryTracker);
        this.name = "PERCENTILES";
    }
}

