/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.converters;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.AnonymousPatternPart;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.NamedPatternPart;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.ParenthesizedPath;
import org.neo4j.cypher.internal.expressions.PathConcatenation;
import org.neo4j.cypher.internal.expressions.PathFactor;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.PatternPartWithSelector;
import org.neo4j.cypher.internal.expressions.QuantifiedPath;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.ShortestPathsPatternPart;
import org.neo4j.cypher.internal.expressions.SimplePattern;
import org.neo4j.cypher.internal.expressions.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.ExhaustivePathPattern;
import org.neo4j.cypher.internal.ir.NodeConnection;
import org.neo4j.cypher.internal.ir.PathPattern;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QuantifiedPathPattern;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.SelectivePathPattern;
import org.neo4j.cypher.internal.ir.ShortestRelationshipPattern;
import org.neo4j.cypher.internal.ir.converters.QuantifiedPathPatternConverters$;
import org.neo4j.cypher.internal.ir.converters.SimplePatternConverters$;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u000b\u0002!IA\u0012\u0005\u00069\u0002!I!\u0018\u0005\u0006s\u0002!IA\u001f\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002Z\u0001!I!a\u0017\u0003#A\u000bG\u000f^3s]\u000e{gN^3si\u0016\u00148O\u0003\u0002\u000f\u001f\u0005Q1m\u001c8wKJ$XM]:\u000b\u0005A\t\u0012AA5s\u0015\t\u00112#\u0001\u0005j]R,'O\\1m\u0015\t!R#\u0001\u0004dsBDWM\u001d\u0006\u0003-]\tQA\\3pi)T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017AH1o_:LXn\\;t-\u0006\u0014\u0018.\u00192mK:\u000bW.Z$f]\u0016\u0014\u0018\r^8s!\t\u0019c%D\u0001%\u0015\t)\u0013#\u0001\u0003vi&d\u0017BA\u0014%\u0005y\ten\u001c8z[>,8OV1sS\u0006\u0014G.\u001a(b[\u0016<UM\\3sCR|'/\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u00035AQ!\t\u0002A\u0002\t\nabY8om\u0016\u0014H\u000fU1ui\u0016\u0014h\u000e\u0006\u00020gA\u0011\u0001'M\u0007\u0002\u001f%\u0011!g\u0004\u0002\r!\u0006$\b\u000eU1ui\u0016\u0014hn\u001d\u0005\u0006i\r\u0001\r!N\u0001\ba\u0006$H/\u001a:o!\t1\u0014(D\u00018\u0015\tA\u0014#A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u001e8\u0005\u001d\u0001\u0016\r\u001e;fe:\f!cY8om\u0016\u0014H\u000fU1ui\u0016\u0014h\u000eU1siR\u0011Q\b\u0011\t\u0003ayJ!aP\b\u0003\u0017A\u000bG\u000f\u001b)biR,'O\u001c\u0005\u0006\u0003\u0012\u0001\rAQ\u0001\fa\u0006$H/\u001a:o!\u0006\u0014H\u000f\u0005\u00027\u0007&\u0011Ai\u000e\u0002\f!\u0006$H/\u001a:o!\u0006\u0014H/A\u000ed_:4XM\u001d;B]>t\u00170\\8vgB\u000bG\u000f^3s]B\u000b'\u000f\u001e\u000b\u0004{\u001d;\u0006\"\u0002%\u0006\u0001\u0004I\u0015\u0001\u00039bi\"t\u0015-\\3\u0011\u0007qQE*\u0003\u0002L;\t1q\n\u001d;j_:\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(\u001e\u001b\u0005\u0001&BA)\u001a\u0003\u0019a$o\\8u}%\u00111+H\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T;!)\u0001,\u0002a\u00013\u0006!\u0012M\\8os6|Wo\u001d)biR,'O\u001c)beR\u0004\"A\u000e.\n\u0005m;$\u0001F!o_:LXn\\;t!\u0006$H/\u001a:o!\u0006\u0014H/A\u0011d_:4XM\u001d;TQ>\u0014H/Z:u!\u0006$\b\u000eU1ui\u0016\u0014h.\u00127f[\u0016tG\u000fF\u0002_C\u001a\u0004\"\u0001M0\n\u0005\u0001|!\u0001F*fY\u0016\u001cG/\u001b<f!\u0006$\b\u000eU1ui\u0016\u0014h\u000eC\u0003c\r\u0001\u00071-\u0001\bqCR$XM\u001d8FY\u0016lWM\u001c;\u0011\u0005Y\"\u0017BA38\u00059\u0001\u0016\r\u001e;fe:,E.Z7f]RDQa\u001a\u0004A\u0002!\f\u0001b]3mK\u000e$xN\u001d\t\u0003SZt!A\u001b;\u000f\u0005-\u001chB\u00017s\u001d\ti\u0017O\u0004\u0002oa:\u0011qj\\\u0005\u00021%\u0011acF\u0005\u0003)UI!AE\n\n\u0005A\t\u0012BA;\u0010\u0003Q\u0019V\r\\3di&4X\rU1uQB\u000bG\u000f^3s]&\u0011q\u000f\u001f\u0002\t'\u0016dWm\u0019;pe*\u0011QoD\u0001\u001fG>tg/\u001a:u'\"|'\u000f^3tiB\u000bG\u000f\u001b)biR,'O\u001c)beR$RAX>~\u0003\u000fAQ\u0001`\u0004A\u0002\t\u000bA\u0001]1si\")ap\u0002a\u0001\u007f\u0006I\u0001O]3eS\u000e\fG/\u001a\t\u00059)\u000b\t\u0001E\u00027\u0003\u0007I1!!\u00028\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u0016G>tg/\u001a:u!\u0006$H/\u001a:o\u000b2,W.\u001a8u)\u0011\ti!!\u0007\u0011\u000bA\ny!a\u0005\n\u0007\u0005EqBA\u000bFq\"\fWo\u001d;jm\u0016\u0004\u0016\r\u001e5QCR$XM\u001d8\u0011\u0007A\n)\"C\u0002\u0002\u0018=\u0011aBT8eK\u000e{gN\\3di&|g\u000eC\u0003c\u0011\u0001\u00071-\u0001\nd_:4XM\u001d;QCRDg)Y2u_J\u001cH\u0003BA\u0007\u0003?Aq!!\t\n\u0001\u0004\t\u0019#A\u0004gC\u000e$xN]:\u0011\r\u0005\u0015\u0012qFA\u001b\u001d\u0011\t9#a\u000b\u000f\u0007=\u000bI#C\u0001\u001f\u0013\r\ti#H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t$a\r\u0003\t1K7\u000f\u001e\u0006\u0004\u0003[i\u0002c\u0001\u001c\u00028%\u0019\u0011\u0011H\u001c\u0003\u0015A\u000bG\u000f\u001b$bGR|'/A\u000bv]\u001a|G\u000e\u001a)bi\"4\u0015m\u0019;peN$\u0016-\u001b7\u0015\t\u0005}\u0012q\u000b\t\u0007\u0003K\t\t%!\u0012\n\t\u0005\r\u00131\u0007\u0002\t\u0019\u0006T\u0018\u0010T5tiB9A$a\u0012\u0002L\u0005E\u0013bAA%;\t1A+\u001e9mKJ\u00022ANA'\u0013\r\tye\u000e\u0002\u000f#V\fg\u000e^5gS\u0016$\u0007+\u0019;i!\r1\u00141K\u0005\u0004\u0003+:$!D*j[BdW\rU1ui\u0016\u0014h\u000eC\u0004\u0002\")\u0001\r!a\t\u0002!\t,\u0018\u000e\u001c3QCRD\u0007+\u0019;uKJtGCBA\u0007\u0003;\n\t\u0007C\u0004\u0002`-\u0001\r!!\u0015\u0002\t!,\u0017\r\u001a\u0005\b\u0003GZ\u0001\u0019AA \u0003\u0011!\u0018-\u001b7")
public class PatternConverters {
    private final AnonymousVariableNameGenerator anonymousVariableNameGenerator;

    public List convertPattern(Pattern pattern) {
        return pattern.patternParts().toList().map((Function1 & Serializable)patternPart -> this.convertPatternPart((PatternPart)patternPart));
    }

    private PathPattern convertPatternPart(PatternPart patternPart) {
        PatternPart patternPart2 = patternPart;
        if (patternPart2 instanceof NamedPatternPart) {
            NamedPatternPart namedPatternPart = (NamedPatternPart)patternPart2;
            Variable variable = namedPatternPart.variable();
            AnonymousPatternPart patternPart3 = namedPatternPart.patternPart();
            return this.convertAnonymousPatternPart((Option<String>)new Some((Object)variable.name()), patternPart3);
        }
        if (patternPart2 instanceof AnonymousPatternPart) {
            AnonymousPatternPart anonymousPatternPart = (AnonymousPatternPart)patternPart2;
            return this.convertAnonymousPatternPart((Option<String>)None$.MODULE$, anonymousPatternPart);
        }
        throw new MatchError((Object)patternPart2);
    }

    private PathPattern convertAnonymousPatternPart(Option<String> pathName, AnonymousPatternPart anonymousPatternPart) {
        AnonymousPatternPart anonymousPatternPart2 = anonymousPatternPart;
        if (anonymousPatternPart2 instanceof PatternPartWithSelector) {
            PatternPart.ShortestGroups shortestGroups;
            UnsignedDecimalIntegerLiteral count;
            PatternPart.AnyShortestPath anyShortestPath;
            UnsignedDecimalIntegerLiteral count2;
            PatternPart.AnyPath anyPath;
            UnsignedDecimalIntegerLiteral count3;
            PatternPartWithSelector patternPartWithSelector = (PatternPartWithSelector)anonymousPatternPart2;
            PatternElement element = patternPartWithSelector.element();
            PatternPart.Selector selector = patternPartWithSelector.selector();
            PatternPart.Selector selector2 = selector;
            if (selector2 instanceof PatternPart.AllPaths) {
                return this.convertPatternElement(element);
            }
            if (selector2 instanceof PatternPart.AnyPath && BoxesRunTime.equalsNumObject((Number)(count3 = (anyPath = (PatternPart.AnyPath)selector2).count()).value(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.Any(1));
            }
            if (selector2 instanceof PatternPart.AnyShortestPath && BoxesRunTime.equalsNumObject((Number)(count2 = (anyShortestPath = (PatternPart.AnyShortestPath)selector2).count()).value(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.Shortest(1));
            }
            if (selector2 instanceof PatternPart.AllShortestPaths) {
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.ShortestGroups(1));
            }
            if (selector2 instanceof PatternPart.ShortestGroups && BoxesRunTime.equalsNumObject((Number)(count = (shortestGroups = (PatternPart.ShortestGroups)selector2).count()).value(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.ShortestGroups(1));
            }
            throw new IllegalArgumentException("Path selector " + selector2.prettified() + " is not supported");
        }
        if (anonymousPatternPart2 instanceof ShortestPathsPatternPart) {
            ShortestPathsPatternPart shortestPathsPatternPart = (ShortestPathsPatternPart)anonymousPatternPart2;
            PatternElement element = shortestPathsPatternPart.element();
            boolean single = shortestPathsPatternPart.single();
            PatternElement patternElement = element;
            if (patternElement instanceof RelationshipChain) {
                RelationshipChain relationshipChain = (RelationshipChain)patternElement;
                SimplePattern leftNode = relationshipChain.element();
                RelationshipPattern relationship = relationshipChain.relationship();
                NodePattern rightNode = relationshipChain.rightNode();
                if (leftNode instanceof NodePattern) {
                    NodePattern nodePattern = (NodePattern)leftNode;
                    return new ShortestRelationshipPattern((Option<String>)new Some(pathName.getOrElse((Function0 & Serializable)() -> $this.anonymousVariableNameGenerator.nextName())), SimplePatternConverters$.MODULE$.makePatternRelationship(nodePattern, relationship, rightNode), single, shortestPathsPatternPart);
                }
            }
            throw new IllegalArgumentException(shortestPathsPatternPart.name() + "() must contain a single relationship, it cannot contain a " + patternElement.productPrefix());
        }
        throw new MatchError((Object)anonymousPatternPart2);
    }

    private SelectivePathPattern convertShortestPathPatternElement(PatternElement patternElement, SelectivePathPattern.Selector selector) {
        PatternElement patternElement2 = patternElement;
        if (patternElement2 instanceof ParenthesizedPath) {
            ParenthesizedPath parenthesizedPath = (ParenthesizedPath)patternElement2;
            PatternPart part = parenthesizedPath.part();
            Option predicate = parenthesizedPath.optionalWhereClause();
            return this.convertShortestPathPatternPart(part, (Option<Expression>)predicate, selector);
        }
        return new SelectivePathPattern(this.convertPatternElement(patternElement2), Selections$.MODULE$.empty(), selector);
    }

    private SelectivePathPattern convertShortestPathPatternPart(PatternPart part, Option<Expression> predicate, SelectivePathPattern.Selector selector) {
        PatternPart patternPart = part;
        if (patternPart instanceof PatternPartWithSelector) {
            PatternPartWithSelector patternPartWithSelector = (PatternPartWithSelector)patternPart;
            PatternElement element = patternPartWithSelector.element();
            PatternPart.Selector allPaths = patternPartWithSelector.selector();
            PatternPart.Selector selector2 = allPaths;
            if (selector2 instanceof PatternPart.AllPaths) {
                return new SelectivePathPattern(this.convertPatternElement(element), Selections$.MODULE$.from((Iterable<Expression>)Option$.MODULE$.option2Iterable(predicate)), selector);
            }
            throw new IllegalArgumentException("Path selectors such as " + selector2 + " cannot be nested");
        }
        if (patternPart instanceof ShortestPathsPatternPart) {
            ShortestPathsPatternPart shortestPathsPatternPart = (ShortestPathsPatternPart)patternPart;
            throw new IllegalArgumentException(shortestPathsPatternPart.name() + "() is not allowed inside of a parenthesised path pattern");
        }
        if (patternPart instanceof NamedPatternPart) {
            throw new IllegalArgumentException("Sub-path assignment is currently not supported");
        }
        throw new MatchError((Object)patternPart);
    }

    private ExhaustivePathPattern<NodeConnection> convertPatternElement(PatternElement patternElement) {
        PatternElement patternElement2 = patternElement;
        if (patternElement2 instanceof SimplePattern) {
            SimplePattern simplePattern = (SimplePattern)patternElement2;
            return SimplePatternConverters$.MODULE$.convertSimplePattern(simplePattern);
        }
        if (patternElement2 instanceof PathConcatenation) {
            PathConcatenation pathConcatenation = (PathConcatenation)patternElement2;
            Seq factors = pathConcatenation.factors();
            return this.convertPathFactors((List<PathFactor>)factors.toList());
        }
        if (patternElement2 instanceof QuantifiedPath) {
            throw new IllegalArgumentException("Quantified path patterns must be concatenated with outer node patterns");
        }
        if (patternElement2 instanceof ParenthesizedPath) {
            throw new IllegalArgumentException("Parenthesised path patterns are only supported at the top level with a selective path selector");
        }
        throw new MatchError((Object)patternElement2);
    }

    private ExhaustivePathPattern<NodeConnection> convertPathFactors(List<PathFactor> factors) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<PathFactor> list = factors;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            PathFactor pattern = (PathFactor)colon2.head();
            List tail = colon2.next$access$1();
            if (pattern instanceof SimplePattern) {
                SimplePattern simplePattern = (SimplePattern)pattern;
                return this.buildPathPattern(simplePattern, this.unfoldPathFactorsTail((List<PathFactor>)tail));
            }
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new IllegalArgumentException("Cannot concatenate an empty list of path factors");
        }
        if (bl) {
            PathFactor other = (PathFactor)colon2.head();
            throw new IllegalArgumentException("Concatenated path factors must start with a simple pattern, not a " + ((Product)other).productPrefix());
        }
        throw new MatchError(list);
    }

    private LazyList<Tuple2<QuantifiedPath, SimplePattern>> unfoldPathFactorsTail(List<PathFactor> factors) {
        return package$.MODULE$.LazyList().unfold(factors, (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = x0$1;
            if (Nil$.MODULE$.equals(list)) {
                return None$.MODULE$;
            }
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                PathFactor quantifiedPath = (PathFactor)colon2.head();
                List tail = colon2.next$access$1();
                if (quantifiedPath instanceof QuantifiedPath) {
                    QuantifiedPath quantifiedPath2 = (QuantifiedPath)quantifiedPath;
                    boolean bl2 = false;
                    .colon.colon colon3 = null;
                    List list2 = tail;
                    if (list2 instanceof .colon.colon) {
                        bl2 = true;
                        colon3 = (.colon.colon)list2;
                        PathFactor simplePattern = (PathFactor)colon3.head();
                        List tail2 = colon3.next$access$1();
                        if (simplePattern instanceof SimplePattern) {
                            SimplePattern simplePattern2 = (SimplePattern)simplePattern;
                            return new Some((Object)new Tuple2((Object)new Tuple2((Object)quantifiedPath2, (Object)simplePattern2), (Object)tail2));
                        }
                    }
                    if (Nil$.MODULE$.equals(list2)) {
                        throw new IllegalArgumentException("A quantified path pattern must be concatenated with a simple path pattern");
                    }
                    if (bl2) {
                        PathFactor other = (PathFactor)colon3.head();
                        throw new IllegalArgumentException("A quantified path pattern must be concatenated with a simple path pattern, not with a " + ((Product)other).productPrefix());
                    }
                    throw new MatchError((Object)list2);
                }
            }
            if (bl) {
                PathFactor other = (PathFactor)colon2.head();
                throw new IllegalArgumentException("A simple path pattern may only be concatenated with a quantified path pattern, not with a " + ((Product)other).productPrefix());
            }
            throw new MatchError((Object)list);
        });
    }

    private ExhaustivePathPattern<NodeConnection> buildPathPattern(SimplePattern head, LazyList<Tuple2<QuantifiedPath, SimplePattern>> tail) {
        return (ExhaustivePathPattern)tail.foldLeft(SimplePatternConverters$.MODULE$.convertSimplePattern(head), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                ExhaustivePathPattern pathPattern = (ExhaustivePathPattern)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    QuantifiedPathPattern quantifiedPathPattern;
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    QuantifiedPath quantifiedPath = (QuantifiedPath)tuple22._1();
                    SimplePattern simplePattern = (SimplePattern)tuple22._2();
                    ExhaustivePathPattern exhaustivePathPattern = pathPattern;
                    if (exhaustivePathPattern instanceof ExhaustivePathPattern.SingleNode) {
                        ExhaustivePathPattern.SingleNode singleNode = (ExhaustivePathPattern.SingleNode)exhaustivePathPattern;
                        String name = singleNode.name();
                        tuple24 = new Tuple2((Object)name, (Object)Nil$.MODULE$);
                    } else if (exhaustivePathPattern instanceof ExhaustivePathPattern.NodeConnections) {
                        ExhaustivePathPattern.NodeConnections nodeConnections = (ExhaustivePathPattern.NodeConnections)exhaustivePathPattern;
                        List connections = nodeConnections.connections();
                        tuple24 = new Tuple2((Object)((NodeConnection)connections.last()).right(), connections);
                    } else {
                        throw new MatchError((Object)exhaustivePathPattern);
                    }
                    Tuple2 tuple25 = tuple24;
                    if (tuple25 == null) {
                        throw new MatchError((Object)tuple25);
                    }
                    String previousRightMostNode = (String)tuple25._1();
                    List previousConnections = (List)tuple25._2();
                    Tuple2 tuple26 = new Tuple2((Object)previousRightMostNode, (Object)previousConnections);
                    String previousRightMostNode2 = (String)tuple26._1();
                    List previousConnections2 = (List)tuple26._2();
                    ExhaustivePathPattern<PatternRelationship> exhaustivePathPattern2 = SimplePatternConverters$.MODULE$.convertSimplePattern(simplePattern);
                    if (exhaustivePathPattern2 instanceof ExhaustivePathPattern.SingleNode) {
                        ExhaustivePathPattern.SingleNode singleNode = (ExhaustivePathPattern.SingleNode)exhaustivePathPattern2;
                        String name = singleNode.name();
                        tuple23 = new Tuple2((Object)name, (Object)Nil$.MODULE$);
                    } else if (exhaustivePathPattern2 instanceof ExhaustivePathPattern.NodeConnections) {
                        ExhaustivePathPattern.NodeConnections nodeConnections = (ExhaustivePathPattern.NodeConnections)exhaustivePathPattern2;
                        List relationships2 = nodeConnections.connections();
                        tuple23 = new Tuple2((Object)((PatternRelationship)relationships2.head()).left(), relationships2);
                    } else {
                        throw new MatchError(exhaustivePathPattern2);
                    }
                    Tuple2 tuple27 = tuple23;
                    if (tuple27 == null) {
                        throw new MatchError((Object)tuple27);
                    }
                    String nextLeftMostNode = (String)tuple27._1();
                    List nextConnections = (List)tuple27._2();
                    Tuple2 tuple28 = new Tuple2((Object)nextLeftMostNode, (Object)nextConnections);
                    String nextLeftMostNode2 = (String)tuple28._1();
                    List nextConnections2 = (List)tuple28._2();
                    QuantifiedPathPattern quantifiedPathPattern2 = quantifiedPathPattern = QuantifiedPathPatternConverters$.MODULE$.convertQuantifiedPath(previousRightMostNode2, quantifiedPath, nextLeftMostNode2);
                    return new ExhaustivePathPattern.NodeConnections((List)previousConnections2.$plus$plus((IterableOnce)nextConnections2.$colon$colon((Object)quantifiedPathPattern2)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public PatternConverters(AnonymousVariableNameGenerator anonymousVariableNameGenerator) {
        this.anonymousVariableNameGenerator = anonymousVariableNameGenerator;
    }
}

