/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.converters;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.Range;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.SimplePattern;
import org.neo4j.cypher.internal.expressions.UnsignedIntegerLiteral;
import org.neo4j.cypher.internal.ir.ExhaustivePathPattern;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.VarPatternLength;
import org.neo4j.cypher.internal.ir.VarPatternLength$;
import org.neo4j.cypher.internal.label_expressions.LabelExpression$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class SimplePatternConverters$ {
    public static final SimplePatternConverters$ MODULE$ = new SimplePatternConverters$();

    public ExhaustivePathPattern<PatternRelationship> convertSimplePattern(SimplePattern simplePattern) {
        SimplePattern simplePattern2 = simplePattern;
        if (simplePattern2 instanceof NodePattern) {
            NodePattern nodePattern = (NodePattern)simplePattern2;
            return new ExhaustivePathPattern.SingleNode<PatternRelationship>(this.getNodePatternVariableName(nodePattern));
        }
        if (simplePattern2 instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)simplePattern2;
            return new ExhaustivePathPattern.NodeConnections<PatternRelationship>(this.convertRelationshipChain(relationshipChain));
        }
        throw new MatchError((Object)simplePattern2);
    }

    public List<PatternRelationship> convertRelationshipChain(RelationshipChain relationshipChain) {
        return this.convertRelationshipChainRec(relationshipChain, (List<PatternRelationship>)Nil$.MODULE$);
    }

    private List<PatternRelationship> convertRelationshipChainRec(RelationshipChain relationshipChain, List<PatternRelationship> relationships2) {
        SimplePattern simplePattern;
        while (true) {
            PatternRelationship relationship;
            if ((simplePattern = relationshipChain.element()) instanceof NodePattern) {
                PatternRelationship relationship2;
                NodePattern nodePattern = (NodePattern)simplePattern;
                PatternRelationship patternRelationship = relationship2 = this.makePatternRelationship(nodePattern, relationshipChain.relationship(), relationshipChain.rightNode());
                return relationships2.$colon$colon((Object)patternRelationship);
            }
            if (!(simplePattern instanceof RelationshipChain)) break;
            RelationshipChain relationshipChain2 = (RelationshipChain)simplePattern;
            PatternRelationship patternRelationship = relationship = this.makePatternRelationship(relationshipChain2.rightNode(), relationshipChain.relationship(), relationshipChain.rightNode());
            relationships2 = relationships2.$colon$colon((Object)patternRelationship);
            relationshipChain = relationshipChain2;
        }
        throw new MatchError((Object)simplePattern);
    }

    public PatternRelationship makePatternRelationship(NodePattern leftNode, RelationshipPattern relationship, NodePattern rightNode) {
        return new PatternRelationship(this.getRelationshipPatternVariableName(relationship), (Tuple2<String, String>)new Tuple2((Object)this.getNodePatternVariableName(leftNode), (Object)this.getNodePatternVariableName(rightNode)), relationship.direction(), (Seq<RelTypeName>)LabelExpression$.MODULE$.getRelTypes(relationship.labelExpression()), this.convertRelationshipLength((Option<Option<Range>>)relationship.length()));
    }

    private String getRelationshipPatternVariableName(RelationshipPattern relationshipPattern) {
        return ((LogicalVariable)relationshipPattern.variable().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Missing variable in relationship pattern");
        })).name();
    }

    private String getNodePatternVariableName(NodePattern nodePattern) {
        return ((LogicalVariable)nodePattern.variable().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Missing variable in node pattern");
        })).name();
    }

    public PatternLength convertRelationshipLength(Option<Option<Range>> relationshipLength) {
        Option option;
        Some some;
        Range range;
        Option option2;
        Some some2;
        Range range2;
        Option option3;
        Some some3;
        Range range3;
        Option option4;
        boolean bl = false;
        Some some4 = null;
        Option<Option<Range>> option5 = relationshipLength;
        if (option5 instanceof Some) {
            Some some5;
            Range range4;
            bl = true;
            some4 = (Some)option5;
            Option option6 = (Option)some4.value();
            if (option6 instanceof Some && (range4 = (Range)(some5 = (Some)option6).value()) != null) {
                Option option7 = range4.lower();
                Option option8 = range4.upper();
                if (option7 instanceof Some) {
                    Some some6 = (Some)option7;
                    UnsignedIntegerLiteral left = (UnsignedIntegerLiteral)some6.value();
                    if (option8 instanceof Some) {
                        Some some7 = (Some)option8;
                        UnsignedIntegerLiteral right = (UnsignedIntegerLiteral)some7.value();
                        return new VarPatternLength((int)Predef$.MODULE$.Long2long(left.value()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(right.value())))));
                    }
                }
            }
        }
        if (bl && (option4 = (Option)some4.value()) instanceof Some && (range3 = (Range)(some3 = (Some)option4).value()) != null) {
            Option option9 = range3.lower();
            Option option10 = range3.upper();
            if (option9 instanceof Some) {
                Some some8 = (Some)option9;
                UnsignedIntegerLiteral left = (UnsignedIntegerLiteral)some8.value();
                if (None$.MODULE$.equals(option10)) {
                    return new VarPatternLength((int)Predef$.MODULE$.Long2long(left.value()), (Option<Object>)None$.MODULE$);
                }
            }
        }
        if (bl && (option3 = (Option)some4.value()) instanceof Some && (range2 = (Range)(some2 = (Some)option3).value()) != null) {
            Option option11 = range2.lower();
            Option option12 = range2.upper();
            if (None$.MODULE$.equals(option11) && option12 instanceof Some) {
                Some some9 = (Some)option12;
                UnsignedIntegerLiteral right = (UnsignedIntegerLiteral)some9.value();
                return new VarPatternLength(1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(right.value())))));
            }
        }
        if (bl && (option2 = (Option)some4.value()) instanceof Some && (range = (Range)(some = (Some)option2).value()) != null) {
            Option option13 = range.lower();
            Option option14 = range.upper();
            if (None$.MODULE$.equals(option13) && None$.MODULE$.equals(option14)) {
                return VarPatternLength$.MODULE$.unlimited();
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)some4.value())) {
            return VarPatternLength$.MODULE$.unlimited();
        }
        if (None$.MODULE$.equals(option5)) {
            return SimplePatternLength$.MODULE$;
        }
        throw new MatchError(option5);
    }

    private SimplePatternConverters$() {
    }
}

