/* Cypher.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. Cypher.java */
/*
 * Copyright (c) 2002-2019 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.internal.parser.javacc;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.internal.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory.StringPos;

/** Simple brace matcher. */
public class Cypher<STATEMENT,
                    QUERY extends STATEMENT,
                    CLAUSE,
                    RETURN_CLAUSE extends CLAUSE,
                    RETURN_ITEM,
                    ORDER_ITEM,
                    PATTERN,
                    NODE_PATTERN,
                    REL_PATTERN,
                    PATH_LENGTH,
                    SET_CLAUSE extends CLAUSE,
                    SET_ITEM,
                    REMOVE_ITEM,
                    CALL_RESULT_ITEM,
                    HINT,
                    EXPRESSION,
                    VARIABLE extends EXPRESSION,
                    PROPERTY extends EXPRESSION,
                    MAP_PROJECTION_ITEM,
                    POS> implements CypherConstants {

    ASTExceptionFactory exceptionFactory;
    ASTFactory<STATEMENT,
               QUERY,
               CLAUSE,
               RETURN_CLAUSE,
               RETURN_ITEM,
               ORDER_ITEM,
               PATTERN,
               NODE_PATTERN,
               REL_PATTERN,
               PATH_LENGTH,
               SET_CLAUSE,
               SET_ITEM,
               REMOVE_ITEM,
               CALL_RESULT_ITEM,
               HINT,
               EXPRESSION,
               VARIABLE,
               PROPERTY,
               MAP_PROJECTION_ITEM,
               POS> astFactory;

    public Cypher(ASTFactory<STATEMENT,
                             QUERY,
                             CLAUSE,
                             RETURN_CLAUSE,
                             RETURN_ITEM,
                             ORDER_ITEM,
                             PATTERN,
                             NODE_PATTERN,
                             REL_PATTERN,
                             PATH_LENGTH,
                             SET_CLAUSE,
                             SET_ITEM,
                             REMOVE_ITEM,
                             CALL_RESULT_ITEM,
                             HINT,
                             EXPRESSION,
                             VARIABLE,
                             PROPERTY,
                             MAP_PROJECTION_ITEM,
                             POS> astFactory,
                  ASTExceptionFactory exceptionFactory,
                  CharStream stream) {
        this(stream);
        this.astFactory = astFactory;
        this.exceptionFactory = exceptionFactory;
    }

  private POS pos(Token t) {
    return astFactory.inputPosition(t.beginOffset, t.beginLine, t.beginColumn);
  }

/** Root production. */
  final public List<STATEMENT> Statements() throws ParseException, Exception {STATEMENT x;
  List stmts = new ArrayList();
    try {
      x = Statement();
stmts.add(x);
      label_1:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_1;
        }
        jj_consume_token(148);
        x = Statement();
stmts.add(x);
      }
      if (jj_2_2(2)) {
        jj_consume_token(148);
      } else {
        ;
      }
      jj_consume_token(0);
{if ("" != null) return stmts;}
    } catch (ParseException e) {
Token t = e.currentToken.next;
    throw exceptionFactory.syntaxException(t.image, ParseExceptions.expected(e.expectedTokenSequences, e.tokenImage), e,
                                           t.beginOffset, t.beginLine, t.beginColumn);
    } catch (InvalidUnicodeLiteral e) {
throw exceptionFactory.syntaxException(e, e.offset, e.line, e.column);
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT Statement() throws ParseException {STATEMENT x;
    x = Query();
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY Query() throws ParseException {QUERY x;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USING:{
      x = PeriodicCommitQuery();
      break;
      }
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case CALL:
    case LOAD:
    case FROM:
    case FOREACH:
    case MERGE:
    case OPTIONAL:{
      x = RegularQuery();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY PeriodicCommitQuery() throws ParseException {Token t;
  Token batchSize = null;
  CLAUSE loadCsv;
  List<CLAUSE> queryBody;
    jj_consume_token(USING);
    t = jj_consume_token(PERIODIC);
    jj_consume_token(COMMIT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:{
      batchSize = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    loadCsv = LoadCSVClause();
    queryBody = PeriodicCommitQueryBody();
{if ("" != null) return astFactory.periodicCommitQuery(pos(t), batchSize == null ? null : batchSize.image, loadCsv, queryBody);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> PeriodicCommitQueryBody() throws ParseException {CLAUSE x;
  List<CLAUSE> clauses = new ArrayList();
    label_2:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case CALL:
      case LOAD:
      case FROM:
      case FOREACH:
      case MERGE:
      case OPTIONAL:{
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      x = Clause();
clauses.add(x);
    }
{if ("" != null) return (List<CLAUSE>)clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY RegularQuery() throws ParseException {QUERY x;
    x = QueryPart();
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY QueryPart() throws ParseException {QUERY x;
    x = SingleQuery();
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNION:{
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      x = Union(x);
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY Union(QUERY lhs) throws ParseException {Token t;
  QUERY rhs;
  boolean all = false;
    t = jj_consume_token(UNION);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      jj_consume_token(ALL);
all = true;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    rhs = SingleQuery();
{if ("" != null) return astFactory.newUnion(pos(t), lhs, rhs, all);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY SingleQuery() throws ParseException {CLAUSE x;
  List clauses = new ArrayList();
    label_4:
    while (true) {
      x = Clause();
clauses.add(x);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case CALL:
      case LOAD:
      case FROM:
      case FOREACH:
      case MERGE:
      case OPTIONAL:{
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_4;
      }
    }
{if ("" != null) return astFactory.newSingleQuery((List<CLAUSE>)clauses);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE Clause() throws ParseException {CLAUSE x = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      x = FromClause();
      break;
      }
    case USE:{
      x = UseClause();
      break;
      }
    case RETURN:{
      x = ReturnClause();
      break;
      }
    case CREATE:{
      x = CreateClause();
      break;
      }
    case DELETE:
    case DETACH:{
      x = DeleteClause();
      break;
      }
    case SET:{
      x = SetClause();
      break;
      }
    case REMOVE:{
      x = RemoveClause();
      break;
      }
    case MATCH:
    case OPTIONAL:{
      x = MatchClause();
      break;
      }
    case MERGE:{
      x = MergeClause();
      break;
      }
    case WITH:{
      x = WithClause();
      break;
      }
    case UNWIND:{
      x = UnwindClause();
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      if (jj_2_3(2)) {
        x = CallClause();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CALL:{
          x = SubqueryClause();
          break;
          }
        case LOAD:{
          x = LoadCSVClause();
          break;
          }
        case FOREACH:{
          x = ForeachClause();
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

// FROM & USE
  final public 
CLAUSE FromClause() throws ParseException {Token t;
  EXPRESSION e;
    t = jj_consume_token(FROM);
    if (jj_2_4(2)) {
      jj_consume_token(GRAPH);
    } else {
      ;
    }
    e = Expression();
{if ("" != null) return astFactory.fromClause(pos(t), e);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE UseClause() throws ParseException {Token t;
  EXPRESSION e;
    t = jj_consume_token(USE);
    if (jj_2_5(2)) {
      jj_consume_token(GRAPH);
    } else {
      ;
    }
    e = Expression();
{if ("" != null) return astFactory.useClause(pos(t), e);}
    throw new IllegalStateException ("Missing return statement in function");
}

// RETURN
  final public 
CLAUSE ReturnClause() throws ParseException {Token t;
  CLAUSE clause;
    t = jj_consume_token(RETURN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GRAPH:{
      t = jj_consume_token(GRAPH);
{if ("" != null) return astFactory.newReturnGraphClause(pos(t));}
      break;
      }
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case PLUS:
    case MINUS:
    case TIMES:
    case LPAREN:
    case LBRACKET:
    case LCURLY:
    case IDENTIFIER:
    case 152:{
      clause = ReturnBody(t);
{if ("" != null) return clause;}
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_CLAUSE ReturnBody(Token t) throws ParseException {boolean distinct = false;
  boolean returnAll = false;
  List order = java.util.Collections.emptyList();
  EXPRESSION skip = null;
  EXPRESSION limit = null;
  RETURN_ITEM x;
  List returnItems = new ArrayList();
    if (jj_2_6(2)) {
      jj_consume_token(DISTINCT);
distinct = true;
    } else {
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
returnAll = true;
      label_5:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 149:{
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_5;
        }
        jj_consume_token(149);
        x = ReturnItem();
returnItems.add(x);
      }
      break;
      }
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case PLUS:
    case MINUS:
    case LPAREN:
    case LBRACKET:
    case LCURLY:
    case IDENTIFIER:
    case 152:{
      x = ReturnItem();
returnItems.add(x);
      label_6:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 149:{
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_6;
        }
        jj_consume_token(149);
        x = ReturnItem();
returnItems.add(x);
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      order = Order();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SKIPROWS:{
      skip = Skip();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LIMITROWS:{
      limit = Limit();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.newReturnClause(pos(t), distinct, returnAll, (List<RETURN_ITEM>)returnItems, (List<ORDER_ITEM>)order, skip, limit);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEM ReturnItem() throws ParseException {EXPRESSION e;
  VARIABLE v = null;
  Token eStart;
  Token eEnd;
eStart = token;
    e = Expression();
eEnd = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
if (v != null) {if ("" != null) return astFactory.newReturnItem(pos(eStart), e, v);}
    else {if ("" != null) return astFactory.newReturnItem(pos(eStart), e, eStart.next.beginOffset, eEnd.endOffset );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<ORDER_ITEM> Order() throws ParseException {ORDER_ITEM o;
  List items = new ArrayList();
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    o = OrderItem();
items.add(o);
    label_7:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      jj_consume_token(149);
      o = OrderItem();
items.add(o);
    }
{if ("" != null) return (List<ORDER_ITEM>)items;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ORDER_ITEM OrderItem() throws ParseException {EXPRESSION e;
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESC:{
      jj_consume_token(DESC);
{if ("" != null) return astFactory.orderDesc(e);}
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASC:{
        jj_consume_token(ASC);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.orderAsc(e);}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Skip() throws ParseException {EXPRESSION e;
    jj_consume_token(SKIPROWS);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Limit() throws ParseException {EXPRESSION e;
    jj_consume_token(LIMITROWS);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

// WITH
  final public 
CLAUSE WithClause() throws ParseException {Token t;
  RETURN_CLAUSE returnClause;
  EXPRESSION where = null;
    t = jj_consume_token(WITH);
    returnClause = ReturnBody(t);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.withClause(pos(t), returnClause, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

// CREATE
  final public 
CLAUSE CreateClause() throws ParseException {Token t; List patterns;
    t = jj_consume_token(CREATE);
    patterns = PatternList();
{if ("" != null) return astFactory.createClause(pos(t), (List<PATTERN>)patterns);}
    throw new IllegalStateException ("Missing return statement in function");
}

// SET
  final public 
SET_CLAUSE SetClause() throws ParseException {Token t;
  SET_ITEM x;
  List items = new ArrayList();
    t = jj_consume_token(SET);
    x = SetItem();
items.add(x);
    label_8:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_8;
      }
      jj_consume_token(149);
      x = SetItem();
items.add(x);
    }
{if ("" != null) return astFactory.setClause(pos(t), (List<SET_ITEM>)items);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SET_ITEM SetItem() throws ParseException {EXPRESSION e; PROPERTY p; VARIABLE v; List<StringPos<POS>> labels;
    if (jj_2_7(2)) {
      p = PropertyExpression();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setProperty(p, e);}
    } else if (jj_2_8(2)) {
      v = Variable();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setVariable(v, e);}
    } else if (jj_2_9(2)) {
      v = Variable();
      jj_consume_token(150);
      e = Expression();
{if ("" != null) return astFactory.addAndSetVariable(v, e);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case TRUE:
      case FALSE:
      case NULL:
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case GRAPH:
      case CALL:
      case YIELD:
      case LOAD:
      case CSV:
      case PERIODIC:
      case COMMIT:
      case HEADERS:
      case FROM:
      case FIELDTERMINATOR:
      case FOREACH:
      case WHERE:
      case DISTINCT:
      case MERGE:
      case OPTIONAL:
      case USING:
      case ORDER:
      case BY:
      case DESC:
      case ASC:
      case SKIPROWS:
      case LIMITROWS:
      case UNION:
      case DROP:
      case INDEX:
      case SEEK:
      case SCAN:
      case JOIN:
      case CONSTRAINT:
      case ASSERT:
      case IS:
      case NODE:
      case KEY:
      case UNIQUE:
      case ON:
      case AS:
      case OR:
      case XOR:
      case AND:
      case NOT:
      case STARTS:
      case ENDS:
      case CONTAINS:
      case IN:
      case COUNT:
      case FILTER:
      case EXTRACT:
      case REDUCE:
      case EXISTS:
      case ALL:
      case ANY:
      case NONE:
      case SINGLE:
      case CASE:
      case ELSE:
      case WHEN:
      case THEN:
      case END:
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case IDENTIFIER:{
        v = Variable();
        labels = NodeLabels();
{if ("" != null) return astFactory.setLabels(v, labels);}
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// REMOVE
  final public 
CLAUSE RemoveClause() throws ParseException {Token t;
  REMOVE_ITEM x;
  List items = new ArrayList();
    t = jj_consume_token(REMOVE);
    x = RemoveItem();
items.add(x);
    label_9:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_9;
      }
      jj_consume_token(149);
      x = RemoveItem();
items.add(x);
    }
{if ("" != null) return astFactory.removeClause(pos(t), (List<REMOVE_ITEM>)items);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REMOVE_ITEM RemoveItem() throws ParseException {EXPRESSION e; PROPERTY p; VARIABLE v; List<StringPos<POS>> labels;
    if (jj_2_10(2)) {
      p = PropertyExpression();
{if ("" != null) return astFactory.removeProperty(p);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case TRUE:
      case FALSE:
      case NULL:
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case GRAPH:
      case CALL:
      case YIELD:
      case LOAD:
      case CSV:
      case PERIODIC:
      case COMMIT:
      case HEADERS:
      case FROM:
      case FIELDTERMINATOR:
      case FOREACH:
      case WHERE:
      case DISTINCT:
      case MERGE:
      case OPTIONAL:
      case USING:
      case ORDER:
      case BY:
      case DESC:
      case ASC:
      case SKIPROWS:
      case LIMITROWS:
      case UNION:
      case DROP:
      case INDEX:
      case SEEK:
      case SCAN:
      case JOIN:
      case CONSTRAINT:
      case ASSERT:
      case IS:
      case NODE:
      case KEY:
      case UNIQUE:
      case ON:
      case AS:
      case OR:
      case XOR:
      case AND:
      case NOT:
      case STARTS:
      case ENDS:
      case CONTAINS:
      case IN:
      case COUNT:
      case FILTER:
      case EXTRACT:
      case REDUCE:
      case EXISTS:
      case ALL:
      case ANY:
      case NONE:
      case SINGLE:
      case CASE:
      case ELSE:
      case WHEN:
      case THEN:
      case END:
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case IDENTIFIER:{
        v = Variable();
        labels = NodeLabels();
{if ("" != null) return astFactory.removeLabels(v, labels);}
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// DELETE
  final public 
CLAUSE DeleteClause() throws ParseException {Token t;
  boolean detach = false;
  EXPRESSION e;
  List list = new ArrayList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DETACH:{
      jj_consume_token(DETACH);
detach=true;
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    t = jj_consume_token(DELETE);
    e = Expression();
list.add(e);
    label_10:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_10;
      }
      jj_consume_token(149);
      e = Expression();
list.add(e);
    }
{if ("" != null) return astFactory.deleteClause(pos(t), detach, (List<EXPRESSION>)list);}
    throw new IllegalStateException ("Missing return statement in function");
}

// MATCH
  final public 
CLAUSE MatchClause() throws ParseException {Token t;
  boolean optional = false;
  List patterns;
  List hints;
  EXPRESSION where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONAL:{
      jj_consume_token(OPTIONAL);
optional = true;
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    t = jj_consume_token(MATCH);
    patterns = PatternList();
    hints = Hints();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.matchClause(pos(t), optional, (List<PATTERN>)patterns, (List<HINT>)hints, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<HINT> Hints() throws ParseException {Token t;
    boolean seek;
    VARIABLE v;
    Token label;
    List propNames;
    List joinVariables;
  HINT h;
  List hints = null;
    label_11:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USING:{
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_11;
      }
      t = jj_consume_token(USING);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:{
        jj_consume_token(INDEX);
seek=false;
        if (jj_2_11(2)) {
          jj_consume_token(SEEK);
seek=true;
        } else {
          ;
        }
        v = Variable();
        label = NodeLabel();
        jj_consume_token(LPAREN);
        propNames = SymbolicNameList1();
        jj_consume_token(RPAREN);
h=astFactory.usingIndexHint(pos(t), v, label.image, (List<String>)propNames, seek);
        break;
        }
      case JOIN:{
        jj_consume_token(JOIN);
        jj_consume_token(ON);
        joinVariables = VariableList1();
h=astFactory.usingJoin(pos(t), (List<VARIABLE>)joinVariables);
        break;
        }
      case SCAN:{
        jj_consume_token(SCAN);
        v = Variable();
        label = NodeLabel();
h=astFactory.usingScan(pos(t), v, label.image);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (hints == null) { hints = new ArrayList(); } hints.add(h);
    }
{if ("" != null) return (List<HINT>)hints;}
    throw new IllegalStateException ("Missing return statement in function");
}

// MERGE
  final public 
CLAUSE MergeClause() throws ParseException {Token t;
  PATTERN p;
  SET_CLAUSE c;
  ArrayList<SET_CLAUSE> clauses = new ArrayList<>();
  ArrayList<ASTFactory.MergeActionType> actionTypes = new ArrayList<>();
    t = jj_consume_token(MERGE);
    p = Pattern();
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_12;
      }
      jj_consume_token(ON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MATCH:{
        jj_consume_token(MATCH);
        c = SetClause();
clauses.add(c); actionTypes.add(ASTFactory.MergeActionType.OnMatch);
        break;
        }
      case CREATE:{
        jj_consume_token(CREATE);
        c = SetClause();
clauses.add(c); actionTypes.add(ASTFactory.MergeActionType.OnCreate);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.mergeClause(pos(t), p, clauses, actionTypes);}
    throw new IllegalStateException ("Missing return statement in function");
}

// UNWIND
  final public 
CLAUSE UnwindClause() throws ParseException {Token t; EXPRESSION e; VARIABLE v;
    t = jj_consume_token(UNWIND);
    e = Expression();
    jj_consume_token(AS);
    v = Variable();
{if ("" != null) return astFactory.unwindClause(pos(t), e, v);}
    throw new IllegalStateException ("Missing return statement in function");
}

// CALL
  final public 
CLAUSE CallClause() throws ParseException {Token t;
  List namespace;
  String name;
  EXPRESSION e;
  List arguments = null;
  CALL_RESULT_ITEM x;
  List items = null;
  EXPRESSION where = null;
    t = jj_consume_token(CALL);
    namespace = Namespace();
    name = ProcedureName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
arguments = new ArrayList();
      if (jj_2_12(2)) {
        e = Expression();
arguments.add(e);
      } else {
        ;
      }
      label_13:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 149:{
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_13;
        }
        jj_consume_token(149);
        e = Expression();
arguments.add(e);
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case YIELD:{
      jj_consume_token(YIELD);
items = new ArrayList();
      x = ProcedureResultItem();
items.add(x);
      label_14:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 149:{
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_14;
        }
        jj_consume_token(149);
        x = ProcedureResultItem();
items.add(x);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        where = Where();
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callClause(pos(t), (List<String>)namespace, name, (List<EXPRESSION>)arguments, (List<CALL_RESULT_ITEM>)items, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String ProcedureName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return t.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CALL_RESULT_ITEM ProcedureResultItem() throws ParseException {Token t;
  VARIABLE v = null;
    t = SymbolicNameString();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callResultItem(pos(t), t.image,  v);}
    throw new IllegalStateException ("Missing return statement in function");
}

// LOAD CSV
  final public 
CLAUSE LoadCSVClause() throws ParseException {Token t;
  boolean headers = false;
  EXPRESSION source;
  VARIABLE v;
  Token sep = null;
    t = jj_consume_token(LOAD);
    jj_consume_token(CSV);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      jj_consume_token(HEADERS);
headers=true;
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    jj_consume_token(FROM);
    source = Expression();
    jj_consume_token(AS);
    v = Variable();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FIELDTERMINATOR:{
      jj_consume_token(FIELDTERMINATOR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING_LITERAL1:{
        sep = jj_consume_token(STRING_LITERAL1);
        break;
        }
      case STRING_LITERAL2:{
        sep = jj_consume_token(STRING_LITERAL2);
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.loadCsvClause(pos(t), headers, source, v, sep == null ? null : sep.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

// FOREACH
  final public 
CLAUSE ForeachClause() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION list;
  CLAUSE c;
  List clauses = new ArrayList();
    t = jj_consume_token(FOREACH);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    list = Expression();
    jj_consume_token(BAR);
    label_15:
    while (true) {
      c = Clause();
clauses.add(c);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case CALL:
      case LOAD:
      case FROM:
      case FOREACH:
      case MERGE:
      case OPTIONAL:{
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_15;
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.foreachClause(pos(t), v, list, (List<CLAUSE>)clauses);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE SubqueryClause() throws ParseException {Token t;
  QUERY q;
    t = jj_consume_token(CALL);
    jj_consume_token(LCURLY);
    q = Query();
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.subqueryClause(pos(t), q);}
    throw new IllegalStateException ("Missing return statement in function");
}

// WHERE
  final public 
EXPRESSION Where() throws ParseException {EXPRESSION e;
    jj_consume_token(WHERE);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

// PATTERN
  final public 
List<PATTERN> PatternList() throws ParseException {PATTERN p;
  List patterns = new ArrayList();
    p = Pattern();
patterns.add(p);
    label_16:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        break label_16;
      }
      jj_consume_token(149);
      p = Pattern();
patterns.add(p);
    }
{if ("" != null) return patterns;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN Pattern() throws ParseException {VARIABLE v;
  PATTERN p;
    if (jj_2_13(2)) {
      v = Variable();
      jj_consume_token(EQ);
      p = AnonymousPattern();
{if ("" != null) return astFactory.namedPattern(v, p);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case LPAREN:{
        p = AnonymousPattern();
{if ("" != null) return p;}
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN AnonymousPattern() throws ParseException {PATTERN p;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:{
      p = ShortestPathPattern();
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      if (jj_2_14(3)) {
        p = EveryPathPattern();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          jj_consume_token(LPAREN);
          p = AnonymousPattern();
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN ShortestPathPattern() throws ParseException {Token t; PATTERN p;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      jj_consume_token(LPAREN);
      p = EveryPathPattern();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.shortestPathPattern(pos(t), p);}
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      jj_consume_token(LPAREN);
      p = EveryPathPattern();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allShortestPathsPattern(pos(t), p);}
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN EveryPathPattern() throws ParseException {NODE_PATTERN n;
  REL_PATTERN r;
  List relationships = new ArrayList();
  List nodes = new ArrayList();
    n = NodePattern();
nodes.add(n);
    label_17:
    while (true) {
      if (jj_2_15(2)) {
      } else {
        break label_17;
      }
      r = RelationshipPattern();
relationships.add(r);
      n = NodePattern();
nodes.add(n);
    }
{if ("" != null) return astFactory.everyPathPattern((List<NODE_PATTERN>)nodes, (List<REL_PATTERN>)relationships);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN EveryPathPatternNonEmpty() throws ParseException {NODE_PATTERN n;
  REL_PATTERN r;
  List relationships = new ArrayList();
  List nodes = new ArrayList();
    n = NodePattern();
nodes.add(n);
    label_18:
    while (true) {
      r = RelationshipPattern();
relationships.add(r);
      n = NodePattern();
nodes.add(n);
      if (jj_2_16(2)) {
      } else {
        break label_18;
      }
    }
{if ("" != null) return astFactory.everyPathPattern((List<NODE_PATTERN>)nodes, (List<REL_PATTERN>)relationships);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePattern() throws ParseException {Token t;
  VARIABLE v = null;
  List<StringPos<POS>> labels = java.util.Collections.emptyList();
  EXPRESSION properties = null;
    t = jj_consume_token(LPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      v = Variable();
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 151:{
      labels = NodeLabels();
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LCURLY:
    case 152:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern(pos(t), v, labels, properties);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> NodeLabels() throws ParseException {Token label;
  List<StringPos<POS>> labels = new ArrayList<>();
    label_19:
    while (true) {
      label = NodeLabel();
labels.add(new StringPos(label.image, pos(label)));
      if (jj_2_17(2)) {
      } else {
        break label_19;
      }
    }
{if ("" != null) return labels;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION HasLabels(EXPRESSION subject) throws ParseException {List<StringPos<POS>> labels;
    labels = NodeLabels();
{if ("" != null) return astFactory.hasLabelsOrTypes(subject, labels);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token NodeLabel() throws ParseException {Token t;
    jj_consume_token(151);
    t = SymbolicNameString();
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Properties() throws ParseException {EXPRESSION e;
    if (jj_2_18(3)) {
      e = MapLiteral();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 152:{
        e = Parameter();
        break;
        }
      case LCURLY:{
        e = OldParameter();
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPattern() throws ParseException {Token firstToken = token.next;
  Token t;
  boolean left = false;
  boolean right = false;
  VARIABLE v = null;
  List<StringPos<POS>> relTypes = java.util.Collections.emptyList();
  boolean legacyTypeSeparator = false;
  PATH_LENGTH pathLength = null;
  EXPRESSION properties = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:
    case ARROW_LEFT_HEAD:{
      LeftArrow();
left = true;
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case TRUE:
      case FALSE:
      case NULL:
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case GRAPH:
      case CALL:
      case YIELD:
      case LOAD:
      case CSV:
      case PERIODIC:
      case COMMIT:
      case HEADERS:
      case FROM:
      case FIELDTERMINATOR:
      case FOREACH:
      case WHERE:
      case DISTINCT:
      case MERGE:
      case OPTIONAL:
      case USING:
      case ORDER:
      case BY:
      case DESC:
      case ASC:
      case SKIPROWS:
      case LIMITROWS:
      case UNION:
      case DROP:
      case INDEX:
      case SEEK:
      case SCAN:
      case JOIN:
      case CONSTRAINT:
      case ASSERT:
      case IS:
      case NODE:
      case KEY:
      case UNIQUE:
      case ON:
      case AS:
      case OR:
      case XOR:
      case AND:
      case NOT:
      case STARTS:
      case ENDS:
      case CONTAINS:
      case IN:
      case COUNT:
      case FILTER:
      case EXTRACT:
      case REDUCE:
      case EXISTS:
      case ALL:
      case ANY:
      case NONE:
      case SINGLE:
      case CASE:
      case ELSE:
      case WHEN:
      case THEN:
      case END:
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case IDENTIFIER:{
        v = Variable();
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 151:{
        jj_consume_token(151);
        t = SymbolicNameString();
relTypes = new ArrayList(); relTypes.add(new StringPos(t.image, pos(t)));
        label_20:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case BAR:{
            break;
            }
          default:
            jj_la1[53] = jj_gen;
            break label_20;
          }
          jj_consume_token(BAR);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 151:{
            jj_consume_token(151);
legacyTypeSeparator = true;
            break;
            }
          default:
            jj_la1[54] = jj_gen;
            ;
          }
          t = SymbolicNameString();
relTypes.add(new StringPos(t.image, pos(t)));
        }
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:
      case 152:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern(pos(firstToken), left, right, v, relTypes, pathLength, properties, legacyTypeSeparator);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void LeftArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:{
      jj_consume_token(LT);
      break;
      }
    case ARROW_LEFT_HEAD:{
      jj_consume_token(ARROW_LEFT_HEAD);
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ArrowLine() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ARROW_LINE:{
      jj_consume_token(ARROW_LINE);
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void RightArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:{
      jj_consume_token(GT);
      break;
      }
    case ARROW_RIGHT_HEAD:{
      jj_consume_token(ARROW_RIGHT_HEAD);
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public PATH_LENGTH PathLength() throws ParseException {Token t; PATH_LENGTH p = null;
    t = jj_consume_token(TIMES);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:
    case DOTDOT:{
      p = PathLengthLiteral(t);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
{if ("" != null) return p == null ? astFactory.pathLength(pos(t), null, null) : p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATH_LENGTH PathLengthLiteral(Token t) throws ParseException {Token v1 = null;
  Token v2 = null;
    if (jj_2_19(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      jj_consume_token(DOTDOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v2 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.pathLength(pos(t), v1 == null ? "" : v1.image, v2 == null ? "" : v2.image);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
String v = v1 == null ? "" : v1.image; {if ("" != null) return astFactory.pathLength(pos(t), v, v);}
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// EXPRESSIONS
  final public 
EXPRESSION Expression() throws ParseException {EXPRESSION e;
    e = Expression12();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression12() throws ParseException {Token t;
  EXPRESSION e;
  EXPRESSION temp;
    e = Expression11();
    label_21:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OR:{
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        break label_21;
      }
      t = jj_consume_token(OR);
      temp = Expression11();
e = astFactory.or(pos(t), e, temp);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression11() throws ParseException {Token t;
  EXPRESSION e;
  EXPRESSION temp;
    e = Expression10();
    label_22:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case XOR:{
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        break label_22;
      }
      t = jj_consume_token(XOR);
      temp = Expression10();
e = astFactory.xor(pos(t), e, temp);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression10() throws ParseException {Token t;
  EXPRESSION e;
  EXPRESSION temp;
    e = Expression9();
    label_23:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:{
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_23;
      }
      t = jj_consume_token(AND);
      temp = Expression9();
e = astFactory.and(pos(t), e, temp);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression9() throws ParseException {EXPRESSION e;
    if (jj_2_20(3)) {
      jj_consume_token(NOT);
      e = Expression9();
e = astFactory.not(e);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case TRUE:
      case FALSE:
      case NULL:
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case GRAPH:
      case CALL:
      case YIELD:
      case LOAD:
      case CSV:
      case PERIODIC:
      case COMMIT:
      case HEADERS:
      case FROM:
      case FIELDTERMINATOR:
      case FOREACH:
      case WHERE:
      case DISTINCT:
      case MERGE:
      case OPTIONAL:
      case USING:
      case ORDER:
      case BY:
      case DESC:
      case ASC:
      case SKIPROWS:
      case LIMITROWS:
      case UNION:
      case DROP:
      case INDEX:
      case SEEK:
      case SCAN:
      case JOIN:
      case CONSTRAINT:
      case ASSERT:
      case IS:
      case NODE:
      case KEY:
      case UNIQUE:
      case ON:
      case AS:
      case OR:
      case XOR:
      case AND:
      case NOT:
      case STARTS:
      case ENDS:
      case CONTAINS:
      case IN:
      case COUNT:
      case FILTER:
      case EXTRACT:
      case REDUCE:
      case EXISTS:
      case ALL:
      case ANY:
      case NONE:
      case SINGLE:
      case CASE:
      case ELSE:
      case WHEN:
      case THEN:
      case END:
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case PLUS:
      case MINUS:
      case LPAREN:
      case LBRACKET:
      case LCURLY:
      case IDENTIFIER:
      case 152:{
        e = Expression8();
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression8() throws ParseException {Token t;
  EXPRESSION e;
  EXPRESSION lhs;
  EXPRESSION rhs;
  List cmps = null;
    e = Expression7();
lhs = e;
    label_24:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:
      case NEQ:
      case NEQ2:
      case LE:
      case GE:
      case LT:
      case GT:{
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_24;
      }
      if (jj_2_21(2)) {
        t = jj_consume_token(EQ);
        rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.eq(pos(t), lhs, rhs)); lhs = rhs;
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NEQ:{
          t = jj_consume_token(NEQ);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.neq(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        case NEQ2:{
          t = jj_consume_token(NEQ2);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.neq2(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        case LE:{
          t = jj_consume_token(LE);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.lte(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        case GE:{
          t = jj_consume_token(GE);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.gte(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        case LT:{
          t = jj_consume_token(LT);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.lt(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        case GT:{
          t = jj_consume_token(GT);
          rhs = Expression7();
if (cmps == null) {cmps = new ArrayList();} cmps.add(astFactory.gt(pos(t), lhs, rhs)); lhs = rhs;
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
if (cmps == null) {if ("" != null) return e;}
    else if (cmps.size() == 1) {if ("" != null) return ((List<EXPRESSION>)cmps).get(0);}
    else {if ("" != null) return astFactory.ands((List<EXPRESSION>)cmps);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression7() throws ParseException {EXPRESSION e;
    e = Expression6();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IS:
    case REGEQ:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:{
      e = ComparisonExpression6(e);
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ComparisonExpression6(EXPRESSION lhs) throws ParseException {Token t;
  EXPRESSION rhs;
    if (jj_2_22(2)) {
      t = jj_consume_token(REGEQ);
      rhs = Expression6();
{if ("" != null) return astFactory.regeq(pos(t), lhs, rhs);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STARTS:{
        t = jj_consume_token(STARTS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.startsWith(pos(t), lhs, rhs);}
        break;
        }
      case ENDS:{
        t = jj_consume_token(ENDS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.endsWith(pos(t), lhs, rhs);}
        break;
        }
      case CONTAINS:{
        t = jj_consume_token(CONTAINS);
        rhs = Expression6();
{if ("" != null) return astFactory.contains(pos(t), lhs, rhs);}
        break;
        }
      case IN:{
        t = jj_consume_token(IN);
        rhs = Expression6();
{if ("" != null) return astFactory.in(pos(t), lhs, rhs);}
        break;
        }
      case IS:{
        t = jj_consume_token(IS);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NULL:{
          jj_consume_token(NULL);
{if ("" != null) return astFactory.isNull(lhs);}
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
          jj_consume_token(NULL);
{if ("" != null) return astFactory.not(astFactory.isNull(lhs));}
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression6() throws ParseException {Token t;
  EXPRESSION lhs;
  EXPRESSION rhs;
    lhs = Expression5();
    label_25:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:
      case MINUS:{
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        break label_25;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        rhs = Expression5();
lhs = astFactory.plus(pos(t), lhs, rhs);
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        rhs = Expression5();
lhs = astFactory.minus(pos(t), lhs, rhs);
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression5() throws ParseException {Token t;
  EXPRESSION lhs;
  EXPRESSION rhs;
    lhs = Expression4();
    label_26:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:
      case DIVIDE:
      case MODULO:{
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_26;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        t = jj_consume_token(TIMES);
        rhs = Expression4();
lhs = astFactory.multiply(pos(t), lhs, rhs);
        break;
        }
      case DIVIDE:{
        t = jj_consume_token(DIVIDE);
        rhs = Expression4();
lhs = astFactory.divide(pos(t), lhs, rhs);
        break;
        }
      case MODULO:{
        t = jj_consume_token(MODULO);
        rhs = Expression4();
lhs = astFactory.modulo(pos(t), lhs, rhs);
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression4() throws ParseException {Token t;
  EXPRESSION lhs;
  EXPRESSION rhs;
    lhs = Expression3();
    label_27:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case POW:{
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        break label_27;
      }
      t = jj_consume_token(POW);
      rhs = Expression3();
lhs = astFactory.pow(pos(t), lhs, rhs);
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression3() throws ParseException {EXPRESSION e;
    if (jj_2_23(3)) {
      e = Expression2();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
        e = Expression2();
e = astFactory.unaryPlus(e);
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
        e = Expression2();
e = astFactory.unaryMinus(e);
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression2() throws ParseException {EXPRESSION e;
    e = Expression1();
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:
      case LBRACKET:
      case 151:{
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        break label_28;
      }
      e = PostFix1(e);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PostFix1(EXPRESSION subject) throws ParseException {Token t;
  EXPRESSION e1 = null;
  EXPRESSION e2 = null;
  EXPRESSION ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOT:{
      ret = Property(subject);
      break;
      }
    case 151:{
      ret = HasLabels(subject);
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      if (jj_2_24(2147483647)) {
        jj_consume_token(LBRACKET);
        e1 = Expression();
        jj_consume_token(RBRACKET);
ret=astFactory.listLookup(subject, e1);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          t = jj_consume_token(LBRACKET);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case TRUE:
          case FALSE:
          case NULL:
          case RETURN:
          case CREATE:
          case DELETE:
          case SET:
          case REMOVE:
          case DETACH:
          case MATCH:
          case WITH:
          case UNWIND:
          case USE:
          case GRAPH:
          case CALL:
          case YIELD:
          case LOAD:
          case CSV:
          case PERIODIC:
          case COMMIT:
          case HEADERS:
          case FROM:
          case FIELDTERMINATOR:
          case FOREACH:
          case WHERE:
          case DISTINCT:
          case MERGE:
          case OPTIONAL:
          case USING:
          case ORDER:
          case BY:
          case DESC:
          case ASC:
          case SKIPROWS:
          case LIMITROWS:
          case UNION:
          case DROP:
          case INDEX:
          case SEEK:
          case SCAN:
          case JOIN:
          case CONSTRAINT:
          case ASSERT:
          case IS:
          case NODE:
          case KEY:
          case UNIQUE:
          case ON:
          case AS:
          case OR:
          case XOR:
          case AND:
          case NOT:
          case STARTS:
          case ENDS:
          case CONTAINS:
          case IN:
          case COUNT:
          case FILTER:
          case EXTRACT:
          case REDUCE:
          case EXISTS:
          case ALL:
          case ANY:
          case NONE:
          case SINGLE:
          case CASE:
          case ELSE:
          case WHEN:
          case THEN:
          case END:
          case SHORTEST_PATH:
          case ALL_SHORTEST_PATH:
          case PLUS:
          case MINUS:
          case LPAREN:
          case LBRACKET:
          case LCURLY:
          case IDENTIFIER:
          case 152:{
            e1 = Expression();
            break;
            }
          default:
            jj_la1[83] = jj_gen;
            ;
          }
          jj_consume_token(DOTDOT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case TRUE:
          case FALSE:
          case NULL:
          case RETURN:
          case CREATE:
          case DELETE:
          case SET:
          case REMOVE:
          case DETACH:
          case MATCH:
          case WITH:
          case UNWIND:
          case USE:
          case GRAPH:
          case CALL:
          case YIELD:
          case LOAD:
          case CSV:
          case PERIODIC:
          case COMMIT:
          case HEADERS:
          case FROM:
          case FIELDTERMINATOR:
          case FOREACH:
          case WHERE:
          case DISTINCT:
          case MERGE:
          case OPTIONAL:
          case USING:
          case ORDER:
          case BY:
          case DESC:
          case ASC:
          case SKIPROWS:
          case LIMITROWS:
          case UNION:
          case DROP:
          case INDEX:
          case SEEK:
          case SCAN:
          case JOIN:
          case CONSTRAINT:
          case ASSERT:
          case IS:
          case NODE:
          case KEY:
          case UNIQUE:
          case ON:
          case AS:
          case OR:
          case XOR:
          case AND:
          case NOT:
          case STARTS:
          case ENDS:
          case CONTAINS:
          case IN:
          case COUNT:
          case FILTER:
          case EXTRACT:
          case REDUCE:
          case EXISTS:
          case ALL:
          case ANY:
          case NONE:
          case SINGLE:
          case CASE:
          case ELSE:
          case WHEN:
          case THEN:
          case END:
          case SHORTEST_PATH:
          case ALL_SHORTEST_PATH:
          case PLUS:
          case MINUS:
          case LPAREN:
          case LBRACKET:
          case LCURLY:
          case IDENTIFIER:
          case 152:{
            e2 = Expression();
            break;
            }
          default:
            jj_la1[84] = jj_gen;
            ;
          }
          jj_consume_token(RBRACKET);
ret=astFactory.listSlice(pos(t), subject, e1, e2);
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY Property(EXPRESSION subject) throws ParseException {EXPRESSION e;
  StringPos<POS> propKeyName;
    jj_consume_token(DOT);
    propKeyName = PropertyKeyName();
{if ("" != null) return astFactory.property(subject, propKeyName);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY PropertyExpression() throws ParseException {EXPRESSION subject;
  PROPERTY p;
    subject = Expression1();
    label_29:
    while (true) {
      p = Property(subject);
subject = p;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_29;
      }
    }
{if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression1() throws ParseException {EXPRESSION e = null; Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      e = NumberLiteral();
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
      break;
      }
    case 152:{
      e = Parameter();
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
e = astFactory.newTrueLiteral(pos(t));
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
e = astFactory.newFalseLiteral(pos(t));
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
e = astFactory.newNullLiteral(pos(t));
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      if (jj_2_25(3)) {
        e = CaseExpression();
      } else if (jj_2_26(3)) {
        t = jj_consume_token(COUNT);
        jj_consume_token(LPAREN);
        jj_consume_token(TIMES);
        jj_consume_token(RPAREN);
e = astFactory.newCountStar(pos(t));
      } else if (jj_2_27(3)) {
        e = MapLiteral();
      } else if (jj_2_28(3)) {
        e = ExistsSubQuery();
      } else if (jj_2_29(2)) {
        e = MapProjection();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LCURLY:{
          e = OldParameter();
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          if (jj_2_30(3)) {
            e = ListComprehension();
          } else if (jj_2_31(2147483647)) {
            e = PatternComprehension();
          } else if (jj_2_32(3)) {
            e = ListLiteral();
          } else if (jj_2_33(3)) {
            e = FilterExpression();
          } else if (jj_2_34(3)) {
            e = ExtractExpression();
          } else if (jj_2_35(3)) {
            e = ReduceExpression();
          } else if (jj_2_36(3)) {
            e = AllExpression();
          } else if (jj_2_37(3)) {
            e = AnyExpression();
          } else if (jj_2_38(3)) {
            e = NoneExpression();
          } else if (jj_2_39(3)) {
            e = SingleExpression();
          } else if (jj_2_40(2147483647)) {
            e = PatternExpression();
          } else if (jj_2_41(2)) {
            e = ShortestPathExpression();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case LPAREN:{
              jj_consume_token(LPAREN);
              e = Expression();
              jj_consume_token(RPAREN);
              break;
              }
            default:
              jj_la1[90] = jj_gen;
              if (jj_2_42(2147483647)) {
                e = FunctionInvocation();
              } else {
                switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
                case ESCAPED_SYMBOLIC_NAME:
                case TRUE:
                case FALSE:
                case NULL:
                case RETURN:
                case CREATE:
                case DELETE:
                case SET:
                case REMOVE:
                case DETACH:
                case MATCH:
                case WITH:
                case UNWIND:
                case USE:
                case GRAPH:
                case CALL:
                case YIELD:
                case LOAD:
                case CSV:
                case PERIODIC:
                case COMMIT:
                case HEADERS:
                case FROM:
                case FIELDTERMINATOR:
                case FOREACH:
                case WHERE:
                case DISTINCT:
                case MERGE:
                case OPTIONAL:
                case USING:
                case ORDER:
                case BY:
                case DESC:
                case ASC:
                case SKIPROWS:
                case LIMITROWS:
                case UNION:
                case DROP:
                case INDEX:
                case SEEK:
                case SCAN:
                case JOIN:
                case CONSTRAINT:
                case ASSERT:
                case IS:
                case NODE:
                case KEY:
                case UNIQUE:
                case ON:
                case AS:
                case OR:
                case XOR:
                case AND:
                case NOT:
                case STARTS:
                case ENDS:
                case CONTAINS:
                case IN:
                case COUNT:
                case FILTER:
                case EXTRACT:
                case REDUCE:
                case EXISTS:
                case ALL:
                case ANY:
                case NONE:
                case SINGLE:
                case CASE:
                case ELSE:
                case WHEN:
                case THEN:
                case END:
                case SHORTEST_PATH:
                case ALL_SHORTEST_PATH:
                case IDENTIFIER:{
                  e = Variable();
                  break;
                  }
                default:
                  jj_la1[91] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION CaseExpression() throws ParseException {Token t;
  EXPRESSION e = null;
  EXPRESSION x;
  List whens = new ArrayList();
  List thens = new ArrayList();
  EXPRESSION elze = null;
    t = jj_consume_token(CASE);
    if (jj_2_43(2147483647)) {
      e = Expression();
      jj_consume_token(WHEN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        jj_consume_token(WHEN);
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    x = Expression();
whens.add(x);
    jj_consume_token(THEN);
    x = Expression();
thens.add(x);
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_30;
      }
      jj_consume_token(WHEN);
      x = Expression();
whens.add(x);
      jj_consume_token(THEN);
      x = Expression();
thens.add(x);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      elze = Expression();
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    jj_consume_token(END);
{if ("" != null) return astFactory.caseExpression(pos(t), e, (List<EXPRESSION>)whens, (List<EXPRESSION>)thens, elze);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListComprehension() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
  EXPRESSION projection = null;
    t = jj_consume_token(LBRACKET);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BAR:{
      jj_consume_token(BAR);
      projection = Expression();
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listComprehension(pos(t), v, e, where, projection);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternComprehension() throws ParseException {Token t;
  VARIABLE v = null;
  PATTERN p;
  EXPRESSION where = null;
  EXPRESSION projection = null;
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      v = Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    p = EveryPathPattern();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      ;
    }
    jj_consume_token(BAR);
    projection = Expression();
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.patternComprehension(pos(t), v, p, where, projection);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void PatternComprehensionPrefix() throws ParseException {
    jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    EveryPathPattern();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      break;
      }
    case BAR:{
      jj_consume_token(BAR);
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public EXPRESSION FilterExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
    t = jj_consume_token(FILTER);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.filterExpression(pos(t), v, e, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ExtractExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
  EXPRESSION projection = null;
    t = jj_consume_token(EXTRACT);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BAR:{
      jj_consume_token(BAR);
      projection = Expression();
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.extractExpression(pos(t), v, e, where, projection);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ReduceExpression() throws ParseException {Token t;
  VARIABLE acc;
  EXPRESSION accExpr;
  VARIABLE v;
  EXPRESSION vExpr;
  EXPRESSION innerExpr;
    t = jj_consume_token(REDUCE);
    jj_consume_token(LPAREN);
    acc = Variable();
    jj_consume_token(EQ);
    accExpr = Expression();
    jj_consume_token(149);
    v = Variable();
    jj_consume_token(IN);
    vExpr = Expression();
    jj_consume_token(BAR);
    innerExpr = Expression();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.reduceExpression(pos(t), acc, accExpr, v, vExpr, innerExpr);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AllExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
    t = jj_consume_token(ALL);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allExpression(pos(t), v, e, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AnyExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
    t = jj_consume_token(ANY);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.anyExpression(pos(t), v, e, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NoneExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
    t = jj_consume_token(NONE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.noneExpression(pos(t), v, e, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SingleExpression() throws ParseException {Token t;
  VARIABLE v;
  EXPRESSION e;
  EXPRESSION where = null;
    t = jj_consume_token(SINGLE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.singleExpression(pos(t), v, e, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternExpression() throws ParseException {PATTERN p; Token t;
t = token;
    p = EveryPathPatternNonEmpty();
{if ("" != null) return astFactory.patternExpression(pos(t.next), p);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ShortestPathExpression() throws ParseException {PATTERN p; Token t;
t = token;
    p = ShortestPathPattern();
{if ("" != null) return astFactory.patternExpression(pos(t.next), p);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapProjection() throws ParseException {Token t;
  VARIABLE v;
  MAP_PROJECTION_ITEM x;
  List items = new ArrayList();
    v = Variable();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case DOT:
    case IDENTIFIER:{
      x = MapProjectionItem();
items.add(x);
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        break label_31;
      }
      jj_consume_token(149);
      x = MapProjectionItem();
items.add(x);
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapProjection(pos(t), v, (List<MAP_PROJECTION_ITEM>)items);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MAP_PROJECTION_ITEM MapProjectionItem() throws ParseException {Token t;
  StringPos<POS> p;
  EXPRESSION e;
  VARIABLE v;
    if (jj_2_44(2)) {
      p = PropertyKeyName();
      jj_consume_token(151);
      e = Expression();
{if ("" != null) return astFactory.mapProjectionLiteralEntry(p, e);}
    } else if (jj_2_45(2)) {
      jj_consume_token(DOT);
      p = PropertyKeyName();
{if ("" != null) return astFactory.mapProjectionProperty(p);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case TRUE:
      case FALSE:
      case NULL:
      case RETURN:
      case CREATE:
      case DELETE:
      case SET:
      case REMOVE:
      case DETACH:
      case MATCH:
      case WITH:
      case UNWIND:
      case USE:
      case GRAPH:
      case CALL:
      case YIELD:
      case LOAD:
      case CSV:
      case PERIODIC:
      case COMMIT:
      case HEADERS:
      case FROM:
      case FIELDTERMINATOR:
      case FOREACH:
      case WHERE:
      case DISTINCT:
      case MERGE:
      case OPTIONAL:
      case USING:
      case ORDER:
      case BY:
      case DESC:
      case ASC:
      case SKIPROWS:
      case LIMITROWS:
      case UNION:
      case DROP:
      case INDEX:
      case SEEK:
      case SCAN:
      case JOIN:
      case CONSTRAINT:
      case ASSERT:
      case IS:
      case NODE:
      case KEY:
      case UNIQUE:
      case ON:
      case AS:
      case OR:
      case XOR:
      case AND:
      case NOT:
      case STARTS:
      case ENDS:
      case CONTAINS:
      case IN:
      case COUNT:
      case FILTER:
      case EXTRACT:
      case REDUCE:
      case EXISTS:
      case ALL:
      case ANY:
      case NONE:
      case SINGLE:
      case CASE:
      case ELSE:
      case WHEN:
      case THEN:
      case END:
      case SHORTEST_PATH:
      case ALL_SHORTEST_PATH:
      case IDENTIFIER:{
        v = Variable();
{if ("" != null) return astFactory.mapProjectionVariable(v);}
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        t = jj_consume_token(TIMES);
{if ("" != null) return astFactory.mapProjectionAll(pos(t));}
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ExistsSubQuery() throws ParseException {Token t;
  List patterns;
  EXPRESSION where = null;
    t = jj_consume_token(EXISTS);
    jj_consume_token(LCURLY);
    if (jj_2_46(2)) {
      jj_consume_token(MATCH);
    } else {
      ;
    }
    patterns = PatternList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = Where();
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.existsSubQuery(pos(t), (List<PATTERN>)patterns, where);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Literal() throws ParseException {Token t; EXPRESSION e;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      e = NumberLiteral();
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
      break;
      }
    case 152:{
      e = Parameter();
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
e = astFactory.newTrueLiteral(pos(t));
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
e = astFactory.newFalseLiteral(pos(t));
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
e = astFactory.newNullLiteral(pos(t));
      break;
      }
    case LBRACKET:{
      e = ListLiteralOfLiterals();
      break;
      }
    case LCURLY:{
      e = MapLiteralOfLiterals();
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      e = FunctionInvocation();
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListLiteralOfLiterals() throws ParseException {Token t;
  EXPRESSION e;
  List list = new ArrayList();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case MINUS:
    case LBRACKET:
    case LCURLY:
    case IDENTIFIER:
    case 152:{
      e = Literal();
list.add(e);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    label_32:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        break label_32;
      }
      jj_consume_token(149);
      e = Literal();
list.add(e);
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral(pos(t), (List<EXPRESSION>)list);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapLiteralOfLiterals() throws ParseException {Token t;
  StringPos<POS> key;
  EXPRESSION value;
  List<StringPos<POS>> keys = new ArrayList();
  List<EXPRESSION> values = new ArrayList();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      key = PropertyKeyName();
      jj_consume_token(151);
      value = Literal();
keys.add(key); values.add(value);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    label_33:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        break label_33;
      }
      jj_consume_token(149);
      key = PropertyKeyName();
      jj_consume_token(151);
      value = Literal();
keys.add(key); values.add(value);
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapLiteral(pos(t), keys, values);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION StringLiteral() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
{if ("" != null) return astFactory.newString(pos(t), token.image);}
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
{if ("" != null) return astFactory.newString(pos(t), token.image);}
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NumberLiteral() throws ParseException {Token t; boolean negated = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:{
      t = jj_consume_token(DECIMAL_DOUBLE);
{if ("" != null) return astFactory.newDouble(pos(t), token.image);}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:{
        jj_consume_token(MINUS);
negated = true;
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        t = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newDecimalInteger(pos(t), token.image, negated);}
        break;
        }
      case UNSIGNED_HEX_INTEGER:{
        t = jj_consume_token(UNSIGNED_HEX_INTEGER);
{if ("" != null) return astFactory.newHexInteger(pos(t), token.image, negated);}
        break;
        }
      case UNSIGNED_OCTAL_INTEGER:{
        t = jj_consume_token(UNSIGNED_OCTAL_INTEGER);
{if ("" != null) return astFactory.newOctalInteger(pos(t), token.image, negated);}
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListLiteral() throws ParseException {Token t;
  EXPRESSION e;
  List list = new ArrayList();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case PLUS:
    case MINUS:
    case LPAREN:
    case LBRACKET:
    case LCURLY:
    case IDENTIFIER:
    case 152:{
      e = Expression();
list.add(e);
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      ;
    }
    label_34:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        break label_34;
      }
      jj_consume_token(149);
      e = Expression();
list.add(e);
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral(pos(t), (List<EXPRESSION>)list);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapLiteral() throws ParseException {Token t;
  StringPos<POS> key;
  EXPRESSION value;
  List<StringPos<POS>> keys = new ArrayList();
  List<EXPRESSION> values = new ArrayList();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      key = PropertyKeyName();
      jj_consume_token(151);
      value = Expression();
keys.add(key); values.add(value);
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    label_35:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[124] = jj_gen;
        break label_35;
      }
      jj_consume_token(149);
      key = PropertyKeyName();
      jj_consume_token(151);
      value = Expression();
keys.add(key); values.add(value);
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapLiteral(pos(t), keys, values);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StringPos<POS> PropertyKeyName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return new StringPos(t.image, pos(t));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Parameter() throws ParseException {Token t; VARIABLE v;
    t = jj_consume_token(152);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case IDENTIFIER:{
      v = Variable();
{if ("" != null) return astFactory.newParameter(pos(t), v);}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:{
      jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newParameter(pos(t), token.image);}
      break;
      }
    default:
      jj_la1[125] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION OldParameter() throws ParseException {Token t; VARIABLE v;
    t = jj_consume_token(LCURLY);
    v = Variable();
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.oldParameter(pos(t), v);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION FunctionInvocation() throws ParseException {Token before = token;
  List namespace;
  String name;
  boolean distinct = false;
  EXPRESSION e;
  List arguments = new ArrayList();
    namespace = Namespace();
    name = FunctionName();
    jj_consume_token(LPAREN);
    if (jj_2_47(2)) {
      jj_consume_token(DISTINCT);
distinct=true;
    } else {
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case TRUE:
    case FALSE:
    case NULL:
    case RETURN:
    case CREATE:
    case DELETE:
    case SET:
    case REMOVE:
    case DETACH:
    case MATCH:
    case WITH:
    case UNWIND:
    case USE:
    case GRAPH:
    case CALL:
    case YIELD:
    case LOAD:
    case CSV:
    case PERIODIC:
    case COMMIT:
    case HEADERS:
    case FROM:
    case FIELDTERMINATOR:
    case FOREACH:
    case WHERE:
    case DISTINCT:
    case MERGE:
    case OPTIONAL:
    case USING:
    case ORDER:
    case BY:
    case DESC:
    case ASC:
    case SKIPROWS:
    case LIMITROWS:
    case UNION:
    case DROP:
    case INDEX:
    case SEEK:
    case SCAN:
    case JOIN:
    case CONSTRAINT:
    case ASSERT:
    case IS:
    case NODE:
    case KEY:
    case UNIQUE:
    case ON:
    case AS:
    case OR:
    case XOR:
    case AND:
    case NOT:
    case STARTS:
    case ENDS:
    case CONTAINS:
    case IN:
    case COUNT:
    case FILTER:
    case EXTRACT:
    case REDUCE:
    case EXISTS:
    case ALL:
    case ANY:
    case NONE:
    case SINGLE:
    case CASE:
    case ELSE:
    case WHEN:
    case THEN:
    case END:
    case SHORTEST_PATH:
    case ALL_SHORTEST_PATH:
    case PLUS:
    case MINUS:
    case LPAREN:
    case LBRACKET:
    case LCURLY:
    case IDENTIFIER:
    case 152:{
      e = Expression();
arguments.add(e);
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      ;
    }
    label_36:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_36;
      }
      jj_consume_token(149);
      e = Expression();
arguments.add(e);
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.functionInvocation(pos(before.next), (List<String>)namespace, name, distinct, (List<EXPRESSION>)arguments);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> Namespace() throws ParseException {Token t;
  List parts = new ArrayList();
    label_37:
    while (true) {
      if (jj_2_48(2)) {
      } else {
        break label_37;
      }
      t = SymbolicNameString();
parts.add(t.image);
      jj_consume_token(DOT);
    }
{if ("" != null) return (List<String>)parts;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String FunctionName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return t.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<VARIABLE> VariableList1() throws ParseException {Token t;
  List list = new ArrayList();
    t = SymbolicNameString();
list.add(astFactory.newVariable(pos(t), t.image));
    label_38:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        break label_38;
      }
      jj_consume_token(149);
      t = SymbolicNameString();
list.add(astFactory.newVariable(pos(t), t.image));
    }
{if ("" != null) return (List<VARIABLE>)list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VARIABLE Variable() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return astFactory.newVariable(pos(t), t.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> SymbolicNameList1() throws ParseException {Token n;
  List list = new ArrayList();
    n = SymbolicNameString();
list.add(n.image);
    label_39:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        break label_39;
      }
      jj_consume_token(149);
      n = SymbolicNameString();
list.add(n.image);
    }
{if ("" != null) return (List<String>)list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token SymbolicNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:{
      t = jj_consume_token(ESCAPED_SYMBOLIC_NAME);
      break;
      }
    case RETURN:{
      t = jj_consume_token(RETURN);
      break;
      }
    case CREATE:{
      t = jj_consume_token(CREATE);
      break;
      }
    case DELETE:{
      t = jj_consume_token(DELETE);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    case REMOVE:{
      t = jj_consume_token(REMOVE);
      break;
      }
    case DETACH:{
      t = jj_consume_token(DETACH);
      break;
      }
    case MATCH:{
      t = jj_consume_token(MATCH);
      break;
      }
    case WITH:{
      t = jj_consume_token(WITH);
      break;
      }
    case UNWIND:{
      t = jj_consume_token(UNWIND);
      break;
      }
    case USE:{
      t = jj_consume_token(USE);
      break;
      }
    case GRAPH:{
      t = jj_consume_token(GRAPH);
      break;
      }
    case CALL:{
      t = jj_consume_token(CALL);
      break;
      }
    case YIELD:{
      t = jj_consume_token(YIELD);
      break;
      }
    case LOAD:{
      t = jj_consume_token(LOAD);
      break;
      }
    case CSV:{
      t = jj_consume_token(CSV);
      break;
      }
    case PERIODIC:{
      t = jj_consume_token(PERIODIC);
      break;
      }
    case COMMIT:{
      t = jj_consume_token(COMMIT);
      break;
      }
    case HEADERS:{
      t = jj_consume_token(HEADERS);
      break;
      }
    case FROM:{
      t = jj_consume_token(FROM);
      break;
      }
    case FIELDTERMINATOR:{
      t = jj_consume_token(FIELDTERMINATOR);
      break;
      }
    case FOREACH:{
      t = jj_consume_token(FOREACH);
      break;
      }
    case WHERE:{
      t = jj_consume_token(WHERE);
      break;
      }
    case DISTINCT:{
      t = jj_consume_token(DISTINCT);
      break;
      }
    case MERGE:{
      t = jj_consume_token(MERGE);
      break;
      }
    case OPTIONAL:{
      t = jj_consume_token(OPTIONAL);
      break;
      }
    case USING:{
      t = jj_consume_token(USING);
      break;
      }
    case ORDER:{
      t = jj_consume_token(ORDER);
      break;
      }
    case BY:{
      t = jj_consume_token(BY);
      break;
      }
    case DESC:{
      t = jj_consume_token(DESC);
      break;
      }
    case ASC:{
      t = jj_consume_token(ASC);
      break;
      }
    case SKIPROWS:{
      t = jj_consume_token(SKIPROWS);
      break;
      }
    case LIMITROWS:{
      t = jj_consume_token(LIMITROWS);
      break;
      }
    case UNION:{
      t = jj_consume_token(UNION);
      break;
      }
    case DROP:{
      t = jj_consume_token(DROP);
      break;
      }
    case INDEX:{
      t = jj_consume_token(INDEX);
      break;
      }
    case SEEK:{
      t = jj_consume_token(SEEK);
      break;
      }
    case SCAN:{
      t = jj_consume_token(SCAN);
      break;
      }
    case JOIN:{
      t = jj_consume_token(JOIN);
      break;
      }
    case CONSTRAINT:{
      t = jj_consume_token(CONSTRAINT);
      break;
      }
    case ASSERT:{
      t = jj_consume_token(ASSERT);
      break;
      }
    case IS:{
      t = jj_consume_token(IS);
      break;
      }
    case NODE:{
      t = jj_consume_token(NODE);
      break;
      }
    case KEY:{
      t = jj_consume_token(KEY);
      break;
      }
    case UNIQUE:{
      t = jj_consume_token(UNIQUE);
      break;
      }
    case ON:{
      t = jj_consume_token(ON);
      break;
      }
    case AS:{
      t = jj_consume_token(AS);
      break;
      }
    case OR:{
      t = jj_consume_token(OR);
      break;
      }
    case XOR:{
      t = jj_consume_token(XOR);
      break;
      }
    case AND:{
      t = jj_consume_token(AND);
      break;
      }
    case NOT:{
      t = jj_consume_token(NOT);
      break;
      }
    case STARTS:{
      t = jj_consume_token(STARTS);
      break;
      }
    case ENDS:{
      t = jj_consume_token(ENDS);
      break;
      }
    case CONTAINS:{
      t = jj_consume_token(CONTAINS);
      break;
      }
    case IN:{
      t = jj_consume_token(IN);
      break;
      }
    case COUNT:{
      t = jj_consume_token(COUNT);
      break;
      }
    case FILTER:{
      t = jj_consume_token(FILTER);
      break;
      }
    case EXTRACT:{
      t = jj_consume_token(EXTRACT);
      break;
      }
    case REDUCE:{
      t = jj_consume_token(REDUCE);
      break;
      }
    case EXISTS:{
      t = jj_consume_token(EXISTS);
      break;
      }
    case ALL:{
      t = jj_consume_token(ALL);
      break;
      }
    case ANY:{
      t = jj_consume_token(ANY);
      break;
      }
    case NONE:{
      t = jj_consume_token(NONE);
      break;
      }
    case SINGLE:{
      t = jj_consume_token(SINGLE);
      break;
      }
    case CASE:{
      t = jj_consume_token(CASE);
      break;
      }
    case ELSE:{
      t = jj_consume_token(ELSE);
      break;
      }
    case WHEN:{
      t = jj_consume_token(WHEN);
      break;
      }
    case THEN:{
      t = jj_consume_token(THEN);
      break;
      }
    case END:{
      t = jj_consume_token(END);
      break;
      }
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_3R_71()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_70()) return true;
    if (jj_scan_token(151)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_46()) return true;
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    if (jj_3_17()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(TIMES)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(USING)) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_46()) return true;
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(151)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(148)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(MATCH)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    xsp = jj_scanpos;
    if (jj_3R_79()) jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    xsp = jj_scanpos;
    if (jj_3R_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(151)) return true;
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_146()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_177()
 {
    Token xsp;
    if (jj_3R_188()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_188()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(BAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_scan_token(149)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) return true;
    }
    return false;
  }

  private boolean jj_3R_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(STRING_LITERAL1)) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(STRING_LITERAL2)) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) return true;
    }
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(151)) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(DECIMAL_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) return true;
    }
    return false;
  }

  private boolean jj_3R_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_178()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_229()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_scan_token(UNSIGNED_HEX_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(UNSIGNED_OCTAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(TIMES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) jj_scanpos = xsp;
    if (jj_scan_token(DOTDOT)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_187()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) return true;
    }
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_81()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(USE)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(GRAPH)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(GRAPH)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(149)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(151)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_110()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_111()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_70()) return true;
    if (jj_scan_token(151)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(152)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(UNSIGNED_DECIMAL_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_3R_135()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_136()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_3R_49()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_158()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(149)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_3R_72()) return true;
    if (jj_3R_157()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_48()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_69()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_3R_50()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_137()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(NEQ)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(NEQ2)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(LE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(GE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(GT)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_51()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(149)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(REGEQ)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(STARTS)) return true;
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(ENDS)) return true;
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(CONTAINS)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) return true;
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(WITH)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_3R_83()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_182()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    }
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_114()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_189()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(TIMES)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(MODULO)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_3R_138()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_201()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(REMOVE)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(POW)) return true;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_3R_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_223()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) jj_scanpos = xsp;
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(DETACH)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_234()) jj_scanpos = xsp;
    if (jj_scan_token(MATCH)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) jj_scanpos = xsp;
    if (jj_scan_token(DOTDOT)) return true;
    xsp = jj_scanpos;
    if (jj_3R_250()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(OPTIONAL)) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_74()) return true;
    Token xsp;
    if (jj_3R_75()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_75()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(TIMES)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(SEEK)) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(UNWIND)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_66()) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_68()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_69()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_69()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) return true;
    }
    if (jj_3R_44()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_44()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_237()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_44()) return true;
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(CALL)) return true;
    if (jj_3R_72()) return true;
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_44()) return true;
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    xsp = jj_scanpos;
    if (jj_3R_242()) jj_scanpos = xsp;
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) return true;
    }
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(LOAD)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(FOREACH)) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(CALL)) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_scan_token(REDUCE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(149)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_44()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_scan_token(ALL)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_246()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_116()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_251()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_scan_token(ANY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) return true;
    }
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(NONE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_174()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(SHORTEST_PATH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(ALL_SHORTEST_PATH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_45()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(SINGLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(149)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_66()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(148)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_66()) return true;
    Token xsp;
    if (jj_3_16()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_169()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CypherTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[131];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x800e800,0x0,0x0,0x800e800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x2000,0x2000,0x0,0x0,0x0,0x800e800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800e800,0x800e800,0x0,0x0,0x0,0x800e800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800e800,0x800e800,0x0,0x0,0x0,0x8000000,0x0,0xe000,0xe800,0x800e800,0x0,0x0,0x0,0x2000,0x800e800,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x15ff8000,0x0,0x15ff8000,0x0,0x0,0x15ff8000,0x1ff8000,0x14000000,0xfffff880,0x0,0x0,0xfffff880,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff800,0x0,0xfffff800,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x210000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x400000,0x80,0x0,0x15ff8000,0x0,0x0,0x0,0x0,0x0,0xfffff800,0x0,0x0,0x0,0x0,0xfffff800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff880,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff880,0xfffff880,0x0,0x0,0x0,0x7080,0x0,0x0,0xfffff800,0x0,0x0,0x0,0x0,0x0,0xfffff800,0x0,0xfffff800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff800,0x0,0xfffff800,0x0,0xfffff880,0xfffff880,0x0,0xfffff800,0x0,0x80,0x0,0x0,0x0,0xfffff880,0x0,0xfffff800,0x0,0xfffff800,0xfffff880,0x0,0x0,0x0,0xfffff800,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x1ca,0x0,0xca,0x8000,0x0,0xca,0xc2,0x8,0xffffffff,0x0,0x0,0xffffffff,0x200,0x2000,0x4000,0x10000000,0x0,0x1000,0x800,0x10,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x80,0x10,0x100,0x1a0000,0x8000000,0x0,0x0,0x0,0x0,0x10,0x0,0x10000000,0x0,0x0,0x4,0xca,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x40000000,0x80000000,0xffffffff,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x10,0x0,0xffffffff,0x10,0xffffffff,0x10,0x10,0x10,0x0,0x10,0x10,0x10,0x10,0xffffffff,0x0,0xffffffff,0x10,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0xffffffff,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0xfffffc01,0x0,0x0,0xfffffc01,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffc01,0x0,0x3ffffc01,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x30000000,0x3ffffc01,0x0,0x0,0x0,0x40,0x3ffffc01,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x40,0x80000000,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc01,0xfe,0xfc,0x3d00,0x1,0x3c00,0xc0000000,0xc0000000,0x0,0x0,0x0,0xc0000000,0x0,0xfffffc01,0xfffffc01,0x0,0x0,0x0,0x80000000,0x0,0x0,0x3ffffc01,0x2000000,0x2000000,0x1000000,0x0,0x0,0x3ffffc01,0x0,0x3ffffc01,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffffc01,0x0,0x3ffffc01,0x0,0xbffffc01,0xbffffc01,0x0,0x3ffffc01,0x0,0x0,0x80000000,0x0,0x80000000,0xfffffc01,0x0,0x3ffffc01,0x0,0x3ffffc01,0xfffffc01,0x0,0x0,0x0,0x3ffffc01,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1002541,0x200000,0x200000,0x1002541,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x200000,0x2000,0x200000,0x2000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x40,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x40,0x0,0x40,0x0,0x2000,0x800000,0x1000400,0x1000400,0x20000,0x2000,0x1000,0x800000,0x800000,0x1,0x1000400,0x100,0x40000,0x20000,0x10000,0x40000,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x1002540,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x7,0x8,0x0,0x800110,0x1002540,0x1002540,0x800010,0x100,0x10,0x1000000,0x400,0x40,0x2000,0x0,0x0,0x0,0x0,0x1000,0x2000,0x0,0x2000,0x1000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x2010,0x200000,0x2010,0x0,0x1002500,0x1002500,0x200000,0x2000,0x200000,0x0,0x0,0x0,0x0,0x1002540,0x200000,0x2000,0x200000,0x2000,0x1002540,0x200000,0x200000,0x200000,0x2000,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[48];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public Cypher(final CharStream stream) {
	 token_source = new CypherTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 131; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 131; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public Cypher(final CypherTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 131; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final CypherTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 131; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  private static final class LookaheadSuccess extends IllegalStateException { }
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[153];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 131; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 153; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 48; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
              case 31: jj_3_32(); break;
              case 32: jj_3_33(); break;
              case 33: jj_3_34(); break;
              case 34: jj_3_35(); break;
              case 35: jj_3_36(); break;
              case 36: jj_3_37(); break;
              case 37: jj_3_38(); break;
              case 38: jj_3_39(); break;
              case 39: jj_3_40(); break;
              case 40: jj_3_41(); break;
              case 41: jj_3_42(); break;
              case 42: jj_3_43(); break;
              case 43: jj_3_44(); break;
              case 44: jj_3_45(); break;
              case 45: jj_3_46(); break;
              case 46: jj_3_47(); break;
              case 47: jj_3_48(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
