/* Cypher.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. Cypher.java */
/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.cypher.internal.parser.javacc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.neo4j.cypher.internal.parser.common.ast.factory.AccessType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory.StringPos;
import org.neo4j.cypher.internal.parser.common.ast.factory.ActionType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.parser.common.ast.factory.CallInTxsOnErrorBehaviourType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintVersion;
import org.neo4j.cypher.internal.parser.common.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.parser.common.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ParameterType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ParserCypherTypeName;
import org.neo4j.cypher.internal.parser.common.ast.factory.ParserNormalForm;
import org.neo4j.cypher.internal.parser.common.ast.factory.ParserTrimSpecification;
import org.neo4j.cypher.internal.parser.common.ast.factory.ScopeType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypher.internal.parser.common.ast.factory.SimpleEither;
import org.neo4j.cypher.internal.parser.common.InvalidUnicodeLiteral;
import org.neo4j.cypher.internal.parser.common.deprecation.DeprecatedChars;

public class Cypher<STATEMENTS,
                    STATEMENT,
                    QUERY extends STATEMENT,
                    CLAUSE,
                    FINISH_CLAUSE extends CLAUSE,
                    RETURN_CLAUSE extends CLAUSE,
                    RETURN_ITEM,
                    RETURN_ITEMS,
                    ORDER_ITEM,
                    PATTERN,
                    NODE_PATTERN extends PATTERN_ATOM,
                    REL_PATTERN extends PATTERN_ATOM,
                    PATH_LENGTH,
                    SET_CLAUSE extends CLAUSE,
                    SET_ITEM,
                    REMOVE_ITEM,
                    CALL_RESULT_ITEM,
                    HINT,
                    EXPRESSION,
                    LABEL_EXPRESSION,
                    FUNCTION_INVOCATION extends EXPRESSION,
                    PARAMETER extends EXPRESSION,
                    VARIABLE extends EXPRESSION,
                    PROPERTY extends EXPRESSION,
                    MAP_PROJECTION_ITEM,
                    USE_CLAUSE extends CLAUSE,
                    STATEMENT_WITH_GRAPH extends STATEMENT,
                    ADMINISTRATION_COMMAND extends STATEMENT_WITH_GRAPH,
                    SCHEMA_COMMAND extends STATEMENT_WITH_GRAPH,
                    YIELD extends CLAUSE,
                    WHERE,
                    DATABASE_SCOPE,
                    WAIT_CLAUSE,
                    ADMINISTRATION_ACTION,
                    GRAPH_SCOPE,
                    PRIVILEGE_TYPE,
                    PRIVILEGE_RESOURCE,
                    PRIVILEGE_QUALIFIER,
                    AUTH,
                    AUTH_ATTRIBUTE,
                    SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
                    SUBQUERY_IN_TRANSACTIONS_BATCH_PARAMETERS,
                    SUBQUERY_IN_TRANSACTIONS_CONCURRENCY_PARAMETERS,
                    SUBQUERY_IN_TRANSACTIONS_ERROR_PARAMETERS,
                    SUBQUERY_IN_TRANSACTIONS_REPORT_PARAMETERS,
                    POS,
                    ENTITY_TYPE,
                    PATTERN_QUANTIFIER,
                    PATTERN_ATOM,
                    DATABASE_NAME,
                    PATTERN_SELECTOR,
                    MATCH_MODE,
                    PATTERN_ELEMENT> implements CypherConstants {

    ASTExceptionFactory exceptionFactory;
    ASTFactory<STATEMENTS,
               STATEMENT,
               QUERY,
               CLAUSE,
               FINISH_CLAUSE,
               RETURN_CLAUSE,
               RETURN_ITEM,
               RETURN_ITEMS,
               ORDER_ITEM,
               PATTERN,
               NODE_PATTERN,
               REL_PATTERN,
               PATH_LENGTH,
               SET_CLAUSE,
               SET_ITEM,
               REMOVE_ITEM,
               CALL_RESULT_ITEM,
               HINT,
               EXPRESSION,
               LABEL_EXPRESSION,
               FUNCTION_INVOCATION,
               PARAMETER,
               VARIABLE,
               PROPERTY,
               MAP_PROJECTION_ITEM,
               USE_CLAUSE,
               STATEMENT_WITH_GRAPH,
               ADMINISTRATION_COMMAND,
               SCHEMA_COMMAND,
               YIELD,
               WHERE,
               DATABASE_SCOPE,
               WAIT_CLAUSE,
               ADMINISTRATION_ACTION,
               GRAPH_SCOPE,
               PRIVILEGE_TYPE,
               PRIVILEGE_RESOURCE,
               PRIVILEGE_QUALIFIER,
               AUTH,
               AUTH_ATTRIBUTE,
               SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
               SUBQUERY_IN_TRANSACTIONS_BATCH_PARAMETERS,
               SUBQUERY_IN_TRANSACTIONS_CONCURRENCY_PARAMETERS,
               SUBQUERY_IN_TRANSACTIONS_ERROR_PARAMETERS,
               SUBQUERY_IN_TRANSACTIONS_REPORT_PARAMETERS,
               POS,
               ENTITY_TYPE,
               PATTERN_QUANTIFIER,
               PATTERN_ATOM,
               DATABASE_NAME,
               PATTERN_SELECTOR,
               MATCH_MODE,
               PATTERN_ELEMENT> astFactory;
    // to distinguish a bar that follows a label expression from the or-operator as part of a label expression, this stack keeps track of the current context
    Stack<ExpectBar> labelExpressionStack = new Stack<>();

    public Cypher(ASTFactory<STATEMENTS,
                             STATEMENT,
                             QUERY,
                             CLAUSE,
                             FINISH_CLAUSE,
                             RETURN_CLAUSE,
                             RETURN_ITEM,
                             RETURN_ITEMS,
                             ORDER_ITEM,
                             PATTERN,
                             NODE_PATTERN,
                             REL_PATTERN,
                             PATH_LENGTH,
                             SET_CLAUSE,
                             SET_ITEM,
                             REMOVE_ITEM,
                             CALL_RESULT_ITEM,
                             HINT,
                             EXPRESSION,
                             LABEL_EXPRESSION,
                             FUNCTION_INVOCATION,
                             PARAMETER,
                             VARIABLE,
                             PROPERTY,
                             MAP_PROJECTION_ITEM,
                             USE_CLAUSE,
                             STATEMENT_WITH_GRAPH,
                             ADMINISTRATION_COMMAND,
                             SCHEMA_COMMAND,
                             YIELD,
                             WHERE,
                             DATABASE_SCOPE,
                             WAIT_CLAUSE,
                             ADMINISTRATION_ACTION,
                             GRAPH_SCOPE,
                             PRIVILEGE_TYPE,
                             PRIVILEGE_RESOURCE,
                             PRIVILEGE_QUALIFIER,
                             AUTH,
                             AUTH_ATTRIBUTE,
                             SUBQUERY_IN_TRANSACTIONS_PARAMETERS,
                             SUBQUERY_IN_TRANSACTIONS_BATCH_PARAMETERS,
                             SUBQUERY_IN_TRANSACTIONS_CONCURRENCY_PARAMETERS,
                             SUBQUERY_IN_TRANSACTIONS_ERROR_PARAMETERS,
                             SUBQUERY_IN_TRANSACTIONS_REPORT_PARAMETERS,
                             POS,
                             ENTITY_TYPE,
                             PATTERN_QUANTIFIER,
                             PATTERN_ATOM,
                             DATABASE_NAME,
                             PATTERN_SELECTOR,
                             MATCH_MODE,
                             PATTERN_ELEMENT> astFactory,
                  ASTExceptionFactory exceptionFactory,
                  CharStream stream) {
        this(stream);
        this.astFactory = astFactory;
        this.exceptionFactory = exceptionFactory;
    }

    private POS pos( Token t )
    {
        return t != null ? astFactory.inputPosition( t.beginOffset, t.beginLine, t.beginColumn ) : null;
    }

    private POS endPos( Token t )
        {
            return t != null ? astFactory.inputPosition( t.endOffset, t.endLine, t.endColumn ) : null;
        }

    private ENTITY_TYPE nodeType()
    {
        return astFactory.nodeType();
    }

    private ENTITY_TYPE relationshipType()
    {
        return astFactory.relationshipType();
    }

    private ENTITY_TYPE nodeOrRelationshipType()
    {
        return astFactory.nodeOrRelationshipType();
    }

    private void assertValidType( Token t, String expected, String actual ) throws Exception
    {
        if ( expected != null && !expected.equals(actual) )
        {
            throw exceptionFactory.syntaxException( new ParseException(
                String.format("Invalid input '%s': expected \"%s\"", t.image, expected ) ), t.beginOffset, t.beginLine, t.beginColumn );
        }
    }

    private void assertNotAlreadySet( Object object, Token token, String errorMessage ) throws Exception
    {
        if ( object != null )
        {
            throw exceptionFactory.syntaxException( new ParseException( errorMessage ), token.beginOffset, token.beginLine, token.beginColumn );
        }
    }

/** Root production. */
  final public STATEMENTS Statements() throws ParseException, Exception {STATEMENT x;
    List<STATEMENT> stmts = new ArrayList<>();
    try {
      x = Statement();
stmts.add( x );
      label_1:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_1;
        }
        jj_consume_token(SEMICOLON);
        x = Statement();
stmts.add( x );
      }
      if (jj_2_2(2)) {
        jj_consume_token(SEMICOLON);
      } else {
        ;
      }
      jj_consume_token(0);
{if ("" != null) return astFactory.statements(stmts);}
    } catch (ParseException e) {
Token t = e.currentToken.next;
        if ( e.getMessage().contains( "Encountered \"<EOF>\"" ) )
        {
            throw exceptionFactory.syntaxException( t.image, ParseExceptions.expected( e.expectedTokenSequences, e.tokenImage, e.currentToken.image ), e,
                                                   t.endOffset + 1, t.endLine, t.endColumn + 1 );
        }
        else
        {
            throw exceptionFactory.syntaxException( t.image, ParseExceptions.expected( e.expectedTokenSequences, e.tokenImage, e.currentToken.image ), e,
                                                   t.beginOffset, t.beginLine, t.beginColumn );
        }
    } catch (InvalidUnicodeLiteral e) {
throw exceptionFactory.syntaxException( e, e.offset, e.line, e.column );
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT Statement() throws ParseException, Exception {STATEMENT statement;
    USE_CLAUSE useClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USING:{
      PeriodicCommitQueryHintFailure();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USE:{
      useClause = UseClause();
      statement = SingleQueryOrCommandWithUseClause(useClause);
      break;
      }
    case ALTER:
    case CALL:
    case CREATE:
    case DEALLOCATE:
    case DELETE:
    case DENY:
    case DETACH:
    case DROP:
    case DRYRUN:
    case ENABLE:
    case FINISH:
    case FOREACH:
    case GRANT:
    case INSERT:
    case LIMITROWS:
    case LOAD:
    case MATCH:
    case MERGE:
    case NODETACH:
    case OFFSET:
    case OPTIONAL:
    case ORDER:
    case REALLOCATE:
    case RENAME:
    case REMOVE:
    case RETURN:
    case REVOKE:
    case SET:
    case SHOW:
    case SKIPROWS:
    case START:
    case STOP:
    case TERMINATE:
    case UNWIND:
    case WITH:{
      statement = SingleQueryOrCommand();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT SingleQueryOrCommand() throws ParseException, Exception {STATEMENT statement = null;
    QUERY query = null;
    if (jj_2_3(2)) {
      statement = CreateCommand(null);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case DEALLOCATE:
      case DENY:
      case DROP:
      case DRYRUN:
      case ENABLE:
      case GRANT:
      case REALLOCATE:
      case RENAME:
      case REVOKE:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:{
        statement = Command(null);
        break;
        }
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FINISH:
      case FOREACH:
      case INSERT:
      case LIMITROWS:
      case LOAD:
      case MATCH:
      case MERGE:
      case NODETACH:
      case OFFSET:
      case OPTIONAL:
      case ORDER:
      case REMOVE:
      case RETURN:
      case SET:
      case SKIPROWS:
      case UNWIND:
      case USE:
      case WITH:{
        query = SingleQuery();
        label_2:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNION:{
            break;
            }
          default:
            jj_la1[2] = jj_gen;
            break label_2;
          }
          query = Union(query);
        }
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if ( query != null )
        {
            {if ("" != null) return query;}
        }
        {if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT SingleQueryOrCommandWithUseClause(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT statement = null;
    QUERY query = null;
    if (jj_2_4(2)) {
      statement = CreateCommand(useClause);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case DEALLOCATE:
      case DENY:
      case DROP:
      case DRYRUN:
      case ENABLE:
      case GRANT:
      case REALLOCATE:
      case RENAME:
      case REVOKE:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:{
        statement = Command(useClause);
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        query = SingleQueryWithUseClause(useClause);
        label_3:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNION:{
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
          query = Union(query);
        }
      }
    }
if ( query != null )
        {
            {if ("" != null) return query;}
        }
        {if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void PeriodicCommitQueryHintFailure() throws ParseException, Exception {Token tPeriodicCommit;
    jj_consume_token(USING);
    tPeriodicCommit = jj_consume_token(PERIODIC);
    jj_consume_token(COMMIT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:{
      jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      ;
    }
throw exceptionFactory.syntaxException(
            new ParseException( ASTExceptionFactory.periodicCommitNotSupported ),
            tPeriodicCommit.beginOffset, tPeriodicCommit.beginLine, tPeriodicCommit.beginColumn );
}

  final public QUERY RegularQuery() throws ParseException, Exception {QUERY x;
    x = SingleQuery();
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNION:{
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      x = Union(x);
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY Union(QUERY lhs) throws ParseException, Exception {Token t;
    QUERY rhs;
    boolean all = false;
    t = jj_consume_token(UNION);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:
    case DISTINCT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:{
        jj_consume_token(ALL);
all = true;
        break;
        }
      case DISTINCT:{
        jj_consume_token(DISTINCT);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    rhs = SingleQuery();
{if ("" != null) return astFactory.newUnion( pos( t ), lhs, rhs, all );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY SingleQuery() throws ParseException, Exception {CLAUSE x;
    List<CLAUSE> clauses = new ArrayList<>();
    label_5:
    while (true) {
      x = Clause();
clauses.add( x );
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FINISH:
      case FOREACH:
      case INSERT:
      case LIMITROWS:
      case LOAD:
      case MATCH:
      case MERGE:
      case NODETACH:
      case OFFSET:
      case OPTIONAL:
      case ORDER:
      case REMOVE:
      case RETURN:
      case SET:
      case SKIPROWS:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
    }
{if ("" != null) return astFactory.newSingleQuery( clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public QUERY SingleQueryWithUseClause(CLAUSE useClause) throws ParseException, Exception {CLAUSE x;
    List<CLAUSE> clauses = new ArrayList<>();
    if ( useClause != null )
    {
      clauses.add( useClause );
    }
    label_6:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FINISH:
      case FOREACH:
      case INSERT:
      case LIMITROWS:
      case LOAD:
      case MATCH:
      case MERGE:
      case NODETACH:
      case OFFSET:
      case OPTIONAL:
      case ORDER:
      case REMOVE:
      case RETURN:
      case SET:
      case SKIPROWS:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_6;
      }
      x = Clause();
clauses.add( x );
    }
{if ("" != null) return astFactory.newSingleQuery( clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE Clause() throws ParseException, Exception {CLAUSE x = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USE:{
      x = UseClause();
      break;
      }
    case FINISH:{
      x = FinishClause();
      break;
      }
    case RETURN:{
      x = ReturnClause();
      break;
      }
    case CREATE:{
      x = CreateClause();
      break;
      }
    case INSERT:{
      x = InsertClause();
      break;
      }
    case DELETE:
    case DETACH:
    case NODETACH:{
      x = DeleteClause();
      break;
      }
    case SET:{
      x = SetClause();
      break;
      }
    case REMOVE:{
      x = RemoveClause();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      if (jj_2_5(2)) {
        x = MatchClause();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MERGE:{
          x = MergeClause();
          break;
          }
        case WITH:{
          x = WithClause();
          break;
          }
        case UNWIND:{
          x = UnwindClause();
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          if (jj_2_6(3)) {
            x = CallClause();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case CALL:
            case OPTIONAL:{
              x = SubqueryClause();
              break;
              }
            case LOAD:{
              x = LoadCSVClause();
              break;
              }
            case FOREACH:{
              x = ForeachClause();
              break;
              }
            case LIMITROWS:
            case OFFSET:
            case ORDER:
            case SKIPROWS:{
              x = OrderBySkipLimitClause();
              break;
              }
            default:
              jj_la1[14] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
{if ("" != null) return x;}
    throw new IllegalStateException ("Missing return statement in function");
}

// USE
  final public 
USE_CLAUSE UseClause() throws ParseException, Exception {Token t;
    USE_CLAUSE useClause;
    t = jj_consume_token(USE);
    if (jj_2_7(2)) {
      jj_consume_token(GRAPH);
      useClause = graphReference(t);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        useClause = graphReference(t);
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return useClause;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public USE_CLAUSE graphReference(Token t) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> aliasName;
    FUNCTION_INVOCATION functionInvocation;
    USE_CLAUSE useClause;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      useClause = graphReference(t);
      jj_consume_token(RPAREN);
{if ("" != null) return useClause;}
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      if (jj_2_8(2147483647)) {
        functionInvocation = FunctionInvocation(true);
{if ("" != null) return astFactory.functionUseClause(pos(t), functionInvocation);}
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          aliasName = SymbolicAliasName();
{if ("" != null) return astFactory.directUseClause(pos(t), aliasName.getLocalAliasName(astFactory));}
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// FINISH
  final public 
FINISH_CLAUSE FinishClause() throws ParseException, Exception {Token t;
    t = jj_consume_token(FINISH);
{if ("" != null) return astFactory.newFinishClause( pos( t ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

// RETURN
  final public 
RETURN_CLAUSE ReturnClause() throws ParseException, Exception {Token t;
    RETURN_CLAUSE clause = null;
    t = jj_consume_token(RETURN);
    clause = ReturnBody(t);
{if ("" != null) return clause;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_CLAUSE ReturnBody(Token t) throws ParseException, Exception {Token skipPosition = null;
    Token limitPosition = null;
    boolean distinct = false;
    List<ORDER_ITEM> order = new ArrayList<>();
    Token orderPos = null;
    EXPRESSION skip = null;
    EXPRESSION limit = null;
    ORDER_ITEM o = null;
    RETURN_ITEM x;
    RETURN_ITEMS returnItems;
    if (jj_2_9(2)) {
      jj_consume_token(DISTINCT);
distinct = true;
    } else {
      ;
    }
    returnItems = ReturnItems();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      orderPos = jj_consume_token(ORDER);
      jj_consume_token(BY);
      o = OrderItem();
order.add( o );
      label_7:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        o = OrderItem();
order.add( o );
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OFFSET:
    case SKIPROWS:{
skipPosition=token.next;
      skip = Skip();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LIMITROWS:{
limitPosition=token.next;
      limit = Limit();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.newReturnClause(  pos( t ), distinct, returnItems, order, pos( orderPos ), skip, pos( skipPosition ), limit, pos( limitPosition ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEM ReturnItem() throws ParseException, Exception {EXPRESSION e;
    VARIABLE v = null;
    Token eStart;
    Token eEnd;
eStart = token;
    e = Expression();
eEnd = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      ;
    }
if ( v != null )
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, v );}
        }
        else
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, eStart.next.beginOffset, eEnd.endOffset );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEMS ReturnItems() throws ParseException, Exception {Token returnItemsPosition;
    RETURN_ITEM x;
    List<RETURN_ITEM> returnItems = new ArrayList<>();
    boolean returnAll = false;
returnItemsPosition = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
returnAll = true;
      label_8:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        x = ReturnItem();
returnItems.add( x );
      }
      break;
      }
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      x = ReturnItem();
returnItems.add( x );
      label_9:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        x = ReturnItem();
returnItems.add( x );
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.newReturnItems( pos( returnItemsPosition.next ), returnAll, returnItems );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ORDER_ITEM OrderItem() throws ParseException, Exception {Token t;
    EXPRESSION e;
t = token;
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESC:
    case DESCENDING:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DESC:{
        jj_consume_token(DESC);
        break;
        }
      case DESCENDING:{
        jj_consume_token(DESCENDING);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return astFactory.orderDesc( pos( t.next ), e );}
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASC:
      case ASCENDING:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ASC:{
          jj_consume_token(ASC);
          break;
          }
        case ASCENDING:{
          jj_consume_token(ASCENDING);
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.orderAsc( pos( t.next ), e );}
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Skip() throws ParseException, Exception {EXPRESSION e;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OFFSET:{
      jj_consume_token(OFFSET);
      break;
      }
    case SKIPROWS:{
      jj_consume_token(SKIPROWS);
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Limit() throws ParseException, Exception {EXPRESSION e;
    jj_consume_token(LIMITROWS);
    e = Expression();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

// WHERE
  final public 
WHERE WhereClause() throws ParseException, Exception {Token t;
    EXPRESSION e;
    t = jj_consume_token(WHERE);
    e = Expression();
{if ("" != null) return astFactory.whereClause( pos( t ), e );}
    throw new IllegalStateException ("Missing return statement in function");
}

// WITH
  final public 
CLAUSE WithClause() throws ParseException, Exception {Token t;
    RETURN_CLAUSE returnClause;
    WHERE where = null;
    t = jj_consume_token(WITH);
    returnClause = ReturnBody(t);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.withClause( pos( t ), returnClause, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

// CREATE
  final public 
CLAUSE CreateClause() throws ParseException, Exception {Token t;
    List<PATTERN> patterns;
    t = jj_consume_token(CREATE);
    patterns = PatternList();
{if ("" != null) return astFactory.createClause( pos( t ), patterns );}
    throw new IllegalStateException ("Missing return statement in function");
}

// INSERT
  final public 
CLAUSE InsertClause() throws ParseException, Exception {Token t;
    List<PATTERN> patterns;
    t = jj_consume_token(INSERT);
    patterns = InsertPatternList();
{if ("" != null) return astFactory.insertClause( pos( t ), patterns );}
    throw new IllegalStateException ("Missing return statement in function");
}

// SET
  final public 
SET_CLAUSE SetClause() throws ParseException, Exception {Token t;
    SET_ITEM item;
    List<SET_ITEM> items = new ArrayList<>();
    t = jj_consume_token(SET);
    item = SetItem();
items.add( item );
    label_10:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      item = SetItem();
items.add( item );
    }
{if ("" != null) return astFactory.setClause( pos( t ), items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SET_ITEM SetItem() throws ParseException, Exception {EXPRESSION e;
    PROPERTY p;
    EXPRESSION d;
    VARIABLE v;
    SET_ITEM setItem = null;
    if (jj_2_10(2147483647)) {
      p = PropertyExpression();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setProperty( p, e );}
    } else if (jj_2_11(2147483647)) {
      d = DynamicPropertyExpression();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setDynamicProperty( d, e );}
    } else if (jj_2_12(2)) {
      v = Variable();
      jj_consume_token(EQ);
      e = Expression();
{if ("" != null) return astFactory.setVariable( v, e );}
    } else if (jj_2_13(2)) {
      v = Variable();
      jj_consume_token(PLUSEQUAL);
      e = Expression();
{if ("" != null) return astFactory.addAndSetVariable( v, e );}
    } else if (jj_2_14(2)) {
      v = Variable();
      setItem = SetNodeLabels(v);
{if ("" != null) return setItem;}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        v = Variable();
        setItem = SetNodeLabelsIs(v);
{if ("" != null) return setItem;}
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// REMOVE
  final public 
CLAUSE RemoveClause() throws ParseException, Exception {Token t;
    REMOVE_ITEM item;
    List<REMOVE_ITEM> items = new ArrayList<>();
    t = jj_consume_token(REMOVE);
    item = RemoveItem();
items.add( item );
    label_11:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      item = RemoveItem();
items.add( item );
    }
{if ("" != null) return astFactory.removeClause( pos( t ), items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REMOVE_ITEM RemoveItem() throws ParseException, Exception {EXPRESSION e;
    PROPERTY p;
    VARIABLE v;
    REMOVE_ITEM removeItem = null;
    if (jj_2_15(2147483647)) {
      p = PropertyExpression();
{if ("" != null) return astFactory.removeProperty( p );}
    } else if (jj_2_16(2147483647)) {
      e = DynamicPropertyExpression();
{if ("" != null) return astFactory.removeDynamicProperty( e );}
    } else if (jj_2_17(2)) {
      v = Variable();
      removeItem = RemoveNodeLabelsColon(v);
{if ("" != null) return removeItem;}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        v = Variable();
        removeItem = RemoveNodeLabelsIs(v);
{if ("" != null) return removeItem;}
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// DELETE
  final public 
CLAUSE DeleteClause() throws ParseException, Exception {Token detachT = null;
    Token t;
    boolean detach = false;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DETACH:
    case NODETACH:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DETACH:{
        detachT = jj_consume_token(DETACH);
detach = true;
        break;
        }
      case NODETACH:{
        detachT = jj_consume_token(NODETACH);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    t = jj_consume_token(DELETE);
    e = Expression();
list.add( e );
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      e = Expression();
list.add( e );
    }
{if ("" != null) return astFactory.deleteClause( pos( detachT != null ? detachT : t ), detach, list );}
    throw new IllegalStateException ("Missing return statement in function");
}

// MATCH
  final public 
CLAUSE MatchClause() throws ParseException, Exception {Token optionalT = null;
    Token t;
    Token whereToken = null;
    boolean optional = false;
    MATCH_MODE matchMode = null;
    List<PATTERN> patterns;
    List<HINT> hints;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONAL:{
      optionalT = jj_consume_token(OPTIONAL);
optional = true;
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    t = jj_consume_token(MATCH);
    if (jj_2_18(2)) {
      matchMode = MatchMode();
    } else {
      ;
    }
    patterns = PatternList();
    hints = Hints();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.matchClause( pos( optionalT != null ? optionalT : t ), optional, matchMode, patterns, pos( t.next ), hints, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MATCH_MODE MatchMode() throws ParseException {Token t;
    MATCH_MODE matchMode;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case REPEATABLE:{
      t = jj_consume_token(REPEATABLE);
      if (jj_2_19(2)) {
        jj_consume_token(ELEMENT);
        jj_consume_token(BINDINGS);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ELEMENT:{
          jj_consume_token(ELEMENT);
          break;
          }
        case ELEMENTS:{
          jj_consume_token(ELEMENTS);
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
matchMode = astFactory.repeatableElements(pos(t));
      break;
      }
    case DIFFERENT:{
      t = jj_consume_token(DIFFERENT);
      if (jj_2_20(2)) {
        jj_consume_token(RELATIONSHIP);
        jj_consume_token(BINDINGS);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RELATIONSHIP:{
          jj_consume_token(RELATIONSHIP);
          break;
          }
        case RELATIONSHIPS:{
          jj_consume_token(RELATIONSHIPS);
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
matchMode = astFactory.differentRelationships(pos(t));
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return matchMode;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<HINT> Hints() throws ParseException {Token t;
    boolean seek;
    VARIABLE v;
    Token labelOrRelType;
    List<VARIABLE> joinVariables;
    HINT hint;
    List<HINT> hints = null;
    label_13:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USING:{
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_13;
      }
      t = jj_consume_token(USING);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:{
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.ANY, pos( t ));
        break;
        }
      case BTREE:{
        jj_consume_token(BTREE);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.BTREE, pos( t ));
        break;
        }
      case TEXT:{
        jj_consume_token(TEXT);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.TEXT, pos( t ));
        break;
        }
      case RANGE:{
        jj_consume_token(RANGE);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.RANGE, pos( t ));
        break;
        }
      case POINT:{
        jj_consume_token(POINT);
        jj_consume_token(INDEX);
        hint = IndexHintBody(HintIndexType.POINT, pos( t ));
        break;
        }
      case JOIN:{
        jj_consume_token(JOIN);
        jj_consume_token(ON);
        joinVariables = VariableList1();
hint = astFactory.usingJoin( pos( t ), joinVariables );
        break;
        }
      case SCAN:{
        jj_consume_token(SCAN);
        v = Variable();
        labelOrRelType = LabelOrRelType();
hint = astFactory.usingScan( pos( t ), v, labelOrRelType.image );
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if ( hints == null )
            {
                hints = new ArrayList<>();
            }
            hints.add( hint );
    }
{if ("" != null) return hints;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public HINT IndexHintBody(HintIndexType indexType, POS p) throws ParseException {boolean seek = false;
    VARIABLE v;
    Token labelOrRelType;
    List<String> propNames;
    if (jj_2_21(2)) {
      jj_consume_token(SEEK);
seek = true;
    } else {
      ;
    }
    v = Variable();
    labelOrRelType = LabelOrRelType();
    jj_consume_token(LPAREN);
    propNames = SymbolicNameList1();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.usingIndexHint( p, v, labelOrRelType.image, propNames, seek, indexType);}
    throw new IllegalStateException ("Missing return statement in function");
}

// MERGE
  final public 
CLAUSE MergeClause() throws ParseException, Exception {Token t;
    Token onToken;
    PATTERN p;
    SET_CLAUSE c;
    ArrayList<SET_CLAUSE> clauses = new ArrayList<>();
    ArrayList<POS> positions = new ArrayList<>();
    ArrayList<ASTFactory.MergeActionType> actionTypes = new ArrayList<>();
    t = jj_consume_token(MERGE);
    p = Pattern();
    label_14:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_14;
      }
      onToken = jj_consume_token(ON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MATCH:{
        jj_consume_token(MATCH);
        c = SetClause();
clauses.add( c ); actionTypes.add( ASTFactory.MergeActionType.OnMatch ); positions.add( pos( onToken ) );
        break;
        }
      case CREATE:{
        jj_consume_token(CREATE);
        c = SetClause();
clauses.add( c ); actionTypes.add( ASTFactory.MergeActionType.OnCreate ); positions.add( pos( onToken ) );
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.mergeClause( pos( t ), p, clauses, actionTypes, positions );}
    throw new IllegalStateException ("Missing return statement in function");
}

// UNWIND
  final public 
CLAUSE UnwindClause() throws ParseException, Exception {Token t;
    EXPRESSION e;
    VARIABLE v;
    t = jj_consume_token(UNWIND);
    e = Expression();
    jj_consume_token(AS);
    v = Variable();
{if ("" != null) return astFactory.unwindClause( pos( t ), e, v );}
    throw new IllegalStateException ("Missing return statement in function");
}

// CALL
  final public 
CLAUSE CallClause() throws ParseException, Exception {Token optionalT = null;
    Token t;
    Token procedureNamePosition;
    Token procedureResultPosition = null;
    List<String> namespace;
    String name;
    EXPRESSION e;
    List<EXPRESSION> arguments = null;
    boolean yieldAll = false;
    CALL_RESULT_ITEM x;
    List<CALL_RESULT_ITEM> items = null;
    WHERE where = null;
    boolean optional = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONAL:{
      optionalT = jj_consume_token(OPTIONAL);
optional=true;
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    t = jj_consume_token(CALL);
    namespace = Namespace();
procedureNamePosition = token;
    name = ProcedureName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
arguments = new ArrayList<>();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LBRACKET:
      case LCURLY:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case MINUS:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case PLUS:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        e = Expression();
arguments.add( e );
        label_15:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            break;
            }
          default:
            jj_la1[49] = jj_gen;
            break label_15;
          }
          jj_consume_token(COMMA);
          e = Expression();
arguments.add( e );
        }
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case YIELD:{
      procedureResultPosition = jj_consume_token(YIELD);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
yieldAll = true;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
items = new ArrayList<>();
        x = ProcedureResultItem();
items.add( x );
        label_16:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            break;
            }
          default:
            jj_la1[52] = jj_gen;
            break label_16;
          }
          jj_consume_token(COMMA);
          x = ProcedureResultItem();
items.add( x );
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case WHERE:{
          where = WhereClause();
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callClause( pos( optionalT != null ? optionalT : t ),
                                     pos( t.next ),
                                     pos( procedureNamePosition.next ),
                                     pos( procedureResultPosition ),
                                     namespace,
                                     name,
                                     arguments,
                                     yieldAll,
                                     items,
                                     where,
                                     optional);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String ProcedureName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return t.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CALL_RESULT_ITEM ProcedureResultItem() throws ParseException {Token t;
    VARIABLE v = null;
    t = SymbolicNameString();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.callResultItem( pos( t ), t.image,  v );}
    throw new IllegalStateException ("Missing return statement in function");
}

// LOAD CSV
  final public 
CLAUSE LoadCSVClause() throws ParseException, Exception {Token t;
    boolean headers = false;
    EXPRESSION source;
    VARIABLE v;
    Token sep = null;
    t = jj_consume_token(LOAD);
    jj_consume_token(CSV);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      jj_consume_token(HEADERS);
headers = true;
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(FROM);
    try {
      source = Expression();
    } catch (Exception e) {
throw new ParseException( exceptionFactory.failedToParseFile + " " + e.getMessage() );
    }
    jj_consume_token(AS);
    v = Variable();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FIELDTERMINATOR:{
      jj_consume_token(FIELDTERMINATOR);
      sep = StringToken();
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.loadCsvClause( pos( t ), headers, source, v, sep == null ? null : sep.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

// FOREACH
  final public 
CLAUSE ForeachClause() throws ParseException, Exception {Token t;
    VARIABLE v = null;
    EXPRESSION list;
    CLAUSE c;
    List<CLAUSE> clauses = new ArrayList<>();
    t = jj_consume_token(FOREACH);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    list = Expression();
    jj_consume_token(BAR);
    label_17:
    while (true) {
      c = Clause();
clauses.add( c );
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALL:
      case CREATE:
      case DELETE:
      case DETACH:
      case FINISH:
      case FOREACH:
      case INSERT:
      case LIMITROWS:
      case LOAD:
      case MATCH:
      case MERGE:
      case NODETACH:
      case OFFSET:
      case OPTIONAL:
      case ORDER:
      case REMOVE:
      case RETURN:
      case SET:
      case SKIPROWS:
      case UNWIND:
      case USE:
      case WITH:{
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_17;
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.foreachClause( pos( t ), v, list, clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CLAUSE SubqueryClause() throws ParseException, Exception {Token optionalT = null;
    Token t;
    QUERY q;
    SUBQUERY_IN_TRANSACTIONS_PARAMETERS inTransactionsParams = null;
    boolean isImportingAll = false;
    boolean hasScope = false;
    VARIABLE v;
    List<VARIABLE> variables = new ArrayList<>();
    boolean optional = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONAL:{
      optionalT = jj_consume_token(OPTIONAL);
optional=true;
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    t = jj_consume_token(CALL);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
hasScope = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
isImportingAll = true;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          v = Variable();
variables.add(v);
          label_18:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[61] = jj_gen;
              break label_18;
            }
            jj_consume_token(COMMA);
            v = Variable();
variables.add(v);
          }
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          ;
        }
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    jj_consume_token(LCURLY);
    q = RegularQuery();
    jj_consume_token(RCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IN:{
      inTransactionsParams = SubqueryInTransactionsParameters();
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.subqueryClause(
            pos( optionalT != null ? optionalT : t ),
            q,
            inTransactionsParams,
            isImportingAll,
            hasScope,
            variables,
            optional
        );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SUBQUERY_IN_TRANSACTIONS_PARAMETERS SubqueryInTransactionsParameters() throws ParseException, Exception {Token t;
    SUBQUERY_IN_TRANSACTIONS_BATCH_PARAMETERS batchParams = null;
    SUBQUERY_IN_TRANSACTIONS_CONCURRENCY_PARAMETERS concurrencyParams = null;
    SUBQUERY_IN_TRANSACTIONS_ERROR_PARAMETERS errorParams = null;
    SUBQUERY_IN_TRANSACTIONS_REPORT_PARAMETERS reportParams = null;
    EXPRESSION c = null;
    String repeatedBatch = "Duplicated OF ROWS parameter";
    String repeatedOnError = "Duplicated ON ERROR parameter";
    String repeatedReport = "Duplicated REPORT STATUS parameter";
    t = jj_consume_token(IN);
    if (jj_2_22(2)) {
      c = Expression();
      jj_consume_token(CONCURRENT);
concurrencyParams = astFactory.subqueryInTransactionsConcurrencyParameters(pos( t ), c);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CONCURRENT:{
        jj_consume_token(CONCURRENT);
concurrencyParams = astFactory.subqueryInTransactionsConcurrencyParameters(pos( t ), null);
        break;
        }
      default:
        jj_la1[66] = jj_gen;
concurrencyParams = null;
      }
    }
    t = jj_consume_token(TRANSACTIONS);
    label_19:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OF:
      case ON:
      case REPORT:{
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        break label_19;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OF:{
assertNotAlreadySet( batchParams, t, repeatedBatch );
        batchParams = SubqueryInTransactionsBatchParameters();
        break;
        }
      case ON:{
assertNotAlreadySet( errorParams, t, repeatedOnError );
        errorParams = SubqueryInTransactionsErrorParameters();
        break;
        }
      case REPORT:{
assertNotAlreadySet( reportParams, t, repeatedReport );
        reportParams = SubqueryInTransactionsReportParameters();
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.subqueryInTransactionsParams( pos( t ), batchParams, concurrencyParams, errorParams, reportParams);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SUBQUERY_IN_TRANSACTIONS_BATCH_PARAMETERS SubqueryInTransactionsBatchParameters() throws ParseException, Exception {Token t;
    EXPRESSION batchSize;
    t = jj_consume_token(OF);
    batchSize = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROW:{
      jj_consume_token(ROW);
      break;
      }
    case ROWS:{
      jj_consume_token(ROWS);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.subqueryInTransactionsBatchParameters( pos( t ), batchSize);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SUBQUERY_IN_TRANSACTIONS_ERROR_PARAMETERS SubqueryInTransactionsErrorParameters() throws ParseException {Token t;
    CallInTxsOnErrorBehaviourType onErrorBehaviour = CallInTxsOnErrorBehaviourType.ON_ERROR_FAIL;
    t = jj_consume_token(ON);
    jj_consume_token(ERROR);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONTINUE:{
      jj_consume_token(CONTINUE);
onErrorBehaviour = CallInTxsOnErrorBehaviourType.ON_ERROR_CONTINUE;
      break;
      }
    case BREAK:{
      jj_consume_token(BREAK);
onErrorBehaviour = CallInTxsOnErrorBehaviourType.ON_ERROR_BREAK;
      break;
      }
    case FAIL:{
      jj_consume_token(FAIL);
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.subqueryInTransactionsErrorParameters( pos( t ), onErrorBehaviour );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SUBQUERY_IN_TRANSACTIONS_REPORT_PARAMETERS SubqueryInTransactionsReportParameters() throws ParseException {Token t;
    VARIABLE v;
    t = jj_consume_token(REPORT);
    jj_consume_token(STATUS);
    jj_consume_token(AS);
    v = Variable();
{if ("" != null) return astFactory.subqueryInTransactionsReportParameters( pos( t ), v );}
    throw new IllegalStateException ("Missing return statement in function");
}

// ORDER BY AND PAGE STATEMENT
  final public CLAUSE OrderBySkipLimitClause() throws ParseException, Exception {Token t = null;
    Token orderPos = null;
    Token skipPos = null;
    Token limitPos = null;
    EXPRESSION skip = null;
    EXPRESSION limit = null;
    List<ORDER_ITEM> order = new ArrayList<>();
    ORDER_ITEM o = null;
t = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      orderPos = jj_consume_token(ORDER);
      jj_consume_token(BY);
      o = OrderItem();
t=orderPos; order.add( o );
      label_20:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        o = OrderItem();
order.add( o );
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OFFSET:
      case SKIPROWS:{
skipPos=token.next;
        skip = Skip();
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LIMITROWS:{
limitPos=token.next;
        limit = Limit();
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        ;
      }
      break;
      }
    case OFFSET:
    case SKIPROWS:{
skipPos=token.next; t=skipPos;
      skip = Skip();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LIMITROWS:{
limitPos=token.next;
        limit = Limit();
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      break;
      }
    case LIMITROWS:{
limitPos=token.next; t=limitPos;
      limit = Limit();
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.orderBySkipLimitClause( pos( t ), order, pos( orderPos ), skip, pos( skipPos ), limit, pos( limitPos ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

// PATTERN
  final public 
List<PATTERN> PatternList() throws ParseException, Exception {PATTERN p;
    List<PATTERN> patterns = new ArrayList<>();
    p = Pattern();
patterns.add( p );
    label_21:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      p = Pattern();
patterns.add( p );
    }
{if ("" != null) return patterns;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PATTERN> InsertPatternList() throws ParseException, Exception {PATTERN p;
    List<PATTERN> patterns = new ArrayList<>();
    p = InsertPattern();
patterns.add( p );
    label_22:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      p = InsertPattern();
patterns.add( p );
    }
{if ("" != null) return patterns;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN Pattern() throws ParseException, Exception {VARIABLE v = null;
    PATTERN p;
    PATTERN_SELECTOR s = null;
    if (jj_2_23(2)) {
      v = Variable();
      jj_consume_token(EQ);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:
      case ANY:
      case SHORTEST:{
        s = Selector();
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:
      case ANY:
      case SHORTEST:{
        s = Selector();
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
    }
    p = AnonymousPattern();
if (v != null) p = astFactory.namedPattern( v, p );
        if (s != null) p = astFactory.patternWithSelector( s, p );
        {if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN InsertPattern() throws ParseException, Exception {Token errorStart = null;
    List<PATTERN_ATOM> patternAtoms = new ArrayList<>();
    if (jj_2_24(2)) {
      errorStart = SymbolicNameString();
      jj_consume_token(EQ);
    } else {
      ;
    }
    patternAtoms = InsertPathPatternAtoms();
if (errorStart != null)
        {
            throw exceptionFactory.syntaxException(
                new ParseException( ASTExceptionFactory.namedPatternInInsertNotSupported ),
                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
        }
        {if ("" != null) return astFactory.insertPathPattern( patternAtoms );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN_QUANTIFIER Quantifier() throws ParseException {Token range;
    Token l = null;
    Token u = null;
    if (jj_2_25(3)) {
      range = jj_consume_token(LCURLY);
      l = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
      jj_consume_token(RCURLY);
{if ("" != null) return astFactory.fixedPathQuantifier(pos(range), pos(l), l.image);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:{
        range = jj_consume_token(LCURLY);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UNSIGNED_DECIMAL_INTEGER:{
          l = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        jj_consume_token(COMMA);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UNSIGNED_DECIMAL_INTEGER:{
          u = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          ;
        }
        jj_consume_token(RCURLY);
{if ("" != null) return astFactory.intervalPathQuantifier(pos(range), pos(l), pos(u), l == null ? null : l.image, u == null ? null : u.image);}
        break;
        }
      case PLUS:{
        range = jj_consume_token(PLUS);
{if ("" != null) return astFactory.plusPathQuantifier(pos(range));}
        break;
        }
      case TIMES:{
        range = jj_consume_token(TIMES);
{if ("" != null) return astFactory.starPathQuantifier(pos(range));}
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN AnonymousPattern() throws ParseException, Exception {PATTERN p;
    PATTERN_ELEMENT pe;
    if (jj_2_26(3)) {
      p = ShortestPathPattern();
{if ("" != null) return p;}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        pe = PatternElement();
{if ("" != null) return astFactory.pathPattern( pe );}
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN ShortestPathPattern() throws ParseException, Exception {Token t;
    PATTERN_ELEMENT pe;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      jj_consume_token(LPAREN);
      pe = PatternElement();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.shortestPathPattern( pos( t ), pe );}
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      jj_consume_token(LPAREN);
      pe = PatternElement();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allShortestPathsPattern( pos( t ), pe );}
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN_ATOM MaybeQuantifiedRelationshipPattern() throws ParseException, Exception {REL_PATTERN rel;
  PATTERN_QUANTIFIER q = null;
    rel = RelationshipPattern();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LCURLY:
    case PLUS:
    case TIMES:{
      q = Quantifier();
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      ;
    }
if ( q == null )
        {
            {if ("" != null) return rel;}
        }
        else
        {
            {if ("" != null) return astFactory.quantifiedRelationship(rel, q);}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN_ELEMENT PatternElement() throws ParseException, Exception {List<PATTERN_ATOM> patternAtoms = new ArrayList<>();
    patternAtoms = PathPatternAtoms();
{if ("" != null) return astFactory.patternElement( patternAtoms );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PATTERN_ATOM> PathPatternAtoms() throws ParseException, Exception {NODE_PATTERN n;
     PATTERN_ATOM r;
     PATTERN_ATOM parenthesizedAtom;
     List<PATTERN_ATOM> patternAtoms = new ArrayList<>();
     labelExpressionStack.push(ExpectBar.DO_NOT_EXPECT_BAR);
    label_23:
    while (true) {
      if (jj_2_28(3)) {
        n = NodePattern();
patternAtoms.add( n );
        label_24:
        while (true) {
          if (jj_2_27(2)) {
          } else {
            break label_24;
          }
          r = MaybeQuantifiedRelationshipPattern();
patternAtoms.add( r );
          n = NodePattern();
patternAtoms.add( n );
        }
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          parenthesizedAtom = ParenthesizedPath();
patternAtoms.add( parenthesizedAtom );
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_23;
      }
    }
labelExpressionStack.pop();
         {if ("" != null) return patternAtoms;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PATTERN_ATOM> InsertPathPatternAtoms() throws ParseException, Exception {NODE_PATTERN n;
     REL_PATTERN r;
     List<PATTERN_ATOM> patternAtoms = new ArrayList<>();
    n = InsertNodePattern();
patternAtoms.add( n );
    label_25:
    while (true) {
      if (jj_2_29(2)) {
      } else {
        break label_25;
      }
      r = InsertRelationshipPattern();
patternAtoms.add( r );
      n = InsertNodePattern();
patternAtoms.add( n );
    }
{if ("" != null) return patternAtoms;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN_SELECTOR Selector() throws ParseException, Exception {Token k = null;
    Token s;
    PATTERN_SELECTOR selector = null;
    if (jj_2_30(2)) {
      s = jj_consume_token(ANY);
      jj_consume_token(SHORTEST);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PATH:
      case PATHS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:{
          jj_consume_token(PATH);
          break;
          }
        case PATHS:{
          jj_consume_token(PATHS);
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        ;
      }
selector = astFactory.anyShortestPathSelector(null, null, pos(s));
    } else if (jj_2_31(2)) {
      s = jj_consume_token(ALL);
      jj_consume_token(SHORTEST);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PATH:
      case PATHS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:{
          jj_consume_token(PATH);
          break;
          }
        case PATHS:{
          jj_consume_token(PATHS);
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        ;
      }
selector = astFactory.allShortestPathSelector(pos(s));
    } else if (jj_2_32(2)) {
      s = jj_consume_token(ANY);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        k = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PATH:
      case PATHS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:{
          jj_consume_token(PATH);
          break;
          }
        case PATHS:{
          jj_consume_token(PATHS);
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
selector = astFactory.anyPathSelector(k != null ? k.image : null, pos(k), pos(s));
    } else if (jj_2_33(2)) {
      s = jj_consume_token(ALL);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PATH:
      case PATHS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:{
          jj_consume_token(PATH);
          break;
          }
        case PATHS:{
          jj_consume_token(PATHS);
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        ;
      }
selector = astFactory.allPathSelector(pos(s));
    } else if (jj_2_34(4)) {
      s = jj_consume_token(SHORTEST);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        k = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PATH:
      case PATHS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:{
          jj_consume_token(PATH);
          break;
          }
        case PATHS:{
          jj_consume_token(PATHS);
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GROUP:{
        jj_consume_token(GROUP);
        break;
        }
      case GROUPS:{
        jj_consume_token(GROUPS);
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selector = astFactory.shortestGroupsSelector(k != null ? k.image : null, pos(k), pos(s));
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SHORTEST:{
        s = jj_consume_token(SHORTEST);
        k = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PATH:
        case PATHS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PATH:{
            jj_consume_token(PATH);
            break;
            }
          case PATHS:{
            jj_consume_token(PATHS);
            break;
            }
          default:
            jj_la1[101] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          ;
        }
selector = astFactory.anyShortestPathSelector(k.image, pos(k), pos(s));
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return selector;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN PathPatternNonEmpty() throws ParseException, Exception {NODE_PATTERN n;
    REL_PATTERN r;
    List<PATTERN_ATOM> patternAtoms = new ArrayList<>();
    labelExpressionStack.push(ExpectBar.DO_NOT_EXPECT_BAR);
    n = NodePattern();
patternAtoms.add( n );
    label_26:
    while (true) {
      r = RelationshipPattern();
patternAtoms.add( r );
      n = NodePattern();
patternAtoms.add( n );
      if (jj_2_35(2)) {
      } else {
        break label_26;
      }
    }
labelExpressionStack.pop();
        {if ("" != null) return astFactory.pathPattern( astFactory.patternElement( patternAtoms ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePattern() throws ParseException, Exception {Token t;
    NODE_PATTERN n;
    t = jj_consume_token(LPAREN);
    if (jj_2_36(2147483647)) {
      n = NodePatternEmpty(t);
    } else if (jj_2_37(2147483647)) {
      n = NodePatternOnlyVariable(t);
    } else if (jj_2_38(2147483647)) {
      n = NodePatternColon(t);
    } else if (jj_2_39(2147483647)) {
      n = NodePatternVariableColon(t);
    } else if (jj_2_40(2147483647)) {
      n = NodePatternProperties(t);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COLON:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        n = NodePatternComplex(t);
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return n;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternEmpty(Token t) throws ParseException, Exception {
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), null, null, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternOnlyVariable(Token t) throws ParseException, Exception {VARIABLE v = null;
    v = Variable();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), v, null, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternColon(Token t) throws ParseException, Exception {LABEL_EXPRESSION labelExpression = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this node pattern started with a colon,
        // so it must be of the form (labelExpression properties? WHERE?).
        labelExpression = LabelExpression(astFactory.nodeType());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:
    case LCURLY:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), null, labelExpression, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternVariableColon(Token t) throws ParseException, Exception {VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this node pattern started with variable followed by a colon,
        // so it must be of the form (variable labelExpression properties? WHERE?).
        v = Variable();
    labelExpression = LabelExpression(astFactory.nodeType());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:
    case LCURLY:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), v, labelExpression, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternProperties(Token t) throws ParseException, Exception {EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this node pattern started with a {,
        // so it must be of the form (properties WHERE?).
        properties = Properties();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), null, null, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN NodePatternComplex(Token t) throws ParseException, Exception {VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    if (jj_2_41(2147483647)) {
      labelExpression = LabelExpression(astFactory.nodeType());
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_42(2147483647)) {
      labelExpression = LabelExpression(astFactory.nodeType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        ;
      }
    } else if (jj_2_43(3)) {
      v = Variable();
      properties = Properties();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        ;
      }
    } else if (jj_2_44(2147483647)) {
      v = Variable();
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_45(2147483647)) {
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_46(3)) {
      v = Variable();
      labelExpression = LabelExpression(astFactory.nodeType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        ;
      }
    } else if (jj_2_47(2147483647)) {
      labelExpression = LabelExpression(astFactory.nodeType());
      properties = Properties();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:
      case IS:{
        labelExpression = LabelExpression(astFactory.nodeType());
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), v, labelExpression, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NODE_PATTERN InsertNodePattern() throws ParseException, Exception {Token t;
    VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    EXPRESSION properties = null;
    t = jj_consume_token(LPAREN);
    if (jj_2_48(3)) {
      v = Variable();
      labelExpression = InsertNodeLabelExpression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:{
        properties = MapLiteral();
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        ;
      }
    } else if (jj_2_49(2)) {
      v = Variable();
      properties = MapLiteral();
    } else if (jj_2_50(2)) {
      labelExpression = InsertNodeLabelExpression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:{
        properties = MapLiteral();
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:{
        properties = MapLiteral();
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          v = Variable();
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          ;
        }
      }
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.nodePattern( pos( t ), v, labelExpression, properties, null);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATTERN_ATOM ParenthesizedPath() throws ParseException, Exception {Token t;
    PATTERN p;
    VARIABLE v;
    EXPRESSION where = null;
    PATTERN_QUANTIFIER quantifier = null;
    t = jj_consume_token(LPAREN);
    p = Pattern();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LCURLY:
    case PLUS:
    case TIMES:{
      quantifier = Quantifier();
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.parenthesizedPathPattern( pos(t), p, where, quantifier );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SET_ITEM SetNodeLabels(VARIABLE v) throws ParseException, Exception {Token label;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<EXPRESSION> dynamicLabels = new ArrayList<>();
    EXPRESSION e = null;
    label_27:
    while (true) {
      if (jj_2_51(2)) {
        label = LabelOrRelType();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          jj_consume_token(DOLLAR);
          jj_consume_token(LPAREN);
          e = Expression();
          jj_consume_token(RPAREN);
dynamicLabels.add( e );
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[124] = jj_gen;
        break label_27;
      }
    }
{if ("" != null) return astFactory.setLabels( v, labels, dynamicLabels, false );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SET_ITEM SetNodeLabelsIs(VARIABLE v) throws ParseException, Exception {Token label;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<EXPRESSION> dynamicLabels = new ArrayList<>();
    EXPRESSION e = null;
    jj_consume_token(IS);
    if (jj_2_52(2)) {
      label = SymbolicNameString();
labels.add( new StringPos<>( label.image, pos( label ) ) );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:{
        jj_consume_token(DOLLAR);
        jj_consume_token(LPAREN);
        e = Expression();
        jj_consume_token(RPAREN);
dynamicLabels.add( e );
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        break label_28;
      }
      if (jj_2_53(2)) {
        label = LabelOrRelType();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          jj_consume_token(DOLLAR);
          jj_consume_token(LPAREN);
          e = Expression();
          jj_consume_token(RPAREN);
dynamicLabels.add( e );
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return astFactory.setLabels( v, labels, dynamicLabels, true );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REMOVE_ITEM RemoveNodeLabelsColon(VARIABLE v) throws ParseException, Exception {Token label;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<EXPRESSION> dynamicLabels = new ArrayList<>();
    EXPRESSION e = null;
    label_29:
    while (true) {
      if (jj_2_54(2)) {
        label = LabelOrRelType();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          jj_consume_token(DOLLAR);
          jj_consume_token(LPAREN);
          e = Expression();
          jj_consume_token(RPAREN);
dynamicLabels.add( e );
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        break label_29;
      }
    }
{if ("" != null) return astFactory.removeLabels( v, labels, dynamicLabels, false );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REMOVE_ITEM RemoveNodeLabelsIs(VARIABLE v) throws ParseException, Exception {Token label;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<EXPRESSION> dynamicLabels = new ArrayList<>();
    EXPRESSION e = null;
    jj_consume_token(IS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
      jj_consume_token(LPAREN);
      e = Expression();
      jj_consume_token(RPAREN);
dynamicLabels.add( e );
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      label = SymbolicNameString();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        break label_30;
      }
      if (jj_2_55(2)) {
        label = LabelOrRelType();
labels.add( new StringPos<>( label.image, pos( label ) ) );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          jj_consume_token(DOLLAR);
          jj_consume_token(LPAREN);
          e = Expression();
          jj_consume_token(RPAREN);
dynamicLabels.add( e );
          break;
          }
        default:
          jj_la1[132] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return astFactory.removeLabels( v, labels, dynamicLabels, true );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION LabelExpressionPredicate(EXPRESSION subject) throws ParseException, Exception {LABEL_EXPRESSION exp = null;
    exp = LabelExpression(astFactory.nodeOrRelationshipType());
{if ("" != null) return astFactory.labelExpressionPredicate( subject, exp );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token LabelOrRelType() throws ParseException {Token t;
    jj_consume_token(COLON);
    t = SymbolicNameString();
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> LabelOrRelTypes() throws ParseException {List<StringPos<POS>> labels = new ArrayList<>();
    StringPos<POS> label;
    jj_consume_token(COLON);
    SymbolicNameString();
labels.add( new StringPos( token.image, pos(token) ) );
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BAR:{
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        break label_31;
      }
      jj_consume_token(BAR);
      SymbolicNameString();
labels.add( new StringPos( token.image, pos(token) ) );
    }
{if ("" != null) return labels;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Properties() throws ParseException, Exception {EXPRESSION e;
    if (jj_2_56(3)) {
      e = MapLiteral();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:{
        e = Parameter(ParameterType.ANY);
        break;
        }
      default:
        jj_la1[134] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPattern() throws ParseException, Exception {Token firstToken = token;
    boolean left = false;
    REL_PATTERN r;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:
    case ARROW_LEFT_HEAD:{
      LeftArrow();
left = true;
      break;
      }
    default:
      jj_la1[135] = jj_gen;
      ;
    }
    ArrowLine();
    if (jj_2_64(2147483647)) {
      r = RelationshipPatternDoubleDash(firstToken, left);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        if (jj_2_57(2147483647)) {
          r = RelationshipPatternEmpty(firstToken, left);
        } else if (jj_2_58(2147483647)) {
          r = RelationshipPatternOnlyVariable(firstToken, left);
        } else if (jj_2_59(2147483647)) {
          r = RelationshipPatternColon(firstToken, left);
        } else if (jj_2_60(2147483647)) {
          r = RelationshipPatternVariableColon(firstToken, left);
        } else if (jj_2_61(2147483647)) {
          r = RelationshipPatternProperties(firstToken, left);
        } else if (jj_2_62(2147483647)) {
          r = RelationshipPatternPathLength(firstToken, left);
        } else if (jj_2_63(2147483647)) {
          r = RelationshipPatternOnlyVariablePathLength(firstToken, left);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COLON:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            r = RelationshipPatternComplex(firstToken, left);
            break;
            }
          default:
            jj_la1[136] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return r;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternDoubleDash(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, null, null, null, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternEmpty(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[139] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, null, null, null, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternOnlyVariable(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    VARIABLE v = null;
    v = Variable();
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[140] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, v, null, null, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternColon(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    LABEL_EXPRESSION labelExpression = null;
    PATH_LENGTH pathLength = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this rel pattern started with a colon,
        // so it must be of the form [labelExpression pathLength? properties? WHERE?].
        labelExpression = LabelExpression(astFactory.relationshipType());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      pathLength = PathLength();
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:
    case LCURLY:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[143] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[144] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, null, labelExpression, pathLength, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternVariableColon(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    PATH_LENGTH pathLength = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this rel pattern started with variable followed by a colon,
        // so it must be of the form [variable labelExpression pathLength? properties? WHERE?].
        v = Variable();
    labelExpression = LabelExpression(astFactory.relationshipType());
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      pathLength = PathLength();
      break;
      }
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:
    case LCURLY:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, v, labelExpression, pathLength, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternProperties(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this rel pattern started with  a {,
        // so it must be of the form [properties WHERE?].
        properties = Properties();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[150] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, null, null, null, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternPathLength(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    PATH_LENGTH pathLength = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    // From the LOOKAHEAD outside, we know this rel pattern started with  a pathLength,
        // so it must be of the form [pathLength properties? WHERE?].
        pathLength = PathLength();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOLLAR:
    case LCURLY:{
      properties = Properties();
      break;
      }
    default:
      jj_la1[151] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, null, null, pathLength, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternOnlyVariablePathLength(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    VARIABLE v = null;
    PATH_LENGTH pathLength = null;
    // From the LOOKAHEAD outside, we know this rel pattern must be of the form [variable pathLength].
        v = Variable();
    pathLength = PathLength();
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, v, null, pathLength, null, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN RelationshipPatternComplex(Token firstToken, boolean left) throws ParseException, Exception {boolean right = false;
    VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    PATH_LENGTH pathLength = null;
    EXPRESSION properties = null;
    EXPRESSION predicate = null;
    if (jj_2_65(2147483647)) {
      labelExpression = LabelExpression(astFactory.relationshipType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        ;
      }
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_66(2147483647)) {
      labelExpression = LabelExpression(astFactory.relationshipType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        ;
      }
    } else if (jj_2_67(2147483647)) {
      v = Variable();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        ;
      }
      properties = Properties();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        ;
      }
    } else if (jj_2_68(2147483647)) {
      v = Variable();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        ;
      }
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_69(2147483647)) {
      jj_consume_token(WHERE);
      predicate = Expression();
    } else if (jj_2_70(3)) {
      v = Variable();
      labelExpression = LabelExpression(astFactory.relationshipType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOLLAR:
      case LCURLY:{
        properties = Properties();
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        ;
      }
    } else if (jj_2_71(2147483647)) {
      labelExpression = LabelExpression(astFactory.relationshipType());
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        pathLength = PathLength();
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        ;
      }
      properties = Properties();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        jj_consume_token(WHERE);
        predicate = Expression();
        break;
        }
      default:
        jj_la1[166] = jj_gen;
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:
      case IS:{
        labelExpression = LabelExpression(astFactory.relationshipType());
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          pathLength = PathLength();
          break;
          }
        default:
          jj_la1[167] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, v, labelExpression, pathLength, properties, predicate );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public REL_PATTERN InsertRelationshipPattern() throws ParseException, Exception {Token firstToken = token;
    boolean left = false;
    boolean right = false;
    VARIABLE v = null;
    LABEL_EXPRESSION labelExpression = null;
    EXPRESSION properties = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:
    case ARROW_LEFT_HEAD:{
      LeftArrow();
left = true;
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    ArrowLine();
    jj_consume_token(LBRACKET);
    if (jj_2_72(3)) {
      v = Variable();
      labelExpression = InsertRelationshipLabelExpression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LCURLY:{
        properties = MapLiteral();
        break;
        }
      default:
        jj_la1[171] = jj_gen;
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:
      case IS:{
        labelExpression = InsertRelationshipLabelExpression();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LCURLY:{
          properties = MapLiteral();
          break;
          }
        default:
          jj_la1[172] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACKET);
    ArrowLine();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:
    case ARROW_RIGHT_HEAD:{
      RightArrow();
right = true;
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.relationshipPattern( pos( firstToken.next ), left, right, v, labelExpression, null, properties, null );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void LeftArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LT:{
      jj_consume_token(LT);
      break;
      }
    case ARROW_LEFT_HEAD:{
      jj_consume_token(ARROW_LEFT_HEAD);
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ArrowLine() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ARROW_LINE:{
      jj_consume_token(ARROW_LINE);
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void RightArrow() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GT:{
      jj_consume_token(GT);
      break;
      }
    case ARROW_RIGHT_HEAD:{
      jj_consume_token(ARROW_RIGHT_HEAD);
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public PATH_LENGTH PathLength() throws ParseException {Token t;
    PATH_LENGTH p = null;
    t = jj_consume_token(TIMES);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNSIGNED_DECIMAL_INTEGER:
    case DOTDOT:{
      p = PathLengthLiteral(t);
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      ;
    }
{if ("" != null) return p == null ? astFactory.pathLength( pos( t ), null, null, null, null ) : p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PATH_LENGTH PathLengthLiteral(Token t) throws ParseException {Token v1 = null;
    Token v2 = null;
    if (jj_2_73(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      t = jj_consume_token(DOTDOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v2 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        ;
      }
{if ("" != null) return astFactory.pathLength( pos( t ), v1 == null ? null : pos ( v1 ), v2 == null ? null : pos ( v2 ),  v1 == null ? "" : v1.image, v2 == null ? "" : v2.image );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        v1 = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
String v = v1 == null ? "" : v1.image;
            {if ("" != null) return astFactory.pathLength( pos( t ), v1 == null ? null : pos ( v1 ), v1 == null ? null : pos ( v1 ), v, v);}
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// LABEL EXPRESSIONS
  final public 
LABEL_EXPRESSION LabelExpression(ENTITY_TYPE type) throws ParseException, Exception {LABEL_EXPRESSION e;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      if (!labelExpressionStack.isEmpty() && labelExpressionStack.peek() == ExpectBar.EXPECT_BAR) {
        e = LabelExpression4ExpectingBar(type);
      } else if (labelExpressionStack.isEmpty() || labelExpressionStack.peek() == ExpectBar.DO_NOT_EXPECT_BAR) {
        e = LabelExpression4(type);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case IS:{
      jj_consume_token(IS);
      if (!labelExpressionStack.isEmpty() && labelExpressionStack.peek() == ExpectBar.EXPECT_BAR) {
        e = LabelExpression4ExpectingBarIs(type);
      } else if (labelExpressionStack.isEmpty() || labelExpressionStack.peek() == ExpectBar.DO_NOT_EXPECT_BAR) {
        e = LabelExpression4Is(type);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression4(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression3(type);
    label_32:
    while (true) {
      if (jj_2_74(2)) {
      } else {
        break label_32;
      }
      t = jj_consume_token(BAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        temp = LabelExpression3(type);
e = astFactory.labelColonDisjunction( pos( t ), e, temp, false );
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case EXCLAMATION_MARK:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        temp = LabelExpression3(type);
e = astFactory.labelDisjunction( pos( t ), e, temp, false );
        break;
        }
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression4Is(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression3Is(type);
    label_33:
    while (true) {
      if (jj_2_75(2)) {
      } else {
        break label_33;
      }
      t = jj_consume_token(BAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        temp = LabelExpression3Is(type);
e = astFactory.labelColonDisjunction( pos( t ), e, temp, true );
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case EXCLAMATION_MARK:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NOTHING:
      case NOWAIT:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        temp = LabelExpression3Is(type);
e = astFactory.labelDisjunction( pos( t ), e, temp, true );
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression4ExpectingBar(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression3(type);
    label_34:
    while (true) {
      if (jj_2_76(2147483647)) {
      } else {
        break label_34;
      }
      t = jj_consume_token(BAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        temp = LabelExpression3(type);
e = astFactory.labelColonDisjunction( pos( t ), e, temp, false );
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case EXCLAMATION_MARK:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        temp = LabelExpression3(type);
e = astFactory.labelDisjunction( pos( t ), e, temp, false );
        break;
        }
      default:
        jj_la1[185] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression4ExpectingBarIs(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression3Is(type);
    label_35:
    while (true) {
      if (jj_2_77(2147483647)) {
      } else {
        break label_35;
      }
      t = jj_consume_token(BAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        temp = LabelExpression3Is(type);
e = astFactory.labelColonDisjunction( pos( t ), e, temp, true );
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case EXCLAMATION_MARK:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NOTHING:
      case NOWAIT:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        temp = LabelExpression3Is(type);
e = astFactory.labelDisjunction( pos( t ), e, temp, true );
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression3(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression2(type);
    label_36:
    while (true) {
      if (jj_2_78(2)) {
      } else {
        break label_36;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AMPERSAND:{
        t = jj_consume_token(AMPERSAND);
        temp = LabelExpression2(type);
e = astFactory.labelConjunction( pos( t ), e, temp, false );
        break;
        }
      case COLON:{
        t = jj_consume_token(COLON);
        temp = LabelExpression2(type);
e = astFactory.labelColonConjunction( pos( t ), e, temp, false );
        break;
        }
      default:
        jj_la1[187] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression3Is(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = LabelExpression2Is(type);
    label_37:
    while (true) {
      if (jj_2_79(2)) {
      } else {
        break label_37;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AMPERSAND:{
        t = jj_consume_token(AMPERSAND);
        temp = LabelExpression2Is(type);
e = astFactory.labelConjunction( pos( t ), e, temp, true );
        break;
        }
      case COLON:{
        t = jj_consume_token(COLON);
        temp = LabelExpression2Is(type);
e = astFactory.labelColonConjunction( pos( t ), e, temp, true );
        break;
        }
      default:
        jj_la1[188] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression2(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    if (jj_2_80(3)) {
      t = jj_consume_token(EXCLAMATION_MARK);
      e = LabelExpression2(type);
e = astFactory.labelNegation( pos( t ), e, false );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        e = LabelExpression1(type);
        break;
        }
      default:
        jj_la1[189] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression2Is(ENTITY_TYPE type) throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    if (jj_2_81(3)) {
      t = jj_consume_token(EXCLAMATION_MARK);
      e = LabelExpression2Is(type);
e = astFactory.labelNegation( pos( t ), e, true );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case PERCENT:
      case NAME:
      case NAMES:
      case NAN:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NOTHING:
      case NOWAIT:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        e = LabelExpression1Is(type);
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression1(ENTITY_TYPE type) throws ParseException, Exception {LABEL_EXPRESSION e = null;
    String label = null;
    Token t;
    labelExpressionStack.push(ExpectBar.DO_NOT_EXPECT_BAR);
    EXPRESSION dynamicExpression;
    Boolean all = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      e = LabelExpression4(type);
      jj_consume_token(RPAREN);
      break;
      }
    case PERCENT:{
      t = jj_consume_token(PERCENT);
e = astFactory.labelWildcard( pos ( t ), false );
      break;
      }
    case DOLLAR:{
      t = jj_consume_token(DOLLAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:
      case ANY:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALL:{
          jj_consume_token(ALL);
          break;
          }
        case ANY:{
          jj_consume_token(ANY);
all = false;
          break;
          }
        default:
          jj_la1[191] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      dynamicExpression = Expression();
      jj_consume_token(RPAREN);
e = astFactory.dynamicLabelLeaf( pos ( t ), dynamicExpression, type, all, false );
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      t = SymbolicNameString();
e = astFactory.labelLeaf( pos ( t ), t.image, type, false );
      break;
      }
    default:
      jj_la1[193] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
labelExpressionStack.pop();
        {if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION LabelExpression1Is(ENTITY_TYPE type) throws ParseException, Exception {LABEL_EXPRESSION e = null;
    String label = null;
    Token t;
    labelExpressionStack.push(ExpectBar.DO_NOT_EXPECT_BAR);
    EXPRESSION dynamicExpression;
    Boolean all = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      e = LabelExpression4Is(type);
      jj_consume_token(RPAREN);
      break;
      }
    case PERCENT:{
      t = jj_consume_token(PERCENT);
e = astFactory.labelWildcard( pos ( t ), true );
      break;
      }
    case DOLLAR:{
      t = jj_consume_token(DOLLAR);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:
      case ANY:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALL:{
          jj_consume_token(ALL);
          break;
          }
        case ANY:{
          jj_consume_token(ANY);
all = false;
          break;
          }
        default:
          jj_la1[194] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      dynamicExpression = Expression();
      jj_consume_token(RPAREN);
e = astFactory.dynamicLabelLeaf( pos ( t ), dynamicExpression, type, all, true );
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NOTHING:
    case NOWAIT:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      t = SymbolicLabelNameString();
e = astFactory.labelLeaf( pos ( t ), t.image, type, true );
      break;
      }
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
labelExpressionStack.pop();
        {if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION InsertNodeLabelExpression() throws ParseException, Exception {Token t;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    boolean containsIs = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      break;
      }
    case IS:{
      jj_consume_token(IS);
containsIs = true;
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    e = InsertLabelConjunction(astFactory.nodeType(), containsIs);
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION InsertRelationshipLabelExpression() throws ParseException, Exception {LABEL_EXPRESSION e;
    boolean containsIs = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      break;
      }
    case IS:{
      jj_consume_token(IS);
containsIs = true;
      break;
      }
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    e = InsertLabelLeaf(astFactory.relationshipType(), containsIs);
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION InsertLabelConjunction(ENTITY_TYPE type, boolean containsIs) throws ParseException, Exception {Token t;
    Token errorStart = null;
    LABEL_EXPRESSION e;
    LABEL_EXPRESSION temp;
    e = InsertLabelLeaf(type, containsIs);
    label_38:
    while (true) {
      if (jj_2_82(2)) {
      } else {
        break label_38;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AMPERSAND:{
        t = jj_consume_token(AMPERSAND);
        temp = InsertLabelLeaf(type, containsIs);
e = astFactory.labelConjunction( pos( t ), e, temp, containsIs );
        break;
        }
      case COLON:{
        errorStart = jj_consume_token(COLON);
        break;
        }
      default:
        jj_la1[199] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if (errorStart != null)
        {
            throw exceptionFactory.syntaxException(
                new ParseException( ASTExceptionFactory.colonConjunctionInInsertNotSupported ),
                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
        }
        {if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LABEL_EXPRESSION InsertLabelLeaf(ENTITY_TYPE type, boolean containsIs) throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return astFactory.labelLeaf( pos ( t ), t.image, type, containsIs );}
    throw new IllegalStateException ("Missing return statement in function");
}

// EXPRESSIONS
  final public 
EXPRESSION Expression() throws ParseException, Exception {EXPRESSION e;
    e = Expression12();
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression12() throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression11();
    label_39:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OR:{
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        break label_39;
      }
      t = jj_consume_token(OR);
      temp = Expression11();
e = astFactory.or( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression11() throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression10();
    label_40:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case XOR:{
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        break label_40;
      }
      t = jj_consume_token(XOR);
      temp = Expression10();
e = astFactory.xor( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression10() throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION temp;
    e = Expression9();
    label_41:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:{
        break;
        }
      default:
        jj_la1[202] = jj_gen;
        break label_41;
      }
      t = jj_consume_token(AND);
      temp = Expression9();
e = astFactory.and( pos( t ), e, temp );
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression9() throws ParseException, Exception {Token t;
    EXPRESSION e;
    if (jj_2_83(3)) {
      t = jj_consume_token(NOT);
      e = Expression9();
e = astFactory.not( pos( t ), e );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LBRACKET:
      case LCURLY:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case MINUS:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case PLUS:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        e = Expression8();
        break;
        }
      default:
        jj_la1[203] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Implements comparison operation chaining. That is that expressions like `a < b < c` are interpreted as `a < b AND b < c`.
 * See https://neo4j.com/docs/cypher-manual/current/syntax/operators/#cypher-operations-chaining
 */
  final public EXPRESSION Expression8() throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION lhs;
    EXPRESSION rhs;
    List<EXPRESSION> expressions = new ArrayList();
    e = Expression7();
lhs = e;
    label_42:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:
      case GE:
      case GT:
      case LE:
      case LT:
      case NEQ:
      case NEQ2:{
        break;
        }
      default:
        jj_la1[204] = jj_gen;
        break label_42;
      }
      if (jj_2_84(2)) {
        t = jj_consume_token(EQ);
        rhs = Expression7();
expressions.add( astFactory.eq( pos( t ), lhs, rhs)); lhs = rhs;
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NEQ:{
          t = jj_consume_token(NEQ);
          rhs = Expression7();
expressions.add( astFactory.neq( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case NEQ2:{
          t = jj_consume_token(NEQ2);
          rhs = Expression7();
expressions.add( astFactory.neq2( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case LE:{
          t = jj_consume_token(LE);
          rhs = Expression7();
expressions.add( astFactory.lte( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case GE:{
          t = jj_consume_token(GE);
          rhs = Expression7();
expressions.add( astFactory.gte( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case LT:{
          t = jj_consume_token(LT);
          rhs = Expression7();
expressions.add( astFactory.lt( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        case GT:{
          t = jj_consume_token(GT);
          rhs = Expression7();
expressions.add( astFactory.gt( pos( t ), lhs, rhs ) ); lhs = rhs;
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
if ( expressions.isEmpty() )
        {
            {if ("" != null) return e;}
        }
        else if ( expressions.size() == 1 )
        {
            {if ("" != null) return expressions.get( 0 );}
        }
        else
        {
            {if ("" != null) return astFactory.ands( expressions );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression8ComparatorExpression(EXPRESSION lhs) throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION rhs;
    if (jj_2_85(2)) {
      t = jj_consume_token(EQ);
      rhs = Expression7();
{if ("" != null) return astFactory.eq( pos( t ), lhs, rhs);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NEQ:{
        t = jj_consume_token(NEQ);
        rhs = Expression7();
{if ("" != null) return astFactory.neq( pos( t ), lhs, rhs );}
        break;
        }
      case NEQ2:{
        t = jj_consume_token(NEQ2);
        rhs = Expression7();
{if ("" != null) return astFactory.neq2( pos( t ), lhs, rhs );}
        break;
        }
      case LE:{
        t = jj_consume_token(LE);
        rhs = Expression7();
{if ("" != null) return astFactory.lte( pos( t ), lhs, rhs );}
        break;
        }
      case GE:{
        t = jj_consume_token(GE);
        rhs = Expression7();
{if ("" != null) return astFactory.gte( pos( t ), lhs, rhs );}
        break;
        }
      case LT:{
        t = jj_consume_token(LT);
        rhs = Expression7();
{if ("" != null) return astFactory.lt( pos( t ), lhs, rhs );}
        break;
        }
      case GT:{
        t = jj_consume_token(GT);
        rhs = Expression7();
{if ("" != null) return astFactory.gt( pos( t ), lhs, rhs );}
        break;
        }
      default:
        jj_la1[206] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression7() throws ParseException, Exception {EXPRESSION e;
    e = Expression6();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLONCOLON:
    case CONTAINS:
    case ENDS:
    case IN:
    case IS:
    case REGEQ:
    case STARTS:{
      e = ComparisonExpression6(e);
      break;
      }
    default:
      jj_la1[207] = jj_gen;
      ;
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ComparisonExpression6(EXPRESSION lhs) throws ParseException, Exception {Token t;
    EXPRESSION rhs;
    ParserCypherTypeName typeName;
    ParserNormalForm normalForm;
    if (jj_2_86(2)) {
      t = jj_consume_token(REGEQ);
      rhs = Expression6();
{if ("" != null) return astFactory.regeq( pos( t ), lhs, rhs );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STARTS:{
        t = jj_consume_token(STARTS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.startsWith( pos( t ), lhs, rhs );}
        break;
        }
      case ENDS:{
        t = jj_consume_token(ENDS);
        jj_consume_token(WITH);
        rhs = Expression6();
{if ("" != null) return astFactory.endsWith( pos( t ), lhs, rhs );}
        break;
        }
      case CONTAINS:{
        t = jj_consume_token(CONTAINS);
        rhs = Expression6();
{if ("" != null) return astFactory.contains( pos( t ), lhs, rhs );}
        break;
        }
      case IN:{
        t = jj_consume_token(IN);
        rhs = Expression6();
{if ("" != null) return astFactory.in( pos( t ), lhs, rhs );}
        break;
        }
      case IS:{
        t = jj_consume_token(IS);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NULL:{
          jj_consume_token(NULL);
{if ("" != null) return astFactory.isNull( pos( t ), lhs );}
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NULL:{
            jj_consume_token(NULL);
{if ("" != null) return astFactory.isNotNull( pos( t ), lhs );}
            break;
            }
          case COLONCOLON:
          case TYPED:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case TYPED:{
              jj_consume_token(TYPED);
              break;
              }
            case COLONCOLON:{
              jj_consume_token(COLONCOLON);
              break;
              }
            default:
              jj_la1[208] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            typeName = cypherTypeName();
{if ("" != null) return astFactory.isNotTyped( pos( t ), lhs, typeName );}
            break;
            }
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NORMALIZED:{
            normalForm = normalForm();
            jj_consume_token(NORMALIZED);
{if ("" != null) return astFactory.isNotNormalized( pos( t ), lhs, normalForm );}
            break;
            }
          default:
            jj_la1[209] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case COLONCOLON:
        case TYPED:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TYPED:{
            jj_consume_token(TYPED);
            break;
            }
          case COLONCOLON:{
            jj_consume_token(COLONCOLON);
            break;
            }
          default:
            jj_la1[210] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          typeName = cypherTypeName();
{if ("" != null) return astFactory.isTyped( pos( t ), lhs, typeName );}
          break;
          }
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NORMALIZED:{
          normalForm = normalForm();
          jj_consume_token(NORMALIZED);
{if ("" != null) return astFactory.isNormalized( pos( t ), lhs, normalForm );}
          break;
          }
        default:
          jj_la1[211] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case COLONCOLON:{
        t = jj_consume_token(COLONCOLON);
        typeName = cypherTypeName();
{if ("" != null) return astFactory.isTyped( pos( t ), lhs, typeName );}
        break;
        }
      default:
        jj_la1[212] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParserNormalForm normalForm() throws ParseException {ParserNormalForm normalForm = ParserNormalForm.NFC;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NFC:{
        jj_consume_token(NFC);
        break;
        }
      case NFD:{
        jj_consume_token(NFD);
normalForm = ParserNormalForm.NFD;
        break;
        }
      case NFKC:{
        jj_consume_token(NFKC);
normalForm = ParserNormalForm.NFKC;
        break;
        }
      case NFKD:{
        jj_consume_token(NFKD);
normalForm = ParserNormalForm.NFKD;
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[214] = jj_gen;
      ;
    }
{if ("" != null) return normalForm;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression6() throws ParseException, Exception {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression5();
    label_43:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOUBLEBAR:
      case MINUS:
      case PLUS:{
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        break label_43;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        rhs = Expression5();
lhs = astFactory.plus( pos( t ), lhs, rhs);
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        rhs = Expression5();
lhs = astFactory.minus( pos( t ), lhs, rhs);
        break;
        }
      case DOUBLEBAR:{
        t = jj_consume_token(DOUBLEBAR);
        rhs = Expression5();
lhs = astFactory.concatenate( pos( t ), lhs, rhs);
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression5() throws ParseException, Exception {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression4();
    label_44:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIVIDE:
      case PERCENT:
      case TIMES:{
        break;
        }
      default:
        jj_la1[217] = jj_gen;
        break label_44;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        t = jj_consume_token(TIMES);
        rhs = Expression4();
lhs = astFactory.multiply( pos( t ), lhs, rhs );
        break;
        }
      case DIVIDE:{
        t = jj_consume_token(DIVIDE);
        rhs = Expression4();
lhs = astFactory.divide( pos( t ), lhs, rhs );
        break;
        }
      case PERCENT:{
        t = jj_consume_token(PERCENT);
        rhs = Expression4();
lhs = astFactory.modulo( pos( t ), lhs, rhs );
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression4() throws ParseException, Exception {Token t;
    EXPRESSION lhs;
    EXPRESSION rhs;
    lhs = Expression3();
    label_45:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case POW:{
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        break label_45;
      }
      t = jj_consume_token(POW);
      rhs = Expression3();
lhs = astFactory.pow( pos( t ), lhs, rhs );
    }
{if ("" != null) return lhs;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression3() throws ParseException, Exception {Token t;
    EXPRESSION e;
    if (jj_2_87(3)) {
      e = Expression2();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        e = Expression2();
e = astFactory.unaryPlus( pos( t ), e );
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        e = Expression2();
e = astFactory.unaryMinus( pos( t ), e );
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression2() throws ParseException, Exception {EXPRESSION e;
    e = Expression1();
    label_46:
    while (true) {
      if (jj_2_88(2147483647)) {
      } else {
        break label_46;
      }
      e = PostFix1(e);
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PostFix1(EXPRESSION subject) throws ParseException, Exception {Token t;
    EXPRESSION e1 = null;
    EXPRESSION e2 = null;
    EXPRESSION ret;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOT:{
      ret = Property(subject);
      break;
      }
    default:
      jj_la1[223] = jj_gen;
      if (jj_2_89(2147483647)) {
        ret = LabelExpressionPredicate(subject);
      } else if (jj_2_90(2147483647)) {
        ret = LabelExpressionPredicate(subject);
      } else if (jj_2_91(2147483647)) {
        jj_consume_token(LBRACKET);
        e1 = Expression();
        jj_consume_token(RBRACKET);
ret=astFactory.listLookup( subject, e1 );
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          t = jj_consume_token(LBRACKET);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LBRACKET:
          case LCURLY:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case LPAREN:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case MINUS:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case PLUS:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            e1 = Expression();
            break;
            }
          default:
            jj_la1[221] = jj_gen;
            ;
          }
          jj_consume_token(DOTDOT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DECIMAL_DOUBLE:
          case UNSIGNED_DECIMAL_INTEGER:
          case UNSIGNED_HEX_INTEGER:
          case UNSIGNED_OCTAL_INTEGER:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LBRACKET:
          case LCURLY:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case LPAREN:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case MINUS:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case PLUS:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            e2 = Expression();
            break;
            }
          default:
            jj_la1[222] = jj_gen;
            ;
          }
          jj_consume_token(RBRACKET);
ret=astFactory.listSlice( pos( t ), subject, e1, e2 );
          break;
          }
        default:
          jj_la1[224] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY Property(EXPRESSION subject) throws ParseException {EXPRESSION e;
    StringPos<POS> propKeyName;
    jj_consume_token(DOT);
    propKeyName = PropertyKeyName();
{if ("" != null) return astFactory.property( subject, propKeyName );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION DynamicPropertyExpression() throws ParseException, Exception {EXPRESSION subject;
    EXPRESSION e;
    subject = Expression1();
    e = DynamicProperty(subject);
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PROPERTY PropertyExpression() throws ParseException, Exception {EXPRESSION subject;
    PROPERTY p;
    subject = Expression1();
    label_47:
    while (true) {
      p = Property(subject);
subject = p;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        break;
        }
      default:
        jj_la1[225] = jj_gen;
        break label_47;
      }
    }
{if ("" != null) return p;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION DynamicProperty(EXPRESSION subject) throws ParseException, Exception {EXPRESSION e;
    jj_consume_token(LBRACKET);
    e = Expression();
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLookup( subject, e );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION Expression1() throws ParseException, Exception {EXPRESSION e = null;
    Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case MINUS:{
      e = NumberLiteral();
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
      break;
      }
    case DOLLAR:{
      e = Parameter(ParameterType.ANY);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
e = astFactory.newTrueLiteral( pos( t ) );
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
e = astFactory.newFalseLiteral( pos( t ) );
      break;
      }
    case INF:
    case INFINITY:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INFINITY:{
        t = jj_consume_token(INFINITY);
        break;
        }
      case INF:{
        t = jj_consume_token(INF);
        break;
        }
      default:
        jj_la1[226] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
e = astFactory.newInfinityLiteral( pos( t ) );
      break;
      }
    case NAN:{
      t = jj_consume_token(NAN);
e = astFactory.newNaNLiteral( pos( t ) );
      break;
      }
    default:
      jj_la1[227] = jj_gen;
      if (jj_2_92(2)) {
        t = jj_consume_token(NULL);
e = astFactory.newNullLiteral( pos( t ) );
      } else if (jj_2_93(3)) {
        e = CaseExpression();
      } else if (jj_2_94(3)) {
        t = jj_consume_token(COUNT);
        jj_consume_token(LPAREN);
        jj_consume_token(TIMES);
        jj_consume_token(RPAREN);
e = astFactory.newCountStar( pos( t ) );
      } else if (jj_2_95(3)) {
        e = MapLiteral();
      } else if (jj_2_96(3)) {
        e = ExistsExpression();
      } else if (jj_2_97(3)) {
        e = CountExpression();
      } else if (jj_2_98(3)) {
        e = CollectExpression();
      } else if (jj_2_99(2)) {
        e = MapProjection();
      } else if (jj_2_100(2147483647)) {
        e = ListComprehension();
      } else if (jj_2_101(2147483647)) {
        e = PatternComprehension();
      } else if (jj_2_102(3)) {
        e = ListLiteral();
      } else if (jj_2_103(3)) {
        e = ReduceExpression();
      } else if (jj_2_104(3)) {
        e = AllExpression();
      } else if (jj_2_105(3)) {
        e = AnyExpression();
      } else if (jj_2_106(3)) {
        e = NoneExpression();
      } else if (jj_2_107(3)) {
        e = SingleExpression();
      } else if (jj_2_108(2)) {
        e = NormalizeExpression();
      } else if (jj_2_109(2)) {
        e = TrimFunction();
      } else if (jj_2_110(2147483647)) {
        e = PatternExpression();
      } else if (jj_2_111(2)) {
        e = ShortestPathExpression();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          jj_consume_token(LPAREN);
labelExpressionStack.push(ExpectBar.DO_NOT_EXPECT_BAR);
          e = Expression();
labelExpressionStack.pop();
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[228] = jj_gen;
          if (jj_2_112(2147483647)) {
            e = FunctionInvocation(false);
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case ESCAPED_SYMBOLIC_NAME:
            case ACCESS:
            case ACTIVE:
            case ADMIN:
            case ADMINISTRATOR:
            case ALIAS:
            case ALIASES:
            case ALL_SHORTEST_PATH:
            case ALL:
            case ALTER:
            case AND:
            case ANY:
            case ARRAY:
            case AS:
            case ASC:
            case ASCENDING:
            case ASSERT:
            case ASSIGN:
            case AT:
            case AUTH:
            case BINDINGS:
            case BOOL:
            case BOOLEAN:
            case BOOSTED:
            case BOTH:
            case BREAK:
            case BRIEF:
            case BTREE:
            case BUILT:
            case BY:
            case CALL:
            case CASCADE:
            case CASE:
            case CHANGE:
            case CIDR:
            case COLLECT:
            case COMMAND:
            case COMMANDS:
            case COMMIT:
            case COMPOSITE:
            case CONCURRENT:
            case CONSTRAINT:
            case CONSTRAINTS:
            case CONTAINS:
            case COPY:
            case CONTINUE:
            case COUNT:
            case CREATE:
            case CSV:
            case CURRENT:
            case DATA:
            case DATABASE:
            case DATABASES:
            case DATE:
            case DATETIME:
            case DBMS:
            case DEALLOCATE:
            case DEFAULT_TOKEN:
            case DEFINED:
            case DELETE:
            case DENY:
            case DESC:
            case DESCENDING:
            case DESTROY:
            case DETACH:
            case DIFFERENT:
            case DISTINCT:
            case DRIVER:
            case DROP:
            case DRYRUN:
            case DUMP:
            case DURATION:
            case EACH:
            case EDGE:
            case ENABLE:
            case ELEMENT:
            case ELEMENTS:
            case ELSE:
            case ENCRYPTED:
            case END:
            case ENDS:
            case EXECUTABLE:
            case EXECUTE:
            case EXIST:
            case EXISTENCE:
            case EXISTS:
            case ERROR:
            case FAIL:
            case FALSE:
            case FIELDTERMINATOR:
            case FINISH:
            case FLOAT:
            case FOR:
            case FOREACH:
            case FROM:
            case FULLTEXT:
            case FUNCTION:
            case FUNCTIONS:
            case GRANT:
            case GRAPH:
            case GRAPHS:
            case GROUP:
            case GROUPS:
            case HEADERS:
            case HOME:
            case ID:
            case IF:
            case IMPERSONATE:
            case IMMUTABLE:
            case IN:
            case INDEX:
            case INDEXES:
            case INF:
            case INFINITY:
            case INSERT:
            case INT:
            case INTEGER:
            case IS:
            case JOIN:
            case KEY:
            case LABEL:
            case LABELS:
            case LEADING:
            case LIMITROWS:
            case LIST:
            case LOAD:
            case LOCAL:
            case LOOKUP:
            case MANAGEMENT:
            case MAP:
            case MATCH:
            case MERGE:
            case NAME:
            case NAMES:
            case NAN:
            case NFC:
            case NFD:
            case NFKC:
            case NFKD:
            case NEW:
            case NODE:
            case NODETACH:
            case NODES:
            case NONE:
            case NORMALIZE:
            case NORMALIZED:
            case NOT:
            case NOTHING:
            case NOWAIT:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case ONLY:
            case OPTIONAL:
            case OPTIONS:
            case OPTION:
            case OR:
            case ORDER:
            case OUTPUT:
            case PASSWORD:
            case PASSWORDS:
            case PATH:
            case PATHS:
            case PERIODIC:
            case PLAINTEXT:
            case POINT:
            case POPULATED:
            case REPEATABLE:
            case PRIMARY:
            case PRIMARIES:
            case PRIVILEGE:
            case PRIVILEGES:
            case PROCEDURE:
            case PROCEDURES:
            case PROPERTIES:
            case PROPERTY:
            case PROVIDER:
            case PROVIDERS:
            case RANGE:
            case READ:
            case REALLOCATE:
            case REDUCE:
            case RENAME:
            case REL:
            case RELATIONSHIP:
            case RELATIONSHIPS:
            case REMOVE:
            case REPLACE:
            case REPORT:
            case REQUIRE:
            case REQUIRED:
            case RESTRICT:
            case RETURN:
            case REVOKE:
            case ROLE:
            case ROLES:
            case ROW:
            case ROWS:
            case SCAN:
            case SEC:
            case SECOND:
            case SECONDARY:
            case SECONDARIES:
            case SECONDS:
            case SEEK:
            case SERVER:
            case SERVERS:
            case SET:
            case SETTING:
            case SETTINGS:
            case SHORTEST_PATH:
            case SHORTEST:
            case SHOW:
            case SIGNED:
            case SINGLE:
            case SKIPROWS:
            case START:
            case STARTS:
            case STATUS:
            case STOP:
            case STRING:
            case SUPPORTED:
            case SUSPENDED:
            case TARGET:
            case TERMINATE:
            case TEXT:
            case THEN:
            case TIME:
            case TIMESTAMP:
            case TIMEZONE:
            case TO:
            case TOPOLOGY:
            case TRAILING:
            case TRANSACTION:
            case TRANSACTIONS:
            case TRAVERSE:
            case TRIM:
            case TRUE:
            case TYPE:
            case TYPED:
            case TYPES:
            case UNION:
            case UNIQUE:
            case UNIQUENESS:
            case UNWIND:
            case URL:
            case USE:
            case USER:
            case USERS:
            case USING:
            case VALUE:
            case VARCHAR:
            case VECTOR:
            case VERBOSE:
            case VERTEX:
            case WAIT:
            case WHEN:
            case WHERE:
            case WITH:
            case WITHOUT:
            case WRITE:
            case XOR:
            case YIELD:
            case ZONE:
            case ZONED:
            case IDENTIFIER:{
              e = Variable();
              break;
              }
            default:
              jj_la1[229] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION CaseExpression() throws ParseException, Exception {EXPRESSION e = null;
    if (jj_2_113(2147483647)) {
      e = SimpleCaseExpression();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASE:{
        e = GeneralCaseExpression();
        break;
        }
      default:
        jj_la1[230] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return e;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SimpleCaseExpression() throws ParseException, Exception {Token t;
    EXPRESSION caseExpr;
    EXPRESSION e;
    List<EXPRESSION> tempWhen = new ArrayList<>();
    List<EXPRESSION> when = new ArrayList<>();
    List<EXPRESSION> then = new ArrayList<>();
    EXPRESSION elseCase = null;
    t = jj_consume_token(CASE);
    caseExpr = Expression();
    jj_consume_token(WHEN);
    tempWhen = simpleCaseWhenOperandList(caseExpr);
when.addAll( tempWhen );
    jj_consume_token(THEN);
    e = Expression();
for (var i = 0; i < tempWhen.size(); i++) { then.add( e ); }
    label_48:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        break;
        }
      default:
        jj_la1[231] = jj_gen;
        break label_48;
      }
      jj_consume_token(WHEN);
      tempWhen = simpleCaseWhenOperandList(caseExpr);
when.addAll( tempWhen );
      jj_consume_token(THEN);
      e = Expression();
for (var i = 0; i < tempWhen.size(); i++) { then.add( e ); }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      elseCase = Expression();
      break;
      }
    default:
      jj_la1[232] = jj_gen;
      ;
    }
    jj_consume_token(END);
{if ("" != null) return astFactory.caseExpression( pos( t ), caseExpr, when, then, elseCase);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<EXPRESSION> simpleCaseWhenOperandList(EXPRESSION caseExpr) throws ParseException, Exception {EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    e = whenOperand(caseExpr);
list.add( e );
    label_49:
    while (true) {
      if (jj_2_114(2)) {
      } else {
        break label_49;
      }
      jj_consume_token(COMMA);
      e = whenOperand(caseExpr);
list.add( e );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION whenOperand(EXPRESSION lhs) throws ParseException, Exception {Token t;
    EXPRESSION e;
    EXPRESSION rhs;
    ParserCypherTypeName typeName;
    ParserNormalForm normalForm;
t = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case REGEQ:{
      t = jj_consume_token(REGEQ);
      rhs = Expression6();
{if ("" != null) return astFactory.regeq( pos( t ), lhs, rhs );}
      break;
      }
    case STARTS:{
      t = jj_consume_token(STARTS);
      jj_consume_token(WITH);
      rhs = Expression6();
{if ("" != null) return astFactory.startsWith( pos( t ), lhs, rhs );}
      break;
      }
    case ENDS:{
      t = jj_consume_token(ENDS);
      jj_consume_token(WITH);
      rhs = Expression6();
{if ("" != null) return astFactory.endsWith( pos( t ), lhs, rhs );}
      break;
      }
    default:
      jj_la1[233] = jj_gen;
      if (jj_2_115(3)) {
        t = jj_consume_token(IS);
        jj_consume_token(NULL);
{if ("" != null) return astFactory.isNull( pos( t ), lhs );}
      } else if (jj_2_116(3)) {
        t = jj_consume_token(IS);
        jj_consume_token(NOT);
        jj_consume_token(NULL);
{if ("" != null) return astFactory.isNotNull( pos( t ), lhs );}
      } else if (jj_2_117(3)) {
        t = jj_consume_token(IS);
        normalForm = normalForm();
        jj_consume_token(NORMALIZED);
{if ("" != null) return astFactory.isNormalized( pos( t ), lhs, normalForm );}
      } else if (jj_2_118(3)) {
        t = jj_consume_token(IS);
        jj_consume_token(NOT);
        normalForm = normalForm();
        jj_consume_token(NORMALIZED);
{if ("" != null) return astFactory.isNotNormalized( pos( t ), lhs, normalForm );}
      } else if (jj_2_119(3)) {
        t = jj_consume_token(IS);
        jj_consume_token(TYPED);
        typeName = cypherTypeName();
{if ("" != null) return astFactory.isTyped( pos( t ), lhs, typeName );}
      } else if (jj_2_120(3)) {
        t = jj_consume_token(IS);
        jj_consume_token(NOT);
        jj_consume_token(TYPED);
        typeName = cypherTypeName();
{if ("" != null) return astFactory.isNotTyped( pos( t ), lhs, typeName );}
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLONCOLON:{
          t = jj_consume_token(COLONCOLON);
          typeName = cypherTypeName();
{if ("" != null) return astFactory.isTyped( pos( t ), lhs, typeName );}
          break;
          }
        case EQ:
        case GE:
        case GT:
        case LE:
        case LT:
        case NEQ:
        case NEQ2:{
          e = Expression8ComparatorExpression(lhs);
{if ("" != null) return e;}
          break;
          }
        case DECIMAL_DOUBLE:
        case UNSIGNED_DECIMAL_INTEGER:
        case UNSIGNED_HEX_INTEGER:
        case UNSIGNED_OCTAL_INTEGER:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LBRACKET:
        case LCURLY:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case MINUS:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case PLUS:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          e = Expression();
{if ("" != null) return astFactory.eq( pos( t ), lhs, e);}
          break;
          }
        default:
          jj_la1[234] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION GeneralCaseExpression() throws ParseException, Exception {Token t;
    EXPRESSION caseExpr = null;
    EXPRESSION e;
    List<EXPRESSION> when = new ArrayList<>();
    List<EXPRESSION> then = new ArrayList<>();
    EXPRESSION elseCase = null;
    t = jj_consume_token(CASE);
    jj_consume_token(WHEN);
    e = Expression();
when.add( e );
    jj_consume_token(THEN);
    e = Expression();
then.add( e );
    label_50:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHEN:{
        break;
        }
      default:
        jj_la1[235] = jj_gen;
        break label_50;
      }
      jj_consume_token(WHEN);
      e = Expression();
when.add( e );
      jj_consume_token(THEN);
      e = Expression();
then.add( e );
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      elseCase = Expression();
      break;
      }
    default:
      jj_la1[236] = jj_gen;
      ;
    }
    jj_consume_token(END);
{if ("" != null) return astFactory.caseExpression( pos( t ), caseExpr, when, then, elseCase);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListComprehension() throws ParseException, Exception {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    EXPRESSION projection = null;
    labelExpressionStack.push(ExpectBar.EXPECT_BAR);
    t = jj_consume_token(LBRACKET);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[237] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BAR:{
      jj_consume_token(BAR);
      projection = Expression();
      break;
      }
    default:
      jj_la1[238] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
labelExpressionStack.pop();
        {if ("" != null) return astFactory.listComprehension( pos( t ), v, e, where, projection );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternComprehension() throws ParseException, Exception {Token t;
    Token relationshipPatternPosition;
    VARIABLE v = null;
    PATTERN p;
    EXPRESSION where = null;
    EXPRESSION projection = null;
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      v = Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[239] = jj_gen;
      ;
    }
relationshipPatternPosition = token;
    p = PathPatternNonEmpty();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
labelExpressionStack.push(ExpectBar.EXPECT_BAR);
      where = Expression();
labelExpressionStack.pop();
      break;
      }
    default:
      jj_la1[240] = jj_gen;
      ;
    }
    jj_consume_token(BAR);
    projection = Expression();
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.patternComprehension( pos( t ), pos( relationshipPatternPosition.next ), v, p, where, projection );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void PatternComprehensionPrefix() throws ParseException, Exception {
    jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      Variable();
      jj_consume_token(EQ);
      break;
      }
    default:
      jj_la1[241] = jj_gen;
      ;
    }
    PathPatternNonEmpty();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      break;
      }
    case BAR:{
      jj_consume_token(BAR);
      break;
      }
    default:
      jj_la1[242] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public EXPRESSION ReduceExpression() throws ParseException, Exception {Token t;
    VARIABLE acc;
    EXPRESSION accExpr;
    VARIABLE v;
    EXPRESSION vExpr;
    EXPRESSION innerExpr;
    t = jj_consume_token(REDUCE);
    jj_consume_token(LPAREN);
    acc = Variable();
    jj_consume_token(EQ);
    accExpr = Expression();
    jj_consume_token(COMMA);
    v = Variable();
    jj_consume_token(IN);
    vExpr = Expression();
    jj_consume_token(BAR);
    innerExpr = Expression();
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.reduceExpression( pos( t ), acc, accExpr, v, vExpr, innerExpr );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AllExpression() throws ParseException, Exception {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(ALL);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[243] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.allExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION AnyExpression() throws ParseException, Exception {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(ANY);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[244] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.anyExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NoneExpression() throws ParseException, Exception {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(NONE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[245] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.noneExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SingleExpression() throws ParseException, Exception {Token t;
    VARIABLE v;
    EXPRESSION e;
    EXPRESSION where = null;
    t = jj_consume_token(SINGLE);
    jj_consume_token(LPAREN);
    v = Variable();
    jj_consume_token(IN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = Expression();
      break;
      }
    default:
      jj_la1[246] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.singleExpression( pos( t ), v, e, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NormalizeExpression() throws ParseException, Exception {Token t;
    EXPRESSION e;
    ParserNormalForm normalForm = ParserNormalForm.NFC;
    t = jj_consume_token(NORMALIZE);
    jj_consume_token(LPAREN);
    e = Expression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NFC:{
        jj_consume_token(NFC);
        break;
        }
      case NFD:{
        jj_consume_token(NFD);
normalForm = ParserNormalForm.NFD;
        break;
        }
      case NFKC:{
        jj_consume_token(NFKC);
normalForm = ParserNormalForm.NFKC;
        break;
        }
      case NFKD:{
        jj_consume_token(NFKD);
normalForm = ParserNormalForm.NFKD;
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[248] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.normalizeExpression( pos( t ), e, normalForm );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION TrimFunction() throws ParseException, Exception {Token t;
    EXPRESSION trimCharacterString = null;
    EXPRESSION trimSource = null;
    EXPRESSION expression = null;
    ParserTrimSpecification trimSpec = ParserTrimSpecification.BOTH;
    t = jj_consume_token(TRIM);
    jj_consume_token(LPAREN);
    if (jj_2_122(2147483647)) {
      jj_consume_token(FROM);
      trimSource = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.trimFunction( pos( t ), trimSpec, trimCharacterString, trimSource );}
    } else if (jj_2_123(2147483647)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOTH:{
        jj_consume_token(BOTH);
        break;
        }
      case LEADING:{
        jj_consume_token(LEADING);
trimSpec = ParserTrimSpecification.LEADING;
        break;
        }
      case TRAILING:{
        jj_consume_token(TRAILING);
trimSpec = ParserTrimSpecification.TRAILING;
        break;
        }
      default:
        jj_la1[249] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(FROM);
      trimSource = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.trimFunction( pos( t ), trimSpec, trimCharacterString, trimSource );}
    } else if (jj_2_124(2147483647)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BOTH:{
        jj_consume_token(BOTH);
        break;
        }
      case LEADING:{
        jj_consume_token(LEADING);
trimSpec = ParserTrimSpecification.LEADING;
        break;
        }
      case TRAILING:{
        jj_consume_token(TRAILING);
trimSpec = ParserTrimSpecification.TRAILING;
        break;
        }
      default:
        jj_la1[250] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      trimCharacterString = Expression();
      jj_consume_token(FROM);
      trimSource = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return astFactory.trimFunction( pos( t ), trimSpec, trimCharacterString, trimSource );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LBRACKET:
      case LCURLY:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case MINUS:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case PLUS:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        expression = Expression();
        if (jj_2_121(2147483647)) {
          jj_consume_token(RPAREN);
{if ("" != null) return astFactory.trimFunction( pos( t ), trimSpec, trimCharacterString, expression );}
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case FROM:{
            jj_consume_token(FROM);
            trimSource = Expression();
            jj_consume_token(RPAREN);
{if ("" != null) return astFactory.trimFunction( pos( t ), trimSpec, expression, trimSource );}
            break;
            }
          default:
            jj_la1[251] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[252] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION PatternExpression() throws ParseException, Exception {PATTERN p;
    Token t;
t = token;
    p = PathPatternNonEmpty();
{if ("" != null) return astFactory.patternExpression( pos( t.next ), p );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ShortestPathExpression() throws ParseException, Exception {PATTERN p;
    Token t;
t = token;
    p = ShortestPathPattern();
{if ("" != null) return astFactory.patternExpression( pos( t.next ), p );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapProjection() throws ParseException, Exception {Token t;
    VARIABLE v;
    MAP_PROJECTION_ITEM x;
    List<MAP_PROJECTION_ITEM> items = new ArrayList<>();
    v = Variable();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DOT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      x = MapProjectionItem();
items.add( x );
      label_51:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[253] = jj_gen;
          break label_51;
        }
        jj_consume_token(COMMA);
        x = MapProjectionItem();
items.add( x );
      }
      break;
      }
    default:
      jj_la1[254] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapProjection( pos( t ), v, items );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MAP_PROJECTION_ITEM MapProjectionItem() throws ParseException, Exception {Token t;
    StringPos<POS> p;
    EXPRESSION e;
    VARIABLE v;
    if (jj_2_125(2)) {
      p = PropertyKeyName();
      jj_consume_token(COLON);
      e = Expression();
{if ("" != null) return astFactory.mapProjectionLiteralEntry( p, e );}
    } else if (jj_2_126(2)) {
      jj_consume_token(DOT);
      p = PropertyKeyName();
{if ("" != null) return astFactory.mapProjectionProperty( p );}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        v = Variable();
{if ("" != null) return astFactory.mapProjectionVariable( v );}
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        t = jj_consume_token(TIMES);
{if ("" != null) return astFactory.mapProjectionAll( pos( t ) );}
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ExistsExpression() throws ParseException, Exception {Token t;
    List<PATTERN> patterns = null;
    MATCH_MODE matchMode = null;
    QUERY q = null;
    WHERE where = null;
    t = jj_consume_token(EXISTS);
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CALL:
    case CREATE:
    case DELETE:
    case DETACH:
    case FINISH:
    case FOREACH:
    case INSERT:
    case LIMITROWS:
    case LOAD:
    case MATCH:
    case MERGE:
    case NODETACH:
    case OFFSET:
    case OPTIONAL:
    case ORDER:
    case REMOVE:
    case RETURN:
    case SET:
    case SKIPROWS:
    case UNWIND:
    case USE:
    case WITH:{
      q = RegularQuery();
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FLOAT:
    case FOR:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIST:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONS:
    case OPTION:
    case OR:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case URL:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIFFERENT:
      case REPEATABLE:{
        matchMode = MatchMode();
        break;
        }
      default:
        jj_la1[256] = jj_gen;
        ;
      }
      patterns = PatternList();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.existsExpression( pos( t ), matchMode, patterns, q, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION CountExpression() throws ParseException, Exception {Token t;
    List<PATTERN> patterns = null;
    MATCH_MODE matchMode = null;
    QUERY q = null;
    WHERE where = null;
    t = jj_consume_token(COUNT);
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CALL:
    case CREATE:
    case DELETE:
    case DETACH:
    case FINISH:
    case FOREACH:
    case INSERT:
    case LIMITROWS:
    case LOAD:
    case MATCH:
    case MERGE:
    case NODETACH:
    case OFFSET:
    case OPTIONAL:
    case ORDER:
    case REMOVE:
    case RETURN:
    case SET:
    case SKIPROWS:
    case UNWIND:
    case USE:
    case WITH:{
      q = RegularQuery();
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FLOAT:
    case FOR:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIST:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case ON:
    case ONLY:
    case OPTIONS:
    case OPTION:
    case OR:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case URL:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIFFERENT:
      case REPEATABLE:{
        matchMode = MatchMode();
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
      patterns = PatternList();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[261] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.countExpression( pos( t ), matchMode, patterns, q, where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION CollectExpression() throws ParseException, Exception {Token t;
    QUERY q;
    t = jj_consume_token(COLLECT);
    jj_consume_token(LCURLY);
    q = RegularQuery();
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.collectExpression( pos( t ), q );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION StringLiteral() throws ParseException {Token t;
    t = StringToken();
{if ("" != null) return astFactory.newString( pos( t ), endPos( t ), token.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION NumberLiteral() throws ParseException {Token sign = null;
    Token t;
    boolean negated = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:{
      sign = jj_consume_token(MINUS);
negated = true;
      break;
      }
    default:
      jj_la1[262] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:{
      t = jj_consume_token(DECIMAL_DOUBLE);
{if ("" != null) return astFactory.newDouble(  pos( sign != null ? sign : t ) , sign != null ? sign.image + token.image : token.image );}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:{
      t = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newDecimalInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    case UNSIGNED_HEX_INTEGER:{
      t = jj_consume_token(UNSIGNED_HEX_INTEGER);
{if ("" != null) return astFactory.newHexInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    case UNSIGNED_OCTAL_INTEGER:{
      t = jj_consume_token(UNSIGNED_OCTAL_INTEGER);
{if ("" != null) return astFactory.newOctalInteger( pos( sign != null ? sign : t ), token.image, negated );}
      break;
      }
    default:
      jj_la1[263] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION SignedIntegerLiteral() throws ParseException {Token sign = null;
    Token number;
    boolean negated = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:{
      sign = jj_consume_token(MINUS);
negated = true;
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      ;
    }
    number = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newDecimalInteger( pos( sign != null ? sign : number ), token.image, negated );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION ListLiteral() throws ParseException, Exception {Token t;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      e = Expression();
list.add( e );
      label_52:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[265] = jj_gen;
          break label_52;
        }
        jj_consume_token(COMMA);
        e = Expression();
list.add( e );
      }
      break;
      }
    default:
      jj_la1[266] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral( pos( t ), list );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION StringListLiteral() throws ParseException, Exception {Token t;
    EXPRESSION e;
    List<EXPRESSION> list = new ArrayList<>();
    t = jj_consume_token(LBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      e = StringLiteral();
list.add( e );
      label_53:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[267] = jj_gen;
          break label_53;
        }
        jj_consume_token(COMMA);
        e = StringLiteral();
list.add( e );
      }
      break;
      }
    default:
      jj_la1[268] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
{if ("" != null) return astFactory.listLiteral( pos( t ), list );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public EXPRESSION MapLiteral() throws ParseException, Exception {Token t;
    StringPos<POS> key;
    EXPRESSION value;
    List<StringPos<POS>> keys = new ArrayList<>();
    List<EXPRESSION> values = new ArrayList<>();
    t = jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      key = PropertyKeyName();
      jj_consume_token(COLON);
      value = Expression();
keys.add( key ); values.add( value );
      label_54:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[269] = jj_gen;
          break label_54;
        }
        jj_consume_token(COMMA);
        key = PropertyKeyName();
        jj_consume_token(COLON);
        value = Expression();
keys.add( key ); values.add( value );
      }
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.mapLiteral( pos( t ), keys, values);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StringPos<POS> PropertyKeyName() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return new StringPos<POS>( t.image,  pos( t ) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PARAMETER Parameter(ParameterType type) throws ParseException {Token t;
    VARIABLE v;
    t = jj_consume_token(DOLLAR);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      v = Variable();
{if ("" != null) return astFactory.newParameter( pos( t ), v, type );}
      break;
      }
    case UNSIGNED_DECIMAL_INTEGER:{
      jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
{if ("" != null) return astFactory.newParameter( pos( t ), token.image, type );}
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FUNCTION_INVOCATION FunctionInvocation(boolean calledFromUseClause) throws ParseException, Exception {Token before = token;
    Token nameSpaceToken;
    Token nameToken;
    List<String> namespace;
    boolean distinct = false;
    EXPRESSION e;
    List<EXPRESSION> arguments = new ArrayList<>();
    namespace = Namespace();
    nameToken = SymbolicNameString();
    jj_consume_token(LPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:
    case DISTINCT:{
      if (jj_2_127(2)) {
        jj_consume_token(DISTINCT);
distinct = true;
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALL:{
          jj_consume_token(ALL);
          break;
          }
        default:
          jj_la1[272] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[273] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      e = Expression();
arguments.add( e );
      label_55:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[274] = jj_gen;
          break label_55;
        }
        jj_consume_token(COMMA);
        e = Expression();
arguments.add( e );
      }
      break;
      }
    default:
      jj_la1[275] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return astFactory.functionInvocation( pos( before.next ), pos( nameToken ), namespace, nameToken.image, distinct, arguments, calledFromUseClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> Namespace() throws ParseException {Token t;
    List<String> parts = new ArrayList<>();
    label_56:
    while (true) {
      if (jj_2_128(2)) {
      } else {
        break label_56;
      }
      t = SymbolicNameString();
parts.add( t.image );
      jj_consume_token(DOT);
    }
{if ("" != null) return parts;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<VARIABLE> VariableList1() throws ParseException {Token t;
    List<VARIABLE> list = new ArrayList<>();
    t = SymbolicNameString();
list.add( astFactory.newVariable( pos( t ), t.image ) );
    label_57:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[276] = jj_gen;
        break label_57;
      }
      jj_consume_token(COMMA);
      t = SymbolicNameString();
list.add( astFactory.newVariable( pos( t ), t.image) );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public VARIABLE Variable() throws ParseException {Token t;
    t = SymbolicNameString();
{if ("" != null) return astFactory.newVariable( pos( t ), t.image );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> SymbolicNameList1() throws ParseException {Token n;
    List<String> list = new ArrayList<>();
    n = SymbolicNameString();
list.add(n.image);
    label_58:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[277] = jj_gen;
        break label_58;
      }
      jj_consume_token(COMMA);
      n = SymbolicNameString();
list.add( n.image );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Command Section
  final public 
STATEMENT_WITH_GRAPH CreateCommand(USE_CLAUSE useClause) throws ParseException, Exception {Token start;
    boolean replace = false;
    STATEMENT_WITH_GRAPH statement;
    start = jj_consume_token(CREATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OR:{
      jj_consume_token(OR);
      jj_consume_token(REPLACE);
replace = true;
      break;
      }
    default:
      jj_la1[278] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      statement = CreateRole(start, replace);
      break;
      }
    case USER:{
      statement = CreateUser(start, replace);
      break;
      }
    case DATABASE:{
      statement = CreateDatabase(start, replace);
      break;
      }
    case CONSTRAINT:{
      statement = CreateConstraint(start, replace);
      break;
      }
    case BTREE:
    case FULLTEXT:
    case INDEX:
    case LOOKUP:
    case POINT:
    case RANGE:
    case TEXT:
    case VECTOR:{
      statement = CreateIndex(start, replace);
      break;
      }
    case ALIAS:{
      statement = CreateAlias(start, replace);
      break;
      }
    case COMPOSITE:{
      statement = CreateCompositeDatabase(start, replace);
      break;
      }
    default:
      jj_la1[279] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.useGraph( statement, useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT Command(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT statement = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:
    case DEALLOCATE:
    case DENY:
    case DROP:
    case DRYRUN:
    case ENABLE:
    case GRANT:
    case REALLOCATE:
    case RENAME:
    case REVOKE:
    case START:
    case STOP:{
      statement = CommandWithUseGraph(useClause);
      break;
      }
    case SHOW:{
      statement = ShowCommand(useClause);
      break;
      }
    case TERMINATE:{
      statement = TerminateCommand(useClause);
      break;
      }
    default:
      jj_la1[280] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH CommandWithUseGraph(USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT_WITH_GRAPH s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DROP:{
      s = DropCommand();
      break;
      }
    case ALTER:{
      s = AlterCommand();
      break;
      }
    case RENAME:{
      s = RenameCommand();
      break;
      }
    case DENY:{
      s = DenyPrivilege();
      break;
      }
    case REVOKE:{
      s = RevokeCommand();
      break;
      }
    case GRANT:{
      s = GrantCommand();
      break;
      }
    case START:{
      s = StartDatabase();
      break;
      }
    case STOP:{
      s = StopDatabase();
      break;
      }
    case ENABLE:{
      s = EnableServerCommand();
      break;
      }
    case DEALLOCATE:
    case DRYRUN:
    case REALLOCATE:{
      s = AllocationCommand();
      break;
      }
    default:
      jj_la1[281] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.useGraph( s, useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH DropCommand() throws ParseException, Exception {Token start;
    STATEMENT_WITH_GRAPH s;
    start = jj_consume_token(DROP);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      s = DropRole(start);
      break;
      }
    case USER:{
      s = DropUser(start);
      break;
      }
    case COMPOSITE:
    case DATABASE:{
      s = DropDatabase(start);
      break;
      }
    case CONSTRAINT:{
      s = DropConstraint(start);
      break;
      }
    case INDEX:{
      s = DropIndex(start);
      break;
      }
    case ALIAS:{
      s = DropAlias(start);
      break;
      }
    case SERVER:{
      s = DropServer(start);
      break;
      }
    default:
      jj_la1[282] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH AlterCommand() throws ParseException, Exception {Token start = null;
    STATEMENT_WITH_GRAPH s;
    start = jj_consume_token(ALTER);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      s = AlterDatabase(start);
      break;
      }
    case ALIAS:{
      s = AlterAlias(start);
      break;
      }
    case CURRENT:{
      s = AlterCurrentUser(start);
      break;
      }
    case USER:{
      s = AlterUser(start);
      break;
      }
    case SERVER:{
      s = AlterServer(start);
      break;
      }
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

// SHOW commands
  final public 
STATEMENT ShowCommand(USE_CLAUSE useClause) throws ParseException, Exception {Token start = null;
    Token showCommandType = null;
    STATEMENT statement = null;
    List<CLAUSE> clauses = null;
    start = jj_consume_token(SHOW);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      showCommandType = jj_consume_token(ALL);
      statement = ShowAllCommand(start, useClause);
      break;
      }
    case POPULATED:{
      jj_consume_token(POPULATED);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROLES:{
        jj_consume_token(ROLES);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        break;
        }
      default:
        jj_la1[284] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      statement = ShowRoles(start, useClause, false);
      break;
      }
    case BTREE:{
      showCommandType = jj_consume_token(BTREE);
      clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.BTREE);
      break;
      }
    case RANGE:{
      showCommandType = jj_consume_token(RANGE);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.RANGE);
      break;
      }
    case FULLTEXT:{
      showCommandType = jj_consume_token(FULLTEXT);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.FULLTEXT);
      break;
      }
    case TEXT:{
      showCommandType = jj_consume_token(TEXT);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.TEXT);
      break;
      }
    case POINT:{
      showCommandType = jj_consume_token(POINT);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.POINT);
      break;
      }
    case VECTOR:{
      showCommandType = jj_consume_token(VECTOR);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.VECTOR);
      break;
      }
    case LOOKUP:{
      showCommandType = jj_consume_token(LOOKUP);
      clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.LOOKUP);
      break;
      }
    case UNIQUE:{
      showCommandType = jj_consume_token(UNIQUE);
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.UNIQUE);
      break;
      }
    case UNIQUENESS:{
      showCommandType = jj_consume_token(UNIQUENESS);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.UNIQUE);
      break;
      }
    case KEY:{
      showCommandType = jj_consume_token(KEY);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.KEY);
      break;
      }
    case NODE:{
      showCommandType = jj_consume_token(NODE);
      clauses = ShowNodeCommand(start);
      break;
      }
    case PROPERTY:{
      showCommandType = jj_consume_token(PROPERTY);
      clauses = ShowPropertyCommand(start, ShowCommandFilterTypes.EXIST);
      break;
      }
    case EXISTENCE:{
      showCommandType = jj_consume_token(EXISTENCE);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.EXIST);
      break;
      }
    case EXISTS:{
      showCommandType = jj_consume_token(EXISTS);
      ShowConstraintsAllowBrief(start);
      break;
      }
    case EXIST:{
      showCommandType = jj_consume_token(EXIST);
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.OLD_EXIST);
      break;
      }
    case RELATIONSHIP:{
      showCommandType = jj_consume_token(RELATIONSHIP);
      clauses = ShowRelationshipCommand(start);
      break;
      }
    case REL:{
      showCommandType = jj_consume_token(REL);
      clauses = ShowRelCommand(start);
      break;
      }
    case BUILT:{
      showCommandType = jj_consume_token(BUILT);
      jj_consume_token(IN);
      clauses = ShowFunctions(start, ShowCommandFilterTypes.BUILT_IN);
      break;
      }
    case INDEX:
    case INDEXES:{
      clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case DATABASE:
    case DATABASES:
    case DEFAULT_TOKEN:
    case HOME:{
      statement = ShowDatabase(start, useClause);
      break;
      }
    case CURRENT:{
      statement = ShowCurrentUser(start, useClause);
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case PROCEDURE:
    case PROCEDURES:{
      clauses = ShowProcedures(start);
      break;
      }
    case SETTING:
    case SETTINGS:{
      clauses = ShowSettings(start);
      break;
      }
    case FUNCTION:
    case FUNCTIONS:{
      clauses = ShowFunctions(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case TRANSACTION:
    case TRANSACTIONS:{
      clauses = ShowTransactions(start);
      break;
      }
    case ALIAS:
    case ALIASES:{
      statement = ShowAliases(start, useClause);
      break;
      }
    case SERVER:
    case SERVERS:{
      statement = ShowServers(start, useClause);
      break;
      }
    case PRIVILEGE:
    case PRIVILEGES:{
      statement = ShowPrivileges(start, useClause);
      break;
      }
    case SUPPORTED:{
      statement = ShowSupportedPrivileges(start, useClause);
      break;
      }
    case ROLE:
    case ROLES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROLES:{
        jj_consume_token(ROLES);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        break;
        }
      default:
        jj_la1[285] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_129(2147483647)) {
        statement = ShowRolePrivileges(start, useClause);
      } else if (jj_2_130(2147483647)) {
        statement = ShowRoles(start, useClause, true);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          statement = ShowRolePrivileges(start, useClause);
          break;
          }
        default:
          jj_la1[286] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[289] = jj_gen;
      if (jj_2_133(2147483647)) {
        showCommandType = jj_consume_token(USER);
        jj_consume_token(DEFINED);
        clauses = ShowFunctions(start, ShowCommandFilterTypes.USER_DEFINED);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case USER:
        case USERS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case USERS:{
            jj_consume_token(USERS);
            break;
            }
          case USER:{
            jj_consume_token(USER);
            break;
            }
          default:
            jj_la1[287] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_131(2147483647)) {
            statement = ShowUserPrivileges(start, useClause);
          } else if (jj_2_132(2147483647)) {
            statement = ShowUsers(start, useClause);
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case ESCAPED_SYMBOLIC_NAME:
            case ACCESS:
            case ACTIVE:
            case ADMIN:
            case ADMINISTRATOR:
            case ALIAS:
            case ALIASES:
            case ALL_SHORTEST_PATH:
            case ALL:
            case ALTER:
            case AND:
            case ANY:
            case ARRAY:
            case AS:
            case ASC:
            case ASCENDING:
            case ASSERT:
            case ASSIGN:
            case AT:
            case AUTH:
            case BINDINGS:
            case BOOL:
            case BOOLEAN:
            case BOOSTED:
            case BOTH:
            case BREAK:
            case BRIEF:
            case BTREE:
            case BUILT:
            case BY:
            case CALL:
            case CASCADE:
            case CASE:
            case CHANGE:
            case CIDR:
            case COLLECT:
            case COMMAND:
            case COMMANDS:
            case COMMIT:
            case COMPOSITE:
            case CONCURRENT:
            case CONSTRAINT:
            case CONSTRAINTS:
            case CONTAINS:
            case COPY:
            case CONTINUE:
            case COUNT:
            case CREATE:
            case CSV:
            case CURRENT:
            case DATA:
            case DATABASE:
            case DATABASES:
            case DATE:
            case DATETIME:
            case DBMS:
            case DEALLOCATE:
            case DEFAULT_TOKEN:
            case DEFINED:
            case DELETE:
            case DENY:
            case DESC:
            case DESCENDING:
            case DESTROY:
            case DETACH:
            case DOLLAR:
            case DIFFERENT:
            case DISTINCT:
            case DRIVER:
            case DROP:
            case DRYRUN:
            case DUMP:
            case DURATION:
            case EACH:
            case EDGE:
            case ENABLE:
            case ELEMENT:
            case ELEMENTS:
            case ELSE:
            case ENCRYPTED:
            case END:
            case ENDS:
            case EXECUTABLE:
            case EXECUTE:
            case EXIST:
            case EXISTENCE:
            case EXISTS:
            case ERROR:
            case FAIL:
            case FALSE:
            case FIELDTERMINATOR:
            case FINISH:
            case FLOAT:
            case FOR:
            case FOREACH:
            case FROM:
            case FULLTEXT:
            case FUNCTION:
            case FUNCTIONS:
            case GRANT:
            case GRAPH:
            case GRAPHS:
            case GROUP:
            case GROUPS:
            case HEADERS:
            case HOME:
            case ID:
            case IF:
            case IMPERSONATE:
            case IMMUTABLE:
            case IN:
            case INDEX:
            case INDEXES:
            case INF:
            case INFINITY:
            case INSERT:
            case INT:
            case INTEGER:
            case IS:
            case JOIN:
            case KEY:
            case LABEL:
            case LABELS:
            case LEADING:
            case LIMITROWS:
            case LIST:
            case LOAD:
            case LOCAL:
            case LOOKUP:
            case MANAGEMENT:
            case MAP:
            case MATCH:
            case MERGE:
            case NAME:
            case NAMES:
            case NAN:
            case NFC:
            case NFD:
            case NFKC:
            case NFKD:
            case NEW:
            case NODE:
            case NODETACH:
            case NODES:
            case NONE:
            case NORMALIZE:
            case NORMALIZED:
            case NOT:
            case NOTHING:
            case NOWAIT:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case ONLY:
            case OPTIONAL:
            case OPTIONS:
            case OPTION:
            case OR:
            case ORDER:
            case OUTPUT:
            case PASSWORD:
            case PASSWORDS:
            case PATH:
            case PATHS:
            case PERIODIC:
            case PLAINTEXT:
            case POINT:
            case POPULATED:
            case REPEATABLE:
            case PRIMARY:
            case PRIMARIES:
            case PRIVILEGE:
            case PRIVILEGES:
            case PROCEDURE:
            case PROCEDURES:
            case PROPERTIES:
            case PROPERTY:
            case PROVIDER:
            case PROVIDERS:
            case RANGE:
            case READ:
            case REALLOCATE:
            case REDUCE:
            case RENAME:
            case REL:
            case RELATIONSHIP:
            case RELATIONSHIPS:
            case REMOVE:
            case REPLACE:
            case REPORT:
            case REQUIRE:
            case REQUIRED:
            case RESTRICT:
            case RETURN:
            case REVOKE:
            case ROLE:
            case ROLES:
            case ROW:
            case ROWS:
            case SCAN:
            case SEC:
            case SECOND:
            case SECONDARY:
            case SECONDARIES:
            case SECONDS:
            case SEEK:
            case SERVER:
            case SERVERS:
            case SET:
            case SETTING:
            case SETTINGS:
            case SHORTEST_PATH:
            case SHORTEST:
            case SHOW:
            case SIGNED:
            case SINGLE:
            case SKIPROWS:
            case START:
            case STARTS:
            case STATUS:
            case STOP:
            case STRING:
            case SUPPORTED:
            case SUSPENDED:
            case TARGET:
            case TERMINATE:
            case TEXT:
            case THEN:
            case TIME:
            case TIMESTAMP:
            case TIMEZONE:
            case TO:
            case TOPOLOGY:
            case TRAILING:
            case TRANSACTION:
            case TRANSACTIONS:
            case TRAVERSE:
            case TRIM:
            case TRUE:
            case TYPE:
            case TYPED:
            case TYPES:
            case UNION:
            case UNIQUE:
            case UNIQUENESS:
            case UNWIND:
            case URL:
            case USE:
            case USER:
            case USERS:
            case USING:
            case VALUE:
            case VARCHAR:
            case VECTOR:
            case VERBOSE:
            case VERTEX:
            case WAIT:
            case WHEN:
            case WHERE:
            case WITH:
            case WITHOUT:
            case WRITE:
            case XOR:
            case YIELD:
            case ZONE:
            case ZONED:
            case IDENTIFIER:{
              statement = ShowUserPrivileges(start, useClause);
              break;
              }
            default:
              jj_la1[288] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[290] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
if ( clauses != null ) {
            if ( useClause != null )
            {
                clauses.add( 0, useClause );
            }
            statement = astFactory.newSingleQuery( pos( start ), clauses );
        }
        {if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT TerminateCommand(USE_CLAUSE useClause) throws ParseException, Exception {Token start = null;
    List<CLAUSE> clauses = null;
    start = jj_consume_token(TERMINATE);
    clauses = TerminateTransactions(start);
if ( useClause != null )
        {
            clauses.add( 0, useClause );
        }
        {if ("" != null) return astFactory.newSingleQuery( pos( start ), clauses );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowAllCommand(Token start, USE_CLAUSE useClause) throws ParseException, Exception {STATEMENT statement = null;
    List<CLAUSE> clauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:
    case ROLES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROLES:{
        jj_consume_token(ROLES);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      statement = ShowRoles(start, useClause, true);
      break;
      }
    case INDEX:
    case INDEXES:{
      clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case FUNCTION:
    case FUNCTIONS:{
      clauses = ShowFunctions(start, ShowCommandFilterTypes.ALL);
      break;
      }
    case PRIVILEGE:
    case PRIVILEGES:{
      statement = ShowPrivileges(start, useClause);
      break;
      }
    default:
      jj_la1[292] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( clauses != null ) {
            if ( useClause != null )
            {
                clauses.add( 0, useClause );
            }
            statement = astFactory.newSingleQuery( pos( start ), clauses );
        }
        {if ("" != null) return statement;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowNodeCommand(Token start) throws ParseException, Exception {List<CLAUSE> clauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNIQUE:
    case UNIQUENESS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNIQUE:{
        jj_consume_token(UNIQUE);
        break;
        }
      case UNIQUENESS:{
        jj_consume_token(UNIQUENESS);
        break;
        }
      default:
        jj_la1[293] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.NODE_UNIQUE);
      break;
      }
    case KEY:{
      jj_consume_token(KEY);
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.NODE_KEY);
      break;
      }
    case PROPERTY:{
      jj_consume_token(PROPERTY);
      clauses = ShowPropertyCommand(start, ShowCommandFilterTypes.NODE_EXIST);
      break;
      }
    case EXISTENCE:{
      jj_consume_token(EXISTENCE);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.NODE_EXIST);
      break;
      }
    case EXISTS:{
      jj_consume_token(EXISTS);
      ShowConstraintsAllowBrief(start);
      break;
      }
    case EXIST:{
      jj_consume_token(EXIST);
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.NODE_OLD_EXIST);
      break;
      }
    default:
      jj_la1[294] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowRelationshipCommand(Token start) throws ParseException, Exception {List<CLAUSE> clauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNIQUE:
    case UNIQUENESS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNIQUE:{
        jj_consume_token(UNIQUE);
        break;
        }
      case UNIQUENESS:{
        jj_consume_token(UNIQUENESS);
        break;
        }
      default:
        jj_la1[295] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_UNIQUE);
      break;
      }
    case KEY:{
      jj_consume_token(KEY);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_KEY);
      break;
      }
    case PROPERTY:{
      jj_consume_token(PROPERTY);
      clauses = ShowPropertyCommand(start, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTENCE:{
      jj_consume_token(EXISTENCE);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTS:{
      jj_consume_token(EXISTS);
      ShowConstraintsAllowBrief(start);
      break;
      }
    case EXIST:{
      jj_consume_token(EXIST);
      clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.RELATIONSHIP_OLD_EXIST);
      break;
      }
    default:
      jj_la1[296] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowRelCommand(Token start) throws ParseException, Exception {List<CLAUSE> clauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNIQUE:
    case UNIQUENESS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNIQUE:{
        jj_consume_token(UNIQUE);
        break;
        }
      case UNIQUENESS:{
        jj_consume_token(UNIQUENESS);
        break;
        }
      default:
        jj_la1[297] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_UNIQUE);
      break;
      }
    case KEY:{
      jj_consume_token(KEY);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_KEY);
      break;
      }
    case PROPERTY:{
      jj_consume_token(PROPERTY);
      clauses = ShowPropertyCommand(start, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXISTENCE:{
      jj_consume_token(EXISTENCE);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    case EXIST:{
      jj_consume_token(EXIST);
      clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.RELATIONSHIP_EXIST);
      break;
      }
    default:
      jj_la1[298] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowPropertyCommand(Token start, ShowCommandFilterTypes existenceConstraintType) throws ParseException, Exception {List<CLAUSE> clauses = null;
    ShowCommandFilterTypes propertyTypeConstraintType;
    if (existenceConstraintType.description().startsWith("NODE")) {
        propertyTypeConstraintType = ShowCommandFilterTypes.NODE_PROP_TYPE;
    } else if (existenceConstraintType.description().startsWith("REL")) {
        propertyTypeConstraintType = ShowCommandFilterTypes.RELATIONSHIP_PROP_TYPE;
    } else {
        propertyTypeConstraintType = ShowCommandFilterTypes.PROP_TYPE;
    }
    ShowCommandFilterTypes constraintType;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXIST:
    case EXISTENCE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXISTENCE:{
        jj_consume_token(EXISTENCE);
        break;
        }
      case EXIST:{
        jj_consume_token(EXIST);
        break;
        }
      default:
        jj_la1[299] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
constraintType = existenceConstraintType;
      break;
      }
    case TYPE:{
      jj_consume_token(TYPE);
constraintType = propertyTypeConstraintType;
      break;
      }
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    clauses = ShowConstraintsAllowYield(start, constraintType);
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RETURN_ITEM YieldItem() throws ParseException {VARIABLE e;
    VARIABLE v = null;
    Token eStart;
    Token eEnd;
eStart = token;
    e = Variable();
eEnd = token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      v = Variable();
      break;
      }
    default:
      jj_la1[301] = jj_gen;
      ;
    }
if ( v != null )
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, v );}
        }
        else
        {
            {if ("" != null) return astFactory.newReturnItem( pos( eStart.next ), e, eStart.next.beginOffset, eEnd.endOffset );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public YIELD YieldClause() throws ParseException, Exception {Token start;
    Token skipPosition = null;
    Token limitPosition = null;
    Token orderToken = null;
    boolean returnAll = false;
    RETURN_ITEM item;
    ORDER_ITEM o;
    List<RETURN_ITEM> returnItems = new ArrayList<>();
    List<ORDER_ITEM> orders = new ArrayList<>();
    EXPRESSION skip = null;
    EXPRESSION limit = null;
    WHERE where = null;
    start = jj_consume_token(YIELD);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
returnAll = true;
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      item = YieldItem();
returnItems.add( item );
      label_59:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[302] = jj_gen;
          break label_59;
        }
        jj_consume_token(COMMA);
        item = YieldItem();
returnItems.add( item );
      }
      break;
      }
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ORDER:{
      orderToken = jj_consume_token(ORDER);
      jj_consume_token(BY);
      o = OrderItem();
orders.add( o );
      label_60:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[304] = jj_gen;
          break label_60;
        }
        jj_consume_token(COMMA);
        o = OrderItem();
orders.add( o );
      }
      break;
      }
    default:
      jj_la1[305] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OFFSET:
    case SKIPROWS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SKIPROWS:{
        skipPosition = jj_consume_token(SKIPROWS);
        skip = SignedIntegerLiteral();
        break;
        }
      case OFFSET:{
        skipPosition = jj_consume_token(OFFSET);
        skip = SignedIntegerLiteral();
        break;
        }
      default:
        jj_la1[306] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[307] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LIMITROWS:{
      limitPosition = jj_consume_token(LIMITROWS);
      limit = SignedIntegerLiteral();
      break;
      }
    default:
      jj_la1[308] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      where = WhereClause();
      break;
      }
    default:
      jj_la1[309] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.yieldClause( pos( start ), returnAll, returnItems, pos( start.next ), orders, pos( orderToken ), skip, pos( skipPosition ), limit, pos( limitPosition ), where );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowIndexesAllowBrief(Token start, ShowCommandFilterTypes indexType) throws ParseException, Exception {// all and btree indexes
    List<CLAUSE> clauses = new ArrayList<>();
    boolean brief = false;
    boolean verbose = false;
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INDEX:{
      jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      jj_consume_token(INDEXES);
      break;
      }
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:
      case VERBOSE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BRIEF:{
          jj_consume_token(BRIEF);
brief = true;
          break;
          }
        case VERBOSE:{
          jj_consume_token(VERBOSE);
verbose = true;
          break;
          }
        default:
          jj_la1[311] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OUTPUT:{
          jj_consume_token(OUTPUT);
          break;
          }
        default:
          jj_la1[312] = jj_gen;
          ;
        }
        break;
        }
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[313] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[314] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[315] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[316] = jj_gen;
      ;
    }
if (brief || verbose) {
            throw exceptionFactory.syntaxException(
                    new ParseException(ASTExceptionFactory.invalidBriefVerbose("SHOW INDEXES")),
                    start.beginOffset, start.beginLine, start.beginColumn );
        }

        if (indexType == ShowCommandFilterTypes.BTREE ) {
            throw exceptionFactory.syntaxException(
                    new ParseException(ASTExceptionFactory.invalidShowBtreeIndexes),
                    start.beginOffset, start.beginLine, start.beginColumn );
        }

        if ( yieldClause != null )
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowIndexesNoBrief(Token start, ShowCommandFilterTypes indexType) throws ParseException, Exception {// remaining indexes
  List<CLAUSE> clauses = new ArrayList<>();
  WHERE where = null;
  YIELD yieldClause = null;
  RETURN_CLAUSE returnClause = null;
  List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INDEX:{
      jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      jj_consume_token(INDEXES);
      break;
      }
    default:
      jj_la1[317] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[318] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[319] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[320] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[321] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showIndexClause( pos( start ), indexType, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowConstraintsAllowBriefAndYield(Token start, ShowCommandFilterTypes constraintType) throws ParseException, Exception {// constraints that previously allowed brief/verbose
    List<CLAUSE> clauses = new ArrayList<>();
    boolean brief = false;
    boolean verbose = false;
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[322] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:
      case VERBOSE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BRIEF:{
          jj_consume_token(BRIEF);
brief = true;
          break;
          }
        case VERBOSE:{
          jj_consume_token(VERBOSE);
verbose = true;
          break;
          }
        default:
          jj_la1[323] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OUTPUT:{
          jj_consume_token(OUTPUT);
          break;
          }
        default:
          jj_la1[324] = jj_gen;
          ;
        }
        break;
        }
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[325] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[328] = jj_gen;
      ;
    }
if (brief || verbose) {
            throw exceptionFactory.syntaxException(
                    new ParseException(ASTExceptionFactory.invalidBriefVerbose("SHOW CONSTRAINTS")),
                    start.beginOffset, start.beginLine, start.beginColumn );
        }

        if ( yieldClause != null )
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void ShowConstraintsAllowBrief(Token start) throws ParseException, Exception {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[329] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BRIEF:
    case VERBOSE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BRIEF:{
        jj_consume_token(BRIEF);
        break;
        }
      case VERBOSE:{
        jj_consume_token(VERBOSE);
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OUTPUT:{
        jj_consume_token(OUTPUT);
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[332] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      composableCommandClauses();
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      ;
    }
throw exceptionFactory.syntaxException(
                new ParseException(ASTExceptionFactory.invalidExistsForShowConstraints),
                start.beginOffset, start.beginLine, start.beginColumn );
}

  final public List<CLAUSE> ShowConstraintsAllowYield(Token start, ShowCommandFilterTypes constraintType) throws ParseException, Exception {// constraints only allowing yield and not brief/verbose
    // this is the method that will be used for all constraints in 6.0
    List<CLAUSE> clauses = new ArrayList<>();
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:{
      jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      jj_consume_token(CONSTRAINTS);
      break;
      }
    default:
      jj_la1[334] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[335] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[336] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[337] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[338] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showConstraintClause( pos( start ), constraintType, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowProcedures(Token start) throws ParseException, Exception {List<CLAUSE> clauses = new ArrayList<>();

    boolean currentUser = false;
    Token userToken = null;
    String user = null;

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;

    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROCEDURE:{
      jj_consume_token(PROCEDURE);
      break;
      }
    case PROCEDURES:{
      jj_consume_token(PROCEDURES);
      break;
      }
    default:
      jj_la1[339] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXECUTABLE:{
      jj_consume_token(EXECUTABLE);
currentUser = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BY:{
        jj_consume_token(BY);
        if (jj_2_134(2147483647)) {
          jj_consume_token(CURRENT);
          jj_consume_token(USER);
currentUser = true;
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            userToken = SymbolicNameString();
user = userToken.image; currentUser = false;
            break;
            }
          default:
            jj_la1[340] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[341] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[343] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[344] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[345] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[346] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showProcedureClause( pos( start ), currentUser, user, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showProcedureClause( pos( start ), currentUser, user, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowFunctions(Token start, ShowCommandFilterTypes functionType) throws ParseException, Exception {List<CLAUSE> clauses = new ArrayList<>();

    boolean currentUser = false;
    Token userToken = null;
    String user = null;

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;

    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case FUNCTIONS:{
      jj_consume_token(FUNCTIONS);
      break;
      }
    default:
      jj_la1[347] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXECUTABLE:{
      jj_consume_token(EXECUTABLE);
currentUser = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BY:{
        jj_consume_token(BY);
        if (jj_2_135(2147483647)) {
          jj_consume_token(CURRENT);
          jj_consume_token(USER);
currentUser = true;
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            userToken = SymbolicNameString();
user = userToken.image; currentUser = false;
            break;
            }
          default:
            jj_la1[348] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[349] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[350] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[351] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[352] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[353] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SHOW:
    case TERMINATE:{
      tailClauses = composableCommandClauses();
      break;
      }
    default:
      jj_la1[354] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showFunctionClause( pos( start ), functionType, currentUser, user, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showFunctionClause( pos( start ), functionType, currentUser, user, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowTransactions(Token start) throws ParseException, Exception {List<CLAUSE> clauses = new LinkedList<>();
    SimpleEither<List<String>, EXPRESSION> idEither = SimpleEither.left(new ArrayList<>());

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;

    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      jj_consume_token(TRANSACTIONS);
      break;
      }
    default:
      jj_la1[355] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      if (jj_2_139(2147483647)) {
        tailClauses = composableCommandClauses();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DECIMAL_DOUBLE:
        case UNSIGNED_DECIMAL_INTEGER:
        case UNSIGNED_HEX_INTEGER:
        case UNSIGNED_OCTAL_INTEGER:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LBRACKET:
        case LCURLY:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case MINUS:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case PLUS:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          if (jj_2_136(2147483647)) {
            idEither = stringsOrExpression();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case YIELD:{
              yieldClause = YieldClause();
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case RETURN:{
                returnClause = ReturnClause();
                break;
                }
              default:
                jj_la1[356] = jj_gen;
                ;
              }
              break;
              }
            case WHERE:{
              where = WhereClause();
              break;
              }
            default:
              jj_la1[357] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else if (jj_2_137(2147483647)) {
            yieldClause = YieldClause();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RETURN:{
              returnClause = ReturnClause();
              break;
              }
            default:
              jj_la1[358] = jj_gen;
              ;
            }
          } else if (jj_2_138(2147483647)) {
            where = WhereClause();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DECIMAL_DOUBLE:
            case UNSIGNED_DECIMAL_INTEGER:
            case UNSIGNED_HEX_INTEGER:
            case UNSIGNED_OCTAL_INTEGER:
            case STRING_LITERAL1:
            case STRING_LITERAL2:
            case ESCAPED_SYMBOLIC_NAME:
            case ACCESS:
            case ACTIVE:
            case ADMIN:
            case ADMINISTRATOR:
            case ALIAS:
            case ALIASES:
            case ALL_SHORTEST_PATH:
            case ALL:
            case ALTER:
            case AND:
            case ANY:
            case ARRAY:
            case AS:
            case ASC:
            case ASCENDING:
            case ASSERT:
            case ASSIGN:
            case AT:
            case AUTH:
            case BINDINGS:
            case BOOL:
            case BOOLEAN:
            case BOOSTED:
            case BOTH:
            case BREAK:
            case BRIEF:
            case BTREE:
            case BUILT:
            case BY:
            case CALL:
            case CASCADE:
            case CASE:
            case CHANGE:
            case CIDR:
            case COLLECT:
            case COMMAND:
            case COMMANDS:
            case COMMIT:
            case COMPOSITE:
            case CONCURRENT:
            case CONSTRAINT:
            case CONSTRAINTS:
            case CONTAINS:
            case COPY:
            case CONTINUE:
            case COUNT:
            case CREATE:
            case CSV:
            case CURRENT:
            case DATA:
            case DATABASE:
            case DATABASES:
            case DATE:
            case DATETIME:
            case DBMS:
            case DEALLOCATE:
            case DEFAULT_TOKEN:
            case DEFINED:
            case DELETE:
            case DENY:
            case DESC:
            case DESCENDING:
            case DESTROY:
            case DETACH:
            case DOLLAR:
            case DIFFERENT:
            case DISTINCT:
            case DRIVER:
            case DROP:
            case DRYRUN:
            case DUMP:
            case DURATION:
            case EACH:
            case EDGE:
            case ENABLE:
            case ELEMENT:
            case ELEMENTS:
            case ELSE:
            case ENCRYPTED:
            case END:
            case ENDS:
            case EXECUTABLE:
            case EXECUTE:
            case EXIST:
            case EXISTENCE:
            case EXISTS:
            case ERROR:
            case FAIL:
            case FALSE:
            case FIELDTERMINATOR:
            case FINISH:
            case FLOAT:
            case FOR:
            case FOREACH:
            case FROM:
            case FULLTEXT:
            case FUNCTION:
            case FUNCTIONS:
            case GRANT:
            case GRAPH:
            case GRAPHS:
            case GROUP:
            case GROUPS:
            case HEADERS:
            case HOME:
            case ID:
            case IF:
            case IMPERSONATE:
            case IMMUTABLE:
            case IN:
            case INDEX:
            case INDEXES:
            case INF:
            case INFINITY:
            case INSERT:
            case INT:
            case INTEGER:
            case IS:
            case JOIN:
            case KEY:
            case LABEL:
            case LABELS:
            case LBRACKET:
            case LCURLY:
            case LEADING:
            case LIMITROWS:
            case LIST:
            case LOAD:
            case LOCAL:
            case LOOKUP:
            case LPAREN:
            case MANAGEMENT:
            case MAP:
            case MATCH:
            case MERGE:
            case MINUS:
            case NAME:
            case NAMES:
            case NAN:
            case NFC:
            case NFD:
            case NFKC:
            case NFKD:
            case NEW:
            case NODE:
            case NODETACH:
            case NODES:
            case NONE:
            case NORMALIZE:
            case NORMALIZED:
            case NOT:
            case NOTHING:
            case NOWAIT:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case ONLY:
            case OPTIONAL:
            case OPTIONS:
            case OPTION:
            case OR:
            case ORDER:
            case OUTPUT:
            case PASSWORD:
            case PASSWORDS:
            case PATH:
            case PATHS:
            case PERIODIC:
            case PLAINTEXT:
            case PLUS:
            case POINT:
            case POPULATED:
            case REPEATABLE:
            case PRIMARY:
            case PRIMARIES:
            case PRIVILEGE:
            case PRIVILEGES:
            case PROCEDURE:
            case PROCEDURES:
            case PROPERTIES:
            case PROPERTY:
            case PROVIDER:
            case PROVIDERS:
            case RANGE:
            case READ:
            case REALLOCATE:
            case REDUCE:
            case RENAME:
            case REL:
            case RELATIONSHIP:
            case RELATIONSHIPS:
            case REMOVE:
            case REPLACE:
            case REPORT:
            case REQUIRE:
            case REQUIRED:
            case RESTRICT:
            case RETURN:
            case REVOKE:
            case ROLE:
            case ROLES:
            case ROW:
            case ROWS:
            case SCAN:
            case SEC:
            case SECOND:
            case SECONDARY:
            case SECONDARIES:
            case SECONDS:
            case SEEK:
            case SERVER:
            case SERVERS:
            case SET:
            case SETTING:
            case SETTINGS:
            case SHORTEST_PATH:
            case SHORTEST:
            case SHOW:
            case SIGNED:
            case SINGLE:
            case SKIPROWS:
            case START:
            case STARTS:
            case STATUS:
            case STOP:
            case STRING:
            case SUPPORTED:
            case SUSPENDED:
            case TARGET:
            case TERMINATE:
            case TEXT:
            case THEN:
            case TIME:
            case TIMESTAMP:
            case TIMEZONE:
            case TO:
            case TOPOLOGY:
            case TRAILING:
            case TRANSACTION:
            case TRANSACTIONS:
            case TRAVERSE:
            case TRIM:
            case TRUE:
            case TYPE:
            case TYPED:
            case TYPES:
            case UNION:
            case UNIQUE:
            case UNIQUENESS:
            case UNWIND:
            case URL:
            case USE:
            case USER:
            case USERS:
            case USING:
            case VALUE:
            case VARCHAR:
            case VECTOR:
            case VERBOSE:
            case VERTEX:
            case WAIT:
            case WHEN:
            case WHERE:
            case WITH:
            case WITHOUT:
            case WRITE:
            case XOR:
            case YIELD:
            case ZONE:
            case ZONED:
            case IDENTIFIER:{
              idEither = stringsOrExpression();
              break;
              }
            default:
              jj_la1[359] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SHOW:
          case TERMINATE:{
            tailClauses = composableCommandClauses();
            break;
            }
          default:
            jj_la1[360] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[361] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[362] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showTransactionsClause( pos( start ), idEither,  where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showTransactionsClause( pos( start ), idEither, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> TerminateTransactions(Token start) throws ParseException, Exception {List<CLAUSE> clauses = new LinkedList<>();
    SimpleEither<List<String>, EXPRESSION> idEither = SimpleEither.left(new ArrayList<>());

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;

    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      jj_consume_token(TRANSACTIONS);
      break;
      }
    default:
      jj_la1[363] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      if (jj_2_143(2147483647)) {
        tailClauses = composableCommandClauses();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DECIMAL_DOUBLE:
        case UNSIGNED_DECIMAL_INTEGER:
        case UNSIGNED_HEX_INTEGER:
        case UNSIGNED_OCTAL_INTEGER:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LBRACKET:
        case LCURLY:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case MINUS:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case PLUS:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          if (jj_2_140(2147483647)) {
            idEither = stringsOrExpression();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case YIELD:{
              yieldClause = YieldClause();
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case RETURN:{
                returnClause = ReturnClause();
                break;
                }
              default:
                jj_la1[364] = jj_gen;
                ;
              }
              break;
              }
            case WHERE:{
              where = WhereClause();
              break;
              }
            default:
              jj_la1[365] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else if (jj_2_141(2147483647)) {
            yieldClause = YieldClause();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RETURN:{
              returnClause = ReturnClause();
              break;
              }
            default:
              jj_la1[366] = jj_gen;
              ;
            }
          } else if (jj_2_142(2147483647)) {
            where = WhereClause();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DECIMAL_DOUBLE:
            case UNSIGNED_DECIMAL_INTEGER:
            case UNSIGNED_HEX_INTEGER:
            case UNSIGNED_OCTAL_INTEGER:
            case STRING_LITERAL1:
            case STRING_LITERAL2:
            case ESCAPED_SYMBOLIC_NAME:
            case ACCESS:
            case ACTIVE:
            case ADMIN:
            case ADMINISTRATOR:
            case ALIAS:
            case ALIASES:
            case ALL_SHORTEST_PATH:
            case ALL:
            case ALTER:
            case AND:
            case ANY:
            case ARRAY:
            case AS:
            case ASC:
            case ASCENDING:
            case ASSERT:
            case ASSIGN:
            case AT:
            case AUTH:
            case BINDINGS:
            case BOOL:
            case BOOLEAN:
            case BOOSTED:
            case BOTH:
            case BREAK:
            case BRIEF:
            case BTREE:
            case BUILT:
            case BY:
            case CALL:
            case CASCADE:
            case CASE:
            case CHANGE:
            case CIDR:
            case COLLECT:
            case COMMAND:
            case COMMANDS:
            case COMMIT:
            case COMPOSITE:
            case CONCURRENT:
            case CONSTRAINT:
            case CONSTRAINTS:
            case CONTAINS:
            case COPY:
            case CONTINUE:
            case COUNT:
            case CREATE:
            case CSV:
            case CURRENT:
            case DATA:
            case DATABASE:
            case DATABASES:
            case DATE:
            case DATETIME:
            case DBMS:
            case DEALLOCATE:
            case DEFAULT_TOKEN:
            case DEFINED:
            case DELETE:
            case DENY:
            case DESC:
            case DESCENDING:
            case DESTROY:
            case DETACH:
            case DOLLAR:
            case DIFFERENT:
            case DISTINCT:
            case DRIVER:
            case DROP:
            case DRYRUN:
            case DUMP:
            case DURATION:
            case EACH:
            case EDGE:
            case ENABLE:
            case ELEMENT:
            case ELEMENTS:
            case ELSE:
            case ENCRYPTED:
            case END:
            case ENDS:
            case EXECUTABLE:
            case EXECUTE:
            case EXIST:
            case EXISTENCE:
            case EXISTS:
            case ERROR:
            case FAIL:
            case FALSE:
            case FIELDTERMINATOR:
            case FINISH:
            case FLOAT:
            case FOR:
            case FOREACH:
            case FROM:
            case FULLTEXT:
            case FUNCTION:
            case FUNCTIONS:
            case GRANT:
            case GRAPH:
            case GRAPHS:
            case GROUP:
            case GROUPS:
            case HEADERS:
            case HOME:
            case ID:
            case IF:
            case IMPERSONATE:
            case IMMUTABLE:
            case IN:
            case INDEX:
            case INDEXES:
            case INF:
            case INFINITY:
            case INSERT:
            case INT:
            case INTEGER:
            case IS:
            case JOIN:
            case KEY:
            case LABEL:
            case LABELS:
            case LBRACKET:
            case LCURLY:
            case LEADING:
            case LIMITROWS:
            case LIST:
            case LOAD:
            case LOCAL:
            case LOOKUP:
            case LPAREN:
            case MANAGEMENT:
            case MAP:
            case MATCH:
            case MERGE:
            case MINUS:
            case NAME:
            case NAMES:
            case NAN:
            case NFC:
            case NFD:
            case NFKC:
            case NFKD:
            case NEW:
            case NODE:
            case NODETACH:
            case NODES:
            case NONE:
            case NORMALIZE:
            case NORMALIZED:
            case NOT:
            case NOTHING:
            case NOWAIT:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case ONLY:
            case OPTIONAL:
            case OPTIONS:
            case OPTION:
            case OR:
            case ORDER:
            case OUTPUT:
            case PASSWORD:
            case PASSWORDS:
            case PATH:
            case PATHS:
            case PERIODIC:
            case PLAINTEXT:
            case PLUS:
            case POINT:
            case POPULATED:
            case REPEATABLE:
            case PRIMARY:
            case PRIMARIES:
            case PRIVILEGE:
            case PRIVILEGES:
            case PROCEDURE:
            case PROCEDURES:
            case PROPERTIES:
            case PROPERTY:
            case PROVIDER:
            case PROVIDERS:
            case RANGE:
            case READ:
            case REALLOCATE:
            case REDUCE:
            case RENAME:
            case REL:
            case RELATIONSHIP:
            case RELATIONSHIPS:
            case REMOVE:
            case REPLACE:
            case REPORT:
            case REQUIRE:
            case REQUIRED:
            case RESTRICT:
            case RETURN:
            case REVOKE:
            case ROLE:
            case ROLES:
            case ROW:
            case ROWS:
            case SCAN:
            case SEC:
            case SECOND:
            case SECONDARY:
            case SECONDARIES:
            case SECONDS:
            case SEEK:
            case SERVER:
            case SERVERS:
            case SET:
            case SETTING:
            case SETTINGS:
            case SHORTEST_PATH:
            case SHORTEST:
            case SHOW:
            case SIGNED:
            case SINGLE:
            case SKIPROWS:
            case START:
            case STARTS:
            case STATUS:
            case STOP:
            case STRING:
            case SUPPORTED:
            case SUSPENDED:
            case TARGET:
            case TERMINATE:
            case TEXT:
            case THEN:
            case TIME:
            case TIMESTAMP:
            case TIMEZONE:
            case TO:
            case TOPOLOGY:
            case TRAILING:
            case TRANSACTION:
            case TRANSACTIONS:
            case TRAVERSE:
            case TRIM:
            case TRUE:
            case TYPE:
            case TYPED:
            case TYPES:
            case UNION:
            case UNIQUE:
            case UNIQUENESS:
            case UNWIND:
            case URL:
            case USE:
            case USER:
            case USERS:
            case USING:
            case VALUE:
            case VARCHAR:
            case VECTOR:
            case VERBOSE:
            case VERTEX:
            case WAIT:
            case WHEN:
            case WHERE:
            case WITH:
            case WITHOUT:
            case WRITE:
            case XOR:
            case YIELD:
            case ZONE:
            case ZONED:
            case IDENTIFIER:{
              idEither = stringsOrExpression();
              break;
              }
            default:
              jj_la1[367] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SHOW:
          case TERMINATE:{
            tailClauses = composableCommandClauses();
            break;
            }
          default:
            jj_la1[368] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[369] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[370] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.terminateTransactionsClause( pos( start ), idEither, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.terminateTransactionsClause( pos( start ), idEither, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> ShowSettings(Token start) throws ParseException, Exception {List<CLAUSE> clauses = new ArrayList<>();
    SimpleEither<List<String>, EXPRESSION> nameEither = SimpleEither.left(new ArrayList<>());

    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;

    List<CLAUSE> tailClauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SETTING:{
      jj_consume_token(SETTING);
      break;
      }
    case SETTINGS:{
      jj_consume_token(SETTINGS);
      break;
      }
    default:
      jj_la1[371] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DECIMAL_DOUBLE:
    case UNSIGNED_DECIMAL_INTEGER:
    case UNSIGNED_HEX_INTEGER:
    case UNSIGNED_OCTAL_INTEGER:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DOLLAR:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LBRACKET:
    case LCURLY:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case LPAREN:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case MINUS:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case PLUS:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      if (jj_2_147(2147483647)) {
        tailClauses = composableCommandClauses();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DECIMAL_DOUBLE:
        case UNSIGNED_DECIMAL_INTEGER:
        case UNSIGNED_HEX_INTEGER:
        case UNSIGNED_OCTAL_INTEGER:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LBRACKET:
        case LCURLY:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case MINUS:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case PLUS:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          if (jj_2_144(2147483647)) {
            nameEither = stringsOrExpression();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case YIELD:{
              yieldClause = YieldClause();
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case RETURN:{
                returnClause = ReturnClause();
                break;
                }
              default:
                jj_la1[372] = jj_gen;
                ;
              }
              break;
              }
            case WHERE:{
              where = WhereClause();
              break;
              }
            default:
              jj_la1[373] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else if (jj_2_145(2147483647)) {
            yieldClause = YieldClause();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RETURN:{
              returnClause = ReturnClause();
              break;
              }
            default:
              jj_la1[374] = jj_gen;
              ;
            }
          } else if (jj_2_146(2147483647)) {
            where = WhereClause();
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DECIMAL_DOUBLE:
            case UNSIGNED_DECIMAL_INTEGER:
            case UNSIGNED_HEX_INTEGER:
            case UNSIGNED_OCTAL_INTEGER:
            case STRING_LITERAL1:
            case STRING_LITERAL2:
            case ESCAPED_SYMBOLIC_NAME:
            case ACCESS:
            case ACTIVE:
            case ADMIN:
            case ADMINISTRATOR:
            case ALIAS:
            case ALIASES:
            case ALL_SHORTEST_PATH:
            case ALL:
            case ALTER:
            case AND:
            case ANY:
            case ARRAY:
            case AS:
            case ASC:
            case ASCENDING:
            case ASSERT:
            case ASSIGN:
            case AT:
            case AUTH:
            case BINDINGS:
            case BOOL:
            case BOOLEAN:
            case BOOSTED:
            case BOTH:
            case BREAK:
            case BRIEF:
            case BTREE:
            case BUILT:
            case BY:
            case CALL:
            case CASCADE:
            case CASE:
            case CHANGE:
            case CIDR:
            case COLLECT:
            case COMMAND:
            case COMMANDS:
            case COMMIT:
            case COMPOSITE:
            case CONCURRENT:
            case CONSTRAINT:
            case CONSTRAINTS:
            case CONTAINS:
            case COPY:
            case CONTINUE:
            case COUNT:
            case CREATE:
            case CSV:
            case CURRENT:
            case DATA:
            case DATABASE:
            case DATABASES:
            case DATE:
            case DATETIME:
            case DBMS:
            case DEALLOCATE:
            case DEFAULT_TOKEN:
            case DEFINED:
            case DELETE:
            case DENY:
            case DESC:
            case DESCENDING:
            case DESTROY:
            case DETACH:
            case DOLLAR:
            case DIFFERENT:
            case DISTINCT:
            case DRIVER:
            case DROP:
            case DRYRUN:
            case DUMP:
            case DURATION:
            case EACH:
            case EDGE:
            case ENABLE:
            case ELEMENT:
            case ELEMENTS:
            case ELSE:
            case ENCRYPTED:
            case END:
            case ENDS:
            case EXECUTABLE:
            case EXECUTE:
            case EXIST:
            case EXISTENCE:
            case EXISTS:
            case ERROR:
            case FAIL:
            case FALSE:
            case FIELDTERMINATOR:
            case FINISH:
            case FLOAT:
            case FOR:
            case FOREACH:
            case FROM:
            case FULLTEXT:
            case FUNCTION:
            case FUNCTIONS:
            case GRANT:
            case GRAPH:
            case GRAPHS:
            case GROUP:
            case GROUPS:
            case HEADERS:
            case HOME:
            case ID:
            case IF:
            case IMPERSONATE:
            case IMMUTABLE:
            case IN:
            case INDEX:
            case INDEXES:
            case INF:
            case INFINITY:
            case INSERT:
            case INT:
            case INTEGER:
            case IS:
            case JOIN:
            case KEY:
            case LABEL:
            case LABELS:
            case LBRACKET:
            case LCURLY:
            case LEADING:
            case LIMITROWS:
            case LIST:
            case LOAD:
            case LOCAL:
            case LOOKUP:
            case LPAREN:
            case MANAGEMENT:
            case MAP:
            case MATCH:
            case MERGE:
            case MINUS:
            case NAME:
            case NAMES:
            case NAN:
            case NFC:
            case NFD:
            case NFKC:
            case NFKD:
            case NEW:
            case NODE:
            case NODETACH:
            case NODES:
            case NONE:
            case NORMALIZE:
            case NORMALIZED:
            case NOT:
            case NOTHING:
            case NOWAIT:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case ONLY:
            case OPTIONAL:
            case OPTIONS:
            case OPTION:
            case OR:
            case ORDER:
            case OUTPUT:
            case PASSWORD:
            case PASSWORDS:
            case PATH:
            case PATHS:
            case PERIODIC:
            case PLAINTEXT:
            case PLUS:
            case POINT:
            case POPULATED:
            case REPEATABLE:
            case PRIMARY:
            case PRIMARIES:
            case PRIVILEGE:
            case PRIVILEGES:
            case PROCEDURE:
            case PROCEDURES:
            case PROPERTIES:
            case PROPERTY:
            case PROVIDER:
            case PROVIDERS:
            case RANGE:
            case READ:
            case REALLOCATE:
            case REDUCE:
            case RENAME:
            case REL:
            case RELATIONSHIP:
            case RELATIONSHIPS:
            case REMOVE:
            case REPLACE:
            case REPORT:
            case REQUIRE:
            case REQUIRED:
            case RESTRICT:
            case RETURN:
            case REVOKE:
            case ROLE:
            case ROLES:
            case ROW:
            case ROWS:
            case SCAN:
            case SEC:
            case SECOND:
            case SECONDARY:
            case SECONDARIES:
            case SECONDS:
            case SEEK:
            case SERVER:
            case SERVERS:
            case SET:
            case SETTING:
            case SETTINGS:
            case SHORTEST_PATH:
            case SHORTEST:
            case SHOW:
            case SIGNED:
            case SINGLE:
            case SKIPROWS:
            case START:
            case STARTS:
            case STATUS:
            case STOP:
            case STRING:
            case SUPPORTED:
            case SUSPENDED:
            case TARGET:
            case TERMINATE:
            case TEXT:
            case THEN:
            case TIME:
            case TIMESTAMP:
            case TIMEZONE:
            case TO:
            case TOPOLOGY:
            case TRAILING:
            case TRANSACTION:
            case TRANSACTIONS:
            case TRAVERSE:
            case TRIM:
            case TRUE:
            case TYPE:
            case TYPED:
            case TYPES:
            case UNION:
            case UNIQUE:
            case UNIQUENESS:
            case UNWIND:
            case URL:
            case USE:
            case USER:
            case USERS:
            case USING:
            case VALUE:
            case VARCHAR:
            case VECTOR:
            case VERBOSE:
            case VERTEX:
            case WAIT:
            case WHEN:
            case WHERE:
            case WITH:
            case WITHOUT:
            case WRITE:
            case XOR:
            case YIELD:
            case ZONE:
            case ZONED:
            case IDENTIFIER:{
              nameEither = stringsOrExpression();
              break;
              }
            default:
              jj_la1[375] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SHOW:
          case TERMINATE:{
            tailClauses = composableCommandClauses();
            break;
            }
          default:
            jj_la1[376] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[377] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[378] = jj_gen;
      ;
    }
if ( yieldClause != null )
        {
            clauses.add( astFactory.showSettingsClause( pos( start ), nameEither, where, yieldClause ) );
            clauses.add( astFactory.turnYieldToWith( yieldClause ) );
            if ( returnClause != null )
            {
                clauses.add( returnClause );
            }
        }
        else
        {
            clauses.add( astFactory.showSettingsClause( pos( start ), nameEither, where, null ) );
        }
        if ( tailClauses != null ) {
            clauses.addAll( tailClauses );
        }
        {if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<CLAUSE> composableCommandClauses() throws ParseException, Exception {Token start = null;
    List<CLAUSE> clauses = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TERMINATE:{
      start = jj_consume_token(TERMINATE);
      clauses = TerminateTransactions(start);
      break;
      }
    case SHOW:{
      start = jj_consume_token(SHOW);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:{
        jj_consume_token(ALL);
        if (jj_2_148(2147483647)) {
          clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.ALL);
        } else if (jj_2_149(2147483647)) {
          clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.ALL);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case FUNCTION:
          case FUNCTIONS:{
            clauses = ShowFunctions(start, ShowCommandFilterTypes.ALL);
            break;
            }
          default:
            jj_la1[379] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case BTREE:{
        jj_consume_token(BTREE);
        clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.BTREE);
        break;
        }
      case BUILT:{
        jj_consume_token(BUILT);
        jj_consume_token(IN);
        clauses = ShowFunctions(start, ShowCommandFilterTypes.BUILT_IN);
        break;
        }
      case EXISTENCE:{
        jj_consume_token(EXISTENCE);
        clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.EXIST);
        break;
        }
      case EXISTS:{
        jj_consume_token(EXISTS);
        ShowConstraintsAllowBrief(start);
        break;
        }
      case EXIST:{
        jj_consume_token(EXIST);
        clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.OLD_EXIST);
        break;
        }
      case FULLTEXT:{
        jj_consume_token(FULLTEXT);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.FULLTEXT);
        break;
        }
      case KEY:{
        jj_consume_token(KEY);
        clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.KEY);
        break;
        }
      case LOOKUP:{
        jj_consume_token(LOOKUP);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.LOOKUP);
        break;
        }
      case NODE:{
        jj_consume_token(NODE);
        clauses = ShowNodeCommand(start);
        break;
        }
      case POINT:{
        jj_consume_token(POINT);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.POINT);
        break;
        }
      case PROPERTY:{
        jj_consume_token(PROPERTY);
        clauses = ShowPropertyCommand(start, ShowCommandFilterTypes.EXIST);
        break;
        }
      case RANGE:{
        jj_consume_token(RANGE);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.RANGE);
        break;
        }
      case RELATIONSHIP:{
        jj_consume_token(RELATIONSHIP);
        clauses = ShowRelationshipCommand(start);
        break;
        }
      case REL:{
        jj_consume_token(REL);
        clauses = ShowRelCommand(start);
        break;
        }
      case TEXT:{
        jj_consume_token(TEXT);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.TEXT);
        break;
        }
      case UNIQUENESS:{
        jj_consume_token(UNIQUENESS);
        clauses = ShowConstraintsAllowYield(start, ShowCommandFilterTypes.UNIQUE);
        break;
        }
      case UNIQUE:{
        jj_consume_token(UNIQUE);
        clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.UNIQUE);
        break;
        }
      case USER:{
        jj_consume_token(USER);
        jj_consume_token(DEFINED);
        clauses = ShowFunctions(start, ShowCommandFilterTypes.USER_DEFINED);
        break;
        }
      case VECTOR:{
        jj_consume_token(VECTOR);
        clauses = ShowIndexesNoBrief(start, ShowCommandFilterTypes.VECTOR);
        break;
        }
      default:
        jj_la1[380] = jj_gen;
        if (jj_2_150(2147483647)) {
          clauses = ShowConstraintsAllowBriefAndYield(start, ShowCommandFilterTypes.ALL);
        } else if (jj_2_151(2147483647)) {
          clauses = ShowFunctions(start, ShowCommandFilterTypes.ALL);
        } else if (jj_2_152(2147483647)) {
          clauses = ShowIndexesAllowBrief(start, ShowCommandFilterTypes.ALL);
        } else if (jj_2_153(2147483647)) {
          clauses = ShowProcedures(start);
        } else if (jj_2_154(2147483647)) {
          clauses = ShowSettings(start);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TRANSACTION:
          case TRANSACTIONS:{
            clauses = ShowTransactions(start);
            break;
            }
          default:
            jj_la1[381] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      break;
      }
    default:
      jj_la1[382] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return clauses;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<List<String>, EXPRESSION> stringsOrExpression() throws ParseException, Exception {List<String> ids = new ArrayList<>();
    EXPRESSION expr = null;
    SimpleEither<List<String>, EXPRESSION> idEither = SimpleEither.left(ids);
    if (jj_2_155(2147483647)) {
      ids = StringList();
idEither=SimpleEither.left(ids);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DECIMAL_DOUBLE:
      case UNSIGNED_DECIMAL_INTEGER:
      case UNSIGNED_HEX_INTEGER:
      case UNSIGNED_OCTAL_INTEGER:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LBRACKET:
      case LCURLY:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case LPAREN:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case MINUS:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case PLUS:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        expr = Expression();
idEither=SimpleEither.right(expr);
        break;
        }
      default:
        jj_la1[383] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return idEither;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Schema commands
// Constraint commands
  final public 
SCHEMA_COMMAND CreateConstraint(Token start, boolean replace) throws ParseException, Exception {SimpleEither<StringPos<POS>, PARAMETER> name = null;
    boolean ifNotExists = false;
    Token label;
    VARIABLE variable = null;
    List<PROPERTY> properties = new ArrayList<>();
    ParserCypherTypeName propertyType = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    ConstraintType constraintType = ConstraintType.NODE_EXISTS;
    boolean isNode = false;
    Token errorStart;
    boolean containsOn = true;
    ConstraintVersion constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
    jj_consume_token(CONSTRAINT);
    if (jj_2_157(2147483647)) {
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
    } else if (jj_2_158(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
containsOn = false;
    } else if (jj_2_159(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        jj_consume_token(ON);
        break;
        }
      case FOR:{
        jj_consume_token(FOR);
containsOn = false;
        break;
        }
      default:
        jj_la1[384] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        if (jj_2_156(2)) {
          name = SymbolicNameOrStringParameter();
        } else {
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[385] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ON:{
          jj_consume_token(ON);
          break;
          }
        case FOR:{
          jj_consume_token(FOR);
containsOn = false;
          break;
          }
        default:
          jj_la1[386] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[387] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      //(variable:LABEL)
              variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[388] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[389] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[390] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_160(2147483647)) {
      jj_consume_token(ASSERT);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
      errorStart = jj_consume_token(EXISTS);
constraintType = isNode ? ConstraintType.NODE_EXISTS : ConstraintType.REL_EXISTS;
      properties = PropertyList();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASSERT:
      case REQUIRE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case REQUIRE:{
          jj_consume_token(REQUIRE);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_2;
          break;
          }
        case ASSERT:{
          jj_consume_token(ASSERT);
constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_0;
          break;
          }
        default:
          jj_la1[391] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        properties = PropertyList();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLONCOLON:{
          jj_consume_token(COLONCOLON);
          propertyType = cypherTypeName();
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop :: <TYPE>
                // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop :: <TYPE>
                constraintType = isNode ? ConstraintType.NODE_IS_TYPED : ConstraintType.REL_IS_TYPED;
          break;
          }
        case IS:{
          errorStart = jj_consume_token(IS);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNIQUE:{
            jj_consume_token(UNIQUE);
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS UNIQUE
                        // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS UNIQUE
                        constraintType = isNode ? ConstraintType.NODE_UNIQUE : ConstraintType.REL_UNIQUE;
            break;
            }
          case KEY:{
            jj_consume_token(KEY);
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS KEY
                        // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS KEY
                        constraintType = isNode ? ConstraintType.NODE_KEY : ConstraintType.REL_KEY;
            break;
            }
          case NODE:{
            jj_consume_token(NODE);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case KEY:{
              jj_consume_token(KEY);
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS NODE KEY
                        constraintType = ConstraintType.NODE_KEY;
                        if ( !isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.relationshipPatternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
              break;
              }
            case UNIQUE:{
              jj_consume_token(UNIQUE);
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS NODE UNIQUE
                        constraintType = ConstraintType.NODE_UNIQUE;
                        if ( !isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.relationshipPatternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
              break;
              }
            default:
              jj_la1[392] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          case REL:
          case RELATIONSHIP:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RELATIONSHIP:{
              jj_consume_token(RELATIONSHIP);
              break;
              }
            case REL:{
              jj_consume_token(REL);
              break;
              }
            default:
              jj_la1[393] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case KEY:{
              jj_consume_token(KEY);
// CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS RELATIONSHIP KEY
                        constraintType = ConstraintType.REL_KEY;
                        if ( isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.nodePatternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
              break;
              }
            case UNIQUE:{
              jj_consume_token(UNIQUE);
// CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS RELATIONSHIP UNIQUE
                        constraintType = ConstraintType.REL_UNIQUE;
                        if ( isNode )
                        {
                            throw exceptionFactory.syntaxException(
                                new ParseException( ASTExceptionFactory.nodePatternNotAllowed( constraintType ) ),
                                errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                        }
              break;
              }
            default:
              jj_la1[394] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          case NOT:{
            jj_consume_token(NOT);
            jj_consume_token(NULL);
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS NOT NULL
                    // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS NOT NULL
                    constraintType = isNode ? ConstraintType.NODE_IS_NOT_NULL : ConstraintType.REL_IS_NOT_NULL;
                    if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0)
                    {
                        constraintVersion = ConstraintVersion.CONSTRAINT_VERSION_1;
                    }
            break;
            }
          case COLONCOLON:
          case TYPED:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case TYPED:{
              jj_consume_token(TYPED);
              break;
              }
            case COLONCOLON:{
              jj_consume_token(COLONCOLON);
              break;
              }
            default:
              jj_la1[395] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            propertyType = cypherTypeName();
// CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS :: <TYPE>
                    // CREATE CONSTRAINT FOR (variable:LABEL) REQUIRE variable.prop IS TYPED <TYPE>
                    // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS :: <TYPE>
                    // CREATE CONSTRAINT FOR ()-[variable:LABEL]-() REQUIRE variable.prop IS TYPED <TYPE>
                    constraintType = isNode ? ConstraintType.NODE_IS_TYPED : ConstraintType.REL_IS_TYPED;
            break;
            }
          default:
            jj_la1[396] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[397] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[398] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[399] = jj_gen;
      ;
    }
String error = ASTExceptionFactory.checkForInvalidCreateConstraint(constraintType, constraintVersion, containsOn, properties.size() > 1);
        if (error != null) {
            throw exceptionFactory.syntaxException(
                new ParseException( error ),
                start.beginOffset, start.beginLine, start.beginColumn );
        } else {
            {if ("" != null) return astFactory.createConstraint( pos( start ), constraintType, replace, ifNotExists, name, variable,
            new StringPos<POS>( label.image, pos( label ) ), properties, propertyType, options );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParserCypherTypeName cypherTypeName() throws ParseException, Exception {Token t = null;
    List<ParserCypherTypeName> list = new ArrayList<>();
t = token;
    list = cypherTypeNameList();
if ( list.size() ==  1)
        {
            {if ("" != null) return list.get(0);}
        }
        else
        {
             t = t.next;
            {if ("" != null) return ParserCypherTypeName.closedDynamicUnionOf(list).withPos(t.beginOffset, t.beginLine, t.beginColumn);}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<ParserCypherTypeName> cypherTypeNameList() throws ParseException, Exception {ParserCypherTypeName typeName;
    List<ParserCypherTypeName> list = new ArrayList<>();
    typeName = cypherTypeNamePart();
list.add( typeName );
    label_61:
    while (true) {
      if (jj_2_161(2)) {
      } else {
        break label_61;
      }
      jj_consume_token(BAR);
      typeName = cypherTypeNamePart();
list.add( typeName );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParserCypherTypeName cypherTypeNamePart() throws ParseException, Exception {Token t = null;
    ParserCypherTypeName typeName = null;
    ParserCypherTypeName innerType = null;
    List<ParserCypherTypeName> unionTypeList = null;
t = token;
    try {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOTHING:{
        jj_consume_token(NOTHING);
typeName = ParserCypherTypeName.NOTHING;
        break;
        }
      case NULL:{
        jj_consume_token(NULL);
typeName = ParserCypherTypeName.NULL;
        break;
        }
      case BOOL:
      case BOOLEAN:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case BOOLEAN:{
          jj_consume_token(BOOLEAN);
          break;
          }
        case BOOL:{
          jj_consume_token(BOOL);
          break;
          }
        default:
          jj_la1[400] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.BOOLEAN;
        break;
        }
      case STRING:
      case VARCHAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          jj_consume_token(STRING);
          break;
          }
        case VARCHAR:{
          jj_consume_token(VARCHAR);
          break;
          }
        default:
          jj_la1[401] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.STRING;
        break;
        }
      case INT:
      case INTEGER:
      case SIGNED:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INT:{
          jj_consume_token(INT);
          break;
          }
        case INTEGER:
        case SIGNED:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SIGNED:{
            jj_consume_token(SIGNED);
            break;
            }
          default:
            jj_la1[402] = jj_gen;
            ;
          }
          jj_consume_token(INTEGER);
          break;
          }
        default:
          jj_la1[403] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.INTEGER;
        break;
        }
      case FLOAT:{
        jj_consume_token(FLOAT);
typeName = ParserCypherTypeName.FLOAT;
        break;
        }
      case DATE:{
        jj_consume_token(DATE);
typeName = ParserCypherTypeName.DATE;
        break;
        }
      case LOCAL:{
        jj_consume_token(LOCAL);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIME:{
          jj_consume_token(TIME);
typeName = ParserCypherTypeName.LOCAL_TIME;
          break;
          }
        case DATETIME:{
          jj_consume_token(DATETIME);
typeName = ParserCypherTypeName.LOCAL_DATETIME;
          break;
          }
        default:
          jj_la1[404] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case ZONED:{
        jj_consume_token(ZONED);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIME:{
          jj_consume_token(TIME);
typeName = ParserCypherTypeName.ZONED_TIME;
          break;
          }
        case DATETIME:{
          jj_consume_token(DATETIME);
typeName = ParserCypherTypeName.ZONED_DATETIME;
          break;
          }
        default:
          jj_la1[405] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case TIME:{
        jj_consume_token(TIME);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case WITHOUT:{
          jj_consume_token(WITHOUT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMEZONE:{
            jj_consume_token(TIMEZONE);
            break;
            }
          case TIME:{
            jj_consume_token(TIME);
            jj_consume_token(ZONE);
            break;
            }
          default:
            jj_la1[406] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.LOCAL_TIME;
          break;
          }
        case WITH:{
          jj_consume_token(WITH);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMEZONE:{
            jj_consume_token(TIMEZONE);
            break;
            }
          case TIME:{
            jj_consume_token(TIME);
            jj_consume_token(ZONE);
            break;
            }
          default:
            jj_la1[407] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.ZONED_TIME;
          break;
          }
        default:
          jj_la1[408] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case TIMESTAMP:{
        jj_consume_token(TIMESTAMP);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case WITHOUT:{
          jj_consume_token(WITHOUT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMEZONE:{
            jj_consume_token(TIMEZONE);
            break;
            }
          case TIME:{
            jj_consume_token(TIME);
            jj_consume_token(ZONE);
            break;
            }
          default:
            jj_la1[409] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.LOCAL_DATETIME;
          break;
          }
        case WITH:{
          jj_consume_token(WITH);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMEZONE:{
            jj_consume_token(TIMEZONE);
            break;
            }
          case TIME:{
            jj_consume_token(TIME);
            jj_consume_token(ZONE);
            break;
            }
          default:
            jj_la1[410] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.ZONED_DATETIME;
          break;
          }
        default:
          jj_la1[411] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case DURATION:{
        jj_consume_token(DURATION);
typeName = ParserCypherTypeName.DURATION;
        break;
        }
      case POINT:{
        jj_consume_token(POINT);
typeName = ParserCypherTypeName.POINT;
        break;
        }
      case NODE:
      case VERTEX:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NODE:{
          jj_consume_token(NODE);
          break;
          }
        case VERTEX:{
          jj_consume_token(VERTEX);
          break;
          }
        default:
          jj_la1[412] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.NODE;
        break;
        }
      case EDGE:
      case RELATIONSHIP:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RELATIONSHIP:{
          jj_consume_token(RELATIONSHIP);
          break;
          }
        case EDGE:{
          jj_consume_token(EDGE);
          break;
          }
        default:
          jj_la1[413] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.RELATIONSHIP;
        break;
        }
      case MAP:{
        jj_consume_token(MAP);
typeName = ParserCypherTypeName.MAP;
        break;
        }
      case ARRAY:
      case LIST:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LIST:{
          jj_consume_token(LIST);
          break;
          }
        case ARRAY:{
          jj_consume_token(ARRAY);
          break;
          }
        default:
          jj_la1[414] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LT);
        innerType = cypherTypeName();
        jj_consume_token(GT);
typeName = ParserCypherTypeName.listOf(innerType);
        break;
        }
      case PATH:{
        jj_consume_token(PATH);
typeName = ParserCypherTypeName.PATH;
        break;
        }
      case PROPERTY:{
        jj_consume_token(PROPERTY);
        jj_consume_token(VALUE);
typeName = ParserCypherTypeName.PROPERTY_VALUE;
        break;
        }
      case ANY:{
        jj_consume_token(ANY);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NODE:
        case VERTEX:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NODE:{
            jj_consume_token(NODE);
            break;
            }
          case VERTEX:{
            jj_consume_token(VERTEX);
            break;
            }
          default:
            jj_la1[415] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.NODE;
          break;
          }
        case EDGE:
        case RELATIONSHIP:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case RELATIONSHIP:{
            jj_consume_token(RELATIONSHIP);
            break;
            }
          case EDGE:{
            jj_consume_token(EDGE);
            break;
            }
          default:
            jj_la1[416] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName = ParserCypherTypeName.RELATIONSHIP;
          break;
          }
        case MAP:{
          jj_consume_token(MAP);
typeName = ParserCypherTypeName.MAP;
          break;
          }
        case PROPERTY:{
          jj_consume_token(PROPERTY);
          jj_consume_token(VALUE);
typeName = ParserCypherTypeName.PROPERTY_VALUE;
          break;
          }
        default:
          jj_la1[419] = jj_gen;
          if (jj_2_162(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case VALUE:{
              jj_consume_token(VALUE);
              break;
              }
            default:
              jj_la1[417] = jj_gen;
              ;
            }
            jj_consume_token(LT);
            unionTypeList = cypherTypeNameList();
            jj_consume_token(GT);
typeName = ParserCypherTypeName.closedDynamicUnionOf(unionTypeList);
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case VALUE:{
              jj_consume_token(VALUE);
              break;
              }
            default:
              jj_la1[418] = jj_gen;
              ;
            }
typeName = ParserCypherTypeName.ANY;
          }
        }
        break;
        }
      default:
        jj_la1[420] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXCLAMATION_MARK:
      case NOT:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NOT:{
          jj_consume_token(NOT);
          jj_consume_token(NULL);
          break;
          }
        case EXCLAMATION_MARK:{
          jj_consume_token(EXCLAMATION_MARK);
          break;
          }
        default:
          jj_la1[421] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName =  ParserCypherTypeName.getNotNullTypeName(typeName);
        break;
        }
      default:
        jj_la1[422] = jj_gen;
        ;
      }
      label_62:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ARRAY:
        case LIST:{
          break;
          }
        default:
          jj_la1[423] = jj_gen;
          break label_62;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LIST:{
          jj_consume_token(LIST);
          break;
          }
        case ARRAY:{
          jj_consume_token(ARRAY);
          break;
          }
        default:
          jj_la1[424] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
typeName = ParserCypherTypeName.listOf(typeName);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case EXCLAMATION_MARK:
        case NOT:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NOT:{
            jj_consume_token(NOT);
            jj_consume_token(NULL);
            break;
            }
          case EXCLAMATION_MARK:{
            jj_consume_token(EXCLAMATION_MARK);
            break;
            }
          default:
            jj_la1[425] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
typeName =  ParserCypherTypeName.getNotNullTypeName(typeName);
          break;
          }
        default:
          jj_la1[426] = jj_gen;
          ;
        }
      }
    } catch (IllegalArgumentException e) {
// This is thrown if the getNotNullTypeName errors, it will error on Open Dynamic Union Types.
        t = t.next;
        throw exceptionFactory.syntaxException(e, t.beginOffset, t.beginLine, t.beginColumn);
    }
t = t.next;
        {if ("" != null) return typeName.withPos(t.beginOffset, t.beginLine, t.beginColumn);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND DropConstraint(Token start) throws ParseException, Exception {SimpleEither<StringPos<POS>, PARAMETER> name = null;
        boolean ifExists = false;
        VARIABLE variable = null;
        Token label = null;
        List<PROPERTY> properties= new ArrayList<>();
        ConstraintType constraintType = ConstraintType.NODE_EXISTS;
        boolean isNode = false;
        Token errorStart;
    jj_consume_token(CONSTRAINT);
    if (jj_2_164(2147483647)) {
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        //(n:LABEL)
                    variable = Variable();
        label = LabelOrRelType();
        jj_consume_token(RPAREN);
isNode = true;
        break;
        }
      case RPAREN:{
        jj_consume_token(RPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LT:
        case ARROW_LEFT_HEAD:{
          LeftArrow();
          break;
          }
        default:
          jj_la1[427] = jj_gen;
          ;
        }
        ArrowLine();
        jj_consume_token(LBRACKET);
        variable = Variable();
        label = LabelOrRelType();
        jj_consume_token(RBRACKET);
        ArrowLine();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case GT:
        case ARROW_RIGHT_HEAD:{
          RightArrow();
          break;
          }
        default:
          jj_la1[428] = jj_gen;
          ;
        }
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[429] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ASSERT);
      if (jj_2_163(2147483647)) {
        errorStart = jj_consume_token(EXISTS);
constraintType = isNode ? ConstraintType.NODE_EXISTS : ConstraintType.REL_EXISTS;
        properties = PropertyList();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case LPAREN:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          properties = PropertyList();
          errorStart = jj_consume_token(IS);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case UNIQUE:{
            jj_consume_token(UNIQUE);
constraintType = ConstraintType.NODE_UNIQUE;
                          if ( !isNode )
                          {
                              throw exceptionFactory.syntaxException(
                                  new ParseException( ASTExceptionFactory.relationshipPatternNotAllowed( constraintType ) ),
                                  errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                          }
            break;
            }
          case NODE:{
            jj_consume_token(NODE);
            jj_consume_token(KEY);
constraintType = ConstraintType.NODE_KEY ;
                          if ( !isNode )
                          {
                              throw exceptionFactory.syntaxException(
                                  new ParseException( ASTExceptionFactory.relationshipPatternNotAllowed( constraintType ) ),
                                  errorStart.beginOffset, errorStart.beginLine, errorStart.beginColumn );
                          }
            break;
            }
          case NOT:{
            jj_consume_token(NOT);
            jj_consume_token(NULL);
constraintType = isNode ? ConstraintType.NODE_IS_NOT_NULL : ConstraintType.REL_IS_NOT_NULL;
            break;
            }
          default:
            jj_la1[430] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[431] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
throw exceptionFactory.syntaxException(
                                              new ParseException( ASTExceptionFactory.invalidDropConstraint( constraintType, properties.size() > 1 ) ),
                                              start.beginOffset, start.beginLine, start.beginColumn );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        //DROP CONSTRAINT name IF EXISTS
                name = SymbolicNameOrStringParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(EXISTS);
ifExists = true;
          break;
          }
        default:
          jj_la1[432] = jj_gen;
          ;
        }
{if ("" != null) return astFactory.dropConstraint( pos( start ), name, ifExists );}
        break;
        }
      default:
        jj_la1[433] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// Index commands
  final public 
SCHEMA_COMMAND CreateIndex(Token start, boolean replace) throws ParseException, Exception {SCHEMA_COMMAND command = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BTREE:{
      jj_consume_token(BTREE);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.BTREE);
      break;
      }
    case RANGE:{
      jj_consume_token(RANGE);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.RANGE);
      break;
      }
    case FULLTEXT:{
      jj_consume_token(FULLTEXT);
      jj_consume_token(INDEX);
      command = createFulltextIndex(start, replace);
      break;
      }
    case TEXT:{
      jj_consume_token(TEXT);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.TEXT);
      break;
      }
    case POINT:{
      jj_consume_token(POINT);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.POINT);
      break;
      }
    case VECTOR:{
      jj_consume_token(VECTOR);
      jj_consume_token(INDEX);
      command = createIndex(start, replace, CreateIndexTypes.VECTOR);
      break;
      }
    case LOOKUP:{
      jj_consume_token(LOOKUP);
      jj_consume_token(INDEX);
      command = createLookupIndex(start, replace);
      break;
      }
    case INDEX:{
      jj_consume_token(INDEX);
      if (jj_2_165(2147483647)) {
        jj_consume_token(ON);
        oldCreateIndex(start, replace);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          command = createIndex(start, replace, CreateIndexTypes.DEFAULT);
          break;
          }
        default:
          jj_la1[434] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[435] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return command;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void oldCreateIndex(Token start, boolean replace) throws ParseException, Exception {Token nodeLabel;
    List<StringPos<POS>> properties;
    //CREATE INDEX ON :nodeLabel(prop1, prop2)
        nodeLabel = LabelOrRelType();
    jj_consume_token(LPAREN);
    properties = SymbolicNamePositions();
    jj_consume_token(RPAREN);
if (replace) {
            throw exceptionFactory.syntaxException( new ParseException("'REPLACE' is not allowed for this index syntax"), start.beginOffset, start.beginLine, start.beginColumn );
        }
        throw exceptionFactory.syntaxException( new ParseException("Invalid create index syntax, use `CREATE INDEX FOR ...` instead."), start.beginOffset, start.beginLine, start.beginColumn );
}

  final public SCHEMA_COMMAND createIndex(Token start, boolean replace, CreateIndexTypes indexType) throws ParseException, Exception {boolean ifNotExists = false;
    boolean isNode = false;
    SimpleEither<StringPos<POS>, PARAMETER> indexName = null;
    VARIABLE variable = null;
    Token label = null;
    List<PROPERTY> properties= new ArrayList<>();
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_166(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_167(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        indexName = SymbolicNameOrStringParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[436] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[437] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      //(n:LABEL)
              variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[438] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      label = LabelOrRelType();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[439] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[440] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    properties = PropertyList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[441] = jj_gen;
      ;
    }
if (indexType == CreateIndexTypes.BTREE ) {
            throw exceptionFactory.syntaxException(
                new ParseException(ASTExceptionFactory.getInvalidCreateBtreeIndexes),
                start.beginOffset, start.beginLine, start.beginColumn );
        }

        {if ("" != null) return astFactory.createIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, new StringPos<>(label.image, pos(label)), properties, options, indexType );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND createFulltextIndex(Token start, boolean replace) throws ParseException, Exception {boolean ifNotExists = false;
    boolean isNode = false;
    SimpleEither<StringPos<POS>, PARAMETER> indexName = null;
    VARIABLE variable = null;
    VARIABLE propName = null;
    PROPERTY p = null;
    List<StringPos<POS>> labels = new ArrayList<>();
    List<PROPERTY> properties= new ArrayList<>();
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_168(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_169(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        indexName = SymbolicNameOrStringParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[442] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[443] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      //(v:L1 | ... | Ln)
                  variable = Variable();
      labels = LabelOrRelTypes();
      jj_consume_token(RPAREN);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[444] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      labels = LabelOrRelTypes();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[445] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[446] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(EACH);
    jj_consume_token(LBRACKET);
    propName = Variable();
    p = Property(propName);
properties.add( p );
    label_63:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[447] = jj_gen;
        break label_63;
      }
      jj_consume_token(COMMA);
      propName = Variable();
      p = Property(propName);
properties.add( p );
    }
    jj_consume_token(RBRACKET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[448] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createFulltextIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, labels, properties, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND createLookupIndex(Token start, boolean replace) throws ParseException, Exception {boolean ifNotExists = false;
    boolean isNode = false;
    SimpleEither<StringPos<POS>, PARAMETER> indexName = null;
    VARIABLE variable = null;
    StringPos<POS> funcName = null;
    VARIABLE funcParam = variable;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    if (jj_2_170(2147483647)) {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else if (jj_2_171(2147483647)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        indexName = SymbolicNameOrStringParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(NOT);
          jj_consume_token(EXISTS);
ifNotExists = true;
          break;
          }
        default:
          jj_la1[449] = jj_gen;
          ;
        }
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        break;
        }
      default:
        jj_la1[450] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      //(v)
              variable = Variable();
      jj_consume_token(RPAREN);
      jj_consume_token(ON);
      jj_consume_token(EACH);
isNode = true;
      break;
      }
    case RPAREN:{
      jj_consume_token(RPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LT:
      case ARROW_LEFT_HEAD:{
        LeftArrow();
        break;
        }
      default:
        jj_la1[451] = jj_gen;
        ;
      }
      ArrowLine();
      jj_consume_token(LBRACKET);
      variable = Variable();
      jj_consume_token(RBRACKET);
      ArrowLine();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GT:
      case ARROW_RIGHT_HEAD:{
        RightArrow();
        break;
        }
      default:
        jj_la1[452] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      jj_consume_token(ON);
      if (jj_2_172(2147483647)) {
        jj_consume_token(EACH);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[453] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    SymbolicNameString();
funcName = new StringPos<POS>( token.image, pos(token) );
    jj_consume_token(LPAREN);
    funcParam = Variable();
    jj_consume_token(RPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      jj_consume_token(OPTIONS);
      options = MapOrParameter();
      break;
      }
    default:
      jj_la1[454] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createLookupIndex( pos(start), replace, ifNotExists, isNode, indexName, variable, funcName, funcParam, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SCHEMA_COMMAND DropIndex(Token start) throws ParseException, Exception {Token nodeLabel;
    List<StringPos<POS>> properties;
    SimpleEither<StringPos<POS>, PARAMETER> name;
    boolean ifExists = false;
    jj_consume_token(INDEX);
    if (jj_2_173(2)) {
      jj_consume_token(ON);
      nodeLabel = LabelOrRelType();
      jj_consume_token(LPAREN);
      properties = SymbolicNamePositions();
      jj_consume_token(RPAREN);
throw exceptionFactory.syntaxException( new ParseException("Indexes cannot be dropped by schema, please drop by name instead: DROP INDEX index_name. The index name can be found using SHOW INDEXES."), start.beginOffset, start.beginLine, start.beginColumn );
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        name = SymbolicNameOrStringParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IF:{
          jj_consume_token(IF);
          jj_consume_token(EXISTS);
ifExists = true;
          break;
          }
        default:
          jj_la1[455] = jj_gen;
          ;
        }
{if ("" != null) return astFactory.dropIndex( pos(start), name, ifExists );}
        break;
        }
      default:
        jj_la1[456] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PROPERTY> PropertyList() throws ParseException {VARIABLE variable;
    PROPERTY p;
    List<PROPERTY> properties= new ArrayList<>();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      variable = Variable();
      p = Property(variable);
properties.add( p );
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      variable = Variable();
      p = Property(variable);
properties.add( p );
      label_64:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[457] = jj_gen;
          break label_64;
        }
        jj_consume_token(COMMA);
        variable = Variable();
        p = Property(variable);
properties.add( p );
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[458] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return properties;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Administration Commands
  final public 
ADMINISTRATION_COMMAND RenameCommand() throws ParseException {Token start;
    ADMINISTRATION_COMMAND command;
    start = jj_consume_token(RENAME);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ROLE:{
      command = RenameRole(start);
      break;
      }
    case USER:{
      command = RenameUser(start);
      break;
      }
    case SERVER:{
      command = RenameServer(start);
      break;
      }
    default:
      jj_la1[459] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return command;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND GrantCommand() throws ParseException, Exception {Token start;
    ADMINISTRATION_COMMAND c;
    boolean immutable = false;
    start = jj_consume_token(GRANT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IMMUTABLE:{
      jj_consume_token(IMMUTABLE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = grantPrivilege(start, true);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = grantRoleManagement(start, true);
        break;
        }
      default:
        jj_la1[460] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case COMPOSITE:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case EXECUTE:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case LOAD:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case ROLE:
    case ROLES:
    case SERVER:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = grantPrivilege(start, false);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        if (jj_2_174(2147483647)) {
          c = grantRoleManagement(start, false);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            c = GrantRole(start);
            break;
            }
          default:
            jj_la1[461] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case ROLES:{
        jj_consume_token(ROLES);
        c = GrantRole(start);
        break;
        }
      default:
        jj_la1[462] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[463] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokeCommand() throws ParseException, Exception {Token start;
    ADMINISTRATION_COMMAND c;
    boolean immutable = false;
    start = jj_consume_token(REVOKE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DENY:{
      jj_consume_token(DENY);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IMMUTABLE:{
        jj_consume_token(IMMUTABLE);
immutable = true;
        break;
        }
      default:
        jj_la1[464] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, false, true, immutable);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = revokeRoleManagement(start, false, true, immutable);
        break;
        }
      default:
        jj_la1[465] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case GRANT:{
      jj_consume_token(GRANT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IMMUTABLE:{
        jj_consume_token(IMMUTABLE);
immutable = true;
        break;
        }
      default:
        jj_la1[466] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, true, false, immutable);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = revokeRoleManagement(start, true, false, immutable);
        break;
        }
      default:
        jj_la1[467] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case IMMUTABLE:{
      jj_consume_token(IMMUTABLE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, true, true, true);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        c = revokeRoleManagement(start, true, true, true);
        break;
        }
      default:
        jj_la1[468] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case COMPOSITE:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case EXECUTE:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case LOAD:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case ROLE:
    case ROLES:
    case SERVER:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ALIAS:
      case ALL:
      case ALTER:
      case ASSIGN:
      case COMPOSITE:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CREATE:
      case DATABASE:
      case DELETE:
      case DROP:
      case EXECUTE:
      case IMPERSONATE:
      case INDEX:
      case INDEXES:
      case LOAD:
      case MATCH:
      case MERGE:
      case NAME:
      case PRIVILEGE:
      case READ:
      case RENAME:
      case REMOVE:
      case SERVER:
      case SET:
      case SHOW:
      case START:
      case STOP:
      case TERMINATE:
      case TRANSACTION:
      case TRAVERSE:
      case USER:
      case WRITE:{
        c = RevokePrivilege(start, true, true, false);
        break;
        }
      default:
        jj_la1[470] = jj_gen;
        if (jj_2_175(2147483647)) {
          jj_consume_token(ROLE);
          c = revokeRoleManagement(start, true, true, false);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ROLE:
          case ROLES:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case ROLE:{
              jj_consume_token(ROLE);
              break;
              }
            case ROLES:{
              jj_consume_token(ROLES);
              break;
              }
            default:
              jj_la1[469] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            c = RevokeRole(start);
            break;
            }
          default:
            jj_la1[471] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      break;
      }
    default:
      jj_la1[472] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Server commands
  final public 
ADMINISTRATION_COMMAND EnableServerCommand() throws ParseException, Exception {Token start;
    SimpleEither<String, PARAMETER> serverName = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    start = jj_consume_token(ENABLE);
    jj_consume_token(SERVER);
    serverName = StringOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      options = Options();
      break;
      }
    default:
      jj_la1[473] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.enableServer( pos( start ), serverName, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterServer(Token start) throws ParseException, Exception {SimpleEither<String, PARAMETER> serverName = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    jj_consume_token(SERVER);
    serverName = StringOrParameter();
    jj_consume_token(SET);
    options = Options();
{if ("" != null) return astFactory.alterServer( pos( start ), serverName, options );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RenameServer(Token start) throws ParseException {SimpleEither<String, PARAMETER> serverName = null;
    SimpleEither<String, PARAMETER> newName = null;
    jj_consume_token(SERVER);
    serverName = StringOrParameter();
    jj_consume_token(TO);
    newName = StringOrParameter();
{if ("" != null) return astFactory.renameServer( pos( start ), serverName, newName );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropServer(Token start) throws ParseException {SimpleEither<String, PARAMETER> serverName = null;
    jj_consume_token(SERVER);
    serverName = StringOrParameter();
{if ("" != null) return astFactory.dropServer( pos( start ), serverName );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowServers(Token start, USE_CLAUSE useClause) throws ParseException, Exception {YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SERVERS:{
      jj_consume_token(SERVERS);
      break;
      }
    case SERVER:{
      jj_consume_token(SERVER);
      break;
      }
    default:
      jj_la1[474] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[475] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[476] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[477] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showServers( pos( start ), yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AllocationCommand() throws ParseException {boolean dryRun = false;
    ADMINISTRATION_COMMAND s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DRYRUN:{
      jj_consume_token(DRYRUN);
dryRun = true;
      break;
      }
    default:
      jj_la1[478] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DEALLOCATE:{
      s = DeallocateDatabaseFromServers(dryRun);
      break;
      }
    case REALLOCATE:{
      s = ReallocateDatabases(dryRun);
      break;
      }
    default:
      jj_la1[479] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DeallocateDatabaseFromServers(boolean dryRun) throws ParseException {Token start;
    List<SimpleEither<String, PARAMETER>> serverNames = new ArrayList<>();
    SimpleEither<String, PARAMETER> entry;
    start = jj_consume_token(DEALLOCATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      jj_consume_token(DATABASES);
      break;
      }
    default:
      jj_la1[480] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(FROM);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SERVER:{
      jj_consume_token(SERVER);
      break;
      }
    case SERVERS:{
      jj_consume_token(SERVERS);
      break;
      }
    default:
      jj_la1[481] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    entry = StringOrParameter();
serverNames.add( entry );
    label_65:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[482] = jj_gen;
        break label_65;
      }
      jj_consume_token(COMMA);
      entry = StringOrParameter();
serverNames.add( entry );
    }
{if ("" != null) return astFactory.deallocateServers( pos( start ), dryRun, serverNames );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND ReallocateDatabases(boolean dryRun) throws ParseException {Token start;
    start = jj_consume_token(REALLOCATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      jj_consume_token(DATABASES);
      break;
      }
    default:
      jj_la1[483] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.reallocateDatabases( pos( start ), dryRun );}
    throw new IllegalStateException ("Missing return statement in function");
}

// Role commands
  final public 
ADMINISTRATION_COMMAND CreateRole(Token start, boolean replace) throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> roleName = null;
    SimpleEither<StringPos<POS>, PARAMETER> sourceRoleName = null;
    boolean ifNotExists = false;
    jj_consume_token(ROLE);
    roleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[484] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      jj_consume_token(COPY);
      jj_consume_token(OF);
      sourceRoleName = SymbolicNameOrStringParameter();
      break;
      }
    default:
      jj_la1[485] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createRole( pos( start ), replace, roleName, sourceRoleName, ifNotExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropRole(Token start) throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> roleName = null;
    boolean ifExists = false;
    jj_consume_token(ROLE);
    roleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[486] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropRole( pos( start ), roleName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RenameRole(Token start) throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> fromRoleName = null;
    SimpleEither<StringPos<POS>, PARAMETER> toRoleName = null;
    boolean ifExists = false;
    jj_consume_token(ROLE);
    fromRoleName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[487] = jj_gen;
      ;
    }
    jj_consume_token(TO);
    toRoleName = SymbolicNameOrStringParameter();
{if ("" != null) return astFactory.renameRole( pos( start ), fromRoleName, toRoleName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowRoles(Token start, USE_CLAUSE useClause, boolean showAll) throws ParseException, Exception {boolean withUsers = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USERS:{
        jj_consume_token(USERS);
        break;
        }
      case USER:{
        jj_consume_token(USER);
        break;
        }
      default:
        jj_la1[488] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
withUsers = true;
      break;
      }
    default:
      jj_la1[489] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[490] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[491] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[492] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showRoles( pos( start ), withUsers, showAll, yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND GrantRole(Token start) throws ParseException {List<SimpleEither<StringPos<POS>, PARAMETER>> roles;
    List<SimpleEither<StringPos<POS>, PARAMETER>> users;
    roles = SymbolicNameOrStringParameterList();
    jj_consume_token(TO);
    users = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantRoles( pos( start ), roles, users );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokeRole(Token start) throws ParseException {List<SimpleEither<StringPos<POS>, PARAMETER>> roles;
    List<SimpleEither<StringPos<POS>, PARAMETER>> users;
    roles = SymbolicNameOrStringParameterList();
    jj_consume_token(FROM);
    users = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokeRoles( pos( start ), roles, users );}
    throw new IllegalStateException ("Missing return statement in function");
}

// User commands
  final public 
ADMINISTRATION_COMMAND CreateUser(Token start, boolean replace) throws ParseException, Exception {Token token = null;
    SimpleEither<StringPos<POS>, PARAMETER> username = null;
    boolean ifNotExists = false;
    Optional<Boolean> suspended = Optional.empty();
    Optional<DATABASE_NAME> homeDatabase = Optional.empty();
    AUTH auth = null;
    List<AUTH> auths = new ArrayList<>();
    List<AUTH_ATTRIBUTE> systemAuthAttributes = new ArrayList<>();
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[493] = jj_gen;
      ;
    }
    label_66:
    while (true) {
      token = jj_consume_token(SET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLAINTEXT:{
        token = jj_consume_token(PLAINTEXT);
        jj_consume_token(PASSWORD);
        SetPassword(token, systemAuthAttributes, false);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        default:
          jj_la1[494] = jj_gen;
          ;
        }
        break;
        }
      case ENCRYPTED:{
        token = jj_consume_token(ENCRYPTED);
        jj_consume_token(PASSWORD);
        SetPassword(token, systemAuthAttributes, true);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        default:
          jj_la1[495] = jj_gen;
          ;
        }
        break;
        }
      case PASSWORD:{
        token = jj_consume_token(PASSWORD);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case DOLLAR:{
          SetPassword(token, systemAuthAttributes, false);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CHANGE:{
            PasswordChangeRequired(systemAuthAttributes);
            break;
            }
          default:
            jj_la1[496] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[497] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case STATUS:{
        suspended = UserStatus(token, suspended);
        break;
        }
      case HOME:{
        homeDatabase = HomeDatabase(token, homeDatabase);
        break;
        }
      case AUTH:{
        auth = UserAuthObjects();
auths.add(auth);
        break;
        }
      default:
        jj_la1[498] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SET:{
        break;
        }
      default:
        jj_la1[499] = jj_gen;
        break label_66;
      }
    }
{if ("" != null) return astFactory.createUser( pos( start ), replace, ifNotExists, username,
                                      suspended.orElse( null ), homeDatabase.orElse( null ),
                                      auths, systemAuthAttributes );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropUser(Token start) throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> username = null;
    boolean ifExists = false;
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[500] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropUser( pos( start ), ifExists, username );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RenameUser(Token start) throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> fromUserName = null;
    SimpleEither<StringPos<POS>, PARAMETER> toUserName = null;
    boolean ifExists = false;
    jj_consume_token(USER);
    fromUserName = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[501] = jj_gen;
      ;
    }
    jj_consume_token(TO);
    toUserName = SymbolicNameOrStringParameter();
{if ("" != null) return astFactory.renameUser( pos( start ), fromUserName, toUserName, ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterCurrentUser(Token start) throws ParseException, Exception {EXPRESSION currentPassword = null;
    EXPRESSION newPassword = null;
    jj_consume_token(CURRENT);
    jj_consume_token(USER);
    jj_consume_token(SET);
    jj_consume_token(PASSWORD);
    jj_consume_token(FROM);
    currentPassword = passwordExpression();
    jj_consume_token(TO);
    newPassword = passwordExpression();
{if ("" != null) return astFactory.setOwnPassword( pos( start ), currentPassword, newPassword);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterUser(Token start) throws ParseException, Exception {Token token = null;
    Token token2 = null;
    SimpleEither<StringPos<POS>, PARAMETER> username = null;
    boolean ifExists = false;
    Optional<Boolean> suspended = Optional.empty();
    Optional<DATABASE_NAME> homeDatabase = Optional.empty();
    boolean removeHome = false;
    boolean removeAllAuth = false;
    EXPRESSION provider = null;
    List<EXPRESSION> removeAuths = new ArrayList<>();
    AUTH auth = null;
    List<AUTH> auths = new ArrayList<>();
    List<AUTH_ATTRIBUTE> systemAuthAttributes = new ArrayList<>();
    jj_consume_token(USER);
    username = SymbolicNameOrStringParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[502] = jj_gen;
      ;
    }
    label_67:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REMOVE:{
        break;
        }
      default:
        jj_la1[503] = jj_gen;
        break label_67;
      }
      token = jj_consume_token(REMOVE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case HOME:{
        jj_consume_token(HOME);
        jj_consume_token(DATABASE);
removeHome = true;
        break;
        }
      case ALL:{
        jj_consume_token(ALL);
        jj_consume_token(AUTH);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PROVIDER:
        case PROVIDERS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PROVIDER:{
            jj_consume_token(PROVIDER);
            break;
            }
          case PROVIDERS:{
            jj_consume_token(PROVIDERS);
            break;
            }
          default:
            jj_la1[504] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[505] = jj_gen;
          ;
        }
removeAllAuth = true;
        break;
        }
      case AUTH:{
        jj_consume_token(AUTH);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PROVIDER:
        case PROVIDERS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PROVIDER:{
            jj_consume_token(PROVIDER);
            break;
            }
          case PROVIDERS:{
            jj_consume_token(PROVIDERS);
            break;
            }
          default:
            jj_la1[506] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[507] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING_LITERAL1:
        case STRING_LITERAL2:{
          provider = StringLiteral();
          break;
          }
        case DOLLAR:{
          provider = Parameter(ParameterType.ANY);
          break;
          }
        case LBRACKET:{
          provider = StringListLiteral();
          break;
          }
        default:
          jj_la1[508] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
removeAuths.add(provider);
        break;
        }
      default:
        jj_la1[509] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_68:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SET:{
        break;
        }
      default:
        jj_la1[510] = jj_gen;
        break label_68;
      }
      token = jj_consume_token(SET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLAINTEXT:{
        token2 = jj_consume_token(PLAINTEXT);
        jj_consume_token(PASSWORD);
        SetPassword(token2, systemAuthAttributes, false);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        default:
          jj_la1[511] = jj_gen;
          ;
        }
        break;
        }
      case ENCRYPTED:{
        token2 = jj_consume_token(ENCRYPTED);
        jj_consume_token(PASSWORD);
        SetPassword(token2, systemAuthAttributes, true);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        default:
          jj_la1[512] = jj_gen;
          ;
        }
        break;
        }
      case PASSWORD:{
        token2 = jj_consume_token(PASSWORD);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(systemAuthAttributes);
          break;
          }
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case DOLLAR:{
          SetPassword(token2, systemAuthAttributes, false);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case CHANGE:{
            PasswordChangeRequired(systemAuthAttributes);
            break;
            }
          default:
            jj_la1[513] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[514] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case STATUS:{
        suspended = UserStatus(token, suspended);
        break;
        }
      case HOME:{
        homeDatabase = HomeDatabase(token, homeDatabase);
        break;
        }
      case AUTH:{
        auth = UserAuthObjects();
auths.add(auth);
        break;
        }
      default:
        jj_la1[515] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return astFactory.alterUser( pos( start ), ifExists, username,
            suspended.orElse( null ), homeDatabase.orElse( null ), removeHome,
             auths, systemAuthAttributes, removeAllAuth, removeAuths );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void SetPassword(Token start, List<AUTH_ATTRIBUTE> attributes, boolean encrypted) throws ParseException, Exception {EXPRESSION newPassword = null;
    newPassword = passwordExpression();
attributes.add(astFactory.password(pos(start), newPassword, encrypted));
}

  final public EXPRESSION passwordExpression() throws ParseException {Token name = null;
   PARAMETER parameter = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      name = StringToken();
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
      break;
      }
    default:
      jj_la1[516] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( name != null )
        {
            {if ("" != null) return astFactory.passwordExpression( pos(name), endPos(name), name.image );}
        }
        else
        {
            {if ("" != null) return astFactory.passwordExpression( parameter );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void PasswordChangeRequired(List<AUTH_ATTRIBUTE> attributes) throws ParseException, Exception {boolean required = true;
    Token token = null;
    token = jj_consume_token(CHANGE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
required = false;
      break;
      }
    default:
      jj_la1[517] = jj_gen;
      ;
    }
    jj_consume_token(REQUIRED);
attributes.add(astFactory.passwordChangeRequired( pos(token), required ));
}

  final public Optional<Boolean> UserStatus(Token start, Optional<Boolean> suspended) throws ParseException, Exception {String errorMessage = "Duplicate SET STATUS {SUSPENDED|ACTIVE} clause";
    boolean suspend = false;
    jj_consume_token(STATUS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SUSPENDED:{
      jj_consume_token(SUSPENDED);
suspend = true;
      break;
      }
    case ACTIVE:{
      jj_consume_token(ACTIVE);
suspend = false;
      break;
      }
    default:
      jj_la1[518] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
assertNotAlreadySet( suspended.orElse(null), start, errorMessage );
        {if ("" != null) return Optional.of( suspend );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Optional<DATABASE_NAME> HomeDatabase(Token start, Optional<DATABASE_NAME> homeDatabase) throws ParseException, Exception {String errorMessage = "Duplicate SET HOME DATABASE clause";
    AliasName<DATABASE_NAME, PARAMETER> home = null;
    jj_consume_token(HOME);
    jj_consume_token(DATABASE);
    home = SymbolicAliasNameOrParameter();
assertNotAlreadySet( homeDatabase.orElse(null), start, errorMessage );
        {if ("" != null) return Optional.of( home.getLocalAliasName(astFactory) );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AUTH UserAuthObjects() throws ParseException, Exception {Token start = null;
    Token set = null;
    Token provider = null;
    EXPRESSION password = null;
    boolean changeRequired = true;
    EXPRESSION id = null;
    List<AUTH_ATTRIBUTE> authAttributes = new ArrayList<>();
    start = jj_consume_token(AUTH);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROVIDER:{
      jj_consume_token(PROVIDER);
      break;
      }
    default:
      jj_la1[519] = jj_gen;
      ;
    }
    provider = StringToken();
    jj_consume_token(LCURLY);
    label_69:
    while (true) {
      jj_consume_token(SET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ID:{
        set = jj_consume_token(ID);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING_LITERAL1:
        case STRING_LITERAL2:{
          id = StringLiteral();
          break;
          }
        case DOLLAR:{
          id = Parameter(ParameterType.STRING);
          break;
          }
        default:
          jj_la1[520] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
authAttributes.add(astFactory.authId(pos(set), id));
        break;
        }
      case PLAINTEXT:{
        set = jj_consume_token(PLAINTEXT);
        jj_consume_token(PASSWORD);
        SetPassword(set, authAttributes, false);
        break;
        }
      case ENCRYPTED:{
        set = jj_consume_token(ENCRYPTED);
        jj_consume_token(PASSWORD);
        SetPassword(set, authAttributes, true);
        break;
        }
      case PASSWORD:{
        set = jj_consume_token(PASSWORD);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CHANGE:{
          PasswordChangeRequired(authAttributes);
          break;
          }
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case DOLLAR:{
          SetPassword(set, authAttributes, false);
          break;
          }
        default:
          jj_la1[521] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[522] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SET:{
        break;
        }
      default:
        jj_la1[523] = jj_gen;
        break label_69;
      }
    }
    jj_consume_token(RCURLY);
{if ("" != null) return astFactory.auth(provider.image, authAttributes, pos(start));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowUsers(Token start, USE_CLAUSE useClause) throws ParseException, Exception {boolean withAuth = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      jj_consume_token(AUTH);
withAuth = true;
      break;
      }
    default:
      jj_la1[524] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[525] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[526] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[527] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showUsers( pos( start ), yield, returnClause, where, withAuth ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowCurrentUser(Token start, USE_CLAUSE useClause) throws ParseException, Exception {YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    jj_consume_token(CURRENT);
    jj_consume_token(USER);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[528] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[529] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[530] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showCurrentUser( pos( start ), yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

// Privilege commands
  final public 
STATEMENT_WITH_GRAPH ShowSupportedPrivileges(Token start, USE_CLAUSE useClause) throws ParseException, Exception {YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    jj_consume_token(SUPPORTED);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PRIVILEGE:{
      jj_consume_token(PRIVILEGE);
      break;
      }
    case PRIVILEGES:{
      jj_consume_token(PRIVILEGES);
      break;
      }
    default:
      jj_la1[531] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[532] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[533] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[534] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showSupportedPrivileges( pos( start ), yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowPrivileges(Token start, USE_CLAUSE useClause) throws ParseException, Exception {boolean asCommand = false;
    boolean asRevoke = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PRIVILEGE:{
      jj_consume_token(PRIVILEGE);
      break;
      }
    case PRIVILEGES:{
      jj_consume_token(PRIVILEGES);
      break;
      }
    default:
      jj_la1[535] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REVOKE:{
        jj_consume_token(REVOKE);
asRevoke=true;
        break;
        }
      default:
        jj_la1[536] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMAND:{
        jj_consume_token(COMMAND);
        break;
        }
      case COMMANDS:{
        jj_consume_token(COMMANDS);
        break;
        }
      default:
        jj_la1[537] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
asCommand=true;
      break;
      }
    default:
      jj_la1[538] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[539] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[540] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[541] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showAllPrivileges( pos( start ), asCommand, asRevoke, yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowRolePrivileges(Token start, USE_CLAUSE useClause) throws ParseException, Exception {List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    boolean asCommand = false;
    boolean asRevoke = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    roles = SymbolicNameOrStringParameterList();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PRIVILEGE:{
      jj_consume_token(PRIVILEGE);
      break;
      }
    case PRIVILEGES:{
      jj_consume_token(PRIVILEGES);
      break;
      }
    default:
      jj_la1[542] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REVOKE:{
        jj_consume_token(REVOKE);
asRevoke=true;
        break;
        }
      default:
        jj_la1[543] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMAND:{
        jj_consume_token(COMMAND);
        break;
        }
      case COMMANDS:{
        jj_consume_token(COMMANDS);
        break;
        }
      default:
        jj_la1[544] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
asCommand=true;
      break;
      }
    default:
      jj_la1[545] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[546] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[547] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[548] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showRolePrivileges( pos( start ), roles, asCommand, asRevoke, yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowUserPrivileges(Token start, USE_CLAUSE useClause) throws ParseException, Exception {List<SimpleEither<StringPos<POS>, PARAMETER>> users = null;
    boolean asCommand = false;
    boolean asRevoke = false;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    if (jj_2_176(2147483647)) {
      users = SymbolicNameOrStringParameterList();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
        break;
        }
      case PRIVILEGES:{
        jj_consume_token(PRIVILEGES);
        break;
        }
      default:
        jj_la1[549] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:
      case PRIVILEGES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PRIVILEGE:{
          jj_consume_token(PRIVILEGE);
          break;
          }
        case PRIVILEGES:{
          jj_consume_token(PRIVILEGES);
          break;
          }
        default:
          jj_la1[550] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        users = SymbolicNameOrStringParameterList();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PRIVILEGE:{
          jj_consume_token(PRIVILEGE);
          break;
          }
        case PRIVILEGES:{
          jj_consume_token(PRIVILEGES);
          break;
          }
        default:
          jj_la1[551] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[552] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case REVOKE:{
        jj_consume_token(REVOKE);
asRevoke=true;
        break;
        }
      default:
        jj_la1[553] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMAND:{
        jj_consume_token(COMMAND);
        break;
        }
      case COMMANDS:{
        jj_consume_token(COMMANDS);
        break;
        }
      default:
        jj_la1[554] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
asCommand=true;
      break;
      }
    default:
      jj_la1[555] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yield = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[556] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[557] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[558] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.useGraph( astFactory.showUserPrivileges( pos( start ), users, asCommand, asRevoke, yield, returnClause, where ), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND grantRoleManagement(Token start, boolean immutable) throws ParseException {PRIVILEGE_TYPE privilege = null;
    List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    privilege = roleManagementPrivilege(start, immutable);
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND revokeRoleManagement(Token start, boolean revokeGrant, boolean revokeDeny, boolean immutable) throws ParseException {PRIVILEGE_TYPE privilege = null;
    List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    privilege = roleManagementPrivilege(start, immutable);
    jj_consume_token(FROM);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokePrivilege( pos(start), roles, privilege, revokeGrant, revokeDeny );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE roleManagementPrivilege(Token start, boolean immutable) throws ParseException {List<SimpleEither<String, PARAMETER>> roles = null;
    jj_consume_token(MANAGEMENT);
    jj_consume_token(ON);
    jj_consume_token(DBMS);
{if ("" != null) return astFactory.dbmsPrivilege( pos(start), astFactory.privilegeAction( ActionType.ROLE_ALL ), astFactory.allQualifier(), immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND grantPrivilege(Token start, boolean immutable) throws ParseException, Exception {List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    privilege = privilege(start, immutable);
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.grantPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DenyPrivilege() throws ParseException, Exception {Token start;
    List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    boolean immutable = false;
    start = jj_consume_token(DENY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IMMUTABLE:{
      jj_consume_token(IMMUTABLE);
immutable = true;
      break;
      }
    default:
      jj_la1[559] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:
    case ALIAS:
    case ALL:
    case ALTER:
    case ASSIGN:
    case COMPOSITE:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CREATE:
    case DATABASE:
    case DELETE:
    case DROP:
    case EXECUTE:
    case IMPERSONATE:
    case INDEX:
    case INDEXES:
    case LOAD:
    case MATCH:
    case MERGE:
    case NAME:
    case PRIVILEGE:
    case READ:
    case RENAME:
    case REMOVE:
    case SERVER:
    case SET:
    case SHOW:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:
    case TRAVERSE:
    case USER:
    case WRITE:{
      privilege = privilege(start, immutable);
      break;
      }
    case ROLE:{
      jj_consume_token(ROLE);
      privilege = roleManagementPrivilege(start, immutable);
      break;
      }
    default:
      jj_la1[560] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(TO);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.denyPrivilege( pos(start), roles, privilege );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND RevokePrivilege(Token start, boolean revokeGrant, boolean revokeDeny, boolean immutable) throws ParseException, Exception {List<SimpleEither<StringPos<POS>, PARAMETER>> roles = null;
    PRIVILEGE_TYPE privilege = null;
    privilege = privilege(start, immutable);
    jj_consume_token(FROM);
    roles = SymbolicNameOrStringParameterList();
{if ("" != null) return astFactory.revokePrivilege( pos(start), roles, privilege, revokeGrant, revokeDeny );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE privilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      privilege = allPrivilege(start, immutable);
      break;
      }
    case CREATE:{
      privilege = createPrivilege(start, immutable);
      break;
      }
    case DROP:{
      privilege = dropPrivilege(start, immutable);
      break;
      }
    case SHOW:{
      privilege = showPrivilege(start, immutable);
      break;
      }
    case LOAD:{
      privilege = loadPrivilege(start, immutable);
      break;
      }
    case SET:{
      privilege = setPrivilege(start, immutable);
      break;
      }
    case REMOVE:{
      privilege = removePrivilege(start, immutable);
      break;
      }
    case ACCESS:
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case NAME:
    case START:
    case STOP:
    case TERMINATE:
    case TRANSACTION:{
      privilege = databasePrivilege(start, immutable);
      break;
      }
    case ALIAS:
    case ALTER:
    case ASSIGN:
    case COMPOSITE:
    case DATABASE:
    case EXECUTE:
    case IMPERSONATE:
    case PRIVILEGE:
    case RENAME:
    case SERVER:
    case USER:{
      privilege = dbmsPrivilege(start, immutable);
      break;
      }
    case WRITE:{
      privilege = writePrivilege(start, immutable);
      break;
      }
    case DELETE:
    case MERGE:{
      privilege = qualifiedGraphPrivileges(start, immutable);
      break;
      }
    case MATCH:
    case READ:
    case TRAVERSE:{
      privilege = qualifiedGraphPrivilegesWithProperty(start, immutable);
      break;
      }
    default:
      jj_la1[561] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE allPrivilege(Token start, boolean immutable) throws ParseException, Exception {ADMINISTRATION_ACTION action = null;
    List<DATABASE_NAME> names = null;
    boolean isAll = false;
    String type = null;
    Token t = null;
    ScopeType scopeType = ScopeType.NAMED;
    ActionType actionType = null;
    boolean usingDefault = false;
    jj_consume_token(ALL);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case DBMS:
    case GRAPH:
    case PRIVILEGES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:
      case DBMS:
      case GRAPH:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DBMS:{
          jj_consume_token(DBMS);
type = "DBMS";
          break;
          }
        case GRAPH:{
          jj_consume_token(GRAPH);
type = "GRAPH";
          break;
          }
        case DATABASE:{
          jj_consume_token(DATABASE);
type = "DATABASE";
          break;
          }
        default:
          jj_la1[562] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[563] = jj_gen;
        ;
      }
      jj_consume_token(PRIVILEGES);
      break;
      }
    default:
      jj_la1[564] = jj_gen;
      ;
    }
    jj_consume_token(ON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DEFAULT_TOKEN:{
      t = jj_consume_token(DEFAULT_TOKEN);
usingDefault = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        jj_consume_token(GRAPH);
actionType = ActionType.GRAPH_ALL;
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
actionType = ActionType.DATABASE_ALL;
        break;
        }
      default:
        jj_la1[565] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case HOME:{
      t = jj_consume_token(HOME);
scopeType = ScopeType.HOME;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        jj_consume_token(GRAPH);
actionType = ActionType.GRAPH_ALL;
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
actionType = ActionType.DATABASE_ALL;
        break;
        }
      default:
        jj_la1[566] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DBMS:{
      t = jj_consume_token(DBMS);
actionType = ActionType.DBMS_ALL;
      break;
      }
    case GRAPH:
    case GRAPHS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        t = jj_consume_token(GRAPH);
        break;
        }
      case GRAPHS:{
        t = jj_consume_token(GRAPHS);
        break;
        }
      default:
        jj_la1[567] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
scopeType = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        names = SymbolicAliasNameList();
        break;
        }
      default:
        jj_la1[568] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
actionType = ActionType.GRAPH_ALL;
      break;
      }
    case DATABASE:
    case DATABASES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
        break;
        }
      case DATABASES:{
        t = jj_consume_token(DATABASES);
        break;
        }
      default:
        jj_la1[569] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
scopeType = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        names = SymbolicAliasNameList();
        break;
        }
      default:
        jj_la1[570] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
actionType = ActionType.DATABASE_ALL;
      break;
      }
    default:
      jj_la1[571] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( actionType == ActionType.DATABASE_ALL ) {
            assertValidType( t, type, "DATABASE" );
            if ( usingDefault ) {
                throw exceptionFactory.syntaxException( new ParseException(ASTExceptionFactory.invalidDefaultScope("DATABASE")), start.beginOffset, start.beginLine, start.beginColumn );
            }
            {if ("" != null) return astFactory.databasePrivilege( pos(start), astFactory.privilegeAction( actionType ), astFactory.databasePrivilegeScope( pos( t ), names, scopeType ), astFactory.allDatabasesQualifier(), immutable );}
        } else if ( actionType == ActionType.GRAPH_ALL ) {
            assertValidType( t, type, "GRAPH" );
            if ( usingDefault ) {
                throw exceptionFactory.syntaxException( new ParseException(ASTExceptionFactory.invalidDefaultScope("GRAPH")), start.beginOffset, start.beginLine, start.beginColumn );
            }
            {if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( actionType ), astFactory.graphScope( pos( t ), names, scopeType ), null, astFactory.allQualifier(), immutable );}
        } else {
            assertValidType( t, type, "DBMS" );
            {if ("" != null) return astFactory.dbmsPrivilege( pos(start), astFactory.privilegeAction( actionType ), astFactory.allQualifier(), immutable );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE createPrivilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    DATABASE_SCOPE database = null;
    GRAPH_SCOPE graph = null;
    List<PRIVILEGE_QUALIFIER> qualifier = new ArrayList<>();
    jj_consume_token(CREATE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case NEW:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[572] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_CREATE );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[573] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_CREATE );
        break;
        }
      case NEW:{
        jj_consume_token(NEW);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LABEL:
        case LABELS:
        case NODE:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NODE:{
            jj_consume_token(NODE);
            break;
            }
          default:
            jj_la1[574] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LABEL:{
            jj_consume_token(LABEL);
            break;
            }
          case LABELS:{
            jj_consume_token(LABELS);
            break;
            }
          default:
            jj_la1[575] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_LABEL );
          break;
          }
        case RELATIONSHIP:
        case TYPE:
        case TYPES:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case RELATIONSHIP:{
            jj_consume_token(RELATIONSHIP);
            break;
            }
          default:
            jj_la1[576] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TYPE:{
            jj_consume_token(TYPE);
            break;
            }
          case TYPES:{
            jj_consume_token(TYPES);
            break;
            }
          default:
            jj_la1[577] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_RELTYPE );
          break;
          }
        case NAME:
        case NAMES:
        case PROPERTY:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PROPERTY:{
            jj_consume_token(PROPERTY);
            break;
            }
          default:
            jj_la1[578] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NAME:{
            jj_consume_token(NAME);
            break;
            }
          case NAMES:{
            jj_consume_token(NAMES);
            break;
            }
          default:
            jj_la1[579] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
action = astFactory.privilegeAction( ActionType.CREATE_PROPERTYKEY );
          break;
          }
        default:
          jj_la1[580] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[581] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      database = DatabaseScope();
privilege = astFactory.databasePrivilege( pos(start), action, database, astFactory.allDatabasesQualifier(), immutable );
      break;
      }
    case ALIAS:
    case COMPOSITE:
    case DATABASE:
    case ROLE:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_CREATE );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_CREATE );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_CREATE );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_CREATE );
        break;
        }
      case COMPOSITE:{
        jj_consume_token(COMPOSITE);
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_COMPOSITE_CREATE );
        break;
        }
      default:
        jj_la1[582] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action,  astFactory.allQualifier(), immutable );
      break;
      }
    case ON:{
      jj_consume_token(ON);
      graph = GraphScope();
      qualifier = graphQualifier();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_CREATE ), graph, null, qualifier, immutable );
      break;
      }
    default:
      jj_la1[583] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE dropPrivilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    DATABASE_SCOPE database = null;
    jj_consume_token(DROP);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[584] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_DROP );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[585] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_DROP );
        break;
        }
      default:
        jj_la1[586] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      database = DatabaseScope();
privilege = astFactory.databasePrivilege( pos(start), action, database, astFactory.allDatabasesQualifier(), immutable );
      break;
      }
    case ALIAS:
    case COMPOSITE:
    case DATABASE:
    case ROLE:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_DROP );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_DROP );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_DROP );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_DROP );
        break;
        }
      case COMPOSITE:{
        jj_consume_token(COMPOSITE);
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_COMPOSITE_DROP );
        break;
        }
      default:
        jj_la1[587] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier(), immutable );
      break;
      }
    default:
      jj_la1[588] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE loadPrivilege(Token start, boolean immutable) throws ParseException {SimpleEither<String,PARAMETER> cidr = null;
    SimpleEither<String,PARAMETER> url = null;
    jj_consume_token(LOAD);
    jj_consume_token(ON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case URL:{
      jj_consume_token(URL);
      url = StringOrParameter();
      break;
      }
    case CIDR:{
      jj_consume_token(CIDR);
      cidr = StringOrParameter();
      break;
      }
    case ALL:{
      jj_consume_token(ALL);
      jj_consume_token(DATA);
      break;
      }
    default:
      jj_la1[589] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return astFactory.loadPrivilege(pos(start), url, cidr, immutable);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE showPrivilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    DATABASE_SCOPE database = null;
    List<PRIVILEGE_QUALIFIER> databaseQualifier = astFactory.allDatabasesQualifier();
    List<PRIVILEGE_QUALIFIER> dbmsQualifier = astFactory.allQualifier();
    List<SimpleEither<StringPos<POS>, PARAMETER>>qualifiers = null;
    jj_consume_token(SHOW);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTRAINT:
    case CONSTRAINTS:
    case INDEX:
    case INDEXES:
    case TRANSACTION:
    case TRANSACTIONS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:
      case INDEXES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INDEX:{
          jj_consume_token(INDEX);
          break;
          }
        case INDEXES:{
          jj_consume_token(INDEXES);
          break;
          }
        default:
          jj_la1[590] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.INDEX_SHOW );
        break;
        }
      case CONSTRAINT:
      case CONSTRAINTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CONSTRAINT:{
          jj_consume_token(CONSTRAINT);
          break;
          }
        case CONSTRAINTS:{
          jj_consume_token(CONSTRAINTS);
          break;
          }
        default:
          jj_la1[591] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_SHOW );
        break;
        }
      case TRANSACTION:
      case TRANSACTIONS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TRANSACTION:{
          jj_consume_token(TRANSACTION);
          break;
          }
        case TRANSACTIONS:{
          jj_consume_token(TRANSACTIONS);
          break;
          }
        default:
          jj_la1[592] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.TRANSACTION_SHOW ); databaseQualifier = astFactory.allUsersQualifier();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LPAREN:{
          jj_consume_token(LPAREN);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TIMES:{
            jj_consume_token(TIMES);
            break;
            }
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            qualifiers = SymbolicNameOrStringParameterList();
databaseQualifier = astFactory.userQualifier(qualifiers);
            break;
            }
          default:
            jj_la1[593] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[594] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[595] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      database = DatabaseScope();
privilege = astFactory.databasePrivilege( pos(start), action, database, databaseQualifier, immutable );
      break;
      }
    case ALIAS:
    case PRIVILEGE:
    case ROLE:
    case SERVER:
    case SERVERS:
    case SETTING:
    case SETTINGS:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_SHOW );
        break;
        }
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_SHOW );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_SHOW );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_SHOW );
        break;
        }
      case SERVER:
      case SERVERS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SERVER:{
          jj_consume_token(SERVER);
          break;
          }
        case SERVERS:{
          jj_consume_token(SERVERS);
          break;
          }
        default:
          jj_la1[596] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.SERVER_SHOW );
        break;
        }
      case SETTING:
      case SETTINGS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SETTING:{
          jj_consume_token(SETTING);
          break;
          }
        case SETTINGS:{
          jj_consume_token(SETTINGS);
          break;
          }
        default:
          jj_la1[597] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        dbmsQualifier = settingQualifier(start);
action = astFactory.privilegeAction( ActionType.SETTING_SHOW );
        break;
        }
      default:
        jj_la1[598] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, dbmsQualifier, immutable );
      break;
      }
    default:
      jj_la1[599] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE setPrivilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    ADMINISTRATION_ACTION action = null;
    GRAPH_SCOPE graph = null;
    PRIVILEGE_RESOURCE resource = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    jj_consume_token(SET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AUTH:
    case DATABASE:
    case PASSWORD:
    case PASSWORDS:
    case USER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PASSWORD:
      case PASSWORDS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PASSWORD:{
          jj_consume_token(PASSWORD);
          break;
          }
        case PASSWORDS:{
          jj_consume_token(PASSWORDS);
          break;
          }
        default:
          jj_la1[600] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
action = astFactory.privilegeAction( ActionType.USER_PASSWORD );
        break;
        }
      case AUTH:{
        jj_consume_token(AUTH);
action = astFactory.privilegeAction( ActionType.USER_AUTH );
        break;
        }
      case USER:{
        jj_consume_token(USER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STATUS:{
          jj_consume_token(STATUS);
action = astFactory.privilegeAction( ActionType.USER_STATUS );
          break;
          }
        case HOME:{
          jj_consume_token(HOME);
          jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.USER_HOME );
          break;
          }
        default:
          jj_la1[601] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
        jj_consume_token(ACCESS);
action = astFactory.privilegeAction( ActionType.SET_DATABASE_ACCESS);
        break;
        }
      default:
        jj_la1[602] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier(), immutable );
      break;
      }
    case LABEL:
    case PROPERTY:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LABEL:{
        jj_consume_token(LABEL);
        resource = labelResource();
        jj_consume_token(ON);
        graph = GraphScope();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_LABEL_SET ), graph, resource, List.of( astFactory.allLabelsQualifier( pos(start) ) ), immutable );
        break;
        }
      case PROPERTY:{
        jj_consume_token(PROPERTY);
        resource = propertyResource();
        jj_consume_token(ON);
        graph = GraphScope();
        qualifier = graphQualifier();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_PROPERTY_SET ), graph, resource, qualifier, immutable );
        break;
        }
      default:
        jj_la1[603] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[604] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE removePrivilege(Token start, boolean immutable) throws ParseException, Exception {PRIVILEGE_TYPE privilege = null;
    GRAPH_SCOPE graph = null;
    PRIVILEGE_RESOURCE resource = null;
    ADMINISTRATION_ACTION action = null;
    jj_consume_token(REMOVE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PRIVILEGE:
    case ROLE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_REMOVE );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_REMOVE );
        break;
        }
      default:
        jj_la1[605] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(DBMS);
privilege = astFactory.dbmsPrivilege( pos(start), action, astFactory.allQualifier(), immutable );
      break;
      }
    case LABEL:{
      jj_consume_token(LABEL);
      resource = labelResource();
      jj_consume_token(ON);
      graph = GraphScope();
privilege = astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_LABEL_REMOVE ), graph, resource, List.of( astFactory.allLabelsQualifier( pos(start) ) ), immutable );
      break;
      }
    default:
      jj_la1[606] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return privilege;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE writePrivilege(Token start, boolean immutable) throws ParseException, Exception {GRAPH_SCOPE graph = null;
    List<SimpleEither<String, PARAMETER>> qualifiers = null;
    jj_consume_token(WRITE);
    jj_consume_token(ON);
    graph = GraphScope();
{if ("" != null) return astFactory.graphPrivilege( pos(start), astFactory.privilegeAction( ActionType.GRAPH_WRITE ), graph, null, List.of( astFactory.allElementsQualifier( pos(start) ) ), immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE databasePrivilege(Token start, boolean immutable) throws ParseException, Exception {ADMINISTRATION_ACTION action = null;
    DATABASE_SCOPE database = null;
    List<PRIVILEGE_QUALIFIER> qualifier = astFactory.allDatabasesQualifier();
    List<SimpleEither<StringPos<POS>, PARAMETER>>qualifiers = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:{
      jj_consume_token(ACCESS);
action = astFactory.privilegeAction( ActionType.ACCESS );
      break;
      }
    case START:{
      jj_consume_token(START);
action = astFactory.privilegeAction( ActionType.DATABASE_START );
      break;
      }
    case STOP:{
      jj_consume_token(STOP);
action = astFactory.privilegeAction( ActionType.DATABASE_STOP );
      break;
      }
    case INDEX:
    case INDEXES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INDEX:{
        jj_consume_token(INDEX);
        break;
        }
      case INDEXES:{
        jj_consume_token(INDEXES);
        break;
        }
      default:
        jj_la1[607] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[608] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.INDEX_ALL );
      break;
      }
    case CONSTRAINT:
    case CONSTRAINTS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CONSTRAINT:{
        jj_consume_token(CONSTRAINT);
        break;
        }
      case CONSTRAINTS:{
        jj_consume_token(CONSTRAINTS);
        break;
        }
      default:
        jj_la1[609] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[610] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.CONSTRAINT_ALL );
      break;
      }
    case TRANSACTION:{
      jj_consume_token(TRANSACTION);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[611] = jj_gen;
        ;
      }
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[612] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[613] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.TRANSACTION_ALL );
      break;
      }
    case TERMINATE:{
      jj_consume_token(TERMINATE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TRANSACTION:{
        jj_consume_token(TRANSACTION);
        break;
        }
      case TRANSACTIONS:{
        jj_consume_token(TRANSACTIONS);
        break;
        }
      default:
        jj_la1[614] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[615] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[616] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.TRANSACTION_TERMINATE );
      break;
      }
    case NAME:{
      jj_consume_token(NAME);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MANAGEMENT:{
        jj_consume_token(MANAGEMENT);
        break;
        }
      default:
        jj_la1[617] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.CREATE_TOKEN );
      break;
      }
    default:
      jj_la1[618] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    database = DatabaseScope();
{if ("" != null) return astFactory.databasePrivilege( pos(start), action, database, qualifier, immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE dbmsPrivilege(Token start, boolean immutable) throws ParseException {ADMINISTRATION_ACTION action = null;
    List<PRIVILEGE_QUALIFIER> qualifier = astFactory.allQualifier();
    List<SimpleEither<StringPos<POS>, PARAMETER>> qualifiers = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:{
      jj_consume_token(ALTER);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_ALTER );
        break;
        }
      case DATABASE:{
        jj_consume_token(DATABASE);
action = astFactory.privilegeAction( ActionType.DATABASE_ALTER );
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
action = astFactory.privilegeAction( ActionType.ALIAS_ALTER );
        break;
        }
      default:
        jj_la1[619] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIVILEGE:{
        jj_consume_token(PRIVILEGE);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_ASSIGN );
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_ASSIGN );
        break;
        }
      default:
        jj_la1[620] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case COMPOSITE:{
      jj_consume_token(COMPOSITE);
      jj_consume_token(DATABASE);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.DATABASE_COMPOSITE_MANAGEMENT );
      break;
      }
    case DATABASE:{
      jj_consume_token(DATABASE);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.DATABASE_MANAGEMENT );
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.ALIAS_MANAGEMENT );
      break;
      }
    case EXECUTE:{
      jj_consume_token(EXECUTE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ADMIN:
      case ADMINISTRATOR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ADMIN:{
          jj_consume_token(ADMIN);
          break;
          }
        case ADMINISTRATOR:{
          jj_consume_token(ADMINISTRATOR);
          break;
          }
        default:
          jj_la1[621] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(PROCEDURES);
action = astFactory.privilegeAction( ActionType.EXECUTE_ADMIN_PROCEDURE );
        break;
        }
      case BOOSTED:{
        jj_consume_token(BOOSTED);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PROCEDURE:
        case PROCEDURES:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PROCEDURE:{
            jj_consume_token(PROCEDURE);
            break;
            }
          case PROCEDURES:{
            jj_consume_token(PROCEDURES);
            break;
            }
          default:
            jj_la1[622] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          qualifier = executeProcedureQualifier(start);
action = astFactory.privilegeAction( ActionType.EXECUTE_BOOSTED_PROCEDURE );
          break;
          }
        case FUNCTION:
        case FUNCTIONS:
        case USER:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case USER:{
            jj_consume_token(USER);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DEFINED:{
              jj_consume_token(DEFINED);
              break;
              }
            default:
              jj_la1[623] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[624] = jj_gen;
            ;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case FUNCTION:{
            jj_consume_token(FUNCTION);
            break;
            }
          case FUNCTIONS:{
            jj_consume_token(FUNCTIONS);
            break;
            }
          default:
            jj_la1[625] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          qualifier = executeFunctionQualifier(start);
action = astFactory.privilegeAction( ActionType.EXECUTE_BOOSTED_FUNCTION );
          break;
          }
        default:
          jj_la1[626] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case PROCEDURE:
      case PROCEDURES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PROCEDURE:{
          jj_consume_token(PROCEDURE);
          break;
          }
        case PROCEDURES:{
          jj_consume_token(PROCEDURES);
          break;
          }
        default:
          jj_la1[627] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        qualifier = executeProcedureQualifier(start);
action = astFactory.privilegeAction( ActionType.EXECUTE_PROCEDURE );
        break;
        }
      case FUNCTION:
      case FUNCTIONS:
      case USER:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case USER:{
          jj_consume_token(USER);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DEFINED:{
            jj_consume_token(DEFINED);
            break;
            }
          default:
            jj_la1[628] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[629] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FUNCTION:{
          jj_consume_token(FUNCTION);
          break;
          }
        case FUNCTIONS:{
          jj_consume_token(FUNCTIONS);
          break;
          }
        default:
          jj_la1[630] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        qualifier = executeFunctionQualifier(start);
action = astFactory.privilegeAction( ActionType.EXECUTE_FUNCTION );
        break;
        }
      default:
        jj_la1[631] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case PRIVILEGE:{
      jj_consume_token(PRIVILEGE);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.PRIVILEGE_ALL );
      break;
      }
    case RENAME:{
      jj_consume_token(RENAME);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ROLE:{
        jj_consume_token(ROLE);
action = astFactory.privilegeAction( ActionType.ROLE_RENAME );
        break;
        }
      case USER:{
        jj_consume_token(USER);
action = astFactory.privilegeAction( ActionType.USER_RENAME );
        break;
        }
      default:
        jj_la1[632] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case SERVER:{
      jj_consume_token(SERVER);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.SERVER_MANAGEMENT );
      break;
      }
    case USER:{
      jj_consume_token(USER);
      jj_consume_token(MANAGEMENT);
action = astFactory.privilegeAction( ActionType.USER_ALL );
      break;
      }
    case IMPERSONATE:{
      jj_consume_token(IMPERSONATE);
qualifier = astFactory.allUsersQualifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DOLLAR:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          qualifiers = SymbolicNameOrStringParameterList();
qualifier = astFactory.userQualifier(qualifiers);
          break;
          }
        default:
          jj_la1[633] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[634] = jj_gen;
        ;
      }
action = astFactory.privilegeAction( ActionType.USER_IMPERSONATE );
      break;
      }
    default:
      jj_la1[635] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(DBMS);
{if ("" != null) return astFactory.dbmsPrivilege( pos(start), action, qualifier, immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PRIVILEGE_QUALIFIER> executeFunctionQualifier(Token start) throws ParseException {
{if ("" != null) return astFactory.functionQualifier(pos(start), globs());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PRIVILEGE_QUALIFIER> executeProcedureQualifier(Token start) throws ParseException {
{if ("" != null) return astFactory.procedureQualifier(pos(start), globs());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PRIVILEGE_QUALIFIER> settingQualifier(Token start) throws ParseException {
{if ("" != null) return astFactory.settingQualifier(pos(start), globs());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> globs() throws ParseException {List<String> executableList = new ArrayList<>();
    String executableName = null;
    executableName = Glob();
executableList.add(executableName);
    label_70:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[636] = jj_gen;
        break label_70;
      }
      jj_consume_token(COMMA);
      executableName = Glob();
executableList.add(executableName);
    }
{if ("" != null) return executableList;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE qualifiedGraphPrivilegesWithProperty(Token start, boolean immutable) throws ParseException, Exception {ADMINISTRATION_ACTION action = null;
    GRAPH_SCOPE graph = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    PRIVILEGE_RESOURCE resource = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRAVERSE:{
      jj_consume_token(TRAVERSE);
action = astFactory.privilegeAction( ActionType.GRAPH_TRAVERSE );
      break;
      }
    case READ:{
      jj_consume_token(READ);
action = astFactory.privilegeAction( ActionType.GRAPH_READ );
      resource = propertyResource();
      break;
      }
    case MATCH:{
      jj_consume_token(MATCH);
action = astFactory.privilegeAction( ActionType.GRAPH_MATCH );
      resource = propertyResource();
      break;
      }
    default:
      jj_la1[637] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    graph = GraphScope();
    qualifier = graphQualifier();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      jj_consume_token(TIMES);
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[638] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.graphPrivilege( pos(start), action, graph, resource, qualifier, immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_TYPE qualifiedGraphPrivileges(Token start, boolean immutable) throws ParseException, Exception {ADMINISTRATION_ACTION action = null;
    GRAPH_SCOPE graph = null;
    List<PRIVILEGE_QUALIFIER> qualifier = null;
    PRIVILEGE_RESOURCE resource = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DELETE:{
      jj_consume_token(DELETE);
action = astFactory.privilegeAction( ActionType.GRAPH_DELETE );
      break;
      }
    case MERGE:{
      jj_consume_token(MERGE);
      resource = propertyResource();
action = astFactory.privilegeAction( ActionType.GRAPH_MERGE );
      break;
      }
    default:
      jj_la1[639] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    graph = GraphScope();
    qualifier = graphQualifier();
{if ("" != null) return astFactory.graphPrivilege( pos(start), action, graph, resource, qualifier, immutable );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_RESOURCE labelResource() throws ParseException {List<String> names = null;
    Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
{if ("" != null) return astFactory.allLabelsResource( pos(token) );}
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      names = SymbolicNameList1();
{if ("" != null) return astFactory.labelsResource( pos(token), names );}
      break;
      }
    default:
      jj_la1[640] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PRIVILEGE_RESOURCE propertyResource() throws ParseException {List<String> names = null;
    PRIVILEGE_RESOURCE resource = null;
    Token t;
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TIMES:{
      jj_consume_token(TIMES);
resource = astFactory.allPropertiesResource( pos(token) );
      break;
      }
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      names = SymbolicNameList1();
resource = astFactory.propertiesResource( pos(token), names );
      break;
      }
    default:
      jj_la1[641] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RCURLY);
{if ("" != null) return resource;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<PRIVILEGE_QUALIFIER> graphQualifier() throws ParseException, Exception {List<PRIVILEGE_QUALIFIER> qualifier = new ArrayList<>();
    Token n = null;
    VARIABLE v = null;
    List<StringPos<POS>> labels = null;
    EXPRESSION propertyRuleExpression = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELEMENT:
    case ELEMENTS:
    case FOR:
    case NODE:
    case NODES:
    case RELATIONSHIP:
    case RELATIONSHIPS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RELATIONSHIP:
      case RELATIONSHIPS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RELATIONSHIP:{
          jj_consume_token(RELATIONSHIP);
          break;
          }
        case RELATIONSHIPS:{
          jj_consume_token(RELATIONSHIPS);
          break;
          }
        default:
          jj_la1[642] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allRelationshipsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.relationshipQualifier( pos(n), n.image ) );
          label_71:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[643] = jj_gen;
              break label_71;
            }
            jj_consume_token(COMMA);
            n = SymbolicNameString();
qualifier.add( astFactory.relationshipQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[644] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case NODE:
      case NODES:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NODE:{
          jj_consume_token(NODE);
          break;
          }
        case NODES:{
          jj_consume_token(NODES);
          break;
          }
        default:
          jj_la1[645] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allLabelsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.labelQualifier( pos(n), n.image ) );
          label_72:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[646] = jj_gen;
              break label_72;
            }
            jj_consume_token(COMMA);
            n = SymbolicNameString();
qualifier.add( astFactory.labelQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[647] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case ELEMENT:
      case ELEMENTS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ELEMENT:{
          jj_consume_token(ELEMENT);
          break;
          }
        case ELEMENTS:{
          jj_consume_token(ELEMENTS);
          break;
          }
        default:
          jj_la1[648] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TIMES:{
          jj_consume_token(TIMES);
qualifier.add( astFactory.allElementsQualifier( pos(token) ) );
          break;
          }
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          n = SymbolicNameString();
qualifier.add( astFactory.elementQualifier( pos(n), n.image ) );
          label_73:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case COMMA:{
              break;
              }
            default:
              jj_la1[649] = jj_gen;
              break label_73;
            }
            jj_consume_token(COMMA);
            n = SymbolicNameString();
qualifier.add( astFactory.elementQualifier( pos(n), n.image ) );
          }
          break;
          }
        default:
          jj_la1[650] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case FOR:{
        jj_consume_token(FOR);
        jj_consume_token(LPAREN);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ESCAPED_SYMBOLIC_NAME:
        case ACCESS:
        case ACTIVE:
        case ADMIN:
        case ADMINISTRATOR:
        case ALIAS:
        case ALIASES:
        case ALL_SHORTEST_PATH:
        case ALL:
        case ALTER:
        case AND:
        case ANY:
        case ARRAY:
        case AS:
        case ASC:
        case ASCENDING:
        case ASSERT:
        case ASSIGN:
        case AT:
        case AUTH:
        case BINDINGS:
        case BOOL:
        case BOOLEAN:
        case BOOSTED:
        case BOTH:
        case BREAK:
        case BRIEF:
        case BTREE:
        case BUILT:
        case BY:
        case CALL:
        case CASCADE:
        case CASE:
        case CHANGE:
        case CIDR:
        case COLLECT:
        case COMMAND:
        case COMMANDS:
        case COMMIT:
        case COMPOSITE:
        case CONCURRENT:
        case CONSTRAINT:
        case CONSTRAINTS:
        case CONTAINS:
        case COPY:
        case CONTINUE:
        case COUNT:
        case CREATE:
        case CSV:
        case CURRENT:
        case DATA:
        case DATABASE:
        case DATABASES:
        case DATE:
        case DATETIME:
        case DBMS:
        case DEALLOCATE:
        case DEFAULT_TOKEN:
        case DEFINED:
        case DELETE:
        case DENY:
        case DESC:
        case DESCENDING:
        case DESTROY:
        case DETACH:
        case DIFFERENT:
        case DISTINCT:
        case DRIVER:
        case DROP:
        case DRYRUN:
        case DUMP:
        case DURATION:
        case EACH:
        case EDGE:
        case ENABLE:
        case ELEMENT:
        case ELEMENTS:
        case ELSE:
        case ENCRYPTED:
        case END:
        case ENDS:
        case EXECUTABLE:
        case EXECUTE:
        case EXIST:
        case EXISTENCE:
        case EXISTS:
        case ERROR:
        case FAIL:
        case FALSE:
        case FIELDTERMINATOR:
        case FINISH:
        case FLOAT:
        case FOR:
        case FOREACH:
        case FROM:
        case FULLTEXT:
        case FUNCTION:
        case FUNCTIONS:
        case GRANT:
        case GRAPH:
        case GRAPHS:
        case GROUP:
        case GROUPS:
        case HEADERS:
        case HOME:
        case ID:
        case IF:
        case IMPERSONATE:
        case IMMUTABLE:
        case IN:
        case INDEX:
        case INDEXES:
        case INF:
        case INFINITY:
        case INSERT:
        case INT:
        case INTEGER:
        case IS:
        case JOIN:
        case KEY:
        case LABEL:
        case LABELS:
        case LEADING:
        case LIMITROWS:
        case LIST:
        case LOAD:
        case LOCAL:
        case LOOKUP:
        case MANAGEMENT:
        case MAP:
        case MATCH:
        case MERGE:
        case NAME:
        case NAMES:
        case NAN:
        case NFC:
        case NFD:
        case NFKC:
        case NFKD:
        case NEW:
        case NODE:
        case NODETACH:
        case NODES:
        case NONE:
        case NORMALIZE:
        case NORMALIZED:
        case NOT:
        case NOTHING:
        case NOWAIT:
        case NULL:
        case OF:
        case OFFSET:
        case ON:
        case ONLY:
        case OPTIONAL:
        case OPTIONS:
        case OPTION:
        case OR:
        case ORDER:
        case OUTPUT:
        case PASSWORD:
        case PASSWORDS:
        case PATH:
        case PATHS:
        case PERIODIC:
        case PLAINTEXT:
        case POINT:
        case POPULATED:
        case REPEATABLE:
        case PRIMARY:
        case PRIMARIES:
        case PRIVILEGE:
        case PRIVILEGES:
        case PROCEDURE:
        case PROCEDURES:
        case PROPERTIES:
        case PROPERTY:
        case PROVIDER:
        case PROVIDERS:
        case RANGE:
        case READ:
        case REALLOCATE:
        case REDUCE:
        case RENAME:
        case REL:
        case RELATIONSHIP:
        case RELATIONSHIPS:
        case REMOVE:
        case REPLACE:
        case REPORT:
        case REQUIRE:
        case REQUIRED:
        case RESTRICT:
        case RETURN:
        case REVOKE:
        case ROLE:
        case ROLES:
        case ROW:
        case ROWS:
        case SCAN:
        case SEC:
        case SECOND:
        case SECONDARY:
        case SECONDARIES:
        case SECONDS:
        case SEEK:
        case SERVER:
        case SERVERS:
        case SET:
        case SETTING:
        case SETTINGS:
        case SHORTEST_PATH:
        case SHORTEST:
        case SHOW:
        case SIGNED:
        case SINGLE:
        case SKIPROWS:
        case START:
        case STARTS:
        case STATUS:
        case STOP:
        case STRING:
        case SUPPORTED:
        case SUSPENDED:
        case TARGET:
        case TERMINATE:
        case TEXT:
        case THEN:
        case TIME:
        case TIMESTAMP:
        case TIMEZONE:
        case TO:
        case TOPOLOGY:
        case TRAILING:
        case TRANSACTION:
        case TRANSACTIONS:
        case TRAVERSE:
        case TRIM:
        case TRUE:
        case TYPE:
        case TYPED:
        case TYPES:
        case UNION:
        case UNIQUE:
        case UNIQUENESS:
        case UNWIND:
        case URL:
        case USE:
        case USER:
        case USERS:
        case USING:
        case VALUE:
        case VARCHAR:
        case VECTOR:
        case VERBOSE:
        case VERTEX:
        case WAIT:
        case WHEN:
        case WHERE:
        case WITH:
        case WITHOUT:
        case WRITE:
        case XOR:
        case YIELD:
        case ZONE:
        case ZONED:
        case IDENTIFIER:{
          v = Variable();
          break;
          }
        default:
          jj_la1[651] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          labels = LabelOrRelTypes();
          break;
          }
        default:
          jj_la1[652] = jj_gen;
          ;
        }
        if (jj_2_177(2147483647)) {
          jj_consume_token(RPAREN);
          jj_consume_token(WHERE);
          propertyRuleExpression = Expression();
        } else if (jj_2_178(2147483647)) {
          jj_consume_token(WHERE);
          propertyRuleExpression = Expression();
          jj_consume_token(RPAREN);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LCURLY:{
            propertyRuleExpression = MapLiteral();
            jj_consume_token(RPAREN);
            break;
            }
          default:
            jj_la1[653] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
List<PRIVILEGE_QUALIFIER> labelQualifiers = new ArrayList<>();
    if ( labels == null ) {
        labelQualifiers.add(astFactory.allLabelsQualifier( pos(token) ));
    } else {
        for(var label: labels) {
          labelQualifiers.add(astFactory.labelQualifier(label.pos, label.string));
        }
    }
    qualifier.add(astFactory.patternQualifier( labelQualifiers, v, propertyRuleExpression));
        break;
        }
      default:
        jj_la1[654] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[655] = jj_gen;
      ;
    }
if ( qualifier.isEmpty() ) {
            qualifier.add( astFactory.allElementsQualifier( pos(token) ) );
        }
        {if ("" != null) return qualifier;}
    throw new IllegalStateException ("Missing return statement in function");
}

// Database commands
  final public 
ADMINISTRATION_COMMAND CreateDatabase(Token start, boolean replace) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> databaseName = null;
    boolean ifNotExists = false;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    Token primaries = null;
    Token secondaries = null;
    Token count = null;
    Token errorStart = null;
    String topologyMultiplePrimaryError = "Duplicate PRIMARY clause";
    String topologyMultipleSecondaryError = "Duplicate SECONDARY clause";
    jj_consume_token(DATABASE);
    databaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[656] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TOPOLOGY:{
      jj_consume_token(TOPOLOGY);
      label_74:
      while (true) {
        count = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PRIMARY:
        case PRIMARIES:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PRIMARY:{
            errorStart = jj_consume_token(PRIMARY);
            break;
            }
          case PRIMARIES:{
            errorStart = jj_consume_token(PRIMARIES);
            break;
            }
          default:
            jj_la1[657] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
assertNotAlreadySet(primaries, errorStart, topologyMultiplePrimaryError);
primaries = count;
          break;
          }
        case SECONDARY:
        case SECONDARIES:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SECONDARY:{
            errorStart = jj_consume_token(SECONDARY);
            break;
            }
          case SECONDARIES:{
            errorStart = jj_consume_token(SECONDARIES);
            break;
            }
          default:
            jj_la1[658] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
assertNotAlreadySet(secondaries, errorStart, topologyMultipleSecondaryError);
secondaries = count;
          break;
          }
        default:
          jj_la1[659] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UNSIGNED_DECIMAL_INTEGER:{
          break;
          }
        default:
          jj_la1[660] = jj_gen;
          break label_74;
        }
      }
      break;
      }
    default:
      jj_la1[661] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      options = Options();
      break;
      }
    default:
      jj_la1[662] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[663] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createDatabase(
            pos( start ),
            replace, databaseName.getAsDatabaseName(astFactory),
            ifNotExists,
            wait,
            options,
            (primaries != null) ? Integer.parseInt(primaries.image) : null,
            (secondaries != null) ? Integer.parseInt(secondaries.image) : null);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<Map<String, EXPRESSION>, PARAMETER> Options() throws ParseException, Exception {SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    jj_consume_token(OPTIONS);
    options = MapOrParameter();
{if ("" != null) return options;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND CreateCompositeDatabase(Token start, boolean replace) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> compositeDatabaseName = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> options = null;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    boolean ifNotExists = false;
    jj_consume_token(COMPOSITE);
    jj_consume_token(DATABASE);
    compositeDatabaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[664] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OPTIONS:{
      options = Options();
      break;
      }
    default:
      jj_la1[665] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[666] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.createCompositeDatabase( pos( start ), replace, compositeDatabaseName.getLocalAliasName(astFactory), ifNotExists, options, wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropDatabase(Token start) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> databaseName = null;
    boolean ifExists = false;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    boolean dumpData = false;
    boolean composite = false;
    boolean aliasAction = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COMPOSITE:{
      jj_consume_token(COMPOSITE);
composite = true;
      break;
      }
    default:
      jj_la1[667] = jj_gen;
      ;
    }
    jj_consume_token(DATABASE);
    databaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[668] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CASCADE:
    case RESTRICT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASCADE:{
        jj_consume_token(CASCADE);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALIAS:{
          jj_consume_token(ALIAS);
          break;
          }
        case ALIASES:{
          jj_consume_token(ALIASES);
          break;
          }
        default:
          jj_la1[669] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
aliasAction = true;
        break;
        }
      case RESTRICT:{
        jj_consume_token(RESTRICT);
        break;
        }
      default:
        jj_la1[670] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[671] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESTROY:
    case DUMP:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DUMP:{
        jj_consume_token(DUMP);
dumpData = true;
        break;
        }
      case DESTROY:{
        jj_consume_token(DESTROY);
        break;
        }
      default:
        jj_la1[672] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(DATA);
      break;
      }
    default:
      jj_la1[673] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[674] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.dropDatabase( pos( start ), databaseName.getLocalAliasName(astFactory), ifExists, composite, aliasAction, dumpData, wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterDatabase(Token start) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> databaseName = null;
    boolean ifExists = false;
    AccessType accessType = null;
    Token primaries = null;
    Token secondaries = null;
    Token count = null;
    Token set = null;
    Map<String, EXPRESSION> options = null;
    Set<String> optionsToRemove = new LinkedHashSet<>();
    String accessSetError = "Duplicate SET ACCESS clause";
    String topologySetError = "Duplicate SET TOPOLOGY clause";
    Token errorStart = null;
    String topologyMultiplePrimaryError = "Duplicate PRIMARY clause";
    String topologyMultipleSecondaryError = "Duplicate SECONDARY clause";
    Token key = null;
    Token remove = null;
    EXPRESSION value = null;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    jj_consume_token(DATABASE);
    databaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[675] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SET:{
      label_75:
      while (true) {
        set = jj_consume_token(SET);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ACCESS:{
          jj_consume_token(ACCESS);
assertNotAlreadySet( accessType, set, accessSetError);
          jj_consume_token(READ);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ONLY:{
            jj_consume_token(ONLY);
accessType = AccessType.READ_ONLY;
            break;
            }
          case WRITE:{
            jj_consume_token(WRITE);
accessType = AccessType.READ_WRITE;
            break;
            }
          default:
            jj_la1[676] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case TOPOLOGY:{
          jj_consume_token(TOPOLOGY);
assertNotAlreadySet(count, set, topologySetError );
          label_76:
          while (true) {
            count = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case PRIMARY:
            case PRIMARIES:{
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case PRIMARY:{
                errorStart = jj_consume_token(PRIMARY);
                break;
                }
              case PRIMARIES:{
                errorStart = jj_consume_token(PRIMARIES);
                break;
                }
              default:
                jj_la1[677] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
assertNotAlreadySet(primaries, errorStart, topologyMultiplePrimaryError);
primaries = count;
              break;
              }
            case SECONDARY:
            case SECONDARIES:{
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case SECONDARY:{
                errorStart = jj_consume_token(SECONDARY);
                break;
                }
              case SECONDARIES:{
                errorStart = jj_consume_token(SECONDARIES);
                break;
                }
              default:
                jj_la1[678] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
assertNotAlreadySet(secondaries, errorStart, topologyMultipleSecondaryError);
secondaries = count;
              break;
              }
            default:
              jj_la1[679] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case UNSIGNED_DECIMAL_INTEGER:{
              break;
              }
            default:
              jj_la1[680] = jj_gen;
              break label_76;
            }
          }
          break;
          }
        case OPTION:{
          jj_consume_token(OPTION);
          key = SymbolicNameString();
          value = Expression();
if (options == null) {
                options = new LinkedHashMap<>();
            }
            assertNotAlreadySet(options.getOrDefault(key.image, null), set, "Duplicate 'SET OPTION " + key.image + "' clause");
            options.put(key.image, value);
          break;
          }
        default:
          jj_la1[681] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SET:{
          break;
          }
        default:
          jj_la1[682] = jj_gen;
          break label_75;
        }
      }
      break;
      }
    case REMOVE:{
      label_77:
      while (true) {
        remove = jj_consume_token(REMOVE);
        jj_consume_token(OPTION);
        key = SymbolicNameString();
String entryOrNull = optionsToRemove.contains(key.image) ? key.image : null;
            assertNotAlreadySet(entryOrNull, remove, "Duplicate 'REMOVE OPTION " + key.image + "' clause");
            optionsToRemove.add(key.image);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case REMOVE:{
          break;
          }
        default:
          jj_la1[683] = jj_gen;
          break label_77;
        }
      }
      break;
      }
    default:
      jj_la1[684] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[685] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.alterDatabase(
            pos( start ),
            databaseName.getLocalAliasName(astFactory),
            ifExists,
            accessType,
            (primaries != null) ? Integer.parseInt(primaries.image) : null,
            (secondaries != null) ? Integer.parseInt(secondaries.image) : null,
            options,
            optionsToRemove,
            wait);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND StartDatabase() throws ParseException, Exception {Token start;
    AliasName<DATABASE_NAME, PARAMETER> databaseName;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    start = jj_consume_token(START);
    jj_consume_token(DATABASE);
    databaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[686] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.startDatabase( pos( start ), databaseName.getLocalAliasName(astFactory), wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND StopDatabase() throws ParseException, Exception {Token start;
    AliasName<DATABASE_NAME, PARAMETER> databaseName;
    WAIT_CLAUSE wait = astFactory.wait( false, -1 );
    start = jj_consume_token(STOP);
    jj_consume_token(DATABASE);
    databaseName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOWAIT:
    case WAIT:{
      wait = WaitClause();
      break;
      }
    default:
      jj_la1[687] = jj_gen;
      ;
    }
{if ("" != null) return astFactory.stopDatabase( pos( start ), databaseName.getLocalAliasName(astFactory), wait );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public WAIT_CLAUSE WaitClause() throws ParseException {Token number = null;
    boolean wait = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WAIT:{
      jj_consume_token(WAIT);
wait = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNSIGNED_DECIMAL_INTEGER:{
        number = jj_consume_token(UNSIGNED_DECIMAL_INTEGER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SEC:
        case SECOND:
        case SECONDS:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SEC:{
            jj_consume_token(SEC);
            break;
            }
          case SECOND:{
            jj_consume_token(SECOND);
            break;
            }
          case SECONDS:{
            jj_consume_token(SECONDS);
            break;
            }
          default:
            jj_la1[688] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[689] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[690] = jj_gen;
        ;
      }
      break;
      }
    case NOWAIT:{
      jj_consume_token(NOWAIT);
      break;
      }
    default:
      jj_la1[691] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( number != null )
        {
            {if ("" != null) return astFactory.wait( wait, Long.parseLong( number.image) );}
        }
        {if ("" != null) return astFactory.wait( wait, -1 ) ;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT_WITH_GRAPH ShowDatabase(Token start, USE_CLAUSE useClause) throws ParseException, Exception {Token scopeStart = null;
    AliasName<DATABASE_NAME, PARAMETER> name = null;
    boolean isDefault = false;
    boolean isHome = false;
    DATABASE_SCOPE scope;
    YIELD yield = null;
    RETURN_CLAUSE returnClause = null;
    WHERE where = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case DATABASES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASES:{
        scopeStart = jj_consume_token(DATABASES);
        break;
        }
      case DATABASE:{
        scopeStart = jj_consume_token(DATABASE);
        break;
        }
      default:
        jj_la1[692] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        if (jj_2_179(2147483647)) {
          name = SymbolicAliasNameOrParameter();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case YIELD:{
            yield = YieldClause();
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case RETURN:{
              returnClause = ReturnClause();
              break;
              }
            default:
              jj_la1[693] = jj_gen;
              ;
            }
            break;
            }
          case WHERE:{
            where = WhereClause();
            break;
            }
          default:
            jj_la1[694] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else if (jj_2_180(2147483647)) {
          yield = YieldClause();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case RETURN:{
            returnClause = ReturnClause();
            break;
            }
          default:
            jj_la1[695] = jj_gen;
            ;
          }
        } else if (jj_2_181(2147483647)) {
          where = WhereClause();
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ESCAPED_SYMBOLIC_NAME:
          case ACCESS:
          case ACTIVE:
          case ADMIN:
          case ADMINISTRATOR:
          case ALIAS:
          case ALIASES:
          case ALL_SHORTEST_PATH:
          case ALL:
          case ALTER:
          case AND:
          case ANY:
          case ARRAY:
          case AS:
          case ASC:
          case ASCENDING:
          case ASSERT:
          case ASSIGN:
          case AT:
          case AUTH:
          case BINDINGS:
          case BOOL:
          case BOOLEAN:
          case BOOSTED:
          case BOTH:
          case BREAK:
          case BRIEF:
          case BTREE:
          case BUILT:
          case BY:
          case CALL:
          case CASCADE:
          case CASE:
          case CHANGE:
          case CIDR:
          case COLLECT:
          case COMMAND:
          case COMMANDS:
          case COMMIT:
          case COMPOSITE:
          case CONCURRENT:
          case CONSTRAINT:
          case CONSTRAINTS:
          case CONTAINS:
          case COPY:
          case CONTINUE:
          case COUNT:
          case CREATE:
          case CSV:
          case CURRENT:
          case DATA:
          case DATABASE:
          case DATABASES:
          case DATE:
          case DATETIME:
          case DBMS:
          case DEALLOCATE:
          case DEFAULT_TOKEN:
          case DEFINED:
          case DELETE:
          case DENY:
          case DESC:
          case DESCENDING:
          case DESTROY:
          case DETACH:
          case DOLLAR:
          case DIFFERENT:
          case DISTINCT:
          case DRIVER:
          case DROP:
          case DRYRUN:
          case DUMP:
          case DURATION:
          case EACH:
          case EDGE:
          case ENABLE:
          case ELEMENT:
          case ELEMENTS:
          case ELSE:
          case ENCRYPTED:
          case END:
          case ENDS:
          case EXECUTABLE:
          case EXECUTE:
          case EXIST:
          case EXISTENCE:
          case EXISTS:
          case ERROR:
          case FAIL:
          case FALSE:
          case FIELDTERMINATOR:
          case FINISH:
          case FLOAT:
          case FOR:
          case FOREACH:
          case FROM:
          case FULLTEXT:
          case FUNCTION:
          case FUNCTIONS:
          case GRANT:
          case GRAPH:
          case GRAPHS:
          case GROUP:
          case GROUPS:
          case HEADERS:
          case HOME:
          case ID:
          case IF:
          case IMPERSONATE:
          case IMMUTABLE:
          case IN:
          case INDEX:
          case INDEXES:
          case INF:
          case INFINITY:
          case INSERT:
          case INT:
          case INTEGER:
          case IS:
          case JOIN:
          case KEY:
          case LABEL:
          case LABELS:
          case LEADING:
          case LIMITROWS:
          case LIST:
          case LOAD:
          case LOCAL:
          case LOOKUP:
          case MANAGEMENT:
          case MAP:
          case MATCH:
          case MERGE:
          case NAME:
          case NAMES:
          case NAN:
          case NFC:
          case NFD:
          case NFKC:
          case NFKD:
          case NEW:
          case NODE:
          case NODETACH:
          case NODES:
          case NONE:
          case NORMALIZE:
          case NORMALIZED:
          case NOT:
          case NOTHING:
          case NOWAIT:
          case NULL:
          case OF:
          case OFFSET:
          case ON:
          case ONLY:
          case OPTIONAL:
          case OPTIONS:
          case OPTION:
          case OR:
          case ORDER:
          case OUTPUT:
          case PASSWORD:
          case PASSWORDS:
          case PATH:
          case PATHS:
          case PERIODIC:
          case PLAINTEXT:
          case POINT:
          case POPULATED:
          case REPEATABLE:
          case PRIMARY:
          case PRIMARIES:
          case PRIVILEGE:
          case PRIVILEGES:
          case PROCEDURE:
          case PROCEDURES:
          case PROPERTIES:
          case PROPERTY:
          case PROVIDER:
          case PROVIDERS:
          case RANGE:
          case READ:
          case REALLOCATE:
          case REDUCE:
          case RENAME:
          case REL:
          case RELATIONSHIP:
          case RELATIONSHIPS:
          case REMOVE:
          case REPLACE:
          case REPORT:
          case REQUIRE:
          case REQUIRED:
          case RESTRICT:
          case RETURN:
          case REVOKE:
          case ROLE:
          case ROLES:
          case ROW:
          case ROWS:
          case SCAN:
          case SEC:
          case SECOND:
          case SECONDARY:
          case SECONDARIES:
          case SECONDS:
          case SEEK:
          case SERVER:
          case SERVERS:
          case SET:
          case SETTING:
          case SETTINGS:
          case SHORTEST_PATH:
          case SHORTEST:
          case SHOW:
          case SIGNED:
          case SINGLE:
          case SKIPROWS:
          case START:
          case STARTS:
          case STATUS:
          case STOP:
          case STRING:
          case SUPPORTED:
          case SUSPENDED:
          case TARGET:
          case TERMINATE:
          case TEXT:
          case THEN:
          case TIME:
          case TIMESTAMP:
          case TIMEZONE:
          case TO:
          case TOPOLOGY:
          case TRAILING:
          case TRANSACTION:
          case TRANSACTIONS:
          case TRAVERSE:
          case TRIM:
          case TRUE:
          case TYPE:
          case TYPED:
          case TYPES:
          case UNION:
          case UNIQUE:
          case UNIQUENESS:
          case UNWIND:
          case URL:
          case USE:
          case USER:
          case USERS:
          case USING:
          case VALUE:
          case VARCHAR:
          case VECTOR:
          case VERBOSE:
          case VERTEX:
          case WAIT:
          case WHEN:
          case WHERE:
          case WITH:
          case WITHOUT:
          case WRITE:
          case XOR:
          case YIELD:
          case ZONE:
          case ZONED:
          case IDENTIFIER:{
            name = SymbolicAliasNameOrParameter();
            break;
            }
          default:
            jj_la1[696] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[697] = jj_gen;
        ;
      }
      break;
      }
    case DEFAULT_TOKEN:
    case HOME:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DEFAULT_TOKEN:{
        scopeStart = jj_consume_token(DEFAULT_TOKEN);
        jj_consume_token(DATABASE);
isDefault = true;
        break;
        }
      case HOME:{
        scopeStart = jj_consume_token(HOME);
        jj_consume_token(DATABASE);
isHome = true;
        break;
        }
      default:
        jj_la1[698] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case WHERE:
      case YIELD:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case YIELD:{
          yield = YieldClause();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case RETURN:{
            returnClause = ReturnClause();
            break;
            }
          default:
            jj_la1[699] = jj_gen;
            ;
          }
          break;
          }
        case WHERE:{
          where = WhereClause();
          break;
          }
        default:
          jj_la1[700] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[701] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[702] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
scope = astFactory.databaseScope( pos( scopeStart ), name == null ? null : name.getLocalAliasName(astFactory), isDefault, isHome );
        {if ("" != null) return astFactory.useGraph( astFactory.showDatabase( pos( start ), scope, yield, returnClause, where), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DATABASE_SCOPE DatabaseScope() throws ParseException, Exception {Token start = null;
    List<DATABASE_NAME> names = null;
    ScopeType type = ScopeType.NAMED;
    boolean usingDefault = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:
    case DATABASES:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        start = jj_consume_token(DATABASE);
        break;
        }
      case DATABASES:{
        start = jj_consume_token(DATABASES);
        break;
        }
      default:
        jj_la1[703] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
type = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        names = SymbolicAliasNameList();
        break;
        }
      default:
        jj_la1[704] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DEFAULT_TOKEN:{
      start = jj_consume_token(DEFAULT_TOKEN);
      jj_consume_token(DATABASE);
usingDefault = true;
      break;
      }
    case HOME:{
      start = jj_consume_token(HOME);
      jj_consume_token(DATABASE);
type = ScopeType.HOME;
      break;
      }
    default:
      jj_la1[705] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( usingDefault ) {
        throw exceptionFactory.syntaxException( new ParseException(ASTExceptionFactory.invalidDefaultScope("DATABASE")), start.beginOffset, start.beginLine, start.beginColumn );
    }
    {if ("" != null) return astFactory.databasePrivilegeScope( pos( start ), names, type );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GRAPH_SCOPE GraphScope() throws ParseException, Exception {Token start = null;
    List<DATABASE_NAME> names = null;
    ScopeType type = ScopeType.NAMED;
    boolean usingDefault = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GRAPH:
    case GRAPHS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case GRAPH:{
        start = jj_consume_token(GRAPH);
        break;
        }
      case GRAPHS:{
        start = jj_consume_token(GRAPHS);
        break;
        }
      default:
        jj_la1[706] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TIMES:{
        jj_consume_token(TIMES);
type = ScopeType.ALL;
        break;
        }
      case ESCAPED_SYMBOLIC_NAME:
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DOLLAR:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        names = SymbolicAliasNameList();
        break;
        }
      default:
        jj_la1[707] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DEFAULT_TOKEN:{
      start = jj_consume_token(DEFAULT_TOKEN);
      jj_consume_token(GRAPH);
usingDefault = true;
      break;
      }
    case HOME:{
      start = jj_consume_token(HOME);
      jj_consume_token(GRAPH);
type = ScopeType.HOME;
      break;
      }
    default:
      jj_la1[708] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( usingDefault ) {
            throw exceptionFactory.syntaxException( new ParseException(ASTExceptionFactory.invalidDefaultScope("GRAPH")), start.beginOffset, start.beginLine, start.beginColumn );
        }
        {if ("" != null) return astFactory.graphScope( pos( start ), names, type );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND CreateAlias(Token start, boolean replace) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> aliasName = null;
    AliasName<DATABASE_NAME, PARAMETER> targetName = null;
    boolean ifNotExists = false;
    SimpleEither<String, PARAMETER> url = null;
    SimpleEither<StringPos<POS>, PARAMETER> username = null;
    EXPRESSION password = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> driverSettings = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> properties = null;
    jj_consume_token(ALIAS);
    aliasName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
ifNotExists = true;
      break;
      }
    default:
      jj_la1[709] = jj_gen;
      ;
    }
    jj_consume_token(FOR);
    jj_consume_token(DATABASE);
    targetName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AT:{
      jj_consume_token(AT);
      url = StringOrParameter();
      jj_consume_token(USER);
      username = SymbolicNameOrStringParameter();
      jj_consume_token(PASSWORD);
      password = passwordExpression();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DRIVER:{
        jj_consume_token(DRIVER);
        driverSettings = MapOrParameter();
        break;
        }
      default:
        jj_la1[710] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[711] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROPERTIES:{
      jj_consume_token(PROPERTIES);
      properties = MapOrParameter();
      break;
      }
    default:
      jj_la1[712] = jj_gen;
      ;
    }
if ( url == null )
       {
           {if ("" != null) return astFactory.createLocalDatabaseAlias( pos( start ), replace, aliasName.getLocalAliasName(astFactory), targetName.getLocalAliasName(astFactory), ifNotExists, properties );}
       }
       else
       {
           {if ("" != null) return astFactory.createRemoteDatabaseAlias( pos( start ), replace, aliasName.getRemoteAliasName(astFactory), targetName.getLocalAliasName(astFactory), ifNotExists, url, username, password, driverSettings, properties );}
       }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND DropAlias(Token start) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> aliasName = null;
    boolean ifExists = false;
    jj_consume_token(ALIAS);
    aliasName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[713] = jj_gen;
      ;
    }
    jj_consume_token(FOR);
    jj_consume_token(DATABASE);
{if ("" != null) return astFactory.dropAlias( pos( start ), aliasName.getLocalAliasName(astFactory), ifExists );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ADMINISTRATION_COMMAND AlterAlias(Token start) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> aliasName = null;
    AliasName<DATABASE_NAME, PARAMETER> targetName = null;
    boolean ifExists = false;
    SimpleEither<String, PARAMETER> url = null;
    SimpleEither<StringPos<POS>, PARAMETER> username = null;
    EXPRESSION password = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> driverSettings = null;
    SimpleEither<Map<String, EXPRESSION>, PARAMETER> properties = null;
    Token errorStart = null;
    String alreadySet = "Duplicate SET DATABASE %s clause";
    jj_consume_token(ALIAS);
    aliasName = SymbolicAliasNameOrParameter();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
ifExists = true;
      break;
      }
    default:
      jj_la1[714] = jj_gen;
      ;
    }
    jj_consume_token(SET);
    jj_consume_token(DATABASE);
    label_78:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TARGET:{
        errorStart = jj_consume_token(TARGET);
assertNotAlreadySet( targetName, errorStart, String.format(alreadySet, errorStart.image) );
        targetName = SymbolicAliasNameOrParameter();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AT:{
          jj_consume_token(AT);
          url = StringOrParameter();
          break;
          }
        default:
          jj_la1[715] = jj_gen;
          ;
        }
        break;
        }
      case USER:{
        errorStart = jj_consume_token(USER);
assertNotAlreadySet( username, errorStart, String.format(alreadySet, errorStart.image) );
        username = SymbolicNameOrStringParameter();
        break;
        }
      case PASSWORD:{
        errorStart = jj_consume_token(PASSWORD);
assertNotAlreadySet( password, errorStart, String.format(alreadySet, errorStart.image) );
        password = passwordExpression();
        break;
        }
      case DRIVER:{
        errorStart = jj_consume_token(DRIVER);
assertNotAlreadySet( driverSettings, errorStart, String.format(alreadySet, errorStart.image) );
        driverSettings = MapOrParameter();
        break;
        }
      case PROPERTIES:{
        errorStart = jj_consume_token(PROPERTIES);
assertNotAlreadySet( properties, errorStart, String.format(alreadySet, errorStart.image) );
        properties = MapOrParameter();
        break;
        }
      default:
        jj_la1[716] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DRIVER:
      case PASSWORD:
      case PROPERTIES:
      case TARGET:
      case USER:{
        break;
        }
      default:
        jj_la1[717] = jj_gen;
        break label_78;
      }
    }
if ( url == null && username == null && password == null && driverSettings == null )
        {
            {if ("" != null) return astFactory.alterLocalDatabaseAlias( pos( start ), aliasName.getLocalAliasName(astFactory), targetName == null ? null : targetName.getLocalAliasName(astFactory), ifExists, properties );}
        }
        else
        {
            {if ("" != null) return astFactory.alterRemoteDatabaseAlias( pos( start ), aliasName.getRemoteAliasName(astFactory), targetName == null ? null : targetName.getRemoteAliasName(astFactory),
                ifExists, url, username, password, driverSettings, properties );}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public STATEMENT ShowAliases(Token start, USE_CLAUSE useClause) throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> aliasName = null;
    WHERE where = null;
    YIELD yieldClause = null;
    RETURN_CLAUSE returnClause = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALIAS:{
      jj_consume_token(ALIAS);
      break;
      }
    case ALIASES:{
      jj_consume_token(ALIASES);
      break;
      }
    default:
      jj_la1[718] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_182(2147483647)) {
      aliasName = SymbolicAliasNameOrParameter();
    } else {
      ;
    }
    jj_consume_token(FOR);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATABASE:{
      jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      jj_consume_token(DATABASES);
      break;
      }
    default:
      jj_la1[719] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:
    case YIELD:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case YIELD:{
        yieldClause = YieldClause();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case RETURN:{
          returnClause = ReturnClause();
          break;
          }
        default:
          jj_la1[720] = jj_gen;
          ;
        }
        break;
        }
      case WHERE:{
        where = WhereClause();
        break;
        }
      default:
        jj_la1[721] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[722] = jj_gen;
      ;
    }
DATABASE_NAME maybeAliasName = aliasName == null ? null : aliasName.getLocalAliasName(astFactory);
        {if ("" != null) return astFactory.useGraph( astFactory.showAliases( pos( start ), maybeAliasName, yieldClause, returnClause, where), useClause );}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<DATABASE_NAME> SymbolicAliasNameList() throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> dbSymbol = null;
    List<DATABASE_NAME> databases = new ArrayList<>();
    dbSymbol = SymbolicAliasNameOrParameter();
databases.add(dbSymbol.getLocalAliasName(astFactory));
    label_79:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[723] = jj_gen;
        break label_79;
      }
      jj_consume_token(COMMA);
      dbSymbol = SymbolicAliasNameOrParameter();
databases.add(dbSymbol.getLocalAliasName(astFactory));
    }
{if ("" != null) return databases;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AliasName<DATABASE_NAME, PARAMETER> SymbolicAliasNameOrParameter() throws ParseException, Exception {AliasName<DATABASE_NAME, PARAMETER> name = null;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      name = SymbolicAliasName();
{if ("" != null) return name;}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return new AliasName<DATABASE_NAME, PARAMETER>( exceptionFactory, parameter );}
      break;
      }
    default:
      jj_la1[724] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AliasName<DATABASE_NAME, PARAMETER> SymbolicAliasName() throws ParseException, Exception {Token token;
    AliasName<DATABASE_NAME, PARAMETER> name = null;
    token = SymbolicNameString();
name = new AliasName<DATABASE_NAME, PARAMETER>( exceptionFactory, token );
    label_80:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        break;
        }
      default:
        jj_la1[725] = jj_gen;
        break label_80;
      }
      jj_consume_token(DOT);
      token = SymbolicNameString();
name.add( token );
    }
{if ("" != null) return name;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<SimpleEither<StringPos<POS>, PARAMETER>> SymbolicNameOrStringParameterList() throws ParseException {SimpleEither<StringPos<POS>, PARAMETER> entry;
    List<SimpleEither<StringPos<POS>, PARAMETER>> list = new ArrayList<>();
    entry = SymbolicNameOrStringParameter();
list.add( entry );
    label_81:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[726] = jj_gen;
        break label_81;
      }
      jj_consume_token(COMMA);
      entry = SymbolicNameOrStringParameter();
list.add( entry );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<StringPos<POS>, PARAMETER> SymbolicNameOrStringParameter() throws ParseException {Token name;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      name = SymbolicNameString();
{if ("" != null) return SimpleEither.<StringPos<POS>, PARAMETER>left( new StringPos<POS>( token.image, pos( token ), endPos( token ) ));}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return SimpleEither.<StringPos<POS>, PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[727] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String Glob() throws ParseException {String globString = "";
    String nextGlob = "";
    Token t = null;
    if (jj_2_183(2147483647)) {
      t = EscapedSymbolicNameString();
globString = t.image;
    } else if (jj_2_184(2147483647)) {
      t = EscapedSymbolicNameString();
globString = t.image;
      nextGlob = GlobRecursive();
globString += nextGlob;
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DOT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case QUESTION:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMES:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        globString = GlobRecursive();
        break;
        }
      default:
        jj_la1[728] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return globString;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String GlobRecursive() throws ParseException {String globString = "";
    String nextGlob = "";
    if (jj_2_185(2147483647)) {
      globString = GlobPart();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DOT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case QUESTION:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMES:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        globString = GlobPart();
        nextGlob = GlobRecursive();
globString += nextGlob;
        break;
        }
      default:
        jj_la1[729] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return globString;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String GlobPart() throws ParseException {String globPartString = null;
    Token globPart = null;
    if (jj_2_186(2147483647)) {
      jj_consume_token(DOT);
      globPart = EscapedSymbolicNameString();
globPartString = "." + globPart.image;
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case QUESTION:{
        jj_consume_token(QUESTION);
globPartString = "?";
        break;
        }
      case TIMES:{
        jj_consume_token(TIMES);
globPartString = "*";
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
globPartString = ".";
        break;
        }
      case ACCESS:
      case ACTIVE:
      case ADMIN:
      case ADMINISTRATOR:
      case ALIAS:
      case ALIASES:
      case ALL_SHORTEST_PATH:
      case ALL:
      case ALTER:
      case AND:
      case ANY:
      case ARRAY:
      case AS:
      case ASC:
      case ASCENDING:
      case ASSERT:
      case ASSIGN:
      case AT:
      case AUTH:
      case BINDINGS:
      case BOOL:
      case BOOLEAN:
      case BOOSTED:
      case BOTH:
      case BREAK:
      case BRIEF:
      case BTREE:
      case BUILT:
      case BY:
      case CALL:
      case CASCADE:
      case CASE:
      case CHANGE:
      case CIDR:
      case COLLECT:
      case COMMAND:
      case COMMANDS:
      case COMMIT:
      case COMPOSITE:
      case CONCURRENT:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTAINS:
      case COPY:
      case CONTINUE:
      case COUNT:
      case CREATE:
      case CSV:
      case CURRENT:
      case DATA:
      case DATABASE:
      case DATABASES:
      case DATE:
      case DATETIME:
      case DBMS:
      case DEALLOCATE:
      case DEFAULT_TOKEN:
      case DEFINED:
      case DELETE:
      case DENY:
      case DESC:
      case DESCENDING:
      case DESTROY:
      case DETACH:
      case DIFFERENT:
      case DISTINCT:
      case DRIVER:
      case DROP:
      case DRYRUN:
      case DUMP:
      case DURATION:
      case EACH:
      case EDGE:
      case ENABLE:
      case ELEMENT:
      case ELEMENTS:
      case ELSE:
      case ENCRYPTED:
      case END:
      case ENDS:
      case EXECUTABLE:
      case EXECUTE:
      case EXIST:
      case EXISTENCE:
      case EXISTS:
      case ERROR:
      case FAIL:
      case FALSE:
      case FIELDTERMINATOR:
      case FINISH:
      case FLOAT:
      case FOR:
      case FOREACH:
      case FROM:
      case FULLTEXT:
      case FUNCTION:
      case FUNCTIONS:
      case GRANT:
      case GRAPH:
      case GRAPHS:
      case GROUP:
      case GROUPS:
      case HEADERS:
      case HOME:
      case ID:
      case IF:
      case IMPERSONATE:
      case IMMUTABLE:
      case IN:
      case INDEX:
      case INDEXES:
      case INF:
      case INFINITY:
      case INSERT:
      case INT:
      case INTEGER:
      case IS:
      case JOIN:
      case KEY:
      case LABEL:
      case LABELS:
      case LEADING:
      case LIMITROWS:
      case LIST:
      case LOAD:
      case LOCAL:
      case LOOKUP:
      case MANAGEMENT:
      case MAP:
      case MATCH:
      case MERGE:
      case NAME:
      case NAMES:
      case NAN:
      case NFC:
      case NFD:
      case NFKC:
      case NFKD:
      case NEW:
      case NODE:
      case NODETACH:
      case NODES:
      case NONE:
      case NORMALIZE:
      case NORMALIZED:
      case NOT:
      case NOTHING:
      case NOWAIT:
      case NULL:
      case OF:
      case OFFSET:
      case ON:
      case ONLY:
      case OPTIONAL:
      case OPTIONS:
      case OPTION:
      case OR:
      case ORDER:
      case OUTPUT:
      case PASSWORD:
      case PASSWORDS:
      case PATH:
      case PATHS:
      case PERIODIC:
      case PLAINTEXT:
      case POINT:
      case POPULATED:
      case REPEATABLE:
      case PRIMARY:
      case PRIMARIES:
      case PRIVILEGE:
      case PRIVILEGES:
      case PROCEDURE:
      case PROCEDURES:
      case PROPERTIES:
      case PROPERTY:
      case PROVIDER:
      case PROVIDERS:
      case RANGE:
      case READ:
      case REALLOCATE:
      case REDUCE:
      case RENAME:
      case REL:
      case RELATIONSHIP:
      case RELATIONSHIPS:
      case REMOVE:
      case REPLACE:
      case REPORT:
      case REQUIRE:
      case REQUIRED:
      case RESTRICT:
      case RETURN:
      case REVOKE:
      case ROLE:
      case ROLES:
      case ROW:
      case ROWS:
      case SCAN:
      case SEC:
      case SECOND:
      case SECONDARY:
      case SECONDARIES:
      case SECONDS:
      case SEEK:
      case SERVER:
      case SERVERS:
      case SET:
      case SETTING:
      case SETTINGS:
      case SHORTEST_PATH:
      case SHORTEST:
      case SHOW:
      case SIGNED:
      case SINGLE:
      case SKIPROWS:
      case START:
      case STARTS:
      case STATUS:
      case STOP:
      case STRING:
      case SUPPORTED:
      case SUSPENDED:
      case TARGET:
      case TERMINATE:
      case TEXT:
      case THEN:
      case TIME:
      case TIMESTAMP:
      case TIMEZONE:
      case TO:
      case TOPOLOGY:
      case TRAILING:
      case TRANSACTION:
      case TRANSACTIONS:
      case TRAVERSE:
      case TRIM:
      case TRUE:
      case TYPE:
      case TYPED:
      case TYPES:
      case UNION:
      case UNIQUE:
      case UNIQUENESS:
      case UNWIND:
      case URL:
      case USE:
      case USER:
      case USERS:
      case USING:
      case VALUE:
      case VARCHAR:
      case VECTOR:
      case VERBOSE:
      case VERTEX:
      case WAIT:
      case WHEN:
      case WHERE:
      case WITH:
      case WITHOUT:
      case WRITE:
      case XOR:
      case YIELD:
      case ZONE:
      case ZONED:
      case IDENTIFIER:{
        globPart = UnescapedSymbolicNameString();
globPartString = globPart.image;
        break;
        }
      default:
        jj_la1[730] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return globPartString;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String StringImage() throws ParseException {Token t;
    t = StringToken();
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> StringList() throws ParseException {String entry;
    List<String> list = new ArrayList<>();
    entry = StringImage();
list.add( entry );
    label_82:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[731] = jj_gen;
        break label_82;
      }
      jj_consume_token(COMMA);
      entry = StringImage();
list.add( entry );
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token StringToken() throws ParseException {Token stringLiteral = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:{
      stringLiteral = jj_consume_token(STRING_LITERAL1);
      break;
      }
    case STRING_LITERAL2:{
      stringLiteral = jj_consume_token(STRING_LITERAL2);
      break;
      }
    default:
      jj_la1[732] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stringLiteral;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<String, PARAMETER> StringOrParameter() throws ParseException {Token token = null;
    PARAMETER parameter = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:{
      token = StringToken();
{if ("" != null) return SimpleEither.<String, PARAMETER>left( token.image );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.STRING);
{if ("" != null) return SimpleEither.<String, PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[733] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SimpleEither<Map<String, EXPRESSION>, PARAMETER> MapOrParameter() throws ParseException, Exception {Map<String, EXPRESSION> map = null;
    PARAMETER parameter;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LCURLY:{
      map = Map();
{if ("" != null) return SimpleEither.<Map<String,EXPRESSION>,PARAMETER>left ( map );}
      break;
      }
    case DOLLAR:{
      parameter = Parameter(ParameterType.MAP);
{if ("" != null) return SimpleEither.<Map<String,EXPRESSION>,PARAMETER>right( parameter );}
      break;
      }
    default:
      jj_la1[734] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Map<String, EXPRESSION> Map() throws ParseException, Exception {Token key;
    EXPRESSION expr;
    LinkedHashMap<String, EXPRESSION> map = new LinkedHashMap<>();
    jj_consume_token(LCURLY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      key = SymbolicNameString();
      jj_consume_token(COLON);
      expr = Expression();
map.put( key.image, expr );
      label_83:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[735] = jj_gen;
          break label_83;
        }
        jj_consume_token(COMMA);
        key = SymbolicNameString();
        jj_consume_token(COLON);
        expr = Expression();
map.put( key.image, expr );
      }
      break;
      }
    default:
      jj_la1[736] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return map;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<StringPos<POS>> SymbolicNamePositions() throws ParseException {List<StringPos<POS>> names = new ArrayList<>();
    SymbolicNameString();
names.add( new StringPos<>( token.image, pos( token ) ) );
    label_84:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[737] = jj_gen;
        break label_84;
      }
      jj_consume_token(COMMA);
      SymbolicNameString();
names.add( new StringPos<>( token.image, pos( token ) ) );
    }
{if ("" != null) return names;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token SymbolicNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:{
      t = EscapedSymbolicNameString();
      break;
      }
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NFC:
    case NFD:
    case NFKC:
    case NFKD:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NORMALIZED:
    case NOT:
    case NOTHING:
    case NOWAIT:
    case NULL:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPED:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      t = UnescapedSymbolicNameString();
      break;
      }
    default:
      jj_la1[738] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token EscapedSymbolicNameString() throws ParseException {Token t;
    t = jj_consume_token(ESCAPED_SYMBOLIC_NAME);
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token UnescapedSymbolicNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NOTHING:
    case NOWAIT:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      t = UnescapedLabelSymbolicNameString();
      break;
      }
    case NOT:{
      t = jj_consume_token(NOT);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    case TYPED:{
      t = jj_consume_token(TYPED);
      break;
      }
    case NORMALIZED:{
      t = jj_consume_token(NORMALIZED);
      break;
      }
    case NFC:{
      t = jj_consume_token(NFC);
      break;
      }
    case NFD:{
      t = jj_consume_token(NFD);
      break;
      }
    case NFKC:{
      t = jj_consume_token(NFKC);
      break;
      }
    case NFKD:{
      t = jj_consume_token(NFKD);
      break;
      }
    default:
      jj_la1[739] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

//used for IS
  final public Token SymbolicLabelNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ESCAPED_SYMBOLIC_NAME:{
      t = EscapedSymbolicNameString();
      break;
      }
    case ACCESS:
    case ACTIVE:
    case ADMIN:
    case ADMINISTRATOR:
    case ALIAS:
    case ALIASES:
    case ALL_SHORTEST_PATH:
    case ALL:
    case ALTER:
    case AND:
    case ANY:
    case ARRAY:
    case AS:
    case ASC:
    case ASCENDING:
    case ASSERT:
    case ASSIGN:
    case AT:
    case AUTH:
    case BINDINGS:
    case BOOL:
    case BOOLEAN:
    case BOOSTED:
    case BOTH:
    case BREAK:
    case BRIEF:
    case BTREE:
    case BUILT:
    case BY:
    case CALL:
    case CASCADE:
    case CASE:
    case CHANGE:
    case CIDR:
    case COLLECT:
    case COMMAND:
    case COMMANDS:
    case COMMIT:
    case COMPOSITE:
    case CONCURRENT:
    case CONSTRAINT:
    case CONSTRAINTS:
    case CONTAINS:
    case COPY:
    case CONTINUE:
    case COUNT:
    case CREATE:
    case CSV:
    case CURRENT:
    case DATA:
    case DATABASE:
    case DATABASES:
    case DATE:
    case DATETIME:
    case DBMS:
    case DEALLOCATE:
    case DEFAULT_TOKEN:
    case DEFINED:
    case DELETE:
    case DENY:
    case DESC:
    case DESCENDING:
    case DESTROY:
    case DETACH:
    case DIFFERENT:
    case DISTINCT:
    case DRIVER:
    case DROP:
    case DRYRUN:
    case DUMP:
    case DURATION:
    case EACH:
    case EDGE:
    case ENABLE:
    case ELEMENT:
    case ELEMENTS:
    case ELSE:
    case ENCRYPTED:
    case END:
    case ENDS:
    case EXECUTABLE:
    case EXECUTE:
    case EXIST:
    case EXISTENCE:
    case EXISTS:
    case ERROR:
    case FAIL:
    case FALSE:
    case FIELDTERMINATOR:
    case FINISH:
    case FLOAT:
    case FOR:
    case FOREACH:
    case FROM:
    case FULLTEXT:
    case FUNCTION:
    case FUNCTIONS:
    case GRANT:
    case GRAPH:
    case GRAPHS:
    case GROUP:
    case GROUPS:
    case HEADERS:
    case HOME:
    case ID:
    case IF:
    case IMPERSONATE:
    case IMMUTABLE:
    case IN:
    case INDEX:
    case INDEXES:
    case INF:
    case INFINITY:
    case INSERT:
    case INT:
    case INTEGER:
    case IS:
    case JOIN:
    case KEY:
    case LABEL:
    case LABELS:
    case LEADING:
    case LIMITROWS:
    case LIST:
    case LOAD:
    case LOCAL:
    case LOOKUP:
    case MANAGEMENT:
    case MAP:
    case MATCH:
    case MERGE:
    case NAME:
    case NAMES:
    case NAN:
    case NEW:
    case NODE:
    case NODETACH:
    case NODES:
    case NONE:
    case NORMALIZE:
    case NOTHING:
    case NOWAIT:
    case OF:
    case OFFSET:
    case ON:
    case ONLY:
    case OPTIONAL:
    case OPTIONS:
    case OPTION:
    case OR:
    case ORDER:
    case OUTPUT:
    case PASSWORD:
    case PASSWORDS:
    case PATH:
    case PATHS:
    case PERIODIC:
    case PLAINTEXT:
    case POINT:
    case POPULATED:
    case REPEATABLE:
    case PRIMARY:
    case PRIMARIES:
    case PRIVILEGE:
    case PRIVILEGES:
    case PROCEDURE:
    case PROCEDURES:
    case PROPERTIES:
    case PROPERTY:
    case PROVIDER:
    case PROVIDERS:
    case RANGE:
    case READ:
    case REALLOCATE:
    case REDUCE:
    case RENAME:
    case REL:
    case RELATIONSHIP:
    case RELATIONSHIPS:
    case REMOVE:
    case REPLACE:
    case REPORT:
    case REQUIRE:
    case REQUIRED:
    case RESTRICT:
    case RETURN:
    case REVOKE:
    case ROLE:
    case ROLES:
    case ROW:
    case ROWS:
    case SCAN:
    case SEC:
    case SECOND:
    case SECONDARY:
    case SECONDARIES:
    case SECONDS:
    case SEEK:
    case SERVER:
    case SERVERS:
    case SET:
    case SETTING:
    case SETTINGS:
    case SHORTEST_PATH:
    case SHORTEST:
    case SHOW:
    case SIGNED:
    case SINGLE:
    case SKIPROWS:
    case START:
    case STARTS:
    case STATUS:
    case STOP:
    case STRING:
    case SUPPORTED:
    case SUSPENDED:
    case TARGET:
    case TERMINATE:
    case TEXT:
    case THEN:
    case TIME:
    case TIMESTAMP:
    case TIMEZONE:
    case TO:
    case TOPOLOGY:
    case TRAILING:
    case TRANSACTION:
    case TRANSACTIONS:
    case TRAVERSE:
    case TRIM:
    case TRUE:
    case TYPE:
    case TYPES:
    case UNION:
    case UNIQUE:
    case UNIQUENESS:
    case UNWIND:
    case URL:
    case USE:
    case USER:
    case USERS:
    case USING:
    case VALUE:
    case VARCHAR:
    case VECTOR:
    case VERBOSE:
    case VERTEX:
    case WAIT:
    case WHEN:
    case WHERE:
    case WITH:
    case WITHOUT:
    case WRITE:
    case XOR:
    case YIELD:
    case ZONE:
    case ZONED:
    case IDENTIFIER:{
      t = UnescapedLabelSymbolicNameString();
      break;
      }
    default:
      jj_la1[740] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token UnescapedLabelSymbolicNameString() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    case ACCESS:{
      t = jj_consume_token(ACCESS);
      break;
      }
    case ACTIVE:{
      t = jj_consume_token(ACTIVE);
      break;
      }
    case ADMIN:{
      t = jj_consume_token(ADMIN);
      break;
      }
    case ADMINISTRATOR:{
      t = jj_consume_token(ADMINISTRATOR);
      break;
      }
    case ALIAS:{
      t = jj_consume_token(ALIAS);
      break;
      }
    case ALIASES:{
      t = jj_consume_token(ALIASES);
      break;
      }
    case ALL_SHORTEST_PATH:{
      t = jj_consume_token(ALL_SHORTEST_PATH);
      break;
      }
    case ALL:{
      t = jj_consume_token(ALL);
      break;
      }
    case ALTER:{
      t = jj_consume_token(ALTER);
      break;
      }
    case AND:{
      t = jj_consume_token(AND);
      break;
      }
    case ANY:{
      t = jj_consume_token(ANY);
      break;
      }
    case ARRAY:{
      t = jj_consume_token(ARRAY);
      break;
      }
    case AS:{
      t = jj_consume_token(AS);
      break;
      }
    case ASC:{
      t = jj_consume_token(ASC);
      break;
      }
    case ASCENDING:{
      t = jj_consume_token(ASCENDING);
      break;
      }
    case ASSERT:{
      t = jj_consume_token(ASSERT);
      break;
      }
    case ASSIGN:{
      t = jj_consume_token(ASSIGN);
      break;
      }
    case AT:{
      t = jj_consume_token(AT);
      break;
      }
    case AUTH:{
      t = jj_consume_token(AUTH);
      break;
      }
    case BINDINGS:{
      t = jj_consume_token(BINDINGS);
      break;
      }
    case BOOL:{
      t = jj_consume_token(BOOL);
      break;
      }
    case BOOLEAN:{
      t = jj_consume_token(BOOLEAN);
      break;
      }
    case BOOSTED:{
      t = jj_consume_token(BOOSTED);
      break;
      }
    case BOTH:{
      t = jj_consume_token(BOTH);
      break;
      }
    case BREAK:{
      t = jj_consume_token(BREAK);
      break;
      }
    case BRIEF:{
      t = jj_consume_token(BRIEF);
      break;
      }
    case BTREE:{
      t = jj_consume_token(BTREE);
      break;
      }
    case BUILT:{
      t = jj_consume_token(BUILT);
      break;
      }
    case BY:{
      t = jj_consume_token(BY);
      break;
      }
    case CALL:{
      t = jj_consume_token(CALL);
      break;
      }
    case CASCADE:{
      t = jj_consume_token(CASCADE);
      break;
      }
    case CASE:{
      t = jj_consume_token(CASE);
      break;
      }
    case CHANGE:{
      t = jj_consume_token(CHANGE);
      break;
      }
    case CIDR:{
      t = jj_consume_token(CIDR);
      break;
      }
    case COLLECT:{
      t = jj_consume_token(COLLECT);
      break;
      }
    case COMMAND:{
      t = jj_consume_token(COMMAND);
      break;
      }
    case COMMANDS:{
      t = jj_consume_token(COMMANDS);
      break;
      }
    case COMMIT:{
      t = jj_consume_token(COMMIT);
      break;
      }
    case COMPOSITE:{
      t = jj_consume_token(COMPOSITE);
      break;
      }
    case CONCURRENT:{
      t = jj_consume_token(CONCURRENT);
      break;
      }
    case CONSTRAINT:{
      t = jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      t = jj_consume_token(CONSTRAINTS);
      break;
      }
    case CONTAINS:{
      t = jj_consume_token(CONTAINS);
      break;
      }
    case CONTINUE:{
      t = jj_consume_token(CONTINUE);
      break;
      }
    case COPY:{
      t = jj_consume_token(COPY);
      break;
      }
    case COUNT:{
      t = jj_consume_token(COUNT);
      break;
      }
    case CREATE:{
      t = jj_consume_token(CREATE);
      break;
      }
    case CSV:{
      t = jj_consume_token(CSV);
      break;
      }
    case CURRENT:{
      t = jj_consume_token(CURRENT);
      break;
      }
    case DATA:{
      t = jj_consume_token(DATA);
      break;
      }
    case DATABASE:{
      t = jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      t = jj_consume_token(DATABASES);
      break;
      }
    case DATE:{
      t = jj_consume_token(DATE);
      break;
      }
    case DATETIME:{
      t = jj_consume_token(DATETIME);
      break;
      }
    case DBMS:{
      t = jj_consume_token(DBMS);
      break;
      }
    case DEALLOCATE:{
      t = jj_consume_token(DEALLOCATE);
      break;
      }
    case DEFAULT_TOKEN:{
      t = jj_consume_token(DEFAULT_TOKEN);
      break;
      }
    case DEFINED:{
      t = jj_consume_token(DEFINED);
      break;
      }
    case DELETE:{
      t = jj_consume_token(DELETE);
      break;
      }
    case DENY:{
      t = jj_consume_token(DENY);
      break;
      }
    case DESC:{
      t = jj_consume_token(DESC);
      break;
      }
    case DESCENDING:{
      t = jj_consume_token(DESCENDING);
      break;
      }
    case DESTROY:{
      t = jj_consume_token(DESTROY);
      break;
      }
    case DETACH:{
      t = jj_consume_token(DETACH);
      break;
      }
    case DIFFERENT:{
      t = jj_consume_token(DIFFERENT);
      break;
      }
    case DISTINCT:{
      t = jj_consume_token(DISTINCT);
      break;
      }
    case DRIVER:{
      t = jj_consume_token(DRIVER);
      break;
      }
    case DROP:{
      t = jj_consume_token(DROP);
      break;
      }
    case DRYRUN:{
      t = jj_consume_token(DRYRUN);
      break;
      }
    case DUMP:{
      t = jj_consume_token(DUMP);
      break;
      }
    case DURATION:{
      t = jj_consume_token(DURATION);
      break;
      }
    case EACH:{
      t = jj_consume_token(EACH);
      break;
      }
    case EDGE:{
      t = jj_consume_token(EDGE);
      break;
      }
    case ELEMENT:{
      t = jj_consume_token(ELEMENT);
      break;
      }
    case ELEMENTS:{
      t = jj_consume_token(ELEMENTS);
      break;
      }
    case ELSE:{
      t = jj_consume_token(ELSE);
      break;
      }
    case ENABLE:{
      t = jj_consume_token(ENABLE);
      break;
      }
    case ENCRYPTED:{
      t = jj_consume_token(ENCRYPTED);
      break;
      }
    case END:{
      t = jj_consume_token(END);
      break;
      }
    case ENDS:{
      t = jj_consume_token(ENDS);
      break;
      }
    case ERROR:{
      t = jj_consume_token(ERROR);
      break;
      }
    case EXECUTABLE:{
      t = jj_consume_token(EXECUTABLE);
      break;
      }
    case EXECUTE:{
      t = jj_consume_token(EXECUTE);
      break;
      }
    case EXIST:{
      t = jj_consume_token(EXIST);
      break;
      }
    case EXISTENCE:{
      t = jj_consume_token(EXISTENCE);
      break;
      }
    case EXISTS:{
      t = jj_consume_token(EXISTS);
      break;
      }
    case FAIL:{
      t = jj_consume_token(FAIL);
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
      break;
      }
    case FIELDTERMINATOR:{
      t = jj_consume_token(FIELDTERMINATOR);
      break;
      }
    case FINISH:{
      t = jj_consume_token(FINISH);
      break;
      }
    case FLOAT:{
      t = jj_consume_token(FLOAT);
      break;
      }
    case FOREACH:{
      t = jj_consume_token(FOREACH);
      break;
      }
    case FOR:{
      t = jj_consume_token(FOR);
      break;
      }
    case FROM:{
      t = jj_consume_token(FROM);
      break;
      }
    case FULLTEXT:{
      t = jj_consume_token(FULLTEXT);
      break;
      }
    case FUNCTION:{
      t = jj_consume_token(FUNCTION);
      break;
      }
    case FUNCTIONS:{
      t = jj_consume_token(FUNCTIONS);
      break;
      }
    case GRANT:{
      t = jj_consume_token(GRANT);
      break;
      }
    case GRAPH:{
      t = jj_consume_token(GRAPH);
      break;
      }
    case GRAPHS:{
      t = jj_consume_token(GRAPHS);
      break;
      }
    case GROUP:{
      t = jj_consume_token(GROUP);
      break;
      }
    case GROUPS:{
      t = jj_consume_token(GROUPS);
      break;
      }
    case HEADERS:{
      t = jj_consume_token(HEADERS);
      break;
      }
    case HOME:{
      t = jj_consume_token(HOME);
      break;
      }
    case ID:{
      t = jj_consume_token(ID);
      break;
      }
    case IF:{
      t = jj_consume_token(IF);
      break;
      }
    case IMMUTABLE:{
      t = jj_consume_token(IMMUTABLE);
      break;
      }
    case IN:{
      t = jj_consume_token(IN);
      break;
      }
    case INDEX:{
      t = jj_consume_token(INDEX);
      break;
      }
    case INDEXES:{
      t = jj_consume_token(INDEXES);
      break;
      }
    case INF:{
      t = jj_consume_token(INF);
      break;
      }
    case INFINITY:{
      t = jj_consume_token(INFINITY);
      break;
      }
    case INSERT:{
      t = jj_consume_token(INSERT);
      break;
      }
    case INT:{
      t = jj_consume_token(INT);
      break;
      }
    case INTEGER:{
      t = jj_consume_token(INTEGER);
      break;
      }
    case IMPERSONATE:{
      t = jj_consume_token(IMPERSONATE);
      break;
      }
    case IS:{
      t = jj_consume_token(IS);
      break;
      }
    case JOIN:{
      t = jj_consume_token(JOIN);
      break;
      }
    case KEY:{
      t = jj_consume_token(KEY);
      break;
      }
    case LABEL:{
      t = jj_consume_token(LABEL);
      break;
      }
    case LABELS:{
      t = jj_consume_token(LABELS);
      break;
      }
    case LEADING:{
      t = jj_consume_token(LEADING);
      break;
      }
    case LIMITROWS:{
      t = jj_consume_token(LIMITROWS);
      break;
      }
    case LIST:{
      t = jj_consume_token(LIST);
      break;
      }
    case LOAD:{
      t = jj_consume_token(LOAD);
      break;
      }
    case LOCAL:{
      t = jj_consume_token(LOCAL);
      break;
      }
    case LOOKUP:{
      t = jj_consume_token(LOOKUP);
      break;
      }
    case MATCH:{
      t = jj_consume_token(MATCH);
      break;
      }
    case MANAGEMENT:{
      t = jj_consume_token(MANAGEMENT);
      break;
      }
    case MAP:{
      t = jj_consume_token(MAP);
      break;
      }
    case MERGE:{
      t = jj_consume_token(MERGE);
      break;
      }
    case NAME:{
      t = jj_consume_token(NAME);
      break;
      }
    case NAMES:{
      t = jj_consume_token(NAMES);
      break;
      }
    case NAN:{
      t = jj_consume_token(NAN);
      break;
      }
    case NEW:{
      t = jj_consume_token(NEW);
      break;
      }
    case NODE:{
      t = jj_consume_token(NODE);
      break;
      }
    case NODETACH:{
      t = jj_consume_token(NODETACH);
      break;
      }
    case NODES:{
      t = jj_consume_token(NODES);
      break;
      }
    case NONE:{
      t = jj_consume_token(NONE);
      break;
      }
    case NORMALIZE:{
      t = jj_consume_token(NORMALIZE);
      break;
      }
    case NOTHING:{
      t = jj_consume_token(NOTHING);
      break;
      }
    case NOWAIT:{
      t = jj_consume_token(NOWAIT);
      break;
      }
    case OF:{
      t = jj_consume_token(OF);
      break;
      }
    case OFFSET:{
      t = jj_consume_token(OFFSET);
      break;
      }
    case ON:{
      t = jj_consume_token(ON);
      break;
      }
    case ONLY:{
      t = jj_consume_token(ONLY);
      break;
      }
    case OPTIONAL:{
      t = jj_consume_token(OPTIONAL);
      break;
      }
    case OPTIONS:{
      t = jj_consume_token(OPTIONS);
      break;
      }
    case OPTION:{
      t = jj_consume_token(OPTION);
      break;
      }
    case OR:{
      t = jj_consume_token(OR);
      break;
      }
    case ORDER:{
      t = jj_consume_token(ORDER);
      break;
      }
    case OUTPUT:{
      t = jj_consume_token(OUTPUT);
      break;
      }
    case PASSWORD:{
      t = jj_consume_token(PASSWORD);
      break;
      }
    case PASSWORDS:{
      t = jj_consume_token(PASSWORDS);
      break;
      }
    case PATH:{
      t = jj_consume_token(PATH);
      break;
      }
    case PATHS:{
      t = jj_consume_token(PATHS);
      break;
      }
    case PERIODIC:{
      t = jj_consume_token(PERIODIC);
      break;
      }
    case PLAINTEXT:{
      t = jj_consume_token(PLAINTEXT);
      break;
      }
    case POINT:{
      t = jj_consume_token(POINT);
      break;
      }
    case POPULATED:{
      t = jj_consume_token(POPULATED);
      break;
      }
    case PRIMARY:{
      t = jj_consume_token(PRIMARY);
      break;
      }
    case PRIMARIES:{
      t = jj_consume_token(PRIMARIES);
      break;
      }
    case PRIVILEGE:{
      t = jj_consume_token(PRIVILEGE);
      break;
      }
    case PRIVILEGES:{
      t = jj_consume_token(PRIVILEGES);
      break;
      }
    case PROCEDURE:{
      t = jj_consume_token(PROCEDURE);
      break;
      }
    case PROCEDURES:{
      t = jj_consume_token(PROCEDURES);
      break;
      }
    case PROPERTIES:{
      t = jj_consume_token(PROPERTIES);
      break;
      }
    case PROPERTY:{
      t = jj_consume_token(PROPERTY);
      break;
      }
    case PROVIDER:{
      t = jj_consume_token(PROVIDER);
      break;
      }
    case PROVIDERS:{
      t = jj_consume_token(PROVIDERS);
      break;
      }
    case RANGE:{
      t = jj_consume_token(RANGE);
      break;
      }
    case READ:{
      t = jj_consume_token(READ);
      break;
      }
    case REALLOCATE:{
      t = jj_consume_token(REALLOCATE);
      break;
      }
    case REDUCE:{
      t = jj_consume_token(REDUCE);
      break;
      }
    case REL:{
      t = jj_consume_token(REL);
      break;
      }
    case RELATIONSHIP:{
      t = jj_consume_token(RELATIONSHIP);
      break;
      }
    case RELATIONSHIPS:{
      t = jj_consume_token(RELATIONSHIPS);
      break;
      }
    case REMOVE:{
      t = jj_consume_token(REMOVE);
      break;
      }
    case RENAME:{
      t = jj_consume_token(RENAME);
      break;
      }
    case REPEATABLE:{
      t = jj_consume_token(REPEATABLE);
      break;
      }
    case REPLACE:{
      t = jj_consume_token(REPLACE);
      break;
      }
    case REPORT:{
      t = jj_consume_token(REPORT);
      break;
      }
    case REQUIRE:{
      t = jj_consume_token(REQUIRE);
      break;
      }
    case REQUIRED:{
      t = jj_consume_token(REQUIRED);
      break;
      }
    case RESTRICT:{
      t = jj_consume_token(RESTRICT);
      break;
      }
    case RETURN:{
      t = jj_consume_token(RETURN);
      break;
      }
    case REVOKE:{
      t = jj_consume_token(REVOKE);
      break;
      }
    case ROLE:{
      t = jj_consume_token(ROLE);
      break;
      }
    case ROLES:{
      t = jj_consume_token(ROLES);
      break;
      }
    case ROW:{
      t = jj_consume_token(ROW);
      break;
      }
    case ROWS:{
      t = jj_consume_token(ROWS);
      break;
      }
    case SCAN:{
      t = jj_consume_token(SCAN);
      break;
      }
    case SEC:{
      t = jj_consume_token(SEC);
      break;
      }
    case SECOND:{
      t = jj_consume_token(SECOND);
      break;
      }
    case SECONDARY:{
      t = jj_consume_token(SECONDARY);
      break;
      }
    case SECONDARIES:{
      t = jj_consume_token(SECONDARIES);
      break;
      }
    case SECONDS:{
      t = jj_consume_token(SECONDS);
      break;
      }
    case SEEK:{
      t = jj_consume_token(SEEK);
      break;
      }
    case SERVER:{
      t = jj_consume_token(SERVER);
      break;
      }
    case SERVERS:{
      t = jj_consume_token(SERVERS);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    case SETTING:{
      t = jj_consume_token(SETTING);
      break;
      }
    case SETTINGS:{
      t = jj_consume_token(SETTINGS);
      break;
      }
    case SHORTEST:{
      t = jj_consume_token(SHORTEST);
      break;
      }
    case SHORTEST_PATH:{
      t = jj_consume_token(SHORTEST_PATH);
      break;
      }
    case SHOW:{
      t = jj_consume_token(SHOW);
      break;
      }
    case SIGNED:{
      t = jj_consume_token(SIGNED);
      break;
      }
    case SINGLE:{
      t = jj_consume_token(SINGLE);
      break;
      }
    case SKIPROWS:{
      t = jj_consume_token(SKIPROWS);
      break;
      }
    case START:{
      t = jj_consume_token(START);
      break;
      }
    case STARTS:{
      t = jj_consume_token(STARTS);
      break;
      }
    case STATUS:{
      t = jj_consume_token(STATUS);
      break;
      }
    case STOP:{
      t = jj_consume_token(STOP);
      break;
      }
    case STRING:{
      t = jj_consume_token(STRING);
      break;
      }
    case SUPPORTED:{
      t = jj_consume_token(SUPPORTED);
      break;
      }
    case SUSPENDED:{
      t = jj_consume_token(SUSPENDED);
      break;
      }
    case TARGET:{
      t = jj_consume_token(TARGET);
      break;
      }
    case TERMINATE:{
      t = jj_consume_token(TERMINATE);
      break;
      }
    case TEXT:{
      t = jj_consume_token(TEXT);
      break;
      }
    case THEN:{
      t = jj_consume_token(THEN);
      break;
      }
    case TIME:{
      t = jj_consume_token(TIME);
      break;
      }
    case TIMESTAMP:{
      t = jj_consume_token(TIMESTAMP);
      break;
      }
    case TIMEZONE:{
      t = jj_consume_token(TIMEZONE);
      break;
      }
    case TO:{
      t = jj_consume_token(TO);
      break;
      }
    case TOPOLOGY:{
      t = jj_consume_token(TOPOLOGY);
      break;
      }
    case TRAILING:{
      t = jj_consume_token(TRAILING);
      break;
      }
    case TRANSACTION:{
      t = jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSACTIONS:{
      t = jj_consume_token(TRANSACTIONS);
      break;
      }
    case TRAVERSE:{
      t = jj_consume_token(TRAVERSE);
      break;
      }
    case TRIM:{
      t = jj_consume_token(TRIM);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
      break;
      }
    case TYPE:{
      t = jj_consume_token(TYPE);
      break;
      }
    case TYPES:{
      t = jj_consume_token(TYPES);
      break;
      }
    case UNION:{
      t = jj_consume_token(UNION);
      break;
      }
    case UNIQUE:{
      t = jj_consume_token(UNIQUE);
      break;
      }
    case UNIQUENESS:{
      t = jj_consume_token(UNIQUENESS);
      break;
      }
    case UNWIND:{
      t = jj_consume_token(UNWIND);
      break;
      }
    case URL:{
      t = jj_consume_token(URL);
      break;
      }
    case USE:{
      t = jj_consume_token(USE);
      break;
      }
    case USER:{
      t = jj_consume_token(USER);
      break;
      }
    case USERS:{
      t = jj_consume_token(USERS);
      break;
      }
    case USING:{
      t = jj_consume_token(USING);
      break;
      }
    case VALUE:{
      t = jj_consume_token(VALUE);
      break;
      }
    case VARCHAR:{
      t = jj_consume_token(VARCHAR);
      break;
      }
    case VECTOR:{
      t = jj_consume_token(VECTOR);
      break;
      }
    case VERBOSE:{
      t = jj_consume_token(VERBOSE);
      break;
      }
    case VERTEX:{
      t = jj_consume_token(VERTEX);
      break;
      }
    case WAIT:{
      t = jj_consume_token(WAIT);
      break;
      }
    case WHEN:{
      t = jj_consume_token(WHEN);
      break;
      }
    case WHERE:{
      t = jj_consume_token(WHERE);
      break;
      }
    case WITH:{
      t = jj_consume_token(WITH);
      break;
      }
    case WITHOUT:{
      t = jj_consume_token(WITHOUT);
      break;
      }
    case WRITE:{
      t = jj_consume_token(WRITE);
      break;
      }
    case XOR:{
      t = jj_consume_token(XOR);
      break;
      }
    case YIELD:{
      t = jj_consume_token(YIELD);
      break;
      }
    case ZONE:{
      t = jj_consume_token(ZONE);
      break;
      }
    case ZONED:{
      t = jj_consume_token(ZONED);
      break;
      }
    default:
      jj_la1[741] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (DeprecatedChars.containsDeprecatedChar(t.image)) {
            for (var depChar : DeprecatedChars.deprecatedChars(t.image)) {
                astFactory.addDeprecatedIdentifierUnicodeNotification(pos(t), (char) depChar, t.image);
            }
        }
        {if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

// used in tests
  final public void EndOfFile() throws ParseException {
    jj_consume_token(0);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_2_155(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_155()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  private boolean jj_2_156(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_156()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  private boolean jj_2_157(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_157()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  private boolean jj_2_158(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_158()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  private boolean jj_2_159(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_159()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  private boolean jj_2_160(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_160()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  private boolean jj_2_161(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_161()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  private boolean jj_2_162(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_162()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  private boolean jj_2_163(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_163()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  private boolean jj_2_164(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_164()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  private boolean jj_2_165(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_165()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  private boolean jj_2_166(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_166()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  private boolean jj_2_167(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_167()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  private boolean jj_2_168(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_168()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  private boolean jj_2_169(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_169()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  private boolean jj_2_170(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_170()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  private boolean jj_2_171(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_171()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  private boolean jj_2_172(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_172()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  private boolean jj_2_173(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_173()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  private boolean jj_2_174(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_174()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  private boolean jj_2_175(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_175()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  private boolean jj_2_176(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_176()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  private boolean jj_2_177(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_177()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  private boolean jj_2_178(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_178()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  private boolean jj_2_179(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_179()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  private boolean jj_2_180(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_180()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  private boolean jj_2_181(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_181()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  private boolean jj_2_182(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_182()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  private boolean jj_2_183(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_183()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  private boolean jj_2_184(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_184()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  private boolean jj_2_185(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_185()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  private boolean jj_2_186(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_186()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  private boolean jj_3_15()
 {
    if (jj_3R_91()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_91()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_721()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_774()) jj_scanpos = xsp;
    if (jj_scan_token(DELETE)) return true;
    if (jj_3R_96()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_807()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(NONE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_92()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_774()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_796()) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) return true;
    }
    return false;
  }

  private boolean jj_3R_796()
 {
    if (jj_scan_token(DETACH)) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(SINGLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_92()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_192()) jj_scanpos = xsp;
    if (jj_scan_token(MATCH)) return true;
    xsp = jj_scanpos;
    if (jj_3_18()) jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    if (jj_3R_812()) return true;
    xsp = jj_scanpos;
    if (jj_3R_813()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(OPTIONAL)) return true;
    return false;
  }

  private boolean jj_3R_811()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_810()) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(NORMALIZE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_96()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) return true;
    }
    return false;
  }

  private boolean jj_3R_438()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_3R_527()) {
    jj_scanpos = xsp;
    if (jj_3R_528()) {
    jj_scanpos = xsp;
    if (jj_3R_529()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(REPEATABLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(DIFFERENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_527()
 {
    if (jj_scan_token(NFD)) return true;
    return false;
  }

  private boolean jj_3R_528()
 {
    if (jj_scan_token(NFKC)) return true;
    return false;
  }

  private boolean jj_3R_529()
 {
    if (jj_scan_token(NFKD)) return true;
    return false;
  }

  private boolean jj_3R_812()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_838()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(TRIM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_439()) {
    jj_scanpos = xsp;
    if (jj_3R_440()) {
    jj_scanpos = xsp;
    if (jj_3R_441()) {
    jj_scanpos = xsp;
    if (jj_3R_442()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_838()
 {
    if (jj_scan_token(USING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_863()) {
    jj_scanpos = xsp;
    if (jj_3R_864()) {
    jj_scanpos = xsp;
    if (jj_3R_865()) {
    jj_scanpos = xsp;
    if (jj_3R_866()) {
    jj_scanpos = xsp;
    if (jj_3R_867()) {
    jj_scanpos = xsp;
    if (jj_3R_868()) {
    jj_scanpos = xsp;
    if (jj_3R_869()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(ELEMENT)) return true;
    if (jj_scan_token(BINDINGS)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(RELATIONSHIP)) return true;
    if (jj_scan_token(BINDINGS)) return true;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_3R_530()) {
    jj_scanpos = xsp;
    if (jj_3R_531()) return true;
    }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_441()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_3R_532()) {
    jj_scanpos = xsp;
    if (jj_3R_533()) return true;
    }
    }
    if (jj_3R_96()) return true;
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_863()
 {
    if (jj_scan_token(INDEX)) return true;
    if (jj_3R_910()) return true;
    return false;
  }

  private boolean jj_3R_864()
 {
    if (jj_scan_token(BTREE)) return true;
    if (jj_scan_token(INDEX)) return true;
    if (jj_