/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.addUniquenessPredicates$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\tY\u0012\t\u001a3V]&\fX/\u001a8fgN\u0004&/\u001a3jG\u0006$Xm\u001d+fgRT!a\u0001\u0003\u0002\u0013I,wO]5uKJ\u001c(BA\u0003\u0007\u0003\r\t7\u000f\u001e\u0006\u0003\u000f!\tAA^\u001a`i)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!R\u0004\u0005\u0002\u001675\taC\u0003\u0002\u00181\u0005aA/Z:u?\",G\u000e]3sg*\u0011q!\u0007\u0006\u00035)\tA!\u001e;jY&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tqr$D\u0001\u0003\u0013\t\u0001#AA\u0006SK^\u0014\u0018\u000e^3UKN$\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\tq\u0002\u0001C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002#I,wO]5uKJ,f\u000eZ3s)\u0016\u001cH/F\u0001)!\tI3H\u0004\u0002+s9\u00111\u0006\u000f\b\u0003Y]r!!\f\u001c\u000f\u00059*dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011$#\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005iQ\u0011BA\u0004\u001a\u0013\tQ\u0004$A\u0004qC\u000e\\\u0017mZ3\n\u0005qj$\u0001\u0003*foJLG/\u001a:\u000b\u0005iB\u0002BB \u0001A\u0003%\u0001&\u0001\nsK^\u0014\u0018\u000e^3s+:$WM\u001d+fgR\u0004\u0003")
public class AddUniquenessPredicatesTest
extends CypherFunSuite
implements RewriteTest {
    private final Function1<Object, Object> rewriterUnderTest;

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        RewriteTest$class.assertRewrite(this, originalQuery, expectedQuery);
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    public AddUniquenessPredicatesTest() {
        RewriteTest$class.$init$(this);
        this.test("does not introduce predicate not needed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten("RETURN 42");
                this.$outer.assertIsNotRewritten("MATCH n RETURN n");
                this.$outer.assertIsNotRewritten("MATCH (n)-[r1]->(m) RETURN n");
                this.$outer.assertIsNotRewritten("MATCH (n)-[r1]->(m) MATCH (m)-[r2]->(x) RETURN x");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("uniqueness check is done between relationships of simple and variable pattern lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2*0..1]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2*0..1]->(c) WHERE NONE(r2 IN r2 WHERE r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1*0..1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1*0..1]->(b)-[r2]->(c) WHERE NONE(r1 IN r1 WHERE r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1*0..1]->(b)-[r2*0..1]->(c) RETURN *", "MATCH (a)-[r1*0..1]->(b)-[r2*0..1]->(c) WHERE NONE(r1 IN r1 WHERE ANY(r2 IN r2 WHERE r1 = r2)) RETURN *");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("uniqueness check is done between relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c)-[r3]->(d) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c)-[r3]->(d) WHERE not(r2 = r3) AND not(r1 = r3) AND not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), (b)-[r2]->(c), (c)-[r3]->(d) RETURN *", "MATCH (a)-[r1]->(b), (b)-[r2]->(c), (c)-[r3]->(d) WHERE not(r1 = r2) AND not(r1 = r3) AND not(r2 = r3) RETURN *");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("no uniqueness check between relationships of different type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1:X]->(b)-[r2:Y]->(c) RETURN *", "MATCH (a)-[r1:X]->(b)-[r2:Y]->(c) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1:X]->(b)-[r2:X|Y]->(c) RETURN *", "MATCH (a)-[r1:X]->(b)-[r2:X|Y]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2:X]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2:X]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ignores shortestPath relationships for uniqueness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), shortestPath((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b), shortestPath((a)-[r]->(b)) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c), shortestPath((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c), shortestPath((a)-[r]->(b)) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ignores allShortestPaths relationships for uniqueness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), allShortestPaths((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b), allShortestPaths((a)-[r]->(b)) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c), allShortestPaths((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c), allShortestPaths((a)-[r]->(b)) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.rewriterUnderTest = addUniquenessPredicates$.MODULE$;
    }
}

