/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_4.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_4.parser.ParserFixture$;
import org.neo4j.cypher.internal.frontend.v3_4.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_4.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_4.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.Rewritable;
import org.neo4j.cypher.internal.util.v3_4.Rewritable$;
import org.neo4j.cypher.internal.util.v3_4.inSequence$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Equals;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_4.expressions.LabelName;
import org.neo4j.cypher.internal.v3_4.expressions.LessThan;
import org.neo4j.cypher.internal.v3_4.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001'\tqQ\t\u001f9b]\u0012\u001cF/\u0019:UKN$(BA\u0002\u0005\u0003%\u0011Xm\u001e:ji\u0016\u00148O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<4?RR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A#\b\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001B;uS2L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uKB\u0011adI\u0007\u0002?)\u0011Q\u0001\t\u0006\u0003\u000f\u0005R!A\t\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001J\u0010\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0015\u0001\u001b\u0005\u0011\u0001\"B\u0016\u0001\t\u0013a\u0013!D1tg\u0016\u0014HOU3xe&$X\rF\u0002.gq\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\")AG\u000ba\u0001k\u0005iqN]5hS:\fG.U;fef\u0004\"AN\u001d\u000f\u00059:\u0014B\u0001\u001d0\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005az\u0003\"B\u001f+\u0001\u0004)\u0014!D3ya\u0016\u001cG/\u001a3Rk\u0016\u0014\u0018\u0010C\u0003@\u0001\u0011%\u0001)A\u0006qe\u0016\u0004(+Z<sSR,GCA!E!\tq\")\u0003\u0002D?\tI1\u000b^1uK6,g\u000e\u001e\u0005\u0006\u000bz\u0002\r!N\u0001\u0002c\u0002")
public class ExpandStarTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public void org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.prepRewrite(originalQuery);
        Statement expected = this.prepRewrite(expectedQuery);
        SemanticCheckResult checkResult = (SemanticCheckResult)original.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        expandStar rewriter = new expandStar(checkResult.state());
        Object result = Rewritable.RewritableAny$.MODULE$.rewrite$extension0(Rewritable$.MODULE$.RewritableAny((Object)original), (Function1)rewriter);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    private Statement prepRewrite(String q) {
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(q, (Option)new Some((Object)this.pos()));
        Function1 rewriter = inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)}));
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(q, ParserFixture$.MODULE$.parser().parse$default$2())), rewriter);
    }

    public ExpandStarTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("rewrites * in return", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n) return *", "match (n) return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n),(c) return *", "match (n),(c) return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-->(c) return *", "match (n)-->(c) return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) return *", "match (n)-[r]->(c) return c,n,r");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) return *", "create (n) return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) return *", "match p = shortestPath((a)-[r*]->(x)) return a,p,r,x");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match p=(a:Start)-->(b) return *", "match p=(a:Start)-->(b) return a, b, p");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrites * in with", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n) with * return n", "match (n) with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n),(c) with * return n", "match (n),(c) with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-->(c) with * return n", "match (n)-->(c) with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) with * return n", "match (n)-[r]->(c) with c,n,r return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) with *, r.pi as x return n", "match (n)-[r]->(c) with c, n, r, r.pi as x return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) with * return n", "create (n) with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) with * return p", "match p = shortestPath((a)-[r*]->(x)) with a,p,r,x return p");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("symbol shadowing should be taken into account", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("match a,x,y with a match (b) return *", "match a,x,y with a match (b) return a, b");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("expands _PRAGMA WITHOUT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH a,x,y _PRAGMA WITHOUT a MATCH b RETURN *", "MATCH a,x,y WITH x, y MATCH b RETURN b, x, y");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keeps listed items during expand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH (n) WITH *, 1 AS b RETURN *", "MATCH (n) WITH n, 1 AS b RETURN b, n");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

