/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.foldConstants$;
import org.neo4j.cypher.internal.frontend.v3_4.helpers.fixedPoint$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\t\tbi\u001c7e\u0007>t7\u000f^1oiN$Vm\u001d;\u000b\u0005\r!\u0011!\u0003:foJLG/\u001a:t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u001ct\f\u000e\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u0015;A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\tU$\u0018\u000e\\\u0005\u00039Y\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tY!+Z<sSR,G+Z:u\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002\u001f\u0001!9a\u0005\u0001b\u0001\n\u00039\u0013!\u0005:foJLG/\u001a:V]\u0012,'\u000fV3tiV\t\u0001\u0006\u0005\u0002*w9\u0011!&\u000f\b\u0003War!\u0001L\u001c\u000f\u000552dB\u0001\u00186\u001d\tyCG\u0004\u00021g5\t\u0011G\u0003\u00023%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011B\u0001\u000e\u000b\u0013\t9\u0011$\u0003\u0002;1\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001f>\u0005!\u0011Vm\u001e:ji\u0016\u0014(B\u0001\u001e\u0019\u0011\u0019y\u0004\u0001)A\u0005Q\u0005\u0011\"/Z<sSR,'/\u00168eKJ$Vm\u001d;!\u0001")
public class FoldConstantsTest
extends CypherFunSuite
implements RewriteTest {
    private final Function1<Object, Object> rewriterUnderTest;

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        RewriteTest$class.assertRewrite(this, originalQuery, expectedQuery);
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    public FoldConstantsTest() {
        RewriteTest$class.$init$(this);
        this.rewriterUnderTest = fixedPoint$.MODULE$.apply((Function1)foldConstants$.MODULE$);
        this.test("solve literal expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FoldConstantsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("RETURN 1+1 AS r", "RETURN 2 AS r");
                this.$outer.assertRewrite("RETURN 1+5*4-3 AS r", "RETURN 18 AS r");
                this.$outer.assertRewrite("RETURN 1+(5*4)/(3*4) AS r", "RETURN 2 AS r");
                this.$outer.assertRewrite("RETURN 1+(5*4)/(2.0*4) AS r", "RETURN 3.5 AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("solve multiplication regardless of order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FoldConstantsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN 5 * 3 * n.prop AS r", "MATCH (n) RETURN n.prop * 15 AS r");
                this.$outer.assertRewrite("MATCH (n) RETURN n.prop * 4 * 2 AS r", "MATCH (n) RETURN n.prop * 8 AS r");
                this.$outer.assertRewrite("MATCH (n) RETURN 12 * n.prop * 5 AS r", "MATCH (n) RETURN n.prop * 60 AS r");
                this.$outer.assertRewrite("MATCH (n) RETURN (12 * n.prop) * 5 AS r", "MATCH (n) RETURN n.prop * 60 AS r");
                this.$outer.assertRewrite("MATCH (n) RETURN 12 * (n.prop * 5) AS r", "MATCH (n) RETURN n.prop * 60 AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("solve equality comparisons between literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FoldConstantsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) WHERE 1=1 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1=8 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2=1.2 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0=1.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0=8.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1=1.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1=8.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1=1.2 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0=1 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0=8 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2=1 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1+(5*4)/(3*4)=2 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertIsNotRewritten("MATCH (n) WHERE 1=null RETURN n AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("solve greater than comparisons between literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FoldConstantsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) WHERE 2>1 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1>2 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2>2.4 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2.0>1.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0>8.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2>1.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1>8.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2.0>1 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0>7 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2>1 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("solve less than comparisons between literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FoldConstantsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) WHERE 2<1 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1<2 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2<2.4 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2.0<1.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0<8.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2<1.0 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1<8.0 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 2.0<1 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.0<7 RETURN n AS r", "MATCH (n) WHERE true RETURN n AS r");
                this.$outer.assertRewrite("MATCH (n) WHERE 1.2<1 RETURN n AS r", "MATCH (n) WHERE false RETURN n AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

