/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_4.parser.ParserFixture$;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.Forced$;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.IfNoParameter$;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.LiteralExtraction;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.literalReplacement$;
import org.neo4j.cypher.internal.util.v3_4.ASTNode;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.Rewritable;
import org.neo4j.cypher.internal.util.v3_4.Rewritable$;
import org.neo4j.cypher.internal.util.v3_4.Rewriter$;
import org.neo4j.cypher.internal.util.v3_4.bottomUp$;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.FloatType;
import org.neo4j.cypher.internal.util.v3_4.symbols.IntegerType;
import org.neo4j.cypher.internal.util.v3_4.symbols.ListType;
import org.neo4j.cypher.internal.util.v3_4.symbols.StringType;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.Parameter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001'\t1B*\u001b;fe\u0006d'+\u001a9mC\u000e,W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005I!/Z<sSR,'o\u001d\u0006\u0003\u000b\u0019\t1!Y:u\u0015\t9\u0001\"\u0001\u0003wg}#$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001B;uS2L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\u0006G\u0001!I\u0001J\u0001\u0015CN\u001cXM\u001d;E_\u0016\u001chj\u001c;SK^\u0014\u0018\u000e^3\u0015\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001B+oSRDQ\u0001\f\u0012A\u00025\nQ!];fef\u0004\"AL\u0019\u000f\u0005\u0019z\u0013B\u0001\u0019(\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A:\u0003\"B\u001b\u0001\t\u00131\u0014!D1tg\u0016\u0014HOU3xe&$X\rF\u0003&oeZ4\tC\u00039i\u0001\u0007Q&A\u0007pe&<\u0017N\\1m#V,'/\u001f\u0005\u0006uQ\u0002\r!L\u0001\u000eKb\u0004Xm\u0019;fIF+XM]=\t\u000bq\"\u0004\u0019A\u001f\u0002\u0019I,\u0007\u000f\\1dK6,g\u000e^:\u0011\t9rT\u0006Q\u0005\u0003\u007fM\u00121!T1q!\t1\u0013)\u0003\u0002CO\t\u0019\u0011I\\=\t\u000f\u0011#\u0004\u0013!a\u0001\u000b\u0006yQ\r\u001f;sC\u000e$H*\u001b;fe\u0006d7\u000f\u0005\u0002G\u00196\tqI\u0003\u0002\u0004\u0011*\u0011Q!\u0013\u0006\u0003\u000f)S!a\u0013\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!!T$\u0003#1KG/\u001a:bY\u0016CHO]1di&|g\u000eC\u0003P\u0001\u0011%\u0001+\u0001\u000fgSb\u0004\u0016M]1nKR,'\u000fV=qK\u0016C\b/Z2uCRLwN\\:\u0016\u0003E\u0003\"A\u0015,\u000f\u0005M#V\"\u0001\r\n\u0005UC\u0012a\u00029bG.\fw-Z\u0005\u0003/b\u0013\u0001BU3xe&$XM\u001d\u0006\u0003+bAqA\u0017\u0001\u0012\u0002\u0013%1,A\fbgN,'\u000f\u001e*foJLG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\tAL\u000b\u0002F;.\na\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003G\u001e\n!\"\u00198o_R\fG/[8o\u0013\t)\u0007MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class LiteralReplacementTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite(String query) {
        this.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(query, query, (Map<String, Object>)Predef$.MODULE$.Map().empty(), this.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
    }

    public void org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(String originalQuery, String expectedQuery, Map<String, Object> replacements, LiteralExtraction extractLiterals) {
        Statement original = ParserFixture$.MODULE$.parser().parse(originalQuery, ParserFixture$.MODULE$.parser().parse$default$2());
        Statement expected = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(expectedQuery, ParserFixture$.MODULE$.parser().parse$default$2())), this.fixParameterTypeExpectations());
        Tuple2 tuple2 = literalReplacement$.MODULE$.apply((ASTNode)original, extractLiterals);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Function1 rewriter = (Function1)tuple2._1();
            Map replacedLiterals = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rewriter, (Object)replacedLiterals);
            Function1 rewriter2 = (Function1)tuple23._1();
            Map replacedLiterals2 = (Map)tuple23._2();
            Object result = Rewritable.RewritableAny$.MODULE$.rewrite$extension0(Rewritable$.MODULE$.RewritableAny((Object)original), rewriter2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            Statement $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(replacements);
            Map $org_scalatest_assert_macro_right2 = replacedLiterals2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public LiteralExtraction org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4() {
        return IfNoParameter$.MODULE$;
    }

    private Function1<Object, Object> fixParameterTypeExpectations() {
        return bottomUp$.MODULE$.apply(Rewriter$.MODULE$.lift((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String name;
                String name2;
                String name3;
                Object object;
                boolean bl = false;
                Parameter parameter = null;
                A1 A1 = x1;
                if (A1 instanceof Parameter) {
                    bl = true;
                    parameter = (Parameter)A1;
                    String name4 = parameter.name();
                    if (name4.startsWith("  AUTOSTRING")) {
                        StringType x$2 = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTString();
                        String x$3 = parameter.copy$default$1();
                        InputPosition x$4 = parameter.position();
                        object = parameter.copy(x$3, (CypherType)x$2, x$4);
                        return (B1)object;
                    }
                }
                if (bl && (name3 = parameter.name()).startsWith("  AUTOINT")) {
                    IntegerType x$5 = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTInteger();
                    String x$6 = parameter.copy$default$1();
                    InputPosition x$7 = parameter.position();
                    object = parameter.copy(x$6, (CypherType)x$5, x$7);
                    return (B1)object;
                }
                if (bl && (name2 = parameter.name()).startsWith("  AUTODOUBLE")) {
                    FloatType x$8 = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTFloat();
                    String x$9 = parameter.copy$default$1();
                    InputPosition x$10 = parameter.position();
                    object = parameter.copy(x$9, (CypherType)x$8, x$10);
                    return (B1)object;
                }
                if (bl && (name = parameter.name()).startsWith("  AUTOLIST")) {
                    ListType x$11 = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTList((CypherType)org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTAny());
                    String x$12 = parameter.copy$default$1();
                    InputPosition x$13 = parameter.position();
                    object = parameter.copy(x$12, (CypherType)x$11, x$13);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                String name;
                String name2;
                boolean bl = false;
                Parameter parameter = null;
                Object object = x1;
                if (object instanceof Parameter) {
                    bl = true;
                    parameter = (Parameter)object;
                    String name3 = parameter.name();
                    if (name3.startsWith("  AUTOSTRING")) {
                        return true;
                    }
                }
                if (bl && (name2 = parameter.name()).startsWith("  AUTOINT")) {
                    return true;
                }
                if (bl && (name = parameter.name()).startsWith("  AUTODOUBLE")) {
                    return true;
                }
                if (!bl) return false;
                String name4 = parameter.name();
                if (!name4.startsWith("  AUTOLIST")) return false;
                return true;
            }
        }), bottomUp$.MODULE$.apply$default$2());
    }

    public LiteralReplacementTest() {
        this.test("should extract starts with patterns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN x STARTS WITH 'Pattern' as X", "RETURN x STARTS WITH {`  AUTOSTRING0`} as X", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"Pattern")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not extract literal dynamic property lookups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite("MATCH n RETURN n[\"name\"]");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in return clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 1 as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOINT0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)1))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 1.1 as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTODOUBLE0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTODOUBLE0"), (Object)BoxesRunTime.boxToDouble((double)1.1))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN 'apa' as result", "RETURN {`  AUTOSTRING0`} as result", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN \"apa\" as result", "RETURN {`  AUTOSTRING0`} as result", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN [1, 2, 3] as result", "RETURN {`  AUTOLIST0`} as result", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOLIST0"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not extract boolean literals in return clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN true as result"})).s((Seq)Nil$.MODULE$));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN false as result"})).s((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in match clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:1})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTOINT0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)1))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:1.1})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTODOUBLE0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTODOUBLE0"), (Object)BoxesRunTime.boxToDouble((double)1.1))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("MATCH ({a:'apa'})", "MATCH ({a:{`  AUTOSTRING0`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("MATCH ({a:\"apa\"})", "MATCH ({a:{`  AUTOSTRING0`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("MATCH (n) WHERE ID(n) IN [1, 2, 3]", "MATCH (n) WHERE ID(n) IN {`  AUTOLIST0`}", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOLIST0"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not extract boolean literals in match clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:true})"})).s((Seq)Nil$.MODULE$));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertDoesNotRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:false})"})).s((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in skip clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 0 as x SKIP 1 limit 2"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOINT0`} as x SKIP {`  AUTOINT1`} LIMIT 2"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT1"), (Object)BoxesRunTime.boxToInteger((int)1))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in create statement clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("create (a {a:0, b:'name 0', c:10000000, d:'a very long string 0'})", "create (a {a:{`  AUTOINT0`}, b:{`  AUTOSTRING1`}, c:{`  AUTOINT2`}, d:{`  AUTOSTRING3`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT2"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING3"), (Object)"a very long string 0")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in merge clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MERGE (n {a:'apa'}) ON CREATE SET n.foo = 'apa' ON MATCH SET n.foo = 'apa'"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MERGE (n {a:{`  AUTOSTRING0`}}) ON CREATE SET n.foo = {`  AUTOSTRING1`} ON MATCH SET n.foo = {`  AUTOSTRING2`}"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"apa"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING2"), (Object)"apa")}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in multiple patterns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create (a {a:0, b:'name 0', c:10000000, d:'a very long string 0'}) create (b {a:0, b:'name 0', c:10000000, d:'a very long string 0'}) create (a)-[:KNOWS {since: 0}]->(b)"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create (a {a:{`  AUTOINT0`}, b:{`  AUTOSTRING1`}, c:{`  AUTOINT2`}, d:{`  AUTOSTRING3`}}) create (b {a:{`  AUTOINT4`}, b:{`  AUTOSTRING5`}, c:{`  AUTOINT6`}, d:{`  AUTOSTRING7`}}) create (a)-[:KNOWS {since: {`  AUTOINT8`}}]->(b)"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT2"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING3"), (Object)"a very long string 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING5"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT6"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING7"), (Object)"a very long string 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT8"), (Object)BoxesRunTime.boxToInteger((int)0))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not rewrite queries that already have params in them", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("CREATE (a:Person {name:'Jakub', age:{age} })", "CREATE (a:Person {name:'Jakub', age:{age} })", (Map<String, Object>)Predef$.MODULE$.Map().empty(), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should rewrite queries that already have params in them if configured to", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("CREATE (a:Person {name: 'Jakub', age: $age })", "CREATE (a:Person {name: {`  AUTOSTRING0`}, age: $age })", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"Jakub")}))), (LiteralExtraction)Forced$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract from procedure calls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("CALL foo(12)", "CALL foo({`  AUTOINT0`})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)12))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract from UNWIND", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite("UNWIND [1, 2, 3] AS list RETURN list", "UNWIND $`  AUTOLIST0` AS list RETURN list", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  AUTOLIST0"), (Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))), this.$outer.org$neo4j$cypher$internal$compiler$v3_4$ast$rewriters$LiteralReplacementTest$$assertRewrite$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

