/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_4.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v3_4.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.frontend.v3_4.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_4.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_4.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.projectFreshSortExpressions$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.Rewritable;
import org.neo4j.cypher.internal.util.v3_4.Rewritable$;
import org.neo4j.cypher.internal.util.v3_4.inSequence$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Equals;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_4.expressions.LabelName;
import org.neo4j.cypher.internal.v3_4.expressions.LessThan;
import org.neo4j.cypher.internal.v3_4.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001'\ty\u0002K]8kK\u000e$hI]3tQN{'\u000f^#yaJ,7o]5p]N$Vm\u001d;\u000b\u0005\r!\u0011!\u0003:foJLG/\u001a:t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u001ct\f\u000e\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0015;\u0005\u0002\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u001dI\"B\u0001\u000e\u000b\u0003\u0011)H/\u001b7\n\u0005q1\"AD\"za\",'OR;o'VLG/\u001a\t\u0003=}i\u0011AA\u0005\u0003A\t\u00111BU3xe&$X\rV3tiB\u0011!eJ\u0007\u0002G)\u0011Q\u0001\n\u0006\u0003\u000f\u0015R!A\n\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001K\u0012\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005a\u0003C\u0001\u0010\u0001\u0011\u001dq\u0003A1A\u0005\u0002=\n\u0011C]3xe&$XM]+oI\u0016\u0014H+Z:u+\u0005\u0001\u0004CA\u0019D\u001d\t\u0011\u0014I\u0004\u00024\u0001:\u0011Ag\u0010\b\u0003kyr!AN\u001f\u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!A\u0007\u0006\n\u0005\u001dI\u0012B\u0001\"\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0011I+wO]5uKJT!A\u0011\r\t\r\u001d\u0003\u0001\u0015!\u00031\u0003I\u0011Xm\u001e:ji\u0016\u0014XK\u001c3feR+7\u000f\u001e\u0011\t\u000b%\u0003A\u0011\u000b&\u0002\u001b\u0005\u001c8/\u001a:u%\u0016<(/\u001b;f)\rY\u0015K\u0017\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0005+:LG\u000fC\u0003S\u0011\u0002\u00071+A\u0007pe&<\u0017N\\1m#V,'/\u001f\t\u0003)^s!\u0001T+\n\u0005Yk\u0015A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV'\t\u000bmC\u0005\u0019A*\u0002\u001b\u0015D\b/Z2uK\u0012\fV/\u001a:z\u0011\u0015)\u0001\u0001\"\u0003^)\tq\u0016\r\u0005\u0002#?&\u0011\u0001m\t\u0002\n'R\fG/Z7f]RDQA\u0019/A\u0002M\u000b\u0011\"];fef$V\r\u001f;")
public class ProjectFreshSortExpressionsTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.ast(originalQuery);
        Statement expected = this.ast(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
    }

    private Statement ast(String queryText) {
        Statement parsed = this.parseForRewriting(queryText);
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        Statement normalized = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)parsed), inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)normalized.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)normalized), inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new expandStar(checkResult.state())})));
    }

    public ProjectFreshSortExpressionsTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.rewriterUnderTest = projectFreshSortExpressions$.MODULE$;
        this.test("don't adjust WITH without ORDER BY or WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing ORDER BY that refers to previous variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop + n.x\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH prop AS prop, prop + n.x AS `  FRESHID42`\n        |WITH prop AS prop, `  FRESHID42` AS `  FRESHID42` ORDER BY `  FRESHID42`\n        |WITH prop AS prop\n        |RETURN prop AS prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate RETURN containing ORDER BY after WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS p, count(*) AS rng\n        |RETURN p ORDER BY rng\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS p, count(*) AS rng\n        |WITH p AS `  FRESHID36`, rng AS rng\n        |WITH `  FRESHID36` AS `  FRESHID36` ORDER BY rng\n        |RETURN `  FRESHID36` AS p\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop AS prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("preserve DISTINCT on first WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keep WHERE with ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handle RETURN * ORDERBY property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN * ORDER BY n.prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, n.prop AS `  FRESHID28`\n        |WITH n AS n, `  FRESHID28` AS `  FRESHID28` ORDER BY `  FRESHID28`\n        |WITH n AS n\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for ORDER BY over preserved variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n      |WITH n AS n, n.prop AS prop\n      |WITH n AS n, prop AS prop ORDER BY prop\n      |RETURN n AS n\n    ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for WHERE over preserved variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH n AS n, prop AS prop WHERE prop\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

