/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.planner;

import org.neo4j.cypher.internal.compiler.v3_4.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_4.phases.CompilerContext;
import org.neo4j.cypher.internal.compiler.v3_4.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.v3_4.planner.HardcodedGraphStatistics$;
import org.neo4j.cypher.internal.compiler.v3_4.planner.LogicalPlanConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_4.planner.LogicalPlanningTestSupport;
import org.neo4j.cypher.internal.compiler.v3_4.planner.LogicalPlanningTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.SimpleMetricsFactory$;
import org.neo4j.cypher.internal.frontend.v3_4.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_4.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_4.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_4.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.rewriters.ASTRewriter;
import org.neo4j.cypher.internal.frontend.v3_4.helpers.rewriting.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v3_4.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_4.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_4.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_4.phases.Monitors;
import org.neo4j.cypher.internal.frontend.v3_4.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticTable;
import org.neo4j.cypher.internal.ir.v3_4.PatternLength;
import org.neo4j.cypher.internal.ir.v3_4.PatternRelationship;
import org.neo4j.cypher.internal.ir.v3_4.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_4.Predicate;
import org.neo4j.cypher.internal.ir.v3_4.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_4.Selections;
import org.neo4j.cypher.internal.ir.v3_4.Selections$;
import org.neo4j.cypher.internal.ir.v3_4.StrictnessMode;
import org.neo4j.cypher.internal.ir.v3_4.UnionQuery;
import org.neo4j.cypher.internal.planner.v3_4.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.v3_4.spi.PlanContext;
import org.neo4j.cypher.internal.planner.v3_4.spi.PlanningAttributes;
import org.neo4j.cypher.internal.util.v3_4.Cardinality;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.attribution.SequentialIdGen;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.And;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Equals;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_4.expressions.LabelName;
import org.neo4j.cypher.internal.v3_4.expressions.LessThan;
import org.neo4j.cypher.internal.v3_4.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_4.expressions.PartialPredicate$;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.RelTypeName;
import org.neo4j.cypher.internal.v3_4.expressions.SemanticDirection;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.neo4j.cypher.internal.v3_4.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_4.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.v3_4.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.v3_4.logical.plans.UserFunctionSignature;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001#\tq1+\u001a7fGRLwN\\:UKN$(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\tY\u001ct\f\u000e\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00137}\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003\u0011)H/\u001b7\n\u0005i!\"AD\"za\",'OR;o'VLG/\u001a\t\u00039ui\u0011AA\u0005\u0003=\t\u0011!\u0004T8hS\u000e\fG\u000e\u00157b]:Lgn\u001a+fgR\u001cV\u000f\u001d9peR\u0004\"\u0001\t\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0007\u0005\u001cHO\u0003\u0002\u0006I)\u0011Q\u0005C\u0001\tMJ|g\u000e^3oI&\u0011q%\t\u0002\u001b\u0003N$8i\u001c8tiJ,8\r^5p]R+7\u000f^*vaB|'\u000f\u001e\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"\u0001\b\u0001\t\u000f5\u0002!\u0019!C\u0001]\u0005I\u0011-S:QKJ\u001cxN\\\u000b\u0002_A\u0011\u0001\u0007N\u0007\u0002c)\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\u0011%\u0011Q'\r\u0002\n\u0011\u0006\u001cH*\u00192fYNDaa\u000e\u0001!\u0002\u0013y\u0013AC1JgB+'o]8oA!9\u0011\b\u0001b\u0001\n\u0003q\u0013!D1JgB\u0013xn\u001a:b[6,'\u000f\u0003\u0004<\u0001\u0001\u0006IaL\u0001\u000fC&\u001b\bK]8he\u0006lW.\u001a:!\u0011\u001di\u0004A1A\u0005\u00029\n\u0011BY%t\u0003:LW.\u00197\t\r}\u0002\u0001\u0015!\u00030\u0003)\u0011\u0017j]!oS6\fG\u000e\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0003=\u0019w.\u001c9be\u0016$vo\u001c(pI\u0016\u001cX#A\"\u0011\u0005A\"\u0015BA#2\u0005\u0019)\u0015/^1mg\"1q\t\u0001Q\u0001\n\r\u000b\u0001cY8na\u0006\u0014X\rV<p\u001d>$Wm\u001d\u0011\t\u000b%\u0003A\u0011\u0002&\u0002\u000f%$g*Y7fgR\u00111*\u0018\t\u0004\u0019N+V\"A'\u000b\u00059{\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0016+\u0001\u0006d_2dWm\u0019;j_:T\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)6\u00131aU3u!\t1&L\u0004\u0002X16\t\u0011+\u0003\u0002Z#\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI\u0016\u000bC\u0003_\u0011\u0002\u0007q,A\u0003oC6,7\u000fE\u0002XAVK!!Y)\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0003d\u0001\u0011%A-\u0001\td_6\u0004\u0018M]3C_RD7+\u001b3fgR\u00191)Z4\t\u000b\u0019\u0014\u0007\u0019A+\u0002\t1,g\r\u001e\u0005\u0006Q\n\u0004\r!V\u0001\u0006e&<\u0007\u000e\u001e")
public class SelectionsTest
extends CypherFunSuite
implements LogicalPlanningTestSupport {
    private final HasLabels aIsPerson;
    private final HasLabels aIsProgrammer;
    private final HasLabels bIsAnimal;
    private final Equals compareTwoNodes;
    private final Monitors monitors;
    private final CypherParser parser;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private final ASTRewriter astRewriter;
    private final PatternRelationship mockRel;
    private final CypherCompilerConfiguration config;
    private final Transformer<CompilerContext, BaseState, LogicalPlanState> pipeLine;
    private final SequentialIdGen idGen;
    private final InputPosition pos;

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    public PatternRelationship mockRel() {
        return this.mockRel;
    }

    @Override
    public CypherCompilerConfiguration config() {
        return this.config;
    }

    @Override
    public Transformer<CompilerContext, BaseState, LogicalPlanState> pipeLine() {
        return this.pipeLine;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$monitors_$eq(Monitors x$1) {
        this.monitors = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$mockRel_$eq(PatternRelationship x$1) {
        this.mockRel = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$config_$eq(CypherCompilerConfiguration x$1) {
        this.config = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanningTestSupport$_setter_$pipeLine_$eq(Transformer x$1) {
        this.pipeLine = x$1;
    }

    @Override
    public PatternRelationship newPatternRelationship(String start, String end, String rel, SemanticDirection dir, Seq<RelTypeName> types, PatternLength length) {
        return LogicalPlanningTestSupport$class.newPatternRelationship(this, start, end, rel, dir, types, length);
    }

    @Override
    public QueryGraph newMockedQueryGraph() {
        return LogicalPlanningTestSupport$class.newMockedQueryGraph(this);
    }

    @Override
    public SimpleMetricsFactory$ newMetricsFactory() {
        return LogicalPlanningTestSupport$class.newMetricsFactory(this);
    }

    @Override
    public ExpressionEvaluator newExpressionEvaluator() {
        return LogicalPlanningTestSupport$class.newExpressionEvaluator(this);
    }

    @Override
    public Metrics newSimpleMetrics(GraphStatistics stats) {
        return LogicalPlanningTestSupport$class.newSimpleMetrics(this, stats);
    }

    @Override
    public GraphStatistics newMockedGraphStatistics() {
        return LogicalPlanningTestSupport$class.newMockedGraphStatistics(this);
    }

    @Override
    public SemanticTable newMockedSemanticTable() {
        return LogicalPlanningTestSupport$class.newMockedSemanticTable(this);
    }

    @Override
    public LogicalPlanningTestSupport.SpyableMetricsFactory newMockedMetricsFactory() {
        return LogicalPlanningTestSupport$class.newMockedMetricsFactory(this);
    }

    @Override
    public QueryGraphSolver newMockedStrategy(LogicalPlan plan) {
        return LogicalPlanningTestSupport$class.newMockedStrategy(this, plan);
    }

    @Override
    public QueryGraphSolver newMockedStrategyWithMultiplePlans(Seq<LogicalPlan> plans) {
        return LogicalPlanningTestSupport$class.newMockedStrategyWithMultiplePlans(this, plans);
    }

    @Override
    public Metrics mockedMetrics() {
        return LogicalPlanningTestSupport$class.mockedMetrics(this);
    }

    @Override
    public Tuple3<LogicalPlanningContext, PlanningAttributes.Solveds, PlanningAttributes.Cardinalities> newMockedLogicalPlanningContext(PlanContext planContext, Metrics metrics, SemanticTable semanticTable, QueryGraphSolver strategy, Cardinality cardinality, Option<StrictnessMode> strictness, InternalNotificationLogger notificationLogger, boolean useErrorsOverWarnings) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext(this, planContext, metrics, semanticTable, strategy, cardinality, strictness, notificationLogger, useErrorsOverWarnings);
    }

    @Override
    public LogicalPlanningContext newMockedLogicalPlanningContextWithFakeAttributes(PlanContext planContext, Metrics metrics, SemanticTable semanticTable, QueryGraphSolver strategy, Cardinality cardinality, Option<StrictnessMode> strictness, InternalNotificationLogger notificationLogger, boolean useErrorsOverWarnings) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes(this, planContext, metrics, semanticTable, strategy, cardinality, strictness, notificationLogger, useErrorsOverWarnings);
    }

    @Override
    public GraphStatistics newMockedStatistics() {
        return LogicalPlanningTestSupport$class.newMockedStatistics(this);
    }

    @Override
    public HardcodedGraphStatistics$ hardcodedStatistics() {
        return LogicalPlanningTestSupport$class.hardcodedStatistics(this);
    }

    @Override
    public PlanContext newMockedPlanContext(GraphStatistics statistics) {
        return LogicalPlanningTestSupport$class.newMockedPlanContext(this, statistics);
    }

    @Override
    public LogicalPlan newMockedLogicalPlan(Seq<String> ids) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan(this, ids);
    }

    @Override
    public LogicalPlan newMockedLogicalPlan(PlanningAttributes.Solveds solveds, PlanningAttributes.Cardinalities cardinalities, Seq<String> ids) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan(this, solveds, cardinalities, ids);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithProjections(PlanningAttributes.Solveds solveds, Seq<String> ids) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithProjections(this, solveds, ids);
    }

    @Override
    public LogicalPlan newMockedLogicalPlan(Set<String> idNames, PlanningAttributes.Solveds solveds, PlanningAttributes.Cardinalities cardinalities, Set<Hint> hints) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan(this, idNames, solveds, cardinalities, hints);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithSolved(PlanningAttributes.Solveds solveds, PlanningAttributes.Cardinalities cardinalities, Set<String> idNames, PlannerQuery solved, Cardinality cardinality) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithSolved(this, solveds, cardinalities, idNames, solved, cardinality);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithPatterns(PlanningAttributes.Solveds solveds, PlanningAttributes.Cardinalities cardinalities, Set<String> idNames, Seq<PatternRelationship> patterns) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns(this, solveds, cardinalities, idNames, patterns);
    }

    @Override
    public PlannerQuery buildPlannerQuery(String query, Option<Function1<QualifiedName, ProcedureSignature>> lookup) {
        return LogicalPlanningTestSupport$class.buildPlannerQuery(this, query, lookup);
    }

    @Override
    public UnionQuery buildPlannerUnionQuery(String query, Option<Function1<QualifiedName, ProcedureSignature>> procLookup, Option<Function1<QualifiedName, Option<UserFunctionSignature>>> fcnLookup) {
        return LogicalPlanningTestSupport$class.buildPlannerUnionQuery(this, query, procLookup, fcnLookup);
    }

    @Override
    public HasLabels identHasLabel(String name, String labelName) {
        return LogicalPlanningTestSupport$class.identHasLabel(this, name, labelName);
    }

    @Override
    public Option<Function1<QualifiedName, ProcedureSignature>> buildPlannerQuery$default$2() {
        return LogicalPlanningTestSupport$class.buildPlannerQuery$default$2(this);
    }

    @Override
    public Option<Function1<QualifiedName, ProcedureSignature>> buildPlannerUnionQuery$default$2() {
        return LogicalPlanningTestSupport$class.buildPlannerUnionQuery$default$2(this);
    }

    @Override
    public Option<Function1<QualifiedName, Option<UserFunctionSignature>>> buildPlannerUnionQuery$default$3() {
        return LogicalPlanningTestSupport$class.buildPlannerUnionQuery$default$3(this);
    }

    @Override
    public SemanticDirection newPatternRelationship$default$4() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$4(this);
    }

    @Override
    public Seq<RelTypeName> newPatternRelationship$default$5() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$5(this);
    }

    @Override
    public PatternLength newPatternRelationship$default$6() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$6(this);
    }

    @Override
    public GraphStatistics newSimpleMetrics$default$1() {
        return LogicalPlanningTestSupport$class.newSimpleMetrics$default$1(this);
    }

    @Override
    public Metrics newMockedLogicalPlanningContext$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$2(this);
    }

    @Override
    public SemanticTable newMockedLogicalPlanningContext$default$3() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$3(this);
    }

    @Override
    public QueryGraphSolver newMockedLogicalPlanningContext$default$4() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$4(this);
    }

    @Override
    public Cardinality newMockedLogicalPlanningContext$default$5() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$5(this);
    }

    @Override
    public Option<StrictnessMode> newMockedLogicalPlanningContext$default$6() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$6(this);
    }

    @Override
    public InternalNotificationLogger newMockedLogicalPlanningContext$default$7() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$7(this);
    }

    @Override
    public boolean newMockedLogicalPlanningContext$default$8() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$8(this);
    }

    @Override
    public Metrics newMockedLogicalPlanningContextWithFakeAttributes$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$2(this);
    }

    @Override
    public SemanticTable newMockedLogicalPlanningContextWithFakeAttributes$default$3() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$3(this);
    }

    @Override
    public QueryGraphSolver newMockedLogicalPlanningContextWithFakeAttributes$default$4() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$4(this);
    }

    @Override
    public Cardinality newMockedLogicalPlanningContextWithFakeAttributes$default$5() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$5(this);
    }

    @Override
    public Option<StrictnessMode> newMockedLogicalPlanningContextWithFakeAttributes$default$6() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$6(this);
    }

    @Override
    public InternalNotificationLogger newMockedLogicalPlanningContextWithFakeAttributes$default$7() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$7(this);
    }

    @Override
    public boolean newMockedLogicalPlanningContextWithFakeAttributes$default$8() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContextWithFakeAttributes$default$8(this);
    }

    @Override
    public GraphStatistics newMockedPlanContext$default$1() {
        return LogicalPlanningTestSupport$class.newMockedPlanContext$default$1(this);
    }

    @Override
    public PlanningAttributes.Solveds newMockedLogicalPlan$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan$default$2(this);
    }

    @Override
    public PlanningAttributes.Cardinalities newMockedLogicalPlan$default$3() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan$default$3(this);
    }

    @Override
    public Set<Hint> newMockedLogicalPlan$default$4() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan$default$4(this);
    }

    @Override
    public PlanningAttributes.Solveds newMockedLogicalPlanWithSolved$default$1() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithSolved$default$1(this);
    }

    @Override
    public PlanningAttributes.Cardinalities newMockedLogicalPlanWithSolved$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithSolved$default$2(this);
    }

    @Override
    public Cardinality newMockedLogicalPlanWithSolved$default$5() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithSolved$default$5(this);
    }

    @Override
    public PlanningAttributes.Solveds newMockedLogicalPlanWithPatterns$default$1() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns$default$1(this);
    }

    @Override
    public PlanningAttributes.Cardinalities newMockedLogicalPlanWithPatterns$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns$default$2(this);
    }

    @Override
    public Seq<PatternRelationship> newMockedLogicalPlanWithPatterns$default$4() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns$default$4(this);
    }

    @Override
    public SequentialIdGen idGen() {
        return this.idGen;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_4$planner$LogicalPlanConstructionTestSupport$_setter_$idGen_$eq(SequentialIdGen x$1) {
        this.idGen = x$1;
    }

    @Override
    public String idSymbol(Symbol name) {
        return LogicalPlanConstructionTestSupport$class.idSymbol(this, name);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public HasLabels aIsPerson() {
        return this.aIsPerson;
    }

    public HasLabels aIsProgrammer() {
        return this.aIsProgrammer;
    }

    public HasLabels bIsAnimal() {
        return this.bIsAnimal;
    }

    public Equals compareTwoNodes() {
        return this.compareTwoNodes;
    }

    public Set<String> org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames(Seq<String> names) {
        return names.toSet();
    }

    private Equals compareBothSides(String left, String right) {
        return new Equals((Expression)this.prop(left, "prop1"), (Expression)this.prop(right, "prop1"), this.pos());
    }

    public SelectionsTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanConstructionTestSupport$class.$init$(this);
        LogicalPlanningTestSupport$class.$init$(this);
        this.aIsPerson = this.identHasLabel("a", "Person");
        this.aIsProgrammer = this.identHasLabel("a", "Programmer");
        this.bIsAnimal = this.identHasLabel("b", "Animal");
        this.compareTwoNodes = this.compareBothSides("a", "b");
        this.test("can flat predicates to a sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson())})));
                this.$outer.convertToAnyShouldWrapper(selections.flatPredicates()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can flat empty predicates to an empty sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new Selections(Selections$.MODULE$.apply$default$1()).flatPredicates()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to sense that predicates are not covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson()), new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)selections.coveredBy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to tell when all predicates are covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson())})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)selections.coveredBy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can extract HasLabels Predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predicate[] predicateArray = new Predicate[4];
                predicateArray[0] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson());
                predicateArray[1] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson());
                predicateArray[2] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Expression)this.$outer.bIsAnimal());
                Variable variable = (Variable)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Variable apply(InputPosition position) {
                        return new Variable("c", position);
                    }
                });
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("42", position);
                    }
                });
                predicateArray[3] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), (Expression)this.$outer.withPos(new Serializable(this, variable, signedDecimalIntegerLiteral){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$1$1;
                    private final SignedDecimalIntegerLiteral eta$1$1$1;

                    public final Equals apply(InputPosition position) {
                        return new Equals((Expression)this.eta$0$1$1, (Expression)this.eta$1$1$1, position);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                        this.eta$1$1$1 = eta$1$1$1;
                    }
                }));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])predicateArray)));
                this.$outer.convertToAnyShouldWrapper(selections.labelPredicates()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.bIsAnimal()})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can find predicates given covered ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<String> a = this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set<String> b = this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(a, (Expression)this.$outer.aIsPerson()), new Predicate(b, (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(a)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("returns no predicates if no ids are covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<String> a = this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set<String> b = this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(a, (Expression)this.$outer.aIsPerson()), new Predicate(b, (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(Predef$.MODULE$.Set().empty())).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("does not take on a predicate if it is only half covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<String> aAndB = this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
                Set a = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)aAndB.head()}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(aAndB, (Expression)this.$outer.compareTwoNodes())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(a)).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("prunes away sub predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                And covering = new And((Expression)this.$outer.aIsPerson(), (Expression)this.$outer.aIsProgrammer(), this.$outer.pos());
                HasLabels covered = this.$outer.aIsProgrammer();
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), PartialPredicate$.MODULE$.apply((Expression)covered, (Expression)covering))})));
                Selections result = selections.$plus$plus(new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)covering)}))));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_4$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)covering)})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should recognize value joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property lhs = this.$outer.prop("x", "id");
                Property rhs = this.$outer.prop("z", "id");
                Equals equalityComparison = new Equals((Expression)lhs, (Expression)rhs, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Expression)equalityComparison);
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{equalityComparison}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if one side is a literal, it's not a value join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = Selections$.MODULE$.from((Expression)this.$outer.propEquality("x", "id", 42));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if both lhs and rhs come from the same variable, it's not a value join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property lhs = this.$outer.prop("x", "id1");
                Property rhs = this.$outer.prop("x", "id2");
                Equals equalityComparison = new Equals((Expression)lhs, (Expression)rhs, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Expression)equalityComparison);
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("combination of predicates is not a problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property x_id1 = this.$outer.prop("x", "id1");
                Property x_id2 = this.$outer.prop("x", "id2");
                Property z_id = this.$outer.prop("z", "id");
                SignedDecimalIntegerLiteral lit = this.$outer.literalInt(42);
                Equals pred1 = new Equals((Expression)x_id1, (Expression)x_id2, this.$outer.pos());
                Equals pred2 = new Equals((Expression)x_id1, (Expression)z_id, this.$outer.pos());
                Equals pred3 = new Equals((Expression)x_id2, (Expression)lit, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{pred1, pred2, pred3})));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{pred2}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

