/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.prettifier;

import org.neo4j.cypher.internal.compiler.v3_4.prettifier.AnyText;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.BreakingKeywords;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.EscapedText;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.EscapedText$;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.GroupToken;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.NonBreakingKeywords;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.PrettifierParser;
import org.neo4j.cypher.internal.compiler.v3_4.prettifier.SyntaxToken;
import org.neo4j.cypher.internal.frontend.v3_4.parser.ParserTest;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.parboiled.scala.rules.Rule1;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001#\t!\u0002K]3ui&4\u0017.\u001a:QCJ\u001cXM\u001d+fgRT!a\u0001\u0003\u0002\u0015A\u0014X\r\u001e;jM&,'O\u0003\u0002\u0006\r\u0005!aoM05\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IY\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005!Q\u000f^5m\u0013\tQBC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\tq\u0011C\u0005J\u0007\u0002;)\u0011adH\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005\u0015\u0001#BA\u0011\t\u0003!1'o\u001c8uK:$\u0017BA\u0012\u001e\u0005)\u0001\u0016M]:feR+7\u000f\u001e\t\u0004K=\u0012dB\u0001\u0014-\u001d\t9#&D\u0001)\u0015\tI\u0003#\u0001\u0004=e>|GOP\u0005\u0002W\u0005)1oY1mC&\u0011QFL\u0001\ba\u0006\u001c7.Y4f\u0015\u0005Y\u0013B\u0001\u00192\u0005\r\u0019V-\u001d\u0006\u0003[9\u0002\"a\r\u001b\u000e\u0003\tI!!\u000e\u0002\u0003\u0017MKh\u000e^1y)>\\WM\u001c\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"a\r\u0001\t\u000fm\u0002!\u0019!C\u0002y\u0005a\u0001/\u0019:tKJ$v\u000eV3tiV\tQ\bE\u0002?\u0013\u0012r!aP$\u000f\u0005\u0001+eBA!D\u001d\t9#)C\u0001\u0010\u0013\t!e\"A\u0005qCJ\u0014w.\u001b7fI&\u00111F\u0012\u0006\u0003\t:I!!\f%\u000b\u0005-2\u0015B\u0001&L\u0005\u0015\u0011V\u000f\\32\u0015\ti\u0003\n\u0003\u0004N\u0001\u0001\u0006I!P\u0001\u000ea\u0006\u00148/\u001a:U_R+7\u000f\u001e\u0011\t\u000b=\u0003A\u0011\u0001)\u0002\u000f\r|gN^3siR\u0011A%\u0015\u0005\u0006%:\u0003\r\u0001J\u0001\u0007m\u0006dW/Z:")
public class PrettifierParserTest
extends CypherFunSuite
implements ParserTest<Seq<SyntaxToken>, Seq<SyntaxToken>> {
    private final Rule1<Seq<SyntaxToken>> parserToTest;

    public ParserTest.ResultCheck parsing(String s, Rule1<Seq<SyntaxToken>> p) {
        return ParserTest.class.parsing((ParserTest)this, (String)s, p);
    }

    public ParserTest.ResultCheck partiallyParsing(String s, Rule1<Seq<SyntaxToken>> p) {
        return ParserTest.class.partiallyParsing((ParserTest)this, (String)s, p);
    }

    public void assertFails(String s, Rule1<Seq<SyntaxToken>> p) {
        ParserTest.class.assertFails((ParserTest)this, (String)s, p);
    }

    public Rule1<Seq<SyntaxToken>> parserToTest() {
        return this.parserToTest;
    }

    public Seq<SyntaxToken> convert(Seq<SyntaxToken> values) {
        return values;
    }

    public PrettifierParserTest() {
        ParserTest.class.$init$((ParserTest)this);
        this.parserToTest = new PrettifierParser().main();
        this.test("shouldParseKeywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String keyword = "create";
                this.$outer.parsing(keyword, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BreakingKeywords[]{new BreakingKeywords(keyword)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldNotParseAssertAsANonBreakingKeyword", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query = "create constraint on (person:Person) assert person.age is unique";
                this.$outer.parsing(query, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("create constraint on"), new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("person:Person")}))), new NonBreakingKeywords("assert"), new AnyText("person.age"), new NonBreakingKeywords("is unique")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseIndexAsKeyword", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String keyword = "asc";
                this.$outer.parsing(keyword, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonBreakingKeywords[]{new NonBreakingKeywords(keyword)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseAnyText", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "a-->b";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText(input)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEscapedText", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "aha!";
                this.$outer.parsing(new StringBuilder().append((Object)"\"").append((Object)input).append((Object)"\"").toString(), this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText(input, EscapedText$.MODULE$.apply$default$2())})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGroupingText", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "(){}[]";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.empty()), new GroupToken("{", "}", (Seq)Seq$.MODULE$.empty()), new GroupToken("[", "]", (Seq)Seq$.MODULE$.empty())})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexExample1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "match a-->b where b.name = \"aha!\" return a.age";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("match"), new AnyText("a-->b"), new BreakingKeywords("where"), new AnyText("b.name"), new AnyText("="), new EscapedText("aha!", EscapedText$.MODULE$.apply$default$2()), new BreakingKeywords("return"), new AnyText("a.age")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexExample2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "merge n on create set n.age=32";
                ParserTest.ResultCheck result = this.$outer.parsing(input, this.$outer.parserToTest());
                Seq expectation = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("merge"), new AnyText("n"), new BreakingKeywords("on create set"), new AnyText("n.age=32")}));
                result.shouldGive((Object)expectation);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseSimpleGrouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("[0,10]", this.$outer.parserToTest());
                result.shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("0,10")})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexGrouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("[(0,10)]", this.$outer.parserToTest());
                result.shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("0,10")})))})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGroupingWithEscapedText", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("( \"Gunhild\" )", this.$outer.parserToTest());
                result.shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("Gunhild", EscapedText$.MODULE$.apply$default$2())})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGrouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.parsing("(x)", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
                this.$outer.parsing("[x]", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
                this.$outer.parsing("{x}", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("{", "}", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseWhereAsNonBreakingInsideGrouping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("( WHERE )", this.$outer.parserToTest());
                result.shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonBreakingKeywords[]{new NonBreakingKeywords("WHERE")})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseUsingPeriodicCommitAndMatchAsDistinctKeywordGroups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("USING PERIODIC COMMIT MATCH", this.$outer.parserToTest());
                result.shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BreakingKeywords[]{new BreakingKeywords("USING PERIODIC COMMIT"), new BreakingKeywords("MATCH")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseStringsAndKeepQuotes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.parsing("\"I'm a literal\"", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("I'm a literal", EscapedText$.MODULE$.apply$default$2())})));
                this.$outer.parsing("'Im a literal'", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("Im a literal", '\'')})));
                this.$outer.parsing("'I\\'m a literal'", this.$outer.parserToTest()).shouldGive((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("I'm a literal", '\'')})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

