/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_4.planner.logical;

import org.neo4j.cypher.internal.compiler.v3_4.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.ir.v3_4.CreatesPropertyKeys;
import org.neo4j.cypher.internal.ir.v3_4.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_4.QueryGraph;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.v3_4.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_4.logical.plans.NodeLogicalLeafPlan;
import org.neo4j.cypher.internal.v3_4.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.v3_4.logical.plans.ResolvedCall;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;

public final class Eagerness$ {
    public static final Eagerness$ MODULE$;

    static {
        new Eagerness$();
    }

    public boolean readWriteConflictInHead(LogicalPlan plan2, PlannerQuery plannerQuery) {
        Seq unstableLeaves = (Seq)plan2.leaves().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof NodeLogicalLeafPlan) {
                    NodeLogicalLeafPlan nodeLogicalLeafPlan = (NodeLogicalLeafPlan)A1;
                    object = nodeLogicalLeafPlan.idName();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof NodeLogicalLeafPlan;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return unstableLeaves.isEmpty() ? false : this.headConflicts(plannerQuery, plannerQuery, (Seq<String>)((Seq)unstableLeaves.tail()));
    }

    private boolean headConflicts(PlannerQuery head, PlannerQuery tail, Seq<String> unstableLeaves) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        boolean conflict;
                        boolean mergeReadWrite;
                        PlannerQuery plannerQuery = head;
                        PlannerQuery plannerQuery2 = tail;
                        boolean bl2 = !(plannerQuery != null ? !plannerQuery.equals(plannerQuery2) : plannerQuery2 != null) && head.queryGraph().containsMergeRecursive() ? true : (mergeReadWrite = false);
                        boolean bl3 = tail.queryGraph().readOnly() || mergeReadWrite ? false : (conflict = this.hasUnsafeRelationships(head.queryGraph()) && (tail.queryGraph().createRelationshipOverlap(head.queryGraph()) || tail.queryGraph().deleteOverlap(head.queryGraph()) || tail.queryGraph().setPropertyOverlap(head.queryGraph())) || unstableLeaves.exists((Function1)new Serializable(head, tail){
                            public static final long serialVersionUID = 0L;
                            private final PlannerQuery head$1;
                            private final PlannerQuery tail$1;

                            public final boolean apply(String x$1) {
                                return Eagerness$.MODULE$.org$neo4j$cypher$internal$compiler$v3_4$planner$logical$Eagerness$$nodeOverlap(x$1, this.head$1.queryGraph(), this.tail$1) || this.tail$1.queryGraph().createRelationshipOverlap(this.head$1.queryGraph()) || this.tail$1.queryGraph().setLabelOverlap(this.head$1.queryGraph()) || this.tail$1.queryGraph().setPropertyOverlap(this.head$1.queryGraph()) || this.tail$1.queryGraph().deleteOverlap(this.head$1.queryGraph()) || this.tail$1.queryGraph().foreachOverlap(this.head$1.queryGraph());
                            }
                            {
                                this.head$1 = head$1;
                                this.tail$1 = tail$1;
                            }
                        }));
                        if (!conflict) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!tail.tail().isEmpty()) break block5;
                    bl = false;
                }
                return bl;
            }
            tail = (PlannerQuery)tail.tail().get();
        }
    }

    public LogicalPlan headReadWriteEagerize(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflictInHead(inputPlan, query) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeNonRecursive(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflict(query, query) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeRecursive(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || query.tail().isDefined() && this.readWriteConflictInTail(query, (PlannerQuery)query.tail().get()) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan headWriteReadEagerize(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInHead(query, (PlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailWriteReadEagerize(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInTail(query, (PlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan horizonReadWriteEagerize(LogicalPlan inputPlan, PlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        LogicalPlan logicalPlan2 = inputPlan;
        if (logicalPlan2 instanceof ProcedureCall) {
            ProcedureCall procedureCall = (ProcedureCall)logicalPlan2;
            LogicalPlan left = procedureCall.source();
            ResolvedCall call = procedureCall.call();
            if (call.signature().eager()) {
                return context.logicalPlanProducer().planCallProcedure(context.logicalPlanProducer().planEager(left, context), call, context);
            }
        }
        if (alwaysEager) return context.logicalPlanProducer().planEager(inputPlan, context);
        if (!query.tail().nonEmpty()) return inputPlan;
        if (!this.horizonReadWriteConflict(query, (PlannerQuery)query.tail().get(), context)) return inputPlan;
        return context.logicalPlanProducer().planEager(inputPlan, context);
    }

    public boolean readWriteConflictInTail(PlannerQuery head, PlannerQuery tail) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        boolean conflict;
                        if (!(conflict = this.readWriteConflict(head, tail))) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!tail.tail().isEmpty()) break block5;
                    bl = false;
                }
                return bl;
            }
            tail = (PlannerQuery)tail.tail().get();
        }
    }

    public boolean readWriteConflict(PlannerQuery readQuery, PlannerQuery writeQuery) {
        PlannerQuery plannerQuery = readQuery;
        PlannerQuery plannerQuery2 = writeQuery;
        boolean mergeReadWrite = !(plannerQuery != null ? !plannerQuery.equals(plannerQuery2) : plannerQuery2 != null) && readQuery.queryGraph().containsMergeRecursive();
        boolean conflict = writeQuery.queryGraph().readOnly() || mergeReadWrite ? false : writeQuery.queryGraph().overlaps(readQuery.queryGraph());
        return conflict;
    }

    public boolean writeReadConflictInTail(PlannerQuery head, PlannerQuery tail, LogicalPlanningContext context) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        boolean conflict;
                        boolean bl2 = tail.queryGraph().writeOnly() ? false : (conflict = head.queryGraph().overlaps(tail.queryGraph()) || head.queryGraph().overlapsHorizon(tail.horizon(), context.semanticTable()) || this.deleteReadOverlap(head.queryGraph(), tail.queryGraph(), context));
                        if (!conflict) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!tail.tail().isEmpty()) break block5;
                    bl = false;
                }
                return bl;
            }
            tail = (PlannerQuery)tail.tail().get();
        }
    }

    public boolean horizonReadWriteConflict(PlannerQuery head, PlannerQuery tail, LogicalPlanningContext context) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        boolean conflict;
                        if (!(conflict = tail.queryGraph().overlapsHorizon(head.horizon(), context.semanticTable()))) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!tail.tail().isEmpty()) break block5;
                    bl = false;
                }
                return bl;
            }
            tail = (PlannerQuery)tail.tail().get();
        }
    }

    private boolean deleteReadOverlap(QueryGraph from, QueryGraph to, LogicalPlanningContext context) {
        Set deleted = from.identifiersToDelete();
        return this.deletedRelationshipsOverlap((Set<String>)deleted, to, context) || this.deletedNodesOverlap((Set<String>)deleted, to, context);
    }

    private boolean deletedRelationshipsOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set relsToRead = to.allPatternRelationshipsRead();
        Set relsDeleted = (Set)deleted.filter((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final LogicalPlanningContext context$1;

            public final boolean apply(String id) {
                return this.context$1.semanticTable().isRelationship(id);
            }
            {
                this.context$1 = context$1;
            }
        });
        return relsToRead.nonEmpty() && relsDeleted.nonEmpty();
    }

    private boolean deletedNodesOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set nodesToRead = to.allPatternNodesRead();
        Set nodesDeleted = (Set)deleted.filter((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final LogicalPlanningContext context$2;

            public final boolean apply(String id) {
                return this.context$2.semanticTable().isNode(id);
            }
            {
                this.context$2 = context$2;
            }
        });
        return nodesToRead.nonEmpty() && nodesDeleted.nonEmpty();
    }

    public boolean writeReadConflictInHead(PlannerQuery head, PlannerQuery tail, LogicalPlanningContext context) {
        return head.queryGraph().writeOnly() ? this.writeReadConflictInHeadRecursive(head, tail) : this.writeReadConflictInTail(head, tail, context);
    }

    public boolean writeReadConflictInHeadRecursive(PlannerQuery head, PlannerQuery tail) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    block3: {
                        boolean conflict;
                        boolean bl2 = conflict = tail.queryGraph().writeOnly() ? false : head.queryGraph().writeOnlyHeadOverlaps(tail.queryGraph());
                        if (!conflict) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!tail.tail().isEmpty()) break block5;
                    bl = false;
                }
                return bl;
            }
            tail = (PlannerQuery)tail.tail().get();
        }
    }

    public boolean org$neo4j$cypher$internal$compiler$v3_4$planner$logical$Eagerness$$nodeOverlap(String currentNode, QueryGraph headQueryGraph, PlannerQuery tail) {
        Set labelsOnCurrentNode = headQueryGraph.allKnownLabelsOnNode(currentNode);
        Set propertiesOnCurrentNode = (Set)headQueryGraph.allKnownPropertiesOnIdentifier(currentNode).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PropertyKeyName apply(Property x$2) {
                return x$2.propertyKey();
            }
        }, Set$.MODULE$.canBuildFrom());
        Set labelsToCreate = tail.queryGraph().createLabels();
        CreatesPropertyKeys propertiesToCreate = tail.queryGraph().createNodeProperties();
        Set labelsToRemove = tail.queryGraph().labelsToRemoveFromOtherNodes(currentNode);
        boolean tailCreatesNodes = tail.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PlannerQuery x$3) {
                return x$3.queryGraph().createsNodes();
            }
        });
        return tail.queryGraph().updatesNodes() && (labelsOnCurrentNode.isEmpty() && propertiesOnCurrentNode.isEmpty() && tailCreatesNodes || ((TraversableOnce)labelsOnCurrentNode.intersect((GenSet)labelsToCreate)).nonEmpty() || propertiesOnCurrentNode.exists((Function1)new Serializable(propertiesToCreate){
            public static final long serialVersionUID = 0L;
            private final CreatesPropertyKeys propertiesToCreate$1;

            public final boolean apply(PropertyKeyName propertyKeyName) {
                return this.propertiesToCreate$1.overlaps(propertyKeyName);
            }
            {
                this.propertiesToCreate$1 = propertiesToCreate$1;
            }
        }) || ((TraversableOnce)labelsToRemove.intersect((GenSet)labelsOnCurrentNode)).nonEmpty());
    }

    private boolean hasUnsafeRelationships(QueryGraph queryGraph) {
        return this.hasRelationships(queryGraph);
    }

    private boolean hasRelationships(QueryGraph queryGraph) {
        return queryGraph.allPatternRelationships().nonEmpty();
    }

    private Eagerness$() {
        MODULE$ = this;
    }
}

