/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.common;

import java.util.Arrays;
import java.util.HashMap;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.cypher.internal.compiler.v3_5.common.CypherOrderability;
import org.neo4j.cypher.internal.v3_5.util.IncomparableValuesException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.VirtualValues;

public class CypherOrderabilityTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    public static Object[] values = new Object[]{new HashMap(), VirtualValues.node((long)1L), VirtualValues.node((long)2L), VirtualValues.relationship((long)1L), VirtualValues.relationship((long)2L), new String[]{"boo"}, new String[]{"foo"}, new boolean[]{false}, new Boolean[]{true}, new Object[]{1, "foo"}, new Object[]{1, "foo", 3}, new Object[]{1, true, "car"}, new Object[]{1, 2, "bar"}, new Object[]{1, 2, "car"}, new int[]{1, 2, 3}, new Object[]{1, 2, 3L, Double.NEGATIVE_INFINITY}, new long[]{1L, 2L, 3L, Long.MIN_VALUE}, new int[]{1, 2, 3, Integer.MIN_VALUE}, new Object[]{1L, 2, 3, Double.NaN}, ValueUtils.of((Object)new Object[]{1L, 2, 3, null}), new Long[]{1L, 2L, 4L}, new int[]{2}, new Integer[]{3}, new double[]{4.0}, new Double[]{5.0}, new float[]{6.0f}, new Float[]{Float.valueOf(7.0f)}, ValueUtils.of((Object)new Object[]{null}), "", Character.valueOf('\u0000'), " ", "20", "X", "Y", "x", "y", Character.valueOf('\ud800'), Character.valueOf('\udbff'), Character.valueOf('\udc00'), Character.valueOf('\udfff'), Character.valueOf('\uffff'), false, true, Double.NEGATIVE_INFINITY, -1.7976931348623157E308, Long.MIN_VALUE, -9223372036854775807L, Integer.MIN_VALUE, (short)Short.MIN_VALUE, (byte)-128, 0, Double.MIN_VALUE, Double.MIN_NORMAL, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_NORMAL), 1L, 1.1, Float.valueOf(1.2f), Math.E, Math.PI, (byte)10, (short)20, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, 9.007199254740992E15, 0x20000000000001L, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN, null};

    @Test
    public void shouldOrderValuesCorrectly() {
        for (int i = 2; i < values.length; ++i) {
            for (int j = 2; j < values.length; ++j) {
                int cmpVal;
                Object left = values[i];
                Object right = values[j];
                int cmpPos = this.sign(i - j);
                if (cmpPos != (cmpVal = this.sign(this.compare(left, right)))) {
                    throw new AssertionError((Object)String.format("Comparing %s against %s does not agree with their positions in the sorted list (%d and %d)", this.toString(left), this.toString(right), i, j));
                }
            }
        }
    }

    private String toString(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        if (clazz.equals(Object[].class)) {
            return Arrays.toString((Object[])o);
        }
        if (clazz.equals(int[].class)) {
            return Arrays.toString((int[])o);
        }
        if (clazz.equals(Integer[].class)) {
            return Arrays.toString((Object[])((Integer[])o));
        }
        if (clazz.equals(long[].class)) {
            return Arrays.toString((long[])o);
        }
        if (clazz.equals(Long[].class)) {
            return Arrays.toString((Object[])((Long[])o));
        }
        if (clazz.equals(String[].class)) {
            return Arrays.toString((String[])o);
        }
        if (clazz.equals(boolean[].class)) {
            return Arrays.toString((boolean[])o);
        }
        if (clazz.equals(Boolean[].class)) {
            return Arrays.toString((Object[])((Boolean[])o));
        }
        return o.toString();
    }

    private <T> int compare(T left, T right) {
        try {
            int cmp1 = CypherOrderability.compare(left, right);
            int cmp2 = CypherOrderability.compare(right, left);
            if (this.sign(cmp1) != -this.sign(cmp2)) {
                throw new AssertionError((Object)String.format("Comparator is not symmetric on %s and %s", left, right));
            }
            return cmp1;
        }
        catch (IncomparableValuesException e) {
            throw new AssertionError(String.format("Failed to compare %s:%s and %s:%s", left, left.getClass().getName(), right, right.getClass().getName()), e);
        }
    }

    private int sign(int value) {
        return Integer.compare(value, 0);
    }
}

