/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.phases;

import java.time.Duration;
import org.neo4j.cypher.internal.compiler.v3_5.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.compiler.v3_5.StatsDivergenceCalculator$;
import org.neo4j.cypher.internal.compiler.v3_5.StatsDivergenceNoDecayCalculator;
import org.neo4j.cypher.internal.compiler.v3_5.phases.StatsDivergenceCalculatorTest$;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Settings;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\ti2\u000b^1ug\u0012Kg/\u001a:hK:\u001cWmQ1mGVd\u0017\r^8s)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001\u000f[1tKNT!!\u0002\u0004\u0002\tY\u001ct,\u000e\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u00181\u0005!Q\u000f^5m\u0015\t)\u0001\"\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u001d\t\u0003A1A\u0005\u0002\t\nq\u0003Z3gCVdG/\u00138ji&\fG\u000e\u00165sKNDw\u000e\u001c3\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a\u0001R8vE2,\u0007B\u0002\u0016\u0001A\u0003%1%\u0001\reK\u001a\fW\u000f\u001c;J]&$\u0018.\u00197UQJ,7\u000f[8mI\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005!%\u0001\feK\u001a\fW\u000f\u001c;UCJ<W\r\u001e+ie\u0016\u001c\bn\u001c7e\u0011\u0019q\u0003\u0001)A\u0005G\u00059B-\u001a4bk2$H+\u0019:hKR$\u0006N]3tQ>dG\r\t\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0003Y!WMZ1vYRLe.\u001b;jC2Le\u000e^3sm\u0006dW#\u0001\u001a\u0011\u0005\u0011\u001a\u0014B\u0001\u001b&\u0005\u0011auN\\4\t\rY\u0002\u0001\u0015!\u00033\u0003]!WMZ1vYRLe.\u001b;jC2Le\u000e^3sm\u0006d\u0007\u0005C\u00049\u0001\t\u0007I\u0011A\u0019\u0002+\u0011,g-Y;miR\u000b'oZ3u\u0013:$XM\u001d<bY\"1!\b\u0001Q\u0001\nI\na\u0003Z3gCVdG\u000fV1sO\u0016$\u0018J\u001c;feZ\fG\u000e\t\u0005\by\u0001\u0011\r\u0011\"\u0001#\u00035i\u0017M]4j]>3WI\u001d:pe\"1a\b\u0001Q\u0001\n\r\na\"\\1sO&twJZ#se>\u0014\b\u0005C\u0003A\u0001\u0011%\u0011)A\u0007bgN,'\u000f\u001e(p\t\u0016\u001c\u0017-\u001f\u000b\u0007\u0005\u0016s\u0005K\u0015+\u0011\u0005\u0011\u001a\u0015B\u0001#&\u0005\u0011)f.\u001b;\t\u000b\u0019{\u0004\u0019A$\u0002\t9\fW.\u001a\t\u0003\u0011.s!\u0001J%\n\u0005)+\u0013A\u0002)sK\u0012,g-\u0003\u0002M\u001b\n11\u000b\u001e:j]\u001eT!AS\u0013\t\u000b={\u0004\u0019A\u0012\u0002!%t\u0017\u000e^5bYRC'/Z:i_2$\u0007\"B)@\u0001\u0004\u0019\u0013a\u0004;be\u001e,G\u000f\u00165sKNDw\u000e\u001c3\t\u000bM{\u0004\u0019\u0001\u001a\u0002\u001f%t\u0017\u000e^5bY&sG/\u001a:wC2DQ!V A\u0002I\na\u0002^1sO\u0016$\u0018J\u001c;feZ\fG\u000eC\u0003A\u0001\u0011%q\u000bF\u0003C1f{\u0016\rC\u0003G-\u0002\u0007q\tC\u0003[-\u0002\u00071,\u0001\u0006eSZ,'oZ3oG\u0016\u0004\"\u0001X/\u000e\u0003\u0011I!A\u0018\u0003\u00033M#\u0018\r^:ESZ,'oZ3oG\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0005\u0006AZ\u0003\raI\u0001\ni\"\u0014Xm\u001d5pY\u0012DQA\u0019,A\u0002I\n\u0001\"\u001b8uKJ4\u0018\r\u001c\u0005\u0006I\u0002!I!Z\u0001\u0016CN\u001cXM\u001d;EK\u000e\f\u0017p]'bW\u0016\u001cVM\\:f)\u0019\u0011em\u001a5jU\")ai\u0019a\u0001\u000f\")qj\u0019a\u0001G!)\u0011k\u0019a\u0001G!)1k\u0019a\u0001e!)Qk\u0019a\u0001e\u0001")
public class StatsDivergenceCalculatorTest
extends CypherFunSuite {
    private final double defaultInitialThreshold = new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.query_statistics_divergence_threshold.getDefaultValue())).toDouble();
    private final double defaultTargetThreshold = new StringOps(Predef$.MODULE$.augmentString(GraphDatabaseSettings.query_statistics_divergence_target.getDefaultValue())).toDouble();
    private final long defaultInitialInterval = ((Duration)Settings.DURATION.apply(GraphDatabaseSettings.cypher_min_replan_interval.getDefaultValue())).toMillis();
    private final long defaultTargetInterval = ((Duration)Settings.DURATION.apply(GraphDatabaseSettings.cypher_replan_interval_target.getDefaultValue())).toMillis();
    private final double marginOfError;

    public double defaultInitialThreshold() {
        return this.defaultInitialThreshold;
    }

    public double defaultTargetThreshold() {
        return this.defaultTargetThreshold;
    }

    public long defaultInitialInterval() {
        return this.defaultInitialInterval;
    }

    public long defaultTargetInterval() {
        return this.defaultTargetInterval;
    }

    public double marginOfError() {
        return this.marginOfError;
    }

    public void org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(String name, double initialThreshold, double targetThreshold, long initialInterval, long targetInterval) {
        StatsDivergenceCalculator divergence = StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(name, initialThreshold, targetThreshold, initialInterval, targetInterval);
        this.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, divergence, initialThreshold, initialInterval);
    }

    public void org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(String name, StatsDivergenceCalculator divergence, double threshold, long interval) {
        this.withClue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For decay algorithm '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Function0)new Serializable(this, divergence, threshold, interval){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;
            private final StatsDivergenceCalculator divergence$1;
            private final double threshold$1;
            private final long interval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)this.divergence$1.decay(0L))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)this.threshold$1)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)this.divergence$1.decay(this.interval$1 / 2L))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)this.threshold$1)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)this.divergence$1.decay(this.interval$1))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)this.threshold$1)));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)this.divergence$1.decay(this.interval$1 * 2L))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)this.threshold$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.divergence$1 = divergence$1;
                this.threshold$1 = threshold$1;
                this.interval$1 = interval$1;
            }
        });
    }

    public void org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense(String name, double initialThreshold, double targetThreshold, long initialInterval, long targetInterval) {
        this.withClue("Testing intervals that differ by only 1 is not supported in this test:", (Function0)new Serializable(this, initialInterval, targetInterval){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;
            private final long initialInterval$1;
            private final long targetInterval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)this.targetInterval$1)).should(this.$outer.be().$greater$eq((Object)BoxesRunTime.boxToLong((long)(this.initialInterval$1 + 2L)), (Ordering)Ordering.Long$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialInterval$1 = initialInterval$1;
                this.targetInterval$1 = targetInterval$1;
            }
        });
        this.withClue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For decay algorithm '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Function0)new Serializable(this, name, initialThreshold, targetThreshold, initialInterval, targetInterval){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;
            private final String name$1;
            private final double initialThreshold$1;
            private final double targetThreshold$1;
            private final long initialInterval$1;
            private final long targetInterval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StatsDivergenceCalculator divergence = StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(this.name$1, this.initialThreshold$1, this.targetThreshold$1, this.initialInterval$1, this.targetInterval$1);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)divergence.decay(this.initialInterval$1))).should(this.$outer.be().apply(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)this.initialThreshold$1), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)this.$outer.marginOfError()))));
                double decayed = divergence.decay((this.initialInterval$1 + this.targetInterval$1) / 2L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)decayed)).should(this.$outer.be().$greater((Object)BoxesRunTime.boxToDouble((double)this.targetThreshold$1), (Ordering)Ordering.Double$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)decayed)).should(this.$outer.be().$less((Object)BoxesRunTime.boxToDouble((double)this.initialThreshold$1), (Ordering)Ordering.Double$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)divergence.decay(this.targetInterval$1))).should(this.$outer.be().apply(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)this.targetThreshold$1), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)this.$outer.marginOfError()))));
                double furtherDecayed = divergence.decay(this.targetInterval$1 * 2L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)furtherDecayed)).should(this.$outer.be().$less((Object)BoxesRunTime.boxToDouble((double)this.targetThreshold$1), (Ordering)Ordering.Double$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)furtherDecayed)).should(this.$outer.be().$greater$eq((Object)BoxesRunTime.boxToDouble((double)0.0), (Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
                this.initialThreshold$1 = initialThreshold$1;
                this.targetThreshold$1 = targetThreshold$1;
                this.initialInterval$1 = initialInterval$1;
                this.targetInterval$1 = targetInterval$1;
            }
        });
    }

    public StatsDivergenceCalculatorTest() {
        this.marginOfError = 1.0E-4;
        this.test("Disabling decay should show no decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StatsDivergenceNoDecayCalculator divergence = StatsDivergenceCalculator$.MODULE$.divergenceNoDecayCalculator(this.$outer.defaultInitialThreshold(), this.$outer.defaultInitialInterval());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(StatsDivergenceCalculator$.MODULE$.none(), (StatsDivergenceCalculator)divergence, this.$outer.defaultInitialThreshold(), this.$outer.defaultInitialInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Using algorithm 'none' decay should show no decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(StatsDivergenceCalculator$.MODULE$.none(), this.$outer.defaultInitialThreshold(), this.$outer.defaultTargetThreshold(), this.$outer.defaultInitialInterval(), this.$outer.defaultTargetInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Default values should make sense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense("default", this.$outer.defaultInitialThreshold(), this.$outer.defaultTargetThreshold(), this.$outer.defaultInitialInterval(), this.$outer.defaultTargetInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Default values should make sense with inverse decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense(StatsDivergenceCalculator$.MODULE$.inverse(), this.$outer.defaultInitialThreshold(), this.$outer.defaultTargetThreshold(), this.$outer.defaultInitialInterval(), this.$outer.defaultTargetInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Default values should make sense with exponential decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense(StatsDivergenceCalculator$.MODULE$.exponential(), this.$outer.defaultInitialThreshold(), this.$outer.defaultTargetThreshold(), this.$outer.defaultInitialInterval(), this.$outer.defaultTargetInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Equal threshold should disable decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, 0.5, 0.5, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialInterval(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetInterval());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Increasing threshold should disable decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, 0.5, 0.75, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialInterval(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetInterval());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Target threshold of zero should disable decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, 0.5, 0.0, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialInterval(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetInterval());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Small target threshold should work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense(name, 0.5, 0.001, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialInterval(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetInterval());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Not changing time should disable decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialThreshold(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetThreshold(), 1000L, 1000L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Going back in time should disable decay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertNoDecay(name, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialThreshold(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetThreshold(), 1000L, 500L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Small time interval should work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDivergenceCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StatsDivergenceCalculator$.MODULE$.inverse(), StatsDivergenceCalculator$.MODULE$.exponential()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply(String name) {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$assertDecaysMakeSense(name, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultInitialThreshold(), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer().defaultTargetThreshold(), 1000L, 1002L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StatsDivergenceCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$phases$StatsDivergenceCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

