/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.assumeIndependence;

import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.assumeIndependence.PatternSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.assumeIndependence.PatternSelectivityCalculatorTest$;
import org.neo4j.cypher.internal.ir.v3_5.PatternLength;
import org.neo4j.cypher.internal.ir.v3_5.PatternRelationship;
import org.neo4j.cypher.internal.ir.v3_5.Predicate;
import org.neo4j.cypher.internal.ir.v3_5.Selections;
import org.neo4j.cypher.internal.ir.v3_5.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.v3_5.VarPatternLength;
import org.neo4j.cypher.internal.planner.v3_5.spi.GraphStatistics;
import org.neo4j.cypher.internal.v3_5.ast.ASTAnnotationMap;
import org.neo4j.cypher.internal.v3_5.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticTable$;
import org.neo4j.cypher.internal.v3_5.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.Equals;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.v3_5.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_5.expressions.LabelName;
import org.neo4j.cypher.internal.v3_5.expressions.LessThan;
import org.neo4j.cypher.internal.v3_5.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_5.expressions.Property;
import org.neo4j.cypher.internal.v3_5.expressions.SemanticDirection;
import org.neo4j.cypher.internal.v3_5.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.Variable;
import org.neo4j.cypher.internal.v3_5.util.Cardinality;
import org.neo4j.cypher.internal.v3_5.util.Cardinality$;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.LabelId;
import org.neo4j.cypher.internal.v3_5.util.Selectivity;
import org.neo4j.cypher.internal.v3_5.util.Selectivity$;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001/\t\u0001\u0003+\u0019;uKJt7+\u001a7fGRLg/\u001b;z\u0007\u0006d7-\u001e7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\nbgN,X.Z%oI\u0016\u0004XM\u001c3f]\u000e,'BA\u0003\u0007\u0003-\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=\u000b\u0005\u001dA\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005!aoM06\u0015\tia\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\ty\u0001#\u0001\u0005j]R,'O\\1m\u0015\t\t\"#\u0001\u0004dsBDWM\u001d\u0006\u0003'Q\tQA\\3pi)T\u0011!F\u0001\u0004_J<7\u0001A\n\u0004\u0001a\t\u0003CA\r \u001b\u0005Q\"BA\u000e\u001d\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tib$\u0001\u0003vi&d'BA\u0006\u000f\u0013\t\u0001#D\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011r\u0012aA1ti&\u0011ae\t\u0002\u001b\u0003N$8i\u001c8tiJ,8\r^5p]R+7\u000f^*vaB|'\u000f\u001e\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003\t\u0001")
public class PatternSelectivityCalculatorTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$v3_5$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public FunctionInvocation exists(Expression e) {
        return AstConstructionTestSupport.class.exists((AstConstructionTestSupport)this, (Expression)e);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public MapExpression mapOf(Seq<Tuple2<String, Expression>> keysAndValues) {
        return AstConstructionTestSupport.class.mapOf((AstConstructionTestSupport)this, keysAndValues);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public FunctionInvocation function(String name, Seq<Expression> args) {
        return AstConstructionTestSupport.class.function((AstConstructionTestSupport)this, (String)name, args);
    }

    public FunctionInvocation function(String name, boolean deprecated, Seq<Expression> args) {
        return AstConstructionTestSupport.class.function((AstConstructionTestSupport)this, (String)name, (boolean)deprecated, args);
    }

    public PatternSelectivityCalculatorTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("should return zero if there are no nodes with the given labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(0.0));
                Mockito.when((Object)stats.nodesAllCardinality()).thenReturn((Object)Cardinality$.MODULE$.EMPTY());
                Mockito.when((Object)stats.cardinalityByLabelsAndRelationshipType((Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(42.0));
                PatternSelectivityCalculator calculator = new PatternSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                PatternRelationship relationship = new PatternRelationship("r", new Tuple2((Object)"a", (Object)"b"), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                LabelName label = new LabelName("L", this.$outer.pos());
                Map x$2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"L"), (Object)new LabelId(0))}));
                ASTAnnotationMap x$3 = SemanticTable$.MODULE$.$lessinit$greater$default$1();
                ASTAnnotationMap x$4 = SemanticTable$.MODULE$.$lessinit$greater$default$2();
                Map x$5 = SemanticTable$.MODULE$.$lessinit$greater$default$4();
                Map x$6 = SemanticTable$.MODULE$.$lessinit$greater$default$5();
                SemanticTable semanticTable = new SemanticTable(x$3, x$4, x$2, x$5, x$6);
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)new HasLabels((Expression)this.$outer.varFor("a"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})), this.$outer.pos()))})));
                Selectivity result = calculator.apply(relationship, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})))})), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Selectivity$.MODULE$.ZERO()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not consider label selectivity twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(1.0));
                Mockito.when((Object)stats.nodesAllCardinality()).thenReturn((Object)Cardinality$.MODULE$.SINGLE());
                Mockito.when((Object)stats.cardinalityByLabelsAndRelationshipType((Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(42.0));
                PatternSelectivityCalculator calculator = new PatternSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                PatternRelationship relationship = new PatternRelationship("r", new Tuple2((Object)"a", (Object)"b"), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                LabelName label = new LabelName("L", this.$outer.pos());
                Map x$7 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"L"), (Object)new LabelId(0))}));
                ASTAnnotationMap x$8 = SemanticTable$.MODULE$.$lessinit$greater$default$1();
                ASTAnnotationMap x$9 = SemanticTable$.MODULE$.$lessinit$greater$default$2();
                Map x$10 = SemanticTable$.MODULE$.$lessinit$greater$default$4();
                Map x$11 = SemanticTable$.MODULE$.$lessinit$greater$default$5();
                SemanticTable semanticTable = new SemanticTable(x$8, x$9, x$7, x$10, x$11);
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)new HasLabels((Expression)this.$outer.varFor("a"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})), this.$outer.pos()))})));
                Selectivity result = calculator.apply(relationship, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})))})), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles variable length paths over 32 in length", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(1.0));
                Mockito.when((Object)stats.nodesAllCardinality()).thenReturn((Object)Cardinality$.MODULE$.SINGLE());
                Mockito.when((Object)stats.cardinalityByLabelsAndRelationshipType((Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(3.0));
                PatternSelectivityCalculator calculator = new PatternSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                PatternRelationship relationship = new PatternRelationship("r", new Tuple2((Object)"a", (Object)"b"), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)new VarPatternLength(33, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)33))));
                LabelName label = new LabelName("L", this.$outer.pos());
                Map x$12 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"L"), (Object)new LabelId(0))}));
                ASTAnnotationMap x$13 = SemanticTable$.MODULE$.$lessinit$greater$default$1();
                ASTAnnotationMap x$14 = SemanticTable$.MODULE$.$lessinit$greater$default$2();
                Map x$15 = SemanticTable$.MODULE$.$lessinit$greater$default$4();
                Map x$16 = SemanticTable$.MODULE$.$lessinit$greater$default$5();
                SemanticTable semanticTable = new SemanticTable(x$13, x$14, x$12, x$15, x$16);
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)new HasLabels((Expression)this.$outer.varFor("a"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})), this.$outer.pos()))})));
                Selectivity result = calculator.apply(relationship, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})))})), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not produce selectivities larger than 1.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Cardinality>(this){

                    public Cardinality answer(InvocationOnMock invocationOnMock) {
                        Option option;
                        block4: {
                            Cardinality cardinality;
                            block3: {
                                block2: {
                                    Option arg = (Option)invocationOnMock.getArgument(0);
                                    option = arg;
                                    if (!None$.MODULE$.equals(option)) break block2;
                                    cardinality = new Cardinality(1.0);
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                cardinality = new Cardinality(1.0);
                            }
                            return cardinality;
                        }
                        throw new MatchError((Object)option);
                    }
                });
                Mockito.when((Object)stats.nodesAllCardinality()).thenReturn((Object)new Cardinality(10.0));
                Mockito.when((Object)stats.cardinalityByLabelsAndRelationshipType((Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)new Cardinality(42.0));
                PatternSelectivityCalculator calculator = new PatternSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                PatternRelationship relationship = new PatternRelationship("r", new Tuple2((Object)"a", (Object)"b"), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                HashMap labels = new HashMap();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).foreach((Function1)new Serializable(this, labels){
                    public static final long serialVersionUID = 0L;
                    private final HashMap labels$1;

                    public final Option<LabelId> apply(int i) {
                        return this.labels$1.put((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (Object)new LabelId(i));
                    }
                    {
                        this.labels$1 = labels$1;
                    }
                });
                Iterable labelNames = (Iterable)labels.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final LabelName apply(String x$1) {
                        return new LabelName(x$1, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$cardinality$assumeIndependence$PatternSelectivityCalculatorTest$$anonfun$$$outer().pos());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Set predicates = ((TraversableOnce)labelNames.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Predicate apply(LabelName l) {
                        return new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)new HasLabels((Expression)this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$cardinality$assumeIndependence$PatternSelectivityCalculatorTest$$anonfun$$$outer().varFor("a"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{l})), this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$cardinality$assumeIndependence$PatternSelectivityCalculatorTest$$anonfun$$$outer().pos()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                HashMap x$17 = labels;
                ASTAnnotationMap x$18 = SemanticTable$.MODULE$.$lessinit$greater$default$1();
                ASTAnnotationMap x$19 = SemanticTable$.MODULE$.$lessinit$greater$default$2();
                Map x$20 = SemanticTable$.MODULE$.$lessinit$greater$default$4();
                Map x$21 = SemanticTable$.MODULE$.$lessinit$greater$default$5();
                SemanticTable semanticTable = new SemanticTable(x$18, x$19, (Map)x$17, x$20, x$21);
                Selections selections = new Selections(predicates);
                Selectivity result = calculator.apply(relationship, Predef$.MODULE$.Map().empty(), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ PatternSelectivityCalculatorTest org$neo4j$cypher$internal$compiler$v3_5$planner$logical$cardinality$assumeIndependence$PatternSelectivityCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

