/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.planner;

import org.neo4j.cypher.internal.compiler.v3_5.planner.PlannerQueryTest$;
import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder;
import org.neo4j.cypher.internal.ir.v3_5.LazyMode$;
import org.neo4j.cypher.internal.ir.v3_5.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_5.QueryGraph$;
import org.neo4j.cypher.internal.ir.v3_5.QueryHorizon;
import org.neo4j.cypher.internal.ir.v3_5.QueryProjection$;
import org.neo4j.cypher.internal.ir.v3_5.QueryShuffle;
import org.neo4j.cypher.internal.ir.v3_5.QueryShuffle$;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery$;
import org.neo4j.cypher.internal.ir.v3_5.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.v3_5.Selections;
import org.neo4j.cypher.internal.v3_5.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.v3_5.ast.SortItem;
import org.neo4j.cypher.internal.v3_5.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.Equals;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.v3_5.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_5.expressions.LabelName;
import org.neo4j.cypher.internal.v3_5.expressions.LessThan;
import org.neo4j.cypher.internal.v3_5.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_5.expressions.Property;
import org.neo4j.cypher.internal.v3_5.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.Variable;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001#\t\u0001\u0002\u000b\\1o]\u0016\u0014\u0018+^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\u001d7b]:,'O\u0003\u0002\u0006\r\u0005!aoM06\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IY\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t9\u0002$\u0001\u0003vi&d'BA\u0003\t\u0013\tQBC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\u0005qyR\"A\u000f\u000b\u0005yA\u0012aA1ti&\u0011\u0001%\b\u0002\u001b\u0003N$8i\u001c8tiJ,8\r^5p]R+7\u000f^*vaB|'\u000f\u001e\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003\t\u0001")
public class PlannerQueryTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$v3_5$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public FunctionInvocation exists(Expression e) {
        return AstConstructionTestSupport.class.exists((AstConstructionTestSupport)this, (Expression)e);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public MapExpression mapOf(Seq<Tuple2<String, Expression>> keysAndValues) {
        return AstConstructionTestSupport.class.mapOf((AstConstructionTestSupport)this, keysAndValues);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public FunctionInvocation function(String name, Seq<Expression> args) {
        return AstConstructionTestSupport.class.function((AstConstructionTestSupport)this, (String)name, args);
    }

    public FunctionInvocation function(String name, boolean deprecated, Seq<Expression> args) {
        return AstConstructionTestSupport.class.function((AstConstructionTestSupport)this, (String)name, (boolean)deprecated, args);
    }

    public PlannerQueryTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("pair map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph qg3;
                QueryGraph qg1 = QueryGraph$.MODULE$.empty();
                QueryGraph qg2 = QueryGraph$.MODULE$.empty();
                QueryGraph x$1 = qg3 = QueryGraph$.MODULE$.empty();
                None$ x$2 = None$.MODULE$;
                InterestingOrder x$3 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$4 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery pq3 = new RegularPlannerQuery(x$1, x$3, x$4, (Option)x$2);
                QueryGraph x$5 = qg2;
                Some x$6 = new Some((Object)pq3);
                InterestingOrder x$7 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$8 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery pq2 = new RegularPlannerQuery(x$5, x$7, x$8, (Option)x$6);
                QueryGraph x$9 = qg1;
                Some x$10 = new Some((Object)pq2);
                InterestingOrder x$11 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$12 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery pq1 = new RegularPlannerQuery(x$9, x$11, x$12, (Option)x$10);
                ObjectRef seenOnPos1 = ObjectRef.create((Object)List$.MODULE$.empty());
                ObjectRef seenOnPos2 = ObjectRef.create((Object)List$.MODULE$.empty());
                PlannerQuery result = pq1.foldMap((Function2)new Serializable(this, seenOnPos1, seenOnPos2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef seenOnPos1$1;
                    private final ObjectRef seenOnPos2$1;

                    public final PlannerQuery apply(PlannerQuery x0$1, PlannerQuery x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null) {
                                PlannerQuery plannerQuery = pq1;
                                if (pq2 != null) {
                                    PlannerQuery plannerQuery2 = pq2;
                                    this.seenOnPos1$1.elem = (List)((List)this.seenOnPos1$1.elem).$colon$plus((Object)plannerQuery, List$.MODULE$.canBuildFrom());
                                    this.seenOnPos2$1.elem = (List)((List)this.seenOnPos2$1.elem).$colon$plus((Object)plannerQuery2, List$.MODULE$.canBuildFrom());
                                    PlannerQuery plannerQuery3 = plannerQuery2;
                                    return plannerQuery3;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.seenOnPos1$1 = seenOnPos1$1;
                        this.seenOnPos2$1 = seenOnPos2$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos1.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RegularPlannerQuery[]{pq1, pq2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos2.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RegularPlannerQuery[]{pq2, pq3}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(pq1), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap on single plannerQuery returns that PQ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph x$13 = QueryGraph$.MODULE$.empty();
                None$ x$14 = None$.MODULE$;
                InterestingOrder x$15 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$16 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery input = new RegularPlannerQuery(x$13, x$15, x$16, (Option)x$14);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final PlannerQuery apply(PlannerQuery x0$2, PlannerQuery x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                throw this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$PlannerQueryTest$$anonfun$$$outer().fail("should not pass through here");
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(input), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ PlannerQueryTest org$neo4j$cypher$internal$compiler$v3_5$planner$PlannerQueryTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap plannerQuery with tail should change when reverseMapped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularPlannerQuery tail = new RegularPlannerQuery(QueryGraph$.MODULE$.empty(), RegularPlannerQuery$.MODULE$.apply$default$2(), RegularPlannerQuery$.MODULE$.apply$default$3(), RegularPlannerQuery$.MODULE$.apply$default$4());
                QueryGraph firstQueryGraph = QueryGraph$.MODULE$.empty();
                Set x$17 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set x$18 = QueryGraph$.MODULE$.apply$default$1();
                Set x$19 = QueryGraph$.MODULE$.apply$default$3();
                Selections x$20 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$21 = QueryGraph$.MODULE$.apply$default$5();
                Seq x$22 = QueryGraph$.MODULE$.apply$default$6();
                Set x$23 = QueryGraph$.MODULE$.apply$default$7();
                IndexedSeq x$24 = QueryGraph$.MODULE$.apply$default$8();
                QueryGraph secondQueryGraph = new QueryGraph(x$18, x$17, x$19, x$20, x$21, x$22, x$23, x$24);
                QueryGraph x$25 = firstQueryGraph;
                Some x$26 = new Some((Object)tail);
                InterestingOrder x$27 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$28 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery input = new RegularPlannerQuery(x$25, x$27, x$28, (Option)x$26);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this, secondQueryGraph){
                    public static final long serialVersionUID = 0L;
                    private final QueryGraph secondQueryGraph$1;

                    public final PlannerQuery apply(PlannerQuery x0$3, PlannerQuery x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                PlannerQuery plannerQuery = pq2;
                                PlannerQuery plannerQuery2 = plannerQuery.withQueryGraph(this.secondQueryGraph$1);
                                return plannerQuery2;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.secondQueryGraph$1 = secondQueryGraph$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.not()).equal((Object)input, Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.queryGraph()).should(this.$outer.equal(firstQueryGraph), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((PlannerQuery)result.tail().get()).queryGraph()).should(this.$outer.equal(secondQueryGraph), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute laziness preference correctly for a single planner query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                RegularQueryProjection shuffleWithLimit;
                RegularQueryProjection x$29 = QueryProjection$.MODULE$.empty();
                QueryGraph x$30 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$31 = RegularPlannerQuery$.MODULE$.apply$default$2();
                Option x$32 = RegularPlannerQuery$.MODULE$.apply$default$4();
                RegularPlannerQuery noLimit = new RegularPlannerQuery(x$30, x$31, (QueryHorizon)x$29, x$32);
                this.$outer.convertToAnyShouldWrapper(noLimit.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                Some x$33 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$34 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$35 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$36 = shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$34, x$35, (Option)x$33));
                QueryGraph x$37 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$38 = RegularPlannerQuery$.MODULE$.apply$default$2();
                Option x$39 = RegularPlannerQuery$.MODULE$.apply$default$4();
                RegularPlannerQuery hasLimit = new RegularPlannerQuery(x$37, x$38, (QueryHorizon)x$36, x$39);
                this.$outer.convertToAnyShouldWrapper(hasLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$41 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$42 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$43 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$40, x$42, (Option)x$41));
                QueryGraph x$44 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$45 = RegularPlannerQuery$.MODULE$.apply$default$2();
                Option x$46 = RegularPlannerQuery$.MODULE$.apply$default$4();
                RegularPlannerQuery hasLimitAndSort = new RegularPlannerQuery(x$44, x$45, (QueryHorizon)x$43, x$46);
                this.$outer.convertToAnyShouldWrapper(hasLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider planner query tails when computing laziness preference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                Some x$47 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$48 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$49 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$48, x$49, (Option)x$47));
                Seq x$50 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$51 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$52 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$53 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$50, x$52, (Option)x$51));
                QueryGraph x$54 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$55 = RegularPlannerQuery$.MODULE$.apply$default$2();
                Option x$56 = RegularPlannerQuery$.MODULE$.apply$default$4();
                RegularPlannerQuery pqWithLimitAndSort = new RegularPlannerQuery(x$54, x$55, (QueryHorizon)x$53, x$56);
                RegularQueryProjection x$57 = shuffleWithLimit;
                Some x$58 = new Some((Object)pqWithLimitAndSort);
                QueryGraph x$59 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$60 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery pqWithLimit = new RegularPlannerQuery(x$59, x$60, (QueryHorizon)x$57, (Option)x$58);
                Some x$61 = new Some((Object)pqWithLimit);
                QueryGraph x$62 = RegularPlannerQuery$.MODULE$.apply$default$1();
                InterestingOrder x$63 = RegularPlannerQuery$.MODULE$.apply$default$2();
                QueryHorizon x$64 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery pq = new RegularPlannerQuery(x$62, x$63, x$64, (Option)x$61);
                this.$outer.convertToAnyShouldWrapper(pq.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

