/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality;

import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.v3_5.util.Selectivity;
import org.neo4j.cypher.internal.v3_5.util.Selectivity$;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001+\t92+\u001a7fGRLg/\u001b;z\u0007>l'-\u001b8feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1bY1sI&t\u0017\r\\5us*\u0011QAB\u0001\bY><\u0017nY1m\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011\u0001\u0002<4?VR!a\u0003\u0007\u0002\u0011\r|W\u000e]5mKJT!!\u0004\b\u0002\u0011%tG/\u001a:oC2T!a\u0004\t\u0002\r\rL\b\u000f[3s\u0015\t\t\"#A\u0003oK>$$NC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u0018;5\t\u0001D\u0003\u0002\u001a5\u0005aA/Z:u?\",G\u000e]3sg*\u00111\u0004H\u0001\u0005kRLGN\u0003\u0002\n\u0019%\u0011a\u0004\u0007\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001")
public class SelectivityCombinerTest
extends CypherFunSuite {
    public SelectivityCombinerTest() {
        this.test("should not lose precision for intermediate numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq selectivities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Selectivity[]{(Selectivity)Selectivity$.MODULE$.of(1.0E-10).get(), (Selectivity)Selectivity$.MODULE$.of(2.0E-10).get()}));
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities(selectivities).get()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ZERO(), Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not lose precision for small numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq selectivities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Selectivity[]{(Selectivity)Selectivity$.MODULE$.of(1.0E-100).get(), (Selectivity)Selectivity$.MODULE$.of(2.0E-100).get(), (Selectivity)Selectivity$.MODULE$.of(1.0E-300).get()}));
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities(selectivities).get()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ZERO(), Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ANDing together works as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq selectivities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Selectivity[]{(Selectivity)Selectivity$.MODULE$.of(0.1).get(), (Selectivity)Selectivity$.MODULE$.of(0.2).get(), Selectivity$.MODULE$.ONE()}));
                double selectivity = ((Selectivity)IndependenceCombiner$.MODULE$.andTogetherSelectivities(selectivities).get()).factor();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)selectivity));
                TripleEqualsSupport.Spread $org_scalatest_assert_macro_right = this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)0.02), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)2.0E-18));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ORing together works as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq selectivities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Selectivity[]{(Selectivity)Selectivity$.MODULE$.of(0.1).get(), (Selectivity)Selectivity$.MODULE$.of(0.2).get()}));
                double selectivity = ((Selectivity)IndependenceCombiner$.MODULE$.orTogetherSelectivities(selectivities).get()).factor();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)selectivity));
                TripleEqualsSupport.Spread $org_scalatest_assert_macro_right = this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)0.28), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)2.8E-17));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("OR: size 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double a = 0.3;
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{a}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Selectivity apply(double x$1) {
                        return Selectivity$.MODULE$.apply(x$1);
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Selectivity x$2) {
                        return x$2.factor();
                    }
                }).get()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)a)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("OR: size 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double a = 0.3;
                double b = 0.85;
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{a, b}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Selectivity apply(double x$3) {
                        return Selectivity$.MODULE$.apply(x$3);
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Selectivity x$4) {
                        return x$4.factor();
                    }
                }).get()).should(this.$outer.be().apply(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)(a + b - a * b)), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)0.001))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("OR: size 3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double a = 0.3;
                double b = 0.85;
                double c = 0.077;
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{a, b, c}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Selectivity apply(double x$5) {
                        return Selectivity$.MODULE$.apply(x$5);
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Selectivity x$6) {
                        return x$6.factor();
                    }
                }).get()).should(this.$outer.be().apply(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)(a + b + c - a * b - a * c - b * c + a * b * c)), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)0.001))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("OR: size 4", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityCombinerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double a = 0.3;
                double b = 0.85;
                double c = 0.077;
                double d = 0.935489;
                this.$outer.convertToAnyShouldWrapper(IndependenceCombiner$.MODULE$.orTogetherSelectivities((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{a, b, c, d}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Selectivity apply(double x$7) {
                        return Selectivity$.MODULE$.apply(x$7);
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Selectivity x$8) {
                        return x$8.factor();
                    }
                }).get()).should(this.$outer.be().apply(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)(a + b + c + d - a * b - a * c - a * d - b * c - b * d - c * d + a * b * c + a * b * d + a * c * d + b * c * d - a * b * c * d)), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)0.001))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

