/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_5.planner.logical.ordering;

import org.neo4j.cypher.internal.compiler.v3_5.planner.logical.ordering.ResultOrdering$;
import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder;
import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder$;
import org.neo4j.cypher.internal.ir.v3_5.ProvidedOrder$;
import org.neo4j.cypher.internal.planner.v3_5.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.package$;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001+\t\u0011\"+Z:vYR|%\u000fZ3sS:<G+Z:u\u0015\t\u0019A!\u0001\u0005pe\u0012,'/\u001b8h\u0015\t)a!A\u0004m_\u001eL7-\u00197\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tAA^\u001a`k)\u00111\u0002D\u0001\tG>l\u0007/\u001b7fe*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005E\u0011\u0012!\u00028f_RR'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001e\u001b\u0005A\"BA\r\u001b\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tYB$\u0001\u0003vi&d'BA\u0005\r\u0013\tq\u0002D\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\u0013\u0001\t\u00131\u0013AC2ba\u0006\u0014\u0017\u000e\\5usR\u0011qe\u0012\t\u0005Q-js(D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005%1UO\\2uS>t\u0017\u0007E\u0002/mer!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005I\"\u0012A\u0002\u001fs_>$h(C\u0001+\u0013\t)\u0014&A\u0004qC\u000e\\\u0017mZ3\n\u0005]B$aA*fc*\u0011Q'\u000b\t\u0003uuj\u0011a\u000f\u0006\u0003yi\tqa]=nE>d7/\u0003\u0002?w\tQ1)\u001f9iKJ$\u0016\u0010]3\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015aA:qS*\u0011\u0011\u0002\u0012\u0006\u0003\u000f1I!AR!\u0003)%sG-\u001a=Pe\u0012,'oQ1qC\nLG.\u001b;z\u0011\u0015)C\u00051\u0001@\u0001")
public class ResultOrderingTest
extends CypherFunSuite {
    public Function1<Seq<CypherType>, IndexOrderCapability> org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability(IndexOrderCapability capability2) {
        return new Serializable(this, capability2){
            public static final long serialVersionUID = 0L;
            private final IndexOrderCapability capability$1;

            public final IndexOrderCapability apply(Seq<CypherType> x$2) {
                return this.capability$1;
            }
            {
                this.capability$1 = capability$1;
            }
        };
    }

    public ResultOrderingTest() {
        this.test("Empty required order results in provided order of index order capability ascending", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger())}));
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(InterestingOrder$.MODULE$.empty(), properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required DESC still results in provided ASC if index is not capable of DESC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger())}));
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(InterestingOrder$.MODULE$.desc("x"), properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required ASC results in provided DESC if index is not capable of ASC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger())}));
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(InterestingOrder$.MODULE$.asc("x"), properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.DESC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.desc("x")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required order results in matching provided order for compatible index capability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger())}));
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(InterestingOrder$.MODULE$.asc("x"), properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x")));
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(InterestingOrder$.MODULE$.desc("x"), properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.DESC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.desc("x")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi property required order results in matching provided order for compatible index capability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"z", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y").asc("z");
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x").asc("y").asc("z")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi property required order results in provided order if property order does not match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"z", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y").asc("z");
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("y").asc("x").asc("z")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi property required order results in provided order if property order partially matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"z", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y").asc("z");
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x").asc("z").asc("y")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi property required order results in provided order if mixed sort direction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"z", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"w", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y").desc("z").asc("w");
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.BOTH$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x").asc("y").asc("z").asc("w")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Shorter multi property required order results in provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"z", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"w", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y");
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, this.$outer.org$neo4j$cypher$internal$compiler$v3_5$planner$logical$ordering$ResultOrderingTest$$capability((IndexOrderCapability)IndexOrderCapability.ASC$.MODULE$))).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x").asc("y").asc("z").asc("w")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Longer multi property required order results in partial matching provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResultOrderingTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)package$.MODULE$.CTInteger()), new Tuple2((Object)"y", (Object)package$.MODULE$.CTInteger())}));
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").asc("y").asc("z").asc("w");
                Serializable capabilities = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexOrderCapability.ASC$ apply(Seq<CypherType> x$1) {
                        return IndexOrderCapability.ASC$.MODULE$;
                    }
                };
                this.$outer.convertToAnyShouldWrapper(ResultOrdering$.MODULE$.withIndexOrderCapability(interestingOrder, properties, (Function1)capabilities)).should(this.$outer.be().apply((Object)ProvidedOrder$.MODULE$.asc("x").asc("y")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

