/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.planner.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.CardinalityByLabelsAndRelationshipType;
import org.neo4j.cypher.internal.planner.spi.DivergenceState;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatisticsSnapshot$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexPropertyExistsSelectivity;
import org.neo4j.cypher.internal.planner.spi.IndexSelectivity;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.MutableGraphStatisticsSnapshot;
import org.neo4j.cypher.internal.planner.spi.MutableGraphStatisticsSnapshot$;
import org.neo4j.cypher.internal.planner.spi.NodesAllCardinality$;
import org.neo4j.cypher.internal.planner.spi.NodesWithLabelCardinality;
import org.neo4j.cypher.internal.planner.spi.StatisticsKey;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0001\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C\u0001+\")1\f\u0001C\u00019\"9!\rAA\u0001\n\u0003\u0019\u0007bB3\u0001#\u0003%\tA\u001a\u0005\bc\u0002\t\t\u0011\"\u0011s\u0011\u001dY\b!!A\u0005\u0002qD\u0011\"!\u0001\u0001\u0003\u0003%\t!a\u0001\t\u0013\u0005=\u0001!!A\u0005B\u0005E\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\tY\u0003AA\u0001\n\u0003\ni\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0011\u00024!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0013q\u0007\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003w9\u0011\"a\u0010\u001c\u0003\u0003E\t!!\u0011\u0007\u0011iY\u0012\u0011!E\u0001\u0003\u0007Ba\u0001\u0015\n\u0005\u0002\u0005m\u0003\"CA\u001b%\u0005\u0005IQIA\u001c\u0011%\tiFEA\u0001\n\u0003\u000by\u0006\u0003\u0005\u0002dI\t\n\u0011\"\u0001g\u0011%\t)GEA\u0001\n\u0003\u000b9\u0007\u0003\u0005\u0002tI\t\n\u0011\"\u0001g\u0011%\t)HEA\u0001\n\u0013\t9HA\fHe\u0006\u0004\bn\u0015;bi&\u001cH/[2t':\f\u0007o\u001d5pi*\u0011A$H\u0001\u0004gBL'B\u0001\u0010 \u0003\u001d\u0001H.\u00198oKJT!\u0001I\u0011\u0002\u0011%tG/\u001a:oC2T!AI\u0012\u0002\r\rL\b\u000f[3s\u0015\t!S%A\u0003oK>$$NC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011f\f\u001a\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\tQ\u0003'\u0003\u00022W\t9\u0001K]8ek\u000e$\bCA\u001a<\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028O\u00051AH]8pizJ\u0011\u0001L\u0005\u0003u-\nq\u0001]1dW\u0006<W-\u0003\u0002={\ta1+\u001a:jC2L'0\u00192mK*\u0011!hK\u0001\fgR\fGo\u001d,bYV,7/F\u0001A!\u0011\tU\t\u0013'\u000f\u0005\t\u001b\u0005CA\u001b,\u0013\t!5&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u00131!T1q\u0015\t!5\u0006\u0005\u0002J\u00156\t1$\u0003\u0002L7\ti1\u000b^1uSN$\u0018nY:LKf\u0004\"AK'\n\u00059[#A\u0002#pk\ndW-\u0001\u0007ti\u0006$8OV1mk\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003%N\u0003\"!\u0013\u0001\t\u000fy\u001a\u0001\u0013!a\u0001\u0001\u0006I!/Z2p[B,H/\u001a\u000b\u0003%ZCQa\u0016\u0003A\u0002a\u000b!b\u001d;bi&\u001cH/[2t!\tI\u0015,\u0003\u0002[7\tyqI]1qQN#\u0018\r^5ti&\u001c7/\u0001\u0005eSZ,'oZ3t)\ti\u0006\r\u0005\u0002J=&\u0011ql\u0007\u0002\u0010\t&4XM]4f]\u000e,7\u000b^1uK\")\u0011-\u0002a\u0001%\u0006A1O\\1qg\"|G/\u0001\u0003d_BLHC\u0001*e\u0011\u001dqd\u0001%AA\u0002\u0001\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001hU\t\u0001\u0005nK\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005v]\u000eDWmY6fI*\u0011anK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00019l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002{B\u0011!F`\u0005\u0003\u007f.\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0002\u0002\fA\u0019!&a\u0002\n\u0007\u0005%1FA\u0002B]fD\u0001\"!\u0004\u000b\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0001CBA\u000b\u00037\t)!\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005]!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\t\u0002*A\u0019!&!\n\n\u0007\u0005\u001d2FA\u0004C_>dW-\u00198\t\u0013\u00055A\"!AA\u0002\u0005\u0015\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2a]A\u0018\u0011!\ti!DA\u0001\u0002\u0004i\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003u\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002g\u00061Q-];bYN$B!a\t\u0002>!I\u0011Q\u0002\t\u0002\u0002\u0003\u0007\u0011QA\u0001\u0018\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgNs\u0017\r]:i_R\u0004\"!\u0013\n\u0014\u000bI\t)%!\u0015\u0011\r\u0005\u001d\u0013Q\n!S\u001b\t\tIEC\u0002\u0002L-\nqA];oi&lW-\u0003\u0003\u0002P\u0005%#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u00111KA-\u001b\t\t)FC\u0002\u0002X]\f!![8\n\u0007q\n)\u0006\u0006\u0002\u0002B\u0005)\u0011\r\u001d9msR\u0019!+!\u0019\t\u000fy*\u0002\u0013!a\u0001\u0001\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0014q\u000e\t\u0005U\u0005-\u0004)C\u0002\u0002n-\u0012aa\u00149uS>t\u0007\u0002CA9/\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003s\u00022\u0001^A>\u0013\r\ti(\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class GraphStatisticsSnapshot
implements Product,
Serializable {
    private final Map<StatisticsKey, Object> statsValues;

    public static Map<StatisticsKey, Object> $lessinit$greater$default$1() {
        return GraphStatisticsSnapshot$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Map<StatisticsKey, Object>> unapply(GraphStatisticsSnapshot x$0) {
        return GraphStatisticsSnapshot$.MODULE$.unapply(x$0);
    }

    public static Map<StatisticsKey, Object> apply$default$1() {
        return GraphStatisticsSnapshot$.MODULE$.apply$default$1();
    }

    public static GraphStatisticsSnapshot apply(Map<StatisticsKey, Object> statsValues) {
        return GraphStatisticsSnapshot$.MODULE$.apply(statsValues);
    }

    public static <A> Function1<Map<StatisticsKey, Object>, A> andThen(Function1<GraphStatisticsSnapshot, A> g) {
        return GraphStatisticsSnapshot$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, GraphStatisticsSnapshot> compose(Function1<A, Map<StatisticsKey, Object>> g) {
        return GraphStatisticsSnapshot$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Map<StatisticsKey, Object> statsValues() {
        return this.statsValues;
    }

    public GraphStatisticsSnapshot recompute(GraphStatistics statistics) {
        MutableGraphStatisticsSnapshot snapshot = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.$lessinit$greater$default$1());
        InstrumentedGraphStatistics instrumented = new InstrumentedGraphStatistics(statistics, snapshot);
        this.statsValues().keys().foreach((Function1 & Serializable)x0$1 -> {
            Option<Selectivity> option;
            StatisticsKey statisticsKey = x0$1;
            if (statisticsKey instanceof NodesWithLabelCardinality) {
                NodesWithLabelCardinality nodesWithLabelCardinality = (NodesWithLabelCardinality)statisticsKey;
                Option<LabelId> labelId = nodesWithLabelCardinality.labelId();
                option = instrumented.nodesWithLabelCardinality(labelId);
            } else if (NodesAllCardinality$.MODULE$.equals(statisticsKey)) {
                option = instrumented.nodesAllCardinality();
            } else if (statisticsKey instanceof CardinalityByLabelsAndRelationshipType) {
                CardinalityByLabelsAndRelationshipType cardinalityByLabelsAndRelationshipType = (CardinalityByLabelsAndRelationshipType)statisticsKey;
                Option<LabelId> lhs = cardinalityByLabelsAndRelationshipType.lhs();
                Option<RelTypeId> relType = cardinalityByLabelsAndRelationshipType.relType();
                Option<LabelId> rhs = cardinalityByLabelsAndRelationshipType.rhs();
                option = instrumented.patternStepCardinality(lhs, relType, rhs);
            } else if (statisticsKey instanceof IndexSelectivity) {
                IndexSelectivity indexSelectivity = (IndexSelectivity)statisticsKey;
                IndexDescriptor index = indexSelectivity.index();
                option = instrumented.uniqueValueSelectivity(index);
            } else if (statisticsKey instanceof IndexPropertyExistsSelectivity) {
                IndexPropertyExistsSelectivity indexPropertyExistsSelectivity = (IndexPropertyExistsSelectivity)statisticsKey;
                IndexDescriptor index = indexPropertyExistsSelectivity.index();
                option = instrumented.indexPropertyIsNotNullSelectivity(index);
            } else {
                throw new MatchError((Object)statisticsKey);
            }
            return option;
        });
        return snapshot.freeze();
    }

    public DivergenceState diverges(GraphStatisticsSnapshot snapshot) {
        Set set = this.statsValues().keySet();
        Set set2 = snapshot.statsValues().keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
        Tuple4 tuple4 = (Tuple4)((IterableOnceOps)this.statsValues().map((Function1 & Serializable)x0$1 -> {
            double e2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StatisticsKey k = (StatisticsKey)tuple2._1();
            double e1 = tuple2._2$mcD$sp();
            double divergence = Math.abs(e1 - (e2 = BoxesRunTime.unboxToDouble((Object)snapshot.statsValues().apply((Object)k)))) / Math.max(e1, e2);
            Tuple4 tuple4 = Double.isNaN(divergence) ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)k, (Object)BoxesRunTime.boxToDouble((double)e1), (Object)BoxesRunTime.boxToDouble((double)e2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)divergence), (Object)k, (Object)BoxesRunTime.boxToDouble((double)e1), (Object)BoxesRunTime.boxToDouble((double)e2));
            return tuple4;
        })).maxBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)GraphStatisticsSnapshot.$anonfun$diverges$2(x$1)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double divergedStats = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        StatisticsKey divergedStatKey = (StatisticsKey)tuple4._2();
        double before = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double after = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)divergedStats), (Object)divergedStatKey, (Object)BoxesRunTime.boxToDouble((double)before), (Object)BoxesRunTime.boxToDouble((double)after));
        Tuple4 tuple43 = tuple42;
        double divergedStats2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        StatisticsKey divergedStatKey2 = (StatisticsKey)tuple43._2();
        double before2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double after2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return new DivergenceState(divergedStatKey2, divergedStats2, before2, after2);
    }

    public GraphStatisticsSnapshot copy(Map<StatisticsKey, Object> statsValues) {
        return new GraphStatisticsSnapshot(statsValues);
    }

    public Map<StatisticsKey, Object> copy$default$1() {
        return this.statsValues();
    }

    public String productPrefix() {
        return "GraphStatisticsSnapshot";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return switch (n) {
            case 0 -> this.statsValues();
            default -> Statics.ioobe((int)x$1);
        };
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GraphStatisticsSnapshot;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return switch (n) {
            case 0 -> "statsValues";
            default -> (String)Statics.ioobe((int)x$1);
        };
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GraphStatisticsSnapshot)) return false;
        boolean bl = true;
        if (!bl) return false;
        GraphStatisticsSnapshot graphStatisticsSnapshot = (GraphStatisticsSnapshot)x$1;
        Map<StatisticsKey, Object> map = this.statsValues();
        Map<StatisticsKey, Object> map2 = graphStatisticsSnapshot.statsValues();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!graphStatisticsSnapshot.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ double $anonfun$diverges$2(Tuple4 x$1) {
        return BoxesRunTime.unboxToDouble((Object)x$1._1());
    }

    public GraphStatisticsSnapshot(Map<StatisticsKey, Object> statsValues) {
        this.statsValues = statsValues;
        Product.$init$((Product)this);
    }
}

