/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.InequalityRangeSeekable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Parameter$;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor$IndexType$Text$;
import org.neo4j.cypher.internal.util.BucketSize;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.cypher.internal.util.WithSizeHint$;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.internal.helpers.MathUtil;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class ExpressionSelectivityCalculator$
implements Serializable {
    public static final ExpressionSelectivityCalculator$ MODULE$ = new ExpressionSelectivityCalculator$();

    public Selectivity indexSelectivityForSubstringSargable(int stringLength, IndexDescriptor.IndexType indexType) {
        if (stringLength == 0) {
            IndexDescriptor.IndexType indexType2 = indexType;
            if (IndexDescriptor$IndexType$Text$.MODULE$.equals(indexType2)) {
                return Selectivity$.MODULE$.ONE();
            }
            return PlannerDefaults$.MODULE$.DEFAULT_TYPE_SELECTIVITY();
        }
        return Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)stringLength);
    }

    public Selectivity indexSelectivityForSubstringSargable(Expression stringExpression, IndexDescriptor.IndexType indexType) {
        return this.indexSelectivityForSubstringSargable(this.getStringLength(stringExpression), indexType);
    }

    public IndexDescriptor.IndexType indexSelectivityForSubstringSargable$default$2() {
        return IndexDescriptor.IndexType$.Range$.MODULE$;
    }

    public int getStringLength(Expression stringExpression) {
        Parameter parameter;
        Option option;
        Expression expression = stringExpression;
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            String value = stringLiteral.value();
            return value.length();
        }
        if (expression instanceof Parameter && !(option = Parameter$.MODULE$.unapply(parameter = (Parameter)expression)).isEmpty()) {
            Option option2;
            BucketSize bucketSize = (BucketSize)((Tuple3)option.get())._3();
            if (((Tuple3)option.get())._2() instanceof StringType && bucketSize != null && !(option2 = WithSizeHint$.MODULE$.unapply(bucketSize)).isEmpty()) {
                int sizeHint = BoxesRunTime.unboxToInt((Object)option2.get());
                return sizeHint;
            }
        }
        return PlannerDefaults$.MODULE$.DEFAULT_STRING_LENGTH();
    }

    public Selectivity getPropertyPredicateRangeSelectivity(InequalityRangeSeekable seekable, Selectivity propEqValueSelectivity) {
        Selectivity pNeq = propEqValueSelectivity.negate();
        double pNeqRange = pNeq.factor() * PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)Math.min(seekable.expr().inequalities().size(), 2);
        Selectivity pRange = Selectivity$.MODULE$.apply(seekable.hasEquality() ? propEqValueSelectivity.factor() + pNeqRange : pNeqRange);
        return Selectivity$.MODULE$.apply(package$.MODULE$.max(propEqValueSelectivity.factor(), pRange.factor()));
    }

    public Selectivity indexSelectivityWithSizeHint(Option<Object> sizeHint, Function1<Object, Selectivity> selectivityCalculator) {
        int n = BoxesRunTime.unboxToInt((Object)sizeHint.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY().amount()));
        switch (n) {
            case 0: {
                return Selectivity$.MODULE$.ZERO();
            }
        }
        return (Selectivity)selectivityCalculator.apply((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public Selectivity subqueryCardinalityToExistsSelectivity(Cardinality subqueryCardinality) {
        Selectivity selectivity = Selectivity$.MODULE$.apply(this.probLognormalGreaterThan1(subqueryCardinality.amount()));
        if (selectivity.$greater((Object)Selectivity$.MODULE$.ZERO())) {
            return selectivity;
        }
        return Selectivity$.MODULE$.TINY();
    }

    public double probLognormalGreaterThan1(double median) {
        double sigma = 2.0;
        return 1.0 - (1.0 + MathUtil.Erf.erf((double)(-Math.log(median) / (sigma * Math.sqrt(2.0))))) * 0.5;
    }

    public Option<Selectivity> defaultSelectivityForPropertyEquality(int size, SelectivityCombiner combiner) {
        return this.selectivityForPropertyEquality((Option<Selectivity>)new Some((Object)PlannerDefaults$.MODULE$.DEFAULT_PROPERTY_SELECTIVITY()), (Option<Selectivity>)new Some((Object)PlannerDefaults$.MODULE$.DEFAULT_EQUALITY_SELECTIVITY()), size, combiner);
    }

    public Option<Selectivity> selectivityForPropertyEquality(Option<Selectivity> propertySelectivity, Option<Selectivity> uniqueValueSelectivity, int size, SelectivityCombiner combiner) {
        return propertySelectivity.flatMap((Function1 & Serializable)propExists -> uniqueValueSelectivity.flatMap((Function1 & Serializable)propEqualsSingleValue -> combiner.orTogetherSelectivities((Iterable<Selectivity>)((Iterable)scala.package$.MODULE$.Seq().fill(size, (Function0 & Serializable)() -> propEqualsSingleValue))).flatMap((Function1 & Serializable)propEqualsAnyValue -> combiner.andTogetherSelectivities((Iterable<Selectivity>)new .colon.colon(propExists, (List)new .colon.colon(propEqualsAnyValue, (List)Nil$.MODULE$))).map((Function1 & Serializable)combinedSelectivity -> combinedSelectivity))));
    }

    public ExpressionSelectivityCalculator apply(GraphStatistics stats, SelectivityCombiner combiner) {
        return new ExpressionSelectivityCalculator(stats, combiner);
    }

    public Option<Tuple2<GraphStatistics, SelectivityCombiner>> unapply(ExpressionSelectivityCalculator x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.stats(), (Object)x$0.combiner()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExpressionSelectivityCalculator$.class);
    }

    private ExpressionSelectivityCalculator$() {
    }
}

