/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality.histogram;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.histogram.EstimateSelectivityUsingHistogram;
import org.neo4j.cypher.internal.expressions.AutoExtractedParameter;
import org.neo4j.cypher.internal.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.GreaterThan;
import org.neo4j.cypher.internal.expressions.GreaterThanOrEqual;
import org.neo4j.cypher.internal.expressions.InequalityExpression;
import org.neo4j.cypher.internal.expressions.LessThan;
import org.neo4j.cypher.internal.expressions.LessThanOrEqual;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.planner.spi.histogram.Bucket;
import org.neo4j.cypher.internal.planner.spi.histogram.Histogram;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import scala.Function1;
import scala.Predef$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class EstimateSelectivityUsingHistogram$ {
    public static final EstimateSelectivityUsingHistogram$ MODULE$ = new EstimateSelectivityUsingHistogram$();

    public Selectivity sumBucketSelectivityEstimates(Histogram histogram, NonEmptyList<InequalityExpression> inequalities) {
        double selectivitySum = BoxesRunTime.unboxToDouble((Object)histogram.buckets().map((Function1 & Serializable)bucket -> BoxesRunTime.boxToDouble((double)EstimateSelectivityUsingHistogram$.MODULE$.estimateBucketSelectivity(bucket, (NonEmptyList<InequalityExpression>)inequalities))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return Selectivity$.MODULE$.apply(selectivitySum);
    }

    public final double estimateBucketSelectivity(Bucket bucket, NonEmptyList<InequalityExpression> inequalities) {
        double outOfRange = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)inequalities.map((Function1 & Serializable)inequalityPredicate -> BoxesRunTime.boxToDouble((double)EstimateSelectivityUsingHistogram$.$anonfun$estimateBucketSelectivity$1(bucket, inequalityPredicate))).iterator().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))), bucket.selectivity());
        return bucket.selectivity() - outOfRange;
    }

    public final double estimateBucketSelectivity(Bucket bucket, InequalityExpression operator) {
        EstimateSelectivityUsingHistogram.BucketEstimationParameters bucketEstimationParameters;
        Expression expression = operator.rhs();
        if (expression instanceof SignedDecimalIntegerLiteral) {
            SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)expression;
            bucketEstimationParameters = new EstimateSelectivityUsingHistogram.BucketEstimationParameters(Predef$.MODULE$.Long2long(signedDecimalIntegerLiteral.value()), 1.0);
        } else if (expression instanceof DecimalDoubleLiteral) {
            DecimalDoubleLiteral decimalDoubleLiteral = (DecimalDoubleLiteral)expression;
            bucketEstimationParameters = new EstimateSelectivityUsingHistogram.BucketEstimationParameters(Predef$.MODULE$.Double2double(decimalDoubleLiteral.value()), Double.MIN_VALUE);
        } else {
            if (expression instanceof AutoExtractedParameter) {
                throw new UnsupportedOperationException("Cardinality estimation using histograms cannot be done when the value in the inequality expression is auto-parameterized");
            }
            throw new UnsupportedOperationException("Cardinality estimation using histograms does not support the value type of " + operator.rhs() + " in the inequality expression");
        }
        EstimateSelectivityUsingHistogram.BucketEstimationParameters inequalityLiteralAndInclusiveToExclusiveConverterValue = bucketEstimationParameters;
        double v = inequalityLiteralAndInclusiveToExclusiveConverterValue.inequalityLiteral();
        double e = inequalityLiteralAndInclusiveToExclusiveConverterValue.inclToExclConverterValue();
        InequalityExpression inequalityExpression = operator;
        if (inequalityExpression instanceof LessThan) {
            if (v <= bucket.minInclusive()) {
                return 0.0;
            }
            if (v >= bucket.maxExclusive()) {
                return bucket.selectivity();
            }
            return bucket.estimatePropLessThanValue(v);
        }
        if (inequalityExpression instanceof LessThanOrEqual) {
            if (v < bucket.minInclusive()) {
                return 0.0;
            }
            if (v >= bucket.maxExclusive() - e) {
                return bucket.selectivity();
            }
            return bucket.estimatePropLessOrEqualThanValue(v, e);
        }
        if (inequalityExpression instanceof GreaterThan) {
            return bucket.selectivity() - this.estimateBucketSelectivity(bucket, operator.negated());
        }
        if (inequalityExpression instanceof GreaterThanOrEqual) {
            return bucket.selectivity() - this.estimateBucketSelectivity(bucket, operator.negated());
        }
        throw new UnsupportedOperationException("Operator type is not supported during histogram selectivity estimation");
    }

    public static final /* synthetic */ double $anonfun$estimateBucketSelectivity$1(Bucket bucket$1, InequalityExpression inequalityPredicate) {
        return bucket$1.selectivity() - MODULE$.estimateBucketSelectivity(bucket$1, inequalityPredicate);
    }

    private EstimateSelectivityUsingHistogram$() {
    }
}

