/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLoggable$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPLogger;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SolvableItemWithExtraRequirements;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.exceptions.InternalException;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u0011#\u0001MB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011M\u0004!\u0011!Q\u0001\nQD\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tq\u0002\u0011\t\u0011)A\u0005s\"AA\u0010\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\ty\u0002\u0001B\u0002B\u0003-\u0011\u0011\u0005\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqA!\b\u0001\t\u0013\u0011y\u0002C\u0004\u0003,\u0001!IA!\f\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!1\f\u0001\u0005\n\tus!\u0003B5E\u0005\u0005\t\u0012\u0001B6\r!\t#%!A\t\u0002\t5\u0004bBA\u00149\u0011\u0005!q\u000e\u0005\n\u0005cb\u0012\u0013!C\u0001\u0005gB\u0011Ba'\u001d#\u0003%\tA!(\t\u0013\tUF$%A\u0005\u0002\t]&!C%E!N{GN^3s\u0015\t\u0019C%A\u0002jIBT!!\n\u0014\u0002\u000f1|w-[2bY*\u0011q\u0005K\u0001\ba2\fgN\\3s\u0015\tI#&\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYC&\u0001\u0005j]R,'O\\1m\u0015\tic&\u0001\u0004dsBDWM\u001d\u0006\u0003_A\nQA\\3pi)T\u0011!M\u0001\u0004_J<7\u0001A\u000b\u0005i\tcuj\u0005\u0002\u0001kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\f\u0011bZ3oKJ\fGo\u001c:\u0011\u000bur\u0004i\u0013(\u000e\u0003\tJ!a\u0010\u0012\u0003\u001b%#\u0005kU8mm\u0016\u00148\u000b^3q!\t\t%\t\u0004\u0001\u0005\u000b\r\u0003!\u0019\u0001#\u0003\u0011M{GN^1cY\u0016\f\"!\u0012%\u0011\u0005Y2\u0015BA$8\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AN%\n\u0005);$aA!osB\u0011\u0011\t\u0014\u0003\u0006\u001b\u0002\u0011\r\u0001\u0012\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\u0005\u0005{E!\u0002)\u0001\u0005\u0004!%aB\"p]R,\u0007\u0010^\u0001\u0013aJ|'.Z2uS:<7+\u001a7fGR|'\u000fE\u0002T).k\u0011\u0001J\u0005\u0003+\u0012\u0012!\u0003\u0015:pU\u0016\u001cG/\u001b8h'\u0016dWm\u0019;pe\u0006y!/Z4jgR\u0014\u0018PR1di>\u0014\u0018\u0010E\u000271jK!!W\u001c\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004cA\u001f\\\u0001&\u0011AL\t\u0002\u000b\u0013\u0012\u0014VmZ5tiJL\u0018\u0001\u0004;bE2,g)Y2u_JL\b#\u0002\u001c`5\u0006D\u0017B\u000118\u0005%1UO\\2uS>t'\u0007\u0005\u0003cK\u0002[eBA\u001fd\u0013\t!'%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'\u0001B*fK\u0012T!\u0001\u001a\u0012\u0011\u0007uJ7*\u0003\u0002kE\tA\u0011\n\u0012)UC\ndW-\u0001\u0007nCb$\u0016M\u00197f'&TX\r\u0005\u00027[&\u0011an\u000e\u0002\u0004\u0013:$\u0018AF5uKJ\fG/[8o\tV\u0014\u0018\r^5p]2KW.\u001b;\u0011\u0005Y\n\u0018B\u0001:8\u0005\u0011auN\\4\u0002+\u0015DHO]1Pe\u0012,'OU3rk&\u0014X-\\3oiB\u0019Q(^&\n\u0005Y\u0014#\u0001E#yiJ\f'+Z9vSJ,W.\u001a8u\u0003a)\u0007\u0010\u001e:b!J|\u0007/\u001a:usJ+\u0017/^5sK6,g\u000e^\u0001\b[>t\u0017\u000e^8s!\ti$0\u0003\u0002|E\t\u0001\u0012\n\u0012)T_24XM]'p]&$xN]\u0001\u0011gR|\u0007oV1uG\"4\u0015m\u0019;pef\u00042A\u000e-\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001/\u0003\u0011!\u0018.\\3\n\t\u0005\u001d\u0011\u0011\u0001\u0002\n'R|\u0007o^1uG\"\f1cY1oG\u0016dG.\u0019;j_:\u001c\u0005.Z2lKJ\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#Q\u0013\u0001B;uS2LA!!\u0006\u0002\u0010\t\u00192)\u00198dK2d\u0017\r^5p]\u000eCWmY6fe\u0006I\u0011\u000e\u001a9M_\u001e<WM\u001d\t\u0004{\u0005m\u0011bAA\u000fE\tI\u0011\n\u0012)M_\u001e<WM]\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003B\u001f\u0002$\u0001K1!!\n#\u0005-IE\t\u0015'pO\u001e\f'\r\\3\u0002\rqJg.\u001b;?)i\tY#!\r\u00024\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$)\u0011\ti#a\f\u0011\u000bu\u0002\u0001i\u0013(\t\u000f\u0005}a\u0002q\u0001\u0002\"!)1H\u0004a\u0001y!)\u0011K\u0004a\u0001%\"9aK\u0004I\u0001\u0002\u00049\u0006bB/\u000f!\u0003\u0005\rA\u0018\u0005\u0006W:\u0001\r\u0001\u001c\u0005\u0006_:\u0001\r\u0001\u001d\u0005\u0006g:\u0001\r\u0001\u001e\u0005\u0006o:\u0001\r\u0001\u001e\u0005\u0006q:\u0001\r!\u001f\u0005\u0006y:\u0001\r! \u0005\b\u0003\u0013q\u0001\u0019AA\u0006\u0011%\t9B\u0004I\u0001\u0002\u0004\tI\"A\u0003baBd\u0017\u0010\u0006\u0005\u0002N\u0005M\u0013qKA9!\u0011i\u0014qJ&\n\u0007\u0005E#EA\u0006CKN$(+Z:vYR\u001c\bBBA+\u001f\u0001\u0007\u0011-\u0001\u0003tK\u0016$\u0007bBA-\u001f\u0001\u0007\u00111L\u0001\fS:LG/[1m)>$u\u000eE\u0003\u0002^\u0005-\u0004I\u0004\u0003\u0002`\u0005%d\u0002BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015$'\u0001\u0004=e>|GOP\u0005\u0002q%\u0011AmN\u0005\u0005\u0003[\nyGA\u0002TKFT!\u0001Z\u001c\t\r\u0005Mt\u00021\u0001O\u0003\u001d\u0019wN\u001c;fqR\f1A];o)!\ti%!\u001f\u0002|\u0005u\u0004BBA+!\u0001\u0007\u0011\rC\u0004\u0002ZA\u0001\r!a\u0017\t\r\u0005M\u0004\u00031\u0001O\u00031\u0019\u0018N\\4mKJ+7/\u001e7u)\rY\u00151\u0011\u0005\b\u0003\u000b\u000b\u0002\u0019AAD\u0003\u00191Xm\u0019;peB1\u0011QLAE\u0003\u001bKA!a#\u0002p\t1a+Z2u_J\u0004bANAH\u0003'[\u0015bAAIo\t1A+\u001e9mKJ\u0002B!!&\u0002\u001c:\u0019Q(a&\n\u0007\u0005e%%\u0001\u0005J\tB\u001b\u0015m\u00195f\u0013\u0011\ti*a(\u00035M\u000bG/[:gS\u0016$W\t\u001f;sCJ+\u0017/^5sK6,g\u000e^:\u000b\u0007\u0005e%%A\ntS:<G.Z(s\u000b6\u0004H/\u001f*fgVdG\u000f\u0006\u0003\u0002&\u0006-\u0006\u0003\u0002\u001c\u0002(.K1!!+8\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\u0011\nA\u0002\u0005\u001d\u0015\u0001C2mCN\u001c\u0018NZ=\u0016\t\u0005E\u0016Q\u0018\u000b\t\u0003g\u000b\t-a3\u0002\\BIa'!.\u0002:\u0006e\u0016\u0011X\u0005\u0004\u0003o;$A\u0002+va2,7\u0007\u0005\u0004\u0002^\u0005%\u00151\u0018\t\u0004\u0003\u0006uFABA`'\t\u0007AIA\u0001U\u0011\u001d\t\u0019m\u0005a\u0001\u0003\u000b\fq\"\u001a7f[\u0016tG/\u0013;fe\u0006$xN\u001d\t\u0007\u0003;\n9-a/\n\t\u0005%\u0017q\u000e\u0002\t\u0013R,'/\u0019;pe\"9\u0011QZ\nA\u0002\u0005=\u0017A\u00039sK\u0012L7-\u0019;fcA9a'!5\u0002<\u0006U\u0017bAAjo\tIa)\u001e8di&|g.\r\t\u0004m\u0005]\u0017bAAmo\t9!i\\8mK\u0006t\u0007bBAo'\u0001\u0007\u0011qZ\u0001\u000baJ,G-[2bi\u0016\u0014\u0014\u0001\u00037pON#\u0018M\u001d;\u0015\u0011\u0005\r\u0018\u0011^Aw\u0003c\u00042ANAs\u0013\r\t9o\u000e\u0002\u0005+:LG\u000f\u0003\u0004\u0002lR\u0001\rAW\u0001\te\u0016<\u0017n\u001d;ss\"1\u0011q\u001e\u000bA\u0002!\fQ\u0001^1cY\u0016Dq!a=\u0015\u0001\u0004\t)0\u0001\u0003u_\u0012{\u0007cA\u001f\u0002x&\u0019\u0011\u0011 \u0012\u0003\t\u001d{\u0017\r\\\u0001\u000eY><7i\\7qC\u000e$\u0018n\u001c8\u0015\u0011\u0005\r\u0018q B\u0001\u0005\u0007Aa!a;\u0016\u0001\u0004Q\u0006BBAx+\u0001\u0007\u0001\u000eC\u0004\u0003\u0006U\u0001\r!!>\u0002\u0011=\u0014\u0018nZ5oC2\f!\u0004\\8h\u0013R,'/\u0019;j_:4U\u000f\u001c7z\u0007>l\u0007\u000f\\3uK\u0012$B\"a9\u0003\f\t=!\u0011\u0003B\u000b\u00053AaA!\u0004\u0017\u0001\u0004q\u0018!B:uCJ$\bBBAx-\u0001\u0007\u0001\u000e\u0003\u0004\u0003\u0014Y\u0001\r\u0001\\\u0001\u0010i\u0006\u0014G.Z*ju\u0016\u0014UMZ8sK\"1!q\u0003\fA\u00021\f\u0011B\u00197pG.\u001c\u0016N_3\t\r\tma\u00031\u0001m\u00031i\u0017\r\u001f\"m_\u000e\\7+\u001b>f\u0003aawn\u001a+bE2,7+\u001b>f\u0019&l\u0017\u000e\u001e*fC\u000eDW\r\u001a\u000b\r\u0003G\u0014\tCa\t\u0003&\t\u001d\"\u0011\u0006\u0005\u0007\u0005\u001b9\u0002\u0019\u0001@\t\r\u0005=x\u00031\u0001i\u0011\u0019\u0011\u0019b\u0006a\u0001Y\"1!qC\fA\u00021DaAa\u0007\u0018\u0001\u0004a\u0017a\u00057pORKW.\u001a'j[&$(+Z1dQ\u0016$G\u0003DAr\u0005_\u0011\tDa\r\u00036\t]\u0002B\u0002B\u00071\u0001\u0007a\u0010\u0003\u0004\u0002pb\u0001\r\u0001\u001b\u0005\u0007\u0005'A\u0002\u0019\u00017\t\r\t]\u0001\u00041\u0001m\u0011\u0019\u0011Y\u0002\u0007a\u0001Y\u0006yAn\\4MS6LGOU3bG\",G\r\u0006\b\u0002d\nu\"\u0011\u000bB*\u0005+\u00129F!\u0017\t\u000f\t}\u0012\u00041\u0001\u0003B\u0005IA.[7jiRK\b/\u001a\t\u0005\u0005\u0007\u0012YE\u0004\u0003\u0003F\t\u001d\u0003cAA1o%\u0019!\u0011J\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iEa\u0014\u0003\rM#(/\u001b8h\u0015\r\u0011Ie\u000e\u0005\u0007\u0005\u001bI\u0002\u0019\u0001@\t\r\u0005=\u0018\u00041\u0001i\u0011\u0019\u0011\u0019\"\u0007a\u0001Y\"1!qC\rA\u00021DaAa\u0007\u001a\u0001\u0004a\u0017\u0001\u00064pe6\fG/\u0013;fe\u0006$\u0018n\u001c8Ti\u0006$X\r\u0006\u0007\u0003B\t}#\u0011\rB2\u0005K\u00129\u0007\u0003\u0004\u0003\u000ei\u0001\rA \u0005\u0007\u0003_T\u0002\u0019\u00015\t\r\tM!\u00041\u0001m\u0011\u0019\u00119B\u0007a\u0001Y\"1!1\u0004\u000eA\u00021\f\u0011\"\u0013#Q'>dg/\u001a:\u0011\u0005ub2C\u0001\u000f6)\t\u0011Y'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\t\u0005k\u0012\u0019Ia&\u0003\u001aV\u0011!q\u000f\u0016\u0005\u0005s\u0012)\t\u0005\u000371\nm\u0004#B\u001f\u0003~\t\u0005\u0015b\u0001B@E\t\tB)\u001a4bk2$\u0018\n\u001a*fO&\u001cHO]=\u0011\u0007\u0005\u0013\u0019\tB\u0003D=\t\u0007Ai\u000b\u0002\u0003\bB!!\u0011\u0012BJ\u001b\t\u0011YI\u0003\u0003\u0003\u000e\n=\u0015!C;oG\",7m[3e\u0015\r\u0011\tjN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BK\u0005\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015ieD1\u0001E\t\u0015\u0001fD1\u0001E\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iUA!q\u0014BU\u0005_\u0013\u0019,\u0006\u0002\u0003\"*\"!1\u0015BC!!1tL!*\u0003,\nE\u0006\u0003B\u001f\\\u0005O\u00032!\u0011BU\t\u0015\u0019uD1\u0001E!\u0019\u0011WMa*\u0003.B\u0019\u0011Ia,\u0005\u000b5{\"\u0019\u0001#\u0011\tuJ'Q\u0016\u0003\u0006!~\u0011\r\u0001R\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00193+!\u0011IL!0\u0003@\n\u0005WC\u0001B^U\u0011\tIB!\"\u0005\u000b\r\u0003#\u0019\u0001#\u0005\u000b5\u0003#\u0019\u0001#\u0005\u000bA\u0003#\u0019\u0001#")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraOrderRequirement;
    private final ExtraRequirement<Result> extraPropertyRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;
    private final CancellationChecker cancellationChecker;
    private final IDPLogger idpLogger;
    private final IDPLoggable<Solvable> evidence$1;

    public static <Solvable, Result, Context> IDPLogger $lessinit$greater$default$12() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$12();
    }

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        return (BestResults)this.idpLogger.markScope("IDP", (Function0 & Serializable)() -> this.run(seed, initialToDo, context));
    }

    private BestResults<Result> run(Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        IntRef iterations = IntRef.create((int)0);
        this.logStart(registry, table, (Goal)toDo.elem);
        while (((Goal)toDo.elem).size() > 1) {
            ++iterations.elem;
            this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Iteration " + iterations$1.elem);
            this.monitor.startIteration(iterations.elem);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), table, toDo, registry, context);
            if (largestFinished <= 0) {
                throw InternalException.foundNoPlanWithinConstraints((String)GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name(), (String)GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name());
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, table);
            this.monitor.endIteration(iterations.elem, largestFinished, table.size());
            this.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations.elem);
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "Done after " + iterations$1.elem + " iteration(s)");
        Iterator plansWithResult = table.plans().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object result = tuple2._2();
                if (tuple22 != null) {
                    IDPCache.SatisfiedExtraRequirements fulfilsReq = (IDPCache.SatisfiedExtraRequirements)tuple22._2();
                    return new Tuple2((Object)fulfilsReq, result);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple3 tuple3 = this.classify(plansWithResult, (Function1 & Serializable)planWithResult -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$run$22(planWithResult)), (Function1 & Serializable)planWithResult -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$run$23(planWithResult)));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Vector plansFulfillingExtraProperties = (Vector)tuple3._1();
        Vector sortedPlans = (Vector)tuple3._2();
        Vector basePlans = (Vector)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)plansFulfillingExtraProperties, (Object)sortedPlans, (Object)basePlans);
        Vector plansFulfillingExtraProperties2 = (Vector)tuple32._1();
        Vector sortedPlans2 = (Vector)tuple32._2();
        Vector basePlans2 = (Vector)tuple32._3();
        return new BestResults<Result>(this.singleResult(basePlans2), this.singleOrEmptyResult(sortedPlans2), this.singleOrEmptyResult(plansFulfillingExtraProperties2));
    }

    private Result singleResult(Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector) {
        SeqOps seqOps;
        Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector2 = vector;
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Tuple2 t = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return (Result)t._2();
        }
        throw new InternalException("Expected a single plan to be left in the plan table");
    }

    private Option<Result> singleOrEmptyResult(Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector) {
        SeqOps seqOps;
        SeqOps seqOps2;
        Vector<Tuple2<IDPCache.SatisfiedExtraRequirements, Result>> vector2 = vector;
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            return None$.MODULE$;
        }
        if (vector2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Tuple2 t = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return new Some(t._2());
        }
        throw new InternalException("Expected a single plan that fulfils the requirements to be left in the plan table");
    }

    private <T> Tuple3<Vector<T>, Vector<T>, Vector<T>> classify(Iterator<T> elementIterator, Function1<T, Object> predicate1, Function1<T, Object> predicate2) {
        ReusableBuilder predicate1Iterable = package$.MODULE$.Vector().newBuilder();
        ReusableBuilder predicate2Iterable = package$.MODULE$.Vector().newBuilder();
        ReusableBuilder noneMatchIterable = package$.MODULE$.Vector().newBuilder();
        elementIterator.foreach((Function1 & Serializable)element -> {
            boolean isPredicate1Accepted = BoxesRunTime.unboxToBoolean((Object)predicate1.apply(element));
            boolean isPredicate2Accepted = BoxesRunTime.unboxToBoolean((Object)predicate2.apply(element));
            Object object = !isPredicate1Accepted && !isPredicate2Accepted ? noneMatchIterable.addOne(element) : BoxedUnit.UNIT;
            Object object2 = isPredicate1Accepted ? predicate1Iterable.addOne(element) : BoxedUnit.UNIT;
            if (isPredicate2Accepted) {
                return predicate2Iterable.addOne(element);
            }
            return BoxedUnit.UNIT;
        });
        return new Tuple3(predicate1Iterable.result(), predicate2Iterable.result(), noneMatchIterable.result());
    }

    private void logStart(IdRegistry<Solvable> registry, IDPTable<Result> table, Goal toDo) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Vector goalsSummaries = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)toDo.bitSet().toVector().sorted((Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)i -> IDPSolver.$anonfun$logStart$2(registry, BoxesRunTime.unboxToInt((Object)i)))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Object solvable = tuple2._2();
                    return "[" + idx + "] " + IDPLoggable$.MODULE$.summary(solvable, $this.evidence$1);
                }
                throw new MatchError((Object)tuple2);
            });
            return "Initial table size = " + table.size() + "\nGoals [" + goalsSummaries.size() + "]: " + goalsSummaries.mkString("[\n  ", ",\n  ", "\n]");
        });
    }

    private void logCompaction(IdRegistry<Solvable> registry, IDPTable<Result> table, Goal original) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> {
            Set originalGoalsSummaries = (Set)registry.explode(original.bitSet()).map((Function1 & Serializable)x$11 -> IDPLoggable$.MODULE$.summary(x$11, $this.evidence$1));
            BitSet originalGoalsBits = registry.explodedBitSet(original.bitSet());
            return "Compacting goal " + original.bitSet() + " (exploded = " + originalGoalsBits + ") = " + originalGoalsSummaries.mkString("[\n  ", ",\n  ", "\n]") + "\nCompacted table size: " + table.size();
        });
    }

    private void logIterationFullyCompleted(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[\u2713] all done, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private void logTableSizeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("table size", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logTimeLimitReached(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.logLimitReached("time", start, table, tableSizeBefore, blockSize, maxBlockSize);
    }

    private void logLimitReached(String limitType, Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "[!] " + limitType + " limit reached, " + this.formatIterationState(start, table, tableSizeBefore, blockSize, maxBlockSize));
    }

    private String formatIterationState(Stopwatch start, IDPTable<Result> table, int tableSizeBefore, int blockSize, int maxBlockSize) {
        long elapsedTimeMs = start.elapsed(TimeUnit.MILLISECONDS);
        return "time(ms)=" + elapsedTimeMs + "/" + this.iterationDurationLimit + ", table=[" + table.size() + "/" + this.maxTableSize + " (+" + (table.size() - tableSizeBefore) + ")], blockSize=[" + blockSize + "/" + maxBlockSize + "]";
    }

    private final Function1 candidateSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), x$2, (Function0<String>)resolved);
    }

    private final Function1 goalSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$3 -> $this.projectingSelector.apply((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object result = tuple2._2();
                return result;
            }
            throw new MatchError((Object)tuple2);
        }, x$3, (Function0<String>)resolved);
    }

    public static final /* synthetic */ void $anonfun$run$10(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$run$11(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$run$12(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, IDPTable table$1, ObjectRef toDo$1, IdRegistry registry$1, Object context$2) {
        int largestFinishedIteration;
        block9: {
            largestFinishedIteration = 0;
            int blockSize = 1;
            boolean keepGoing = true;
            Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
            int tableSizeBefore = table$1.size();
            while (keepGoing && blockSize <= maxBlockSize) {
                BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
                Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
                while (keepGoing && goals.hasNext()) {
                    boolean bl;
                    this.cancellationChecker.throwIfCancelled();
                    Goal goal = (Goal)goals.next();
                    if (table$1.contains(goal, false, false)) continue;
                    Vector candidates = this.generator.apply(registry$1, goal, table$1, context$2).toVector();
                    Tuple3 tuple3 = this.classify(candidates.iterator(), (Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraPropertyRequirement.fulfils(result)), (Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraOrderRequirement.fulfils(result)));
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Vector extraPropertiesCandidates = (Vector)tuple3._1();
                    Vector extraOrderCandidates = (Vector)tuple3._2();
                    Vector baseCandidates = (Vector)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)extraPropertiesCandidates, (Object)extraOrderCandidates, (Object)baseCandidates);
                    Vector extraPropertiesCandidates2 = (Vector)tuple32._1();
                    Vector extraOrderCandidates2 = (Vector)tuple32._2();
                    Vector baseCandidates2 = (Vector)tuple32._3();
                    Option bestSortedCandidate = (Option)this.candidateSelector$1((Function0 & Serializable)() -> "best sorted plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraOrderCandidates2);
                    Option bestPrefetchedPropertiesCandidate = (Option)this.candidateSelector$1((Function0 & Serializable)() -> "best plan with pre-fetched properties for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraPropertiesCandidates2);
                    ((Option)this.candidateSelector$1((Function0 & Serializable)() -> "best overall plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply(((IterableOps)baseCandidates2.$plus$plus((IterableOnce)bestSortedCandidate)).$plus$plus((IterableOnce)bestPrefetchedPropertiesCandidate))).foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$10(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    bestSortedCandidate.foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$11(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    bestPrefetchedPropertiesCandidate.foreach((Function1 & Serializable)candidate -> {
                        IDPSolver.$anonfun$run$12(foundNoCandidate, table$1, goal, candidate);
                        return BoxedUnit.UNIT;
                    });
                    if (blockSize == 2) {
                        bl = true;
                    } else if (table$1.size() > this.maxTableSize) {
                        this.logTableSizeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else if (start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS)) {
                        this.logTimeLimitReached(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    keepGoing = bl;
                }
                largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
            }
            if (!keepGoing) break block9;
            this.logIterationFullyCompleted(start, table$1, tableSizeBefore, blockSize, maxBlockSize);
        }
        return largestFinishedIteration;
    }

    public static final /* synthetic */ Nothing$ $anonfun$run$14(int blockSize$1, Iterable blockCandidates$1, IDPTable table$1) {
        throw InternalException.foundNoSolutionForBlock((int)blockSize$1, (String)blockCandidates$1.toString(), (String)table$1.toString());
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, IDPTable table$1) {
        Vector blockCandidates = table$1.unsortedPlansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)this.goalSelector$1((Function0 & Serializable)() -> "Best candidate for block size " + blockSize).apply((Object)blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse(() -> IDPSolver.$anonfun$run$14(blockSize, (Iterable)blockCandidates, table$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal = (Goal)tuple2._1();
        Goal goal2 = goal;
        return goal2;
    }

    private final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        this.logCompaction(registry$1, table$1, original);
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Option extraPropertiesResult = results.extraPropertiesResult();
        Tuple3 tuple3 = new Tuple3(result, sortedResult, extraPropertiesResult);
        Option result2 = (Option)tuple3._1();
        Option sortedResult2 = (Option)tuple3._2();
        Option extraPropertiesResult2 = (Option)tuple3._3();
        result2.foreach((Function1 & Serializable)x$6 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, false, x$6);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable)x$7 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), true, false, x$7);
            return BoxedUnit.UNIT;
        });
        extraPropertiesResult2.foreach((Function1 & Serializable)x$8 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, true, x$8);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((IterableOnce)original.bitSet()).$plus((Object)BoxesRunTime.boxToInteger((int)newId)));
        table$1.removeAllTracesOf(original);
        this.idpLogger.log((Function0<String>)(Function0 & Serializable)() -> "New compacted goal id = " + newId);
    }

    public static final /* synthetic */ boolean $anonfun$run$22(Tuple2 planWithResult) {
        return ((IDPCache.SatisfiedExtraRequirements)planWithResult._1()).hasExtraProperties();
    }

    public static final /* synthetic */ boolean $anonfun$run$23(Tuple2 planWithResult) {
        return ((IDPCache.SatisfiedExtraRequirements)planWithResult._1()).sorted();
    }

    public static final /* synthetic */ Option $anonfun$logStart$2(IdRegistry registry$2, int i) {
        return registry$2.lookup(i).map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), x$10));
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<SolvableItemWithExtraRequirements<Solvable>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraOrderRequirement, ExtraRequirement<Result> extraPropertyRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory, CancellationChecker cancellationChecker, IDPLogger idpLogger, IDPLoggable<Solvable> evidence$1) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraOrderRequirement = extraOrderRequirement;
        this.extraPropertyRequirement = extraPropertyRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
        this.cancellationChecker = cancellationChecker;
        this.idpLogger = idpLogger;
        this.evidence$1 = evidence$1;
    }
}

