/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerKit;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPQueryGraphSolver;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPQueryGraphSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.JoinDisconnectedQueryGraphComponents;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SingleComponentPlannerTrait;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.ExistsSubqueryPlanner;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.DatabaseMode$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class IDPQueryGraphSolver$
implements Serializable {
    public static final IDPQueryGraphSolver$ MODULE$ = new IDPQueryGraphSolver$();
    private static final boolean VERBOSE = Boolean.getBoolean("pickBestPlan.VERBOSE");

    public boolean VERBOSE() {
        return VERBOSE;
    }

    public <Solvable> IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> composeSolverSteps(QueryGraph queryGraph, InterestingOrderConfig interestingOrderConfig, QueryPlannerKit kit, LogicalPlanningContext context, Seq<IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext>> generators) {
        Seq combinedSolverSteps = (Seq)generators.map((Function1 & Serializable)solverStep2 -> {
            IDPSolverStep selectingAndSortingSolver = MODULE$.selectingAndSortingSolverStep(queryGraph, interestingOrderConfig, kit, context, (IDPSolverStep)solverStep2);
            return MODULE$.prefetchingPropertiesSolverStep(queryGraph, context, selectingAndSortingSolver);
        });
        return (IDPSolverStep)combinedSolverSteps.foldLeft(IDPSolverStep$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> x$1.$plus$plus(x$2));
    }

    public <Solvable> IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> selectingAndSortingSolverStep(QueryGraph queryGraph, InterestingOrderConfig interestingOrderConfig, QueryPlannerKit kit, LogicalPlanningContext context, IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> solverStep2) {
        IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> selectingSolverStep = solverStep2.map((Function1<LogicalPlan, LogicalPlan>)(Function1 & Serializable)plan -> (LogicalPlan)kit.select().apply(plan, (Object)queryGraph));
        if (interestingOrderConfig.orderToSolve().isEmpty()) {
            return selectingSolverStep;
        }
        IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> sortingSolverStep = selectingSolverStep.flatMap((Function1<LogicalPlan, IterableOnce<LogicalPlan>>)(Function1 & Serializable)plan -> SortPlanner$.MODULE$.maybeSortedPlan((LogicalPlan)plan, interestingOrderConfig, true, context, true).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)IDPQueryGraphSolver$.$anonfun$selectingAndSortingSolverStep$3(plan, x$3))));
        return selectingSolverStep.$plus$plus(sortingSolverStep);
    }

    private <Solvable> IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> prefetchingPropertiesSolverStep(QueryGraph queryGraph, LogicalPlanningContext context, IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> solverStep2) {
        Enumeration.Value value = context.staticComponents().planContext().databaseMode();
        Enumeration.Value value2 = DatabaseMode$.MODULE$.SHARDED();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> prefetchedPropertiesSolverStep = solverStep2.flatMap((Function1<LogicalPlan, IterableOnce<LogicalPlan>>)(Function1 & Serializable)plan -> context.settings().remoteBatchPropertiesStrategy().planPrefetchRemoteBatchPropertiesIfRequired(queryGraph, (Iterable<LogicalPlan>)((Iterable)package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{plan}))), context));
            return solverStep2.$plus$plus(prefetchedPropertiesSolverStep);
        }
        return solverStep2;
    }

    public ExtraRequirement<LogicalPlan> extraRequirementForInterestingOrder(LogicalPlanningContext context, InterestingOrderConfig interestingOrderConfig) {
        if (interestingOrderConfig.orderToSolve().isEmpty()) {
            return ExtraRequirement$.MODULE$.empty();
        }
        return new ExtraRequirement<LogicalPlan>(interestingOrderConfig, context){
            private final InterestingOrderConfig interestingOrderConfig$3;
            private final LogicalPlanningContext context$4;

            public boolean fulfils(LogicalPlan plan) {
                SortPlanner.SatisfiedForPlan asSortedAsPossible = new SortPlanner.SatisfiedForPlan(plan);
                InterestingOrder.Satisfaction satisfaction = SortPlanner$.MODULE$.orderSatisfaction(this.interestingOrderConfig$3, this.context$4, plan);
                return satisfaction != null && asSortedAsPossible.unapply(satisfaction);
            }
            {
                this.interestingOrderConfig$3 = interestingOrderConfig$3;
                this.context$4 = context$4;
            }
        };
    }

    public IDPQueryGraphSolver apply(SingleComponentPlannerTrait singleComponentSolver, JoinDisconnectedQueryGraphComponents componentConnector, ExistsSubqueryPlanner existsSubqueryPlanner, IDPQueryGraphSolverMonitor monitor) {
        return new IDPQueryGraphSolver(singleComponentSolver, componentConnector, existsSubqueryPlanner, monitor);
    }

    public Option<Tuple3<SingleComponentPlannerTrait, JoinDisconnectedQueryGraphComponents, ExistsSubqueryPlanner>> unapply(IDPQueryGraphSolver x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.singleComponentSolver(), (Object)x$0.componentConnector(), (Object)x$0.existsSubqueryPlanner()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IDPQueryGraphSolver$.class);
    }

    public static final /* synthetic */ boolean $anonfun$selectingAndSortingSolverStep$3(LogicalPlan plan$1, LogicalPlan x$3) {
        LogicalPlan logicalPlan = x$3;
        LogicalPlan logicalPlan2 = plan$1;
        return !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null);
    }

    private IDPQueryGraphSolver$() {
    }
}

