/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QgWithLeafInfo;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.LogicalLeafPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeByIdSeek;
import org.neo4j.cypher.internal.logical.plans.NodeLogicalLeafPlan;
import org.neo4j.cypher.internal.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByIdSeek;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class Eagerness$ {
    public static Eagerness$ MODULE$;

    static {
        new Eagerness$();
    }

    public boolean readWriteConflictInHead(LogicalPlan plan, SinglePlannerQuery plannerQuery, LogicalPlanningContext context) {
        boolean bl;
        Seq nodeOrRelLeaves = (Seq)plan.leaves().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof NodeLogicalLeafPlan) {
                    NodeLogicalLeafPlan nodeLogicalLeafPlan;
                    object = nodeLogicalLeafPlan = (NodeLogicalLeafPlan)A1;
                } else if (A1 instanceof DirectedRelationshipByIdSeek) {
                    DirectedRelationshipByIdSeek directedRelationshipByIdSeek = (DirectedRelationshipByIdSeek)A1;
                    object = directedRelationshipByIdSeek;
                } else if (A1 instanceof UndirectedRelationshipByIdSeek) {
                    UndirectedRelationshipByIdSeek undirectedRelationshipByIdSeek = (UndirectedRelationshipByIdSeek)A1;
                    object = undirectedRelationshipByIdSeek;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof NodeLogicalLeafPlan ? true : (logicalPlan instanceof DirectedRelationshipByIdSeek ? true : logicalPlan instanceof UndirectedRelationshipByIdSeek);
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (nodeOrRelLeaves.isEmpty()) {
            bl = false;
        } else {
            Set stablySolvedPredicates = (Set)nodeOrRelLeaves.headOption().map((Function1 & Serializable & scala.Serializable)p -> ((PlannerQueryPart)context.planningAttributes().solveds().apply(p.id())).asSinglePlannerQuery().queryGraph().selections().predicates()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
            Option stableIdentifier = nodeOrRelLeaves.headOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                QgWithLeafInfo.StableIdentifier stableIdentifier;
                LogicalLeafPlan logicalLeafPlan = x0$1;
                if (logicalLeafPlan instanceof NodeByIdSeek) {
                    NodeByIdSeek nodeByIdSeek = (NodeByIdSeek)logicalLeafPlan;
                    String idName = nodeByIdSeek.idName();
                    stableIdentifier = new QgWithLeafInfo.StableIdentifier(idName, true);
                } else if (logicalLeafPlan instanceof DirectedRelationshipByIdSeek) {
                    DirectedRelationshipByIdSeek directedRelationshipByIdSeek = (DirectedRelationshipByIdSeek)logicalLeafPlan;
                    String idName = directedRelationshipByIdSeek.idName();
                    stableIdentifier = new QgWithLeafInfo.StableIdentifier(idName, true);
                } else if (logicalLeafPlan instanceof UndirectedRelationshipByIdSeek) {
                    UndirectedRelationshipByIdSeek undirectedRelationshipByIdSeek = (UndirectedRelationshipByIdSeek)logicalLeafPlan;
                    String idName = undirectedRelationshipByIdSeek.idName();
                    stableIdentifier = new QgWithLeafInfo.StableIdentifier(idName, true);
                } else if (logicalLeafPlan instanceof NodeLogicalLeafPlan) {
                    NodeLogicalLeafPlan nodeLogicalLeafPlan = (NodeLogicalLeafPlan)logicalLeafPlan;
                    stableIdentifier = new QgWithLeafInfo.StableIdentifier(nodeLogicalLeafPlan.idName(), false);
                } else {
                    throw new MatchError((Object)logicalLeafPlan);
                }
                return stableIdentifier;
            });
            Set unstableLeaves = ((TraversableOnce)((TraversableLike)nodeOrRelLeaves.tail()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                String string;
                LogicalLeafPlan logicalLeafPlan = x0$2;
                if (logicalLeafPlan instanceof NodeLogicalLeafPlan) {
                    NodeLogicalLeafPlan nodeLogicalLeafPlan = (NodeLogicalLeafPlan)logicalLeafPlan;
                    string = nodeLogicalLeafPlan.idName();
                } else if (logicalLeafPlan instanceof DirectedRelationshipByIdSeek) {
                    DirectedRelationshipByIdSeek directedRelationshipByIdSeek = (DirectedRelationshipByIdSeek)logicalLeafPlan;
                    string = directedRelationshipByIdSeek.idName();
                } else if (logicalLeafPlan instanceof UndirectedRelationshipByIdSeek) {
                    UndirectedRelationshipByIdSeek undirectedRelationshipByIdSeek = (UndirectedRelationshipByIdSeek)logicalLeafPlan;
                    string = undirectedRelationshipByIdSeek.idName();
                } else {
                    throw new MatchError((Object)logicalLeafPlan);
                }
                return string;
            }, Seq$.MODULE$.canBuildFrom())).toSet();
            QgWithLeafInfo headQgWithLeafInfo = new QgWithLeafInfo(plannerQuery.queryGraph(), stablySolvedPredicates, unstableLeaves, stableIdentifier);
            bl = this.headConflicts(plannerQuery, plannerQuery, headQgWithLeafInfo);
        }
        return bl;
    }

    private boolean headConflicts(SinglePlannerQuery head, SinglePlannerQuery tail, QgWithLeafInfo headQgWithLeafInfo) {
        boolean bl;
        while (true) {
            boolean conflict;
            boolean mergeReadWrite;
            SinglePlannerQuery singlePlannerQuery = head;
            SinglePlannerQuery singlePlannerQuery2 = tail;
            boolean bl2 = !(singlePlannerQuery != null ? !singlePlannerQuery.equals(singlePlannerQuery2) : singlePlannerQuery2 != null) && head.queryGraph().containsMergeRecursive() ? true : (mergeReadWrite = false);
            boolean bl3 = tail.queryGraph().readOnly() || mergeReadWrite ? false : (conflict = tail.queryGraph().nodeOverlap(headQgWithLeafInfo) || tail.queryGraph().removeLabelOverlap(headQgWithLeafInfo) || tail.queryGraph().setLabelOverlap(headQgWithLeafInfo) || tail.queryGraph().createRelationshipOverlap(headQgWithLeafInfo) || tail.queryGraph().setPropertyOverlap(headQgWithLeafInfo) || tail.queryGraph().deleteOverlap(headQgWithLeafInfo) || tail.queryGraph().foreachOverlap(headQgWithLeafInfo));
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    public LogicalPlan headReadWriteEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflictInHead(inputPlan, query, context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeNonRecursive(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflict(query, query) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeRecursive(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || query.tail().isDefined() && this.readWriteConflictInTail(query, (SinglePlannerQuery)query.tail().get()) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan headWriteReadEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInHead(query, (SinglePlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailWriteReadEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInTail(query, (SinglePlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan horizonReadWriteEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        LogicalPlan logicalPlan = inputPlan;
        if (logicalPlan instanceof ProcedureCall) {
            ProcedureCall procedureCall = (ProcedureCall)logicalPlan;
            LogicalPlan left = procedureCall.source();
            ResolvedCall call = procedureCall.call();
            if (call.signature().eager()) {
                return context.logicalPlanProducer().planCallProcedure(context.logicalPlanProducer().planEager(left, context), call, query.interestingOrder(), context);
            }
        }
        if (alwaysEager) return context.logicalPlanProducer().planEager(inputPlan, context);
        if (!query.tail().nonEmpty()) return inputPlan;
        if (!this.horizonReadWriteConflict(query, (SinglePlannerQuery)query.tail().get(), context)) return inputPlan;
        return context.logicalPlanProducer().planEager(inputPlan, context);
    }

    public boolean readWriteConflictInTail(SinglePlannerQuery head, SinglePlannerQuery tail) {
        boolean bl;
        while (true) {
            boolean conflict;
            if (conflict = this.readWriteConflict(head, tail)) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    private QgWithLeafInfo qgWithNoStableIdentifierAndOnlyLeaves(QueryGraph qg) {
        return new QgWithLeafInfo(qg, Predef$.MODULE$.Set().empty(), qg.allCoveredIds(), (Option)None$.MODULE$);
    }

    public boolean readWriteConflict(SinglePlannerQuery readQuery, SinglePlannerQuery writeQuery) {
        SinglePlannerQuery singlePlannerQuery = readQuery;
        SinglePlannerQuery singlePlannerQuery2 = writeQuery;
        boolean mergeReadWrite = !(singlePlannerQuery != null ? !singlePlannerQuery.equals(singlePlannerQuery2) : singlePlannerQuery2 != null) && readQuery.queryGraph().containsMergeRecursive();
        boolean conflict = writeQuery.queryGraph().readOnly() || mergeReadWrite ? false : writeQuery.queryGraph().overlaps(this.qgWithNoStableIdentifierAndOnlyLeaves(readQuery.queryGraph()));
        return conflict;
    }

    public boolean writeReadConflictInTail(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        boolean bl;
        while (true) {
            boolean conflict;
            QgWithLeafInfo tailQgWithLeafInfo = this.qgWithNoStableIdentifierAndOnlyLeaves(tail.queryGraph());
            boolean bl2 = tail.queryGraph().writeOnly() ? false : (conflict = head.queryGraph().overlaps(tailQgWithLeafInfo) || head.queryGraph().overlapsHorizon(tail.horizon(), context.semanticTable()) || this.deleteReadOverlap(head.queryGraph(), tail.queryGraph(), context));
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    public boolean horizonReadWriteConflict(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        boolean bl;
        while (true) {
            boolean conflict;
            if (conflict = tail.queryGraph().overlapsHorizon(head.horizon(), context.semanticTable())) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    private boolean deleteReadOverlap(QueryGraph from, QueryGraph to, LogicalPlanningContext context) {
        Set deleted = from.identifiersToDelete();
        return this.deletedRelationshipsOverlap((Set<String>)deleted, to, context) || this.deletedNodesOverlap((Set<String>)deleted, to, context);
    }

    private boolean deletedRelationshipsOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set relsToRead = to.allPatternRelationshipsRead();
        Set relsDeleted = (Set)deleted.filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$deletedRelationshipsOverlap$1(context, id)));
        return relsToRead.nonEmpty() && relsDeleted.nonEmpty();
    }

    private boolean deletedNodesOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set nodesToRead = to.allPatternNodesRead();
        Set nodesDeleted = (Set)deleted.filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$deletedNodesOverlap$1(context, id)));
        return nodesToRead.nonEmpty() && nodesDeleted.nonEmpty();
    }

    public boolean writeReadConflictInHead(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        return head.queryGraph().writeOnly() ? this.writeReadConflictInHeadRecursive(head, tail) : this.writeReadConflictInTail(head, tail, context);
    }

    public boolean writeReadConflictInHeadRecursive(SinglePlannerQuery head, SinglePlannerQuery tail) {
        boolean bl;
        while (true) {
            boolean conflict;
            boolean bl2 = conflict = tail.queryGraph().writeOnly() ? false : head.queryGraph().writeOnlyHeadOverlaps(this.qgWithNoStableIdentifierAndOnlyLeaves(tail.queryGraph()));
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    private boolean hasUnsafeRelationships(QueryGraph queryGraph) {
        return this.hasRelationships(queryGraph);
    }

    private boolean hasRelationships(QueryGraph queryGraph) {
        return queryGraph.allPatternRelationships().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$deletedRelationshipsOverlap$1(LogicalPlanningContext context$2, String id) {
        return context$2.semanticTable().isRelationship(id);
    }

    public static final /* synthetic */ boolean $anonfun$deletedNodesOverlap$1(LogicalPlanningContext context$3, String id) {
        return context$3.semanticTable().isNode(id);
    }

    private Eagerness$() {
        MODULE$ = this;
    }
}

