/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001M\u0011\u0011\"\u0013#Q'>dg/\u001a:\u000b\u0005\r!\u0011aA5ea*\u0011QAB\u0001\bY><\u0017nY1m\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011\u0001C2p[BLG.\u001a:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001!F\u0003\u0015G5\u00024g\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001aD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\nO\u0016tWM]1u_J\u0004bAH\u0010\"Y=\u0012T\"\u0001\u0002\n\u0005\u0001\u0012!!D%E!N{GN^3s'R,\u0007\u000f\u0005\u0002#G1\u0001A!\u0002\u0013\u0001\u0005\u0004)#\u0001C*pYZ\f'\r\\3\u0012\u0005\u0019J\u0003C\u0001\f(\u0013\tAsCA\u0004O_RD\u0017N\\4\u0011\u0005YQ\u0013BA\u0016\u0018\u0005\r\te.\u001f\t\u0003E5\"QA\f\u0001C\u0002\u0015\u00121BU3rk&\u0014X-\\3oiB\u0011!\u0005\r\u0003\u0006c\u0001\u0011\r!\n\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\u0005\t\u001aD!\u0002\u001b\u0001\u0005\u0004)#aB\"p]R,\u0007\u0010\u001e\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005\u0011\u0002O]8kK\u000e$\u0018N\\4TK2,7\r^8s!\rA\u0014hL\u0007\u0002\t%\u0011!\b\u0002\u0002\u0013!J|'.Z2uS:<7+\u001a7fGR|'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003=\u0011XmZ5tiJLh)Y2u_JL\bc\u0001\f?\u0001&\u0011qh\u0006\u0002\n\rVt7\r^5p]B\u00022AH!\"\u0013\t\u0011%A\u0001\u0006JIJ+w-[:uefD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\ri\u0006\u0014G.\u001a$bGR|'/\u001f\t\u0006-\u0019\u0003\u0005jT\u0005\u0003\u000f^\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u000b%c\u0015\u0005L\u0018\u000f\u0005yQ\u0015BA&\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u0003\tM+W\r\u001a\u0006\u0003\u0017\n\u0001BA\b)0Y%\u0011\u0011K\u0001\u0002\t\u0013\u0012\u0003F+\u00192mK\"A1\u000b\u0001B\u0001B\u0003%A+\u0001\u0007nCb$\u0016M\u00197f'&TX\r\u0005\u0002\u0017+&\u0011ak\u0006\u0002\u0004\u0013:$\b\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002-%$XM]1uS>tG)\u001e:bi&|g\u000eT5nSR\u0004\"A\u0006.\n\u0005m;\"\u0001\u0002'p]\u001eD\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IAX\u0001\u0011Kb$(/\u0019*fcVL'/Z7f]R\u0004BAH0-_%\u0011\u0001M\u0001\u0002\u0011\u000bb$(/\u0019*fcVL'/Z7f]RD\u0001B\u0019\u0001\u0003\u0002\u0003\u0006IaY\u0001\b[>t\u0017\u000e^8s!\tqB-\u0003\u0002f\u0005\t\u0001\u0012\n\u0012)T_24XM]'p]&$xN\u001d\u0005\u0006O\u0002!\t\u0001[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013%T7\u000e\\7o_B\f\bC\u0002\u0010\u0001C1z#\u0007C\u0003\u001dM\u0002\u0007Q\u0004C\u00037M\u0002\u0007q\u0007C\u0004=MB\u0005\t\u0019A\u001f\t\u000f\u00113\u0007\u0013!a\u0001\u000b\")1K\u001aa\u0001)\")\u0001L\u001aa\u00013\")QL\u001aa\u0001=\")!M\u001aa\u0001G\")1\u000f\u0001C\u0001i\u0006)\u0011\r\u001d9msR9Q/!\u0007\u0002\u001e\u0005\u0005\u0002\u0003\u0002<~\u0003\u0003q!a\u001e?\u000f\u0005a\\X\"A=\u000b\u0005i\u0014\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tYu#\u0003\u0002\u007f\u007f\nA\u0011\n^3sCR|'O\u0003\u0002L/A1a#a\u0001\u0002\b=J1!!\u0002\u0018\u0005\u0019!V\u000f\u001d7feA1a#a\u0001\u0002\n1\u0002R!a\u0003\u0002\u0014\u0005rA!!\u0004\u0002\u0010A\u0011\u0001pF\u0005\u0004\u0003#9\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!aA*fi*\u0019\u0011\u0011C\f\t\r\u0005m!\u000f1\u0001I\u0003\u0011\u0019X-\u001a3\t\u000f\u0005}!\u000f1\u0001\u0002\n\u0005Y\u0011N\\5uS\u0006dGk\u001c#p\u0011\u0019\t\u0019C\u001da\u0001e\u000591m\u001c8uKb$x!CA\u0014\u0005\u0005\u0005\t\u0012AA\u0015\u0003%IE\tU*pYZ,'\u000fE\u0002\u001f\u0003W1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QF\n\u0004\u0003W)\u0002bB4\u0002,\u0011\u0005\u0011\u0011\u0007\u000b\u0003\u0003SA!\"!\u000e\u0002,E\u0005I\u0011AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gUQ\u0011\u0011HA$\u00037\ni&a\u0018\u0016\u0005\u0005m\"\u0006BA\u001f\u0003\u0013\u0002BA\u0006 \u0002@A)a$!\u0011\u0002F%\u0019\u00111\t\u0002\u0003#\u0011+g-Y;mi&#'+Z4jgR\u0014\u0018\u0010E\u0002#\u0003\u000f\"a\u0001JA\u001a\u0005\u0004)3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Us#\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\r9\n\u0019D1\u0001&\t\u0019\t\u00141\u0007b\u0001K\u00111A'a\rC\u0002\u0015B!\"a\u0019\u0002,E\u0005I\u0011AA3\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iUQ\u0011qMA9\u0003o\nY(a \u0016\u0005\u0005%$\u0006BA6\u0003\u0013\u0002\u0002B\u0006$\u0002n\u0005M\u0014Q\u0010\t\u0005=\u0005\u000by\u0007E\u0002#\u0003c\"a\u0001JA1\u0005\u0004)\u0003\u0003C%M\u0003_\n)(!\u001f\u0011\u0007\t\n9\b\u0002\u0004/\u0003C\u0012\r!\n\t\u0004E\u0005mDAB\u0019\u0002b\t\u0007Q\u0005\u0005\u0004\u001f!\u0006e\u0014Q\u000f\u0003\u0007i\u0005\u0005$\u0019A\u0013")
public class IDPSolver<Solvable, Requirement, Result, Context> {
    private final IDPSolverStep<Solvable, Requirement, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    public final ExtraRequirement<Requirement, Result> org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement;
    private final IDPSolverMonitor monitor;

    public static <Solvable, Requirement, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Requirement, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public Iterator<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>> seed, Set<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        ObjectRef toDo = ObjectRef.create((Object)registry.registerAll(initialToDo));
        Function1 & Serializable & scala.Serializable goalSelector = (Function1 & Serializable & scala.Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable & scala.Serializable)x$1 -> x$1._2(), x$2);
        int iterations = 0;
        while (((BitSet)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestFinished = this.generateBestCandidates$1(((BitSet)toDo.elem).size(), context, registry, table, toDo);
            if (largestFinished <= 0) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("Unfortunately, the planner was unable to find a plan within the constraints provided.\n           |Try increasing the config values `").append(GraphDatabaseSettings.cypher_idp_solver_table_threshold.name()).append("`\n           |and `").append(GraphDatabaseSettings.cypher_idp_solver_duration_threshold.name()).append("` to allow\n           |for a larger sub-plan table and longer planning time.").toString())).stripMargin());
            }
            BitSet bestGoal = IDPSolver.findBestCandidateInBlock$1(largestFinished, table, goalSelector);
            this.monitor.endIteration(iterations, largestFinished, table.size());
            IDPSolver.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations);
        Iterator maybeSorted = table.plans().collect((PartialFunction)new scala.Serializable(this, registry){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDPSolver $outer;
            private final IdRegistry registry$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Tuple2<BitSet, Requirement>, Result>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Tuple2 tuple2 = (Tuple2)A1._1();
                    Object result = A1._2();
                    if (tuple2 != null) {
                        BitSet key = (BitSet)tuple2._1();
                        Object attribute = tuple2._2();
                        if (this.$outer.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.is(attribute)) {
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2(this.registry$1.explode(key), attribute)), result);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Tuple2<BitSet, Requirement>, Result> x1) {
                Object attribute;
                Tuple2 tuple2;
                Tuple2<Tuple2<BitSet, Requirement>, Result> tuple22 = x1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null && this.$outer.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.is(attribute = tuple2._2());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.registry$1 = registry$1;
            }
        });
        return maybeSorted.hasNext() ? maybeSorted : table.plans().collect((PartialFunction)new scala.Serializable(null, registry){
            public static final long serialVersionUID = 0L;
            private final IdRegistry registry$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Tuple2<BitSet, Requirement>, Result>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    Tuple2 tuple2 = (Tuple2)A1._1();
                    Object result = A1._2();
                    if (tuple2 != null) {
                        BitSet key = (BitSet)tuple2._1();
                        Object attribute = tuple2._2();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2(this.registry$1.explode(key), attribute)), result);
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Tuple2<BitSet, Requirement>, Result> x2) {
                Tuple2 tuple2;
                Tuple2<Tuple2<BitSet, Requirement>, Result> tuple22 = x2;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
            {
                this.registry$1 = registry$1;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(IDPSolver $this, Object candidate) {
        return BoxesRunTime.equals($this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.forResult(candidate), $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.none());
    }

    public static final /* synthetic */ void $anonfun$apply$5(IDPSolver $this, IDPTable table$1, BooleanRef foundNoCandidate$1, BitSet goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.none(), candidate);
    }

    public static final /* synthetic */ void $anonfun$apply$6(IDPSolver $this, IDPTable table$1, BooleanRef foundNoCandidate$1, BitSet goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.forResult(candidate), candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, Object context$1, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        Stopwatch start = Stopwatch.start();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator goals = ((BitSet)toDo$1.elem).subsets(++blockSize);
            while (keepGoing && goals.hasNext()) {
                BitSet goal = (BitSet)goals.next();
                if (!table$1.apply(goal).isEmpty()) continue;
                LazyIterable candidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.generator.apply(registry$1, goal, table$1, context$1));
                Tuple2 tuple2 = candidates.partition((Function1 & Serializable & scala.Serializable)candidate -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$apply$4(this, candidate)));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Iterable baseCandidates = (Iterable)tuple2._1();
                Iterable extraCandidates = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)baseCandidates, (Object)extraCandidates);
                Tuple2 tuple23 = tuple22;
                Iterable baseCandidates2 = (Iterable)tuple23._1();
                Iterable extraCandidates2 = (Iterable)tuple23._2();
                this.projectingSelector.apply(baseCandidates2).foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$5(this, table$1, foundNoCandidate, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                this.projectingSelector.apply(extraCandidates2).foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$6(this, table$1, foundNoCandidate, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && !start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS);
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    private static final BitSet findBestCandidateInBlock$1(int blockSize, IDPTable table$1, Function1 goalSelector$1) {
        BitSet goal;
        Tuple2 tuple2;
        IndexedSeq blockCandidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> table$1.plansOfSize(blockSize)).toIndexedSeq();
        Option bestInBlock = (Option)goalSelector$1.apply(blockCandidates);
        Tuple2 tuple22 = (Tuple2)bestInBlock.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(100).append("Found no solution for block with size ").append(blockSize).append(",\n              |").append(blockCandidates).append(" were the selected candidates from the table ").append(table$1).toString())).stripMargin());
        });
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
            throw new MatchError((Object)tuple22);
        }
        BitSet bitSet = goal = (BitSet)tuple2._1();
        BitSet goal2 = bitSet;
        return goal2;
    }

    public static final /* synthetic */ void $anonfun$apply$9(IDPTable table$1, int newId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object attribute = tuple2._1();
        Object result = tuple2._2();
        table$1.put(BitSet$.MODULE$.empty().$plus(newId$1), attribute, result);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void compactBlock$1(BitSet original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original);
        table$1.apply(original).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IDPSolver.$anonfun$apply$9(table$1, newId, x0$1);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = ((BitSet)((BitSet)toDo$1.elem).$minus$minus((GenTraversableOnce)original)).$plus(newId);
        table$1.removeAllTracesOf(original);
    }

    public IDPSolver(IDPSolverStep<Solvable, Requirement, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Requirement, Result> extraRequirement, IDPSolverMonitor monitor) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement = extraRequirement;
        this.monitor = monitor;
    }
}

