/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.neo4j.exceptions.IncomparableValuesException;
import org.neo4j.exceptions.UnorderableValueException;
import org.neo4j.graphdb.Path;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValues;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class CypherOrderability {
    private static final Comparator<Object> FALLBACK_COMPARATOR = (lhs, rhs) -> {
        if (lhs.getClass().isAssignableFrom(rhs.getClass()) && lhs instanceof Comparable && rhs instanceof Comparable) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        throw new IncomparableValuesException(lhs.getClass().getSimpleName(), rhs.getClass().getSimpleName());
    };
    private static final Comparator<Object> VOID_COMPARATOR = (lhs, rhs) -> 0;
    private static final Comparator<Number> NUMBER_COMPARATOR = (lhs, rhs) -> {
        if (lhs instanceof Double && rhs instanceof Float) {
            return ((Double)lhs).compareTo(rhs.doubleValue());
        }
        if (lhs instanceof Float && rhs instanceof Double) {
            return -((Double)rhs).compareTo(lhs.doubleValue());
        }
        if (lhs instanceof Float && rhs instanceof Float) {
            return ((Float)lhs).compareTo((Float)rhs);
        }
        if (lhs instanceof Double && rhs instanceof Double) {
            return ((Double)lhs).compareTo((Double)rhs);
        }
        if (lhs instanceof Double || lhs instanceof Float) {
            return MathUtil.compareDoubleAgainstLong((double)lhs.doubleValue(), (long)rhs.longValue());
        }
        if (rhs instanceof Double || rhs instanceof Float) {
            return -MathUtil.compareDoubleAgainstLong((double)rhs.doubleValue(), (long)lhs.longValue());
        }
        return Long.compare(lhs.longValue(), rhs.longValue());
    };
    private static final Comparator<Object> STRING_COMPARATOR = (lhs, rhs) -> {
        if (lhs instanceof Character && rhs instanceof String) {
            return lhs.toString().compareTo((String)rhs);
        }
        if (lhs instanceof String && rhs instanceof Character) {
            return ((String)lhs).compareTo(rhs.toString());
        }
        return ((Comparable)lhs).compareTo(rhs);
    };
    private static final Comparator<Boolean> BOOLEAN_COMPARATOR = Boolean::compareTo;
    private static final Comparator<VirtualNodeValue> NODE_COMPARATOR = Comparator.comparingLong(VirtualNodeValue::id);
    private static final Comparator<VirtualRelationshipValue> RELATIONSHIP_COMPARATOR = Comparator.comparingLong(VirtualRelationshipValue::id);
    private static final Comparator<Path> PATH_COMPARATOR = (lhs, rhs) -> {
        Iterator lhsIter = lhs.iterator();
        Iterator rhsIter = rhs.iterator();
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            int result = CypherOrderability.compare(lhsIter.next(), rhsIter.next());
            if (0 == result) continue;
            return result;
        }
        return lhsIter.hasNext() ? 1 : (rhsIter.hasNext() ? -1 : 0);
    };
    private static final Comparator<Object> LIST_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            Iterator lhsIter = this.toIterator(lhs);
            Iterator rhsIter = this.toIterator(rhs);
            while (lhsIter.hasNext() && rhsIter.hasNext()) {
                int result = CypherOrderability.compare(lhsIter.next(), rhsIter.next());
                if (0 == result) continue;
                return result;
            }
            return lhsIter.hasNext() ? 1 : (rhsIter.hasNext() ? -1 : 0);
        }

        private Iterator toIterator(Object o) {
            Class<?> clazz = o.getClass();
            if (Iterable.class.isAssignableFrom(clazz)) {
                return ((Iterable)o).iterator();
            }
            if (Object[].class.isAssignableFrom(clazz)) {
                return Arrays.stream((Object[])o).iterator();
            }
            if (clazz.equals(int[].class)) {
                return IntStream.of((int[])o).iterator();
            }
            if (clazz.equals(long[].class)) {
                return LongStream.of((long[])o).iterator();
            }
            if (clazz.equals(float[].class)) {
                return IntStream.range(0, ((float[])o).length).mapToObj(i -> Float.valueOf(((float[])o)[i])).iterator();
            }
            if (clazz.equals(double[].class)) {
                return DoubleStream.of((double[])o).iterator();
            }
            if (clazz.equals(String[].class)) {
                return Arrays.stream((String[])o).iterator();
            }
            if (clazz.equals(boolean[].class)) {
                return IntStream.range(0, ((boolean[])o).length).mapToObj(i -> ((boolean[])o)[i]).iterator();
            }
            if (clazz.equals(Boolean[].class)) {
                return Arrays.stream((Boolean[])o).iterator();
            }
            throw new UnsupportedOperationException(String.format("Can not convert to iterator: %s", clazz.getName()));
        }
    };

    private CypherOrderability() {
        throw new UnsupportedOperationException();
    }

    public static int compare(Object lhs, Object rhs) {
        SuperType rightType;
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == Values.NO_VALUE || lhs == null) {
            return 1;
        }
        if (rhs == Values.NO_VALUE || rhs == null) {
            return -1;
        }
        if (lhs instanceof AnyValue) {
            AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
            return AnyValues.COMPARATOR.compare((AnyValue)lhs, rhsValue);
        }
        if (rhs instanceof AnyValue) {
            AnyValue lhsValue = ValueUtils.of((Object)lhs);
            return AnyValues.COMPARATOR.compare(lhsValue, (AnyValue)rhs);
        }
        SuperType leftType = SuperType.ofValue(lhs);
        int typeComparison = SuperType.TYPE_ID_COMPARATOR.compare(leftType, rightType = SuperType.ofValue(rhs));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return leftType.comparator.compare(lhs, rhs);
    }

    public static enum SuperType {
        MAP(0, FALLBACK_COMPARATOR),
        NODE(1, NODE_COMPARATOR),
        RELATIONSHIP(2, RELATIONSHIP_COMPARATOR),
        LIST(3, LIST_COMPARATOR),
        PATH(4, PATH_COMPARATOR),
        STRING(5, STRING_COMPARATOR),
        BOOLEAN(6, BOOLEAN_COMPARATOR),
        NUMBER(7, NUMBER_COMPARATOR),
        VOID(8, VOID_COMPARATOR);

        public final int typeId;
        public final Comparator comparator;
        public static final Comparator<SuperType> TYPE_ID_COMPARATOR;

        private SuperType(int typeId, Comparator comparator) {
            this.typeId = typeId;
            this.comparator = comparator;
        }

        public static SuperType ofValue(Object value) {
            if (value instanceof String || value instanceof Character) {
                return STRING;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Map) {
                return MAP;
            }
            if (value instanceof List || value.getClass().isArray()) {
                return LIST;
            }
            if (value instanceof VirtualNodeValue) {
                if (((VirtualNodeValue)value).id() == -1L) {
                    return VOID;
                }
                return NODE;
            }
            if (value instanceof VirtualRelationshipValue) {
                if (((VirtualRelationshipValue)value).id() == -1L) {
                    return VOID;
                }
                return RELATIONSHIP;
            }
            if (value instanceof Path) {
                return PATH;
            }
            throw new UnorderableValueException(value.getClass().getSimpleName(), null);
        }

        static {
            TYPE_ID_COMPARATOR = Comparator.comparingInt(left -> left.typeId);
        }
    }
}

