/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.helpers.MapSupport$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics$QueryGraphSolverInput$;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.StatisticsBackedCardinalityModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.StrictnessMode;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.values.storable.NumberValue;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\t\u0012\u0001\u0001B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\"9Q\n\u0001b\u0001\n\u0013q\u0005BB+\u0001A\u0003%q\nC\u0004W\u0001\t\u0007I\u0011B,\t\rm\u0003\u0001\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!a\b\u0001\t\u0013\t\tcB\u0004\u00024EA\t!!\u000e\u0007\rA\t\u0002\u0012AA\u001c\u0011\u0019AU\u0002\"\u0001\u0002:!9\u00111H\u0007\u0005\u0002\u0005u\"\u0001I*uCRL7\u000f^5dg\n\u000b7m[3e\u0007\u0006\u0014H-\u001b8bY&$\u00180T8eK2T!AE\n\u0002\u000f1|w-[2bY*\u0011A#F\u0001\ba2\fgN\\3s\u0015\t1r#\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tA\u0012$\u0001\u0005j]R,'O\\1m\u0015\tQ2$\u0001\u0004dsBDWM\u001d\u0006\u00039u\tQA\\3pi)T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)y9\u0011\u0011F\u000f\b\u0003Uer!a\u000b\u001d\u000f\u00051:dBA\u00177\u001d\tqSG\u0004\u00020i9\u0011\u0001gM\u0007\u0002c)\u0011!gH\u0001\u0007yI|w\u000e\u001e \n\u0003yI!\u0001H\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003wE\tq!T3ue&\u001c7/\u0003\u0002>}\t\u00012)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0006\u0003wE\t!$];fef<%/\u00199i\u0007\u0006\u0014H-\u001b8bY&$\u00180T8eK2\u0004\"\u0001K!\n\u0005\ts$AG)vKJLxI]1qQ\u000e\u000b'\u000fZ5oC2LG/_'pI\u0016d\u0017!G:j[BdW-\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J\u0004\"!\u0012$\u000e\u0003EI!aR\t\u0003'\u0015C\bO]3tg&|g.\u0012<bYV\fGo\u001c:\u0002\rqJg.\u001b;?)\rQ5\n\u0014\t\u0003\u000b\u0002AQaP\u0002A\u0002\u0001CQaQ\u0002A\u0002\u0011\u000bq$\u001a=qe\u0016\u001c8/[8o'\u0016dWm\u0019;jm&$\u0018pQ1mGVd\u0017\r^8s+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u0012\u0003-\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=\n\u0005Q\u000b&aH#yaJ,7o]5p]N+G.Z2uSZLG/_\"bY\u000e,H.\u0019;pe\u0006\u0001S\r\u001f9sKN\u001c\u0018n\u001c8TK2,7\r^5wSRL8)\u00197dk2\fGo\u001c:!\u0003!\u0019w.\u001c2j]\u0016\u0014X#\u0001-\u0011\u0005AK\u0016B\u0001.R\u0005M\u0019V\r\\3di&4\u0018\u000e^=D_6\u0014\u0017N\\3s\u0003%\u0019w.\u001c2j]\u0016\u0014\b%A\u0003baBd\u0017\u0010\u0006\u0003_I2\f\bCA0c\u001b\u0005\u0001'BA1\u0018\u0003\u0011)H/\u001b7\n\u0005\r\u0004'aC\"be\u0012Lg.\u00197jifDQ!\u001a\u0005A\u0002\u0019\f\u0011\"];fef\u0004\u0016M\u001d;\u0011\u0005\u001dTW\"\u00015\u000b\u0005%<\u0012AA5s\u0013\tY\u0007N\u0001\tQY\u0006tg.\u001a:Rk\u0016\u0014\u0018\u0010U1si\")Q\u000e\u0003a\u0001]\u00061\u0011N\u001c9viB\u0002\"\u0001K8\n\u0005At$!F)vKJLxI]1qQN{GN^3s\u0013:\u0004X\u000f\u001e\u0005\u0006e\"\u0001\ra]\u0001\u000eg\u0016l\u0017M\u001c;jGR\u000b'\r\\3\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018!C:f[\u0006tG/[2t\u0015\tAx#A\u0002bgRL!A_;\u0003\u001bM+W.\u00198uS\u000e$\u0016M\u00197f\u0003\r\u001a\u0017\r\\2vY\u0006$XmQ1sI&t\u0017\r\\5us\u001a{'/U;fefDuN]5{_:$RAX?\u0000\u0003\u0013AQA`\u0005A\u0002y\u000b!!\u001b8\t\u000f\u0005\u0005\u0011\u00021\u0001\u0002\u0004\u00059\u0001n\u001c:ju>t\u0007cA4\u0002\u0006%\u0019\u0011q\u00015\u0003\u0019E+XM]=I_JL'p\u001c8\t\u000bIL\u0001\u0019A:\u0002A!|'/\u001b>p]\u000e\u000b'\u000fZ5oC2LG/_,ji\"\u001cV\r\\3di&|gn\u001d\u000b\b=\u0006=\u00111CA\u000f\u0011\u0019\t\tB\u0003a\u0001=\u0006Q2-\u0019:eS:\fG.\u001b;z\u0005\u00164wN]3TK2,7\r^5p]\"9\u0011Q\u0003\u0006A\u0002\u0005]\u0011!B<iKJ,\u0007cA4\u0002\u001a%\u0019\u00111\u00045\u0003\u0015M+G.Z2uS>t7\u000fC\u0003s\u0015\u0001\u00071/A\u0011dC2\u001cW\u000f\\1uK\u000e\u000b'\u000fZ5oC2LG/\u001f$peF+XM]=He\u0006\u0004\b\u000eF\u0004o\u0003G\ti#!\r\t\u000f\u0005\u00152\u00021\u0001\u0002(\u0005)qM]1qQB\u0019q-!\u000b\n\u0007\u0005-\u0002N\u0001\u0006Rk\u0016\u0014\u0018p\u0012:ba\"Da!a\f\f\u0001\u0004q\u0017!B5oaV$\b\"\u0002:\f\u0001\u0004\u0019\u0018\u0001I*uCRL7\u000f^5dg\n\u000b7m[3e\u0007\u0006\u0014H-\u001b8bY&$\u00180T8eK2\u0004\"!R\u0007\u0014\u00055\tCCAA\u001b\u0003\r\nwm\u001a:fO\u0006$XmQ1sI&t\u0017\r\\5us\n+gm\u001c:f'\u0016dWm\u0019;j_:$RAXA \u0003\u0003BQA`\bA\u0002yCq!a\u0011\u0010\u0001\u0004\t)%A\nhe>,\b/\u001b8h\u000bb\u0004(/Z:tS>t7\u000f\u0005\u0005\u0002H\u0005=\u0013QKA.\u001d\u0011\tI%a\u0013\u0011\u0005A\u001a\u0013bAA'G\u00051\u0001K]3eK\u001aLA!!\u0015\u0002T\t\u0019Q*\u00199\u000b\u0007\u000553\u0005\u0005\u0003\u0002H\u0005]\u0013\u0002BA-\u0003'\u0012aa\u0015;sS:<\u0007\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005t#A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA3\u0003?\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0001")
public class StatisticsBackedCardinalityModel
implements Metrics.CardinalityModel {
    private final Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel;
    private final ExpressionEvaluator simpleExpressionEvaluator;
    private final ExpressionSelectivityCalculator expressionSelectivityCalculator;
    private final SelectivityCombiner combiner;

    public static Cardinality aggregateCardinalityBeforeSelection(Cardinality cardinality, Map<String, Expression> map) {
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityBeforeSelection(cardinality, map);
    }

    private ExpressionSelectivityCalculator expressionSelectivityCalculator() {
        return this.expressionSelectivityCalculator;
    }

    private SelectivityCombiner combiner() {
        return this.combiner;
    }

    @Override
    public Cardinality apply(PlannerQueryPart queryPart, Metrics.QueryGraphSolverInput input0, SemanticTable semanticTable) {
        Cardinality cardinality;
        PlannerQueryPart plannerQueryPart = queryPart;
        if (plannerQueryPart instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQueryPart;
            Metrics.QueryGraphSolverInput output = (Metrics.QueryGraphSolverInput)singlePlannerQuery.fold((Object)input0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Metrics.QueryGraphSolverInput input = (Metrics.QueryGraphSolverInput)tuple2._1();
                SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)tuple2._2();
                if (!(singlePlannerQuery instanceof RegularSinglePlannerQuery)) throw new MatchError((Object)tuple2);
                RegularSinglePlannerQuery regularSinglePlannerQuery = (RegularSinglePlannerQuery)singlePlannerQuery;
                QueryGraph graph = regularSinglePlannerQuery.queryGraph();
                QueryHorizon horizon = regularSinglePlannerQuery.horizon();
                Metrics.QueryGraphSolverInput queryGraphSolverInput = this.calculateCardinalityForQueryGraph(graph, input, semanticTable);
                if (queryGraphSolverInput == null) throw new MatchError((Object)queryGraphSolverInput);
                Map<String, Set<LabelName>> newLabels = queryGraphSolverInput.labelInfo();
                Cardinality graphCardinality = queryGraphSolverInput.inboundCardinality();
                Option<StrictnessMode> laziness = queryGraphSolverInput.strictness();
                Tuple3 tuple3 = new Tuple3(newLabels, (Object)graphCardinality, laziness);
                Tuple3 tuple32 = tuple3;
                Map newLabels2 = (Map)tuple32._1();
                Cardinality graphCardinality2 = (Cardinality)tuple32._2();
                Option laziness2 = (Option)tuple32._3();
                Cardinality horizonCardinality = this.calculateCardinalityForQueryHorizon(graphCardinality2, horizon, semanticTable);
                return new Metrics.QueryGraphSolverInput((Map<String, Set<LabelName>>)newLabels2, horizonCardinality, (Option<StrictnessMode>)laziness2);
            });
            cardinality = output.inboundCardinality();
        } else if (plannerQueryPart instanceof UnionQuery) {
            UnionQuery unionQuery = (UnionQuery)plannerQueryPart;
            PlannerQueryPart part = unionQuery.part();
            SinglePlannerQuery query = unionQuery.query();
            boolean distinct2 = unionQuery.distinct();
            Cardinality unionCardinality = this.apply(part, input0, semanticTable).$plus(this.apply((PlannerQueryPart)query, input0, semanticTable));
            cardinality = distinct2 ? unionCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY()) : unionCardinality;
        } else {
            throw new MatchError((Object)plannerQueryPart);
        }
        return cardinality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cardinality calculateCardinalityForQueryHorizon(Cardinality in, QueryHorizon horizon, SemanticTable semanticTable) {
        boolean bl = false;
        RegularQueryProjection regularQueryProjection = null;
        boolean bl2 = false;
        AggregatingQueryProjection aggregatingQueryProjection = null;
        QueryHorizon queryHorizon = horizon;
        if (queryHorizon instanceof RegularQueryProjection) {
            Some some;
            Expression limit;
            Option option;
            bl = true;
            regularQueryProjection = (RegularQueryProjection)queryHorizon;
            QueryPagination queryPagination = regularQueryProjection.queryPagination();
            Selections where = regularQueryProjection.selections();
            if (queryPagination != null && (option = queryPagination.limit()) instanceof Some && (limit = (Expression)(some = (Some)option).value()) instanceof IntegerLiteral) {
                IntegerLiteral integerLiteral = (IntegerLiteral)limit;
                Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, Cardinality$.MODULE$.lift((double)Predef$.MODULE$.Long2long(integerLiteral.value())));
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, where, semanticTable);
            }
        }
        if (bl) {
            Option option;
            QueryPagination queryPagination = regularQueryProjection.queryPagination();
            Selections where = regularQueryProjection.selections();
            if (queryPagination != null && (option = queryPagination.limit()) instanceof Some) {
                Option<Object> evaluatedValue;
                boolean cannotEvaluateStableValue;
                Some some = (Some)option;
                Expression limit = (Expression)some.value();
                boolean bl3 = cannotEvaluateStableValue = this.simpleExpressionEvaluator.hasParameters(limit) || !this.simpleExpressionEvaluator.isDeterministic(limit);
                Cardinality limitCardinality = cannotEvaluateStableValue ? PlannerDefaults$.MODULE$.DEFAULT_LIMIT_CARDINALITY() : ((evaluatedValue = this.simpleExpressionEvaluator.evaluateExpression(limit)).isDefined() && evaluatedValue.get() instanceof NumberValue ? new Cardinality(((NumberValue)evaluatedValue.get()).doubleValue()) : PlannerDefaults$.MODULE$.DEFAULT_LIMIT_CARDINALITY());
                Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, limitCardinality);
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, where, semanticTable);
            }
        }
        if (bl) {
            return this.horizonCardinalityWithSelections(in, regularQueryProjection.selections(), semanticTable);
        }
        if (queryHorizon instanceof AggregatingQueryProjection) {
            bl2 = true;
            aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            if (aggregatingQueryProjection.aggregationExpressions().isEmpty()) {
                Cardinality cardinalityBeforeSelection = in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, aggregatingQueryProjection.selections(), semanticTable);
            }
        }
        if (queryHorizon instanceof DistinctQueryProjection) {
            DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
            Cardinality cardinalityBeforeSelection = in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
            return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, distinctQueryProjection.selections(), semanticTable);
        }
        if (bl2) {
            Cardinality cardinalityBeforeSelection = StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityBeforeSelection(in, (Map<String, Expression>)aggregatingQueryProjection.groupingExpressions());
            return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, aggregatingQueryProjection.selections(), semanticTable);
        }
        if (queryHorizon instanceof UnwindProjection) {
            return in.$times(new Multiplier(10.0));
        }
        if (queryHorizon instanceof ProcedureCallProjection) {
            return in.$times(new Multiplier(10.0)).min(Cardinality$.MODULE$.lift(1.0)).max(Cardinality$.MODULE$.lift(10000.0));
        }
        if (queryHorizon instanceof LoadCSVProjection) {
            return in;
        }
        if (queryHorizon instanceof PassthroughAllHorizon) {
            return in;
        }
        if (!(queryHorizon instanceof CallSubqueryHorizon)) throw new MatchError((Object)queryHorizon);
        CallSubqueryHorizon callSubqueryHorizon = (CallSubqueryHorizon)queryHorizon;
        PlannerQueryPart subquery = callSubqueryHorizon.callSubquery();
        Cardinality subQueryCardinality = this.apply(subquery, Metrics$QueryGraphSolverInput$.MODULE$.empty(), semanticTable);
        return in.$times(subQueryCardinality);
    }

    private Cardinality horizonCardinalityWithSelections(Cardinality cardinalityBeforeSelection, Selections where, SemanticTable semanticTable) {
        Cardinality cardinality;
        Selections selections = where;
        SemanticTable implicitSemanticTable = semanticTable;
        Seq expressionSelectivities = (Seq)selections.flatPredicates().map((Function1 & Serializable & scala.Serializable)x$2 -> this.expressionSelectivityCalculator().apply((Expression)x$2, implicitSemanticTable, selections), Seq$.MODULE$.canBuildFrom());
        Option<Selectivity> maybeWhereSelectivity = this.combiner().andTogetherSelectivities((Seq<Selectivity>)expressionSelectivities);
        Option<Selectivity> option = maybeWhereSelectivity;
        if (option instanceof Some) {
            Some some = (Some)option;
            Selectivity whereSelectivity = (Selectivity)some.value();
            cardinality = cardinalityBeforeSelection.$times(whereSelectivity);
        } else if (None$.MODULE$.equals(option)) {
            cardinality = cardinalityBeforeSelection;
        } else {
            throw new MatchError(option);
        }
        return cardinality;
    }

    private Metrics.QueryGraphSolverInput calculateCardinalityForQueryGraph(QueryGraph graph, Metrics.QueryGraphSolverInput input, SemanticTable semanticTable) {
        Map<String, Set<LabelName>> newLabels = MapSupport$.MODULE$.PowerMap(input.labelInfo()).fuse((Map<String, Set<LabelName>>)graph.patternNodeLabels(), (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (Set)x$3.$plus$plus((GenTraversableOnce)x$4));
        Cardinality newCardinality = this.queryGraphCardinalityModel.apply(graph, input, semanticTable);
        return new Metrics.QueryGraphSolverInput(newLabels, newCardinality, input.strictness());
    }

    public StatisticsBackedCardinalityModel(Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel, ExpressionEvaluator simpleExpressionEvaluator2) {
        this.queryGraphCardinalityModel = queryGraphCardinalityModel;
        this.simpleExpressionEvaluator = simpleExpressionEvaluator2;
        this.expressionSelectivityCalculator = queryGraphCardinalityModel.expressionSelectivityCalculator();
        this.combiner = IndependenceCombiner$.MODULE$;
    }
}

