/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.compiler.DeprecatedProcedureNotification;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.InternalException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class ProcedureDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static ProcedureDeprecationWarnings$ MODULE$;

    static {
        new ProcedureDeprecationWarnings$();
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.postConditions$((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable & scala.Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement) {
        return (Set)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)A1).signature()) != null) {
                    QualifiedName name = procedureSignature.name();
                    Option option = procedureSignature.deprecationInfo();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String deprecatedBy = (String)some.value();
                        intersect = (Function1 & Serializable & scala.Serializable)seq -> new Tuple2((Object)seq.$plus((Object)new DeprecatedProcedureNotification(resolvedCall.position(), name.toString(), deprecatedBy)), (Object)None$.MODULE$);
                        return (B1)intersect;
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already");
                }
                intersect = function1.apply(x1);
                return (B1)intersect;
            }

            public final boolean isDefinedAt(Object x1) {
                Option option;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                Object object = x1;
                boolean bl = object instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)object).signature()) != null && (option = procedureSignature.deprecationInfo()) instanceof Some ? true : object instanceof UnresolvedCall;
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.logical.plans.ResolvedCall org.neo4j.cypher.internal.logical.plans.QualifiedName java.lang.String scala.collection.immutable.Set )}, serializedLambda);
            }
        });
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String description() {
        return "find calls to deprecated procedures and generate warnings for them";
    }

    private ProcedureDeprecationWarnings$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        VisitorPhase.$init$((VisitorPhase)this);
    }
}

