/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.Eagerness$;
import org.neo4j.cypher.internal.compiler.planner.logical.EventHorizonPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.plannerQueryPartPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.aggregation$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.distinct$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.skipAndLimit$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.exceptions.InternalException;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class PlanEventHorizon$
implements EventHorizonPlanner,
Product,
Serializable {
    public static PlanEventHorizon$ MODULE$;

    static {
        new PlanEventHorizon$();
    }

    @Override
    public LogicalPlan apply(SinglePlannerQuery query, LogicalPlan plan, Option<InterestingOrder> previousInterestingOrder, LogicalPlanningContext context) {
        LogicalPlan logicalPlan;
        LogicalPlan selectedPlan = context.config().applySelections().apply(plan, query.queryGraph(), query.interestingOrder(), context);
        QueryHorizon queryHorizon = query.horizon();
        if (queryHorizon instanceof AggregatingQueryProjection) {
            LogicalPlan logicalPlan2;
            AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            LogicalPlan aggregationPlan = aggregation$.MODULE$.apply(selectedPlan, aggregatingQueryProjection, query.interestingOrder(), previousInterestingOrder, context);
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(aggregationPlan, query.interestingOrder(), context);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            if (aggregatingQueryProjection.selections().isEmpty()) {
                logicalPlan2 = limited;
            } else {
                Seq predicates = aggregatingQueryProjection.selections().flatPredicates();
                logicalPlan2 = context.logicalPlanProducer().planHorizonSelection(limited, (Seq<Expression>)predicates, query.interestingOrder(), context);
            }
            logicalPlan = logicalPlan2;
        } else if (queryHorizon instanceof RegularQueryProjection) {
            LogicalPlan logicalPlan3;
            LogicalPlan projected;
            RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(selectedPlan, query.interestingOrder(), context);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            LogicalPlan logicalPlan4 = projected = regularQueryProjection.projections().isEmpty() && query.tail().isEmpty() ? context.logicalPlanProducer().planEmptyProjection(plan, context) : projection$.MODULE$.apply(limited, (Map<String, Expression>)regularQueryProjection.projections(), (Map<String, Expression>)regularQueryProjection.projections(), context);
            if (regularQueryProjection.selections().isEmpty()) {
                logicalPlan3 = projected;
            } else {
                Seq predicates = regularQueryProjection.selections().flatPredicates();
                logicalPlan3 = context.logicalPlanProducer().planHorizonSelection(projected, (Seq<Expression>)predicates, query.interestingOrder(), context);
            }
            logicalPlan = logicalPlan3;
        } else if (queryHorizon instanceof DistinctQueryProjection) {
            LogicalPlan logicalPlan5;
            DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
            LogicalPlan distinctPlan = distinct$.MODULE$.apply(selectedPlan, distinctQueryProjection, context);
            LogicalPlan sorted = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(distinctPlan, query.interestingOrder(), context);
            LogicalPlan limited = skipAndLimit$.MODULE$.apply(sorted, query, context);
            if (distinctQueryProjection.selections().isEmpty()) {
                logicalPlan5 = limited;
            } else {
                Seq predicates = distinctQueryProjection.selections().flatPredicates();
                logicalPlan5 = context.logicalPlanProducer().planHorizonSelection(limited, (Seq<Expression>)predicates, query.interestingOrder(), context);
            }
            logicalPlan = logicalPlan5;
        } else if (queryHorizon instanceof UnwindProjection) {
            UnwindProjection unwindProjection = (UnwindProjection)queryHorizon;
            String variable = unwindProjection.variable();
            Expression expression = unwindProjection.exp();
            LogicalPlan projected = context.logicalPlanProducer().planUnwind(selectedPlan, variable, expression, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, query.interestingOrder(), context);
        } else if (queryHorizon instanceof ProcedureCallProjection) {
            ProcedureCallProjection procedureCallProjection = (ProcedureCallProjection)queryHorizon;
            ResolvedCall call = procedureCallProjection.call();
            LogicalPlan projected = context.logicalPlanProducer().planCallProcedure(plan, call, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, query.interestingOrder(), context);
        } else if (queryHorizon instanceof LoadCSVProjection) {
            LoadCSVProjection loadCSVProjection = (LoadCSVProjection)queryHorizon;
            String variableName = loadCSVProjection.variable();
            Expression url = loadCSVProjection.url();
            CSVFormat format = loadCSVProjection.format();
            Option fieldTerminator = loadCSVProjection.fieldTerminator();
            LogicalPlan projected = context.logicalPlanProducer().planLoadCSV(plan, variableName, url, format, (Option<StringLiteral>)fieldTerminator, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, query.interestingOrder(), context);
        } else if (queryHorizon instanceof PassthroughAllHorizon) {
            LogicalPlan projected = context.logicalPlanProducer().planPassAll(plan, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, query.interestingOrder(), context);
        } else if (queryHorizon instanceof CallSubqueryHorizon) {
            LogicalPlan subPlan;
            CallSubqueryHorizon callSubqueryHorizon = (CallSubqueryHorizon)queryHorizon;
            PlannerQueryPart callSubquery = callSubqueryHorizon.callSubquery();
            boolean correlated = callSubqueryHorizon.correlated();
            Tuple2<LogicalPlan, LogicalPlanningContext> tuple2 = plannerQueryPartPlanner$.MODULE$.plan(callSubquery, context, plannerQueryPartPlanner$.MODULE$.plan$default$3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogicalPlan logicalPlan6 = subPlan = (LogicalPlan)tuple2._1();
            LogicalPlan subPlan2 = logicalPlan6;
            logicalPlan = context.logicalPlanProducer().planSubquery(plan, subPlan2, context, correlated);
        } else {
            throw new InternalException(new StringBuilder(39).append("Received QG with unknown horizon type: ").append(query.horizon()).toString());
        }
        LogicalPlan projectedPlan = logicalPlan;
        return Eagerness$.MODULE$.horizonReadWriteEagerize(projectedPlan, query, context);
    }

    public String productPrefix() {
        return "PlanEventHorizon";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PlanEventHorizon$;
    }

    public int hashCode() {
        return -120284278;
    }

    public String toString() {
        return "PlanEventHorizon";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PlanEventHorizon$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

