/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.compiler.DeprecatedFieldNotification;
import org.neo4j.cypher.internal.compiler.ProcedureWarningNotification;
import org.neo4j.cypher.internal.compiler.phases.ProcedureWarnings$;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.logical.plans.FieldSignature;
import org.neo4j.cypher.internal.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Foldable$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.InternalException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

public final class ProcedureWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static ProcedureWarnings$ MODULE$;

    static {
        new ProcedureWarnings$();
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.postConditions$((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findWarnings(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable & scala.Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findWarnings(Statement statement) {
        return (Set)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                boolean bl = false;
                ObjectRef objectRef = ObjectRef.create(null);
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall) {
                    bl = true;
                    objectRef.elem = (ResolvedCall)A1;
                    ProcedureSignature procedureSignature = ((ResolvedCall)objectRef.elem).signature();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.warning();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String warning = (String)some.value();
                            intersect = (Function1 & Serializable & scala.Serializable)seq -> new Tuple2((Object)seq.$plus((Object)new ProcedureWarningNotification(((ResolvedCall)x2$2.elem).position(), name.toString(), warning)), (Object)None$.MODULE$);
                            return (B1)intersect;
                        }
                    }
                }
                if (bl) {
                    ProcedureSignature procedureSignature = ((ResolvedCall)objectRef.elem).signature();
                    IndexedSeq results = ((ResolvedCall)objectRef.elem).callResults();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.outputSignature();
                        Option option2 = procedureSignature.deprecationInfo();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            IndexedSeq output = (IndexedSeq)some.value();
                            if (None$.MODULE$.equals(option2) && output.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findWarnings.1.$anonfun$applyOrElse$3(x$1)))) {
                                intersect = (Function1 & Serializable & scala.Serializable)set -> new Tuple2((Object)set.$plus$plus(ProcedureWarnings$.MODULE$.org$neo4j$cypher$internal$compiler$phases$ProcedureWarnings$$usedDeprecatedFields(name.toString(), (Seq<ProcedureResultItem>)results, (Seq<FieldSignature>)output)), (Object)None$.MODULE$);
                                return (B1)intersect;
                            }
                        }
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already");
                }
                intersect = function1.apply(x1);
                return (B1)intersect;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                ProcedureSignature procedureSignature;
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                Object object = x1;
                if (object instanceof ResolvedCall) {
                    Option option;
                    bl = true;
                    resolvedCall = (ResolvedCall)object;
                    ProcedureSignature procedureSignature2 = resolvedCall.signature();
                    if (procedureSignature2 != null && (option = procedureSignature2.warning()) instanceof Some) {
                        return true;
                    }
                }
                if (bl && (procedureSignature = resolvedCall.signature()) != null) {
                    Option option = procedureSignature.outputSignature();
                    Option option2 = procedureSignature.deprecationInfo();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        IndexedSeq output = (IndexedSeq)some.value();
                        if (None$.MODULE$.equals(option2) && output.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findWarnings.1.$anonfun$isDefinedAt$1(x$1)))) {
                            return true;
                        }
                    }
                }
                if (!(object instanceof UnresolvedCall)) return false;
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(FieldSignature x$1) {
                return x$1.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(FieldSignature x$1) {
                return x$1.deprecated();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(scala.runtime.ObjectRef org.neo4j.cypher.internal.logical.plans.QualifiedName java.lang.String scala.collection.immutable.Set ), $anonfun$applyOrElse$3$adapted(org.neo4j.cypher.internal.logical.plans.FieldSignature ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.logical.plans.QualifiedName scala.collection.IndexedSeq scala.collection.IndexedSeq scala.collection.immutable.Set ), $anonfun$isDefinedAt$1$adapted(org.neo4j.cypher.internal.logical.plans.FieldSignature )}, serializedLambda);
            }
        });
    }

    public Seq<DeprecatedFieldNotification> org$neo4j$cypher$internal$compiler$phases$ProcedureWarnings$$usedDeprecatedFields(String procedure, Seq<ProcedureResultItem> used, Seq<FieldSignature> available) {
        return (Seq)((TraversableLike)used.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)available.exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)ProcedureWarnings$.$anonfun$usedDeprecatedFields$2(r, o)))))).map((Function1 & Serializable & scala.Serializable)r -> new DeprecatedFieldNotification(r.position(), procedure, r.outputName()), Seq$.MODULE$.canBuildFrom());
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String description() {
        return "find calls to procedures with warnings";
    }

    public static final /* synthetic */ boolean $anonfun$usedDeprecatedFields$2(ProcedureResultItem r$1, FieldSignature o) {
        String string = o.name();
        String string2 = r$1.outputName();
        return !(string != null ? !string.equals(string2) : string2 != null) && o.deprecated();
    }

    private ProcedureWarnings$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        VisitorPhase.$init$((VisitorPhase)this);
    }
}

