/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\t\u0012\u0001\tB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006q\u0002!\t!_\u0004\n\u0003_\t\u0012\u0011!E\u0001\u0003c1\u0001\u0002E\t\u0002\u0002#\u0005\u00111\u0007\u0005\u0007[2!\t!!\u000e\t\u0013\u0005]B\"%A\u0005\u0002\u0005e\u0002\"CA2\u0019E\u0005I\u0011AA3\u0005%IE\tU*pYZ,'O\u0003\u0002\u0013'\u0005\u0019\u0011\u000e\u001a9\u000b\u0005Q)\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003-]\tq\u0001\u001d7b]:,'O\u0003\u0002\u00193\u0005A1m\\7qS2,'O\u0003\u0002\u001b7\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001d;\u000511-\u001f9iKJT!AH\u0010\u0002\u000b9,w\u000e\u000e6\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001)RaI\u0019<}\u0005\u001b\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003%9WM\\3sCR|'\u000f\u0005\u0004-[=RT\bQ\u0007\u0002#%\u0011a&\u0005\u0002\u000e\u0013\u0012\u00036k\u001c7wKJ\u001cF/\u001a9\u0011\u0005A\nD\u0002\u0001\u0003\u0006e\u0001\u0011\ra\r\u0002\t'>dg/\u00192mKF\u0011Ag\u000e\t\u0003KUJ!A\u000e\u0014\u0003\u000f9{G\u000f[5oOB\u0011Q\u0005O\u0005\u0003s\u0019\u00121!\u00118z!\t\u00014\bB\u0003=\u0001\t\u00071GA\u0006SKF,\u0018N]3nK:$\bC\u0001\u0019?\t\u0015y\u0004A1\u00014\u0005\u0019\u0011Vm];miB\u0011\u0001'\u0011\u0003\u0006\u0005\u0002\u0011\ra\r\u0002\b\u0007>tG/\u001a=u\u0003I\u0001(o\u001c6fGRLgnZ*fY\u0016\u001cGo\u001c:\u0011\u0007\u00153U(D\u0001\u0014\u0013\t95C\u0001\nQe>TWm\u0019;j]\u001e\u001cV\r\\3di>\u0014\u0018a\u0004:fO&\u001cHO]=GC\u000e$xN]=\u0011\u0007\u0015RE*\u0003\u0002LM\tIa)\u001e8di&|g\u000e\r\t\u0004Y5{\u0013B\u0001(\u0012\u0005)IEMU3hSN$(/_\u0001\ri\u0006\u0014G.\u001a$bGR|'/\u001f\t\u0006KEc5KW\u0005\u0003%\u001a\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u000bQ;vFO\u001f\u000f\u00051*\u0016B\u0001,\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\tM+W\r\u001a\u0006\u0003-F\u0001B\u0001L.>u%\u0011A,\u0005\u0002\t\u0013\u0012\u0003F+\u00192mK\u0006aQ.\u0019=UC\ndWmU5{KB\u0011QeX\u0005\u0003A\u001a\u00121!\u00138u\u0003YIG/\u001a:bi&|g\u000eR;sCRLwN\u001c'j[&$\bCA\u0013d\u0013\t!gE\u0001\u0003M_:<\u0017\u0001E3yiJ\f'+Z9vSJ,W.\u001a8u!\u0011asMO\u001f\n\u0005!\f\"\u0001E#yiJ\f'+Z9vSJ,W.\u001a8u\u0003\u001diwN\\5u_J\u0004\"\u0001L6\n\u00051\f\"\u0001E%E!N{GN^3s\u001b>t\u0017\u000e^8s\u0003\u0019a\u0014N\\5u}QIq\u000e]9sgR,ho\u001e\t\u0007Y\u0001y#(\u0010!\t\u000b)J\u0001\u0019A\u0016\t\u000b\rK\u0001\u0019\u0001#\t\u000f!K\u0001\u0013!a\u0001\u0013\"9q*\u0003I\u0001\u0002\u0004\u0001\u0006\"B/\n\u0001\u0004q\u0006\"B1\n\u0001\u0004\u0011\u0007\"B3\n\u0001\u00041\u0007\"B5\n\u0001\u0004Q\u0017!B1qa2LHc\u0002>\u0002$\u0005\u001d\u00121\u0006\t\u0006w\u0006\u0015\u00111\u0002\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u0000C\u00051AH]8pizJ\u0011aJ\u0005\u0003-\u001aJA!a\u0002\u0002\n\tA\u0011\n^3sCR|'O\u0003\u0002WMA1Q%!\u0004\u0002\u0012uJ1!a\u0004'\u0005\u0019!V\u000f\u001d7feA1Q%!\u0004\u0002\u0014i\u0002R!!\u0006\u0002\u001e=rA!a\u0006\u0002\u001aA\u0011QPJ\u0005\u0004\u000371\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"aA*fi*\u0019\u00111\u0004\u0014\t\r\u0005\u0015\"\u00021\u0001T\u0003\u0011\u0019X-\u001a3\t\u000f\u0005%\"\u00021\u0001\u0002\u0014\u0005Y\u0011N\\5uS\u0006dGk\u001c#p\u0011\u0019\tiC\u0003a\u0001\u0001\u000691m\u001c8uKb$\u0018!C%E!N{GN^3s!\taCb\u0005\u0002\rIQ\u0011\u0011\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0015\u0005m\u0012\u0011JA/\u0003?\n\t'\u0006\u0002\u0002>)\"\u0011qHA&!\u0011)#*!\u0011\u0011\u000b1\n\u0019%a\u0012\n\u0007\u0005\u0015\u0013CA\tEK\u001a\fW\u000f\u001c;JIJ+w-[:uef\u00042\u0001MA%\t\u0015\u0011dB1\u00014W\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA,M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0013\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002\u001f\u000f\u0005\u0004\u0019D!B \u000f\u0005\u0004\u0019D!\u0002\"\u000f\u0005\u0004\u0019\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0006\u0002h\u0005E\u0014qOA>\u0003\u007f*\"!!\u001b+\t\u0005-\u00141\n\t\tKE\u000bi'a\u001d\u0002~A!A&TA8!\r\u0001\u0014\u0011\u000f\u0003\u0006e=\u0011\ra\r\t\t)^\u000by'!\u001e\u0002zA\u0019\u0001'a\u001e\u0005\u000bqz!\u0019A\u001a\u0011\u0007A\nY\bB\u0003@\u001f\t\u00071\u0007\u0005\u0004-7\u0006e\u0014Q\u000f\u0003\u0006\u0005>\u0011\ra\r")
public class IDPSolver<Solvable, Requirement, Result, Context> {
    private final IDPSolverStep<Solvable, Requirement, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    public final ExtraRequirement<Requirement, Result> org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement;
    private final IDPSolverMonitor monitor;

    public static <Solvable, Requirement, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Requirement, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public Iterator<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>> seed, Set<Solvable> initialToDo, Context context) {
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        ObjectRef toDo = ObjectRef.create((Object)registry.registerAll(initialToDo));
        Function1 & Serializable & scala.Serializable goalSelector = (Function1 & Serializable & scala.Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable & scala.Serializable)x$1 -> x$1._2(), x$2);
        int iterations = 0;
        while (((BitSet)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestFinished = this.generateBestCandidates$1(((BitSet)toDo.elem).size(), toDo, table, registry, context);
            if (largestFinished <= 0) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("Unfortunately, the planner was unable to find a plan within the constraints provided.\n           |Try increasing the config values `").append(GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name()).append("`\n           |and `").append(GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name()).append("` to allow\n           |for a larger sub-plan table and longer planning time.").toString())).stripMargin());
            }
            BitSet bestGoal = IDPSolver.findBestCandidateInBlock$1(largestFinished, table, goalSelector);
            this.monitor.endIteration(iterations, largestFinished, table.size());
            IDPSolver.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations);
        Iterator maybeSorted = table.plans().collect((PartialFunction)new scala.Serializable(this, registry){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDPSolver $outer;
            private final IdRegistry registry$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Tuple2<BitSet, Requirement>, Result>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Tuple2 tuple2 = (Tuple2)A1._1();
                    Object result = A1._2();
                    if (tuple2 != null) {
                        BitSet key = (BitSet)tuple2._1();
                        Object attribute = tuple2._2();
                        if (this.$outer.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.is(attribute)) {
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2(this.registry$1.explode(key), attribute)), result);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Tuple2<BitSet, Requirement>, Result> x1) {
                Object attribute;
                Tuple2 tuple2;
                Tuple2<Tuple2<BitSet, Requirement>, Result> tuple22 = x1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null && this.$outer.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.is(attribute = tuple2._2());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.registry$1 = registry$1;
            }
        });
        return maybeSorted.hasNext() ? maybeSorted : table.plans().collect((PartialFunction)new scala.Serializable(null, registry){
            public static final long serialVersionUID = 0L;
            private final IdRegistry registry$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Tuple2<BitSet, Requirement>, Result>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    Tuple2 tuple2 = (Tuple2)A1._1();
                    Object result = A1._2();
                    if (tuple2 != null) {
                        BitSet key = (BitSet)tuple2._1();
                        Object attribute = tuple2._2();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2(this.registry$1.explode(key), attribute)), result);
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Tuple2<BitSet, Requirement>, Result> x2) {
                Tuple2 tuple2;
                Tuple2<Tuple2<BitSet, Requirement>, Result> tuple22 = x2;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
            {
                this.registry$1 = registry$1;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(IDPSolver $this, Object candidate) {
        return BoxesRunTime.equals($this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.forResult(candidate), $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.none());
    }

    public static final /* synthetic */ void $anonfun$apply$5(IDPSolver $this, BooleanRef foundNoCandidate$1, IDPTable table$1, BitSet goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.none(), candidate);
    }

    public static final /* synthetic */ void $anonfun$apply$6(IDPSolver $this, BooleanRef foundNoCandidate$1, IDPTable table$1, BitSet goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, $this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement.forResult(candidate), candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, ObjectRef toDo$1, IDPTable table$1, IdRegistry registry$1, Object context$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        Stopwatch start = Stopwatch.start();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator goals = ((BitSet)toDo$1.elem).subsets(++blockSize);
            while (keepGoing && goals.hasNext()) {
                BitSet goal = (BitSet)goals.next();
                if (!table$1.apply(goal).isEmpty()) continue;
                LazyIterable candidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.generator.apply(registry$1, goal, table$1, context$1));
                Tuple2 tuple2 = candidates.partition((Function1 & Serializable & scala.Serializable)candidate -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$apply$4(this, candidate)));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Iterable baseCandidates = (Iterable)tuple2._1();
                Iterable extraCandidates = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)baseCandidates, (Object)extraCandidates);
                Tuple2 tuple23 = tuple22;
                Iterable baseCandidates2 = (Iterable)tuple23._1();
                Iterable extraCandidates2 = (Iterable)tuple23._2();
                this.projectingSelector.apply(baseCandidates2).foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$5(this, foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                this.projectingSelector.apply(extraCandidates2).foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$6(this, foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && !start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS);
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    private static final BitSet findBestCandidateInBlock$1(int blockSize, IDPTable table$1, Function1 goalSelector$1) {
        BitSet goal;
        Tuple2 tuple2;
        IndexedSeq blockCandidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> table$1.plansOfSize(blockSize)).toIndexedSeq();
        Option bestInBlock = (Option)goalSelector$1.apply(blockCandidates);
        Tuple2 tuple22 = (Tuple2)bestInBlock.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("Found no solution for block with size ").append(blockSize).append(",\n             |").append(blockCandidates).append(" were the selected candidates from the table ").append(table$1).toString())).stripMargin());
        });
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
            throw new MatchError((Object)tuple22);
        }
        BitSet bitSet = goal = (BitSet)tuple2._1();
        BitSet goal2 = bitSet;
        return goal2;
    }

    public static final /* synthetic */ void $anonfun$apply$9(IDPTable table$1, int newId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object attribute = tuple2._1();
        Object result = tuple2._2();
        table$1.put(BitSet$.MODULE$.empty().$plus(newId$1), attribute, result);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void compactBlock$1(BitSet original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original);
        table$1.apply(original).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IDPSolver.$anonfun$apply$9(table$1, newId, x0$1);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = ((BitSet)((BitSet)toDo$1.elem).$minus$minus((GenTraversableOnce)original)).$plus(newId);
        table$1.removeAllTracesOf(original);
    }

    public IDPSolver(IDPSolverStep<Solvable, Requirement, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Requirement>, Result>>, IDPTable<Result, Requirement>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Requirement, Result> extraRequirement, IDPSolverMonitor monitor) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.org$neo4j$cypher$internal$compiler$planner$logical$idp$IDPSolver$$extraRequirement = extraRequirement;
        this.monitor = monitor;
    }
}

