/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.AliasedReturnItem;
import org.neo4j.cypher.internal.ast.AscSortItem;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.Create;
import org.neo4j.cypher.internal.ast.Delete;
import org.neo4j.cypher.internal.ast.DescSortItem;
import org.neo4j.cypher.internal.ast.Foreach;
import org.neo4j.cypher.internal.ast.InputDataStream;
import org.neo4j.cypher.internal.ast.LoadCSV;
import org.neo4j.cypher.internal.ast.Match;
import org.neo4j.cypher.internal.ast.Merge;
import org.neo4j.cypher.internal.ast.MergeAction;
import org.neo4j.cypher.internal.ast.OnCreate;
import org.neo4j.cypher.internal.ast.OnMatch;
import org.neo4j.cypher.internal.ast.OrderBy;
import org.neo4j.cypher.internal.ast.QueryPart;
import org.neo4j.cypher.internal.ast.Remove;
import org.neo4j.cypher.internal.ast.RemoveItem;
import org.neo4j.cypher.internal.ast.RemoveLabelItem;
import org.neo4j.cypher.internal.ast.RemovePropertyItem;
import org.neo4j.cypher.internal.ast.Return;
import org.neo4j.cypher.internal.ast.ReturnItem;
import org.neo4j.cypher.internal.ast.ReturnItems;
import org.neo4j.cypher.internal.ast.SetClause;
import org.neo4j.cypher.internal.ast.SetExactPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetIncludingPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetItem;
import org.neo4j.cypher.internal.ast.SetLabelItem;
import org.neo4j.cypher.internal.ast.SetPropertyItem;
import org.neo4j.cypher.internal.ast.SortItem;
import org.neo4j.cypher.internal.ast.SubQuery;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.ast.Unwind;
import org.neo4j.cypher.internal.ast.Where;
import org.neo4j.cypher.internal.ast.With;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.helpers.AggregationHelper$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.expressions.EveryPath;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.In;
import org.neo4j.cypher.internal.expressions.IsAggregate$;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.LogicalProperty;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.LogicalVariable$;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.Null;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.expressions.containsAggregate$;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection$;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CreateNode;
import org.neo4j.cypher.internal.ir.CreatePattern;
import org.neo4j.cypher.internal.ir.CreateRelationship;
import org.neo4j.cypher.internal.ir.DeleteExpression;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection$;
import org.neo4j.cypher.internal.ir.ForeachPattern;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.MergeNodePattern;
import org.neo4j.cypher.internal.ir.MergeRelationshipPattern;
import org.neo4j.cypher.internal.ir.MutatingPattern;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryGraph$;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryPagination$;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.QueryProjection$;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection$;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.RemoveLabelPattern;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.SetLabelPattern;
import org.neo4j.cypher.internal.ir.SetMutatingPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertyPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetPropertyPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertyPattern;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters$;
import org.neo4j.cypher.internal.ir.helpers.PatternConverters;
import org.neo4j.cypher.internal.ir.helpers.PatternConverters$;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder$;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrderCandidate;
import org.neo4j.cypher.internal.ir.ordering.RequiredOrderCandidate;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.SyntaxException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ClauseConverters$ {
    public static ClauseConverters$ MODULE$;

    static {
        new ClauseConverters$();
    }

    public PlannerQueryBuilder addToLogicalPlanInput(PlannerQueryBuilder acc, Clause clause) {
        PlannerQueryBuilder plannerQueryBuilder;
        Clause clause2 = clause;
        if (clause2 instanceof Return) {
            Return return_ = (Return)clause2;
            plannerQueryBuilder = this.addReturnToLogicalPlanInput(acc, return_);
        } else if (clause2 instanceof Match) {
            Match match = (Match)clause2;
            plannerQueryBuilder = this.addMatchToLogicalPlanInput(acc, match);
        } else if (clause2 instanceof With) {
            With with = (With)clause2;
            plannerQueryBuilder = this.addWithToLogicalPlanInput(acc, with);
        } else if (clause2 instanceof Unwind) {
            Unwind unwind = (Unwind)clause2;
            plannerQueryBuilder = this.addUnwindToLogicalPlanInput(acc, unwind);
        } else if (clause2 instanceof ResolvedCall) {
            ResolvedCall resolvedCall = (ResolvedCall)clause2;
            plannerQueryBuilder = this.addCallToLogicalPlanInput(acc, resolvedCall);
        } else if (clause2 instanceof Create) {
            Create create = (Create)clause2;
            plannerQueryBuilder = this.addCreateToLogicalPlanInput(acc, create);
        } else if (clause2 instanceof SetClause) {
            SetClause setClause = (SetClause)clause2;
            plannerQueryBuilder = this.addSetClauseToLogicalPlanInput(acc, setClause);
        } else if (clause2 instanceof Delete) {
            Delete delete = (Delete)clause2;
            plannerQueryBuilder = this.addDeleteToLogicalPlanInput(acc, delete);
        } else if (clause2 instanceof Remove) {
            Remove remove = (Remove)clause2;
            plannerQueryBuilder = this.addRemoveToLogicalPlanInput(acc, remove);
        } else if (clause2 instanceof Merge) {
            Merge merge = (Merge)clause2;
            plannerQueryBuilder = this.addMergeToLogicalPlanInput(acc, merge);
        } else if (clause2 instanceof LoadCSV) {
            LoadCSV loadCSV = (LoadCSV)clause2;
            plannerQueryBuilder = this.addLoadCSVToLogicalPlanInput(acc, loadCSV);
        } else if (clause2 instanceof Foreach) {
            Foreach foreach = (Foreach)clause2;
            plannerQueryBuilder = this.addForeachToLogicalPlanInput(acc, foreach);
        } else if (clause2 instanceof InputDataStream) {
            InputDataStream inputDataStream = (InputDataStream)clause2;
            plannerQueryBuilder = this.addInputDataStreamToLogicalPlanInput(acc, inputDataStream);
        } else if (clause2 instanceof SubQuery) {
            SubQuery subQuery = (SubQuery)clause2;
            plannerQueryBuilder = this.addCallSubqueryToLogicalPlanInput(acc, subQuery);
        } else {
            if (clause2 instanceof UnresolvedCall) {
                UnresolvedCall unresolvedCall = (UnresolvedCall)clause2;
                throw new IllegalArgumentException(new StringBuilder(21).append(unresolvedCall).append(" is not expected here").toString());
            }
            throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(clause2).toString());
        }
        return plannerQueryBuilder;
    }

    private PlannerQueryBuilder addLoadCSVToLogicalPlanInput(PlannerQueryBuilder acc, LoadCSV clause) {
        return acc.withHorizon((QueryHorizon)new LoadCSVProjection(clause.variable().name(), clause.urlString(), (CSVFormat)(clause.withHeaders() ? HasHeaders$.MODULE$ : NoHeaders$.MODULE$), clause.fieldTerminator())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addInputDataStreamToLogicalPlanInput(PlannerQueryBuilder acc, InputDataStream clause) {
        return acc.withQueryInput((Seq<String>)((Seq)clause.variables().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())));
    }

    private Selections asSelections(Option<Where> optWhere) {
        return new Selections((scala.collection.immutable.Set)optWhere.map((Function1 & Serializable & scala.Serializable)x$2 -> ExpressionConverters.PredicateConverter$.MODULE$.asPredicates$extension0(ExpressionConverters$.MODULE$.PredicateConverter(x$2.expression()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty()));
    }

    private QueryProjection asQueryProjection(boolean distinct2, Seq<ReturnItem> items) {
        Seq seq;
        Seq groupingKeys;
        block5: {
            Tuple2 tuple2;
            block4: {
                tuple2 = items.partition((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)IsAggregate$.MODULE$.apply(item.expression())));
                if (tuple2 == null) break block4;
                Seq aggregatingItems = (Seq)tuple2._1();
                groupingKeys = (Seq)tuple2._2();
                if (aggregatingItems == null) break block4;
                seq = aggregatingItems;
                if (groupingKeys != null) break block5;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = groupingKeys;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Tuple2 tuple22 = tuple2;
        Seq aggregatingItems = (Seq)tuple22._1();
        Seq groupingKeys2 = (Seq)tuple22._2();
        Map projectionMap = ClauseConverters$.turnIntoMap$1(groupingKeys2);
        Map aggregationsMap = ClauseConverters$.turnIntoMap$1(aggregatingItems);
        if (projectionMap.values().exists((Function1)containsAggregate$.MODULE$)) {
            throw new InternalException("Grouping keys contains aggregation. AST has not been rewritten?");
        }
        return aggregationsMap.nonEmpty() ? new AggregatingQueryProjection(projectionMap, aggregationsMap, AggregatingQueryProjection$.MODULE$.apply$default$3(), AggregatingQueryProjection$.MODULE$.apply$default$4()) : (distinct2 ? new DistinctQueryProjection(projectionMap, DistinctQueryProjection$.MODULE$.apply$default$2(), DistinctQueryProjection$.MODULE$.apply$default$3()) : new RegularQueryProjection(projectionMap, RegularQueryProjection$.MODULE$.apply$default$2(), RegularQueryProjection$.MODULE$.apply$default$3()));
    }

    private PlannerQueryBuilder addReturnToLogicalPlanInput(PlannerQueryBuilder acc, Return clause) {
        Seq items;
        Option limit;
        Option skip;
        Option optOrderBy;
        boolean distinct2;
        block3: {
            block2: {
                Return return_ = clause;
                if (return_ == null) break block2;
                distinct2 = return_.distinct();
                ReturnItems returnItems = return_.returnItems();
                optOrderBy = return_.orderBy();
                skip = return_.skip();
                limit = return_.limit();
                if (returnItems == null) break block2;
                boolean star = returnItems.includeExisting();
                items = returnItems.items();
                if (!star) break block3;
            }
            throw new InternalException(new StringBuilder(67).append("AST needs to be rewritten before it can be used for planning. Got: ").append(clause).toString());
        }
        QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withSkip(skip).withLimit(limit);
        QueryProjection projection2 = this.asQueryProjection(distinct2, (Seq<ReturnItem>)items).withPagination(queryPagination);
        InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)projection2, (Option<OrderBy>)optOrderBy);
        PlannerQueryBuilder plannerQueryBuilder = acc.withHorizon((QueryHorizon)projection2).withInterestingOrder(requiredOrder);
        return plannerQueryBuilder;
    }

    public InterestingOrder findRequiredOrder(QueryHorizon horizon, Option<OrderBy> optOrderBy) {
        Iterable interestingOrderColumns;
        Seq requiredOrderColumns;
        block12: {
            Tuple2 tuple2;
            block11: {
                Tuple2 tuple22;
                Seq sortItems = optOrderBy.isDefined() ? ((OrderBy)optOrderBy.get()).sortItems() : (Seq)Seq$.MODULE$.empty();
                QueryHorizon queryHorizon = horizon;
                if (queryHorizon instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
                    Map projections = regularQueryProjection.projections();
                    tuple22 = new Tuple2(this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)projections), (Object)Seq$.MODULE$.empty());
                } else if (queryHorizon instanceof AggregatingQueryProjection) {
                    Iterable iterable;
                    AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
                    Map groupingExpressions = aggregatingQueryProjection.groupingExpressions();
                    Map aggregationExpressions = aggregatingQueryProjection.aggregationExpressions();
                    Seq<InterestingOrder.ColumnOrder> requiredOrders = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)groupingExpressions);
                    if (groupingExpressions.isEmpty() && aggregationExpressions.size() == 1) {
                        Expression value = (Expression)aggregationExpressions.apply(aggregationExpressions.keys().head());
                        iterable = (Iterable)AggregationHelper$.MODULE$.checkMinOrMax(value, (Function1 & Serializable & scala.Serializable)e -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterestingOrder.Asc[]{new InterestingOrder.Asc(e, InterestingOrder.Asc$.MODULE$.apply$default$2())})), (Function1 & Serializable & scala.Serializable)e -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterestingOrder.Desc[]{new InterestingOrder.Desc(e, InterestingOrder.Desc$.MODULE$.apply$default$2())})), Seq$.MODULE$.empty());
                    } else {
                        iterable = requiredOrders.isEmpty() ? (Iterable)groupingExpressions.values().collect((PartialFunction)new scala.Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof Property) {
                                    Property property = (Property)A1;
                                    object = new InterestingOrder.Asc((Expression)property, InterestingOrder.Asc$.MODULE$.apply$default$2());
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x1) {
                                Expression expression = x1;
                                boolean bl = expression instanceof Property;
                                return bl;
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.empty();
                    }
                    Iterable interestingColumnOrders = iterable;
                    tuple22 = new Tuple2(requiredOrders, (Object)interestingColumnOrders);
                } else if (queryHorizon instanceof DistinctQueryProjection) {
                    DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
                    Map groupingExpressions = distinctQueryProjection.groupingExpressions();
                    Seq<InterestingOrder.ColumnOrder> requiredColumns = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)groupingExpressions);
                    Iterable interestingColumnOrders = requiredColumns.isEmpty() ? (Iterable)groupingExpressions.values().collect((PartialFunction)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 instanceof Property) {
                                Property property = (Property)A1;
                                object = new InterestingOrder.Asc((Expression)property, InterestingOrder.Asc$.MODULE$.apply$default$2());
                            } else {
                                object = function1.apply(x2);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x2) {
                            Expression expression = x2;
                            boolean bl = expression instanceof Property;
                            return bl;
                        }
                    }, scala.collection.Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.empty();
                    tuple22 = new Tuple2(requiredColumns, (Object)interestingColumnOrders);
                } else {
                    tuple22 = new Tuple2((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty());
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block11;
                requiredOrderColumns = (Seq)tuple2._1();
                interestingOrderColumns = (Iterable)tuple2._2();
                if (interestingOrderColumns instanceof Seq) break block12;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq = (Seq)interestingOrderColumns;
        Tuple2 tuple2 = new Tuple2((Object)requiredOrderColumns, (Object)seq);
        Tuple2 tuple23 = tuple2;
        Seq requiredOrderColumns2 = (Seq)tuple23._1();
        Seq interestingOrderColumns2 = (Seq)tuple23._2();
        return interestingOrderColumns2.isEmpty() ? new InterestingOrder(new RequiredOrderCandidate(requiredOrderColumns2), InterestingOrder$.MODULE$.apply$default$2()) : new InterestingOrder(new RequiredOrderCandidate(requiredOrderColumns2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterestingOrderCandidate[]{new InterestingOrderCandidate(interestingOrderColumns2)})));
    }

    private Seq<InterestingOrder.ColumnOrder> extractColumnOrderFromOrderBy(Seq<SortItem> sortItems, Map<String, Expression> projections) {
        return (Seq)sortItems.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Variable variable;
            Option option;
            Expression e;
            Variable variable2;
            Option option2;
            Expression e2;
            boolean bl = false;
            AscSortItem ascSortItem = null;
            boolean bl2 = false;
            DescSortItem descSortItem = null;
            SortItem sortItem = x0$1;
            if (sortItem instanceof AscSortItem) {
                Variable variable3;
                Option option3;
                Property property;
                Expression expression;
                bl = true;
                ascSortItem = (AscSortItem)sortItem;
                Expression e3 = ascSortItem.expression();
                if (e3 instanceof Property && (expression = (property = (Property)e3).map()) instanceof Variable && !(option3 = LogicalVariable$.MODULE$.unapply(variable3 = (Variable)expression)).isEmpty()) {
                    InterestingOrder.Asc asc;
                    String varName = (String)option3.get();
                    Option option4 = projections.get((Object)varName);
                    if (option4 instanceof Some) {
                        Some some = (Some)option4;
                        Expression expression2 = (Expression)some.value();
                        asc = new InterestingOrder.Asc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)varName), (Object)expression2)})));
                        return asc;
                    } else {
                        if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
                        asc = new InterestingOrder.Asc((Expression)property, InterestingOrder.Asc$.MODULE$.apply$default$2());
                    }
                    return asc;
                }
            }
            if (sortItem instanceof DescSortItem) {
                Variable variable4;
                Option option5;
                Property property;
                Expression expression;
                bl2 = true;
                descSortItem = (DescSortItem)sortItem;
                Expression e4 = descSortItem.expression();
                if (e4 instanceof Property && (expression = (property = (Property)e4).map()) instanceof Variable && !(option5 = LogicalVariable$.MODULE$.unapply(variable4 = (Variable)expression)).isEmpty()) {
                    InterestingOrder.Desc desc;
                    String varName = (String)option5.get();
                    Option option6 = projections.get((Object)varName);
                    if (option6 instanceof Some) {
                        Some some = (Some)option6;
                        Expression expression3 = (Expression)some.value();
                        desc = new InterestingOrder.Desc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)varName), (Object)expression3)})));
                        return desc;
                    } else {
                        if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)option6);
                        desc = new InterestingOrder.Desc((Expression)property, InterestingOrder.Desc$.MODULE$.apply$default$2());
                    }
                    return desc;
                }
            }
            if (bl && (e2 = ascSortItem.expression()) instanceof Variable && !(option2 = LogicalVariable$.MODULE$.unapply(variable2 = (Variable)e2)).isEmpty()) {
                InterestingOrder.Asc asc;
                String name = (String)option2.get();
                Option option7 = projections.get((Object)name);
                if (option7 instanceof Some) {
                    Some some = (Some)option7;
                    Expression expression = (Expression)some.value();
                    asc = new InterestingOrder.Asc((Expression)variable2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)expression)})));
                    return asc;
                } else {
                    if (!None$.MODULE$.equals(option7)) throw new MatchError((Object)option7);
                    asc = new InterestingOrder.Asc((Expression)variable2, InterestingOrder.Asc$.MODULE$.apply$default$2());
                }
                return asc;
            }
            if (bl2 && (e = descSortItem.expression()) instanceof Variable && !(option = LogicalVariable$.MODULE$.unapply(variable = (Variable)e)).isEmpty()) {
                InterestingOrder.Desc desc;
                String name = (String)option.get();
                Option option8 = projections.get((Object)name);
                if (option8 instanceof Some) {
                    Some some = (Some)option8;
                    Expression expression = (Expression)some.value();
                    desc = new InterestingOrder.Desc((Expression)variable, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)expression)})));
                    return desc;
                } else {
                    if (!None$.MODULE$.equals(option8)) throw new MatchError((Object)option8);
                    desc = new InterestingOrder.Desc((Expression)variable, InterestingOrder.Desc$.MODULE$.apply$default$2());
                }
                return desc;
            }
            if (bl) {
                Expression expression = ascSortItem.expression();
                scala.collection.immutable.Set depNames = (scala.collection.immutable.Set)expression.dependencies().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                Map orderProjections = (Map)projections.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)depNames.contains(p._1())));
                return new InterestingOrder.Asc(expression, orderProjections);
            }
            if (!bl2) throw new MatchError((Object)sortItem);
            Expression expression = descSortItem.expression();
            scala.collection.immutable.Set depNames = (scala.collection.immutable.Set)expression.dependencies().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
            Map orderProjections = (Map)projections.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)depNames.contains(p._1())));
            return new InterestingOrder.Desc(expression, orderProjections);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private PlannerQueryBuilder addSetClauseToLogicalPlanInput(PlannerQueryBuilder acc, SetClause clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
            SetItem item = (SetItem)tuple2._2();
            PlannerQueryBuilder plannerQueryBuilder = builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.addMutatingPatterns((MutatingPattern)MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(acc.semanticTable(), item)));
            return plannerQueryBuilder;
        });
    }

    private PlannerQueryBuilder addCreateToLogicalPlanInput(PlannerQueryBuilder builder, Create clause) {
        ArrayBuffer nodes = new ArrayBuffer();
        ArrayBuffer relationships = new ArrayBuffer();
        scala.collection.mutable.Set seenPatternNodes = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        seenPatternNodes.$plus$plus$eq(builder.allSeenPatternNodes());
        clause.pattern().patternParts().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClauseConverters$.$anonfun$addCreateToLogicalPlanInput$1(nodes, seenPatternNodes, relationships, clause, x0$1);
            return BoxedUnit.UNIT;
        });
        return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$11 -> x$11.addMutatingPatterns((MutatingPattern)new CreatePattern((Seq)nodes, (Seq)relationships)));
    }

    private scala.collection.immutable.IndexedSeq<CreateNode> dedup(Vector<CreateNode> nodePatterns) {
        scala.collection.mutable.Set seen = Set$.MODULE$.empty();
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        nodePatterns.foreach((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$dedup$1(seen, result, pattern)));
        return result.toIndexedSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Vector<CreateNode>, Vector<CreateRelationship>> allCreatePatterns(PatternElement element) {
        boolean bl = false;
        NodePattern nodePattern = null;
        boolean bl2 = false;
        RelationshipChain relationshipChain = null;
        PatternElement patternElement = element;
        if (patternElement instanceof NodePattern) {
            bl = true;
            nodePattern = (NodePattern)patternElement;
            Option option = nodePattern.variable();
            if (None$.MODULE$.equals(option)) {
                throw new InternalException("All nodes must be named at this instance");
            }
        }
        if (bl) {
            Option option = nodePattern.variable();
            Seq labels = nodePattern.labels();
            Option props = nodePattern.properties();
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalVariable variable = (LogicalVariable)some.value();
                return new Tuple2((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode(variable.name(), labels, props)})), (Object)package$.MODULE$.Vector().empty());
            }
        }
        if (patternElement instanceof RelationshipChain) {
            bl2 = true;
            relationshipChain = (RelationshipChain)patternElement;
            PatternElement leftNode = relationshipChain.element();
            RelationshipPattern rel = relationshipChain.relationship();
            NodePattern rightNode = relationshipChain.rightNode();
            if (leftNode instanceof NodePattern) {
                NodePattern nodePattern2 = (NodePattern)leftNode;
                String leftIdName = ((LogicalVariable)nodePattern2.variable().get()).name();
                String rightIdName = ((LogicalVariable)rightNode.variable().get()).name();
                RelTypeName relType = (RelTypeName)rel.types().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new InternalException("Expected single relationship type");
                });
                return new Tuple2((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode(leftIdName, nodePattern2.labels(), nodePattern2.properties()), new CreateNode(rightIdName, rightNode.labels(), rightNode.properties())})), (Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateRelationship[]{new CreateRelationship(((LogicalVariable)rel.variable().get()).name(), leftIdName, relType, rightIdName, rel.direction(), rel.properties())})));
            }
        }
        if (!bl2) throw new MatchError((Object)patternElement);
        PatternElement left = relationshipChain.element();
        RelationshipPattern rel = relationshipChain.relationship();
        NodePattern rightNode = relationshipChain.rightNode();
        Tuple2<Vector<CreateNode>, Vector<CreateRelationship>> tuple2 = this.allCreatePatterns(left);
        if (tuple2 == null) throw new MatchError(tuple2);
        Vector nodes = (Vector)tuple2._1();
        Vector rels = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nodes, (Object)rels);
        Tuple2 tuple23 = tuple22;
        Vector nodes2 = (Vector)tuple23._1();
        Vector rels2 = (Vector)tuple23._2();
        String rightIdName = ((LogicalVariable)rightNode.variable().get()).name();
        return new Tuple2(nodes2.$colon$plus((Object)new CreateNode(rightIdName, rightNode.labels(), rightNode.properties()), Vector$.MODULE$.canBuildFrom()), rels2.$colon$plus((Object)new CreateRelationship(((LogicalVariable)rel.variable().get()).name(), ((CreateNode)nodes2.last()).idName(), (RelTypeName)rel.types().head(), rightIdName, rel.direction(), rel.properties()), Vector$.MODULE$.canBuildFrom()));
    }

    private PlannerQueryBuilder addDeleteToLogicalPlanInput(PlannerQueryBuilder acc, Delete clause) {
        return acc.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$13 -> x$13.addMutatingPatterns((Seq)clause.expressions().map((Function1 & Serializable & scala.Serializable)x$14 -> new DeleteExpression(x$14, clause.forced()), Seq$.MODULE$.canBuildFrom())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq<ReturnItem> asReturnItems(QueryGraph current, ReturnItems returnItems) {
        ReturnItems returnItems2 = returnItems;
        if (returnItems2 != null) {
            boolean star = returnItems2.includeExisting();
            Seq items = returnItems2.items();
            if (star) {
                return (Seq)QueryProjection$.MODULE$.forIds(current.allCoveredIds()).$plus$plus((GenTraversableOnce)items, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }
        if (returnItems2 == null) return (Seq)Seq$.MODULE$.empty();
        Seq items = returnItems2.items();
        return items;
    }

    private PlannerQueryBuilder addMatchToLogicalPlanInput(PlannerQueryBuilder acc, Match clause) {
        PatternConverters.DestructResult patternContent = PatternConverters.PatternDestructor$.MODULE$.destructed$extension(PatternConverters$.MODULE$.PatternDestructor(clause.pattern()));
        Selections selections = this.asSelections((Option<Where>)clause.where());
        return clause.optional() ? acc.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)qg -> {
            Selections x$1 = selections;
            scala.collection.immutable.Set x$2 = patternContent.nodeIds().toSet();
            scala.collection.immutable.Set x$3 = patternContent.rels().toSet();
            scala.collection.immutable.Set x$4 = clause.hints().toSet();
            scala.collection.immutable.Set x$5 = patternContent.shortestPaths().toSet();
            scala.collection.immutable.Set x$6 = QueryGraph$.MODULE$.apply$default$3();
            IndexedSeq x$7 = QueryGraph$.MODULE$.apply$default$5();
            IndexedSeq x$8 = QueryGraph$.MODULE$.apply$default$8();
            return qg.withAddedOptionalMatch(new QueryGraph(x$3, x$2, x$6, x$1, x$7, x$4, x$5, x$8));
        }) : acc.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)qg -> qg.addSelections(selections).addPatternNodes(patternContent.nodeIds()).addPatternRelationships(patternContent.rels()).addHints((GenTraversableOnce)clause.hints()).addShortestPaths(patternContent.shortestPaths()));
    }

    private PlannerQueryBuilder addCallSubqueryToLogicalPlanInput(PlannerQueryBuilder acc, SubQuery clause) {
        QueryPart subquery = clause.part();
        PlannerQueryPart callSubquery = StatementConverters$.MODULE$.toPlannerQueryPart(subquery, acc.semanticTable());
        return acc.withCallSubquery(callSubquery, subquery.isCorrelated());
    }

    private Map<PropertyKeyName, Expression> toPropertyMap(Option<Expression> expr) {
        Some some;
        Expression expression;
        Map map;
        Option<Expression> option = expr;
        if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else if (option instanceof Some && (expression = (Expression)(some = (Some)option).value()) instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)expression;
            Seq items = mapExpression.items();
            map = items.toMap(Predef$.MODULE$.$conforms());
        } else {
            throw new InternalException(new StringBuilder(28).append("Expected MapExpression, got ").append(option).toString());
        }
        return map;
    }

    private Seq<Expression> toPropertySelection(LogicalVariable identifier, Map<PropertyKeyName, Expression> map) {
        return ((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PropertyKeyName k = (PropertyKeyName)tuple2._1();
            Expression e = (Expression)tuple2._2();
            In in = new In((Expression)new Property((Expression)identifier, k, k.position()), (Expression)new ListLiteral((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{e})), e.position()), identifier.position());
            return in;
        }, Iterable$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetMutatingPattern org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(SemanticTable semanticTable, SetItem setItem) {
        boolean bl = false;
        SetPropertyItem setPropertyItem = null;
        boolean bl2 = false;
        SetExactPropertiesFromMapItem setExactPropertiesFromMapItem = null;
        boolean bl3 = false;
        SetIncludingPropertiesFromMapItem setIncludingPropertiesFromMapItem = null;
        SetItem setItem2 = setItem;
        if (setItem2 instanceof SetLabelItem) {
            SetLabelItem setLabelItem = (SetLabelItem)setItem2;
            Variable id = setLabelItem.variable();
            Seq labels = setLabelItem.labels();
            return new SetLabelPattern(id.name(), labels);
        }
        if (setItem2 instanceof SetPropertyItem) {
            bl = true;
            setPropertyItem = (SetPropertyItem)setItem2;
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Variable variable;
                Property property = (Property)logicalProperty;
                Expression node = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (node instanceof Variable && semanticTable.isNode((LogicalVariable)(variable = (Variable)node))) {
                    return new SetNodePropertyPattern(variable.name(), propertyKey, expr);
                }
            }
        }
        if (bl) {
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Variable variable;
                Property property = (Property)logicalProperty;
                Expression rel = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (rel instanceof Variable && semanticTable.isRelationship((LogicalVariable)(variable = (Variable)rel))) {
                    return new SetRelationshipPropertyPattern(variable.name(), propertyKey, expr);
                }
            }
        }
        if (bl) {
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Property property = (Property)logicalProperty;
                Expression entityExpr = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                return new SetPropertyPattern(entityExpr, propertyKey, expr);
            }
        }
        if (setItem2 instanceof SetExactPropertiesFromMapItem) {
            bl2 = true;
            setExactPropertiesFromMapItem = (SetExactPropertiesFromMapItem)setItem2;
            Variable node = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.isNode((LogicalVariable)node)) {
                return new SetNodePropertiesFromMapPattern(node.name(), expression, true);
            }
        }
        if (bl2) {
            Variable rel = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.isRelationship((LogicalVariable)rel)) {
                return new SetRelationshipPropertiesFromMapPattern(rel.name(), expression, true);
            }
        }
        if (bl2) {
            Variable vr = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            return new SetPropertiesFromMapPattern((Expression)vr, expression, true);
        }
        if (setItem2 instanceof SetIncludingPropertiesFromMapItem) {
            bl3 = true;
            setIncludingPropertiesFromMapItem = (SetIncludingPropertiesFromMapItem)setItem2;
            Variable node = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.isNode((LogicalVariable)node)) {
                return new SetNodePropertiesFromMapPattern(node.name(), expression, false);
            }
        }
        if (bl3) {
            Variable rel = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.isRelationship((LogicalVariable)rel)) {
                return new SetRelationshipPropertiesFromMapPattern(rel.name(), expression, false);
            }
        }
        if (!bl3) throw new MatchError((Object)setItem2);
        Variable vr = setIncludingPropertiesFromMapItem.variable();
        Expression expression = setIncludingPropertiesFromMapItem.expression();
        return new SetPropertiesFromMapPattern((Expression)vr, expression, false);
    }

    private PlannerQueryBuilder addMergeToLogicalPlanInput(PlannerQueryBuilder builder, Merge clause) {
        Seq onCreate = (Seq)((GenericTraversableTemplate)clause.actions().collect((PartialFunction)new scala.Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof OnCreate) {
                    OnCreate onCreate = (OnCreate)A1;
                    SetClause setClause = onCreate.action();
                    object = setClause.items().map((Function1 & Serializable & scala.Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem), Seq$.MODULE$.canBuildFrom());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(MergeAction x1) {
                MergeAction mergeAction = x1;
                boolean bl = mergeAction instanceof OnCreate;
                return bl;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$3 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        Seq onMatch = (Seq)((GenericTraversableTemplate)clause.actions().collect((PartialFunction)new scala.Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof OnMatch) {
                    OnMatch onMatch = (OnMatch)A1;
                    SetClause setClause = onMatch.action();
                    object = setClause.items().map((Function1 & Serializable & scala.Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem), Seq$.MODULE$.canBuildFrom());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(MergeAction x2) {
                MergeAction mergeAction = x2;
                boolean bl = mergeAction instanceof OnMatch;
                return bl;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$4 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (PlannerQueryBuilder)clause.pattern().patternParts().foldLeft((Object)builder, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                EveryPath everyPath;
                PatternElement patternElement;
                PlannerQueryBuilder acc = (PlannerQueryBuilder)tuple2._1();
                PatternPart patternPart = (PatternPart)tuple2._2();
                if (patternPart instanceof EveryPath && (patternElement = (everyPath = (EveryPath)patternPart).element()) instanceof NodePattern) {
                    NodePattern nodePattern = (NodePattern)patternElement;
                    Option option = nodePattern.variable();
                    Seq labels = nodePattern.labels();
                    Option props = nodePattern.properties();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LogicalVariable id = (LogicalVariable)some.value();
                        scala.collection.immutable.Set<String> currentlyAvailableVariables = builder.currentlyAvailableVariables();
                        Seq labelPredicates = (Seq)labels.map((Function1 & Serializable & scala.Serializable)l -> new HasLabels((Expression)id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{l})), id.position()), Seq$.MODULE$.canBuildFrom());
                        Seq<Expression> propertyPredicates = MODULE$.toPropertySelection(id, MODULE$.toPropertyMap((Option<Expression>)props));
                        CreateNode createNodePattern = new CreateNode(id.name(), labels, props);
                        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.name()}));
                        Selections x$2 = Selections$.MODULE$.from((Traversable)labelPredicates.$plus$plus(propertyPredicates, Seq$.MODULE$.canBuildFrom()));
                        scala.collection.immutable.Set<String> x$3 = currentlyAvailableVariables;
                        scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$1();
                        IndexedSeq x$5 = QueryGraph$.MODULE$.apply$default$5();
                        scala.collection.immutable.Set x$6 = QueryGraph$.MODULE$.apply$default$6();
                        scala.collection.immutable.Set x$7 = QueryGraph$.MODULE$.apply$default$7();
                        IndexedSeq x$8 = QueryGraph$.MODULE$.apply$default$8();
                        QueryGraph matchGraph = new QueryGraph(x$4, x$1, x$3, x$2, x$5, x$6, x$7, x$8);
                        QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(matchGraph.argumentIds()).addMutatingPatterns((MutatingPattern)new MergeNodePattern(createNodePattern, matchGraph, onCreate, onMatch));
                        return acc.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)MODULE$.asQueryProjection(false, (Seq<ReturnItem>)QueryProjection$.MODULE$.forIds(queryGraph.allCoveredIds()))).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
                    }
                }
            }
            if (tuple2 == null) throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(tuple2._2()).toString());
            PlannerQueryBuilder acc = (PlannerQueryBuilder)tuple2._1();
            PatternPart patternPart = (PatternPart)tuple2._2();
            if (!(patternPart instanceof EveryPath)) throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(tuple2._2()).toString());
            EveryPath everyPath = (EveryPath)patternPart;
            PatternElement pattern2 = everyPath.element();
            if (!(pattern2 instanceof RelationshipChain)) throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(tuple2._2()).toString());
            RelationshipChain relationshipChain = (RelationshipChain)pattern2;
            Tuple2<Vector<CreateNode>, Vector<CreateRelationship>> tuple22 = MODULE$.allCreatePatterns((PatternElement)relationshipChain);
            if (tuple22 == null) throw new MatchError(tuple22);
            Vector nodes = (Vector)tuple22._1();
            Vector rels = (Vector)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)nodes, (Object)rels);
            Tuple2 tuple24 = tuple23;
            Vector nodes2 = (Vector)tuple24._1();
            Vector rels2 = (Vector)tuple24._2();
            scala.collection.immutable.IndexedSeq<CreateNode> dedupedNodes = MODULE$.dedup((Vector<CreateNode>)nodes2);
            Set<String> seenPatternNodes = acc.allSeenPatternNodes();
            scala.collection.immutable.IndexedSeq nodesToCreate = (scala.collection.immutable.IndexedSeq)dedupedNodes.filterNot((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)seenPatternNodes.apply((Object)pattern.idName())));
            scala.collection.immutable.Set nodesCreatedBefore = ((TraversableOnce)dedupedNodes.filter((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)seenPatternNodes.apply((Object)pattern.idName())))).toSet();
            nodesCreatedBefore.collectFirst((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends CreateNode, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1.labels().nonEmpty() || A1.properties().nonEmpty()) {
                        throw new SyntaxException(new StringBuilder(101).append("Can't create node `").append(A1.idName()).append("` with labels or properties here. The variable is already declared in this context").toString());
                    }
                    Object object = function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(CreateNode x3) {
                    CreateNode createNode = x3;
                    boolean bl = createNode.labels().nonEmpty() || createNode.properties().nonEmpty();
                    return bl;
                }
            });
            InputPosition pos = relationshipChain.position();
            Selections selections = MODULE$.asSelections((Option<Where>)clause.where());
            Vector hasLabels = (Vector)nodes2.flatMap((Function1 & Serializable & scala.Serializable)n -> (Seq)n.labels().map((Function1 & Serializable & scala.Serializable)l -> new HasLabels((Expression)new Variable(n.idName(), pos), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{l})), pos), Seq$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            Vector hasProps = (Vector)((Vector)nodes2.flatMap((Function1 & Serializable & scala.Serializable)n -> MODULE$.toPropertySelection((LogicalVariable)new Variable(n.idName(), pos), MODULE$.toPropertyMap((Option<Expression>)n.properties())), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)rels2.flatMap((Function1 & Serializable & scala.Serializable)r -> MODULE$.toPropertySelection((LogicalVariable)new Variable(r.idName(), pos), MODULE$.toPropertyMap((Option<Expression>)r.properties())), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            scala.collection.immutable.Set x$9 = ((TraversableOnce)nodes2.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.idName(), Vector$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set x$10 = ((TraversableOnce)rels2.map((Function1 & Serializable & scala.Serializable)r -> new PatternRelationship(r.idName(), new Tuple2((Object)r.leftNode(), (Object)r.rightNode()), r.direction(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelTypeName[]{r.relType()})), (PatternLength)SimplePatternLength$.MODULE$), Vector$.MODULE$.canBuildFrom())).toSet();
            Selections x$11 = selections.$plus$plus(Selections$.MODULE$.from((Traversable)hasLabels.$plus$plus((GenTraversableOnce)hasProps, Vector$.MODULE$.canBuildFrom())));
            scala.collection.immutable.Set x$12 = (scala.collection.immutable.Set)builder.currentlyAvailableVariables().$plus$plus((GenTraversableOnce)nodesCreatedBefore.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.idName(), scala.collection.immutable.Set$.MODULE$.canBuildFrom()));
            IndexedSeq x$13 = QueryGraph$.MODULE$.apply$default$5();
            scala.collection.immutable.Set x$14 = QueryGraph$.MODULE$.apply$default$6();
            scala.collection.immutable.Set x$15 = QueryGraph$.MODULE$.apply$default$7();
            IndexedSeq x$162 = QueryGraph$.MODULE$.apply$default$8();
            QueryGraph matchGraph = new QueryGraph(x$10, x$9, x$12, x$11, x$13, x$14, x$15, x$162);
            QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(matchGraph.argumentIds()).addMutatingPatterns((MutatingPattern)new MergeRelationshipPattern((Seq)nodesToCreate, (Seq)rels2, matchGraph, onCreate, onMatch));
            return acc.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)MODULE$.asQueryProjection(false, (Seq<ReturnItem>)QueryProjection$.MODULE$.forIds(queryGraph.allCoveredIds()))).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlannerQueryBuilder addWithToLogicalPlanInput(PlannerQueryBuilder builder, With clause) {
        With with = clause;
        if (with != null) {
            boolean bl = with.distinct();
            ReturnItems ri = with.returnItems();
            Option option = with.orderBy();
            Option option2 = with.skip();
            Option option3 = with.limit();
            Option where = with.where();
            if (!bl && None$.MODULE$.equals(option) && None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && !builder.currentQueryGraph().hasOptionalPatterns() && !builder.currentQueryGraph().containsUpdates() && ri.items().forall((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addWithToLogicalPlanInput$1(item))) && builder.currentQueryGraph().shortestPathPatterns().isEmpty() && ri.items().forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addWithToLogicalPlanInput$2(x0$1))) && builder.readOnly()) {
                Selections selections = this.asSelections((Option<Where>)where);
                return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$18 -> x$18.addSelections(selections));
            }
        }
        if (with == null) throw new InternalException(new StringBuilder(67).append("AST needs to be rewritten before it can be used for planning. Got: ").append(clause).toString());
        boolean distinct2 = with.distinct();
        ReturnItems projection2 = with.returnItems();
        Option orderBy = with.orderBy();
        Option skip = with.skip();
        Option limit = with.limit();
        Option where = with.where();
        Selections selections = this.asSelections((Option<Where>)where);
        Seq<ReturnItem> returnItems = this.asReturnItems(builder.currentQueryGraph(), projection2);
        QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withLimit(limit).withSkip(skip);
        QueryProjection queryProjection = this.asQueryProjection(distinct2, returnItems).withPagination(queryPagination).withSelection(selections);
        InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)queryProjection, (Option<OrderBy>)orderBy);
        return builder.withHorizon((QueryHorizon)queryProjection).withInterestingOrder(requiredOrder).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(new QueryGraph(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private PlannerQueryBuilder addUnwindToLogicalPlanInput(PlannerQueryBuilder builder, Unwind clause) {
        return builder.withHorizon((QueryHorizon)new UnwindProjection(clause.variable().name(), clause.expression())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addCallToLogicalPlanInput(PlannerQueryBuilder builder, ResolvedCall call) {
        return builder.withHorizon(new ProcedureCallProjection(call)).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addForeachToLogicalPlanInput(PlannerQueryBuilder builder, Foreach clause) {
        scala.collection.immutable.Set<String> currentlyAvailableVariables = builder.currentlyAvailableVariables();
        scala.collection.immutable.Set setOfNodeVariables = builder.semanticTable().isNode(clause.variable().name()) ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clause.variable().name()})) : Predef$.MODULE$.Set().empty();
        Variable foreachVariable = clause.variable();
        QueryProjection projectionToInnerUpdates = this.asQueryProjection(false, (Seq<ReturnItem>)QueryProjection$.MODULE$.forIds((scala.collection.immutable.Set)currentlyAvailableVariables.$plus((Object)foreachVariable.name())));
        PlannerQueryBuilder innerBuilder = new PlannerQueryBuilder((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty(), builder.semanticTable()).amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$19 -> {
            String string = foreachVariable.name();
            return x$19.addPatternNodes((Seq)builder.allSeenPatternNodes().$plus$plus((GenTraversableOnce)setOfNodeVariables).toIndexedSeq()).addArgumentIds((Seq)currentlyAvailableVariables.toIndexedSeq().$plus$colon((Object)string, IndexedSeq$.MODULE$.canBuildFrom()));
        }).withHorizon((QueryHorizon)projectionToInnerUpdates);
        SinglePlannerQuery innerPlannerQuery = ((PlannerQueryBuilder)StatementConverters$.MODULE$.flattenCreates((Seq<Clause>)clause.updates()).foldLeft((Object)innerBuilder, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PlannerQueryBuilder acc = (PlannerQueryBuilder)tuple2._1();
            Clause innerClause = (Clause)tuple2._2();
            PlannerQueryBuilder plannerQueryBuilder = MODULE$.addToLogicalPlanInput(acc, innerClause);
            return plannerQueryBuilder;
        })).build();
        ForeachPattern foreachPattern = new ForeachPattern(clause.variable().name(), clause.expression(), innerPlannerQuery);
        scala.collection.immutable.Set<String> x$1 = currentlyAvailableVariables;
        IndexedSeq x$2 = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ForeachPattern[]{foreachPattern}));
        scala.collection.immutable.Set x$3 = QueryGraph$.MODULE$.apply$default$1();
        scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$2();
        Selections x$5 = QueryGraph$.MODULE$.apply$default$4();
        IndexedSeq x$6 = QueryGraph$.MODULE$.apply$default$5();
        scala.collection.immutable.Set x$7 = QueryGraph$.MODULE$.apply$default$6();
        scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$7();
        QueryGraph foreachGraph = new QueryGraph(x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$2);
        return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(foreachGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private PlannerQueryBuilder addRemoveToLogicalPlanInput(PlannerQueryBuilder acc, Remove clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemoveLabelItem) {
                    RemoveLabelItem removeLabelItem = (RemoveLabelItem)removeItem;
                    LogicalVariable variable = removeLabelItem.variable();
                    Seq labelNames = removeLabelItem.labels();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$21 -> x$21.addMutatingPatterns((MutatingPattern)new RemoveLabelPattern(variable.name(), labelNames)));
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable2 = (Variable)variable;
                        if (acc.semanticTable().isNode((LogicalVariable)variable2)) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$22 -> x$22.addMutatingPatterns((MutatingPattern)new SetNodePropertyPattern(variable2.name(), propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable3 = (Variable)variable;
                        if (acc.semanticTable().isRelationship((LogicalVariable)variable3)) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$23 -> x$23.addMutatingPatterns((MutatingPattern)new SetRelationshipPropertyPattern(variable3.name(), propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable & scala.Serializable)x$24 -> x$24.addMutatingPatterns((MutatingPattern)new SetPropertyPattern(variable, propertyKey, (Expression)new Null(propertyKey.position()))));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            RemoveItem other = (RemoveItem)tuple2._2();
            throw new InternalException(new StringBuilder(41).append("REMOVE ").append(other).append(" not supported in cost planner yet").toString());
        });
    }

    private static final Map turnIntoMap$1(Seq x) {
        return ((TraversableOnce)x.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.expression()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$addCreateToLogicalPlanInput$1(ArrayBuffer nodes$1, scala.collection.mutable.Set seenPatternNodes$1, ArrayBuffer relationships$1, Create clause$1, PatternPart x0$1) {
        boolean bl = false;
        EveryPath everyPath = null;
        PatternPart patternPart = x0$1;
        if (patternPart instanceof EveryPath) {
            bl = true;
            everyPath = (EveryPath)patternPart;
            PatternElement patternElement = everyPath.element();
            if (patternElement instanceof NodePattern) {
                NodePattern nodePattern = (NodePattern)patternElement;
                Option option = nodePattern.variable();
                Seq labels = nodePattern.labels();
                Option props = nodePattern.properties();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogicalVariable id = (LogicalVariable)some.value();
                    nodes$1.$plus$eq((Object)new CreateNode(id.name(), labels, props));
                    seenPatternNodes$1.$plus$eq((Object)id.name());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(clause$1).toString());
        PatternElement pattern2 = everyPath.element();
        if (!(pattern2 instanceof RelationshipChain)) throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(clause$1).toString());
        RelationshipChain relationshipChain = (RelationshipChain)pattern2;
        Tuple2<Vector<CreateNode>, Vector<CreateRelationship>> tuple2 = MODULE$.allCreatePatterns((PatternElement)relationshipChain);
        if (tuple2 == null) throw new MatchError(tuple2);
        Vector currentNodes = (Vector)tuple2._1();
        Vector currentRelationships = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)currentNodes, (Object)currentRelationships);
        Tuple2 tuple23 = tuple22;
        Vector currentNodes2 = (Vector)tuple23._1();
        Vector currentRelationships2 = (Vector)tuple23._2();
        scala.collection.immutable.IndexedSeq<CreateNode> dedupedNodes = MODULE$.dedup((Vector<CreateNode>)currentNodes2);
        Tuple2 tuple24 = dedupedNodes.partition((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)seenPatternNodes$1.apply((Object)pattern.idName())));
        if (tuple24 == null) throw new MatchError((Object)tuple24);
        scala.collection.immutable.IndexedSeq nodesCreatedBefore = (scala.collection.immutable.IndexedSeq)tuple24._1();
        scala.collection.immutable.IndexedSeq nodesToCreate = (scala.collection.immutable.IndexedSeq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)nodesCreatedBefore, (Object)nodesToCreate);
        Tuple2 tuple26 = tuple25;
        scala.collection.immutable.IndexedSeq nodesCreatedBefore2 = (scala.collection.immutable.IndexedSeq)tuple26._1();
        scala.collection.immutable.IndexedSeq nodesToCreate2 = (scala.collection.immutable.IndexedSeq)tuple26._2();
        nodesCreatedBefore2.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends CreateNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.labels().nonEmpty() || A1.properties().nonEmpty()) {
                    throw new SyntaxException(new StringBuilder(101).append("Can't create node `").append(A1.idName()).append("` with labels or properties here. The variable is already declared in this context").toString());
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CreateNode x1) {
                CreateNode createNode = x1;
                boolean bl = createNode.labels().nonEmpty() || createNode.properties().nonEmpty();
                return bl;
            }
        });
        nodes$1.$plus$plus$eq((TraversableOnce)nodesToCreate2);
        seenPatternNodes$1.$plus$plus$eq((TraversableOnce)nodesToCreate2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.idName(), IndexedSeq$.MODULE$.canBuildFrom()));
        relationships$1.$plus$plus$eq((TraversableOnce)currentRelationships2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$dedup$1(scala.collection.mutable.Set seen$1, ListBuffer result$1, CreateNode pattern) {
        if (!seen$1.apply((Object)pattern.idName())) {
            result$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{pattern}));
        } else if (pattern.labels().nonEmpty() || pattern.properties().nonEmpty()) {
            throw new SyntaxException(new StringBuilder(101).append("Can't create node `").append(pattern.idName()).append("` with labels or properties here. The variable is already declared in this context").toString());
        }
        return seen$1.add((Object)pattern.idName());
    }

    public static final /* synthetic */ boolean $anonfun$addWithToLogicalPlanInput$1(ReturnItem item) {
        return !containsAggregate$.MODULE$.apply(item.expression());
    }

    public static final /* synthetic */ boolean $anonfun$addWithToLogicalPlanInput$2(ReturnItem x0$1) {
        ReturnItem returnItem = x0$1;
        if (!(returnItem instanceof AliasedReturnItem)) {
            throw new InternalException("This should have been rewritten to an AliasedReturnItem.");
        }
        AliasedReturnItem aliasedReturnItem = (AliasedReturnItem)returnItem;
        Expression expression = aliasedReturnItem.expression();
        LogicalVariable logicalVariable = aliasedReturnItem.variable();
        boolean bl = !(expression != null ? !expression.equals(logicalVariable) : logicalVariable != null);
        return bl;
    }

    private ClauseConverters$() {
        MODULE$ = this;
    }
}

