/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsDistanceSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsIdSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsPropertyScannable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsPropertySeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsStringRangeSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsValueRangeSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.IdSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.InequalityRangeSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PointDistanceSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PrefixRangeSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PropertySeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.Scannable;
import org.neo4j.cypher.internal.expressions.AssertIsNode;
import org.neo4j.cypher.internal.expressions.Contains;
import org.neo4j.cypher.internal.expressions.EndsWith;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.False;
import org.neo4j.cypher.internal.expressions.GreaterThan;
import org.neo4j.cypher.internal.expressions.GreaterThanOrEqual;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LessThan;
import org.neo4j.cypher.internal.expressions.LessThanOrEqual;
import org.neo4j.cypher.internal.expressions.Not;
import org.neo4j.cypher.internal.expressions.Ors;
import org.neo4j.cypher.internal.expressions.PartialPredicate;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.logical.plans.PrefixRange;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001\u0002\u0013&\u0001ZB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u000b\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005T\u0001\tE\t\u0015!\u0003P\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\t9\u000e\u0001C\u0005\u00033Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018!I!1\u0006\u0001\u0002\u0002\u0013\u0005!Q\u0006\u0005\n\u0005g\u0001\u0011\u0013!C\u0001\u0005kA\u0011Ba\u0013\u0001#\u0003%\tA!\u0014\t\u0013\tE\u0003!!A\u0005B\tM\u0003\"\u0003B2\u0001\u0005\u0005I\u0011\u0001B3\u0011%\u00119\u0007AA\u0001\n\u0003\u0011I\u0007C\u0005\u0003v\u0001\t\t\u0011\"\u0011\u0003x!I!Q\u0011\u0001\u0002\u0002\u0013\u0005!q\u0011\u0005\n\u0005\u0017\u0003\u0011\u0011!C!\u0005\u001bC\u0011Ba$\u0001\u0003\u0003%\tE!%\t\u0013\tM\u0005!!A\u0005B\tUu!\u0003BMK\u0005\u0005\t\u0012\u0001BN\r!!S%!A\t\u0002\tu\u0005B\u0002+\u001f\t\u0003\u0011Y\u000bC\u0005\u0003\u0010z\t\t\u0011\"\u0012\u0003\u0012\"A\u0011LHA\u0001\n\u0003\u0013i\u000bC\u0005\u00034z\t\t\u0011\"!\u00036\"I!1\u0019\u0010\u0002\u0002\u0013%!Q\u0019\u0002 \u000bb\u0004(/Z:tS>t7+\u001a7fGRLg/\u001b;z\u0007\u0006d7-\u001e7bi>\u0014(B\u0001\u0014(\u0003-\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=\u000b\u0005!J\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003U-\nq\u0001\u001d7b]:,'O\u0003\u0002-[\u0005A1m\\7qS2,'O\u0003\u0002/_\u0005A\u0011N\u001c;fe:\fGN\u0003\u00021c\u000511-\u001f9iKJT!AM\u001a\u0002\u000b9,w\u000e\u000e6\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001c>\u0001B\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"\u0001\u000f \n\u0005}J$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u0005K!AQ\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015\u0003\"A\u0012&\u000e\u0003\u001dS!\u0001S%\u0002\u0007M\u0004\u0018N\u0003\u0002+[%\u00111j\u0012\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\u000611\u000f^1ug\u0002\n\u0001bY8nE&tWM]\u000b\u0002\u001fB\u0011\u0001+U\u0007\u0002K%\u0011!+\n\u0002\u0014'\u0016dWm\u0019;jm&$\u0018pQ8nE&tWM]\u0001\nG>l'-\u001b8fe\u0002\na\u0001P5oSRtDc\u0001,X1B\u0011\u0001\u000b\u0001\u0005\u0006\u0007\u0016\u0001\r!\u0012\u0005\u0006\u001b\u0016\u0001\raT\u0001\u0006CB\u0004H.\u001f\u000b\u000672$\u0018Q\u0004\u000b\u00039\n\u0004\"!\u00181\u000e\u0003yS!aX\u0017\u0002\tU$\u0018\u000e\\\u0005\u0003Cz\u00131bU3mK\u000e$\u0018N^5us\")1M\u0002a\u0002I\u0006i1/Z7b]RL7\rV1cY\u0016\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u0013M,W.\u00198uS\u000e\u001c(BA5.\u0003\r\t7\u000f^\u0005\u0003W\u001a\u0014QbU3nC:$\u0018n\u0019+bE2,\u0007\"B7\u0007\u0001\u0004q\u0017aA3yaB\u0011qN]\u0007\u0002a*\u0011\u0011/L\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002ta\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000bU4\u0001\u0019\u0001<\u0002\u00131\f'-\u001a7J]\u001a|\u0007cA<\u0002\u00189\u0019\u00010a\u0005\u000f\u0007e\f\tBD\u0002{\u0003\u001fq1a_A\u0007\u001d\ra\u00181\u0002\b\u0004{\u0006%ab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002k\u00051AH]8pizJ\u0011\u0001N\u0005\u0003eMJ!\u0001M\u0019\n\u00059z\u0013B\u0001\u0017.\u0013\tQ3&\u0003\u0002)S%\u0019\u0011QC\u0014\u0002\u000f5+GO]5dg&!\u0011\u0011DA\u000e\u0005%a\u0015MY3m\u0013:4wNC\u0002\u0002\u0016\u001dBq!a\b\u0007\u0001\u0004\t\t#A\u0006sK2$\u0016\u0010]3J]\u001a|\u0007cA<\u0002$%!\u0011QEA\u000e\u0005-\u0011V\r\u001c+za\u0016LeNZ8\u0002!\u0005\u0014XMU3mCRLwN\\:iSB\u001cH\u0003CA\u0016\u0003c\t\u0019$!\u0010\u0011\u0007a\ni#C\u0002\u00020e\u0012qAQ8pY\u0016\fg\u000eC\u0003d\u000f\u0001\u0007A\rC\u0004\u00026\u001d\u0001\r!a\u000e\u0002\u00071D7\u000fE\u0002p\u0003sI1!a\u000fq\u0005!1\u0016M]5bE2,\u0007bBA \u000f\u0001\u0007\u0011qG\u0001\u0004e\"\u001c\u0018\u0001H2bY\u000e,H.\u0019;f'\u0016dWm\u0019;jm&$\u0018PR8s\u0019\u0006\u0014W\r\u001c\u000b\u00049\u0006\u0015\u0003bBA$\u0011\u0001\u0007\u0011\u0011J\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0006q\u0005-\u0013qJ\u0005\u0004\u0003\u001bJ$AB(qi&|g\u000eE\u0002^\u0003#J1!a\u0015_\u0005\u001da\u0015MY3m\u0013\u0012\f\u0001fY1mGVd\u0017\r^3TK2,7\r^5wSRLhi\u001c:Qe>\u0004XM\u001d;z\u000bbL7\u000f^3oG\u0016$\"\"!\u0017\u0002^\u0005E\u00141OA;)\ra\u00161\f\u0005\u0006G&\u0001\u001d\u0001\u001a\u0005\b\u0003?J\u0001\u0019AA1\u0003!1\u0018M]5bE2,\u0007\u0003BA2\u0003WrA!!\u001a\u0002hA\u0011q0O\u0005\u0004\u0003SJ\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002jeBQ!^\u0005A\u0002YDq!a\b\n\u0001\u0004\t\t\u0003C\u0004\u0002x%\u0001\r!!\u001f\u0002\u0017A\u0014x\u000e]3sif\\U-\u001f\t\u0004_\u0006m\u0014bAA?a\ny\u0001K]8qKJ$\u0018pS3z\u001d\u0006lW-A\u0012j]\u0012,\u0007\u0010\u0015:pa\u0016\u0014H/_#ySN$8oU3mK\u000e$\u0018N^5uS\u0016\u001chi\u001c:\u0015\u0015\u0005\r\u0015\u0011TAN\u0003;\u000by\n\u0006\u0003\u0002\u0006\u0006]\u0005#BAD\u0003#cf\u0002BAE\u0003\u001bs1a`AF\u0013\u0005Q\u0014bAAHs\u00059\u0001/Y2lC\u001e,\u0017\u0002BAJ\u0003+\u00131aU3r\u0015\r\ty)\u000f\u0005\u0006G*\u0001\u001d\u0001\u001a\u0005\b\u0003?R\u0001\u0019AA1\u0011\u0015)(\u00021\u0001w\u0011\u001d\tyB\u0003a\u0001\u0003CAq!a\u001e\u000b\u0001\u0004\tI(A\u0014dC2\u001cW\u000f\\1uKN+G.Z2uSZLG/\u001f$peB\u0013x\u000e]3sif,\u0015/^1mSRLH\u0003DAS\u0003S\u000bY+a.\u0002:\u0006mFc\u0001/\u0002(\")1m\u0003a\u0002I\"9\u0011qL\u0006A\u0002\u0005\u0005\u0004bBAW\u0017\u0001\u0007\u0011qV\u0001\tg&TX\rS5oiB)\u0001(a\u0013\u00022B\u0019\u0001(a-\n\u0007\u0005U\u0016HA\u0002J]RDQ!^\u0006A\u0002YDq!a\b\f\u0001\u0004\t\t\u0003C\u0004\u0002x-\u0001\r!!\u001f\u0002G%tG-\u001a=TK2,7\r^5wSRLhi\u001c:Qe>\u0004XM\u001d;z\u000bF,\u0018\r\\5usR1\u0011\u0011YAb\u0003\u001b\u0004B\u0001OA&9\"9\u0011Q\u0019\u0007A\u0002\u0005\u001d\u0017A\u00033fg\u000e\u0014\u0018\u000e\u001d;peB\u0019a)!3\n\u0007\u0005-wIA\bJ]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0011\u001d\ty\r\u0004a\u0001\u0003c\u000bAa]5{K\u0006)C-\u001a4bk2$8+\u001a7fGRLg/\u001b;z\r>\u0014\bK]8qKJ$\u00180R9vC2LG/\u001f\u000b\u0005\u0003\u0003\f)\u000eC\u0004\u0002P6\u0001\r!!-\u0002=M,G.Z2uSZLG/\u001f$peB\u0013x\u000e]3sif,\u0015/^1mSRLH\u0003CAa\u00037\fy.a9\t\u000f\u0005ug\u00021\u0001\u0002B\u0006\u0019\u0002O]8qKJ$\u0018pU3mK\u000e$\u0018N^5us\"9\u0011\u0011\u001d\bA\u0002\u0005\u0005\u0017AF;oSF,XMV1mk\u0016\u001cV\r\\3di&4\u0018\u000e^=\t\u000f\u0005=g\u00021\u0001\u00022\u0006I3-\u00197dk2\fG/Z*fY\u0016\u001cG/\u001b<jif4uN\u001d,bYV,'+\u00198hKN+Wm[1cY\u0016$\u0002\"!;\u0002n\u0006u\u0018q \u000b\u00049\u0006-\b\"B2\u0010\u0001\b!\u0007bBAx\u001f\u0001\u0007\u0011\u0011_\u0001\tg\u0016,7.\u00192mKB!\u00111_A}\u001b\t\t)PC\u0002\u0002x\u001e\nQ\u0001\u001d7b]NLA!a?\u0002v\n9\u0012J\\3rk\u0006d\u0017\u000e^=SC:<WmU3fW\u0006\u0014G.\u001a\u0005\u0006k>\u0001\rA\u001e\u0005\b\u0003?y\u0001\u0019AA\u0011\u00031\u001a\u0017\r\\2vY\u0006$XmU3mK\u000e$\u0018N^5us\u001a{'\u000fU8j]R$\u0015n\u001d;b]\u000e,7+Z3lC\ndW\r\u0006\u0005\u0003\u0006\t%!\u0011\u0003B\n)\ra&q\u0001\u0005\u0006GB\u0001\u001d\u0001\u001a\u0005\b\u0003_\u0004\u0002\u0019\u0001B\u0006!\u0011\t\u0019P!\u0004\n\t\t=\u0011Q\u001f\u0002\u0016!>Lg\u000e\u001e#jgR\fgnY3TK\u0016\\\u0017M\u00197f\u0011\u0015)\b\u00031\u0001w\u0011\u001d\ty\u0002\u0005a\u0001\u0003C\t\u0001fY1mGVd\u0017\r^3TK2,7\r^5wSRLhi\u001c:Tk\n\u001cHO]5oON\u000b'oZ1cY\u0016$BB!\u0007\u0003\u001e\t}!\u0011\u0005B\u0012\u0005K!2\u0001\u0018B\u000e\u0011\u0015\u0019\u0017\u0003q\u0001e\u0011\u001d\ty&\u0005a\u0001\u0003CBQ!^\tA\u0002YDq!a\b\u0012\u0001\u0004\t\t\u0003C\u0004\u0002xE\u0001\r!!\u001f\t\u000f\t\u001d\u0012\u00031\u0001\u0003*\u0005YQ.Y=cKN#(/\u001b8h!\u0015A\u00141JA1\u0003\u0011\u0019w\u000e]=\u0015\u000bY\u0013yC!\r\t\u000f\r\u0013\u0002\u0013!a\u0001\u000b\"9QJ\u0005I\u0001\u0002\u0004y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005oQ3!\u0012B\u001dW\t\u0011Y\u0004\u0005\u0003\u0003>\t\u001dSB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B#s\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%#q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fR3a\u0014B\u001d\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u000b\t\u0005\u0005/\u0012\t'\u0004\u0002\u0003Z)!!1\fB/\u0003\u0011a\u0017M\\4\u000b\u0005\t}\u0013\u0001\u00026bm\u0006LA!!\u001c\u0003Z\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011W\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011YG!\u001d\u0011\u0007a\u0012i'C\u0002\u0003pe\u00121!\u00118z\u0011%\u0011\u0019hFA\u0001\u0002\u0004\t\t,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005s\u0002bAa\u001f\u0003\u0002\n-TB\u0001B?\u0015\r\u0011y(O\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BB\u0005{\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0006BE\u0011%\u0011\u0019(GA\u0001\u0002\u0004\u0011Y'\u0001\u0005iCND7i\u001c3f)\t\t\t,\u0001\u0005u_N#(/\u001b8h)\t\u0011)&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\u00119\nC\u0005\u0003tq\t\t\u00111\u0001\u0003l\u0005yR\t\u001f9sKN\u001c\u0018n\u001c8TK2,7\r^5wSRL8)\u00197dk2\fGo\u001c:\u0011\u0005As2\u0003\u0002\u0010\u0003 \u0002\u0003rA!)\u0003(\u0016{e+\u0004\u0002\u0003$*\u0019!QU\u001d\u0002\u000fI,h\u000e^5nK&!!\u0011\u0016BR\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u00057#RA\u0016BX\u0005cCQaQ\u0011A\u0002\u0015CQ!T\u0011A\u0002=\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00038\n}\u0006#\u0002\u001d\u0002L\te\u0006#\u0002\u001d\u0003<\u0016{\u0015b\u0001B_s\t1A+\u001e9mKJB\u0001B!1#\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa2\u0011\t\t]#\u0011Z\u0005\u0005\u0005\u0017\u0014IF\u0001\u0004PE*,7\r\u001e")
public class ExpressionSelectivityCalculator
implements Product,
scala.Serializable {
    private final GraphStatistics stats;
    private final SelectivityCombiner combiner;

    public static Option<Tuple2<GraphStatistics, SelectivityCombiner>> unapply(ExpressionSelectivityCalculator expressionSelectivityCalculator) {
        return ExpressionSelectivityCalculator$.MODULE$.unapply(expressionSelectivityCalculator);
    }

    public static Function1<Tuple2<GraphStatistics, SelectivityCombiner>, ExpressionSelectivityCalculator> tupled() {
        return ExpressionSelectivityCalculator$.MODULE$.tupled();
    }

    public static Function1<GraphStatistics, Function1<SelectivityCombiner, ExpressionSelectivityCalculator>> curried() {
        return ExpressionSelectivityCalculator$.MODULE$.curried();
    }

    public GraphStatistics stats() {
        return this.stats;
    }

    public SelectivityCombiner combiner() {
        return this.combiner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Selectivity apply(Expression exp, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable) {
        Option<PointDistanceSeekable> option;
        Expression expression;
        Expression expression2;
        PrefixRangeSeekable seekable;
        Expression expression3;
        PrefixRange<Expression> prefixRange;
        PrefixRangeSeekable seekable2;
        HasLabels hasLabels;
        Seq seq;
        boolean bl = false;
        Contains contains = null;
        boolean bl2 = false;
        EndsWith endsWith = null;
        boolean bl3 = false;
        Not not = null;
        Expression expression4 = exp;
        if (expression4 instanceof HasLabels && (seq = (hasLabels = (HasLabels)expression4).labels()) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)seq;
            LabelName label = (LabelName)colon2.head();
            List list = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list)) {
                return this.calculateSelectivityForLabel((Option<LabelId>)semanticTable.id(label));
            }
        }
        if (expression4 instanceof False) {
            return Selectivity$.MODULE$.ZERO();
        }
        if (expression4 instanceof PartialPredicate) {
            PartialPredicate partialPredicate = (PartialPredicate)expression4;
            return this.apply(partialPredicate.coveredPredicate(), labelInfo, relTypeInfo, semanticTable);
        }
        Option<PropertySeekable> option2 = AsPropertySeekable$.MODULE$.unapply(expression4);
        if (!option2.isEmpty()) {
            PropertySeekable seekable3 = (PropertySeekable)option2.get();
            return this.calculateSelectivityForPropertyEquality(seekable3.name(), (Option<Object>)seekable3.args().sizeHint(), labelInfo, relTypeInfo, seekable3.propertyKey(), semanticTable);
        }
        Option<PrefixRangeSeekable> option3 = AsStringRangeSeekable$.MODULE$.unapply(expression4);
        if (!option3.isEmpty() && (seekable2 = (PrefixRangeSeekable)option3.get()) != null && (prefixRange = seekable2.range()) != null && (expression3 = (Expression)prefixRange.prefix()) instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression3;
            String prefix = stringLiteral.value();
            return this.calculateSelectivityForSubstringSargable(seekable2.name(), labelInfo, relTypeInfo, seekable2.propertyKeyName(), (Option<String>)new Some((Object)prefix), semanticTable);
        }
        Option<PrefixRangeSeekable> option4 = AsStringRangeSeekable$.MODULE$.unapply(expression4);
        if (!option4.isEmpty() && (seekable = (PrefixRangeSeekable)option4.get()) != null && seekable.range() != null) {
            return this.calculateSelectivityForSubstringSargable(seekable.name(), labelInfo, relTypeInfo, seekable.propertyKeyName(), (Option<String>)None$.MODULE$, semanticTable);
        }
        if (expression4 instanceof Contains) {
            bl = true;
            contains = (Contains)expression4;
            Expression expression5 = contains.lhs();
            Expression expression6 = contains.rhs();
            if (expression5 instanceof Property) {
                Property property = (Property)expression5;
                Expression expression7 = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (expression7 instanceof Variable) {
                    Variable variable = (Variable)expression7;
                    String name = variable.name();
                    if (expression6 instanceof StringLiteral) {
                        StringLiteral stringLiteral = (StringLiteral)expression6;
                        String substring = stringLiteral.value();
                        return this.calculateSelectivityForSubstringSargable(name, labelInfo, relTypeInfo, propertyKey, (Option<String>)new Some((Object)substring), semanticTable);
                    }
                }
            }
        }
        if (bl && (expression2 = contains.lhs()) instanceof Property) {
            Property property = (Property)expression2;
            Expression expression8 = property.map();
            PropertyKeyName propertyKey = property.propertyKey();
            if (expression8 instanceof Variable) {
                Variable variable = (Variable)expression8;
                String name = variable.name();
                return this.calculateSelectivityForSubstringSargable(name, labelInfo, relTypeInfo, propertyKey, (Option<String>)None$.MODULE$, semanticTable);
            }
        }
        if (expression4 instanceof EndsWith) {
            bl2 = true;
            endsWith = (EndsWith)expression4;
            Expression expression9 = endsWith.lhs();
            Expression expression10 = endsWith.rhs();
            if (expression9 instanceof Property) {
                Property property = (Property)expression9;
                Expression expression11 = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (expression11 instanceof Variable) {
                    Variable variable = (Variable)expression11;
                    String name = variable.name();
                    if (expression10 instanceof StringLiteral) {
                        StringLiteral stringLiteral = (StringLiteral)expression10;
                        String substring = stringLiteral.value();
                        return this.calculateSelectivityForSubstringSargable(name, labelInfo, relTypeInfo, propertyKey, (Option<String>)new Some((Object)substring), semanticTable);
                    }
                }
            }
        }
        if (bl2 && (expression = endsWith.lhs()) instanceof Property) {
            Property property = (Property)expression;
            Expression expression12 = property.map();
            PropertyKeyName propertyKey = property.propertyKey();
            if (expression12 instanceof Variable) {
                Variable variable = (Variable)expression12;
                String name = variable.name();
                return this.calculateSelectivityForSubstringSargable(name, labelInfo, relTypeInfo, propertyKey, (Option<String>)None$.MODULE$, semanticTable);
            }
        }
        if (!(option = AsDistanceSeekable$.MODULE$.unapply(expression4)).isEmpty()) {
            PointDistanceSeekable seekable4 = (PointDistanceSeekable)option.get();
            return this.calculateSelectivityForPointDistanceSeekable(seekable4, labelInfo, relTypeInfo, semanticTable);
        }
        Option<InequalityRangeSeekable> option5 = AsValueRangeSeekable$.MODULE$.unapply(expression4);
        if (!option5.isEmpty()) {
            InequalityRangeSeekable seekable5 = (InequalityRangeSeekable)option5.get();
            return this.calculateSelectivityForValueRangeSeekable(seekable5, labelInfo, relTypeInfo, semanticTable);
        }
        Option<Scannable<Expression>> option6 = AsPropertyScannable$.MODULE$.unapply(expression4);
        if (!option6.isEmpty()) {
            Scannable scannable = (Scannable)option6.get();
            return this.calculateSelectivityForPropertyExistence(scannable.name(), labelInfo, relTypeInfo, scannable.propertyKey(), semanticTable);
        }
        if (expression4 instanceof Not) {
            bl3 = true;
            not = (Not)expression4;
            Expression expression13 = not.rhs();
            if (expression13 instanceof Equals) {
                Equals equals = (Equals)expression13;
                Expression lhs = equals.lhs();
                Expression rhs = equals.rhs();
                if (lhs instanceof Variable) {
                    Variable variable;
                    Variable variable2 = (Variable)lhs;
                    if (rhs instanceof Variable && this.areRelationships(semanticTable, variable2, variable = (Variable)rhs)) {
                        return PlannerDefaults$.MODULE$.DEFAULT_REL_UNIQUENESS_SELECTIVITY();
                    }
                }
            }
        }
        if (bl3) {
            Expression inner = not.rhs();
            return this.apply(inner, labelInfo, relTypeInfo, semanticTable).negate();
        }
        if (expression4 instanceof Ors) {
            Ors ors = (Ors)expression4;
            Seq expressions = ors.exprs();
            IndexedSeq selectivities = (IndexedSeq)expressions.toIndexedSeq().map((Function1 & Serializable & scala.Serializable)x$1 -> this.apply((Expression)x$1, labelInfo, relTypeInfo, semanticTable), IndexedSeq$.MODULE$.canBuildFrom());
            return (Selectivity)this.combiner().orTogetherSelectivities((Seq<Selectivity>)selectivities).get();
        }
        Option<IdSeekable> option7 = AsIdSeekable$.MODULE$.unapply(expression4);
        if (!option7.isEmpty()) {
            IdSeekable seekable6 = (IdSeekable)option7.get();
            return (Selectivity)((Cardinality)seekable6.args().sizeHint().map((Function1 & Serializable & scala.Serializable)x$2 -> ExpressionSelectivityCalculator.$anonfun$apply$2(BoxesRunTime.unboxToInt((Object)x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_NUMBER_OF_ID_LOOKUPS())).$div(this.stats().nodesAllCardinality()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Selectivity$.MODULE$.ONE());
        }
        if (expression4 instanceof Equals) {
            return PlannerDefaults$.MODULE$.DEFAULT_EQUALITY_SELECTIVITY();
        }
        boolean bl4 = expression4 instanceof GreaterThan ? true : (expression4 instanceof GreaterThanOrEqual ? true : (expression4 instanceof LessThan ? true : expression4 instanceof LessThanOrEqual));
        if (bl4) {
            return PlannerDefaults$.MODULE$.DEFAULT_RANGE_SELECTIVITY();
        }
        if (!(expression4 instanceof AssertIsNode)) return PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY();
        return Selectivity$.MODULE$.ONE();
    }

    private boolean areRelationships(SemanticTable semanticTable, Variable lhs, Variable rhs) {
        boolean l = semanticTable.isRelationship((Expression)lhs);
        boolean r = semanticTable.isRelationship((Expression)rhs);
        return l && r;
    }

    private Selectivity calculateSelectivityForLabel(Option<LabelId> label) {
        Cardinality labelCardinality = this.stats().nodesWithLabelCardinality(label);
        return (Selectivity)labelCardinality.$div(this.stats().nodesAllCardinality()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Selectivity$.MODULE$.ONE());
    }

    private Selectivity calculateSelectivityForPropertyExistence(String variable, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, PropertyKeyName propertyKey, SemanticTable semanticTable) {
        Seq<Selectivity> indexPropertyExistsSelectivities = this.indexPropertyExistsSelectivitiesFor(variable, labelInfo, relTypeInfo, propertyKey, semanticTable);
        return (Selectivity)this.combiner().orTogetherSelectivities(indexPropertyExistsSelectivities).getOrElse((Function0 & Serializable & scala.Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_PROPERTY_SELECTIVITY());
    }

    private Seq<Selectivity> indexPropertyExistsSelectivitiesFor(String variable, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, PropertyKeyName propertyKey, SemanticTable semanticTable) {
        Set labels = (Set)labelInfo.getOrElse((Object)variable, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        Option relTypes = relTypeInfo.get((Object)variable);
        return (Seq)((TraversableOnce)labels.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(relTypes), Set$.MODULE$.canBuildFrom())).toIndexedSeq().flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Tuple2 ids;
            Tuple2 tuple2;
            SymbolicName symbolicName = name;
            if (symbolicName instanceof LabelName) {
                LabelName labelName = (LabelName)symbolicName;
                tuple2 = new Tuple2((Object)semanticTable.id(labelName), (Object)semanticTable.id(propertyKey));
            } else {
                if (!(symbolicName instanceof RelTypeName)) throw new MatchError((Object)symbolicName);
                RelTypeName relTypeName = (RelTypeName)symbolicName;
                tuple2 = new Tuple2((Object)semanticTable.id(relTypeName), (Object)semanticTable.id(propertyKey));
            }
            Tuple2 tuple22 = ids = tuple2;
            if (tuple22 != null) {
                Some some;
                Product labelId;
                Option option = (Option)tuple22._1();
                Option option2 = (Option)tuple22._2();
                if (option instanceof Some && (labelId = (Product)(some = (Some)option).value()) instanceof LabelId) {
                    LabelId labelId2 = (LabelId)labelId;
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        PropertyKeyId propertyKeyId = (PropertyKeyId)some2.value();
                        IndexDescriptor descriptor = IndexDescriptor$.MODULE$.forLabel(labelId2, (Seq)new .colon.colon((Object)propertyKeyId, (List)Nil$.MODULE$));
                        return Option$.MODULE$.option2Iterable(this.stats().indexPropertyExistsSelectivity(descriptor));
                    }
                }
            }
            if (tuple22 == null) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Option option = (Option)tuple22._1();
            Option option3 = (Option)tuple22._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Some some = (Some)option;
            Product relTypeId = (Product)some.value();
            if (!(relTypeId instanceof RelTypeId)) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            RelTypeId relTypeId2 = (RelTypeId)relTypeId;
            if (!(option3 instanceof Some)) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Some some3 = (Some)option3;
            PropertyKeyId propertyKeyId = (PropertyKeyId)some3.value();
            IndexDescriptor descriptor = IndexDescriptor$.MODULE$.forRelType(relTypeId2, (Seq)new .colon.colon((Object)propertyKeyId, (List)Nil$.MODULE$));
            return Option$.MODULE$.option2Iterable(this.stats().indexPropertyExistsSelectivity(descriptor));
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Selectivity calculateSelectivityForPropertyEquality(String variable, Option<Object> sizeHint, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, PropertyKeyName propertyKey, SemanticTable semanticTable) {
        Selectivity selectivity;
        int n = BoxesRunTime.unboxToInt((Object)sizeHint.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> (int)PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY().amount()));
        switch (n) {
            case 0: {
                selectivity = Selectivity$.MODULE$.ZERO();
                break;
            }
            default: {
                Set labels = (Set)labelInfo.getOrElse((Object)variable, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
                Option relTypes = relTypeInfo.get((Object)variable);
                IndexedSeq indexSelectivities = (IndexedSeq)((TraversableOnce)labels.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(relTypes), Set$.MODULE$.canBuildFrom())).toIndexedSeq().flatMap(arg_0 -> ExpressionSelectivityCalculator.$anonfun$calculateSelectivityForPropertyEquality$3(this, semanticTable, propertyKey, n, arg_0), IndexedSeq$.MODULE$.canBuildFrom());
                selectivity = (Selectivity)this.combiner().orTogetherSelectivities((Seq<Selectivity>)indexSelectivities).orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultSelectivityForPropertyEquality(n)).getOrElse((Function0 & Serializable & scala.Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY());
                break;
            }
        }
        return selectivity;
    }

    private Option<Selectivity> indexSelectivityForPropertyEquality(IndexDescriptor descriptor, int size) {
        return this.selectivityForPropertyEquality((Option<Selectivity>)this.stats().indexPropertyExistsSelectivity(descriptor), (Option<Selectivity>)this.stats().uniqueValueSelectivity(descriptor), size);
    }

    private Option<Selectivity> defaultSelectivityForPropertyEquality(int size) {
        return this.selectivityForPropertyEquality((Option<Selectivity>)new Some((Object)PlannerDefaults$.MODULE$.DEFAULT_PROPERTY_SELECTIVITY()), (Option<Selectivity>)new Some((Object)PlannerDefaults$.MODULE$.DEFAULT_EQUALITY_SELECTIVITY()), size);
    }

    private Option<Selectivity> selectivityForPropertyEquality(Option<Selectivity> propertySelectivity, Option<Selectivity> uniqueValueSelectivity, int size) {
        return propertySelectivity.flatMap((Function1 & Serializable & scala.Serializable)propExists -> uniqueValueSelectivity.flatMap((Function1 & Serializable & scala.Serializable)propEqualsSingleValue -> this.combiner().orTogetherSelectivities((Seq<Selectivity>)((Seq)Seq$.MODULE$.fill(size, (Function0 & Serializable & scala.Serializable)() -> propEqualsSingleValue))).flatMap((Function1 & Serializable & scala.Serializable)propEqualsAnyValue -> this.combiner().andTogetherSelectivities((Seq<Selectivity>)((Seq)new .colon.colon(propExists, (List)new .colon.colon(propEqualsAnyValue, (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)combinedSelectivity -> combinedSelectivity))));
    }

    private Selectivity calculateSelectivityForValueRangeSeekable(InequalityRangeSeekable seekable, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable) {
        Set labels = (Set)labelInfo.getOrElse((Object)seekable.ident().name(), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        Option relTypes = relTypeInfo.get((Object)seekable.ident().name());
        Seq indexRangeSelectivities = (Seq)((TraversableOnce)labels.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(relTypes), Set$.MODULE$.canBuildFrom())).toIndexedSeq().flatMap((Function1 & Serializable & scala.Serializable)name -> {
            IndexDescriptor indexDescriptor;
            Tuple2 ids;
            Tuple2 tuple2;
            SymbolicName symbolicName = name;
            if (symbolicName instanceof LabelName) {
                LabelName labelName = (LabelName)symbolicName;
                tuple2 = new Tuple2((Object)semanticTable.id(labelName), (Object)semanticTable.id(seekable.expr().property().propertyKey()));
            } else {
                if (!(symbolicName instanceof RelTypeName)) throw new MatchError((Object)symbolicName);
                RelTypeName relTypeName = (RelTypeName)symbolicName;
                tuple2 = new Tuple2((Object)semanticTable.id(relTypeName), (Object)semanticTable.id(seekable.expr().property().propertyKey()));
            }
            Tuple2 tuple22 = ids = tuple2;
            if (tuple22 == null) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Option option = (Option)tuple22._1();
            Option option2 = (Option)tuple22._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Some some = (Some)option;
            Product labelOrRelTypeId = (Product)some.value();
            if (!(option2 instanceof Some)) return Option$.MODULE$.option2Iterable((Option)new Some((Object)Selectivity$.MODULE$.ZERO()));
            Some some2 = (Some)option2;
            PropertyKeyId propertyKeyId = (PropertyKeyId)some2.value();
            Product product = labelOrRelTypeId;
            if (product instanceof LabelId) {
                LabelId labelId = (LabelId)product;
                indexDescriptor = IndexDescriptor$.MODULE$.forLabel(labelId, (Seq)new .colon.colon((Object)propertyKeyId, (List)Nil$.MODULE$));
            } else {
                if (!(product instanceof RelTypeId)) throw new MatchError((Object)product);
                RelTypeId relTypeId = (RelTypeId)product;
                indexDescriptor = IndexDescriptor$.MODULE$.forRelType(relTypeId, (Seq)new .colon.colon((Object)propertyKeyId, (List)Nil$.MODULE$));
            }
            IndexDescriptor descriptor = indexDescriptor;
            return Option$.MODULE$.option2Iterable(this.stats().indexPropertyExistsSelectivity(descriptor).flatMap((Function1 & Serializable & scala.Serializable)propertyExistsSelectivity -> this.stats().uniqueValueSelectivity(descriptor).map((Function1 & Serializable & scala.Serializable)propEqValueSelectivity -> {
                Selectivity pNeq = propEqValueSelectivity.negate();
                double pNeqRange = pNeq.factor() * PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)Math.min(seekable.expr().inequalities().size(), 2);
                Selectivity pRange = Selectivity$.MODULE$.apply(seekable.hasEquality() ? propEqValueSelectivity.factor() + pNeqRange : pNeqRange);
                Selectivity pRangeBounded = Selectivity$.MODULE$.apply(package$.MODULE$.max(propEqValueSelectivity.factor(), pRange.factor()));
                return pRangeBounded.$times(propertyExistsSelectivity);
            })));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Selectivity)this.combiner().orTogetherSelectivities((Seq<Selectivity>)indexRangeSelectivities).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExpressionSelectivityCalculator.default$1(seekable));
    }

    private Selectivity calculateSelectivityForPointDistanceSeekable(PointDistanceSeekable seekable, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, SemanticTable semanticTable) {
        Seq<Selectivity> indexPropertyExistsSelectivities = this.indexPropertyExistsSelectivitiesFor(seekable.ident().name(), labelInfo, relTypeInfo, seekable.propertyKeyName(), semanticTable);
        Seq indexDistanceSelectivities = (Seq)indexPropertyExistsSelectivities.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.$times(Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR())), Seq$.MODULE$.canBuildFrom());
        return (Selectivity)this.combiner().orTogetherSelectivities((Seq<Selectivity>)indexDistanceSelectivities).getOrElse((Function0 & Serializable & scala.Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_RANGE_SELECTIVITY());
    }

    private Selectivity calculateSelectivityForSubstringSargable(String variable, Map<String, Set<LabelName>> labelInfo, Map<String, RelTypeName> relTypeInfo, PropertyKeyName propertyKey, Option<String> maybeString, SemanticTable semanticTable) {
        int n;
        Option<String> option = maybeString;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n2 = (String)some.value();
            n = n2.length();
        } else if (None$.MODULE$.equals(option)) {
            n = PlannerDefaults$.MODULE$.DEFAULT_STRING_LENGTH();
        } else {
            throw new MatchError(option);
        }
        int stringLength = n;
        Seq<Selectivity> indexPropertyExistsSelectivities = this.indexPropertyExistsSelectivitiesFor(variable, labelInfo, relTypeInfo, propertyKey, semanticTable);
        Seq indexSubstringSelectivities = (Seq)indexPropertyExistsSelectivities.map((Function1 & Serializable & scala.Serializable)exists -> {
            Selectivity selectivity;
            if (stringLength == 0) {
                selectivity = exists.$times(PlannerDefaults$.MODULE$.DEFAULT_TYPE_SELECTIVITY());
            } else {
                double res = exists.factor() * PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)stringLength;
                selectivity = Selectivity$.MODULE$.apply(res);
            }
            return selectivity;
        }, Seq$.MODULE$.canBuildFrom());
        return (Selectivity)this.combiner().orTogetherSelectivities((Seq<Selectivity>)indexSubstringSelectivities).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExpressionSelectivityCalculator.default$2(stringLength));
    }

    public ExpressionSelectivityCalculator copy(GraphStatistics stats, SelectivityCombiner combiner) {
        return new ExpressionSelectivityCalculator(stats, combiner);
    }

    public GraphStatistics copy$default$1() {
        return this.stats();
    }

    public SelectivityCombiner copy$default$2() {
        return this.combiner();
    }

    public String productPrefix() {
        return "ExpressionSelectivityCalculator";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.stats();
                break;
            }
            case 1: {
                object = this.combiner();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ExpressionSelectivityCalculator;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ExpressionSelectivityCalculator)) return false;
        boolean bl = true;
        if (!bl) return false;
        ExpressionSelectivityCalculator expressionSelectivityCalculator = (ExpressionSelectivityCalculator)x$1;
        GraphStatistics graphStatistics = this.stats();
        GraphStatistics graphStatistics2 = expressionSelectivityCalculator.stats();
        if (graphStatistics == null) {
            if (graphStatistics2 != null) {
                return false;
            }
        } else if (!graphStatistics.equals(graphStatistics2)) return false;
        SelectivityCombiner selectivityCombiner = this.combiner();
        SelectivityCombiner selectivityCombiner2 = expressionSelectivityCalculator.combiner();
        if (selectivityCombiner == null) {
            if (selectivityCombiner2 != null) {
                return false;
            }
        } else if (!selectivityCombiner.equals(selectivityCombiner2)) return false;
        if (!expressionSelectivityCalculator.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Cardinality $anonfun$apply$2(int x$2) {
        return new Cardinality((double)x$2);
    }

    public static final /* synthetic */ IndexDescriptor $anonfun$calculateSelectivityForPropertyEquality$4(PropertyKeyId propKeyId$1, LabelId id) {
        return IndexDescriptor$.MODULE$.forLabel(id, (Seq)new .colon.colon((Object)propKeyId$1, (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ IndexDescriptor $anonfun$calculateSelectivityForPropertyEquality$5(PropertyKeyId propKeyId$2, RelTypeId id) {
        return IndexDescriptor$.MODULE$.forRelType(id, (Seq)new .colon.colon((Object)propKeyId$2, (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ Option $anonfun$calculateSelectivityForPropertyEquality$6(ExpressionSelectivityCalculator $this, int x1$1, IndexDescriptor x$3) {
        return $this.indexSelectivityForPropertyEquality(x$3, x1$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterable $anonfun$calculateSelectivityForPropertyEquality$3(ExpressionSelectivityCalculator $this, SemanticTable semanticTable$3, PropertyKeyName propertyKey$2, int x1$1, SymbolicName name) {
        block3: {
            block2: {
                var7_5 = new Tuple2((Object)name, (Object)semanticTable$3.id(propertyKey$2));
                if (var7_5 == null) break block2;
                labelName = (SymbolicName)var7_5._1();
                var9_7 = (Option)var7_5._2();
                if (!(labelName instanceof LabelName)) break block2;
                var10_8 = (LabelName)labelName;
                if (!(var9_7 instanceof Some)) break block2;
                var11_9 = (Some)var9_7;
                propKeyId = (PropertyKeyId)var11_9.value();
                var5_11 = semanticTable$3.id(var10_8).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$calculateSelectivityForPropertyEquality$4(org.neo4j.cypher.internal.util.PropertyKeyId org.neo4j.cypher.internal.util.LabelId ), (Lorg/neo4j/cypher/internal/util/LabelId;)Lorg/neo4j/cypher/internal/planner/spi/IndexDescriptor;)((PropertyKeyId)propKeyId));
                break block3;
            }
            if (var7_5 == null) ** GOTO lbl-1000
            relTypeName = (SymbolicName)var7_5._1();
            var14_13 = (Option)var7_5._2();
            if (!(relTypeName instanceof RelTypeName)) ** GOTO lbl-1000
            var15_14 = (RelTypeName)relTypeName;
            if (var14_13 instanceof Some) {
                var16_15 = (Some)var14_13;
                propKeyId = (PropertyKeyId)var16_15.value();
                var5_11 = semanticTable$3.id(var15_14).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$calculateSelectivityForPropertyEquality$5(org.neo4j.cypher.internal.util.PropertyKeyId org.neo4j.cypher.internal.util.RelTypeId ), (Lorg/neo4j/cypher/internal/util/RelTypeId;)Lorg/neo4j/cypher/internal/planner/spi/IndexDescriptor;)((PropertyKeyId)propKeyId));
            } else lbl-1000:
            // 3 sources

            {
                var5_11 = None$.MODULE$;
            }
        }
        descriptor = var5_11;
        return Option$.MODULE$.option2Iterable(descriptor.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$calculateSelectivityForPropertyEquality$6(org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator int org.neo4j.cypher.internal.planner.spi.IndexDescriptor ), (Lorg/neo4j/cypher/internal/planner/spi/IndexDescriptor;)Lscala/Option;)((ExpressionSelectivityCalculator)$this, (int)x1$1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Selectivity default$1(InequalityRangeSeekable seekable$1) {
        void var1_1;
        Selectivity defaultRange = PlannerDefaults$.MODULE$.DEFAULT_RANGE_SELECTIVITY().$times(Selectivity$.MODULE$.apply(1.0 / (double)Math.min(seekable$1.expr().inequalities().size(), 2)));
        return seekable$1.hasEquality() ? (Selectivity)Selectivity$.MODULE$.of(PlannerDefaults$.MODULE$.DEFAULT_EQUALITY_SELECTIVITY().factor() + defaultRange.factor()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Selectivity$.MODULE$.ONE()) : var1_1;
    }

    private static final Selectivity default$2(int stringLength$1) {
        return stringLength$1 == 0 ? PlannerDefaults$.MODULE$.DEFAULT_PROPERTY_SELECTIVITY().$times(PlannerDefaults$.MODULE$.DEFAULT_TYPE_SELECTIVITY()) : Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SELECTIVITY().factor() / (double)stringLength$1);
    }

    public ExpressionSelectivityCalculator(GraphStatistics stats, SelectivityCombiner combiner) {
        this.stats = stats;
        this.combiner = combiner;
        Product.$init$((Product)this);
    }
}

