/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnionAll;
import org.neo4j.cypher.internal.ast.UnionDistinct;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState$;
import org.neo4j.cypher.internal.frontend.PlannerName;
import org.neo4j.cypher.internal.frontend.phases.AmbiguousNamesDisambiguated$;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.InPredicatesCollapsed$;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.StatementCondition;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.frontend.phases.rewriting.cnf.CNFNormalizer$;
import org.neo4j.cypher.internal.ir.PeriodicCommit;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.rewriting.ValidatingCondition;
import org.neo4j.cypher.internal.rewriting.conditions.aggregationsAreIsolated$;
import org.neo4j.cypher.internal.rewriting.conditions.containsNamedPathOnlyForShortestPath$;
import org.neo4j.cypher.internal.rewriting.conditions.containsNoNodesOfType;
import org.neo4j.cypher.internal.rewriting.conditions.package$;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.DatabaseAdministrationException;
import org.neo4j.exceptions.InternalException;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class CreatePlannerQuery$
implements Phase<BaseContext, BaseState, LogicalPlanState>,
StepSequencer.Step,
PlanPipelineTransformerFactory,
Product,
Serializable {
    public static CreatePlannerQuery$ MODULE$;

    static {
        new CreatePlannerQuery$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public LogicalPlanState process(BaseState from, BaseContext context) {
        Statement statement = from.statement();
        if (!(statement instanceof Query)) {
            if (statement instanceof AdministrationCommand) {
                AdministrationCommand administrationCommand = (AdministrationCommand)statement;
                throw new DatabaseAdministrationException(new StringBuilder(89).append("This is an administration command and it should be executed against the system database: ").append(administrationCommand.name()).toString());
            }
            throw new InternalException(new StringBuilder(27).append("Expected a Query and not `").append(statement).append("`").toString());
        }
        Query query = (Query)statement;
        PlannerQuery plannerQuery = StatementConverters$.MODULE$.toPlannerQuery(query, from.semanticTable());
        LogicalPlanState qual$1 = LogicalPlanState$.MODULE$.apply(from);
        Some x$1 = new Some((Object)plannerQuery);
        String x$2 = qual$1.copy$default$1();
        Option<InputPosition> x$3 = qual$1.copy$default$2();
        PlannerName x$4 = qual$1.copy$default$3();
        PlanningAttributes x$5 = qual$1.copy$default$4();
        Option<Statement> x$6 = qual$1.copy$default$5();
        Option<SemanticState> x$7 = qual$1.copy$default$6();
        Option<Map<String, Object>> x$8 = qual$1.copy$default$7();
        Option<SemanticTable> x$9 = qual$1.copy$default$8();
        Option<LogicalPlan> x$10 = qual$1.copy$default$10();
        Option<Option<PeriodicCommit>> x$11 = qual$1.copy$default$11();
        Set<StepSequencer.Condition> x$12 = qual$1.copy$default$12();
        Map<String, CypherType> x$13 = qual$1.copy$default$13();
        boolean x$14 = qual$1.copy$default$14();
        Option<Seq<String>> x$15 = qual$1.copy$default$15();
        Option<ObfuscationMetadata> x$16 = qual$1.copy$default$16();
        LogicalPlanState logicalPlanState = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<PlannerQuery>)x$1, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        return logicalPlanState;
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)((SetLike)((TraversableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new StatementCondition((ValidatingCondition)containsNamedPathOnlyForShortestPath$.MODULE$), new StatementCondition((ValidatingCondition)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionAll.class))), new StatementCondition((ValidatingCondition)new containsNoNodesOfType(ClassTag$.MODULE$.apply(UnionDistinct.class))), AmbiguousNamesDisambiguated$.MODULE$, new StatementCondition((ValidatingCondition)aggregationsAreIsolated$.MODULE$), InPredicatesCollapsed$.MODULE$}))).$plus$plus((GenTraversableOnce)CNFNormalizer$.MODULE$.PredicatesInCNF(), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)package$.MODULE$.SemanticInfoAvailable());
    }

    public Set<StepSequencer.Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(UnionQuery.class))}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public Transformer<BaseContext, BaseState, LogicalPlanState> getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    public String productPrefix() {
        return "CreatePlannerQuery";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreatePlannerQuery$;
    }

    public int hashCode() {
        return -1598443182;
    }

    public String toString() {
        return "CreatePlannerQuery";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CreatePlannerQuery$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        Product.$init$((Product)this);
    }
}

