/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.helpers.IteratorSupport$;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable;
import org.neo4j.cypher.internal.compiler.helpers.LazyIterable$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.exceptions.InternalException;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\n\u0015\u0001\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000fC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u000e\u0001!\t!a\u0004\b\u0013\u0005eB#!A\t\u0002\u0005mb\u0001C\n\u0015\u0003\u0003E\t!!\u0010\t\retA\u0011AA \u0011%\t\tEDI\u0001\n\u0003\t\u0019\u0005C\u0005\u0002f9\t\n\u0011\"\u0001\u0002h!I\u0011Q\u0010\b\u0012\u0002\u0013\u0005\u0011q\u0010\u0002\n\u0013\u0012\u00036k\u001c7wKJT!!\u0006\f\u0002\u0007%$\u0007O\u0003\u0002\u00181\u00059An\\4jG\u0006d'BA\r\u001b\u0003\u001d\u0001H.\u00198oKJT!a\u0007\u000f\u0002\u0011\r|W\u000e]5mKJT!!\b\u0010\u0002\u0011%tG/\u001a:oC2T!a\b\u0011\u0002\r\rL\b\u000f[3s\u0015\t\t#%A\u0003oK>$$NC\u0001$\u0003\ry'oZ\u0002\u0001+\u00111CGP!\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-A\u0005hK:,'/\u0019;peB)q\u0006\r\u001a>\u00016\tA#\u0003\u00022)\ti\u0011\n\u0012)T_24XM]*uKB\u0004\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\tA1k\u001c7wC\ndW-\u0005\u00028uA\u0011\u0001\u0006O\u0005\u0003s%\u0012qAT8uQ&tw\r\u0005\u0002)w%\u0011A(\u000b\u0002\u0004\u0003:L\bCA\u001a?\t\u0015y\u0004A1\u00017\u0005\u0019\u0011Vm];miB\u00111'\u0011\u0003\u0006\u0005\u0002\u0011\rA\u000e\u0002\b\u0007>tG/\u001a=u\u0003I\u0001(o\u001c6fGRLgnZ*fY\u0016\u001cGo\u001c:\u0011\u0007\u00153U(D\u0001\u0017\u0013\t9eC\u0001\nQe>TWm\u0019;j]\u001e\u001cV\r\\3di>\u0014\u0018AE2b]\u0012LG-\u0019;f!J|'.Z2u_J\u0004B\u0001\u000b&>{%\u00111*\u000b\u0002\n\rVt7\r^5p]F\nqB]3hSN$(/\u001f$bGR|'/\u001f\t\u0004Q9\u0003\u0016BA(*\u0005%1UO\\2uS>t\u0007\u0007E\u00020#JJ!A\u0015\u000b\u0003\u0015%#'+Z4jgR\u0014\u00180\u0001\u0007uC\ndWMR1di>\u0014\u0018\u0010E\u0003)+B;f,\u0003\u0002WS\tIa)\u001e8di&|gN\r\t\u00051n\u0013TH\u0004\u000203&\u0011!\fF\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0003TK\u0016$'B\u0001.\u0015!\rys,P\u0005\u0003AR\u0011\u0001\"\u0013#Q)\u0006\u0014G.Z\u0001\r[\u0006DH+\u00192mKNK'0\u001a\t\u0003Q\rL!\u0001Z\u0015\u0003\u0007%sG/\u0001\fji\u0016\u0014\u0018\r^5p]\u0012+(/\u0019;j_:d\u0015.\\5u!\tAs-\u0003\u0002iS\t!Aj\u001c8h\u0003A)\u0007\u0010\u001e:b%\u0016\fX/\u001b:f[\u0016tG\u000fE\u00020WvJ!\u0001\u001c\u000b\u0003!\u0015CHO]1SKF,\u0018N]3nK:$\u0018aB7p]&$xN\u001d\t\u0003_=L!\u0001\u001d\u000b\u0003!%#\u0005kU8mm\u0016\u0014Xj\u001c8ji>\u0014\u0018\u0001E:u_B<\u0016\r^2i\r\u0006\u001cGo\u001c:z!\rAcj\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\u0002\nA\u0001^5nK&\u0011\u00010\u001e\u0002\n'R|\u0007o^1uG\"\fa\u0001P5oSRtD#E>}{z|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\fA)q\u0006\u0001\u001a>\u0001\")Qf\u0003a\u0001]!)1i\u0003a\u0001\t\"9\u0001j\u0003I\u0001\u0002\u0004I\u0005b\u0002'\f!\u0003\u0005\r!\u0014\u0005\b'.\u0001\n\u00111\u0001U\u0011\u0015\t7\u00021\u0001c\u0011\u0015)7\u00021\u0001g\u0011\u0015I7\u00021\u0001k\u0011\u0015i7\u00021\u0001o\u0011\u0015\t8\u00021\u0001s\u0003\u0015\t\u0007\u000f\u001d7z)!\t\t\"a\u0006\u0002\u001c\u0005U\u0002\u0003B\u0018\u0002\u0014uJ1!!\u0006\u0015\u0005-\u0011Um\u001d;SKN,H\u000e^:\t\r\u0005eA\u00021\u0001X\u0003\u0011\u0019X-\u001a3\t\u000f\u0005uA\u00021\u0001\u0002 \u0005Y\u0011N\\5uS\u0006dGk\u001c#p!\u0015\t\t#a\f3\u001d\u0011\t\u0019#!\f\u000f\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b%\u0003\u0019a$o\\8u}%\t!&\u0003\u0002[S%!\u0011\u0011GA\u001a\u0005\r\u0019V-\u001d\u0006\u00035&Ba!a\u000e\r\u0001\u0004\u0001\u0015aB2p]R,\u0007\u0010^\u0001\n\u0013\u0012\u00036k\u001c7wKJ\u0004\"a\f\b\u0014\u000599CCAA\u001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gUA\u0011QIA1\u0003\u001b\n\u0019'\u0006\u0002\u0002H)\"\u0011\u0011JA(!\u0019A#*a\u0013\u0002LA\u00191'!\u0014\u0005\u000b}\u0002\"\u0019\u0001\u001c,\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0017*\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\n)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Q!\u000e\tC\u0002Y\"QA\u0011\tC\u0002Y\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003CA5\u0003o\nI(a\u001f\u0016\u0005\u0005-$\u0006BA7\u0003\u001f\u0002B\u0001\u000b(\u0002pA)q&!\u001d\u0002v%\u0019\u00111\u000f\u000b\u0003#\u0011+g-Y;mi&#'+Z4jgR\u0014\u0018\u0010E\u00024\u0003o\"Q!N\tC\u0002Y\"QaP\tC\u0002Y\"QAQ\tC\u0002Y\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003CAA\u0003\u0017\u000b\t*!&\u0016\u0005\u0005\r%\u0006BAC\u0003\u001f\u0002\u0002\u0002K+\u0002\b\u00065\u00151\u0013\t\u0005_E\u000bI\tE\u00024\u0003\u0017#Q!\u000e\nC\u0002Y\u0002b\u0001W.\u0002\n\u0006=\u0005cA\u001a\u0002\u0012\u0012)qH\u0005b\u0001mA!qfXAH\t\u0015\u0011%C1\u00017\u0001")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function1<Result, Result> candidateProjector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> $lessinit$greater$default$5() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$5();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function1<Result, Result> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        BestResults<Object> bestResults;
        Object bestResult;
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        int iterations = 0;
        while (((Goal)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), toDo, table, registry, context);
            if (largestFinished <= 0) {
                throw new InternalException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("Unfortunately, the planner was unable to find a plan within the constraints provided.\n           |Try increasing the config values `").append(GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name()).append("`\n           |and `").append(GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name()).append("` to allow\n           |for a larger sub-plan table and longer planning time.").toString())).stripMargin());
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, table);
            this.monitor.endIteration(iterations, largestFinished, table.size());
            IDPSolver.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations);
        Tuple2 tuple2 = table.plans().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object result;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    result = tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            boolean fulfilsReq = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)fulfilsReq), result);
            return tuple23;
        }).partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$apply$16(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator plansFulfillingReq = (Iterator)tuple2._1();
        Iterator plans = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plansFulfillingReq, (Object)plans);
        Tuple2 tuple23 = tuple22;
        Iterator plansFulfillingReq2 = (Iterator)tuple23._1();
        Iterator plans2 = (Iterator)tuple23._2();
        Tuple2 tuple24 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plans2).toSingleOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InternalException("Expected a single plan to be left in the plan table");
        });
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Object object = bestResult = tuple24._2();
        Object bestResult2 = object;
        if (plansFulfillingReq2.hasNext()) {
            Object plan;
            Tuple2 tuple25 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plansFulfillingReq2).toSingleOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new InternalException("Expected a single plan that fulfils the requirements to be left in the plan table");
            });
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            Object object2 = plan = tuple25._2();
            Object plan2 = object2;
            bestResults = new BestResults<Object>(bestResult2, (Option<Object>)new Some(plan2));
        } else {
            bestResults = new BestResults<Object>(bestResult2, (Option<Object>)None$.MODULE$);
        }
        return bestResults;
    }

    private final Function1 candidateSelector$1(Function0 resolved) {
        return (Function1 & Serializable & scala.Serializable)x$2 -> $this.projectingSelector.apply($this.candidateProjector, x$2, (Function0<String>)resolved);
    }

    private final Function1 goalSelector$1(Function0 resolved) {
        return (Function1 & Serializable & scala.Serializable)x$3 -> $this.projectingSelector.apply((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object result = tuple2._2();
            Object object = $this.candidateProjector.apply(result);
            return object;
        }, x$3, (Function0<String>)resolved);
    }

    public static final /* synthetic */ void $anonfun$apply$8(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$apply$9(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, ObjectRef toDo$1, IDPTable table$1, IdRegistry registry$1, Object context$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
            while (keepGoing && goals.hasNext()) {
                Goal goal = (Goal)goals.next();
                if (table$1.contains(goal, false)) continue;
                LazyIterable candidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.generator.apply(registry$1, goal, table$1, context$1));
                Tuple2 tuple2 = candidates.partition((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraRequirement.fulfils(result)));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Iterable extraCandidates = (Iterable)tuple2._1();
                Iterable baseCandidates = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)extraCandidates, (Object)baseCandidates);
                Tuple2 tuple23 = tuple22;
                Iterable extraCandidates2 = (Iterable)tuple23._1();
                Iterable baseCandidates2 = (Iterable)tuple23._2();
                Option bestExtraCandidate = (Option)this.candidateSelector$1((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("best sorted plan for ").append(goal.bitSet()).append("@").append(registry$1.explode(goal.bitSet())).toString()).apply((Object)extraCandidates2);
                ((Option)this.candidateSelector$1((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("best overall plan for ").append(goal.bitSet()).append("@").append(registry$1.explode(goal.bitSet())).toString()).apply(baseCandidates2.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(bestExtraCandidate).toIterable(), Iterable$.MODULE$.canBuildFrom()))).foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$8(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                bestExtraCandidate.foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$9(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && !start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS);
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, IDPTable table$1) {
        Goal goal;
        IndexedSeq blockCandidates = LazyIterable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> table$1.unsortedPlansOfSize(blockSize)).toIndexedSeq();
        Option bestInBlock = (Option)this.goalSelector$1((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Best candidate for block size ").append(blockSize).toString()).apply(blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InternalException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("Found no solution for block with size ").append(blockSize).append(",\n             |").append(blockCandidates).append(" were the selected candidates from the table ").append(table$1).toString())).stripMargin());
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal2 = goal = (Goal)tuple2._1();
        Goal goal3 = goal2;
        return goal3;
    }

    private static final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Tuple2 tuple2 = new Tuple2(result, sortedResult);
        Tuple2 tuple22 = tuple2;
        Option result2 = (Option)tuple22._1();
        Option sortedResult2 = (Option)tuple22._2();
        result2.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            table$1.put(new Goal(BitSet$.MODULE$.empty().$plus(newId)), false, x$6);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            table$1.put(new Goal(BitSet$.MODULE$.empty().$plus(newId)), true, x$7);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal(((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((GenTraversableOnce)original.bitSet())).$plus(newId));
        table$1.removeAllTracesOf(original);
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(Tuple2 x0$2) {
        boolean fulfilsReq;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = fulfilsReq = tuple2._1$mcZ$sp();
        return bl;
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function1<Result, Result> candidateProjector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.candidateProjector = candidateProjector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraRequirement = extraRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
    }
}

