/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cypher.internal.compiler.planner.logical.CostModelMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SelectorHeuristic;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.CostComparisonListener;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanToPlanBuilderString$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.cypher.internal.util.attribution.Id;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SystemOutCostLogger$
implements CostComparisonListener {
    public static SystemOutCostLogger$ MODULE$;
    private final AtomicLong comparisonId;
    private final String prefix;

    static {
        new SystemOutCostLogger$();
    }

    private AtomicLong comparisonId() {
        return this.comparisonId;
    }

    private String prefix() {
        return this.prefix;
    }

    private String blue(String str) {
        return new StringBuilder(9).append("\u001b[34m").append(str).append("\u001b[0m").toString();
    }

    private String blue_bold(String str) {
        return new StringBuilder(13).append("\u001b[34m\u001b[1m").append(str).append("\u001b[0m").toString();
    }

    private String cyan(String str) {
        return new StringBuilder(9).append("\u001b[36m").append(str).append("\u001b[0m").toString();
    }

    private String cyan_bold(String str) {
        return new StringBuilder(17).append("\u001b[36m\u001b[4m\u001b[1m").append(str).append("\u001b[0m").toString();
    }

    private String cyan_background(String str) {
        return new StringBuilder(9).append("\u001b[46m").append(str).append("\u001b[0m").toString();
    }

    private String green(String str) {
        return new StringBuilder(9).append("\u001b[32m").append(str).append("\u001b[0m").toString();
    }

    private String magenta(String str) {
        return new StringBuilder(9).append("\u001b[35m").append(str).append("\u001b[0m").toString();
    }

    private String magenta_bold(String str) {
        return new StringBuilder(17).append("\u001b[35m\u001b[4m\u001b[1m").append(str).append("\u001b[0m").toString();
    }

    private String indent(int level, String str) {
        String ind = new StringOps(Predef$.MODULE$.augmentString(this.prefix())).$times(level);
        return new StringBuilder(0).append(ind).append(str.replaceAll(System.lineSeparator(), new StringBuilder(0).append(System.lineSeparator()).append(ind).toString())).toString();
    }

    @Override
    public <X> void report(Function1<X, LogicalPlan> projector, Iterable<X> input, Ordering<X> inputOrdering, LogicalPlanningContext context, Function0<String> resolved, Function1<LogicalPlan, String> resolvedPerPlan, SelectorHeuristic heuristic) {
        block0: {
            Map planCost = Map$.MODULE$.empty();
            Map planEffectiveCardinality = Map$.MODULE$.empty();
            CostModelMonitor monitor = new CostModelMonitor(planCost, planEffectiveCardinality){
                private final Map planCost$1;
                private final Map planEffectiveCardinality$1;

                public void reportPlanCost(LogicalPlan rootPlan, LogicalPlan plan, Cost cost) {
                    this.planCost$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id()))), (Object)cost));
                }

                public void reportPlanEffectiveCardinality(LogicalPlan rootPlan, LogicalPlan plan, Cardinality cardinality) {
                    this.planEffectiveCardinality$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id()))), (Object)cardinality));
                }
                {
                    this.planCost$1 = planCost$1;
                    this.planEffectiveCardinality$1 = planEffectiveCardinality$1;
                }
            };
            IndexedSeq plansInOrder = (IndexedSeq)((TraversableLike)((SeqLike)input.toIndexedSeq().distinct()).sorted(inputOrdering)).map(projector, IndexedSeq$.MODULE$.canBuildFrom());
            plansInOrder.foreach((Function1 & Serializable & scala.Serializable)plan -> context.cost().costFor((LogicalPlan)plan, context.input(), context.semanticTable(), context.planningAttributes().cardinalities(), context.planningAttributes().providedOrders(), monitor));
            if (!plansInOrder.nonEmpty()) break block0;
            long id = this.comparisonId().getAndIncrement();
            Predef$.MODULE$.println((Object)this.blue_bold(new StringBuilder(12).append(id).append(": Resolving ").append(resolved.apply()).toString()));
            Predef$.MODULE$.println((Object)"Get best of:");
            ((TraversableLike)plansInOrder.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SystemOutCostLogger$.$anonfun$report$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                SystemOutCostLogger$.$anonfun$report$3(this, resolvedPerPlan, context, heuristic, planCost, planEffectiveCardinality, x$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public <X> Function1<LogicalPlan, String> report$default$6() {
        return (Function1 & Serializable & scala.Serializable)x$3 -> "";
    }

    private final String costString$1(LogicalPlan rootPlan, LogicalPlan plan, Map planCost$1, LogicalPlanningContext context$1, Map planEffectiveCardinality$1) {
        double cost = ((Cost)planCost$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).gummyBears();
        double cardinality = ((Cardinality)context$1.planningAttributes().cardinalities().get(plan.id())).amount();
        double effectiveCardinality = ((Cardinality)planEffectiveCardinality$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).amount();
        String costStr = new StringBuilder(0).append(this.magenta(" // cost ")).append(this.magenta_bold(Double.toString(cost))).toString();
        String cardStr = new StringBuilder(0).append(this.magenta(", cardinality ")).append(this.magenta_bold(Double.toString(cardinality))).toString();
        String effCardStr = cardinality > effectiveCardinality ? new StringBuilder(0).append(this.cyan(" (effective cardinality ")).append(this.cyan_bold(Double.toString(effectiveCardinality))).append(this.cyan(")")).toString() : "";
        return new StringBuilder(0).append(costStr).append(cardStr).append(effCardStr).toString();
    }

    private final String planPrefixDotString$1(LogicalPlan rootPlan, LogicalPlan plan, LogicalPlanningContext context$1, Map planEffectiveCardinality$1) {
        double effectiveCardinality;
        double cardinality = ((Cardinality)context$1.planningAttributes().cardinalities().get(plan.id())).amount();
        return cardinality > (effectiveCardinality = ((Cardinality)planEffectiveCardinality$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).amount()) ? this.cyan_background(".") : ".";
    }

    public static final /* synthetic */ boolean $anonfun$report$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$report$3(SystemOutCostLogger$ $this, Function1 resolvedPerPlan$1, LogicalPlanningContext context$1, SelectorHeuristic heuristic$1, Map planCost$1, Map planEffectiveCardinality$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan plan2 = (LogicalPlan)tuple2._1();
        int index = tuple2._2$mcI$sp();
        String winner = index == 0 ? MODULE$.green(" [winner]") : "";
        String resolvedStr = MODULE$.cyan(new StringBuilder(1).append(" ").append(resolvedPerPlan$1.apply((Object)plan2)).toString());
        String header = new StringBuilder(0).append(MODULE$.blue(new StringBuilder(8).append(index).append(": Plan #").append(plan2.debugId()).toString())).append(winner).append(resolvedStr).toString();
        String planWithCosts = LogicalPlanToPlanBuilderString$.MODULE$.apply(plan2, (Function1 & Serializable & scala.Serializable)plan -> $this.costString$1(plan2, (LogicalPlan)plan, planCost$1, context$1, planEffectiveCardinality$1), (Function1 & Serializable & scala.Serializable)plan -> $this.planPrefixDotString$1(plan2, (LogicalPlan)plan, context$1, planEffectiveCardinality$1));
        int hints = ((PlannerQueryPart)context$1.planningAttributes().solveds().get(plan2.id())).numHints();
        int heuristicValue = heuristic$1.tieBreaker(plan2);
        String extra = new StringBuilder(22).append("(hints: ").append(hints).append(", heuristic: ").append(heuristicValue).append(")").toString();
        Predef$.MODULE$.println((Object)MODULE$.indent(1, header));
        Predef$.MODULE$.println((Object)MODULE$.indent(2, planWithCosts));
        Predef$.MODULE$.println((Object)MODULE$.indent(2, extra));
        Predef$.MODULE$.println();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SystemOutCostLogger$() {
        MODULE$ = this;
        this.comparisonId = new AtomicLong();
        this.prefix = "\t";
    }
}

