/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.CostModelMonitor$;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerConfiguration$;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerKit;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Component;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.JoinDisconnectedQueryGraphComponents;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.PlannedComponent;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SingleComponentPlannerTrait;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.ir.ordering.ProvidedOrder;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipIndexSeek;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueIndexSeek;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipIndexSeek;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.exceptions.InternalException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class cartesianProductsOrValueJoins$
implements JoinDisconnectedQueryGraphComponents,
Product,
scala.Serializable {
    public static cartesianProductsOrValueJoins$ MODULE$;
    private final int COMPONENT_THRESHOLD_FOR_CARTESIAN_PRODUCT;

    static {
        new cartesianProductsOrValueJoins$();
    }

    public int COMPONENT_THRESHOLD_FOR_CARTESIAN_PRODUCT() {
        return this.COMPONENT_THRESHOLD_FOR_CARTESIAN_PRODUCT;
    }

    @Override
    public BestResults<LogicalPlan> connectComponentsAndSolveOptionalMatch(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Tuple2 tuple2 = this.recurse$1(plans, (Seq)qg.optionalMatches(), context, qg, interestingOrderConfig, kit, singleComponentPlanner);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set resultingPlans = (Set)tuple2._1();
        Seq optionalMatches = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resultingPlans, (Object)optionalMatches);
        Tuple2 tuple23 = tuple22;
        Set resultingPlans2 = (Set)tuple23._1();
        Seq optionalMatches2 = (Seq)tuple23._2();
        Predef$.MODULE$.require(resultingPlans2.size() == 1);
        Predef$.MODULE$.require(optionalMatches2.isEmpty());
        return ((PlannedComponent)resultingPlans2.head()).plan();
    }

    private Set<PlannedComponent> connectComponentsStep(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Set set;
        Predef$.MODULE$.require(plans.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Can't connect less than 2 components.");
        Map joins = this.produceHashJoins(plans, qg, context, kit).$plus$plus(this.produceNIJVariations(plans, qg, interestingOrderConfig, context, kit, singleComponentPlanner));
        Tuple2 tuple2 = joins.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$connectComponentsStep$2(context, interestingOrderConfig, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map joinsSatisfyingOrder = (Map)tuple2._1();
        Map joinsOther = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinsSatisfyingOrder, (Object)joinsOther);
        Tuple2 tuple23 = tuple22;
        Map joinsSatisfyingOrder2 = (Map)tuple23._1();
        Map joinsOther2 = (Map)tuple23._2();
        if (joinsSatisfyingOrder2.nonEmpty()) {
            set = this.pickTheBest(plans, kit, (Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>>)joinsSatisfyingOrder2);
        } else if (joinsOther2.nonEmpty()) {
            set = this.pickTheBest(plans, kit, (Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>>)joinsOther2);
        } else if (plans.size() < this.COMPONENT_THRESHOLD_FOR_CARTESIAN_PRODUCT()) {
            Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> cartesianProducts = this.produceCartesianProducts(plans, qg, context, kit);
            set = this.pickTheBest(plans, kit, cartesianProducts);
        } else {
            set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannedComponent[]{this.planLotsOfCartesianProducts(plans, qg, interestingOrderConfig, context, kit, true)}));
        }
        return set;
    }

    private Set<PlannedComponent> pickTheBest(Set<PlannedComponent> plans, QueryPlannerKit kit, Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> joins) {
        BestResults bestPlan = (BestResults)kit.pickBest().ofBestResults((Iterable)joins.map((Function1 & Serializable & scala.Serializable)x$3 -> ((PlannedComponent)x$3._1()).plan(), Iterable$.MODULE$.canBuildFrom()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "best join plan", (Function1<LogicalPlan, String>)(Function1 & Serializable & scala.Serializable)plan -> {
            QueryGraph solvedQg = (QueryGraph)joins.keys().collectFirst((PartialFunction)new scala.Serializable((LogicalPlan)plan){
                public static final long serialVersionUID = 0L;
                private final LogicalPlan plan$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends PlannedComponent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        QueryGraph queryGraph = A1.queryGraph();
                        BestResults<LogicalPlan> bestResults = A1.plan();
                        if (bestResults != null) {
                            LogicalPlan bestResult = bestResults.bestResult();
                            Option<LogicalPlan> bestResultFulfillingReq = bestResults.bestResultFulfillingReq();
                            LogicalPlan logicalPlan = bestResult;
                            LogicalPlan logicalPlan2 = this.plan$1;
                            if (!(logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2)) || bestResultFulfillingReq.contains((Object)this.plan$1)) {
                                object = queryGraph;
                                return (B1)object;
                            }
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(PlannedComponent x1) {
                    PlannedComponent plannedComponent = x1;
                    if (plannedComponent == null) return false;
                    BestResults<LogicalPlan> bestResults = plannedComponent.plan();
                    if (bestResults == null) return false;
                    LogicalPlan bestResult = bestResults.bestResult();
                    Option<LogicalPlan> bestResultFulfillingReq = bestResults.bestResultFulfillingReq();
                    LogicalPlan logicalPlan = bestResult;
                    LogicalPlan logicalPlan2 = this.plan$1;
                    if (logicalPlan == null) {
                        if (logicalPlan2 == null) return true;
                    } else if (logicalPlan.equals(logicalPlan2)) return true;
                    if (!bestResultFulfillingReq.contains((Object)this.plan$1)) return false;
                    return true;
                }
                {
                    this.plan$1 = plan$1;
                }
            }).get();
            return new StringBuilder(8).append("Solved: ").append(solvedQg).toString();
        }).get();
        QueryGraph bestQG = (QueryGraph)joins.collectFirst((PartialFunction)new scala.Serializable(bestPlan){
            public static final long serialVersionUID = 0L;
            private final BestResults bestPlan$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                PlannedComponent plannedComponent;
                A1 A1 = x2;
                if (A1 != null && (plannedComponent = (PlannedComponent)A1._1()) != null) {
                    QueryGraph fqg = plannedComponent.queryGraph();
                    BestResults<LogicalPlan> pl = plannedComponent.plan();
                    BestResults bestResults = this.bestPlan$1;
                    BestResults<LogicalPlan> bestResults2 = pl;
                    if (!(bestResults != null ? !((Object)bestResults).equals(bestResults2) : bestResults2 != null)) {
                        object = fqg;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> x2) {
                Tuple2<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> tuple2 = x2;
                if (tuple2 == null) return false;
                PlannedComponent plannedComponent = (PlannedComponent)tuple2._1();
                if (plannedComponent == null) return false;
                BestResults<LogicalPlan> pl = plannedComponent.plan();
                BestResults bestResults = this.bestPlan$1;
                BestResults<LogicalPlan> bestResults2 = pl;
                if (bestResults != null) {
                    if (!((Object)bestResults).equals(bestResults2)) return false;
                    return true;
                }
                if (bestResults2 == null) return true;
                return false;
            }
            {
                this.bestPlan$1 = bestPlan$1;
            }
        }).get();
        Tuple2 tuple2 = (Tuple2)joins.apply((Object)new PlannedComponent(bestQG, bestPlan));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PlannedComponent p1 = (PlannedComponent)tuple2._1();
        PlannedComponent p2 = (PlannedComponent)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
        Tuple2 tuple23 = tuple22;
        PlannedComponent p12 = (PlannedComponent)tuple23._1();
        PlannedComponent p22 = (PlannedComponent)tuple23._2();
        return (Set)plans.$minus((Object)p12).$minus((Object)p22).$plus((Object)new PlannedComponent(bestQG, bestPlan));
    }

    private Option<PlannedComponent> theSortedComponent(Set<PlannedComponent> components, QueryPlannerKit kit) {
        Set allSorted = (Set)components.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends PlannedComponent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<LogicalPlan> option;
                BestResults<LogicalPlan> bestResults;
                A1 A1 = x1;
                Object object = A1 != null && (bestResults = A1.plan()) != null && (option = bestResults.bestResultFulfillingReq()) instanceof Some ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(PlannedComponent x1) {
                Option<LogicalPlan> option;
                BestResults<LogicalPlan> bestResults;
                PlannedComponent plannedComponent = x1;
                boolean bl = plannedComponent != null && (bestResults = plannedComponent.plan()) != null && (option = bestResults.bestResultFulfillingReq()) instanceof Some;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        return kit.pickBest().apply((Function1 & Serializable & scala.Serializable)x$5 -> x$5.plan().result(), allSorted, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "best sorted component");
    }

    public PlannedComponent planLotsOfCartesianProducts(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, QueryPlannerKit kit, boolean considerSelections) {
        List list;
        Option<PlannedComponent> maybeSortedComponent = this.theSortedComponent(plans, kit);
        List components = (List)plans.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BestResults<LogicalPlan> bestResults;
            QueryGraph queryGraph;
            block3: {
                PlannedComponent plannedComponent;
                block2: {
                    plannedComponent = x0$1;
                    if (plannedComponent == null) break block2;
                    queryGraph = plannedComponent.queryGraph();
                    bestResults = plannedComponent.plan();
                    if (bestResults != null) break block3;
                }
                throw new MatchError((Object)plannedComponent);
            }
            LogicalPlan bestResult = bestResults.bestResult();
            Component component = new Component(queryGraph, bestResult);
            return component;
        }, List$.MODULE$.canBuildFrom());
        if (components.size() < 2) {
            list = components;
        } else {
            Cardinality maxCardinality = (Cardinality)((TraversableOnce)((TraversableLike)components.map((Function1 & Serializable & scala.Serializable)c -> (Cardinality)context.planningAttributes().cardinalities().apply(c.plan().id()), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.$greater$eq((Object)Cardinality$.MODULE$.SINGLE())))).product((Numeric)Cardinality.NumericCardinality$.MODULE$);
            Ordering<Tuple2<Cost, Cardinality>> ordering = context.executionModel().cartesianOrdering(maxCardinality);
            list = (Seq)((List)((SeqLike)components.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2(c, (Object)cartesianProductsOrValueJoins$.sortCriteria$1(c, context)), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$7 -> (Tuple2)x$7._2(), ordering)).map((Function1 & Serializable & scala.Serializable)x$8 -> (Component)x$8._1(), List$.MODULE$.canBuildFrom());
        }
        List bestComponents = list;
        Option componentsWithSortedPlanFirst = maybeSortedComponent.map(arg_0 -> cartesianProductsOrValueJoins$.$anonfun$planLotsOfCartesianProducts$7((Seq)bestComponents, arg_0));
        Component bestPlan = cartesianProductsOrValueJoins$.cross$1((Seq)bestComponents, context, considerSelections, kit, qg);
        Option candidate1 = componentsWithSortedPlanFirst.map((Function1 & Serializable & scala.Serializable)allPlans -> cartesianProductsOrValueJoins$.cross$1(allPlans, context, considerSelections, kit, qg)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.plan());
        Option<LogicalPlan> candidate2 = SortPlanner$.MODULE$.maybeSortedPlan(bestPlan.plan(), interestingOrderConfig, true, context, true);
        Option bestSortedPlan = kit.pickBest().apply((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{candidate1, candidate2})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("best sorted plan for ").append(plans.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.queryGraph(), Set$.MODULE$.canBuildFrom())).toString());
        return new PlannedComponent(bestPlan.queryGraph(), new BestResults<LogicalPlan>(bestPlan.plan(), bestSortedPlan));
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceCartesianProducts(Set<PlannedComponent> plans, QueryGraph qg, LogicalPlanningContext context, QueryPlannerKit kit) {
        return ((TraversableOnce)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            PlannedComponent plannedComponent = x$14;
            if (plannedComponent == null) {
                throw new MatchError((Object)plannedComponent);
            }
            QueryGraph qg1 = plannedComponent.queryGraph();
            BestResults<LogicalPlan> p1 = plannedComponent.plan();
            Set set = (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$3(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceCartesianProducts$4(p1, x$12))).map((Function1 & Serializable & scala.Serializable)x$13 -> {
                PlannedComponent plannedComponent = x$13;
                if (plannedComponent == null) {
                    throw new MatchError((Object)plannedComponent);
                }
                QueryGraph qg2 = plannedComponent.queryGraph();
                BestResults<LogicalPlan> p2 = plannedComponent.plan();
                LogicalPlan crossProduct = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planCartesianProduct((LogicalPlan)p1.bestResult(), p2.bestResult(), context), (Object)qg);
                Tuple2 tuple2 = new Tuple2((Object)new PlannedComponent(qg1.$plus$plus(qg2), new BestResults<LogicalPlan>(crossProduct, (Option<LogicalPlan>)None$.MODULE$)), (Object)new Tuple2((Object)plannedComponent, (Object)plannedComponent));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom());
            return set;
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceNIJVariations(Set<PlannedComponent> plans, QueryGraph qg, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Tuple2[] predicatesWithDependencies = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qg.selections().flatPredicates().toArray(ClassTag$.MODULE$.apply(Expression.class)))).map((Function1 & Serializable & scala.Serializable)pred -> new Tuple2(pred, ((TraversableOnce)pred.dependencies().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        PlannedComponent[] planArray = (PlannedComponent[])plans.toArray(ClassTag$.MODULE$.apply(PlannedComponent.class));
        Set[] allCoveredIds = (Set[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])planArray)).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.queryGraph().allCoveredIds(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class)));
        Builder result = Predef$.MODULE$.Map().newBuilder();
        IntRef a = IntRef.create((int)0);
        while (a.elem < planArray.length) {
            IntRef b = IntRef.create((int)(a.elem + 1));
            while (b.elem < planArray.length) {
                BestResults<LogicalPlan> planA = planArray[a.elem].plan();
                BestResults<LogicalPlan> planB = planArray[b.elem].plan();
                QueryGraph qgA = planArray[a.elem].queryGraph();
                QueryGraph qgB = planArray[b.elem].queryGraph();
                this.predicatesDependendingOnBothSides(predicatesWithDependencies, (Set<String>)allCoveredIds[a.elem], (Set<String>)allCoveredIds[b.elem]).foreach((Function1 & Serializable & scala.Serializable)predicate -> {
                    cartesianProductsOrValueJoins$.$anonfun$produceNIJVariations$4(planA, planB, qgA, qgB, qg, interestingOrderConfig, context, kit, singleComponentPlanner, result, planArray, a, b, predicate);
                    return BoxedUnit.UNIT;
                });
                ++b.elem;
            }
            ++a.elem;
        }
        return (Map)result.result();
    }

    private Map<PlannedComponent, Tuple2<PlannedComponent, PlannedComponent>> produceHashJoins(Set<PlannedComponent> plans, QueryGraph qg, LogicalPlanningContext context, QueryPlannerKit kit) {
        return ((TraversableOnce)((GenericTraversableTemplate)this.joinPredicateCandidates((Seq<Expression>)qg.selections().flatPredicates()).flatMap((Function1 & Serializable & scala.Serializable)join -> (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$2(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$3(join, x$17))).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
            PlannedComponent plannedComponent = x$20;
            if (plannedComponent == null) {
                throw new MatchError((Object)plannedComponent);
            }
            BestResults<LogicalPlan> planA = plannedComponent.plan();
            Set set = (Set)plans.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$5(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$produceHashJoins$6(join, planA, x$18))).map((Function1 & Serializable & scala.Serializable)x$19 -> {
                PlannedComponent plannedComponent = x$19;
                if (plannedComponent == null) {
                    throw new MatchError((Object)plannedComponent);
                }
                BestResults<LogicalPlan> planB = plannedComponent.plan();
                LogicalPlan hashJoinAB = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planValueHashJoin((LogicalPlan)planA.bestResult(), planB.bestResult(), (Equals)join, (Equals)join, context), (Object)qg);
                LogicalPlan hashJoinBA = (LogicalPlan)kit.select().apply((Object)context.logicalPlanProducer().planValueHashJoin(planB.bestResult(), (LogicalPlan)planA.bestResult(), join.switchSides(), (Equals)join, context), (Object)qg);
                Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(hashJoinAB.id())).asSinglePlannerQuery().lastQueryGraph(), new BestResults<LogicalPlan>(hashJoinAB, (Option<LogicalPlan>)None$.MODULE$)), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plannedComponent), (Object)plannedComponent)), new Tuple2((Object)new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(hashJoinBA.id())).asSinglePlannerQuery().lastQueryGraph(), new BestResults<LogicalPlan>(hashJoinBA, (Option<LogicalPlan>)None$.MODULE$)), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plannedComponent), (Object)plannedComponent))}));
                return set;
            }, Set$.MODULE$.canBuildFrom());
            return set;
        }, Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterator<PlannedComponent> planNIJIfApplicable(LogicalPlan lhsPlan, LogicalPlan rhsInputPlan, QueryGraph lhsQG, QueryGraph rhsQG, QueryGraph fullQG, InterestingOrderConfig interestingOrderConfig, Expression predicate, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        boolean notSingleComponent = rhsQG.connectedComponents().size() > 1;
        boolean containsOptionals = ((PlannerQueryPart)context.planningAttributes().solveds().get(rhsInputPlan.id())).asSinglePlannerQuery().lastQueryGraph().optionalMatches().nonEmpty();
        return notSingleComponent || containsOptionals ? package$.MODULE$.Iterator().empty() : this.planNIJ(lhsPlan, rhsInputPlan, lhsQG, rhsQG, interestingOrderConfig, predicate, context, kit, singleComponentPlanner).map((Function1 & Serializable & scala.Serializable)result -> {
            LogicalPlan resultWithSelection = (LogicalPlan)kit.select().apply(result, (Object)fullQG);
            return new PlannedComponent(((PlannerQueryPart)context.planningAttributes().solveds().get(resultWithSelection.id())).asSinglePlannerQuery().lastQueryGraph(), new BestResults<LogicalPlan>(resultWithSelection, (Option<LogicalPlan>)None$.MODULE$));
        });
    }

    public Iterator<LogicalPlan> planNIJ(LogicalPlan lhsPlan, LogicalPlan rhsInputPlan, QueryGraph lhsQG, QueryGraph rhsQG, InterestingOrderConfig interestingOrderConfig, Expression predicate, LogicalPlanningContext context, QueryPlannerKit kit, SingleComponentPlannerTrait singleComponentPlanner) {
        Iterator iterator;
        QueryGraph rhsQgWithLhsArguments = ((PlannerQueryPart)context.planningAttributes().solveds().get(rhsInputPlan.id())).asSinglePlannerQuery().lastQueryGraph().addArgumentIds((Seq)lhsQG.idsWithoutOptionalMatchesOrUpdates().toIndexedSeq()).addPredicates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{predicate})).addHints((GenTraversableOnce)rhsQG.hints());
        Set set = lhsQG.idsWithoutOptionalMatchesOrUpdates();
        Tuple2 tuple2 = ((TraversableLike)predicate.dependencies().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.name(), Set$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set leftSymbols = (Set)tuple2._1();
        Set rightSymbols = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftSymbols, (Object)rightSymbols);
        Tuple2 tuple23 = tuple22;
        Set leftSymbols2 = (Set)tuple23._1();
        Set rightSymbols2 = (Set)tuple23._2();
        Seq seq = rightSymbols2.toSeq();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            Some some2;
            String rightSymbol = (String)((SeqLike)some.get()).apply(0);
            LogicalPlanningContext contextForRhs = context.withUpdatedLabelInfo(lhsPlan);
            LogicalPlanningContext contextForRhsLeaves = contextForRhs.withConfig(context.config().withLeafPlanners(QueryPlannerConfiguration$.MODULE$.leafPlannersForNestedIndexJoins(new LeafPlanRestrictions.OnlyIndexSeekPlansFor(rightSymbol, (Set<String>)leftSymbols2))));
            QueryGraph x$1 = rhsQgWithLhsArguments;
            InterestingOrderConfig x$2 = interestingOrderConfig;
            LogicalPlanningContext x$3 = contextForRhsLeaves;
            Function2<LogicalPlan, QueryGraph, LogicalPlan> x$4 = contextForRhsLeaves.config().leafPlanners().candidates$default$2();
            Set<LogicalPlan> leafPlanCandidates = contextForRhsLeaves.config().leafPlanners().candidates(x$1, x$4, x$2, x$3);
            try {
                some2 = new Some(singleComponentPlanner.planComponent(leafPlanCandidates, rhsQgWithLhsArguments, contextForRhs, kit, interestingOrderConfig));
            }
            catch (InternalException internalException) {
                some2 = None$.MODULE$;
            }
            Some rhsPlans = some2;
            iterator = (Iterator)rhsPlans.fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().empty(), (Function1 & Serializable & scala.Serializable)x$23 -> x$23.allResults().iterator().collect((PartialFunction)new scala.Serializable(context, lhsPlan){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$8;
                private final LogicalPlan lhsPlan$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = cartesianProductsOrValueJoins$.MODULE$.containsDependentIndexSeeks(A1) ? this.context$8.logicalPlanProducer().planApply(this.lhsPlan$1, A1, this.context$8) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = cartesianProductsOrValueJoins$.MODULE$.containsDependentIndexSeeks(logicalPlan);
                    return bl;
                }
                {
                    this.context$8 = context$8;
                    this.lhsPlan$1 = lhsPlan$1;
                }
            }));
        } else {
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    public boolean containsDependentIndexSeeks(LogicalPlan plan) {
        return plan.leaves().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$containsDependentIndexSeeks$1(x0$1)));
    }

    public Set<Equals> joinPredicateCandidates(Seq<Expression> flatPredicates) {
        return ((TraversableOnce)flatPredicates.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Equals) {
                    Equals equals = (Equals)A1;
                    Expression l = equals.lhs();
                    Expression r = equals.rhs();
                    if (l.dependencies().nonEmpty() && r.dependencies().nonEmpty()) {
                        Set set = r.dependencies();
                        Set set2 = l.dependencies();
                        if (set == null ? set2 != null : !set.equals(set2)) {
                            object = equals;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (!(expression instanceof Equals)) return false;
                Equals equals = (Equals)expression;
                Expression l = equals.lhs();
                Expression r = equals.rhs();
                if (!l.dependencies().nonEmpty()) return false;
                if (!r.dependencies().nonEmpty()) return false;
                Set set = r.dependencies();
                Set set2 = l.dependencies();
                if (set == null) {
                    if (set2 == null) return false;
                    return true;
                } else if (set.equals(set2)) return false;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public Seq<Expression> predicatesDependendingOnBothSides(Tuple2<Expression, String[]>[] predicateDependencies, Set<String> idsFromLeft, Set<String> idsFromRight) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateDependencies)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$predicatesDependendingOnBothSides$1(idsFromLeft, idsFromRight, x0$1))))).map((Function1 & Serializable & scala.Serializable)x$28 -> (Expression)x$28._1(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String productPrefix() {
        return "cartesianProductsOrValueJoins";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof cartesianProductsOrValueJoins$;
    }

    public int hashCode() {
        return 1781857095;
    }

    public String toString() {
        return "cartesianProductsOrValueJoins";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$connectComponentsAndSolveOptionalMatch$1(QueryGraph firstOptionalMatch$1, PlannedComponent p) {
        return firstOptionalMatch$1.argumentIds().subsetOf((GenSet)p.plan().bestResult().availableSymbols());
    }

    private final Tuple2 recurse$1(Set plans, Seq optionalMatches, LogicalPlanningContext context$1, QueryGraph qg$1, InterestingOrderConfig interestingOrderConfig$1, QueryPlannerKit kit$1, SingleComponentPlannerTrait singleComponentPlanner$1) {
        while (true) {
            if (optionalMatches.nonEmpty()) {
                Some some;
                PlannedComponent t;
                QueryGraph firstOptionalMatch = (QueryGraph)optionalMatches.head();
                Option applicablePlan = plans.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$connectComponentsAndSolveOptionalMatch$1(firstOptionalMatch, p)));
                Option option = applicablePlan;
                if (option instanceof Some && (t = (PlannedComponent)(some = (Some)option).value()) != null) {
                    QueryGraph solvedQg = t.queryGraph();
                    BestResults<LogicalPlan> p2 = t.plan();
                    Seq candidates = (Seq)context$1.config().optionalSolvers().flatMap((Function1 & Serializable & scala.Serializable)getSolver -> getSolver.solver(firstOptionalMatch, qg$1, interestingOrderConfig$1, context$1).connect((LogicalPlan)p2.bestResult()), Seq$.MODULE$.canBuildFrom());
                    LogicalPlan best = (LogicalPlan)kit$1.pickBest().apply(candidates, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("best plan solving optional match: ").append(firstOptionalMatch).toString()).get();
                    optionalMatches = (Seq)optionalMatches.tail();
                    plans = (Set)plans.$minus((Object)t).$plus((Object)new PlannedComponent(solvedQg, new BestResults<LogicalPlan>(best, (Option<LogicalPlan>)None$.MODULE$)));
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    plans = this.connectComponentsStep(plans, qg$1, interestingOrderConfig$1, context$1, kit$1, singleComponentPlanner$1);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            if (plans.size() <= 1) break;
            plans = this.connectComponentsStep((Set<PlannedComponent>)plans, qg$1, interestingOrderConfig$1, context$1, kit$1, singleComponentPlanner$1);
        }
        return new Tuple2((Object)plans, (Object)optionalMatches);
    }

    public static final /* synthetic */ boolean $anonfun$connectComponentsStep$2(LogicalPlanningContext context$2, InterestingOrderConfig interestingOrderConfig$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PlannedComponent comp = (PlannedComponent)tuple2._1();
        Predef$.MODULE$.require(comp.plan().bestResultFulfillingReq().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Expected only bestResult for component ").append(comp).toString());
        LogicalPlan plan = comp.plan().bestResult();
        SortPlanner.SatisfiedForPlan asSortedAsPossible = new SortPlanner.SatisfiedForPlan(plan);
        ProvidedOrder providedOrder = (ProvidedOrder)context$2.planningAttributes().providedOrders().apply(plan.id());
        InterestingOrder.Satisfaction satisfaction = interestingOrderConfig$2.orderToSolve().satisfiedBy(providedOrder);
        boolean bl = asSortedAsPossible.unapply(satisfaction);
        boolean bl2 = bl;
        return bl2;
    }

    private static final Tuple2 sortCriteria$1(Component c, LogicalPlanningContext context$3) {
        Cardinality cardinality = (Cardinality)context$3.planningAttributes().cardinalities().apply(c.plan().id());
        Cost cost = context$3.cost().costFor(c.plan(), context$3.input(), context$3.semanticTable(), context$3.planningAttributes().cardinalities(), context$3.planningAttributes().providedOrders(), CostModelMonitor$.MODULE$.DEFAULT());
        return new Tuple2((Object)cost, (Object)cardinality);
    }

    public static final /* synthetic */ boolean $anonfun$planLotsOfCartesianProducts$8(Component c$1, Component comp) {
        QueryGraph queryGraph = c$1.queryGraph();
        QueryGraph queryGraph2 = comp.queryGraph();
        return !(queryGraph != null ? !queryGraph.equals(queryGraph2) : queryGraph2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$planLotsOfCartesianProducts$7(Seq bestComponents$1, PlannedComponent sortedComponent) {
        Component c;
        Component component = c = new Component(sortedComponent.queryGraph(), (LogicalPlan)sortedComponent.plan().bestResultFulfillingReq().get());
        return (Seq)((SeqLike)bestComponents$1.filterNot((Function1 & Serializable & scala.Serializable)comp -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$planLotsOfCartesianProducts$8(c, comp)))).$plus$colon((Object)component, Seq$.MODULE$.canBuildFrom());
    }

    private static final Component cross$1(Seq allPlans, LogicalPlanningContext context$3, boolean considerSelections$1, QueryPlannerKit kit$2, QueryGraph qg$2) {
        return (Component)allPlans.reduceRight((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Component l = (Component)tuple2._1();
            Component r = (Component)tuple2._2();
            LogicalPlan cp = context$3.logicalPlanProducer().planCartesianProduct(l.plan(), r.plan(), context$3);
            LogicalPlan cpWithSelection = considerSelections$1 ? (LogicalPlan)kit$2.select().apply((Object)cp, (Object)qg$2) : cp;
            Component component = new Component(l.queryGraph().$plus$plus(r.queryGraph()), cpWithSelection);
            return component;
        });
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$1(PlannedComponent check$ifrefutable$1) {
        PlannedComponent plannedComponent = check$ifrefutable$1;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$3(PlannedComponent check$ifrefutable$2) {
        PlannedComponent plannedComponent = check$ifrefutable$2;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceCartesianProducts$4(BestResults p1$1, PlannedComponent x$12) {
        PlannedComponent plannedComponent = x$12;
        if (plannedComponent == null) {
            throw new MatchError((Object)plannedComponent);
        }
        BestResults<LogicalPlan> p2 = plannedComponent.plan();
        BestResults bestResults = p1$1;
        BestResults<LogicalPlan> bestResults2 = p2;
        boolean bl = bestResults == null ? bestResults2 != null : !((Object)bestResults).equals(bestResults2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$produceNIJVariations$4(BestResults planA$1, BestResults planB$1, QueryGraph qgA$1, QueryGraph qgB$1, QueryGraph qg$4, InterestingOrderConfig interestingOrderConfig$3, LogicalPlanningContext context$5, QueryPlannerKit kit$4, SingleComponentPlannerTrait singleComponentPlanner$2, Builder result$1, PlannedComponent[] planArray$1, IntRef a$1, IntRef b$1, Expression predicate) {
        Iterator<PlannedComponent> nestedIndexJoinAB = MODULE$.planNIJIfApplicable((LogicalPlan)planA$1.bestResult(), (LogicalPlan)planB$1.bestResult(), qgA$1, qgB$1, qg$4, interestingOrderConfig$3, predicate, context$5, kit$4, singleComponentPlanner$2);
        Iterator<PlannedComponent> nestedIndexJoinBA = MODULE$.planNIJIfApplicable((LogicalPlan)planB$1.bestResult(), (LogicalPlan)planA$1.bestResult(), qgB$1, qgA$1, qg$4, interestingOrderConfig$3, predicate, context$5, kit$4, singleComponentPlanner$2);
        nestedIndexJoinAB.foreach((Function1 & Serializable & scala.Serializable)x -> result$1.$plus$eq((Object)new Tuple2(x, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)planArray$1[a$1.elem]), (Object)planArray$1[b$1.elem]))));
        nestedIndexJoinBA.foreach((Function1 & Serializable & scala.Serializable)x -> result$1.$plus$eq((Object)new Tuple2(x, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)planArray$1[a$1.elem]), (Object)planArray$1[b$1.elem]))));
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$2(PlannedComponent check$ifrefutable$3) {
        PlannedComponent plannedComponent = check$ifrefutable$3;
        boolean bl = plannedComponent != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$3(Equals join$1, PlannedComponent x$17) {
        PlannedComponent plannedComponent = x$17;
        if (plannedComponent == null) {
            throw new MatchError((Object)plannedComponent);
        }
        BestResults<LogicalPlan> planA = plannedComponent.plan();
        boolean bl = planA.bestResult().satisfiesExpressionDependencies(join$1.lhs()) && !planA.bestResult().satisfiesExpressionDependencies(join$1.rhs());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceHashJoins$5(PlannedComponent check$ifrefutable$4) {
        PlannedComponent plannedComponent = check$ifrefutable$4;
        boolean bl = plannedComponent != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$produceHashJoins$6(Equals join$1, BestResults planA$2, PlannedComponent x$18) {
        PlannedComponent plannedComponent = x$18;
        if (plannedComponent == null) throw new MatchError((Object)plannedComponent);
        BestResults<LogicalPlan> planB = plannedComponent.plan();
        if (!planB.bestResult().satisfiesExpressionDependencies(join$1.rhs())) return false;
        if (planB.bestResult().satisfiesExpressionDependencies(join$1.lhs())) return false;
        BestResults bestResults = planA$2;
        BestResults<LogicalPlan> bestResults2 = planB;
        if (bestResults == null) {
            if (bestResults2 == null) return false;
            return true;
        } else if (((Object)bestResults).equals(bestResults2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentIndexSeeks$2(Expression x$24) {
        return x$24.dependencies().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentIndexSeeks$3(Expression x$25) {
        return x$25.dependencies().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentIndexSeeks$4(Expression x$26) {
        return x$26.dependencies().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentIndexSeeks$5(Expression x$27) {
        return x$27.dependencies().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentIndexSeeks$1(LogicalPlan x0$1) {
        boolean bl;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof NodeIndexSeek) {
            NodeIndexSeek nodeIndexSeek = (NodeIndexSeek)logicalPlan;
            QueryExpression valueExpr = nodeIndexSeek.valueExpr();
            bl = valueExpr.expressions().exists((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$containsDependentIndexSeeks$2(x$24)));
        } else if (logicalPlan instanceof NodeUniqueIndexSeek) {
            NodeUniqueIndexSeek nodeUniqueIndexSeek = (NodeUniqueIndexSeek)logicalPlan;
            QueryExpression valueExpr = nodeUniqueIndexSeek.valueExpr();
            bl = valueExpr.expressions().exists((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$containsDependentIndexSeeks$3(x$25)));
        } else if (logicalPlan instanceof DirectedRelationshipIndexSeek) {
            DirectedRelationshipIndexSeek directedRelationshipIndexSeek = (DirectedRelationshipIndexSeek)logicalPlan;
            QueryExpression valueExpr = directedRelationshipIndexSeek.valueExpr();
            bl = valueExpr.expressions().exists((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$containsDependentIndexSeeks$4(x$26)));
        } else if (logicalPlan instanceof UndirectedRelationshipIndexSeek) {
            UndirectedRelationshipIndexSeek undirectedRelationshipIndexSeek = (UndirectedRelationshipIndexSeek)logicalPlan;
            QueryExpression valueExpr = undirectedRelationshipIndexSeek.valueExpr();
            bl = valueExpr.expressions().exists((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)cartesianProductsOrValueJoins$.$anonfun$containsDependentIndexSeeks$5(x$27)));
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$predicatesDependendingOnBothSides$1(Set idsFromLeft$1, Set idsFromRight$1, Tuple2 x0$1) {
        boolean forAllLhsOrRhs;
        boolean unfulfilledRhsDep;
        boolean unfulfilledLhsDep;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String[] deps = (String[])tuple2._2();
            unfulfilledLhsDep = false;
            unfulfilledRhsDep = false;
            forAllLhsOrRhs = true;
            for (int i = 0; i < deps.length; ++i) {
                boolean inLhs = idsFromLeft$1.apply((Object)deps[i]);
                boolean inRhs = idsFromRight$1.apply((Object)deps[i]);
                unfulfilledLhsDep = unfulfilledLhsDep || !inLhs;
                unfulfilledRhsDep = unfulfilledRhsDep || !inRhs;
                forAllLhsOrRhs = forAllLhsOrRhs && (inLhs || inRhs);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = unfulfilledLhsDep && unfulfilledRhsDep && forAllLhsOrRhs;
        return bl;
    }

    private cartesianProductsOrValueJoins$() {
        MODULE$ = this;
        Product.$init$((Product)this);
        this.COMPONENT_THRESHOLD_FOR_CARTESIAN_PRODUCT = 8;
    }
}

